/*
 * Stack code for generic stacks.
 * Copyright (C) 1999  Steven Brown
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Steven Brown <swbrown@ucsd.edu>
 *
 * $Id: stacklist.c,v 1.2 1999/05/19 08:22:16 kefka Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include "stacklist.h"
#include "error.h"

/* Initialize a stacklist. */
void stacklist_init(Stacklist *stacklist) {
	stacklist->first=NULL;
	stacklist->entries=0;
}

/* Remove an entry from the stacklist. */
void stacklist_remove(Stacklist *stacklist, Stacklist_Entry *stacklist_entry) {
	Stacklist_Entry **last=&stacklist->first;
	Stacklist_Entry *next;
	
	/* Loop through all entries. */
	for(next=stacklist->first; next != NULL; next=next->previous) {
		
		/* Is this us? */
		if(next == stacklist_entry) {
			
			/* Unlink this one. */
			*last=next->previous;
			
			/* Free it. */
			free(next);
			
			/* All done. */
			break;
		}
		
		/* Set our last link to this guy. */
		last=&next->previous;
	}
	
	/* We better have found it. */
	if(next == NULL) panic("Wacky stacklist remove if I do say so myself and I do.\n");
	
	/* We have one less entry. */
	stacklist->entries=stacklist->entries-1;
	
	return;
}

/* Insert an entry in the stacklist. */
void stacklist_insert(Stacklist *stacklist, void *info) {
	Stacklist_Entry *stacklist_entry;
	
	/* Create a new entry. */
	stacklist_entry=malloc(sizeof(Stacklist_Entry));
	if(!stacklist_entry) fatal("Out of memory.");
	
	/* Insert the info. */
	stacklist_entry->info=info;
	
	/* Add it to the stacklist. */
	stacklist_entry->previous=stacklist->first;
	stacklist->first=stacklist_entry;
	stacklist->entries++;

	return;
}

/* Free a stacklist. */
void stacklist_free(Stacklist *stacklist) {
	Stacklist_Entry *stacklist_entry;
	Stacklist_Entry *previous;
	
	/* Loop through freeing each entry. */
	for(stacklist_entry=stacklist->first; stacklist_entry != NULL; stacklist_entry=previous) {
		
		/* Save the previous link. */
		previous=stacklist_entry->previous;
		
		/* Free the entry. */
		free(stacklist_entry);
	}
	
	return;		
}
