/*
 * Flex lexer for the configuration file.
 * Copyright (C) 1999  Steven Brown
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Steven Brown <swbrown@ucsd.edu>
 *
 * $Id: conf-lex.l,v 1.9 1999/09/19 18:43:46 kefka Exp $
 */

%option noyywrap
%option yylineno

%{
#include <string.h>
#include "stacklist.h"
#include "conf.h"
#include "conf-parse.h"
#include "error.h"
%}

%%

MACRO                      return(MACRO);
HMACRO                     return(HMACRO);
COMMAND                    return(COMMAND);
DEVICE                     return(DEVICE);
ALIAS                      return(ALIAS);
TTY                        return(TTY);
DAEMON_SOCKET              return(DAEMON_SOCKET);
DAEMON_MONITOR_SOCKET      return(DAEMON_MONITOR_SOCKET);
RUN                        return(RUN);
HOUSECODE                  return(HOUSECODE);
DAEMON_DIR                 return(DAEMON_DIR);
DAEMON_COMMAND_TIMEOUT     return(DAEMON_COMMAND_TIMEOUT);
IF                         return(IF);
ELSE                       return(ELSE);

ON             return(ON);
OFF            return(OFF);
DIM            return(DIM);
BRIGHT         return(BRIGHT);
ALL_LIGHTS_ON  return(ALL_LIGHTS_ON);
ALL_UNITS_OFF  return(ALL_UNITS_OFF);

LAMP               return(LAMP);
APPLIANCE          return(APPLIANCE);
MOTION_DETECTOR    return(MOTION_DETECTOR);
SIGNAL             return(SIGNAL);
TRANSCEIVER        return(TRANSCEIVER);

EXAMPLE     return(EXAMPLE);

0[0-9]* {
	yylval.integer=strtol(yytext, NULL, 8);
	return(INTEGER);
}
0x[0-9a-fA-F]+ {
	yylval.integer=strtol(yytext, NULL, 16);
	return(INTEGER);
}
[1-9][0-9]* {
	yylval.integer=strtol(yytext, NULL, 10); 
	return(INTEGER);
}

[a-zA-Z_][a-zA-Z_0-9]* {
	yylval.string=strdup(yytext);
	if(!yylval.string) {
		fatal("Out of memory.");
	}
	return(IDENTIFIER);
}

\"[^\"]*\" {
	
	/* We only copy what's inside of the string. */
	yytext[strlen(yytext)-1]=0;
	yylval.string=strdup(yytext+1);
	if(!yylval.string) {
		fatal("Out of memory.");
	}
	return(STRING);
}

"#".*"\n" {
	
	/* Hash comments. */
	break;
}
"/*" {
	int c;
	
	/* C comment skipper, taken from the flex man page. */
	for(;;) {
		
		/* eat up text of comment */
		while((c = input()) != '*' && c != EOF);
		
		if (c == '*') {
			while((c = input()) == '*');
			if(c == '/') {
				/* found the end */
				break;    
			}
		}
		
		if (c == EOF) {
			error("EOF in comment");
			break;
		}
	}
}

":" {
	return(COLON);
}
"{" {
	return(BRACE_LEFT);
}
"}" {
	return(BRACE_RIGHT);
}
"(" {
	return(PAREN_LEFT);
}
")" {
	return(PAREN_RIGHT);
}
"," {
	return(COMMA);
}
";" {
	return(SEMI);
}

[ \t\r\f]* {
	break;
}
"\n" {
	break;
}
. {
	return(yytext[0]);
}
