//
// SystemConfigurationTest.cpp
//
// $Id: //poco/1.4/Util/testsuite/src/SystemConfigurationTest.cpp#2 $
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "SystemConfigurationTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/Util/SystemConfiguration.h"
#include "Poco/AutoPtr.h"
#include "Poco/Exception.h"
#include "Poco/Environment.h"
#include "Poco/Path.h"
#if !defined(POCO_VXWORKS)
#include "Poco/Process.h"
#endif
#include "Poco/NumberParser.h"
#include <algorithm>


using Poco::Util::SystemConfiguration;
using Poco::Util::AbstractConfiguration;
using Poco::AutoPtr;
using Poco::Environment;
using Poco::Path;
using Poco::InvalidAccessException;
using Poco::NotFoundException;


SystemConfigurationTest::SystemConfigurationTest(const std::string& name): CppUnit::TestCase(name)
{
}


SystemConfigurationTest::~SystemConfigurationTest()
{
}


void SystemConfigurationTest::testProperties()
{
	AutoPtr<SystemConfiguration> pConf = new SystemConfiguration;
	
	assert (pConf->getString("system.osName") == Environment::osName());
	assert (pConf->getString("system.osVersion") == Environment::osVersion());
	assert (pConf->getString("system.osArchitecture") == Environment::osArchitecture());
	assert (pConf->getString("system.nodeName") == Environment::nodeName());
	assert (pConf->getString("system.currentDir") == Path::current());
	assert (pConf->getString("system.homeDir") == Path::home());
	assert (pConf->getString("system.tempDir") == Path::temp());
	
	std::string dateTime = pConf->getString("system.dateTime");
	assert (dateTime.size() == 20);
	
#if !defined(POCO_VXWORKS)
	std::string pid = pConf->getString("system.pid");
	assert (Poco::NumberParser::parse64(pid) == Poco::Process::id());
#endif
	
#if defined(POCO_OS_FAMILY_WINDOWS)
	std::string home = pConf->getString("system.env.HOMEPATH");
#else
	std::string home = pConf->getString("system.env.HOME");
#endif
	assert (!home.empty());
}


void SystemConfigurationTest::testKeys()
{
	AutoPtr<SystemConfiguration> pConf = new SystemConfiguration;

	AbstractConfiguration::Keys keys;
	pConf->keys(keys);
	assert (keys.size() == 1);
	assert (std::find(keys.begin(), keys.end(), "system") != keys.end());

	pConf->keys("system", keys);
#if defined(POCO_VXWORKS)
	assert (keys.size() == 10);
#else
	assert (keys.size() == 11);
#endif
	assert (std::find(keys.begin(), keys.end(), "osName") != keys.end());
	assert (std::find(keys.begin(), keys.end(), "osVersion") != keys.end());
	assert (std::find(keys.begin(), keys.end(), "osArchitecture") != keys.end());
	assert (std::find(keys.begin(), keys.end(), "nodeName") != keys.end());
	assert (std::find(keys.begin(), keys.end(), "nodeId") != keys.end());
	assert (std::find(keys.begin(), keys.end(), "currentDir") != keys.end());
	assert (std::find(keys.begin(), keys.end(), "homeDir") != keys.end());
	assert (std::find(keys.begin(), keys.end(), "tempDir") != keys.end());
	assert (std::find(keys.begin(), keys.end(), "dateTime") != keys.end());
#if !defined(POCO_VXWORKS)
	assert (std::find(keys.begin(), keys.end(), "pid") != keys.end());
#endif
	assert (std::find(keys.begin(), keys.end(), "env") != keys.end());
}


void SystemConfigurationTest::setUp()
{
}


void SystemConfigurationTest::tearDown()
{
}


CppUnit::Test* SystemConfigurationTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("SystemConfigurationTest");

	CppUnit_addTest(pSuite, SystemConfigurationTest, testProperties);
	CppUnit_addTest(pSuite, SystemConfigurationTest, testKeys);

	return pSuite;
}
