/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.forms;

import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;

public class HomozRuns
extends Form {
    private static Logger logger = Logger.getLogger(HomozRuns.class);
    public static String name = "Runs of homozygosity";
    private JRadioButton homSNPButton;
    private JRadioButton homKBButton;
    private JCheckBox homGroupButton;
    private JCheckBox homMatchButton;
    private JCheckBox homHetButton;
    private JCheckBox homVerboseButton;
    private JTextField homSNPText;
    private JTextField homKBText;
    private JTextField homMatchText;
    private JTextField homHetText;

    public HomozRuns(GPLINK mf) {
        super(mf, name);
        this.pack();
        this.setVisible(true);
    }

    protected JPanel createBody() {
        JPanel body = new JPanel();
        this.homSNPText = new JTextField(4);
        this.homSNPText.getDocument().addDocumentListener(this.validateBodyDL);
        this.homKBText = new JTextField(4);
        this.homKBText.getDocument().addDocumentListener(this.validateBodyDL);
        this.homHetText = new JTextField(4);
        this.homHetText.getDocument().addDocumentListener(this.validateBodyDL);
        this.homMatchText = new JTextField(4);
        this.homMatchText.getDocument().addDocumentListener(this.validateBodyDL);
        this.homSNPButton = new JRadioButton("Homozygous run length, SNPs (--homozyg-snp)");
        this.homSNPButton.addActionListener(this.validateBodyAL);
        HomozRuns.bundel((JToggleButton)this.homSNPButton, this.homSNPText);
        this.homKBButton = new JRadioButton("Homozygous run length, kb (--homozyg-kb)");
        this.homKBButton.addActionListener(this.validateBodyAL);
        HomozRuns.bundel((JToggleButton)this.homKBButton, this.homKBText);
        this.homHetButton = new JCheckBox("Heterozygotes allowed in homozygous run (--homozyg-het)");
        this.homHetButton.addActionListener(this.validateBodyAL);
        HomozRuns.bundel((JToggleButton)this.homHetButton, this.homHetText);
        this.homGroupButton = new JCheckBox("Group overlapping segments (--homozyg-group)");
        this.homGroupButton.addActionListener(this.validateBodyAL);
        this.homMatchButton = new JCheckBox("Threshold for allelic match (--homozyg-match)");
        this.homMatchButton.addActionListener(this.validateBodyAL);
        HomozRuns.bundel((JToggleButton)this.homMatchButton, this.homMatchText);
        this.homVerboseButton = new JCheckBox("Verbose segment listing (--homozyg-verbose)");
        this.homVerboseButton.addActionListener(this.validateBodyAL);
        body.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        body.add((Component)this.homKBButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        body.add((Component)this.homKBText, c);
        c.weightx = 0.0;
        c.gridy = 1;
        c.gridx = 0;
        body.add((Component)this.homSNPButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        body.add((Component)this.homSNPText, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        body.add((Component)new JSeparator(0), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridy = 3;
        c.gridx = 0;
        body.add((Component)this.homHetButton, c);
        c.gridx = 1;
        body.add((Component)this.homHetText, c);
        c.gridy = 4;
        c.gridx = 0;
        body.add((Component)this.homGroupButton, c);
        c.gridy = 5;
        body.add((Component)this.homMatchButton, c);
        c.gridx = 1;
        body.add((Component)this.homMatchText, c);
        c.gridy = 6;
        c.gridx = 0;
        body.add((Component)this.homVerboseButton, c);
        this.validBody = true;
        return body;
    }

    protected String processBody() {
        String ans = " --homozyg";
        if (this.homVerboseButton.isSelected()) {
            ans = " --homozyg-verbose";
        }
        if (this.homKBButton.isSelected()) {
            ans = String.valueOf(ans) + " --homozyg-kb " + this.homKBText.getText();
        }
        if (this.homSNPButton.isSelected()) {
            ans = String.valueOf(ans) + " --homozyg-snp " + this.homSNPText.getText();
        }
        if (this.homHetButton.isSelected()) {
            ans = String.valueOf(ans) + " --homozyg-het " + this.homHetText.getText();
        }
        if (this.homGroupButton.isSelected()) {
            ans = String.valueOf(ans) + " --homozyg-group";
        }
        if (this.homMatchButton.isSelected()) {
            ans = String.valueOf(ans) + " --homozyg-match " + this.homMatchText.getText();
        }
        ans = ans.replaceFirst(" ", "");
        return ans;
    }

    protected void isBodyValid() {
        logger.info("[isBodyValid()] Entering...");
        this.validBody = this.homKBButton.isSelected() && !this.homKBText.getText().matches("\\d+") ? false : (this.homSNPButton.isSelected() && !this.homSNPText.getText().matches("\\d+") ? false : (this.homHetButton.isSelected() && !this.homHetText.getText().matches("\\d+") ? false : !this.homMatchButton.isSelected() || this.homMatchText.getText().matches("\\d*\\.?\\d+")));
        this.okForm();
        logger.info("[isBodyValid()] Exiting...");
    }
}

