/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2;

import edu.harvard.mgh.purcell.gCLINE.PopUpMenu;
import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.AutoUpdater;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gCLINE.pane.FileView;
import edu.harvard.mgh.purcell.gCLINE.pane.FolderView;
import edu.harvard.mgh.purcell.gCLINE.pane.OpView;
import edu.harvard.mgh.purcell.gPLINK2.OpenHapDialog;
import edu.harvard.mgh.purcell.gPLINK2.PLINK_Execute;
import edu.harvard.mgh.purcell.gPLINK2.PlinkMenuBar;
import edu.harvard.mgh.purcell.gPLINK2.data.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class GPLINK
extends StartFrame {
    public static String versionHistory;
    private static Logger logger;
    public Project data;
    PlinkMenuBar menu;
    WindowListener properClosing = new WindowListener(){

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            logger.info("GPLINK is closing (2)");
            if (GPLINK.this.data != null) {
                GPLINK.this.data.properClosing();
            }
            System.exit(0);
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    };

    static {
        logger = Logger.getLogger(GPLINK.class);
    }

    protected void setVersion() {
        this.version = "2.050";
        versionHistory = "2.050 BUGFIX sort by fileroots in the forms \n2.049 FEATURE UPDATE polished up the proxy assoc form \n2.048 BUGFIX & FEATURE UPDATE 1)add first pass drag and drop from folder list to operations 2) prevent inclusion of numbers as file names 3) updated forms fixed link file to operation 4) changed how the opTree is updated \n2.047 FEATURE UPDATE add conditional haplotype form - 01.07.08 \n2.046 BUGFIX catch trivial roots in log files (ie [.log] and [.gplink] are not valid files to construct an operation from) - 01.04.08 \n2.045 FEATURE UPDATE add proxy association form and commenting - 1.3.08 \n2.044 BUGFIX if one autherization fails for some reason then go to the second. \n2.043 BUGFIX alternative editor now looks localy all the time - 11.16.07 \n2.042 FEATURE UPDATE auto updater is set to default 5 seconds in local mode and 30 seconds in remote mode. These are now to different config parameters -11.16.07 \n2.041 FEATURE UPDATE remove browse option from menu option and the default to not browse, browse is only activated when user chooses not to steal the lock for a project -11.16.07 \n2.040 FEATURE UPDATE add text to alternative pheno panel, add \"Advance\" menu, add ok button check for threshold settings -11.15.07 \n2.039 BUGFIX remote time stamps imported correctly with operation -11.08.07 \n2.038 BUGFIX fixed optree rendering issue when rescan timing changed in config dialog -11.02.07 \n2.037 formating fixes -11.02.07 \n2.036 icon's auto refresh when an op completes -11.02.07 \n2.035 fixed popup trigger -11.01.07 \n2.034 format forms -10.30.07 \n2.033 do not ad the exit status file to the optree -10.30.07 \n2.032 import plink operations from remote directory correctly -10.30.07 \n2.031 reactive buttons on form when filter/threshold closed via x -10.30.07 \n2.030 fix bug with remote config file not being there 2)error dialog always on top 3)fixed lable/parent of plink_exe dialog -10.30.07 \n2.029 quote output file name appropreately -10.30.07 \n2.028 cetch nulls in file transfure to disconnect cleanly. 2.027 freeze remote flag on opening until a local file is selected -10.30.07 \n2.026 fixed null pointer error trying to close a remote connection without a connection \n2.025 more fun with the drop down list in the import dialog. -10.17.07 \n2.024 autoUpdater waits for files to download now -10.17.07 \n2.023 fix homozygosity form -10.16.07 \n2.022 fixed null pointer in relationship heirarchy dialog -10.15.07 \n2.021 fix error message popup that happened when there was no metafile in the remote directory to download -10.04.07 \n2.020 import bug fix \n2.019 import drop down is now works - 10.03.07 \n2.018 import no longer assumes that an operation is completed sucessfully and checks the log file to see what the .gplink file should be set to. \n2.017 1)merge form fixed 2) null pointer caught in opTree pop-up menu - 10.03.07 \n2.016 back button in remote file browser now only steps back one directory at a time - 10.03.07 \n2.015 major bug fix for remote mode including 1) full file names in command line 2) upload/download lock/metafile fix - 10.01.07 \n2.014 added form - 9.28.07 \n2.013 never adds --gplink if it's already in the command line-9.26.07 \n2.012 bug fix adding alternative phenotype - 9.26.07 \n2.011 bug fix selecting remote file names - 9.26.07 \n2.010 fix import so that it quotes filenames - 09.19.07 \n2.009 fixed null pointer exception for short binary inport in forms (when it was empty) - 09.19.07 \n2.008 file lists now go through a bubble sort to make sure they are lists alphabetically \n2.007 fixed loading error \n2.006 can now launch Haploview \nfrom gPLINK - 08.06.07 \n2.005 add restore from backup option - 08.02.07 \n2.004 add time stamps to ops - 8.02.07 \n2.003 added crtl+1/2 for updown on optree - 8.02.07 \n2.002 fixed downloading file and opening file in alt and default editors \n2.001 rewored API for gPLINK. Shrink lines of code from 15K to 10K and fixed threading issue";
    }

    public void layoutPanels(Project d) {
        this.data = null;
        this.fileViewer = null;
        this.folderViewer = null;
        this.opViewer = null;
        this.data = d;
        this.fileViewer = new FileView();
        this.folderViewer = new myFolderView((Record)this.data);
        this.opViewer = new myOpView(this.data, this.fileViewer);
        this.menu = new PlinkMenuBar(this);
        JSplitPane splitPaneHorz = new JSplitPane(0, this.opViewer.toJScrollPane(), this.fileViewer);
        JSplitPane splitPaneVert = new JSplitPane(1, this.folderViewer.toJScrollPane(), splitPaneHorz);
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)splitPaneVert, "Center");
        this.getContentPane().add((Component)this.statusBar, "Last");
        this.setJMenuBar(this.menu);
        this.pack();
    }

    public void layoutPanels() {
        this.layoutPanels(new Project(this));
    }

    public void setBrowseOnly(boolean state) {
        this.isBrowseOnly = state;
        if (state && this.data != null && this.data.myLock != null && this.data.myLock.hasLock()) {
            this.data.myLock.unlockFile();
        }
        if (this.data != null) {
            this.data.saveConfig();
        }
        if (this.menu != null) {
            this.menu.setEnabledMenu();
        }
    }

    public GPLINK() {
        super("gPLINK");
        this.setTitle("gPLINK-" + this.version);
        Logger.getLogger("com.sshtools").setLevel(Level.OFF);
        Logger gCLINELogger = Logger.getLogger("edu.harvard.mgh.purcell.gCLINE");
        Logger gPLINK2Logger = Logger.getLogger("edu.harvard.mgh.purcell.gPLINK2");
        logger.info("User OS: " + System.getProperty("os.name") + ": " + System.getProperty("os.arch") + ": " + System.getProperty("os.version"));
        logger.info("Java: " + System.getProperty("java.version"));
        gCLINELogger.setLevel(Level.OFF);
        gPLINK2Logger.setLevel(Level.OFF);
        this.filesInTransit = new Vector();
        this.addWindowListener(this.properClosing);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Couldn't set \"system\" look and feel.");
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception e1) {
                System.err.println("Could not set \"cross platform\" look a feel. Going to default.");
            }
        }
        GPLINK mw = new GPLINK();
        mw.pack();
        mw.setVisible(true);
    }

    class myOpView
    extends OpView {
        public myOpView(Record d, FileView f) {
            super(d, f);
            if (GPLINK.this.data.update != null) {
                ImageIcon sucessIcon = this.createImageIcon("images/success.gif");
                ImageIcon failIcon = this.createImageIcon("images/fail.gif");
                ImageIcon runningIcon = this.createImageIcon("images/running.gif");
                ImageIcon fileInfoIcon = this.createImageIcon("images/fileInfoIcon.GIF");
                if (sucessIcon != null && failIcon != null && runningIcon != null) {
                    AutoUpdater autoUpdater = GPLINK.this.data.update;
                    autoUpdater.getClass();
                    this.myTree.setCellRenderer(autoUpdater.new AutoUpdater.MyRenderer(sucessIcon, failIcon, runningIcon, fileInfoIcon));
                } else {
                    logger.warn("[myOpView(Record, FileView)] one of the icon's is null!");
                }
            } else {
                logger.warn("[myOpView(Record, FileView)] data.update is null!");
            }
        }

        protected PopUpMenu createPopUp(StartFrame mf, Record d, String[] givenFiles, String[] givenOp) {
            return new myPopUpMenu(mf, d, givenFiles, givenOp);
        }

        public ImageIcon createImageIcon(String path) {
            URL imgURL = GPLINK.class.getResource(path);
            if (imgURL != null) {
                return new ImageIcon(imgURL);
            }
            logger.error("[createImageIcon()] Can't find file: " + path);
            return null;
        }
    }

    class myFolderView
    extends FolderView {
        public myFolderView(Record d) {
            super(GPLINK.this, d);
        }

        protected PopUpMenu createPopUp(StartFrame mf, Record d, String[] givenFiles, String[] givenOp) {
            return new myPopUpMenu(mf, d, givenFiles, givenOp);
        }
    }

    class myPopUpMenu
    extends PopUpMenu {
        public myPopUpMenu(StartFrame mf, Record d, String[] givenFiles, String[] givenOp) {
            super(mf, d, givenFiles, givenOp, Project.GPLINK_EXT);
            if (GPLINK.this.data.getHaploPath() != null && !GPLINK.this.data.getHaploPath().matches("^\\s*$") && this.fileNames != null) {
                JMenuItem hapOpen = new JMenuItem("Open in Haploview");
                hapOpen.addActionListener(this.openHaploview());
                this.insert(hapOpen, 1);
            }
        }

        protected ActionListener createExicute() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new PLINK_Execute(GPLINK.this, myPopUpMenu.this.data.getOp(myPopUpMenu.this.opnames[0]).getCline());
                }
            };
        }

        private ActionListener openHaploview() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (myPopUpMenu.this.fileNames != null) {
                        if (myPopUpMenu.this.opnames != null) {
                            new OpenHapDialog(GPLINK.this, myPopUpMenu.this.opnames[0], myPopUpMenu.this.fileNames[0]);
                        } else {
                            new OpenHapDialog(GPLINK.this, null, myPopUpMenu.this.fileNames[0]);
                        }
                    }
                }
            };
        }
    }
}

