/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.util.Hash;
import java.security.NoSuchAlgorithmException;

public abstract class SshPublicKey {
    public abstract String getAlgorithmName();

    public abstract int getBitLength();

    public abstract byte[] getEncoded();

    public String getFingerprint() {
        try {
            Hash md5 = new Hash("MD5");
            md5.putBytes(this.getEncoded());
            byte[] digest = md5.doFinal();
            int bits = this.getBitLength();
            bits = bits % 8 != 0 ? (bits = bits + bits % 8) : bits;
            String ret = String.valueOf(bits);
            int i = 0;
            while (i < digest.length) {
                ret = String.valueOf(ret) + (i == 0 ? ":" : "") + " " + Integer.toHexString(digest[i] & 0xFF);
                ++i;
            }
            return ret;
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshPublicKey) {
            return this.getFingerprint().compareTo(((SshPublicKey)obj).getFingerprint()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getFingerprint().hashCode();
    }

    public abstract boolean verifySignature(byte[] var1, byte[] var2) throws InvalidSshKeySignatureException;
}

