/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.openssh.KeyInfo;
import com.sshtools.j2ssh.util.SimpleASNReader;
import com.sshtools.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSAKeyInfo
implements KeyInfo {
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;

    public RSAKeyInfo(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) {
        this.modulus = modulus;
        this.publicExponent = publicExponent;
        this.privateExponent = privateExponent;
        this.primeP = primeP;
        this.primeQ = primeQ;
        this.primeExponentP = primeExponentP;
        this.primeExponentQ = primeExponentQ;
        this.crtCoefficient = crtCoefficient;
    }

    public KeySpec getPrivateKeySpec() {
        return new RSAPrivateKeySpec(this.modulus, this.privateExponent);
    }

    public KeySpec getPublicKeySpec() {
        return new RSAPublicKeySpec(this.modulus, this.publicExponent);
    }

    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    public BigInteger getPrimeP() {
        return this.primeP;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public static RSAKeyInfo getRSAKeyInfo(SimpleASNReader asn) throws IOException {
        asn.assertByte(48);
        int length = asn.getLength();
        asn.assertByte(2);
        byte[] version = asn.getData();
        asn.assertByte(2);
        byte[] modulus = asn.getData();
        asn.assertByte(2);
        byte[] publicExponent = asn.getData();
        asn.assertByte(2);
        byte[] privateExponent = asn.getData();
        asn.assertByte(2);
        byte[] primeP = asn.getData();
        asn.assertByte(2);
        byte[] primeQ = asn.getData();
        asn.assertByte(2);
        byte[] primeExponentP = asn.getData();
        asn.assertByte(2);
        byte[] primeExponentQ = asn.getData();
        asn.assertByte(2);
        byte[] crtCoefficient = asn.getData();
        return new RSAKeyInfo(new BigInteger(modulus), new BigInteger(publicExponent), new BigInteger(privateExponent), new BigInteger(primeP), new BigInteger(primeQ), new BigInteger(primeExponentP), new BigInteger(primeExponentQ), new BigInteger(crtCoefficient));
    }

    public static void writeRSAKeyInfo(SimpleASNWriter asn, RSAKeyInfo keyInfo) {
        SimpleASNWriter asn2 = new SimpleASNWriter();
        asn2.writeByte(2);
        byte[] version = new byte[1];
        asn2.writeData(version);
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getModulus().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getPublicExponent().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getPrivateExponent().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getPrimeP().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getPrimeQ().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getPrimeExponentP().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getPrimeExponentQ().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getCrtCoefficient().toByteArray());
        byte[] rsaKeyEncoded = asn2.toByteArray();
        asn.writeByte(48);
        asn.writeData(rsaKeyEncoded);
    }
}

