/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.SshRuntimeException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.util.HashMap;

public class SshThread
extends Thread {
    private static HashMap names = new HashMap();
    protected byte[] sessionId;
    protected String sessionIdString = null;
    protected String username;
    private HashMap settings = new HashMap();

    public SshThread(Runnable target, String name, boolean daemon) {
        super(target);
        this.setProperties(name, daemon);
    }

    public SshThread(String name, boolean daemon) {
        this.setProperties(name, daemon);
    }

    private void setProperties(String name, boolean daemon) {
        Integer i = names.containsKey(name) ? new Integer((Integer)names.get(name) + 1) : new Integer(1);
        names.put(name, i);
        this.setName(String.valueOf(name) + " " + Integer.toHexString(i & 0xFF));
        this.setDaemon(daemon);
        if (ConfigurationLoader.isContextClassLoader()) {
            this.setContextClassLoader(ConfigurationLoader.getContextClassLoader());
        }
    }

    public void setSessionId(byte[] sessionId) {
        if (sessionId != null) {
            this.sessionId = new byte[sessionId.length];
            System.arraycopy(sessionId, 0, this.sessionId, 0, sessionId.length);
            this.sessionIdString = String.valueOf((long)new String(sessionId).hashCode() & 0xFFFFFFFFL);
        }
    }

    public String getSessionIdString() {
        return this.sessionIdString;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public SshThread cloneThread(Runnable target, String name) {
        SshThread thread = new SshThread(target, name, this.isDaemon());
        thread.setSessionId(this.sessionId);
        thread.setUsername(this.username);
        thread.settings.putAll(this.settings);
        return thread;
    }

    public void setProperty(String name, Object value) {
        this.settings.put(name, value);
    }

    public Object getProperty(String name) {
        return this.settings.get(name);
    }

    public boolean containsProperty(String name) {
        return this.settings.containsKey(name);
    }

    public static String getCurrentThreadUser() throws SshRuntimeException {
        if (Thread.currentThread() instanceof SshThread) {
            return ((SshThread)Thread.currentThread()).getUsername();
        }
        throw new SshRuntimeException("The current thread is not running within an SshThread context");
    }

    public static boolean hasUserContext() {
        if (Thread.currentThread() instanceof SshThread) {
            return ((SshThread)Thread.currentThread()).getUsername() != null;
        }
        throw new SshRuntimeException("The current thread is not running within an SshThread context");
    }

    public static String getCurrentSessionId() throws SshRuntimeException {
        if (Thread.currentThread() instanceof SshThread) {
            return ((SshThread)Thread.currentThread()).getSessionIdString();
        }
        throw new SshRuntimeException("The current thread is not running within an SshThread context");
    }

    public static SshThread getCurrentThread() throws SshRuntimeException {
        if (Thread.currentThread() instanceof SshThread) {
            return (SshThread)Thread.currentThread();
        }
        throw new SshRuntimeException("The current thread is not an SshThread");
    }
}

