/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.mru;

import com.sshtools.common.mru.MRUList;
import java.io.File;
import javax.swing.AbstractListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MRUListModel
extends AbstractListModel {
    private static Log log = LogFactory.getLog(MRUListModel.class);
    private MRUList mru;

    public MRUListModel() {
        this.setMRUList(new MRUList());
    }

    public void add(File f) {
        this.mru.insertElementAt(f, 0);
        int i = this.mru.size() - 1;
        while (i >= 1) {
            if (((File)this.mru.elementAt(i)).equals(f)) {
                this.mru.removeElementAt(i);
            }
            --i;
        }
        if (this.mru.size() > 15) {
            i = this.mru.size() - 1;
            while (i >= 15) {
                this.mru.removeElementAt(i);
                --i;
            }
        }
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public Object getElementAt(int i) {
        return this.mru.get(i);
    }

    public int getSize() {
        return this.mru == null ? 0 : this.mru.size();
    }

    public void setMRUList(MRUList mru) {
        this.mru = mru;
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public MRUList getMRUList() {
        return this.mru;
    }
}

