
#include "common_includes.h"

RCSID ("$Id: video.c,v 1.17 2000/01/27 11:38:16 misiek Exp $")

     void info_add_highlights (int pos, int cursor, long lines, char **message);

     void
       substitutestr (char *src, char *dest, char *from, char *to)
/*
 * Utility for substituting strings in given string.
 * Used for internationalization of info headers.
 */
{
  char *start = strstr (src, from);
  char tmp;
  if (!start)
    strcpy (dest, src);
  else
    {
      tmp = *start;
      *start = 0;
      strcpy (dest, src);
      strcat (dest, to);
      *start = tmp;
      start += strlen (from);
      strcat (dest, start);
    }
}

void
addtopline (char *type)
{
  char *buf1 = xmalloc (strlen (type) + 50);
  char *buf2 = xmalloc (strlen (type) + 50);
  strcpy (buf1, type);

  substitutestr (buf1, buf2, "File:", _ ("File:"));
  substitutestr (buf2, buf1, "Node:", _ ("Node:"));
  substitutestr (buf1, buf2, "Next:", _ ("Next:"));
  substitutestr (buf2, buf1, "Prev:", _ ("Prev:"));
  substitutestr (buf1, buf2, "Up:", _ ("Up:"));
  attrset (topline);
  mymvhline (0, 0, ' ', maxx);	/* pads line with spaces -- estetic */
  if (strlen (buf2))
    buf2[strlen (buf2) - 1] = '\0';
  mvaddstr (0, 0, buf2);
  attrset (normal);
  xfree (buf1);
  xfree (buf2);
}

void
showscreen (char **message, char *type, long lines, long pos, long cursor)
{
  long i;
#ifdef HAVE_BKGDSET
  bkgdset (' ' | normal);
#endif
  attrset(normal);
  for (i = pos; (i < lines) && (i < pos + maxy - 2); i++)
    {
      int tmp = strlen (message[i]) - 1;
      message[i][tmp] = 0;
      mvaddstr (i + 1 - pos, 0, message[i]);
#ifdef HAVE_BKGDSET
      clrtoeol ();
#else
      myclrtoeol ();
#endif
      message[i][tmp] = '\n';
    }
  clrtobot ();
#ifdef HAVE_BKGDSET
  bkgdset (0);
#endif
  attrset (bottomline);
  mymvhline (maxy - 1, 0, ' ', maxx);
  move (maxy - 1, 0);
  if ((pos < lines - 1) && (lines > pos + maxy - 2))
    printw (_ ("Viewing line %d/%d, %d%%"), pos + maxy - 2, lines, ((pos + maxy - 2) * 100) / lines);
  else
    printw (_ ("Viewing line %d/%d, 100%%"), lines, lines);
  info_add_highlights (pos, cursor, lines, message);
  attrset (normal);
  move (0, 0);
  refresh ();
}
void
info_add_highlights (int pos, int cursor, long lines, char **message)
{
  int i, j;
  for (i = 0; i < hyperobjectcount; i++)
    {
      if ((hyperobjects[i].line >= pos) &&
	  (hyperobjects[i].line < pos + (maxy - 2)))
	{
	  if (hyperobjects[i].type < 2)		/* menu */
	    {
	      if (i == cursor)
		attrset (menuselected);
	      else
		attrset (menu);
	    }
	  else if (hyperobjects[i].type < 4)	/* note */
	    {
	      if (i == cursor)
		attrset (noteselected);
	      else
		attrset (note);
	    }
	  else if (hyperobjects[i].type < HIGHLIGHT)	/* url */
	    {
	      if (i == cursor)
		attrset (urlselected);
	      else
		attrset (url);
	    }
	  else
	    /* quoted text -- highlight it */
	    {
	      attrset (infohighlight);
	    }
	  if (hyperobjects[i].file[0] == 0)
	    {
	      if (hyperobjects[i].breakpos == -1)
		{
		  mvaddstr (1 + hyperobjects[i].line - pos,
			    hyperobjects[i].col,
			    hyperobjects[i].node);
		}
	      else
		{
		  char tmp = hyperobjects[i].node[hyperobjects[i].breakpos];
		  hyperobjects[i].node[hyperobjects[i].breakpos] = 0;
		  mvaddstr (1 + hyperobjects[i].line - pos,
			    hyperobjects[i].col,
			    hyperobjects[i].node);
		  hyperobjects[i].node[hyperobjects[i].breakpos] = tmp;
		  if (hyperobjects[i].line - pos + 3 < maxy)
		    mvaddstr (1 + hyperobjects[i].line - pos + 1,
			      0,
			   hyperobjects[i].node + hyperobjects[i].breakpos);
		}
	    }
	  else
	    {
	      if (hyperobjects[i].breakpos == -1)
		{
		  move (1 + hyperobjects[i].line - pos,
			hyperobjects[i].col);
		  addstr ("(");
		  addstr (hyperobjects[i].file);
		  addstr (")");
		  addstr (hyperobjects[i].node);
		}
	      else
		{
		  static char buf[1024];
		  char tmp;
		  strcpy (buf, "(");
		  strcat (buf, hyperobjects[i].file);
		  strcat (buf, ")");
		  strcat (buf, hyperobjects[i].node);
		  tmp = buf[hyperobjects[i].breakpos];
		  buf[hyperobjects[i].breakpos] = 0;
		  mvaddstr (1 + hyperobjects[i].line - pos,
			    hyperobjects[i].col,
			    buf);
		  buf[hyperobjects[i].breakpos] = tmp;
		  if (hyperobjects[i].line - pos + 3 < maxy)
		    mvaddstr (1 + hyperobjects[i].line - pos + 1,
			      0,
			      buf + hyperobjects[i].breakpos);
		}
	    }
	  attrset (normal);
	}
    }
#ifndef ___DONT_USE_REGEXP_SEARCH___
  if ((h_regexp_num) || (aftersearch))
    {
      regmatch_t pmatch[1];
      long maxpos = pos + (maxy - 2);
      if (maxpos > lines)
	maxpos = lines;
      for (i = pos; i < maxpos; i++)
	{
	  int maxregexp = aftersearch ? h_regexp_num + 1 : h_regexp_num;
	  /* if it is after search, then we have user defined regexps+
	     a searched regexp to highlight */
	  for (j = 0; j < maxregexp; j++)
	    {
	      char *str = message[i];
	      while (!regexec (&h_regexp[j], str, 1, pmatch, 0))
		{
		  int n = pmatch[0].rm_eo - pmatch[0].rm_so, k;
		  int y = i - pos + 1, x = calculate_len (message[i], pmatch[0].rm_so + str);
		  int txtoffset = pmatch[0].rm_so + str - message[i];
		  char tmp;
		  tmp = message[i][x + n];
		  message[i][x + n] = 0;
		  attrset (searchhighlight);
		  mvaddstr (y, x, message[i] + txtoffset);
		  attrset (normal);
		  message[i][x + n] = tmp;
		  str = str + pmatch[0].rm_eo;
		}
	    }
	}
    }
#endif
}
