#!/bin/sh
# osname: Get the operating system dependent name.
#
# Christos Zoulas, Tue Jun 11 14:07:28 EDT 1996
# 1996-06-11  Kimmo Suominen
#
# osname.sh,v 1.8 1997/07/14 13:50:05 kim Exp
#

PATH=/bin:/usr/bin export PATH

# Store the common uname stuff.
os="`uname -s`"
node="`uname -n`"
release="`uname -r`"
minmaj=major

# Stock SVR4 uses the nodename as the osname.
# The nodename can be FQDN while the osname is short.
case "$node" in
"${os}"*)
    case "$release" in
    4.*)
	os=svr4
	minmaj=minor
	;;
    esac
esac

# Extract major and minor version numbers.
version() {
    OIFS="$IFS"
    IFS=".$IFS"
    set x $release
    IFS="$OIFS"
    shift
    case $minmaj in
    minor)
	echo ${2-0}
	;;
    *)
	echo $1
	;;
    esac
}

# Use uname to get the name and version of the Operating System used.
# We care only about the major version numbers.
osname() {
    echo "$os.`version`"
}

# Use uname to get the processor type. We could try to use uname -p, but 
# that works only on solaris. So we use uname -m and fix the sun4* output.
machname() {
    machine="`uname -m`"
    case "$machine" in
    sun4*)
	echo sparc
	;;
    *)
	echo "$machine"
	;;
    esac
}

simplename() {
    case "$os" in
    IRIX*)
	echo irix
	;;
    OSF*)
	echo osf
	;;
    SunOS)
	case "$release" in
	[0-4]*)
	    echo sunos
	    ;;
	*)
	    echo solaris
	    ;;
	esac
	;;
    *)
	echo "$os" | tr '[A-Z]' '[a-z]'
	;;
    esac
}

if [ -z "$1" ]
then
    simplename
    exit 0
fi

for i
do
    case "$i" in
    -os)
	osname
	;;
    -machine)
	machname
	;;
    -path)
	echo `osname`.`machname`
	;;
    *)
	echo "Usage: `basename $0` [-os|-machine|-path]" >&2
	exit 1
	;;
    esac
done
