#include <fstream>
#include <string>
#include <list>
#include <stack>



using namespace std;
namespace ord {


	class OutStream {
		ostream * currentStream ;
		ostream * debugStream ;
		stack<ostream *> streams ;
	public:
		OutStream();
		void push(ostream& str) {streams.push(currentStream);
				currentStream = &str;}
		void pop(){if (!streams.size()) return ;
			currentStream = streams.top(); streams.pop(); }
		ostream & outStream() const {return * currentStream;}
		ostream & outDbgStream() const { if (debugStream) return * debugStream;
			return * currentStream ;}
		static OutStream streamManager ;
	};

	extern ostream& outStream() ;
	extern ostream& outDbgStream() ;


	#define DBG(param) (OrdinalImpl::debugControl.check( \
		DebugControlParam::param,0))


	struct DebugControlParam {
		unsigned int level ;
		unsigned long flags;
					static const int standard = 4 ;
		static const int opInput = 8 ;
		static const int maxDebug = 1024 ;
		
		static const unsigned ctrOrd = 0x1 ;
		static const unsigned dtrOrd = 0x2 ;
		static const unsigned ctrElt = 0x4 ;
		static const unsigned dtrElt = 0x8 ;

		static const unsigned refOrd = 0x10 ;
		static const unsigned drfOrd = 0x20 ;
		static const unsigned refElt = 0x40 ;
		static const unsigned drfElt = 0x80 ;

		static const unsigned add =     0x1000 ;
		static const unsigned mult =    0x2000 ;
		static const unsigned expon =   0x4000 ;
		static const unsigned compare = 0x8000 ;
		static const unsigned limit =  0x10000 ;

		static const unsigned idOrd = 0x100000;
		static const unsigned idElt = 0x200000;
		
		
		static const unsigned refList = 0x10000 ;

		bool check(unsigned long flg, unsigned int lev = opInput) const
			{return ((lev <= level)
				&&((flags &flg) !=0)) ;}

		DebugControlParam& setStandard() 
			{level = standard; flags = add | mult | expon ; return *this;}
		DebugControlParam& clearAll()
			{level = 0 ; flags = 0 ;return *this;}
		DebugControlParam& setMemMang() {level = maxDebug;
			flags =
			ctrOrd | dtrOrd | ctrElt | dtrElt | refOrd | drfOrd |
			refElt | drfElt | idOrd | idElt | refList ;return *this;}
		DebugControlParam&  setExpon() {level = maxDebug; flags =
			expon ;return *this;}
		DebugControlParam&  setArith() {level = maxDebug; flags =
			add | mult | expon ;return *this;}
		DebugControlParam&  setLimit()
			{level = maxDebug; flags = limit;return *this;}
        DebugControlParam&  setCtrOrd()
			{level = maxDebug; flags = ctrOrd;return *this;}
		DebugControlParam&  setCompare()
			{level = maxDebug; flags = compare;return *this;}
		DebugControlParam&  setAll() {level = maxDebug; flags =  
			ctrOrd | dtrOrd | ctrElt | dtrElt | refOrd | drfOrd |
			refElt | drfElt | add | mult | expon | compare | idOrd |
			idElt | refList ;return *this;}


	} ;

	struct DebugControlStack {
		struct DebugElt {
			const DebugControlParam& elt ;
			DebugElt * next ;
			DebugElt(const DebugControlParam& e,DebugElt * nxt=0):
				elt(e),next(nxt){}
		} * stack  ;
		static const DebugControlParam& defaultControl ;
public:
		DebugControlStack():stack(0){}
		void push (const DebugControlParam &c) {
			stack = new DebugElt(c,stack);
		}
		const DebugControlParam& pop() {
			if (!stack) return defaultControl ;
			DebugElt * toDelete = stack ;
			stack = stack->next ;
			delete toDelete ;
			if (!stack) return defaultControl ;
			return stack->elt ;
		};
	};



	struct DebugControl {
		DebugControlStack stack ;

		const DebugControlParam * currentLevel ;
		DebugControl():currentLevel(&DebugControlStack::defaultControl) {}
		
		void push(const DebugControlParam& pm) {stack.push(pm);}
		void updateFlags(DebugControlParam& param, bool addFlag);
		void setStandard(bool addFlag=false)
			{updateFlags((new DebugControlParam)->setStandard(),addFlag);}
		void clearAll()
			{updateFlags((new DebugControlParam)->clearAll(),false);}
		void setMemMang(bool addFlag=false)
			{updateFlags((new DebugControlParam)->setMemMang(),addFlag);}
		void setExpon(bool addFlag=false)
			{updateFlags((new DebugControlParam)->setExpon(),addFlag);}
		void setArith(bool addFlag=false)
			{updateFlags((new DebugControlParam)->setArith(),addFlag);}
		void setCompare(bool addFlag=false)
			{updateFlags((new DebugControlParam)->setCompare(),addFlag);}
		void setCtrOrd(bool addFlag=false)
			{updateFlags((new DebugControlParam)->setCtrOrd(),addFlag);}
		void setLimit(bool addFlag=false)
			{updateFlags((new DebugControlParam)->setLimit(),addFlag);}
		void setAll(bool addFlag=false)
			{updateFlags((new DebugControlParam)->setAll(),addFlag);}

		bool check(unsigned long flg,
			unsigned int lev = DebugControlParam::opInput )
			{return currentLevel->check(flg,lev);}

		void pop()
			{ if (currentLevel != &(DebugControlStack::defaultControl))
				delete currentLevel ;
			currentLevel = &(stack.pop());
			}

	};
		

	
	extern DebugControl debugControl ;
    extern void checkMemory(const char * where);

}
