#include <string>
#include <map>
#include <list>
#include <assert.h>
using namespace ord;
using namespace std;

namespace ord {


typedef void (*CommandAction)(list<const string *> * lst);

struct CommandOptions {
    virtual const CommandOptions * getNext() const {
        return this + 1 ;
    }
    const enum Type {cmd,scr} type ;
    const char * name ;
    CommandAction action ;
    const char * whatItDoes ;
    CommandOptions(const char *nm, CommandAction act =(CommandAction)NULL,
        const char * wh=NULL,Type typ=cmd):name(nm),action(act),whatItDoes(wh),
        type(typ){}
};

struct Commands {
    const char * name;
    void (*action) (const char *cmd, list<const string *> * params);
    const CommandOptions * options ;
    const char * whatItDoes ;
};

struct ExampleScripts: public CommandOptions {
    virtual const CommandOptions * getNext() const {
        return this+1 ;
    }
    const char * title ;
    const char ** script ;
    const char ** descript ;
    ExampleScripts(const char *nm, CommandAction act = (CommandAction)NULL,
       const char * wh = NULL, const char *tl = NULL, const char ** scrx = NULL,
       const char ** desc = NULL, Type sc=scr):
            CommandOptions(nm,act,wh,sc),title(tl),
            script(scrx), descript(desc){}
} ;





class ParseContainer {
    public:
    const enum Type {ord=0x1, ordLst=0x2, drillDown=0x4} type ;
    union Object {
        const Ordinal * ordinal ;
        list<const Ordinal *>* ordinalList ;
        Object(const Ordinal * o):ordinal(o){}
        Object(list<const Ordinal *>* lst):ordinalList(lst){}
    } object ;
    ParseContainer(const Ordinal * o, Type t =ord):type(t),object(o){}
    ParseContainer(list<const Ordinal *>* l):type(ordLst),object(l){}
    const Ordinal * getOrd() const {assert(type&ord);return object.ordinal;}
    list<const Ordinal *>* getList() const {assert(type&ordLst);
        return object.ordinalList;}
    const Ordinal * checkOrd() const 
        {if (type&ord) return object.ordinal; return NULL;}
    list<const Ordinal *>* checkList() const
        {if (type&ordLst) return object.ordinalList; return NULL;}
    const Ordinal * front() const ;

    const Ordinal * getFirstOrdinal() const ;

    void out(ostream& out) ;

    static const Ordinal * getNth(list<const ParseContainer *> *lst, int n);
    static const Ordinal * getFirst(list<const ParseContainer *> *lst)
        {return getNth(lst,1);}
    static const Ordinal * getSecond(list<const ParseContainer *> *lst)
        {return getNth(lst,2);}
    static const Ordinal * getThird(list<const ParseContainer *> *lst)
        {return getNth(lst,3);}
    static int size(list<const ParseContainer *> *lst);
    static list<const Ordinal *>* linearList(list<const ParseContainer *> *lst,
        const int skip = 0);
};


class ParseSemantics {
    enum Options {formatText = 1, formatTeX =2 , formatBoth=3,
        formatPsi = 4} ;
    int formatOptions ;
    int promptLine;
    int promptLineLimit;
public:
    bool promptUser ;
    static ostream * out ;
    ParseSemantics():promptLine(0),promptLineLimit(20),promptUser(true),
        currentFile(NULL),formatOptions(formatText){}
    void found(const char * str) ;
    void expr(const ParseContainer * exp);

    void reset(); 

    static const char ** exampleInput ;
    void exampleParse();
    
    
    list<const Ordinal *>* findListValue(const string * name) const ;
    const Ordinal * findValue(const string * name) const;
    const ParseContainer * evaluate(const string * name);
    const ParseContainer * number(int val);
    const Ordinal * subtract(const Ordinal& op1, const Ordinal& op2) const ;
    const ParseContainer * operation(const ParseContainer * op1, char op,
        const ParseContainer * op2);
    const ParseContainer * ddMark(const ParseContainer * op);
    const ParseContainer * memberFunction(const ParseContainer * ord,
        const string * name, list<const ParseContainer *> * arguments);
    void assign(const string * nane, list<const ParseContainer *> *lst );
    void stz() const ;

    void listAssignments(ostream& strOut =*out, bool textOnly=false);
    void outList(list<const Ordinal *>* ordinal, ostream * ot=out,
        int charCount = 0);

    void outPsiList(list<const Ordinal *>* ordinal, ostream * ot=out,
        int charCount = 0);

    void outTeXlist(list<const Ordinal *>* ordinal, ostream * ot=out,
        int charCount = 0);

    void outList(list<const ParseContainer *> * ordLst, ostream * ot=out,
        int charCount=0);

    void outPsiList(list<const ParseContainer *> * ordLst, ostream * ot=out,
        int charCount=0);

    void outTeXlist(list<const ParseContainer *> * ordLst, ostream * ot=out,
        int charCount=0);

    static const Ordinal * getFirstOrdinal(const ParseContainer * contain);
    const ParseContainer * evaluateFunction(const string * name,
        list<const ParseContainer *> * arguments);
    list<const string *> * makeQuoteList(const string *str,const string *str2);
    list<const string *> * makeStrList(const string *str,const string *str2);
    list<const string *> * makeStrList(const string *str);
    list<const string *> * appendStrList( list<const string *> * lst, const string *str);
    list<const string *> * appendQuoteList( list<const string *> * lst, const string *str);
    list<const ParseContainer *> * makeParamList(const string * nm);
    list<const ParseContainer *> * makeContainList(const ParseContainer * contain);
    list<const ParseContainer *> * appendContainList(
        list<const ParseContainer *> * lst, const ParseContainer *contain );
    list<const ParseContainer *> * appendParamList(
        list<const ParseContainer *> * lst,list<const ParseContainer *> * lst2 );
    list<const ParseContainer *> * makeList(const Ordinal * ordinal);
    list<const ParseContainer *> * appendList(
        list<const ParseContainer *> * lst, const Ordinal * ordinal);
    bool checkCmd(const string *);
    const string * checkCommand(list<const string *> * lst);
    bool compare(const Ordinal * ordA, int oper, const Ordinal * ordB);
    bool compare(const ParseContainer * ordA, int oper,
        const ParseContainer * ordB);
    const Ordinal * memberFunction(const string * s, 
        list<const ParseContainer *> * arguments);
    const ParseContainer * iterOrd(const ParseContainer * iter,
        list<const ParseContainer *> * lst);
    const ParseContainer * admisOrd(const ParseContainer * embed,
        const ParseContainer * admis1, 
        const ParseContainer * iter2, list<const ParseContainer *> * lst,
        const ParseContainer *o);
        
    void parseInput(const char * file);
    void popFile();
    void readline(char * buf, int& char_read, int max_size);
    void readFromFile(const string * fileName);
    void readFromFile();
    enum logOption {createLog,flushLog,stopLog,exitClean};
    void log(logOption flushLog, const string * filename=NULL);
    void yy_flush_bison_buffer();

    bool getPromptUser()const {return promptUser;}
    void setPromptLine(int n);
    void setPromptLimit(int n){promptLineLimit =n;}
    void promptCheck() ;
    void waitForEnter(list<const string *> * strList=NULL);

    void addFormatPsi() {formatOptions |=formatPsi;}
    void setFormatTeX() {formatOptions = formatTeX;}
    void setFormatText() {formatOptions = formatText;}
    void setFormatBoth() {formatOptions = formatBoth;}

    static const string * fileToRead ;

    static const Ordinal * omega ;
    static string defaultSaveFile ;  
    static string defaultExportTexFile ;  
    static const char *ordCalc ;

    static bool initFile ;
    struct FileState {
        string name ;
        int line ;
        ifstream * stream ;
        FileState(string nm, ifstream * str);
        ~FileState();
    } * currentFile ;

    static ofstream * logFileStream ;
    static string defaultLogFile ; 
    bool outTeX() const {return formatOptions&formatTeX;}
    bool outText() const  {return formatOptions&formatText;}
    bool outPsi() const  {return formatOptions&formatPsi;}
    void createTeXDocumentation(const char * fileName);
    static bool TeXdocMode ;
    void brTeX(){if(TeXdocMode) *out << "\\\\\n" ;}

    const ParseContainer * desLimitOrdLst(int depth, int index,
       const Ordinal *base, list<const Ordinal *>*ordList,
       const string (Ordinal::*nf)() const) const ;
    const ParseContainer * limitOrdLst(const Ordinal *base,
       list<const Ordinal *>*ordList,
       const string (Ordinal::*nf)() const) const ;

    const ParseContainer * limitOrdLst(const Ordinal * theOrd,
        list<const ParseContainer *> *ordList) const ;

    const ParseContainer * desLimitOrdLst(const Ordinal * theOrd,
        list<const ParseContainer *> *ordList) const ;


    enum EscTeXlevel {escNone,escAll,escScript} ;
    static const char * escTeX(char c);
    static const char * escTeXscr(char c);
    static int formatBufLength;
    static int formatCharLength;
    static int formatBufIndex;
    static int formatCharIndex;
    static const int formatBufSize =1023 ;
    static char formatBuf[formatBufSize+1] ;
    void writeFormatted(const char ** text, bool skip=false);
    void addChar(char c, EscTeXlevel skipEsc);
    static const char * chTtyTeX(const char * in);
    static const char * checkTeX(const char * in, const char *pre = NULL,
        const char *post= NULL);
    static const char * ttyTeX(const char * in);
    static int formatSq ;
    static  int formatDq ;
    static void formatResetQ() {formatDq=formatSq=0;}
    static const char * sectionTeX ;
    static const char * sqTeX(bool left = true);
    static const char * dqTeX(bool left = true);
    static void outTeXcmdsWithOpts() ;
    void exampleOut(const char * title,  const char * text[]);
    
    void exampleOutFile(const ExampleScripts * entry);
};

class ParserState  {
    void initMap();
    ParseSemantics semantics ;
public:
    map<const string, list<const Ordinal *> > assignments ;
    bool runChecks ;
    ParserState():runChecks(false){initMap();}
    ParseSemantics& getParseSemantics() {return semantics;}
    
};

extern string * intToString(int v);

extern ParserState * parserState ;

extern ParseSemantics * pS ;
}
