/*  indextex.C   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */
// #include "cpyrght_exe.h"
#include <string>
#include <ctype.h>
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <assert.h>
//#include <getopt.h>

#include "linlist.h"
#include "lexnum.h"
// #include "outtok.h"
#include "mkstr.h"
#include "texutil.h"
#include "texspec.h"

using namespace std;

#define LogOut if (Debug) cerr 
int Debug = 0 ;
int multiply_two_word = 0 ;

bool omitFlag = false ;

struct IndexEntry ;
class LinearList ;

extern LinearList TheIndexEntrys ;

int hyperPage=0 ;

ofstream * OutFile = 0 ;
// OutTokens * OutTok = 0 ;

FILE * InFile = 0 ;
char * InputFileName = 0 ;

const char * MarkMain = "\\it" ;

int MaxEntry = 8 ;

static const char * sec = "\\subsection" ;

struct IndexEntry {
	const char * Cite ;
	const char * Page ;
	int MainFlag ;
	const char * Cmd ;
	IndexEntry(const char * cite, const char * page, const char * cmd, int flg=0);
	int Identical(IndexEntry * check);
	int SameCite(IndexEntry * check) ;
};

IndexEntry::IndexEntry(const char * cite, const char * page, const char * cmd, int flg):
	Cite(MakeLitString(cite)),
	MainFlag(flg),
	Page(MakeLitString(page))
{
	if (cmd) Cmd = MakeLitString(cmd);
	else Cmd = 0 ;
	LogOut << "Found: " << Cite << ", " << Page ;
	if (Cmd) LogOut << ", " << Cmd ;
	LogOut << "\n" ;
}

int IndexEntry::Identical(IndexEntry * check)
{
	if (!check) return 0 ;
	LogOut << "`" << Cite << "' : `" << Page << "'\n" ;
	LogOut << "`" << check->Cite << "' : `" << check->Page << "'\n" ;
	int Ck = TeXstrcmp(check->Cite,Cite) ;
	int Ck2 = strcmp(check->Page,Page) ;
	int Return = !Ck && !Ck2 ;
	LogOut << "Identical (" << Ck << ", " << Ck2 << ") = " << Return<<"\n" ;
	return Return ;
}
int safe_cmp(const char * a, const char * b)
{
	if (!a) if (!b) return 0 ;
		else return 1 ;
	if (!b) return -1 ;
	return (strcmp(a,b));
}

int IndexEntry::SameCite(IndexEntry * check)
{
	if (!check) return 0 ;
	int cmp = TeXstrcmp(check->Cite,Cite) ;
	if (cmp) return !cmp; 
	return !safe_cmp(check->Cmd,Cmd);
}

class LinearList {
	void ** Items ;
	int Size ;
	int Max ;
	const int MinSize ;
	void Expand() ;
public:
	LinearList(void ** Initial = 0, int Size = 0, int min=32);
	void AddItem(void * Item);
	void ** Get() { return Items;}
	int Length() {return ListLength((const void **) Items);}
};

LinearList TheIndexEntrys ;

LinearList::LinearList(void ** Initial, int Size, int min):
	Items(0),
	Size(0),
	Max(0),
	MinSize(min>4?min:4)
	// Less than this and the expansion formula FAILS.
{
	if (Size) {
		Size = Max = Size ;
		Items = Initial ;
		Items[Size] = 0 ;
	} else {
		Items = Initial ;
		Size=Max = ListLength((const void **) Items);
	}
}

void LinearList::Expand()
{
	void ** Temp = new void * [1 + (Max = Max + (Max >> 2)) ] ;
	if (Items) for (int i = 0 ; i < Size+1 ; i++) Temp[i] = Items[i];
	delete Items ;
	Items = Temp ;
}

void LinearList::AddItem(void * Item)
{
	if (!Items) {
		Items = new void * [MinSize + 1] ;
		Items[0] = Item ;
		Size = 1 ;
		Max = MinSize ;
		return ;
	}
	if (Size >= Max) Expand() ;
	Items[Size++] = Item ;
}

int LineNumber ;
int WarningCount = 0 ;
int ErrorCount = 0 ;

void Warning()
{
	cerr << " at line " << LineNumber << "\n" ;
	WarningCount++ ;
}

void Error()
{
	cerr << " at line " << LineNumber << "\n" ;
	ErrorCount++ ;
}

void Fatal()
{
	cerr << " at line " << LineNumber << "\n" ;
	exit(1);
}

int findMainKey(char * buf)
{
	const char * ME = "\\ME" ;
	int length = strlen(ME);
    LogOut << "findMainKey entry " << buf << "\n" ;
	for (char * p = buf; *p ; p++) if (!strncmp(p,ME,length)) {
		if (p[length]) strcpy(p,p+length);
		else return 0 ;
        LogOut << "findMainKey " << buf << "\n" ;
		return 1 ;
	}
	return 0;
}

IndexEntry * Scan(char * Buf)
{
	{ 
		char *dest = Buf ;
		char *pt;
		for (pt = Buf; *pt; pt++) 
			if (*pt != '\r') *dest++ = *pt ;
		*dest= *pt;
	
	}		

	LogOut << "Scanning: " << Buf << "\n" ;
	int mainFlag = findMainKey(Buf);

	// remove blanks before `{' 
	int last_blank = 0 ;
	char * dest =  Buf ;
	for (char * pt = Buf; *pt; pt++) {
		if ((*pt == '{') && last_blank && (pt[1] != '\\')) {
			dest-- ;
		}
		if (*pt ==' ') last_blank = 1 ;
		else last_blank = 0 ;
		*dest++ = *pt ;
	}
	*dest ='\0' ;


	int Length = strlen(Buf);
	char * Ptr = Buf + Length -1 ;
	if (*Ptr != '}') {
		cerr << "Buf: `" << Buf << "'\n" ;
		cerr << "Entry not terminated by `}'" ;
		Warning();
		return 0 ;
	}
	*Ptr-- = '\0' ;
	int BracketDepth = 1 ;
	for ( ; Ptr >= Buf; Ptr--) if (*Ptr == '}') BracketDepth++ ;
		else if (*Ptr == '{') if (!--BracketDepth) break ;
	const char * Page = Ptr+1 ;
	int Error = 1 ;
	if (Ptr > Buf+1) if (*Ptr-- == '{') if (*Ptr == '}') Error = 0 ;
	if (Error) {
		cerr << "Cannot find page entry" ;
		cerr << "Buf:`" << Buf << "'\n" ;
		cerr << "Ptr:`" << Ptr << "'\n" ;
		Warning();
		return 0 ;
	}
	*Ptr = '\0' ;
	for (char * ClearBlank = Ptr - 1 ; ClearBlank >=Buf; ClearBlank++)
		if(isspace(*ClearBlank)) *ClearBlank = '\0' ; else break ;
	const char * Init = "\\indexentry{" ;
	if (strncmp(Buf,Init,strlen(Init))) {
		cerr << "Cannot find citation" ;
		Warning() ;
		return 0 ;
	}
	char * Special = 0 ;
	const char * Cite = Buf + strlen(Init);
	const char * save = Cite ;
	if (Cite[0] == '{' && Cite[1] =='\\') {
		int count = 2 ;
		Cite += count ;
		while (isalnum(*Cite)) Cite++, count++ ;
		if (count > 2) if (strncmp("\\Godel",save,count-2)) {
			Special = new char[count+1] ;
			strncpy(Special,save,count);
			Special[count] ='\0' ;
		}
		if (!Special) Cite = save ;
	}
	while (*Cite) if (!isspace(*Cite)) break ; else Cite++ ;
	if (!*Cite || !*Page) {
		cerr << "Partially NULL entry" ;
		Warning() ;
		return 0 ;
	}
	return new IndexEntry(Cite, Page, Special,mainFlag);
}

void remove_underscore_expansion(char * buf)
{
	if (!buf) return ;
	if (!*buf) return ;
	static const char * to_remove =
		"\\unhbox \\voidb@x \\kern .06em \\vbox {\\hrule width.3em}" ;
	static int length= 0 ;
	if (!length) length = strlen(to_remove);
	int bl = strlen(buf);
	if (bl <= length) return ;
	for (char * pt = buf + bl - length ; pt >= buf ; pt--) {
		if (strncmp(pt,to_remove,length)) continue ;
		pt[0] = '_' ;
		strcpy(pt+1,pt+length);
	}
}

void removeSp_(char * Buf)
{
    const char *toCheck = " _" ;// "omega _" ;
    int length = strlen(toCheck);
    LogOut << "removeSp before " << Buf << "\n" ;
    for (char *pt = Buf ; *pt; pt ++) {
        if (!strncmp(toCheck,pt,length)) {
            char *ct = pt + length-2 ;
            for (; *ct; ct++)
                *ct = ct[1];
            ct[1]='0' ;
            LogOut << "removeSp after " << Buf << "\n" ;
        }
    }

}

void  removeHyperPage(char * Buf)
{
	const char * toRemove = "|hyperpage" ;
	int len = strlen(toRemove);
	for (char * b = Buf; *b; b++)
		if (!strncmp(toRemove,b,len)) {
			hyperPage = 1 ;
			int toMove = strlen(b) - len + 1;
			memmove(b,b+len,toMove);
			return ;
		}
}

IndexEntry * GetNext()
{
	const int BufSize = 2048 ;
	char Buf[BufSize + 1] ;
	if (!InFile) return 0 ;
	if (!fgets(Buf,BufSize,InFile)) return 0 ;
	LogOut << "IN:" << Buf << "\n";
    removeSp_(Buf);
    LogOut << "After removeSP " << Buf << "\n";
	removeHyperPage(Buf);
	LogOut << "After RHP:" << Buf << "\n";
	remove_underscore_expansion(Buf);
    LogOut << "After underscore_expansion" << Buf << "\n";
	LineNumber++ ;
	int End = strlen(Buf) ;
	if (Buf[End-1] == '\n') Buf[End-1] = '\0' ;
	else if (End == BufSize) {
		cerr << "Line  > " << BufSize << " characters.\n" ;
		Fatal();
	} else {
		cerr << "Incomplete last line at line " ;
		Warning();
	}
	return Scan(Buf);
}

class PrintIndex {
	IndexEntry ** TheSortedEntrys ;
	int LastFirstCharacter ;
	IndexEntry * LastEntry ;
	int CheckIfTooMany(IndexEntry ** Start) ;
	int SkipFlag ;
	int AnyEntries ;
	int MainFlag ;
	const char * Pages[100];
	int nextPage ;
	void outPage(const char * page);
public:
	PrintIndex(IndexEntry ** entrys);
	void WriteEntry(IndexEntry ** Entry) ;
	void WriteIndex();
	void CheckNewCharacter(char C);
	int SameCite(IndexEntry ** next);
};

PrintIndex::PrintIndex(IndexEntry ** entrys):
	TheSortedEntrys(entrys),
	LastEntry(0),
	LastFirstCharacter(0),
	AnyEntries(0),
	SkipFlag(0),
	MainFlag(0),
	nextPage(0)
{
}


int PrintIndex::CheckIfTooMany(IndexEntry ** Start)
{
	int RepeatCount = 1 ;
	IndexEntry * First = *Start++ ;
	const char * LastPage = "XXX" ;
	for (; *Start; Start++) {
		if ((*Start)->SameCite(First))
			if (strcmp(LastPage,(*Start)->Page)) RepeatCount++ ;
		LastPage = (*Start)->Page ;
		if (RepeatCount > MaxEntry) return 1 ;
	}
	return 0 ;
}

void PrintIndex::outPage(const char * page)
{
	if (MainFlag) *OutFile << "{" << MarkMain << " " ;
	if (hyperPage) *OutFile << "\\hyperpage{" ;
	*OutFile << page ;
	if (hyperPage) *OutFile << "}" ;
	if (MainFlag) *OutFile << "}" ;
}
	

int PrintIndex::SameCite(IndexEntry** next)
{
	IndexEntry& Next = **next ;
	if (!Next.SameCite(LastEntry)) {
		SkipFlag = CheckIfTooMany(next);
		LastEntry = &Next ;
		return 0 ;
	}
	if (SkipFlag) return 1 ;
	for (int i = 0 ; i < nextPage; i++) if (!strcmp(Next.Page,Pages[i])) return 1 ;
	LastEntry = &Next ;
	MainFlag |= Next.MainFlag ;
	*OutFile << ", " ;
	outPage(Next.Page);
	Pages[nextPage++]=Next.Page ;
	MainFlag = 0;
	return 1 ;
}

void PrintIndex::CheckNewCharacter(char C)
{
	if (tolower(C) == LastFirstCharacter) return ;
	if (!isalpha(C)) return ;
	if (AnyEntries) *OutFile << "\n\n\\vspace{.1in}\n\n" ;
	AnyEntries = 0 ;
	LastFirstCharacter = tolower(C) ;
	char chr[2]  ;
	char Chr[2];
	Chr[1]= chr[1] = '\0' ;
	*chr = LastFirstCharacter ;
	*Chr = toupper(LastFirstCharacter);
	*OutFile <<  sec ;
    if (omitFlag) *OutFile << "*" ;
    *OutFile << "{" << Chr << "}\n";
	*OutFile << "\\label{IxS" << chr << "}\n" ;
}

static int getContiguousText(const char * str)
{
    int ret = 0 ;
    for (const char *pt = str; *pt; pt++,ret++) if (isblank(*pt)) break ;
    return ret ;
}

static const char * EscapeUnderscore(const char * str)
{
    const int buf_size = 8192;
    static char buf[buf_size+1] ;
    static const char * bufEnd = buf+buf_size ;
    char * dest = buf ;
	int is_math = 0 ;

    int contiguousText = getContiguousText(str);
    static const int maxContiguouText = 36 ;

    bool breakLine = contiguousText > maxContiguouText ;

	// int dollar_count = 0 ;
    for(const char * pt = str; *pt; pt++) {
		if (*pt=='$') is_math = !is_math ;
		/* if (*pt) dollar_count = !dollar_count ; */
		/* if (!dollar_count) */
		if (!is_math)
		if(*pt == '_') {
			int do_escape = 1 ;
			if (pt > str) if (pt[-1] == '\\') do_escape = 0 ;
			if (do_escape) *dest++ = '\\' ;
		}
        if (breakLine && (*pt == ':') && (pt > str) && (pt[-1] == ':')) {
            static const char * linebreak = "\\linebreak{}" ;
            static const int ll = strlen(linebreak);
            assert(dest + 1 + ll < bufEnd);
            *dest++ = *pt ;
            strcpy(dest,linebreak);
            dest += ll ;
            continue ;
            
        }
        assert(dest < bufEnd);
        *dest++ = *pt ;
    }
    assert(dest < bufEnd);
	*dest++ = '\0' ;
    return buf ;
}


static const char * checkFirstWord(IndexEntry& entry)
{
    static const char * lastFirstWord = NULL; ;
    static bool cmdFlag = false ;

    const char * cmd = entry.Cmd ;
    const char * citeEntry = entry.Cite ;

    bool inWord = false ;
    int bracketCount= 0 ;
    int dollarCount = 0 ;
    if (cmd) {
        static const char * expectedCmd = "{\\tt" ;
        assert(!strcmp(expectedCmd,cmd));
        bracketCount = 1 ;
    }
    const char *pt = citeEntry ;
    for (; *pt; pt++) {
        if (isblank(*pt)) 
            if (inWord && !bracketCount && ((dollarCount%2)==0)) break ;
            else continue ;
        inWord = true ;
        if (*pt == '$') dollarCount++;
        if (*pt == '{') bracketCount++;
        else if (*pt == '}') bracketCount--;
    }
    if (!inWord || bracketCount || ((dollarCount%2)!=0)) {
        if (lastFirstWord) {
            delete lastFirstWord;
            lastFirstWord = NULL ;
            cmdFlag = false ;
        }
        return NULL ;
    }
    int length = pt - citeEntry ;
    bool restoreLength = false ;
    if (length >2) {
        if (citeEntry[length-1] == ',') length--,restoreLength=true; ;
        // if (citeEntry[length-1] == 's') length-- ;    
    }
    if (lastFirstWord && !strncmp(lastFirstWord,citeEntry,length)) {
        if (!*pt) return pt ;
        while (*++pt) if (!isblank(*pt)) break ;
        return pt ;
     }

    if (restoreLength) length++;
    char * lst = new char[length+1] ;
    strncpy(lst,citeEntry,length);
    lst[length]='\0' ;
    delete lastFirstWord;
    lastFirstWord = lst ;
    cmdFlag = cmd != NULL ;
    return NULL ;
}


void PrintIndex::WriteEntry(IndexEntry **  entry)
{
	IndexEntry& Entry = **entry ;
	MainFlag |= Entry.MainFlag ;
	LogOut << "Processing " << EscapeUnderscore(Entry.Cite) << ", " <<
		Entry.Page << ", MF " << MainFlag << "\n" ;
	if (entry[1]) 
		if ((entry[1])->Identical(&Entry)) {
			LogOut << "skipping because next is same\n" ;
			return ;
		}
	// if (Entry.Identical(LastEntry)) return ;
	LogOut << "Not identical\n" ;
	CheckNewCharacter(Entry.Cite[0]);
	if (SameCite(entry)) return ;
	if (SkipFlag) return ;
	LogOut << "Not same cite\n" ;
    const char * sub =  checkFirstWord(Entry);
    if (sub) {
        if (*sub) {
	        *OutFile << "\n\\subitem " ;
            *OutFile << EscapeUnderscore(sub) << " " ;
        }
    } else {
	    *OutFile << "\n\\item " ;
	    if (Entry.Cmd) {
            *OutFile << Entry.Cmd << " " ;
            LogOut << "Entry.Cmd " << Entry.Cmd << "--\n" ;
        }
	    *OutFile << EscapeUnderscore(Entry.Cite) << " " ;
    }
	outPage(Entry.Page);
	Pages[(nextPage=1)-1] = Entry.Page ;
	MainFlag = 0 ;
	AnyEntries = 1 ;
}
	
void PrintIndex::WriteIndex()
{
	if (TheSortedEntrys) {
		*OutFile << "\\begin{theindex}\n" ;
		*OutFile << "\\ifx\\indexhead\\undefined " <<
			"\\newcommand{\\indexhead}{}\\fi\n" <<
			"\\indexhead\n" ;
/*
 *		cerr << "Starting index of index\n" ;
 *		for (int c = 'A' ; c <= 'Z' ; c++) {
 *			char Chr[2];
 *			char chr[2];
 *			chr[1]=Chr[1]='\0' ;
 *			*Chr = c ;
 *			*chr = tolower(c);
 *			cerr << Chr << chr <<"\n" ;
 *			*OutFile << "\\pdfbookmark[1]{" << Chr <<
 *				"}{IxS" << chr << "}\n" ;
 *		}
 */
        // *OutFile << sec << "{Special symbols}\n" ;
		for (IndexEntry ** entry = TheSortedEntrys ; *entry; entry++)
			WriteEntry(entry);
        *OutFile <<
        "\\ifx\\indextail\\undefined \\newcommand{\\indextail}{}\\fi\n";
        *OutFile << "\\indextail\n";

		*OutFile << "\n\\end{theindex}\n" ;
	} else {
		cerr << "No citations found.\n" ;
		exit(0) ;
	}
}

void WriteIndex()
{
	PrintIndex DoPrint( (IndexEntry **) TheIndexEntrys.Get());
	DoPrint.WriteIndex();
}

static int SafeCompare(const char * a,const char * b)
{
	if (!a) if (!b) return 0; else return -1 ;
	if (!b) return 1 ;
	return TeXstrcmp(a,b);
}


static int ToValue(const char * page)
{
	int sum = 0 ;
	int repeated = 0 ;
	int last_roman = 0 ;
	int type = -1 ;
	int t ;
	int v ;
	int err = 0 ;
	for (const char * pt = page;*pt;pt++) {
		 switch(*pt) {
default:
			err = 1 ;
			break ;
case '0':
			v = 0 ; t = 0 ;
			break ;
case '1':
			v = 1 ; t = 0 ;
			break ;
case '2':
			v = 2 ; t = 0 ;
			break ;
case '3':
			v = 3 ; t = 0 ;
			break ;
case '4':
			v = 4 ; t = 0 ;
			break ;
case '5':
			v = 5 ; t = 0 ;
			break ;
case '6':
			v = 6 ; t = 0 ;
			break ;
case '7':
			v = 7 ; t = 0 ;
			break ;
case '8':
			v = 8 ; t = 0 ;
			break ;
case '9':
			v = 9 ; t = 0 ;
			break ;
case 'i' :
			v= 1 ; t = 1 ; break ;
case 'v' :
			v= 5 ; t = 1 ; break ;
case 'x' :
			v= 10 ; t = 1 ; break ;
case 'l' :
			v= 50 ; t = 1 ; break ;
case 'c' :
			v= 100 ; t = 1 ; break ;
case 'd' :
			v= 500 ; t = 1 ; break ;
case 'm' :
			v= 1000 ; t = 1 ; break ;
		}
		if (type != -1) if (t != type) err = 1;
		if (err) {
			cerr << "Warning: invalid number `" << pt << "'.\n" ;
			return -1 ;
		}
		type = t ;
		if (type == 0) sum = sum * 10 + v ;
		else {
			if (last_roman == *pt) {
				repeated += v ;
				continue ;
			}
			if (v > last_roman) sum -= repeated ;
			else sum += repeated ;
			repeated = v ;
			last_roman = v ;
		}
	}
	if (repeated) sum+= repeated ;
	if (!type) sum += 100000 ;
	LogOut << "Converted `" << page << "' to " << sum << "\n" ;
	return sum ;
}

static int SafeNumberCompare(const char * a,const char * b)
{
	if (!a) if (!b) return 0; else return -1 ;
	if (!b) return 1 ;
	return ToValue(a) - ToValue(b) ;
// 	int SizeDiff = strlen(a) - strlen(b) ;
	// leading zeros not allowed
// 	if (SizeDiff) return SizeDiff ;
// 	const char * PtrA = a ;
// 	const char * PtrB = b ;
// 	int Test ;
// 	while (*a && *b) if (Test = *a++ - *b++) return Test ;
// 	if (!*a) if (!*b) return 0 ; else return -1;
// 	return 1 ;
}

inline char * FromTeX(const char * a)
	{return TheTeXWordTranslator.Translate(a);}

static int TeXSafeCompare(const char * A, const char * B)
{
	char * AA = FromTeX(A);
	char * BB = FromTeX(B);
	int Return = SafeCompare(AA?AA:A,BB?BB:B);
	delete AA ;
	delete BB ;
	return Return ;
}

enum EntryType {typeNone=0,typeTty=1, typeMath=2} ;

EntryType getType(const IndexEntry * entry)
{
    LogOut << "getType(" << (entry->Cmd?entry->Cmd:"NULL") << ", " << entry->Cite <<
        ")\n" ;
    if (entry->Cmd) return typeTty ;
    const char *ent = entry->Cite ;
    static const char * ttyType = "{\\tt " ;
    static const int ttyLength = strlen(ttyType);
    for (const char * pt = ent ; *pt; pt++) {
        if (isblank(*pt)) continue ;
        if (isalnum(*pt)) return typeNone ;
        if (!strncmp(pt,ttyType,ttyLength)) return typeTty ;
        if (*pt == '$') return typeMath ;
        if (ispunct(*pt)) return typeNone ;
        LogOut << "Before abort: " << ent << "::" << (void *) ent << "\n" ;
        assert(0);
    }
}

bool sameFirstWord(const char *a, const char *b)
{
    LogOut << "sameFirstWord(" << a << ", " << b << ")\n" ;
    const char * pt = a ;
    for (; *pt ; pt++) if (isblank(*pt) || ispunct(*pt)) break ;
    int alength = pt - a ;
    for (pt=b ; *pt ; pt++) if (isblank(*pt) || ispunct(*pt)) break ;
    int blength = pt - b ;
    if (alength != blength) return false ;
    if (!strncasecmp(a,b,alength)) {
        LogOut << "TRUEsfw\n" ;
        return true ;
    }
    LogOut << "FALSE\n" ;
    return false ;
}


const char * firstComma(const char * str)
{
    for (const char * pt = str ; *pt ; pt++)
        if (*pt == ',') return pt ;
    return NULL ;
}

static const char *remCm(const char * str, char * buf)
{
    const char *fc = firstComma(str);
    if (!fc) return str ;
    int length = fc - str ;
    strncpy(buf,str,length);
    strcpy(buf+length,str+length+1);
    return buf ;
}

static const char *remCma(const char * str)
{
    if (!str) return str ;
    static const int maxLine=8192 ;
    static char buf[maxLine];
    assert(strlen(str)<maxLine);
    return remCm(str,buf);
}

static const char *remCmb(const char * str)
{
    if (!str) return str ;
    static const int maxLine=8192 ;
    static char buf[maxLine];
    assert(strlen(str)<maxLine);
    return remCm(str,buf);
}

int IndexListSort(const void * a, const void * b)
{
	const IndexEntry ** A = (const IndexEntry **) a ;
	const IndexEntry ** B = (const IndexEntry **) b ;
	if (!A) return -1 ;
	if (!B) return 1 ;
    EntryType aType = getType(*A) ;
    EntryType bType = getType(*B) ;
	const char * Aa = (*A)->Cite ;
	const char * Bb = (*B)->Cite;
	LogOut << Aa << " ::: " << Bb << "\n" ;

    const char *exp = "\\UseVerb{Exp}" ;
    static const int expl = strlen(exp);
    if (!strncmp(Aa,exp,expl)) Aa= "^" ;
    if (!strncmp(Bb,exp,expl)) Bb= "^" ;
	LogOut << Aa << " ::: " << Bb << "\n" ;

	int cmp = 0;
	if (*Aa == '$') if (!(cmp=strcmp(Aa,Bb)))
			return SafeNumberCompare((*A)->Page,(*B)->Page);
			else return cmp ;
	if (*Bb == '$') return 1 ;
    if (aType != bType) if (sameFirstWord(Aa,Bb)) return (aType - bType);
        
	const char * schrt = "Schrodinger" ;
	const char ** schr = &schrt ;
	
    // if (!strncmp(Aa,exp,expl)) Aa= "^" ;
    // if (!strncmp(Bb,exp,expl)) Bb= "^" ;
	if (!strncmp(Aa,"\\Godel",6)) Aa++ ;
	if (!strncmp(Bb,"\\Godel",6)) Bb++ ;
	if (!strncmp(Aa,"\\Schr",5)) Aa="Schrodinger";
	if (!strncmp(Bb,"\\Schr",5)) Bb="Schrodinger";
	int Return = TeXSafeCompare(remCma(Aa),remCmb(Bb));
	if (Return) return Return ;
	Return = safe_cmp(remCma((*A)->Cmd),remCmb((*B)->Cmd));
	if (Return) return Return ;
	return SafeNumberCompare((*A)->Page,(*B)->Page);
	
}

		
void SortIndex()
{
	IndexEntry ** Lst = (IndexEntry **) TheIndexEntrys.Get();
	if (!Lst) return ;
	qsort((char *)Lst,TheIndexEntrys.Length(),sizeof(*Lst),IndexListSort);
}

const char * ignore_list[] = {
	"or ",
	"of ",
	"to ",
	"also ",
	"and ",
	"body ",
	"play ",
	"plays ",
	"like ",
	"for ",
	"point ",
	"up ",
	"shut ",
	"calculate ",
	"founded ",
	"the ",
	"towards ",
	"order ",
	"Morley ",
	"disease ",
	"stuff ",
	"well ",
	"one's ",
	"if ",
	"not ",
	"is ",
	"am ",
	"an ",
	"at ",
	"a ",
	"as ",
	"aided ",
	"between ",
	"in ",
	"it ",
	"its ",
	"based ",
	"on ",
	"over ",
	"all ",
	"an ",
	"I ",
	0
};

int check_ignore_word(const char * check)
{
	if (!check) return 0 ;
	if (!*check) return 0 ;
	char second = check[1] ;
	if (!second) return 1 ;
	if (second ==' ') return 1 ;
	if (second =='.' && check[2] ==' ') return 1 ;
	for (const char ** pt = ignore_list; *pt;pt++) {
		const char * p = *pt ;
		int length= strlen(p)  ;
		if (length < 2) continue ;
		int ckl = strlen(check);
		if (ckl == (length-1)) length=ckl;
		if (!strncmp(p,check,length)) {
			LogOut << "Matched `" << p << "'.\n"  ;
			return 1 ;
		}
	}
	return 0 ;
}

IndexEntry * CheckForMultipleWords(IndexEntry& NextEntry)
{
	int ignore_next_blank = 0;
	int alpha_count = 0 ;
	int save_alpha_count = 0 ;
	const char * split_point = 0 ;
	if (NextEntry.Cmd) return 0 ;
    int words= 0 ;
    bool inWord= false ;
	for (const char *pt = NextEntry.Cite;*pt;pt++){
        if ((*pt == ',') && inWord) {
            LogOut << "Comma exit for " << NextEntry.Cite << "\n" ;
            return NULL ;
        }
        if (isblank(*pt)) {
            if (inWord) words++;
            inWord = false ;
        }
        else if (isalnum(*pt)) inWord=true ;
    }
    if (inWord) words++ ;
    if ((words<1) || (words >2)) return NULL ;
    LogOut << "Cite: " << NextEntry.Cite << ", words = " << words << "\n" ;
	for (const char *pt = NextEntry.Cite;*pt;pt++){
		if (*pt == '{') return 0 ;
		if (*pt == '$') return 0 ;
		if (isalpha(*pt)) alpha_count++ ;
		if (split_point) continue ;
		if (*pt == '\\') {
			if (strncmp(pt+1,"Godel",5)) ignore_next_blank = 1 ;
		}
		if (pt == NextEntry.Cite) {
			LogOut << "check_ignore_word " << pt << " = " <<
				check_ignore_word(pt) << "\n" ;
			if (check_ignore_word(pt)) {
				save_alpha_count = alpha_count ;
				continue ;
			}
		}
		if (*pt == ' ') {
			int t = alpha_count ;
			alpha_count = 0 ;
			if (save_alpha_count) t = save_alpha_count ;
			save_alpha_count = 0 ;
			while (pt[1] == ' ') pt++ ;
			if (ignore_next_blank) {
				ignore_next_blank = 0 ;
				continue ;
			}
			
			// if (t < 2) continue ;
			LogOut << "check_ignore_word " << pt+1 << " = " <<
				check_ignore_word(pt+1) << "\n" ;
			if (check_ignore_word(pt+1)) {
				save_alpha_count = t ;
				continue ;
			}
			split_point = pt+ 1 ;
		}
	}
	if (!split_point) return 0 ;
	if (!*split_point) return 0 ;
	if (alpha_count < 3) return 0 ;
	int length = strlen(NextEntry.Cite) + 2 ;
	char * cite = new char[length];
	strcpy(cite,split_point);
	strcat(cite,", ");
	char * dest = cite;
	while (*dest) dest++ ;
	for (const char * p = NextEntry.Cite; p < split_point - 1; *dest++ = *p++);
	*dest++ = '\0' ;
	if (dest - cite != length ) {
		cerr << "Length expected " << length << " found " << dest - cite <<
			"\n" ;
		return 0 ;
	}
	LogOut << "Created entry: " << cite << " ::: " << NextEntry.Page << "\n" ; 
	return new IndexEntry(cite,NextEntry.Page,NextEntry.Cmd,NextEntry.MainFlag) ;
}
		
void ReadIdxFile()
{
	IndexEntry * NextEntry ;
	while(NextEntry = GetNext()) {
		TheIndexEntrys.AddItem(NextEntry);
		if (multiply_two_word)
			if (NextEntry = CheckForMultipleWords(*NextEntry))
				TheIndexEntrys.AddItem(NextEntry);
	}
}

void Main()
{
	ReadIdxFile();
	SortIndex() ;
	WriteIndex();
}


const char * FileSuffix = ".idx" ;

static void Usage(const char * Pgm)
{
	cerr << "Usage is: " << Pgm << " [-d] file\n" ;
	cerr << "`-t' specifies make two entries for two word items.\n" ;
	cerr << "`-d' specifes debugging mode.\n" ;
	cerr << "`file' is a tex index file.\n" ;
	cerr << "`-w dir' specified directory for output file.\n" ;
	cerr << "`-l N' number of entry to delete entry (default = "
		<< MaxEntry << ").\n" ;
    cerr << "`-o' omit table of contents entry for each letter.\n" ;
	cerr << "FileSuffix `" << FileSuffix <<
		"' will be appended to the name if missing.\n" ;
	exit (1);
}

int main(int argc,char ** argv)
{
	int c;
	int errflg = 0;
	const char * OutputDirectory = 0;
	const char * OutputFileName = 0 ;
	const char * MaxEntryString = 0 ;

	while (( c = getopt(argc,argv,"tdw:ol:")) != EOF) switch(c) {
case 'd':
		Debug = 1 ;
		break ;
case 't':
		multiply_two_word = 1 ;
		break ;
case 'w':
		OutputDirectory = MakeLitString(optarg);
		break ;
case 'l':
		MaxEntryString = MakeLitString(optarg);
        break;
case 'o':
        omitFlag = true ;
        break ;

default:
		errflg++;
		break ;
	}
	if (errflg) {
		cerr << "Invalid command line.\n" ;
		Usage(argv[0]);
	}
	for (; optind < argc; optind++) {
		if (InFile) {
			cerr << "Only one input file is allowed.\n" ;
			Usage(argv[0]);
		}
		InputFileName = new char[strlen(argv[optind])+1];
		strcpy(InputFileName,argv[optind]);
		InputFileName = AddSuffix(InputFileName,FileSuffix);

		InFile = fopen(InputFileName,"r");
		if (!InFile) {
			cerr << "Cannot open input file `" << InputFileName <<
				"'\n" ;
			Usage(argv[0]);
		}
	}
	if (!InputFileName) Usage(argv[0]);
	if (MaxEntryString) if (sscanf(MaxEntryString,"%d",&MaxEntry) != 1) {
		cerr << "Parameter for option `-l' is not an integer.\n" ;
		Usage(argv[0]);
	}

	OutputFileName = AddSuffix(RemoveSuffix(InputFileName,FileSuffix),
		".txx");
	if (OutputDirectory)  
		if (OutputDirectory[strlen(OutputDirectory)-1] == '/')
			OutputFileName = Concatenate(OutputDirectory,
				OutputFileName);
		else OutputFileName = Concatenate(OutputDirectory,
				"/",OutputFileName);
		
	OutFile = new ofstream(OutputFileName);
	if (!OutFile->good()) {
		cerr << "Cannot create output file `" << OutputFileName
			<< "'.\n" ;
		Usage(argv[0]);
	}
	// OutTok = new OutTokens(OutFile,0,""," ","",80,1000000) ;

		
	
	Main();
	// OutTok->FlushLine();

	delete OutFile ;
	// exit(0);
	return 0;
}
