// rmepsilon-main.h

// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Author: allauzen@google.com (Cyril Allauzen)
//
// \file
// Removes epsilons from an FST. Includes helper function for
// fstrmepsilon.cc that templates the main on the arc type to support
// multiple and extensible arc types.
//

#ifndef FST_EPSNORMALIZE_MAIN_H__
#define FST_EPSNORMALIZE_MAIN_H__

#include <fst/epsnormalize.h>
#include <fst/main.h>
#include <fst/vector-fst.h>

DECLARE_bool(eps_norm_output);

namespace fst {

// Main function for fstepsnormalize templated on the arc type.
// Call only with 'return CALL_FST_MAIN' in main().
template <class Arc>
int EpsNormalizeMain(int argc, char **argv, istream &strm,
             const FstReadOptions &opts) {
  Fst<Arc> *ifst = Fst<Arc>::Read(strm, opts);
  if (!ifst) return 1;

  EpsNormalizeType eps_norm_type = FLAGS_eps_norm_output ?
      EPS_NORM_OUTPUT : EPS_NORM_INPUT;

  VectorFst<Arc> ofst;
  EpsNormalize(*ifst, &ofst, eps_norm_type);
  ofst.Write(argc > 2 ? argv[2] : "");

  return 0;
}

}  // namespace fst

#endif  // FST_EPSNORMALIZE_MAIN_H__
