/* Edit this file in -*- c -*- mode. */

/* Open Digita Services  --  Camera Device Protocol definitions.
   
   Copyright (C) 1998, 1999 James C. Thompson <jim.thompson@pobox.com>
   Copyright (C) 1998, 1999 Viljo Hakala <viljo.hakala@pcuf.fi>

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
   
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#if !defined(_receive_h_)
#define _receive_h_

#include <sys/types.h>

/* Start Editing Here: */

ODSResult	begin_rec(ODSCamera camera, unsigned long *length);
ODSResult	abort_rec(ODSCamera camera);
ODSResult	end_rec(ODSCamera camera);

ODSResult	rec_ushort(ODSCamera camera, short *s);
ODSResult	rec_uint(ODSCamera camera, UInteger * u);
ODSResult	rec_sint(ODSCamera camera, SInteger * s);
ODSResult	rec_fixed(ODSCamera camera, Fixed * f);
ODSResult	rec_boolean(ODSCamera camera, Boolean * b);
ODSResult	rec_bitflags(ODSCamera camera, BitFlags * f);
ODSResult	rec_pname(ODSCamera camera, PName * p);
ODSResult	rec_string(ODSCamera camera, String * s);
ODSResult	rec_dosname(ODSCamera camera, DOSName * d);
ODSResult	rec_ptvs(ODSCamera, PNameTypeValueStruct *);
ODSResult	rec_fileitem(ODSCamera, ResFileItem *fileitem);
ODSResult	rec_partialtag(ODSCamera camera, PartialTag *partialtag);
ODSResult	rec_bytes(ODSCamera camera, void *addr, size_t len, int);

void		dump_ptvs(PNameTypeValueStruct *);

#endif /* _receive_h_ */
       /* Do not add anything below this line! */
