/* Open Digita Services  --  Camera Device Protocol definitions.

   Copyright (C) 1998, 1999 James C. Thompson <jim.thompson@pobox.com>
   Copyright (C) 1998, 1999 Viljo Hakala <viljo.hakala@pcuf.fi>

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc., 59
   Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/*--------------------------------------------------------------------------
  System include files */

#if defined(HAVE_CONFIG_H)
#include "config.h"
#endif

#include <stdio.h>
#include <ctype.h>

/* Start Editing Here: */

int 
format_char(int c)
{
  return isprint(c) ? c : '.';
}

static char *
format_mem_char(const char *base, int *from, int to)
{
  static char	buffer[256];
  char		*s = buffer;
  int		format_from;
  int		format_to;
  int		i;

  format_from = *from - (*from % 16);
  format_to = format_from + 16;

  sprintf(s, "%08x |  ", format_from);
  s += 12;

  for (i = format_from; i < *from; i++) 
    {
      *s++ = ' ';
      *s++ = ' ';
      if (i % 2) 
	{
	  *s++ = ' ';
	}
    }

  for (; (i < to) && (i < format_to); i++) 
    {
      sprintf(s, "%02x", 0xff & base[i]);
      s += 2;
      *s++ = ' ';
    }

  for (; i < format_to; i++) 
    {
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
    }

  *s++ = ' ';
  *s++ = '|';

  for (i = format_from; i < *from; i++) 
    {
      *s++ = ' ';
    }

  for (; (i < to) && (i < format_to); i++) 
    {
      *s++ = format_char(base[i]);
    }

  /* Set return value; */
  *from = i;

  for (; i < format_to; i++) 
    {
      *s++ = ' ';
    }

  *s++ = '|';
  *s++ = '\0';

  return buffer;
}

static char *
format_mem_short(const short *base, int *from, int to)
{
  static char	buffer[256];
  char *	s = buffer;
  int		format_from;
  int		format_to;
  int		i;

  format_from = *from - (*from % 8);
  format_to = format_from + 8;

  sprintf(s, " %08x  | ", format_from);
  s += 13;

  for (i = format_from; i < *from; i++) 
    {
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
    }

  for (; (i < to) && (i < format_to); i++) 
    {
      sprintf(s, "%04hx|", base[i]);
      s += 4;
      *s++ = ' ';
    }

  for (; i < format_to; i++) 
    {
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
    }

  *s++ = ' ';
  *s++ = '|';

  for (i = format_from; i < *from; i++) 
    {
      *s++ = ' ';
      *s++ = ' ';
    }

  for (; (i < to) && (i < format_to); i++) 
    {
      *s++ = format_char((base[i] >> 8) & 0xff);
      *s++ = format_char(base[i] & 0xff);
    }

  /* Set return value; */
  *from = i;

  for (; i < format_to; i++) 
    {
      *s++ = ' ';
      *s++ = ' ';
    }

  *s++ = '|';
  *s++ = '\0';

  return buffer;
}

static char *
format_mem_long(const long *base, int *from, int to)
{
  static char	buffer[256];
  char *	s = buffer;
  int		format_from;
  int		format_to;
  int		i;

  format_from = *from - (*from % 4);
  format_to = format_from + 4;

  sprintf(s, " %08x  | ", format_from);
  s += 13;

  for (i = format_from; i < *from; i++) 
    {
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
    }

  for (; (i < to) && (i < format_to); i++) 
    {
      sprintf(s, "%08lx", base[i]);
      s += 8;
      *s++ = ' ';
      *s++ = ' ';
    }

  for (; i < format_to; i++) 
    {
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
    }

  *s++ = ' ';
  *s++ = '|';

  for (i = format_from; i < *from; i++) 
    {
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
    }

  for (; (i < to) && (i < format_to); i++) 
    {
      *s++ = format_char((base[i] >> 24) & 0xff);
      *s++ = format_char((base[i] >> 16) & 0xff);
      *s++ = format_char((base[i] >> 8) & 0xff);
      *s++ = format_char(base[i] & 0xff);
    }

  /* Set return value; */
  *from = i;

  for (; i < format_to; i++) 
    {
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
      *s++ = ' ';
    }

  *s++ = '|';
  *s++ = '\0';

  return buffer;
}

void 
format_chars(FILE * f, const char *base, int from, int to)
{
  int local_from = from;

  while (local_from < to) 
    {
      fprintf(f, "%s\n", format_mem_char(base, &local_from, to));
    }
}

void 
format_shorts(FILE * f, const short *base, int from, int to)
{
  int local_from = from;

  while (local_from < to) 
    {
      fprintf(f, "%s\n", format_mem_short(base, &local_from, to));
    }
}

void 
format_longs(FILE * f, const long *base, int from, int to)
{
  int local_from = from;

  while (local_from < to) 
    {
      fprintf(f, "%s\n", format_mem_long(base, &local_from, to));
    }
}
