/* Edit this file in -*- c -*- mode. */

/* Open Digita Services  --  type definitions
   
   Copyright (C) 1998, 1999 James C. Thompson <jim.thompson@pobox.com
   Copyright (C) 1998, 1999 Viljo Hakala <viljo.hakala@pcuf.fi>
   
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
   
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#if !defined(_defs_h_)
#define _defs_h_

/* Start Editing Here: */

/*--------------------------------------------------------------------------
  System include files */

#include <ctype.h>

#if !defined(_ENDIAN_H)
#if defined(__SVR4) /* Solaris doesn't have endian.h */ 
#else 
#if defined(__BEOS__)
#include <posix/endian.h>
#else
#include <machine/endian.h>
#endif
#endif
#endif

/* These definitions should be replaced by architecture -- independent
   equivalents, preferably by some automated process such as "configure".
   On the to-do list. */

/* These definitions are intended for use in data packets where size is
   important; in other places, conventional shorts, ints, and longs should 
   be used. */

typedef char	CHAR8;
typedef short	INT16;
typedef long	INT32;

typedef unsigned char	UCHAR8;
typedef unsigned short	UINT16;
typedef unsigned long	UINT32;

#if defined(LITTLE_ENDIAN)

/* Little-endian architectures need byte-swapping. */

#define sws(x) (((x >> 8) & 0x00ff) | ((x << 8) & 0xff00))
#define swl(x) (sws(x >> 16) | (sws(x) << 16))

#define swap_short(x) (x = sws(x))
#define swap_long(x) (x = swl(x))

#else                                   /* if !LITTLE_ENDIAN */

/* Big-endian anchictectures don't need byte-swapping. */

#define sws(x) (x)
#define swl(x) (x)

#define swap_short(x) (x = sws(x))
#define swap_long(x) (x = swl(x))

#endif					/* LITTLE_ENDIAN */


#endif /* _defs_h_ */
       /* Do not add anything below this line! */
