/* Edit this file in -*- c -*- mode. */

/* Open Digita Services  --  Camera Device Protocol definitions.
  
   Copyright (C) 1998, 1999 James C. Thompson <jim.thompson@pobox.com>
   Copyright (C) 1998, 1999 Viljo Hakala <viljo.hakala@pcuf.fi>
  
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
  
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
  
   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#if !defined(_cdp_h_)
#define _cdp_h_

#include "defs.h"

/* Start Editing Here: */

typedef UINT32	UInteger;
typedef INT32	SInteger;
typedef INT32	Fixed;
typedef UINT32	Boolean;
typedef UINT32	BitFlags;
typedef UINT32	PName;

typedef char	DOSName[16];
typedef char	ShortStr[16];
typedef char	String[32];

typedef UINT32	PNameType;
typedef UINT32	ReqLength;
typedef UINT32	ResLength;

typedef enum 
{
  kCHNoErr			= 0,
  kCHUnimplemented		= 1,
  kCHUnsupportedVersion		= 2,
  kCHAppTimeout			= 3,
  kCHInternalError		= 4,
  kCHParamError			= 5,
  kCHFileSystemFull		= 6,
  kCHFileNotFound		= 7,
  kCHDataSectionNotFound	= 8,
  kCHInvalidFileType		= 9,
  kCHUnknownDrive		= 10,
  kCHDriveNotMounted		= 11,
  kCHSystemBusy			= 12,
  kCHBatteryLow			= 13
} TCDPResult;

typedef enum 
{
  kUInteger	= 1,
  kSInteger	= 2,
  kFixed	= 3,
  kBoolean	= 4,
  kBitFlags	= 5,
  kPName	= 6,
  kDOSName	= 7,
  kString	= 8,
  kEnumList	 = 9
} ValueType;

typedef union 
{
  UInteger	UInt;
  SInteger	Int;
  Fixed		fFixed;
  Boolean	fBoolean;
  BitFlags	fBitFlags;
  PName		fPName;
  DOSName	fDOSName;
  String	fString;
} PNameValue;

typedef struct
{
  PName		Name;
  PNameValue	Data;
} PNameValueStruct;

typedef struct
{
  PName		Name;
  ValueType	Type;
  PNameValue	Value;
} PNameTypeValueStruct;

typedef struct
{
  UINT16	fVendorID;
  UINT16	FDeviceID;
} TCDPBeacon;

typedef struct
{
  int		fPodReceiveMode:2;
  int		fHostReceiveMode:2;
  UINT32	fDataSpeed;
  UINT16	fDeviceFrameSize;
  UINT16	fHostFrameSize;
} TCDPBeaconAck;

typedef struct 
{
  UINT32	fLength;
  UCHAR8	Version;
  CHAR8		fReserved[3];
  INT16		fCommand;
  INT16		fResult;
} TCDPHeader;

typedef struct 
{
  TCDPHeader	fCDPHeader;
  CHAR8		fData[1];
} TCDP;

typedef struct 
{
  UInteger	Date;
  UInteger	Time;
  SInteger	ErrorCode;
  String	ErrorDescription;
} ErrorData;

typedef struct 
{
  UInteger	Value;
  String	Descript;
} ListPair;

typedef struct 
{
  UInteger	Count;
  UInteger	Factory;
  ListPair	Data[1];
} ListData;

typedef struct 
{
  PNameValue	MinV;
  PNameValue	MaxV;
  PNameValue	Factory;
} RangeData;

typedef struct 
{
  ValueType	Type;
  PNameValue	Factory;
} ValueData;

typedef struct 
{
  PName		Name;
  ValueType	Type;
  String	Descript;
  union 
  {
    ListData	List;
    RangeData	Range;
    ValueData	TypeValue;
  } Data;
} CapabilitiesData;

typedef struct 
{
  SInteger	DriveNo;
  String	PathName;
  DOSName	DOSName;
  SInteger	FileLength;
  BitFlags	FileStatus;
} ResFileItem;

typedef struct 
{
  /* CCD specs */
  struct ccd 
  {
    UInteger	pattern;
    UInteger	pixels_horizontal;
    UInteger	pixels_vertical;
    UInteger	ring_pixels_horizontal;
    UInteger	ring_pixels_vertical;
    UInteger	bad_columns;
    UInteger	bad_pixels;
  } ccd;

  /* Thumbnail */
  struct thumbnail 
  {
    UInteger	type;
    UInteger	pixels_horizontal;
    UInteger	pixels_vertical;
    UInteger	file_size;
  } thumbnail;

  /* screennail */
  struct screennail 
  {
    UInteger	type;
    UInteger	pixels_horizontal;
    UInteger	pixels_vertical;
  } screennail;

  /* Focus zone */
  struct focus_zone 
  {
    UInteger	type;
    UInteger	number_horizontal_zones;
    UInteger	number_vertical_zones;
    UInteger	origin_horizontal_zones;
    UInteger	origin_vertical_zones;
    UInteger	horizontal_zone_size;
    UInteger	vertical_zone_size;

  } focus_zone;

  /* Exposure zone */
  struct exposure_zone 
  {
    UInteger	type;
    UInteger	number_horizontal_zones;
    UInteger	number_vertical_zones;
    UInteger	origin_horizontal_zones;
    UInteger	origin_vertical_zones;
    UInteger	horizontal_zone_size;
    UInteger	vertical_zone_size;
  } exposure_zone;
} ImageSpecificationList;

typedef struct 
{
  SInteger	DriveNo;
  String	PathName;
  DOSName	DOSName;
} FileNameStruct;

typedef struct 
{
  UInteger	Offset;
  UInteger	Length;
  UInteger	Filesize;
} PartialTag;

typedef struct 
{
  UInteger	dataSize;
  UInteger	height;
  UInteger	width;
  UInteger	type;
} ThumbnailData;

typedef struct 
{
  UInteger	ClockDate;
  UInteger	ClockTime;
} ClockDateTime;

typedef struct 
{
  UInteger	HostPollTimeOut;
  UInteger	CmdRspTimeOut;
} Timeout;

#endif
/* Do not add anything below this line! */
