/* Edit this file in -*- c -*- mode. */

/* Open Digita Services	 --  Camera Device Protocol definitions.
   
   Copyright (C) 1998, 1999 James C. Thompson <jim.thompson@pobox.com>
   Copyright (C) 1998, 1999 Viljo Hakala <viljo.hakala@pcuf.fi>
   
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
   
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#if !defined(_camera_h_)
#define _camera_h_

#include "cdp.h"

typedef struct _ODSCameraRec *ODSCamera;

/* Start Editing Here: */

typedef enum 
{
  ods_unknown,
  ods_serial,				/* NSS - Normal Speed Serial */
  ods_usb,				/* USB - Useless Serial Bus */
  ods_irda				/* IrDA - Infrared Device Access */
} ods_port_type;

typedef enum 
{
  /* Error codes 0 - 13 are as defined in cdp.h for typedef enum TCDPResult,
     so that functions returning ODSResult can return camera error codes as
     well as ODS library codes. */
  kODSNoErr			= 0,
  kODSUnimplemented		= 1,
  kODSUnsupportedVersion	= 2,
  kODSAppTimeout		= 3,
  kODSInternalError		= 4,
  kODSParamError		= 5,
  kODSFileSystemFull		= 6,
  kODSFileNotFound		= 7,
  kODSDataSectionNotFound	= 8,
  kODSInvalidFileType		= 9,
  kODSUnknownDrive		= 10,
  kODSDriveNotMounted		= 11,
  kODSSystemBusy		= 12,
  kODSBatteryLow		= 13,

  /* ODS-specific error codes start here. */
  kODSMiscError			= 14,
  kODSUnixError			= 15,	/* Means see errno for specifics */
  kODSAlreadyOpen		= 16,	/* Second attempt to open camera */
  kODSNotOpen			= 17,	/* Attempt to use unopened camera */
  kODSIOError			= 18,	/* Low-level Input/Output error */
  kODSModeError			= 19,	/* Operation doesn't match protocol
					   mode. */
  kODSBufferError		= 20,	/* Buffer over- or under-flow */
  kODSCameraBusy		= 21	 
} ODSResult;

ODSCamera	odsCreateCamera();

void		odsSetReceiveRate(ODSCamera, unsigned long);
void		odsSetSendRate(ODSCamera, unsigned long);
void		odsSetIOTimeout(ODSCamera, unsigned long);

unsigned long	odsGetReceiveRate(ODSCamera);
unsigned long	odsGetSendRate(ODSCamera);
unsigned long	odsGetIOTimeout(ODSCamera);

ODSResult	odsOpenNSS(ODSCamera,
			   const char *dev,
			   unsigned long speed);
ODSResult	odsCloseNSS(ODSCamera);

ODSResult	odsOpenUSB(ODSCamera, const char *dev);
ODSResult	odsCloseUSB(ODSCamera);

ODSResult	odsDestroyCamera(ODSCamera);
void		odsResetCamera(ODSCamera);

/* Product and Image Information Commands */

ODSResult	odsGetProductInfo(ODSCamera,
				  PName,
				  ResLength *,
				  PNameTypeValueStruct *,
				  unsigned int valuelen);

ODSResult	odsSetProductInfo(ODSCamera camera,
				  UInteger reqlength,
				  PNameTypeValueStruct *list,
				  UInteger *driveno,
				  String *path,
				  SInteger *availablespace);

ODSResult	odsGetImageSpecifications(ODSCamera camera,
					  ImageSpecificationList *specificationlist);


/* Status Commands */

ODSResult	odsGetCameraStatus(ODSCamera camera,
				   BitFlags *systemstatus,
				   BitFlags *capturestatus,
				   BitFlags *vendorstatus);

ODSResult	odsGetError(ODSCamera camera,
			    ErrorData *errordata);


/* Camera Capabilities and State Commands */

ODSResult	odsGetCameraCapabilities(ODSCamera camera,
					 PName pname,
					 UInteger *reslength,
					 CapabilitiesData *capabilitiesdata,
					 unsigned long valuelen);

ODSResult	odsGetCameraState(ODSCamera camera,
				  PName pname,
				  UInteger *reslength,
				  PNameTypeValueStruct *typevaluelist,
				  unsigned long valuelen);

ODSResult	odsSetCameraState(ODSCamera camera,
				  const PNameValueStruct *valuestruct);

ODSResult	odsGetCameraDefault(ODSCamera camera,
				    UInteger defaultsource,
				    PName pname,
				    UInteger *reslength,
				    PNameTypeValueStruct *typevaluelist,
				    unsigned long valuelen);

ODSResult	odsSetCameraDefault(ODSCamera camera,
				    UInteger updatesource,
				    PNameValueStruct *valuestruct);

ODSResult	odsRestoreCameraState(ODSCamera camera,
				      UInteger defaultsource,
				      PName pname);

/* Scene Analysis Command */

ODSResult	odsGetSceneAnalysis(ODSCamera camera,
				    UInteger analysistype,
				    Boolean preview,
				    UInteger *reslength,
				    UInteger *sceneanalysisdata);

/* Power and Capture Commands */

ODSResult	odsGetPowerMode(ODSCamera, UInteger *);
ODSResult	odsSetPowerMode(ODSCamera);
ODSResult	odsGetS1Mode(ODSCamera camera, Boolean *s1mode);
ODSResult	odsSetS1Mode(ODSCamera camera, Boolean s1mode);
ODSResult	odsStartCapture(ODSCamera camera);

/* File Commands */

ODSResult	odsGetFileList(ODSCamera,
			       UInteger listorder,
			       const FileNameStruct *filename,
			       UInteger *reslength,
			       ResFileItem *resfilelist,
			       int resfilelen);

ODSResult	odsGetNewFileList(ODSCamera camera,
				  UInteger *reslength,
				  ResFileItem *resfilelist,
				  unsigned int valuelen);

ODSResult	odsGetFileData(ODSCamera camera,
			       const FileNameStruct *filename,
			       UInteger dataselector,
			       PartialTag *partialtag,
			       void *filedata,
			       UInteger *thumb_len,
			       UInteger *thumb_w,
			       UInteger *thumb_h,
			       UInteger *unknown);

ODSResult	odsSetFileData(ODSCamera camera,
			       const FileNameStruct *filename,
			       UInteger dataselector,
			       const PartialTag *partialtag,
			       const void *filedata);

ODSResult	odsEraseFile(ODSCamera camera,
			     const FileNameStruct *filename);

ODSResult	odsGetStorageStatus(ODSCamera camera,
				    UInteger *takencount,
				    UInteger *availablecount,
				    SInteger *rawcount);

ODSResult	odsGetFileTag(ODSCamera camera,
			      const FileNameStruct *name,
			      PName pname,
			      ResLength *reslength,
			      PNameTypeValueStruct *valuelist,
			      int valuelen);

ODSResult	odsSetUserFileTag(ODSCamera camera,
				  const FileNameStruct *filename,
				  const PNameValueStruct *valuestruct);

/* Clock Commands */

ODSResult	odsGetClock(ODSCamera camera,
			    ClockDateTime *datetime);

ODSResult	odsSetClock(ODSCamera camera,
			    const ClockDateTime *datetime);

ODSResult	odsGetInterfaceTimeout(ODSCamera camera,
				       Timeout *timeout);

ODSResult	odsSetInterfaceTimeout(ODSCamera camera,
				       const Timeout *timeout);

#endif /* _camera_h_ */
       /* Do not add anything below this line! */
