/*
 * ntesla - a program for designing Tesla Coils
 * 
 * Copyright (C) 1997  Steven A. Falco
 * 
 * Email contact: sfalco@worldnet.att.net
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define EXTERN extern
#include "protos.h"

void
findR()
{
	Tcparms.misc_res = Tcparms.misc_volt / Tcparms.misc_amp;
}

void
findV()
{
	Tcparms.misc_volt = Tcparms.misc_amp * Tcparms.misc_res;
}

void
findA()
{
	Tcparms.misc_amp = Tcparms.misc_volt / Tcparms.misc_res;
}

void
findC()
{
	Tcparms.misc_cap = 
	  1e6 / (pow(2.0 * PI * Tcparms.misc_freq, 2.0) * Tcparms.misc_ind);
}

void
findL()
{
	Tcparms.misc_ind =
	  1e6 / (pow(2.0 * PI * Tcparms.misc_freq, 2.0) * Tcparms.misc_cap);
}

void
findF()
{
	Tcparms.misc_freq =
	  1e3 / (2.0 * PI * sqrt(Tcparms.misc_ind * Tcparms.misc_cap));
}

/* Miscellaneous menu */
void
misc()
{
	char buf[BS];
	int iii;
	double tmpval;

	/* Calculate dependent parameters */
	findF();
	findV();

	while(1) {
		
		/* Build the screen image */
		Row = 0;
S "  *Inductance %g uH and *Capacitance %g uF\n",
     Tcparms.misc_ind, Tcparms.misc_cap);
S "  resonate at *Frequency %g kHz\n", Tcparms.misc_freq);
S "\n");
S "  %g *Amps through %g *Ohms\n", Tcparms.misc_amp, Tcparms.misc_res);
S "  drops %g *Volts\n", Tcparms.misc_volt);
S "\n");
S "  *Wire diameter %s,  *Spool diameter %s, *Length of spool %s\n",
     UnitOut((void *)&Tcparms.spool_wd, Tcparms.units ? TOINCH : TOCM, Ub0),
     UnitOut((void *)&Tcparms.spool_cd, Tcparms.units ? TOINCH : TOCM, Ub1),
     UnitOut((void *)&Tcparms.spool_len, Tcparms.units ? TOINCH : TOCM, Ub2));
S "  *Gauge of wire %s\n",
     UnitOut((void *)&Tcparms.spool_wire, Tcparms.units ? TOBS : TOWMM, Ub0));
     	/* Find cubic inches of winding space */
	tmpval = (pow(Tcparms.spool_wd, 2.0) - pow(Tcparms.spool_cd, 2.0))
	         * (PI / 4.0) * Tcparms.spool_len;
	/* Divide by square inches per turn of wire */
	tmpval /= pow(Tcparms.spool_wire.thick, 2.0) * (PI / 4.0) / SPOOLFACTOR;
	/* Allow for finer wire sizes packing less tightly */
	tmpval *= (7.5 - (0.05 * Tcparms.spool_wire.gauge)) / 7.0;
S "\n");
S "Spool holds approximately %s of wire.\n",
     UnitOut((void *)&tmpval, Tcparms.units ? TOFEET : TOMETER, Ub0));
S "\n");

		/* Clear the screen, then display the menu */
		CLEAR_SCREEN; for(iii = 0; iii < Row; iii++) P Display[iii]);

		/* Put up general instructions */
		general_instructions();

		/* Get the users choice */
		if(fgets(buf, BS, stdin) == NULL) {
			/* We are done */
			break;
		}

		switch(tolower(buf[0])) {

		  case 'i':
		  	Tcparms.misc_ind = atof(buf + 1);
			P "Enter 'c' to find capacitor, or 'f' to find frequency > ");
			if(fgets(buf, BS, stdin) == NULL) {
				/* We are done */
				break;
			}
			if(tolower(buf[0]) == 'c') {
				findC();
			} else {
				findF();
			}
		  	break;

		  case 'c':
		  	Tcparms.misc_cap = atof(buf + 1);
			P "Enter 'i' to find inductor, or 'f' to find frequency > ");
			if(fgets(buf, BS, stdin) == NULL) {
				/* We are done */
				break;
			}
			if(tolower(buf[0]) == 'i') {
				findL();
			} else {
				findF();
			}
		  	break;

		  case 'f':
		  	Tcparms.misc_freq = atof(buf + 1);
			P "Enter 'i' to find inductor, or 'c' to find capacitor > ");
			if(fgets(buf, BS, stdin) == NULL) {
				/* We are done */
				break;
			}
			if(tolower(buf[0]) == 'i') {
				findL();
			} else {
				findC();
			}
		  	break;

		  case 'a':
		  	Tcparms.misc_amp = atof(buf + 1);
			P "Enter 'v' to find volts, or 'r' to find resistor > ");
			if(fgets(buf, BS, stdin) == NULL) {
				/* We are done */
				break;
			}
			if(tolower(buf[0]) == 'v') {
				findV();
			} else {
				findR();
			}
		  	break;

		  case 'v':
		  	Tcparms.misc_volt = atof(buf + 1);
			P "Enter 'a' to find amps, or 'r' to find resistor > ");
			if(fgets(buf, BS, stdin) == NULL) {
				/* We are done */
				break;
			}
			if(tolower(buf[0]) == 'a') {
				findA();
			} else {
				findR();
			}
		  	break;

		  case 'o':
		  	Tcparms.misc_res = atof(buf + 1);
			P "Enter 'a' to find amps, or 'v' to find volts > ");
			if(fgets(buf, BS, stdin) == NULL) {
				/* We are done */
				break;
			}
			if(tolower(buf[0]) == 'a') {
				findA();
			} else {
				findV();
			}
		  	break;

		  case 'w':
		  	UnitIn(atof(buf + 1), (void *)&Tcparms.spool_wd,
			  Tcparms.units ? TOINCH : TOCM);
		  	break;

		  case 's':
		  	UnitIn(atof(buf + 1), (void *)&Tcparms.spool_cd,
			  Tcparms.units ? TOINCH : TOCM);
		  	break;

		  case 'l':
		  	UnitIn(atof(buf + 1), (void *)&Tcparms.spool_len,
			  Tcparms.units ? TOINCH : TOCM);
		  	break;

		  case 'g':
			UnitIn(atof(buf + 1), (void *)&Tcparms.spool_wire,
			  Tcparms.units ? TOBS : TOWMM);
		  	break;

		  case 'h':
		  	misc_help();
			break;

		  case 'p':
		  	print_buf();
			break;

		  case 'q':
		  	save_parms();
			EXIT(0);

		  case 'r':
		  	return;

		  case '\n':
		  case '\r':
		  	break;

		  default:
			E "\007Sorry - %c is illegal - try again ", buf[0]);
			break;
		}
	}

	return;
}

void
misc_help()
{
	char buf[BS];
	int iii;

	while(1) {
		
		/* Build the screen image */
		Row = 0;
S "This screen can be used to find the resonant frequency of a capacitor/inductor\n");
S "tank.  Alternately, you can set the desired frequency, then solve for the\n");
S "required capacitance or inductance.\n");
S "\n");
S "Similarly, you can calculate the voltage drop across a resistor with a given\n");
S "current through it, or you can specify the voltage and calculate the needed\n");
S "resistance or current.\n");
S "\n");
S "Also, if you have a spool of wire, you can estimate the length of wire on the\n");
S "spool.  Enter the diameter of the outer turns of wire as parameter W, and the\n");
S "diameter of the spool as parameter S.  The length of the spool from flange to\n");
S "flange is parameter L, and the gauge of the wire is parameter G.  Note that\n");
S "the estimate takes a variable packing factor into account - fine wire\n");
S "typically wastes up to 25%%%% of the available space in a random-wound coil as.\n");
S "opposed to thick wire.\n");
S "\n");

		/* Clear the screen, then display the menu */
		CLEAR_SCREEN; for(iii = 0; iii < Row; iii++) P Display[iii]);

		/* Put up help instructions */
		help_instructions();

		/* Get the users choice */
		if(fgets(buf, BS, stdin) == NULL) {
			/* We are done */
			break;
		}

		switch(tolower(buf[0])) {

		  case 'p':
		  	print_buf();
			break;

		  case 'q':
		  	save_parms();
			EXIT(0);

		  case 'r':
		  	return;

		  case '\n':
		  case '\r':
		  	break;

		  default:
			E "\007Sorry - %c is illegal - try again ", buf[0]);
			break;
		}
	}

	return;
}
