/* $Id: log.h,v 1.3 2002/03/24 13:05:47 proff Exp $
 * $Copyright$
 */

#ifndef LOG_H
#define LOG_H

/*
 * if anyone can work out how to do this in one syslog call, without
 * using vsprintf, I'd dearly like to know. CPP IS LAME.
 *
 * You need to call these macros like so:
 *
 *	logd(("messge id %s", msgid));
 */

#define logt(x) \
do\
{\
	syslog(LOG_DEBUG, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
} while(0)

#define logl(x) \
do\
{\
	if (con->logListMerge)\
	{\
		syslog(LOG_DEBUG, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define logn(x) \
do\
{\
	if (con->logNocem)\
	{\
		syslog(LOG_DEBUG, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define loglc(x) \
do\
{\
	if (con->logListMergeCorrelation)\
	{\
		syslog(LOG_DEBUG, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define logd(x) \
do\
{\
	if (con->logDebug)\
	{\
		syslog(LOG_DEBUG, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define loge(x) \
do\
{\
	if (con->logErrors)\
	{\
		syslog(LOG_ERR, (errno ? "%s:%d:%m: %s" : "%s:%d: %s"), __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define logen(x) \
do\
{\
	if (con->logErrors)\
	{\
		syslog(LOG_ERR, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define logw(x) \
do\
{\
	if (con->logWarnings)\
	{\
		syslog(LOG_WARNING, (errno ? "%s:%d:%m: %s" : "%s:%d: %s"), __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define logwn(x) \
do\
{\
	if (con->logWarnings)\
	{\
		syslog(LOG_WARNING, "%s:%d: %s", __FILE__, __LINE__, logPrint x);\
	}\
} while(0)

#define log(x) \
do\
{\
	if (con->logInfo)\
	{\
		syslog(LOG_INFO, "%s", logPrint x);\
	}\
} while(0)

#define loginne(x) \
do\
{\
	if (con->logErrors && con->logInn)\
	{\
		syslog(LOG_ERR, "%s", logPrint x);\
	}\
} while(0)

#define loginnw(x) \
do\
{\
	if (con->logWarnings && con->logInn)\
	{\
		syslog(LOG_WARNING, "%s", logPrint x);\
	}\
} while(0)

#define loginn(x) \
do\
{\
	if (con->logInfo && con->logInn)\
	{\
		syslog(LOG_INFO, "%s", logPrint x);\
	}\
} while(0)


#include "log.ext"

#endif /* LOG_H */
