/*
 * tabkey.c: Ninja IRC tab completion
 *
 * written by Joshua J. Drake and Kraig Amador
 */

#include "irc.h"
#include "dma.h"

#include "tabkey.h"

#include "input.h"
#include "ircaux.h"
#include "list.h"
#include "vars.h"

static Reply *tabkey_array = (Reply *) 0;

/*
 * tab reply!
 */
void
tab_reply(u_int dumb, u_char *dumber)
{
   u_char *tmp = NULL;
   u_char *cmdchar = NULL;

   tmp = get_tab_key(1);
   if (tmp && *tmp)
     {
	u_char tmp1[1024], *p;
	
	if (!(cmdchar = get_string_var(CMDCHARS_VAR)))
	   cmdchar = "/";
	input_clear_line('\0', NULL);
	snprintf(tmp1, sizeof(tmp1)-1, "%s%s ", cmdchar, tmp);
	p = tmp1;
	while (p && *p)
	  input_add_character(*p++, NULL);
     }
}

void
add_tab_key(int times, u_char *prompt, u_char *targ)
{
   Reply *new, *tmp;
   u_char tb[128];
   
   if (!prompt || !targ)
     return;
   my_strmcpy(tb, prompt, sizeof(tb)-1);
   my_strmcat(tb, targ, sizeof(tb)-1);

   tmp = tabkey_array;
   if (!tmp || 
       !(new = (Reply *) remove_from_list((List **) & tmp, tb)))
     {
	new = (Reply *) dma_Malloc(sizeof(Reply));
	dma_strcpy(&(new->nick), tb);
	new->times = times;
     }
   new->last_used = time(NULL);
   new->next = tmp;
   tabkey_array = new;
}

u_char *
get_tab_key(int direction)
{
   Reply *tmp, *new;
   static u_char tb[128];

   tmp = new = tabkey_array;
   if (!tmp)
     return NULL;
   if (new->next)
     {
	tabkey_array = new->next;
	new->next = NULL;
	tmp = tabkey_array;
	while (tmp)
	  {
	     if (tmp->next)
	       tmp = tmp->next;
	     else
	       break;
	  }
	tmp->next = new;
     }
   if (new->times)
     {
	tmp = (Reply *) remove_from_list((List **) & tabkey_array, new->nick);
	my_strmcpy(tb, tmp->nick, sizeof(tb)-1);
	dma_Free(&tmp->nick);
	dma_Free(&tmp);
	return tb;
     }
   if (new && new->nick)
     return new->nick;
   return NULL;
}

#ifndef NFREQ_TAB_KEY_EXPIRE
# define NFREQ_TAB_KEY_EXPIRE	3600 /* default, 1 hour */
#endif
/*
 * expire tab reply entries...
 */
void
nchk_tabkeys(current)
   time_t current;
{
   Reply *tmp, *tmp2;

   tmp = tabkey_array;
   while (tmp)
     {
	if ((current - tmp->last_used) > NFREQ_TAB_KEY_EXPIRE)
	  {
	     if ((tmp2 = (Reply *) remove_from_list((List **) & tabkey_array, tmp->nick)) != NULL)
	       {
		  tmp = tmp2->next;
		  dma_Free(&tmp2->nick);
		  dma_Free(&tmp2);
	       }
	  }
	else
	  tmp = tmp->next;
     }
}
