#include <haskell2c.h>
#include "cLowBinary.h"
#include "cLowUnboxedArray.h"

int hs_putUBA (BinHandle bh,UBA uba)
{ unsigned int p;
  /* BH is always a file - never memory */
   unsigned temp;
   p = vtell(bh);
   closecache(bh);
   vsync(bh);
   temp = htonl(0);	/* some extra padding, just in case */
   write(bh->loc.fd,&temp,sizeof(unsigned));
   temp = htonl(uba->free);
   write(bh->loc.fd,&temp,sizeof(unsigned));
   temp = htonl(uba->write);
   write(bh->loc.fd,&temp,sizeof(unsigned));
   temp = htonl(uba->end);
   write(bh->loc.fd,&temp,sizeof(unsigned));
   write(bh->loc.fd,uba->block,uba->write*sizeof(unsigned));
   opencache(bh);
  return p;
}


void * hs_getUBA (BinHandle bh)
{ UBA uba;
  /* BH is always a file - never memory */
   unsigned temp;
   closecache(bh);
   vsync(bh);
   uba = (UBA)malloc(sizeof(struct UnboxedArray));
   read(bh->loc.fd,&temp,sizeof(unsigned));	/* read and ignore padding */
   read(bh->loc.fd,&temp,sizeof(unsigned));
   uba->free = ntohl(temp);
   read(bh->loc.fd,&temp,sizeof(unsigned));
   uba->write = ntohl(temp);
   read(bh->loc.fd,&temp,sizeof(unsigned));
   uba->end = ntohl(temp);
   uba->block = (unsigned*)malloc((uba->write+uba->free)*sizeof(unsigned));
   read(bh->loc.fd,uba->block,uba->write*sizeof(unsigned));
   opencache(bh);
  return nhc_mkCInt((int)allocForeignObj((void*)uba,(gcCval)finaliseUBA,gcNow));
}
