/*
 * Copyright (c) 1981 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)curses.h	5.9 (Berkeley) 7/1/90
 */

#ifndef WINDOW

#include	<stdio.h>
#include	<sys/types.h>

#if defined(NO_U_LONG) && !defined(u_long)
#define u_long	unsigned long
#define u_short unsigned short
#define u_char	unsigned char
#endif
 
#ifdef USE_SGTTY
#define USE_OLD_TTY
#include	<sys/ioctl.h>
#undef USE_OLD_TTY
#endif
#ifdef USE_TERMIO
#include	<termio.h>
#endif
#ifdef USE_TERMIOS
#include	<termios.h>
#include	<unistd.h>
#ifndef TAB3
#define TAB3	0
#endif
#ifndef IUCLC
#define IUCLC	0
#endif
#endif

#define	bool	char
#define	reg	register

#ifndef TRUE
#define	TRUE	(1)
#endif
#ifndef FALSE
#define	FALSE	(0)
#endif
#define	ERR	(0)
#define	OK	(1)

#define	_ENDLINE	000000000001
#define	_FULLWIN	000000000002
#define	_SCROLLWIN	000000000004
#define	_FLUSH		000000000010
#define	_FULLLINE	000000000020
#define	_IDLINE		000000000040
#define	_STANDOUT	000001000000
#define	_KANJI_1st	000002000000
#define	_KANJI_2nd	000004000000
#define	_NOCHANGE	-1

#define	_puts(s)	tputs(s, 0, _putchar)

#ifdef USE_SGTTY	/* for former BSD */
typedef	struct sgttyb	SGTTY;
#endif
#ifdef USE_TERMIO	/* for System V */
typedef struct termio	SGTTY;
#endif
#ifdef USE_TERMIOS	/* for POSIX */
typedef struct termios	SGTTY;
#endif

typedef u_long _y_t;
/*
 * Capabilities from termcap
 */

extern bool     AM, BS, CA, DA, DB, EO, HC, IN, MI, MS, NC, NS, OS, UL,
		XB, XN, XT, XS, XX;
extern char	*AL, *BC, *BT, *CD, *CE, *CL, *CM, *CR, *CS, *DC, *DL,
		*DM, *DO, *ED, *EI, *K0, *K1, *K2, *K3, *K4, *K5, *K6,
		*K7, *K8, *K9, *HO, *IC, *IM, *IP, *KD, *KE, *KH, *KL,
		*KR, *KS, *KU, *LL, *MA, *ND, *NL, *RC, *SC, *SE, *SF,
		*SO, *SR, *TA, *TE, *TI, *UC, *UE, *UP, *US, *VB, *VS,
		*VE, *AL_PARM, *DL_PARM, *UP_PARM, *DOWN_PARM,
		*LEFT_PARM, *RIGHT_PARM;
extern char	PC;

/*
 * From the tty modes...
 */

extern bool	GT, NONL, UPPERCASE, normtty, _pfast;

struct _win_st {
	short		_cury, _curx;
	short		_maxy, _maxx;
	short		_begy, _begx;
	short		_ch_off;
	u_long		_flags;
	bool		_clear;
	bool		_leave;
	bool		_scroll;
	_y_t		**_y;
	short		*_firstch;
	short		*_lastch;
	struct _win_st	*_nextp, *_orig;
};

#define	WINDOW	struct _win_st

extern bool	My_term, _echoit, _rawmode, _endwin;

extern char	*Def_term, ttytype[];

extern int	LINES, COLS, _tty_ch;

#ifdef USE_SGTTY
extern int	_res_flg;
#endif
#ifdef USE_TERMIO
extern SGTTY	_res_tty;
#endif
#ifdef USE_TERMIOS
extern SGTTY	_res_tty;
#endif

extern SGTTY	_tty;

extern WINDOW	*stdscr, *curscr;

#ifndef XTABS	/* for HP-UX */
#define	XTABS	TAB3
#endif

#ifdef USE_TERMCAP
#define	SIZEOF_TTYTYPE	sizeof(ttytype)
#endif
#ifdef USE_TERMINFO
#define	SIZEOF_TTYTYPE	50	/* pessimistic assumption */
#endif

/*
 *	Define VOID to stop lint from generating "null effect"
 * comments.
 */
#ifdef lint
int	__void__;
#define	VOID(x)	(__void__ = (int) (x))
#else
#define	VOID(x)	(x)
#endif

/*
 * psuedo functions for standard screen
 */
#define	addch(ch)	VOID(waddch(stdscr, ch))
#define	getch()		VOID(wgetch(stdscr))
#define	addbytes(da,co)	VOID(waddbytes(stdscr, da,co))
#define	addstr(str)	VOID(waddbytes(stdscr, str, strlen(str)))
#define	getstr(str)	VOID(wgetstr(stdscr, str))
#define	move(y, x)	VOID(wmove(stdscr, y, x))
#define	clear()		VOID(wclear(stdscr))
#define	erase()		VOID(werase(stdscr))
#define	clrtobot()	VOID(wclrtobot(stdscr))
#define	clrtoeol()	VOID(wclrtoeol(stdscr))
#define	insertln()	VOID(winsertln(stdscr))
#define	deleteln()	VOID(wdeleteln(stdscr))
#define	refresh()	VOID(wrefresh(stdscr))
#define	inch()		VOID(winch(stdscr))
#define	insch(c)	VOID(winsch(stdscr,c))
#define	delch()		VOID(wdelch(stdscr))
#define	standout()	VOID(wstandout(stdscr))
#define	standend()	VOID(wstandend(stdscr))

/*
 * mv functions
 */
#define	mvwaddch(win,y,x,ch)	VOID(wmove(win,y,x)==ERR?ERR:waddch(win,ch))
#define	mvwgetch(win,y,x)	VOID(wmove(win,y,x)==ERR?ERR:wgetch(win))
#define	mvwaddbytes(win,y,x,da,co) \
		VOID(wmove(win,y,x)==ERR?ERR:waddbytes(win,da,co))
#define	mvwaddstr(win,y,x,str) \
		VOID(wmove(win,y,x)==ERR?ERR:waddbytes(win,str,strlen(str)))
#define mvwgetstr(win,y,x,str)  VOID(wmove(win,y,x)==ERR?ERR:wgetstr(win,str))
#define	mvwinch(win,y,x)	VOID(wmove(win,y,x) == ERR ? ERR : winch(win))
#define	mvwdelch(win,y,x)	VOID(wmove(win,y,x) == ERR ? ERR : wdelch(win))
#define	mvwinsch(win,y,x,c)	VOID(wmove(win,y,x) == ERR ? ERR:winsch(win,c))
#define	mvaddch(y,x,ch)		mvwaddch(stdscr,y,x,ch)
#define	mvgetch(y,x)		mvwgetch(stdscr,y,x)
#define	mvaddbytes(y,x,da,co)	mvwaddbytes(stdscr,y,x,da,co)
#define	mvaddstr(y,x,str)	mvwaddstr(stdscr,y,x,str)
#define mvgetstr(y,x,str)       mvwgetstr(stdscr,y,x,str)
#define	mvinch(y,x)		mvwinch(stdscr,y,x)
#define	mvdelch(y,x)		mvwdelch(stdscr,y,x)
#define	mvinsch(y,x,c)		mvwinsch(stdscr,y,x,c)

/*
 * psuedo functions
 */

#define	clearok(win,bf)	 (win->_clear = bf)
#define	leaveok(win,bf)	 (win->_leave = bf)
#define	scrollok(win,bf) (win->_scroll = bf)
#define flushok(win,bf)	 (bf ? (win->_flags |= _FLUSH):(win->_flags &= ~_FLUSH))
#define	getyx(win,y,x)	 y = win->_cury, x = win->_curx
#define	winch(win)	 (win->_y[win->_cury][win->_curx] & 0377)

#ifdef USE_SGTTY
#define raw()	 (_tty.sg_flags|=RAW, _pfast=_rawmode=TRUE, \
	ioctl(_tty_ch, TIOCSETP, &_tty))
#define noraw()	 (_tty.sg_flags&=~RAW,_rawmode=FALSE,\
	_pfast=!(_tty.sg_flags&CRMOD),ioctl(_tty_ch, TIOCSETP, &_tty))
#define cbreak() (_tty.sg_flags |= CBREAK, _rawmode = TRUE, \
	ioctl(_tty_ch, TIOCSETP, &_tty))
#define nocbreak() (_tty.sg_flags &= ~CBREAK,_rawmode=FALSE, \
	ioctl(_tty_ch, TIOCSETP, &_tty))
#define crmode() cbreak()	/* backwards compatability */
#define nocrmode() nocbreak()	/* backwards compatability */
#define echo()	 (_tty.sg_flags |= ECHO, _echoit = TRUE, \
	ioctl(_tty_ch, TIOCSETP, &_tty))
#define noecho() (_tty.sg_flags &= ~ECHO, _echoit = FALSE, \
	ioctl(_tty_ch, TIOCSETP, &_tty))
#define nl()	 (_tty.sg_flags |= CRMOD,_pfast = _rawmode, \
	ioctl(_tty_ch, TIOCSETP, &_tty))
#define nonl()	 (_tty.sg_flags &= ~CRMOD, _pfast = TRUE, \
	ioctl(_tty_ch, TIOCSETP, &_tty))
#define	savetty() ((void) ioctl(_tty_ch, TIOCGETP, &_tty), \
	_res_flg = _tty.sg_flags)
#define	resetty() (_tty.sg_flags = _res_flg, \
	_echoit = ((_res_flg & ECHO) == ECHO), \
	_rawmode = ((_res_flg & (CBREAK|RAW)) != 0), \
	_pfast = ((_res_flg & CRMOD) ? _rawmode : TRUE), \
	(void) ioctl(_tty_ch, TIOCSETP, &_tty))

#define	erasechar()	(_tty.sg_erase)
#define	killchar()	(_tty.sg_kill)
#define baudrate()	(_tty.sg_ospeed)
#endif /* USE_SGTTY */

#ifdef USE_TERMIO
#define raw()	 (_tty.c_iflag &= ~(ICRNL|IXON),\
	_tty.c_oflag &= ~OPOST,\
	_tty.c_lflag &= ~(ICANON|ISIG),\
	_tty.c_cc[VMIN] = 1, _tty.c_cc[VTIME] = 0,\
	_pfast = _rawmode = TRUE,\
	ioctl(_tty_ch, TCSETA, &_tty))
#define noraw()	 (_tty.c_iflag |= (ICRNL|IXON),\
	_tty.c_oflag |= OPOST,\
	_tty.c_lflag |= (ICANON|ISIG),\
	_tty.c_cc[VEOF] = 0x04, _tty.c_cc[VEOL] = 0,\
	_rawmode = _pfast = FALSE,\
	ioctl(_tty_ch, TCSETA, &_tty))
#define cbreak() (/* _tty.c_iflag &= ~ICRNL, */\
	_tty.c_oflag &= ~OPOST,\
	_tty.c_lflag &= ~ICANON,\
	_tty.c_cc[VMIN] = 1, _tty.c_cc[VTIME] = 0,\
	_pfast = _rawmode = TRUE,\
	ioctl(_tty_ch, TCSETA, &_tty))
#define nocbreak() (/* _tty.c_iflag |= ICRNL, */\
	_tty.c_oflag |= OPOST,\
	_tty.c_lflag |= ICANON,\
	_tty.c_cc[VEOF] = 0x04, _tty.c_cc[VEOL] = 0,\
	_rawmode = _pfast = FALSE,\
	ioctl(_tty_ch, TCSETA, &_tty))
#define crmode() cbreak()	/* backwards compatability */
#define nocrmode() nocbreak()	/* backwards compatability */
#define echo()	 (_tty.c_lflag |= ECHO,\
	_echoit = TRUE,\
	ioctl(_tty_ch, TCSETA, &_tty))
#define noecho() (_tty.c_lflag &= ~ECHO,\
	_echoit = FALSE,\
	ioctl(_tty_ch, TCSETA, &_tty))
#define nl()	 (/* _tty.c_iflag |= ICRNL, */\
	_tty.c_oflag |= OPOST,\
	_pfast = FALSE,\
	ioctl(_tty_ch, TCSETA, &_tty))
#define nonl()	 (/* _tty.c_iflag &= ~ICRNL, */\
	_tty.c_oflag &= ~OPOST,\
	_pfast = TRUE,\
	ioctl(_tty_ch, TCSETA, &_tty))
#define	savetty() ((void) ioctl(_tty_ch, TCGETA, &_tty),\
	_res_tty = _tty)
#define	resetty() (_tty = _res_tty,\
	_echoit = ((_res_tty.c_lflag & ECHO) == ECHO),\
	_rawmode = ((_res_tty.c_lflag & ICANON) == 0),\
	_pfast = ((_res_tty.c_oflag & OPOST) == 0),\
	(void) ioctl(_tty_ch, TCSETA, &_tty))

#define	erasechar()	(_tty.c_cc[VERASE])
#define	killchar()	(_tty.c_cc[VKILL])
#define baudrate()	(_tty.c_cflag & CBAUD)
#endif /* USE_TERMIO */

#ifdef USE_TERMIOS
#define raw()	 (_tty.c_iflag &= ~(ICRNL|IXON),\
	_tty.c_oflag &= ~OPOST,\
	_tty.c_lflag &= ~(ICANON|ISIG),\
	_tty.c_cc[VMIN] = 1, _tty.c_cc[VTIME] = 0,\
	_pfast = _rawmode = TRUE,\
	tcsetattr(_tty_ch, TCSANOW, &_tty))
#define noraw()	 (_tty.c_iflag |= (ICRNL|IXON),\
	_tty.c_oflag |= OPOST,\
	_tty.c_lflag |= (ICANON|ISIG),\
	_tty.c_cc[VEOF] = 0x04, _tty.c_cc[VEOL] = 0,\
	_rawmode = _pfast = FALSE,\
	tcsetattr(_tty_ch, TCSANOW, &_tty))
#define cbreak() (/* _tty.c_iflag &= ~ICRNL, */\
	_tty.c_oflag &= ~OPOST,\
	_tty.c_lflag &= ~ICANON,\
	_tty.c_cc[VMIN] = 1, _tty.c_cc[VTIME] = 0,\
	_pfast = _rawmode = TRUE,\
	tcsetattr(_tty_ch, TCSANOW, &_tty))
#define nocbreak() (/* _tty.c_iflag |= ICRNL, */\
	_tty.c_oflag |= OPOST,\
	_tty.c_lflag |= ICANON,\
	_tty.c_cc[VEOF] = 0x04, _tty.c_cc[VEOL] = 0,\
	_rawmode = _pfast = FALSE,\
	tcsetattr(_tty_ch, TCSANOW, &_tty))
#define crmode() cbreak()	/* backwards compatability */
#define nocrmode() nocbreak()	/* backwards compatability */
#define echo()	 (_tty.c_lflag |= ECHO,\
	_echoit = TRUE,\
	tcsetattr(_tty_ch, TCSANOW, &_tty))
#define noecho() (_tty.c_lflag &= ~ECHO,\
	_echoit = FALSE,\
	tcsetattr(_tty_ch, TCSANOW, &_tty))
#define nl()	 (_tty.c_iflag |= ICRNL,\
	_tty.c_oflag |= OPOST,\
	_pfast = FALSE,\
	tcsetattr(_tty_ch, TCSANOW, &_tty))
#define nonl()	 (_tty.c_iflag &= ~ICRNL,\
	_tty.c_oflag &= ~OPOST,\
	_pfast = TRUE,\
	tcsetattr(_tty_ch, TCSANOW, &_tty))
#define	savetty() ((void) tcgetattr(_tty_ch, &_tty),\
	_res_tty = _tty)
#define	resetty() (_tty = _res_tty,\
	_echoit = ((_res_tty.c_lflag & ECHO) == ECHO),\
	_rawmode = ((_res_tty.c_lflag & ICANON) == 0),\
	_pfast = ((_res_tty.c_oflag & OPOST) == 0),\
	(void) tcsetattr(_tty_ch, TCSANOW, &_tty))

#define	erasechar()	(_tty.c_cc[VERASE])
#define	killchar()	(_tty.c_cc[VKILL])
#define baudrate()	cfgetospeed(&_tty)
#endif /* USE_TERMIOS */

WINDOW	*initscr(), *newwin(), *subwin();
char	*longname(), *getcap();

/*
 * Used to be in unctrl.h.
 */
#define	unctrl(c)	_unctrl[(c) & 0377]
extern char *_unctrl[];
#endif
