.\" Copyright (c) 1980, 1991 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"     @(#)which.1	6.3 (Berkeley) 4/23/91
.\"
.Dd April 23, 1991
.Dt WHICH 1
.Os BSD 3
.Sh NAME
.Nm which
.Nd "locate a program file including aliases and paths"
.Pq Xr csh 1
only)
.Sh SYNOPSIS
.Nm which
.Op Ar name
.Ar ...
.Sh DESCRIPTION
.Nm Which
takes a list of names and looks for the files which would be
executed had these names been given as commands.
Each argument is expanded if it is aliased,
and searched for along the user's path.
Both aliases and path are taken from the user's
.Pa \&.cshrc
file.
.Sh FILES
.Bl -tag -width ~/\&.cshrc
.It Pa ~/\&.cshrc
source of aliases and path values
.El
.Sh DIAGNOSTICS
A diagnostic is given for names which are aliased to more than a single
word,
or if an executable file with the argument name was not found in the path.
.Sh BUGS
Must be executed by a
.Xr csh 1 ,
or some other shell which knows about aliases.
.Sh HISTORY
The
.Nm
command appeared in
.Bx 3.0 .
