.\" this document requires the tmac.kbird macros
.\"
.\" $(TROFF) $(MSMACROS) tmac.kbird thisfile
.\"
.\" revision date - change whenever this file is edited
.ds RD 2001-11-19
.\"
.EH 'itools-R6.3 README'- % -''
.OH ''- % -'itools-R6.3 README'
.OF 'Revision date:\0\0\*(RD''Printed:\0\0\n(dy \*(MO 20\n(yr'
.EF 'Revision date:\0\0\*(RD''Printed:\0\0\n(dy \*(MO 20\n(yr'
.\"
.TL
.ps +2
itools-R6.3 README
.ps
.AU
Paul DuBois
.H*ahref mailto:paul@kitebird.com
paul@kitebird.com
.H*aend
.AI
.H*aend
Revision date:\0\0\*(RD
.\"
.H*toc*title "Table of Contents"
.\"
.\"
.Ah "Introduction"
.\"
.LP
The
.I itools
distribution contains
.I imake ,
some related configuration programs,
and a set of X11 configuration files.
Instructions for building and installing the distribution
may be found in Appendix B of the "boa book":
.Ps
Software Portability with imake (2nd edition)
Paul DuBois
O'Reilly & Associates, 1996
ISBN 1-56592-055-4
.Pe
Appendix B is also available online at:
.Ps
.H*ahref http://www.dubois.ws/software/imake-book/
http://www.dubois.ws/software/imake-book/
.H*aend
.Pe
or at the same location from which you obtained the
.I itools
distribution.
.LP
Most of this distribution was derived directly from the distribution
of the X Window System, Version 11, Release 6.3, patchlevel 1.
.LP
IMPORTANT: To build this distribution, you must have an ANSI C
compiler.
If you don't have one, or you encounter other problems
building the distribution, try building the
.I itools-R6.1
distribution instead.
(If you have problems other than the lack of an ANSI C
compiler, please send me a description of what goes wrong.
You may have found a bug in the distribution that can be fixed.)
.\"
.Ah "Before You Build"
.\"
.LP
Before you build the distribution, there are a few things you should check.
.LP
Look in the
.I config/misc
directory to see if there are any notes for the type of system you're using.
If there are, read them.
.LP
Take a look at
.I config/cf/site.def
and read the comments to see if there's anything you'd like to modify.
.LP
Take a look at
.I config/extras/extras.tmpl
and check the following:
.LP
.B "All systems:"
.Ls B
.Li
If you're going to install
.I imboot
and you don't want to use
.I /usr/local/lib/config
as the
.I imboot
configuration root directory, change the value of
.Cw CONFIGROOTDIR .
.Le 0
.B "UNIX systems:"
.Ls B
.Li
Make sure the value of
.Cw PERLPATH
is correct for your system.
This is needed for building Perl scripts.
It can be the full pathname of either Perl 4 or Perl 5.
.Li
If you want to use the
.I sh
version of
.I imboot ,
the "#define UsePerlImboot" line should be commented out:
.Ps
/*#define UsePerlImboot YES*/
.Pe
If you want to use the Perl version of
.I imboot ,
the line should be uncommented:
.Ps
#define UsePerlImboot YES
.Pe 0
.Li
If you want to use the
.I sh
version of
.I xmkmf ,
the "#define UsePerlXmkmf" line should be commented out:
.Ps
/*#define UsePerlXmkmf YES*/
.Pe
If you want to use the Perl version of
.I xmkmf ,
the line should be uncommented:
.Ps
#define UsePerlXmkmf YES
.Pe 0
.Le
.B "Windows NT systems:"
.Ls B
.Li
If you have the Windows NT version of Perl, you can use the Perl
script
.I imdent
and the Perl versions of
.I imboot
and
.I xmkmf .
Uncomment the
"#define WinNTHasPerl" line:
.Ps
#define WinNTHasPerl YES
.Pe
If you don't have Perl, the line should be commented out:
.Ps
/*#define WinNTHasPerl YES*/
.Pe
In the latter case, you won't be able to use
.I xmkmf ,
.I imboot ,
or
.I imdent .
.Le
.\"
.Ah "Building the Distribution"
.\"
First of all, do *NOT* run a bootstrapper like
.I xmkmf
or
.I imboot
to try to generate a
.I Makefile
from the
.I Imakefile
in the distribution root directory.
The
.I Makefile
in the root is written by hand; running a bootstrapper
destroys it and you will not be able to build the distribution.
If you do run a bootstrapper inadvertantly, you can restore the original
.I Makefile
like this:
.Ps
% cp Makefile.sav Makefile
.Pe
For UNIX, the command for building the distribution is:
.Ps
.ta 3i
% make World	\fI(or)\fP
% make World BOOTSTRAPCFLAGS="flags"
.Pe
where "flags" is something like "-Dhpux", "-Dsun", etc.
(See Appendix B if you need a flags value.)
.LP
For Windows NT, the command for building the distribution
is shown below, but before you run it, make sure you read
.I config/misc/Win32.notes :
.Ps
nmake World.Win32 > world.log
.Pe 0
.\"
.Ah "Installing the Distribution"
.\"
.LP
For UNIX, run this command (you may need to be
.I root )
to install everything built by the build step:
.Ps
% make install
.Pe
For Windows NT, run this command:
.Ps
nmake install
.Pe
To install everything that is built in a particular directory, change
into that directory and run "make install" (or "nmake install" for
Windows NT) there.
.LP
You can also install individual targets.
For example, if you want to
install a program "prog", you can change into the directory in
which the program is built, then run "make install.prog" under UNIX.
Under NT, use "nmake install.prog.exe" or "nmake install.prog.bat",
depending on whether prog is an executable binary or batch script.
.\"
.Ah "Miscellaneous"
.\"
.LP
Some of the differences between the itools distribution and the original
X stuff from which it was derived:
.Ls B
.Li
The
.I config/misc
directory contains notes for various systems that might
be useful or of interest.
.Li
The
.I config/extras
directory (containing
.I imboot ,
.I msub ,
and
.I imdent )
is not part of X.
.Li
The Perl version of
.I xmkmf
(in
.I config/util )
is not part of X.
.Li
.I which
(in
.I config/util )
is not part of X.
.Li
Most of the original files were mode 444 (read only), the
presumption being that you would just use them to build and install
X, but not modify them.
I'm presuming that you may very well want
to mess around with anything that's here, consequently all the
files are writable.
.Li
Many of the Imakefiles and a few other files were changed from the
originals in the X11R6.3 distribution.
(You can usually tell that a
file
.I xxx
was modified if a file
.I xxx.orig
is present.)
.Li
The set of configuration files in
.I config/cf
includes
.I linux-pmac.cf
for
Linux/PPC systems, and the Linux vendor block in
.I Imake.cf
was modified to recognize when to use it.
(Linux/PPC support is not provided in X11R6.3 at present.)
.Li
.I imake
source has been patched to strip leading zeroes from version
numbers written to
.I Imakefile.c ,
so that
.I cpp
won't interpret them as octal constants.
.Li
.I makedepend
source has been patched not to have a conflict with the
.Cw getline()
function declared in
.I stdio.h
of glibc.
(I changed
.Cw getline()
in the source to
.Cw mdgetline() .)
.Li
.I mkdirhier.c
source has been modified to test the return value from
.Cw _mkdir()
differently (to eliminate spurious errors).
.Le
