/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <ncurses.h>

#include "defines.h"
#include "colors.h"
#include "cmds.h"
#include "nap.h"
#include "vfuncs.h"


extern chans_t *curchan, *chanl;
extern ssearch_t *search;
extern unsigned char ircmode;
extern char *conns[];
extern WINDOW *wchan;

vars_t vars[] = {
  { "curchan", vcurchan },
  { "topic", vtopic },
  { "version", vversion },
  { "key", vkey },
  { "mode", vmode },
  { "args", vargs },
  { "isop", visop },
  { "nick", vnick },
  { "attr", vattr },
  { "search", vsearch },
  { "conn", vconn },
  { "chr", vchr },
  { "strstr", vstrstr },
  { NULL, NULL }
};


V_FUNC(vcurchan)
{
  if (!curchan)
    return(strdup(""));
  else
    return(strdup(curchan->nm));
}

V_FUNC(vtopic)
{
  if (!curchan || !curchan->topic)
    return(strdup(""));
  else
    return(strdup(curchan->topic));
}

V_FUNC(vversion)
{
  unsigned char *ret = NULL;
  
  msprintf((char **)&ret, "nap v%s", VERSION);
  
  return(ret);
}

V_FUNC(vkey)
{
  if (!curchan || !curchan->key)
    return(strdup(""));
  else
    return(strdup(curchan->key));
}

V_FUNC(vmode)
{
  if (ircmode)
    return(strdup("irc"));
  else
    return(strdup("nap"));
}

V_FUNC(visop)
{
  chans_t *cur;
  user_t *usr;
  
  if (cnt < 2)
    return(strdup(""));
  
  cur = findchan(chanl, tok[0]);
  if (!cur)
    return(strdup(""));
  usr = finduser(cur, tok[1]);
  if (!usr)
    return(strdup(""));
  
  if (usr->flag & 1)
    return(strdup("1"));
  else
    return(strdup("0"));
}

V_FUNC(vargs)
{
  int i;
  char b[256];
  
  memset(b, 0, sizeof(b));
  b[0] = '|';
  for (i=0;i<cnt;i++)
  {
    strcat(b, tok[i]);
    strcat(b, "|");
  }
  
  wp(wchan, "Args: %s\n", b);
  drw(wchan);
  
  if (tok && tok[0])
    return(strdup(tok[0]));
  else
    return(strdup(""));
}

V_FUNC(vnick)
{
  int i, n;
  chans_t *cur;
  user_t *usr;
  
  if (cnt < 2)
    return(strdup(""));
  
  cur = findchan(chanl, tok[0]);
  if (!cur)
    return(strdup(""));
  
  n = atoi(tok[1]);
  
  for (i=0,usr=cur->users;;usr=usr->next,i++)
  {
    if (!usr)
      return(strdup(""));

    if (i == n)
      break;
  }
  
  return(strdup(usr->nm));
}

V_FUNC(vattr)
{
  if (cnt < 1)
    return(strdup(""));
  
  if (!strcasecmp(tok[0], "bold"))
    return(strdup(BOLD));
  else if (!strcasecmp(tok[0], "white"))
    return(strdup(WHITE));
  else if (!strcasecmp(tok[0], "red"))
    return(strdup(RED));
  else if (!strcasecmp(tok[0], "green"))
    return(strdup(GREEN));
  else if (!strcasecmp(tok[0], "blue"))
    return(strdup(BLUE));
  else if (!strcasecmp(tok[0], "yellow"))
    return(strdup(YELLOW));
  else if (!strcasecmp(tok[0], "magenta"))
    return(strdup(MAGENTA));
  else if (!strcasecmp(tok[0], "blink"))
    return(strdup(BLINK));
  else if (!strcasecmp(tok[0], "underline"))
    return(strdup(UNDERLINE));
  else if (!strcasecmp(tok[0], "cyan"))
    return(strdup(CYAN));
  else
    return(strdup(""));
}

V_FUNC(vsearch)
{
  ssearch_t *cur;
  char *ret=NULL;
  int i;

  if (!search)
    return(strdup(""));
  
  if (cnt < 1)
  {
    for (i=0,cur=search;cur;cur=cur->next,i++);
    msprintf(&ret, "%i", i);
    return(ret);
  }
  
  for (i=atoi(tok[0]),cur=search;;cur=cur->next)
    if (!cur || i == cur->num)
      break;
  
  if (!cur)
    return(strdup(""));
  
  if (cnt < 2)
    return(strdup(cur->song));
  
  if (!strcasecmp(tok[1], "size"))
  {
    msprintf(&ret, "%lu", cur->sz);
    return(ret);
  }
  else if (!strcasecmp(tok[1], "user"))
    return(strdup(cur->cmp));
  else if (!strcasecmp(tok[1], "freq"))
  {
    msprintf(&ret, "%i", cur->freq);
    return(ret);
  }
  else if (!strcasecmp(tok[1], "length"))
  {
    msprintf(&ret, "%i", cur->time);
    return(ret);
  }
  else if (!strcasecmp(tok[1], "speed"))
    return(strdup(conns[cur->conn]));
  else if (!strcasecmp(tok[1], "bitrate"))
  {
    msprintf(&ret, "%i", cur->brate);
    return(ret);
  }
  else if (!strcasecmp(tok[1], "filename"))
    return(strdup(cur->fn));
  else if (!strcasecmp(tok[1], "ping"))
  {
    msprintf(&ret, "%i", cur->ping);
    return(ret);
  }
  else
    return(strdup(""));
}

V_FUNC(vconn)
{
  if (cnt < 1 || atoi(tok[0]) > 10)
    return(strdup(""));
  else
    return(strdup(conns[atoi(tok[0])]));
}

V_FUNC(vchr)
{
  char *r=NULL;

  if (cnt < 1)
    return(strdup(""));
  
  msprintf(&r, "%c", atoi(tok[0]));
  return(r);
}

V_FUNC(vstrstr)
{
  char *r;
  
  if (cnt < 2)
    return(strdup(""));
  
  r = strstr(tok[0], tok[1]);
  if (!r)
    return(strdup(""));
  else
    return(strdup(r));
}