
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 24 "/export/home/pb2/build/sb_0-8792293-1364217028.61/mysql-5.5.31-release-export-4981782_gpl/sql/sql_yacc.yy"

/* thd is passed as an argument to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)
#define YYLIP (& YYTHD->m_parser_state->m_lip)
#define YYPS (& YYTHD->m_parser_state->m_yacc)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Alter_table*_statement
#include "sql_truncate.h"                      // Truncate_statement
#include "sql_admin.h"                         // Analyze/Check..._table_stmt
#include "sql_partition_admin.h"               // Alter_table_*_partition_stmt
#include "sql_signal.h"
#include "event_parse_data.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror((char*) (A));                   \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !test(i) ||
         sp->push_backpatch(i, ctx->push_label((char *)"", 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!test(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable_t *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->dflt)
    it= spv->dflt;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_NO_WRITE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}



/* Line 189 of yacc.c  */
#line 789 "/export/home/pb2/build/sb_0-8792293-1364217028.61/dist_GPL/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     AT_SYM = 277,
     AUTHORS_SYM = 278,
     AUTOEXTEND_SIZE_SYM = 279,
     AUTO_INC = 280,
     AVG_ROW_LENGTH = 281,
     AVG_SYM = 282,
     BACKUP_SYM = 283,
     BEFORE_SYM = 284,
     BEGIN_SYM = 285,
     BETWEEN_SYM = 286,
     BIGINT = 287,
     BINARY = 288,
     BINLOG_SYM = 289,
     BIN_NUM = 290,
     BIT_AND = 291,
     BIT_OR = 292,
     BIT_SYM = 293,
     BIT_XOR = 294,
     BLOB_SYM = 295,
     BLOCK_SYM = 296,
     BOOLEAN_SYM = 297,
     BOOL_SYM = 298,
     BOTH = 299,
     BTREE_SYM = 300,
     BY = 301,
     BYTE_SYM = 302,
     CACHE_SYM = 303,
     CALL_SYM = 304,
     CASCADE = 305,
     CASCADED = 306,
     CASE_SYM = 307,
     CAST_SYM = 308,
     CATALOG_NAME_SYM = 309,
     CHAIN_SYM = 310,
     CHANGE = 311,
     CHANGED = 312,
     CHARSET = 313,
     CHAR_SYM = 314,
     CHECKSUM_SYM = 315,
     CHECK_SYM = 316,
     CIPHER_SYM = 317,
     CLASS_ORIGIN_SYM = 318,
     CLIENT_SYM = 319,
     CLOSE_SYM = 320,
     COALESCE = 321,
     CODE_SYM = 322,
     COLLATE_SYM = 323,
     COLLATION_SYM = 324,
     COLUMNS = 325,
     COLUMN_SYM = 326,
     COLUMN_NAME_SYM = 327,
     COMMENT_SYM = 328,
     COMMITTED_SYM = 329,
     COMMIT_SYM = 330,
     COMPACT_SYM = 331,
     COMPLETION_SYM = 332,
     COMPRESSED_SYM = 333,
     CONCURRENT = 334,
     CONDITION_SYM = 335,
     CONNECTION_SYM = 336,
     CONSISTENT_SYM = 337,
     CONSTRAINT = 338,
     CONSTRAINT_CATALOG_SYM = 339,
     CONSTRAINT_NAME_SYM = 340,
     CONSTRAINT_SCHEMA_SYM = 341,
     CONTAINS_SYM = 342,
     CONTEXT_SYM = 343,
     CONTINUE_SYM = 344,
     CONTRIBUTORS_SYM = 345,
     CONVERT_SYM = 346,
     COUNT_SYM = 347,
     CPU_SYM = 348,
     CREATE = 349,
     CROSS = 350,
     CUBE_SYM = 351,
     CURDATE = 352,
     CURRENT_USER = 353,
     CURSOR_SYM = 354,
     CURSOR_NAME_SYM = 355,
     CURTIME = 356,
     DATABASE = 357,
     DATABASES = 358,
     DATAFILE_SYM = 359,
     DATA_SYM = 360,
     DATETIME = 361,
     DATE_ADD_INTERVAL = 362,
     DATE_SUB_INTERVAL = 363,
     DATE_SYM = 364,
     DAY_HOUR_SYM = 365,
     DAY_MICROSECOND_SYM = 366,
     DAY_MINUTE_SYM = 367,
     DAY_SECOND_SYM = 368,
     DAY_SYM = 369,
     DEALLOCATE_SYM = 370,
     DECIMAL_NUM = 371,
     DECIMAL_SYM = 372,
     DECLARE_SYM = 373,
     DEFAULT = 374,
     DEFINER_SYM = 375,
     DELAYED_SYM = 376,
     DELAY_KEY_WRITE_SYM = 377,
     DELETE_SYM = 378,
     DESC = 379,
     DESCRIBE = 380,
     DES_KEY_FILE = 381,
     DETERMINISTIC_SYM = 382,
     DIRECTORY_SYM = 383,
     DISABLE_SYM = 384,
     DISCARD = 385,
     DISK_SYM = 386,
     DISTINCT = 387,
     DIV_SYM = 388,
     DOUBLE_SYM = 389,
     DO_SYM = 390,
     DROP = 391,
     DUAL_SYM = 392,
     DUMPFILE = 393,
     DUPLICATE_SYM = 394,
     DYNAMIC_SYM = 395,
     EACH_SYM = 396,
     ELSE = 397,
     ELSEIF_SYM = 398,
     ENABLE_SYM = 399,
     ENCLOSED = 400,
     END = 401,
     ENDS_SYM = 402,
     END_OF_INPUT = 403,
     ENGINES_SYM = 404,
     ENGINE_SYM = 405,
     ENUM = 406,
     EQ = 407,
     EQUAL_SYM = 408,
     ERROR_SYM = 409,
     ERRORS = 410,
     ESCAPED = 411,
     ESCAPE_SYM = 412,
     EVENTS_SYM = 413,
     EVENT_SYM = 414,
     EVERY_SYM = 415,
     EXECUTE_SYM = 416,
     EXISTS = 417,
     EXIT_SYM = 418,
     EXPANSION_SYM = 419,
     EXTENDED_SYM = 420,
     EXTENT_SIZE_SYM = 421,
     EXTRACT_SYM = 422,
     FALSE_SYM = 423,
     FAST_SYM = 424,
     FAULTS_SYM = 425,
     FETCH_SYM = 426,
     FILE_SYM = 427,
     FIRST_SYM = 428,
     FIXED_SYM = 429,
     FLOAT_NUM = 430,
     FLOAT_SYM = 431,
     FLUSH_SYM = 432,
     FORCE_SYM = 433,
     FOREIGN = 434,
     FOR_SYM = 435,
     FOUND_SYM = 436,
     FROM = 437,
     FULL = 438,
     FULLTEXT_SYM = 439,
     FUNCTION_SYM = 440,
     GE = 441,
     GENERAL = 442,
     GEOMETRYCOLLECTION = 443,
     GEOMETRY_SYM = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GROUP_SYM = 449,
     GROUP_CONCAT_SYM = 450,
     GT_SYM = 451,
     HANDLER_SYM = 452,
     HASH_SYM = 453,
     HAVING = 454,
     HELP_SYM = 455,
     HEX_NUM = 456,
     HIGH_PRIORITY = 457,
     HOST_SYM = 458,
     HOSTS_SYM = 459,
     HOUR_MICROSECOND_SYM = 460,
     HOUR_MINUTE_SYM = 461,
     HOUR_SECOND_SYM = 462,
     HOUR_SYM = 463,
     IDENT = 464,
     IDENTIFIED_SYM = 465,
     IDENT_QUOTED = 466,
     IF = 467,
     IGNORE_SYM = 468,
     IGNORE_SERVER_IDS_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INITIAL_SIZE_SYM = 474,
     INNER_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INSTALL_SYM = 480,
     INTERVAL_SYM = 481,
     INTO = 482,
     INT_SYM = 483,
     INVOKER_SYM = 484,
     IN_SYM = 485,
     IO_SYM = 486,
     IPC_SYM = 487,
     IS = 488,
     ISOLATION = 489,
     ISSUER_SYM = 490,
     ITERATE_SYM = 491,
     JOIN_SYM = 492,
     KEYS = 493,
     KEY_BLOCK_SIZE = 494,
     KEY_SYM = 495,
     KILL_SYM = 496,
     LANGUAGE_SYM = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAVES = 501,
     LEAVE_SYM = 502,
     LEFT = 503,
     LESS_SYM = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEAR_SYM = 509,
     LINES = 510,
     LINESTRING = 511,
     LIST_SYM = 512,
     LOAD = 513,
     LOCAL_SYM = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGFILE_SYM = 518,
     LOGS_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MASTER_CONNECT_RETRY_SYM = 527,
     MASTER_HOST_SYM = 528,
     MASTER_LOG_FILE_SYM = 529,
     MASTER_LOG_POS_SYM = 530,
     MASTER_PASSWORD_SYM = 531,
     MASTER_PORT_SYM = 532,
     MASTER_SERVER_ID_SYM = 533,
     MASTER_SSL_CAPATH_SYM = 534,
     MASTER_SSL_CA_SYM = 535,
     MASTER_SSL_CERT_SYM = 536,
     MASTER_SSL_CIPHER_SYM = 537,
     MASTER_SSL_KEY_SYM = 538,
     MASTER_SSL_SYM = 539,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 540,
     MASTER_SYM = 541,
     MASTER_USER_SYM = 542,
     MASTER_HEARTBEAT_PERIOD_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SIZE_SYM = 548,
     MAX_SYM = 549,
     MAX_UPDATES_PER_HOUR = 550,
     MAX_USER_CONNECTIONS_SYM = 551,
     MAX_VALUE_SYM = 552,
     MEDIUMBLOB = 553,
     MEDIUMINT = 554,
     MEDIUMTEXT = 555,
     MEDIUM_SYM = 556,
     MEMORY_SYM = 557,
     MERGE_SYM = 558,
     MESSAGE_TEXT_SYM = 559,
     MICROSECOND_SYM = 560,
     MIGRATE_SYM = 561,
     MINUTE_MICROSECOND_SYM = 562,
     MINUTE_SECOND_SYM = 563,
     MINUTE_SYM = 564,
     MIN_ROWS = 565,
     MIN_SYM = 566,
     MODE_SYM = 567,
     MODIFIES_SYM = 568,
     MODIFY_SYM = 569,
     MOD_SYM = 570,
     MONTH_SYM = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     MYSQL_ERRNO_SYM = 576,
     NAMES_SYM = 577,
     NAME_SYM = 578,
     NATIONAL_SYM = 579,
     NATURAL = 580,
     NCHAR_STRING = 581,
     NCHAR_SYM = 582,
     NDBCLUSTER_SYM = 583,
     NE = 584,
     NEG = 585,
     NEW_SYM = 586,
     NEXT_SYM = 587,
     NODEGROUP_SYM = 588,
     NONE_SYM = 589,
     NOT2_SYM = 590,
     NOT_SYM = 591,
     NOW_SYM = 592,
     NO_SYM = 593,
     NO_WAIT_SYM = 594,
     NO_WRITE_TO_BINLOG = 595,
     NULL_SYM = 596,
     NUM = 597,
     NUMERIC_SYM = 598,
     NVARCHAR_SYM = 599,
     OFFSET_SYM = 600,
     OLD_PASSWORD = 601,
     ON = 602,
     ONE_SHOT_SYM = 603,
     ONE_SYM = 604,
     OPEN_SYM = 605,
     OPTIMIZE = 606,
     OPTIONS_SYM = 607,
     OPTION = 608,
     OPTIONALLY = 609,
     OR2_SYM = 610,
     ORDER_SYM = 611,
     OR_OR_SYM = 612,
     OR_SYM = 613,
     OUTER = 614,
     OUTFILE = 615,
     OUT_SYM = 616,
     OWNER_SYM = 617,
     PACK_KEYS_SYM = 618,
     PAGE_SYM = 619,
     PARAM_MARKER = 620,
     PARSER_SYM = 621,
     PARTIAL = 622,
     PARTITIONING_SYM = 623,
     PARTITIONS_SYM = 624,
     PARTITION_SYM = 625,
     PASSWORD = 626,
     PHASE_SYM = 627,
     PLUGINS_SYM = 628,
     PLUGIN_SYM = 629,
     POINT_SYM = 630,
     POLYGON = 631,
     PORT_SYM = 632,
     POSITION_SYM = 633,
     PRECISION = 634,
     PREPARE_SYM = 635,
     PRESERVE_SYM = 636,
     PREV_SYM = 637,
     PRIMARY_SYM = 638,
     PRIVILEGES = 639,
     PROCEDURE_SYM = 640,
     PROCESS = 641,
     PROCESSLIST_SYM = 642,
     PROFILE_SYM = 643,
     PROFILES_SYM = 644,
     PROXY_SYM = 645,
     PURGE = 646,
     QUARTER_SYM = 647,
     QUERY_SYM = 648,
     QUICK = 649,
     RANGE_SYM = 650,
     READS_SYM = 651,
     READ_ONLY_SYM = 652,
     READ_SYM = 653,
     READ_WRITE_SYM = 654,
     REAL = 655,
     REBUILD_SYM = 656,
     RECOVER_SYM = 657,
     REDOFILE_SYM = 658,
     REDO_BUFFER_SIZE_SYM = 659,
     REDUNDANT_SYM = 660,
     REFERENCES = 661,
     REGEXP = 662,
     RELAY = 663,
     RELAYLOG_SYM = 664,
     RELAY_LOG_FILE_SYM = 665,
     RELAY_LOG_POS_SYM = 666,
     RELAY_THREAD = 667,
     RELEASE_SYM = 668,
     RELOAD = 669,
     REMOVE_SYM = 670,
     RENAME = 671,
     REORGANIZE_SYM = 672,
     REPAIR = 673,
     REPEATABLE_SYM = 674,
     REPEAT_SYM = 675,
     REPLACE = 676,
     REPLICATION = 677,
     REQUIRE_SYM = 678,
     RESET_SYM = 679,
     RESIGNAL_SYM = 680,
     RESOURCES = 681,
     RESTORE_SYM = 682,
     RESTRICT = 683,
     RESUME_SYM = 684,
     RETURNS_SYM = 685,
     RETURN_SYM = 686,
     REVOKE = 687,
     RIGHT = 688,
     ROLLBACK_SYM = 689,
     ROLLUP_SYM = 690,
     ROUTINE_SYM = 691,
     ROWS_SYM = 692,
     ROW_FORMAT_SYM = 693,
     ROW_SYM = 694,
     RTREE_SYM = 695,
     SAVEPOINT_SYM = 696,
     SCHEDULE_SYM = 697,
     SCHEMA_NAME_SYM = 698,
     SECOND_MICROSECOND_SYM = 699,
     SECOND_SYM = 700,
     SECURITY_SYM = 701,
     SELECT_SYM = 702,
     SENSITIVE_SYM = 703,
     SEPARATOR_SYM = 704,
     SERIALIZABLE_SYM = 705,
     SERIAL_SYM = 706,
     SESSION_SYM = 707,
     SERVER_SYM = 708,
     SERVER_OPTIONS = 709,
     SET = 710,
     SET_VAR = 711,
     SHARE_SYM = 712,
     SHIFT_LEFT = 713,
     SHIFT_RIGHT = 714,
     SHOW = 715,
     SHUTDOWN = 716,
     SIGNAL_SYM = 717,
     SIGNED_SYM = 718,
     SIMPLE_SYM = 719,
     SLAVE = 720,
     SLOW = 721,
     SMALLINT = 722,
     SNAPSHOT_SYM = 723,
     SOCKET_SYM = 724,
     SONAME_SYM = 725,
     SOUNDS_SYM = 726,
     SOURCE_SYM = 727,
     SPATIAL_SYM = 728,
     SPECIFIC_SYM = 729,
     SQLEXCEPTION_SYM = 730,
     SQLSTATE_SYM = 731,
     SQLWARNING_SYM = 732,
     SQL_BIG_RESULT = 733,
     SQL_BUFFER_RESULT = 734,
     SQL_CACHE_SYM = 735,
     SQL_CALC_FOUND_ROWS = 736,
     SQL_NO_CACHE_SYM = 737,
     SQL_SMALL_RESULT = 738,
     SQL_SYM = 739,
     SQL_THREAD = 740,
     SSL_SYM = 741,
     STARTING = 742,
     STARTS_SYM = 743,
     START_SYM = 744,
     STATUS_SYM = 745,
     STDDEV_SAMP_SYM = 746,
     STD_SYM = 747,
     STOP_SYM = 748,
     STORAGE_SYM = 749,
     STRAIGHT_JOIN = 750,
     STRING_SYM = 751,
     SUBCLASS_ORIGIN_SYM = 752,
     SUBDATE_SYM = 753,
     SUBJECT_SYM = 754,
     SUBPARTITIONS_SYM = 755,
     SUBPARTITION_SYM = 756,
     SUBSTRING = 757,
     SUM_SYM = 758,
     SUPER_SYM = 759,
     SUSPEND_SYM = 760,
     SWAPS_SYM = 761,
     SWITCHES_SYM = 762,
     SYSDATE = 763,
     TABLES = 764,
     TABLESPACE = 765,
     TABLE_REF_PRIORITY = 766,
     TABLE_SYM = 767,
     TABLE_CHECKSUM_SYM = 768,
     TABLE_NAME_SYM = 769,
     TEMPORARY = 770,
     TEMPTABLE_SYM = 771,
     TERMINATED = 772,
     TEXT_STRING = 773,
     TEXT_SYM = 774,
     THAN_SYM = 775,
     THEN_SYM = 776,
     TIMESTAMP = 777,
     TIMESTAMP_ADD = 778,
     TIMESTAMP_DIFF = 779,
     TIME_SYM = 780,
     TINYBLOB = 781,
     TINYINT = 782,
     TINYTEXT = 783,
     TO_SYM = 784,
     TRAILING = 785,
     TRANSACTION_SYM = 786,
     TRIGGERS_SYM = 787,
     TRIGGER_SYM = 788,
     TRIM = 789,
     TRUE_SYM = 790,
     TRUNCATE_SYM = 791,
     TYPES_SYM = 792,
     TYPE_SYM = 793,
     UDF_RETURNS_SYM = 794,
     ULONGLONG_NUM = 795,
     UNCOMMITTED_SYM = 796,
     UNDEFINED_SYM = 797,
     UNDERSCORE_CHARSET = 798,
     UNDOFILE_SYM = 799,
     UNDO_BUFFER_SIZE_SYM = 800,
     UNDO_SYM = 801,
     UNICODE_SYM = 802,
     UNINSTALL_SYM = 803,
     UNION_SYM = 804,
     UNIQUE_SYM = 805,
     UNKNOWN_SYM = 806,
     UNLOCK_SYM = 807,
     UNSIGNED = 808,
     UNTIL_SYM = 809,
     UPDATE_SYM = 810,
     UPGRADE_SYM = 811,
     USAGE = 812,
     USER = 813,
     USE_FRM = 814,
     USE_SYM = 815,
     USING = 816,
     UTC_DATE_SYM = 817,
     UTC_TIMESTAMP_SYM = 818,
     UTC_TIME_SYM = 819,
     VALUES = 820,
     VALUE_SYM = 821,
     VARBINARY = 822,
     VARCHAR = 823,
     VARIABLES = 824,
     VARIANCE_SYM = 825,
     VARYING = 826,
     VAR_SAMP_SYM = 827,
     VIEW_SYM = 828,
     WAIT_SYM = 829,
     WARNINGS = 830,
     WEEK_SYM = 831,
     WHEN_SYM = 832,
     WHERE = 833,
     WHILE_SYM = 834,
     WITH = 835,
     WITH_CUBE_SYM = 836,
     WITH_ROLLUP_SYM = 837,
     WORK_SYM = 838,
     WRAPPER_SYM = 839,
     WRITE_SYM = 840,
     X509_SYM = 841,
     XA_SYM = 842,
     XML_SYM = 843,
     XOR = 844,
     YEAR_MONTH_SYM = 845,
     YEAR_SYM = 846,
     ZEROFILL = 847
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define AT_SYM 277
#define AUTHORS_SYM 278
#define AUTOEXTEND_SIZE_SYM 279
#define AUTO_INC 280
#define AVG_ROW_LENGTH 281
#define AVG_SYM 282
#define BACKUP_SYM 283
#define BEFORE_SYM 284
#define BEGIN_SYM 285
#define BETWEEN_SYM 286
#define BIGINT 287
#define BINARY 288
#define BINLOG_SYM 289
#define BIN_NUM 290
#define BIT_AND 291
#define BIT_OR 292
#define BIT_SYM 293
#define BIT_XOR 294
#define BLOB_SYM 295
#define BLOCK_SYM 296
#define BOOLEAN_SYM 297
#define BOOL_SYM 298
#define BOTH 299
#define BTREE_SYM 300
#define BY 301
#define BYTE_SYM 302
#define CACHE_SYM 303
#define CALL_SYM 304
#define CASCADE 305
#define CASCADED 306
#define CASE_SYM 307
#define CAST_SYM 308
#define CATALOG_NAME_SYM 309
#define CHAIN_SYM 310
#define CHANGE 311
#define CHANGED 312
#define CHARSET 313
#define CHAR_SYM 314
#define CHECKSUM_SYM 315
#define CHECK_SYM 316
#define CIPHER_SYM 317
#define CLASS_ORIGIN_SYM 318
#define CLIENT_SYM 319
#define CLOSE_SYM 320
#define COALESCE 321
#define CODE_SYM 322
#define COLLATE_SYM 323
#define COLLATION_SYM 324
#define COLUMNS 325
#define COLUMN_SYM 326
#define COLUMN_NAME_SYM 327
#define COMMENT_SYM 328
#define COMMITTED_SYM 329
#define COMMIT_SYM 330
#define COMPACT_SYM 331
#define COMPLETION_SYM 332
#define COMPRESSED_SYM 333
#define CONCURRENT 334
#define CONDITION_SYM 335
#define CONNECTION_SYM 336
#define CONSISTENT_SYM 337
#define CONSTRAINT 338
#define CONSTRAINT_CATALOG_SYM 339
#define CONSTRAINT_NAME_SYM 340
#define CONSTRAINT_SCHEMA_SYM 341
#define CONTAINS_SYM 342
#define CONTEXT_SYM 343
#define CONTINUE_SYM 344
#define CONTRIBUTORS_SYM 345
#define CONVERT_SYM 346
#define COUNT_SYM 347
#define CPU_SYM 348
#define CREATE 349
#define CROSS 350
#define CUBE_SYM 351
#define CURDATE 352
#define CURRENT_USER 353
#define CURSOR_SYM 354
#define CURSOR_NAME_SYM 355
#define CURTIME 356
#define DATABASE 357
#define DATABASES 358
#define DATAFILE_SYM 359
#define DATA_SYM 360
#define DATETIME 361
#define DATE_ADD_INTERVAL 362
#define DATE_SUB_INTERVAL 363
#define DATE_SYM 364
#define DAY_HOUR_SYM 365
#define DAY_MICROSECOND_SYM 366
#define DAY_MINUTE_SYM 367
#define DAY_SECOND_SYM 368
#define DAY_SYM 369
#define DEALLOCATE_SYM 370
#define DECIMAL_NUM 371
#define DECIMAL_SYM 372
#define DECLARE_SYM 373
#define DEFAULT 374
#define DEFINER_SYM 375
#define DELAYED_SYM 376
#define DELAY_KEY_WRITE_SYM 377
#define DELETE_SYM 378
#define DESC 379
#define DESCRIBE 380
#define DES_KEY_FILE 381
#define DETERMINISTIC_SYM 382
#define DIRECTORY_SYM 383
#define DISABLE_SYM 384
#define DISCARD 385
#define DISK_SYM 386
#define DISTINCT 387
#define DIV_SYM 388
#define DOUBLE_SYM 389
#define DO_SYM 390
#define DROP 391
#define DUAL_SYM 392
#define DUMPFILE 393
#define DUPLICATE_SYM 394
#define DYNAMIC_SYM 395
#define EACH_SYM 396
#define ELSE 397
#define ELSEIF_SYM 398
#define ENABLE_SYM 399
#define ENCLOSED 400
#define END 401
#define ENDS_SYM 402
#define END_OF_INPUT 403
#define ENGINES_SYM 404
#define ENGINE_SYM 405
#define ENUM 406
#define EQ 407
#define EQUAL_SYM 408
#define ERROR_SYM 409
#define ERRORS 410
#define ESCAPED 411
#define ESCAPE_SYM 412
#define EVENTS_SYM 413
#define EVENT_SYM 414
#define EVERY_SYM 415
#define EXECUTE_SYM 416
#define EXISTS 417
#define EXIT_SYM 418
#define EXPANSION_SYM 419
#define EXTENDED_SYM 420
#define EXTENT_SIZE_SYM 421
#define EXTRACT_SYM 422
#define FALSE_SYM 423
#define FAST_SYM 424
#define FAULTS_SYM 425
#define FETCH_SYM 426
#define FILE_SYM 427
#define FIRST_SYM 428
#define FIXED_SYM 429
#define FLOAT_NUM 430
#define FLOAT_SYM 431
#define FLUSH_SYM 432
#define FORCE_SYM 433
#define FOREIGN 434
#define FOR_SYM 435
#define FOUND_SYM 436
#define FROM 437
#define FULL 438
#define FULLTEXT_SYM 439
#define FUNCTION_SYM 440
#define GE 441
#define GENERAL 442
#define GEOMETRYCOLLECTION 443
#define GEOMETRY_SYM 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GROUP_SYM 449
#define GROUP_CONCAT_SYM 450
#define GT_SYM 451
#define HANDLER_SYM 452
#define HASH_SYM 453
#define HAVING 454
#define HELP_SYM 455
#define HEX_NUM 456
#define HIGH_PRIORITY 457
#define HOST_SYM 458
#define HOSTS_SYM 459
#define HOUR_MICROSECOND_SYM 460
#define HOUR_MINUTE_SYM 461
#define HOUR_SECOND_SYM 462
#define HOUR_SYM 463
#define IDENT 464
#define IDENTIFIED_SYM 465
#define IDENT_QUOTED 466
#define IF 467
#define IGNORE_SYM 468
#define IGNORE_SERVER_IDS_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INITIAL_SIZE_SYM 474
#define INNER_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INSTALL_SYM 480
#define INTERVAL_SYM 481
#define INTO 482
#define INT_SYM 483
#define INVOKER_SYM 484
#define IN_SYM 485
#define IO_SYM 486
#define IPC_SYM 487
#define IS 488
#define ISOLATION 489
#define ISSUER_SYM 490
#define ITERATE_SYM 491
#define JOIN_SYM 492
#define KEYS 493
#define KEY_BLOCK_SIZE 494
#define KEY_SYM 495
#define KILL_SYM 496
#define LANGUAGE_SYM 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAVES 501
#define LEAVE_SYM 502
#define LEFT 503
#define LESS_SYM 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEAR_SYM 509
#define LINES 510
#define LINESTRING 511
#define LIST_SYM 512
#define LOAD 513
#define LOCAL_SYM 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGFILE_SYM 518
#define LOGS_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MASTER_CONNECT_RETRY_SYM 527
#define MASTER_HOST_SYM 528
#define MASTER_LOG_FILE_SYM 529
#define MASTER_LOG_POS_SYM 530
#define MASTER_PASSWORD_SYM 531
#define MASTER_PORT_SYM 532
#define MASTER_SERVER_ID_SYM 533
#define MASTER_SSL_CAPATH_SYM 534
#define MASTER_SSL_CA_SYM 535
#define MASTER_SSL_CERT_SYM 536
#define MASTER_SSL_CIPHER_SYM 537
#define MASTER_SSL_KEY_SYM 538
#define MASTER_SSL_SYM 539
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 540
#define MASTER_SYM 541
#define MASTER_USER_SYM 542
#define MASTER_HEARTBEAT_PERIOD_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SIZE_SYM 548
#define MAX_SYM 549
#define MAX_UPDATES_PER_HOUR 550
#define MAX_USER_CONNECTIONS_SYM 551
#define MAX_VALUE_SYM 552
#define MEDIUMBLOB 553
#define MEDIUMINT 554
#define MEDIUMTEXT 555
#define MEDIUM_SYM 556
#define MEMORY_SYM 557
#define MERGE_SYM 558
#define MESSAGE_TEXT_SYM 559
#define MICROSECOND_SYM 560
#define MIGRATE_SYM 561
#define MINUTE_MICROSECOND_SYM 562
#define MINUTE_SECOND_SYM 563
#define MINUTE_SYM 564
#define MIN_ROWS 565
#define MIN_SYM 566
#define MODE_SYM 567
#define MODIFIES_SYM 568
#define MODIFY_SYM 569
#define MOD_SYM 570
#define MONTH_SYM 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define MYSQL_ERRNO_SYM 576
#define NAMES_SYM 577
#define NAME_SYM 578
#define NATIONAL_SYM 579
#define NATURAL 580
#define NCHAR_STRING 581
#define NCHAR_SYM 582
#define NDBCLUSTER_SYM 583
#define NE 584
#define NEG 585
#define NEW_SYM 586
#define NEXT_SYM 587
#define NODEGROUP_SYM 588
#define NONE_SYM 589
#define NOT2_SYM 590
#define NOT_SYM 591
#define NOW_SYM 592
#define NO_SYM 593
#define NO_WAIT_SYM 594
#define NO_WRITE_TO_BINLOG 595
#define NULL_SYM 596
#define NUM 597
#define NUMERIC_SYM 598
#define NVARCHAR_SYM 599
#define OFFSET_SYM 600
#define OLD_PASSWORD 601
#define ON 602
#define ONE_SHOT_SYM 603
#define ONE_SYM 604
#define OPEN_SYM 605
#define OPTIMIZE 606
#define OPTIONS_SYM 607
#define OPTION 608
#define OPTIONALLY 609
#define OR2_SYM 610
#define ORDER_SYM 611
#define OR_OR_SYM 612
#define OR_SYM 613
#define OUTER 614
#define OUTFILE 615
#define OUT_SYM 616
#define OWNER_SYM 617
#define PACK_KEYS_SYM 618
#define PAGE_SYM 619
#define PARAM_MARKER 620
#define PARSER_SYM 621
#define PARTIAL 622
#define PARTITIONING_SYM 623
#define PARTITIONS_SYM 624
#define PARTITION_SYM 625
#define PASSWORD 626
#define PHASE_SYM 627
#define PLUGINS_SYM 628
#define PLUGIN_SYM 629
#define POINT_SYM 630
#define POLYGON 631
#define PORT_SYM 632
#define POSITION_SYM 633
#define PRECISION 634
#define PREPARE_SYM 635
#define PRESERVE_SYM 636
#define PREV_SYM 637
#define PRIMARY_SYM 638
#define PRIVILEGES 639
#define PROCEDURE_SYM 640
#define PROCESS 641
#define PROCESSLIST_SYM 642
#define PROFILE_SYM 643
#define PROFILES_SYM 644
#define PROXY_SYM 645
#define PURGE 646
#define QUARTER_SYM 647
#define QUERY_SYM 648
#define QUICK 649
#define RANGE_SYM 650
#define READS_SYM 651
#define READ_ONLY_SYM 652
#define READ_SYM 653
#define READ_WRITE_SYM 654
#define REAL 655
#define REBUILD_SYM 656
#define RECOVER_SYM 657
#define REDOFILE_SYM 658
#define REDO_BUFFER_SIZE_SYM 659
#define REDUNDANT_SYM 660
#define REFERENCES 661
#define REGEXP 662
#define RELAY 663
#define RELAYLOG_SYM 664
#define RELAY_LOG_FILE_SYM 665
#define RELAY_LOG_POS_SYM 666
#define RELAY_THREAD 667
#define RELEASE_SYM 668
#define RELOAD 669
#define REMOVE_SYM 670
#define RENAME 671
#define REORGANIZE_SYM 672
#define REPAIR 673
#define REPEATABLE_SYM 674
#define REPEAT_SYM 675
#define REPLACE 676
#define REPLICATION 677
#define REQUIRE_SYM 678
#define RESET_SYM 679
#define RESIGNAL_SYM 680
#define RESOURCES 681
#define RESTORE_SYM 682
#define RESTRICT 683
#define RESUME_SYM 684
#define RETURNS_SYM 685
#define RETURN_SYM 686
#define REVOKE 687
#define RIGHT 688
#define ROLLBACK_SYM 689
#define ROLLUP_SYM 690
#define ROUTINE_SYM 691
#define ROWS_SYM 692
#define ROW_FORMAT_SYM 693
#define ROW_SYM 694
#define RTREE_SYM 695
#define SAVEPOINT_SYM 696
#define SCHEDULE_SYM 697
#define SCHEMA_NAME_SYM 698
#define SECOND_MICROSECOND_SYM 699
#define SECOND_SYM 700
#define SECURITY_SYM 701
#define SELECT_SYM 702
#define SENSITIVE_SYM 703
#define SEPARATOR_SYM 704
#define SERIALIZABLE_SYM 705
#define SERIAL_SYM 706
#define SESSION_SYM 707
#define SERVER_SYM 708
#define SERVER_OPTIONS 709
#define SET 710
#define SET_VAR 711
#define SHARE_SYM 712
#define SHIFT_LEFT 713
#define SHIFT_RIGHT 714
#define SHOW 715
#define SHUTDOWN 716
#define SIGNAL_SYM 717
#define SIGNED_SYM 718
#define SIMPLE_SYM 719
#define SLAVE 720
#define SLOW 721
#define SMALLINT 722
#define SNAPSHOT_SYM 723
#define SOCKET_SYM 724
#define SONAME_SYM 725
#define SOUNDS_SYM 726
#define SOURCE_SYM 727
#define SPATIAL_SYM 728
#define SPECIFIC_SYM 729
#define SQLEXCEPTION_SYM 730
#define SQLSTATE_SYM 731
#define SQLWARNING_SYM 732
#define SQL_BIG_RESULT 733
#define SQL_BUFFER_RESULT 734
#define SQL_CACHE_SYM 735
#define SQL_CALC_FOUND_ROWS 736
#define SQL_NO_CACHE_SYM 737
#define SQL_SMALL_RESULT 738
#define SQL_SYM 739
#define SQL_THREAD 740
#define SSL_SYM 741
#define STARTING 742
#define STARTS_SYM 743
#define START_SYM 744
#define STATUS_SYM 745
#define STDDEV_SAMP_SYM 746
#define STD_SYM 747
#define STOP_SYM 748
#define STORAGE_SYM 749
#define STRAIGHT_JOIN 750
#define STRING_SYM 751
#define SUBCLASS_ORIGIN_SYM 752
#define SUBDATE_SYM 753
#define SUBJECT_SYM 754
#define SUBPARTITIONS_SYM 755
#define SUBPARTITION_SYM 756
#define SUBSTRING 757
#define SUM_SYM 758
#define SUPER_SYM 759
#define SUSPEND_SYM 760
#define SWAPS_SYM 761
#define SWITCHES_SYM 762
#define SYSDATE 763
#define TABLES 764
#define TABLESPACE 765
#define TABLE_REF_PRIORITY 766
#define TABLE_SYM 767
#define TABLE_CHECKSUM_SYM 768
#define TABLE_NAME_SYM 769
#define TEMPORARY 770
#define TEMPTABLE_SYM 771
#define TERMINATED 772
#define TEXT_STRING 773
#define TEXT_SYM 774
#define THAN_SYM 775
#define THEN_SYM 776
#define TIMESTAMP 777
#define TIMESTAMP_ADD 778
#define TIMESTAMP_DIFF 779
#define TIME_SYM 780
#define TINYBLOB 781
#define TINYINT 782
#define TINYTEXT 783
#define TO_SYM 784
#define TRAILING 785
#define TRANSACTION_SYM 786
#define TRIGGERS_SYM 787
#define TRIGGER_SYM 788
#define TRIM 789
#define TRUE_SYM 790
#define TRUNCATE_SYM 791
#define TYPES_SYM 792
#define TYPE_SYM 793
#define UDF_RETURNS_SYM 794
#define ULONGLONG_NUM 795
#define UNCOMMITTED_SYM 796
#define UNDEFINED_SYM 797
#define UNDERSCORE_CHARSET 798
#define UNDOFILE_SYM 799
#define UNDO_BUFFER_SIZE_SYM 800
#define UNDO_SYM 801
#define UNICODE_SYM 802
#define UNINSTALL_SYM 803
#define UNION_SYM 804
#define UNIQUE_SYM 805
#define UNKNOWN_SYM 806
#define UNLOCK_SYM 807
#define UNSIGNED 808
#define UNTIL_SYM 809
#define UPDATE_SYM 810
#define UPGRADE_SYM 811
#define USAGE 812
#define USER 813
#define USE_FRM 814
#define USE_SYM 815
#define USING 816
#define UTC_DATE_SYM 817
#define UTC_TIMESTAMP_SYM 818
#define UTC_TIME_SYM 819
#define VALUES 820
#define VALUE_SYM 821
#define VARBINARY 822
#define VARCHAR 823
#define VARIABLES 824
#define VARIANCE_SYM 825
#define VARYING 826
#define VAR_SAMP_SYM 827
#define VIEW_SYM 828
#define WAIT_SYM 829
#define WARNINGS 830
#define WEEK_SYM 831
#define WHEN_SYM 832
#define WHERE 833
#define WHILE_SYM 834
#define WITH 835
#define WITH_CUBE_SYM 836
#define WITH_ROLLUP_SYM 837
#define WORK_SYM 838
#define WRAPPER_SYM 839
#define WRITE_SYM 840
#define X509_SYM 841
#define XA_SYM 842
#define XML_SYM 843
#define XOR 844
#define YEAR_MONTH_SYM 845
#define YEAR_SYM 846
#define ZEROFILL 847




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 730 "/export/home/pb2/build/sb_0-8792293-1364217028.61/mysql-5.5.31-release-export-4981782_gpl/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;



/* Line 214 of yacc.c  */
#line 2059 "/export/home/pb2/build/sb_0-8792293-1364217028.61/dist_GPL/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 778 "/export/home/pb2/build/sb_0-8792293-1364217028.61/mysql-5.5.31-release-export-4981782_gpl/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2076 "/export/home/pb2/build/sb_0-8792293-1364217028.61/dist_GPL/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  573
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   50069

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  612
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  886
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2493
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4239

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   847

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   605,     2,     2,     2,   599,   594,     2,
     602,   603,   597,   596,   604,   595,   610,   598,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   611,   608,
       2,     2,     2,     2,   609,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   600,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   606,   593,   607,   601,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   127,   129,   131,   136,   138,   141,   142,   147,
     148,   151,   155,   157,   160,   161,   165,   166,   172,   174,
     178,   182,   186,   190,   194,   198,   202,   206,   210,   214,
     218,   222,   226,   230,   236,   238,   239,   241,   245,   247,
     251,   255,   259,   263,   264,   272,   273,   286,   287,   300,
     301,   314,   315,   322,   323,   327,   332,   337,   341,   344,
     355,   357,   361,   364,   367,   370,   373,   376,   379,   382,
     383,   397,   398,   405,   408,   409,   411,   415,   417,   418,
     421,   422,   425,   426,   428,   432,   437,   438,   441,   442,
     445,   447,   449,   451,   453,   455,   457,   459,   461,   463,
     465,   467,   469,   471,   472,   476,   478,   479,   482,   483,
     486,   489,   492,   495,   498,   502,   506,   508,   510,   512,
     515,   519,   523,   524,   529,   530,   534,   535,   537,   541,
     543,   544,   546,   550,   552,   553,   557,   558,   560,   564,
     566,   571,   572,   574,   576,   578,   579,   583,   586,   590,
     591,   595,   596,   602,   608,   609,   617,   623,   624,   627,
     629,   631,   633,   637,   639,   641,   643,   647,   648,   650,
     652,   654,   656,   659,   661,   665,   667,   669,   670,   672,
     673,   676,   680,   686,   688,   690,   692,   694,   696,   698,
     700,   702,   704,   706,   708,   710,   712,   714,   716,   720,
     722,   726,   727,   730,   732,   734,   736,   738,   740,   742,
     744,   746,   748,   750,   752,   754,   756,   757,   763,   764,
     767,   768,   772,   773,   776,   779,   782,   785,   786,   793,
     796,   797,   800,   802,   804,   808,   809,   810,   811,   819,
     820,   823,   826,   828,   830,   831,   832,   841,   842,   849,
     851,   854,   856,   859,   860,   861,   868,   869,   870,   877,
     878,   881,   882,   888,   889,   891,   892,   898,   899,   902,
     903,   909,   914,   915,   916,   925,   926,   934,   936,   938,
     940,   942,   944,   947,   952,   958,   959,   964,   969,   974,
     978,   982,   985,   988,   989,   992,   994,   997,  1001,  1003,
    1005,  1007,  1009,  1011,  1014,  1018,  1020,  1022,  1024,  1026,
    1028,  1030,  1032,  1034,  1036,  1038,  1041,  1045,  1047,  1049,
    1051,  1053,  1055,  1057,  1059,  1062,  1066,  1068,  1070,  1072,
    1074,  1076,  1078,  1080,  1082,  1084,  1087,  1091,  1093,  1095,
    1097,  1100,  1103,  1106,  1108,  1110,  1112,  1114,  1117,  1121,
    1125,  1129,  1133,  1137,  1141,  1145,  1149,  1154,  1155,  1157,
    1159,  1161,  1163,  1165,  1168,  1172,  1175,  1180,  1186,  1187,
    1193,  1194,  1195,  1201,  1202,  1210,  1212,  1213,  1215,  1216,
    1221,  1222,  1223,  1227,  1233,  1240,  1241,  1246,  1249,  1252,
    1255,  1258,  1259,  1261,  1262,  1266,  1267,  1269,  1271,  1275,
    1277,  1282,  1288,  1294,  1295,  1298,  1299,  1300,  1308,  1309,
    1320,  1322,  1326,  1328,  1330,  1331,  1334,  1335,  1339,  1341,
    1345,  1346,  1353,  1355,  1356,  1357,  1363,  1364,  1369,  1371,
    1373,  1375,  1379,  1381,  1385,  1386,  1387,  1393,  1395,  1399,
    1401,  1403,  1404,  1408,  1410,  1414,  1415,  1420,  1422,  1423,
    1425,  1428,  1430,  1434,  1439,  1443,  1447,  1451,  1456,  1461,
    1465,  1466,  1467,  1474,  1475,  1477,  1478,  1480,  1482,  1485,
    1487,  1489,  1490,  1492,  1494,  1497,  1499,  1500,  1504,  1505,
    1507,  1509,  1512,  1514,  1517,  1521,  1525,  1529,  1533,  1537,
    1541,  1545,  1549,  1553,  1557,  1561,  1565,  1569,  1573,  1574,
    1581,  1583,  1585,  1589,  1594,  1599,  1602,  1605,  1608,  1612,
    1616,  1621,  1626,  1628,  1630,  1632,  1634,  1636,  1638,  1640,
    1642,  1644,  1646,  1648,  1650,  1653,  1655,  1657,  1659,  1661,
    1663,  1665,  1669,  1671,  1673,  1676,  1679,  1687,  1696,  1705,
    1714,  1723,  1726,  1727,  1729,  1734,  1735,  1737,  1740,  1741,
    1746,  1750,  1754,  1758,  1760,  1763,  1765,  1767,  1771,  1774,
    1778,  1781,  1784,  1786,  1790,  1794,  1797,  1801,  1803,  1805,
    1807,  1809,  1811,  1814,  1816,  1818,  1820,  1823,  1827,  1830,
    1834,  1837,  1840,  1844,  1848,  1852,  1853,  1860,  1861,  1868,
    1871,  1873,  1875,  1877,  1879,  1881,  1883,  1885,  1887,  1889,
    1891,  1893,  1896,  1899,  1901,  1904,  1906,  1909,  1913,  1916,
    1918,  1920,  1922,  1924,  1926,  1928,  1930,  1933,  1934,  1936,
    1938,  1944,  1945,  1947,  1950,  1952,  1954,  1956,  1958,  1962,
    1966,  1970,  1974,  1975,  1977,  1978,  1980,  1981,  1983,  1986,
    1988,  1990,  1993,  1996,  2001,  2003,  2007,  2010,  2012,  2015,
    2018,  2021,  2024,  2027,  2029,  2032,  2034,  2036,  2038,  2040,
    2042,  2043,  2046,  2048,  2050,  2052,  2054,  2056,  2057,  2060,
    2062,  2064,  2065,  2067,  2069,  2072,  2075,  2077,  2080,  2083,
    2084,  2086,  2088,  2090,  2094,  2096,  2100,  2101,  2103,  2104,
    2106,  2112,  2113,  2117,  2121,  2123,  2124,  2127,  2130,  2133,
    2134,  2138,  2142,  2149,  2156,  2158,  2160,  2163,  2166,  2169,
    2171,  2174,  2177,  2179,  2181,  2182,  2184,  2186,  2188,  2190,
    2191,  2193,  2195,  2197,  2198,  2200,  2203,  2204,  2206,  2207,
    2209,  2210,  2212,  2214,  2217,  2219,  2222,  2224,  2227,  2230,
    2233,  2237,  2240,  2242,  2244,  2246,  2248,  2252,  2254,  2256,
    2258,  2263,  2266,  2268,  2273,  2274,  2276,  2277,  2280,  2282,
    2286,  2287,  2294,  2295,  2301,  2309,  2310,  2316,  2317,  2323,
    2324,  2330,  2331,  2336,  2337,  2348,  2352,  2357,  2361,  2365,
    2373,  2374,  2378,  2380,  2385,  2386,  2390,  2391,  2394,  2395,
    2397,  2398,  2401,  2404,  2407,  2410,  2412,  2414,  2416,  2420,
    2425,  2426,  2433,  2438,  2439,  2445,  2446,  2453,  2458,  2462,
    2464,  2467,  2469,  2471,  2472,  2478,  2479,  2483,  2486,  2487,
    2493,  2494,  2495,  2502,  2504,  2508,  2510,  2512,  2516,  2519,
    2523,  2526,  2531,  2532,  2539,  2540,  2541,  2550,  2555,  2560,
    2564,  2568,  2571,  2574,  2581,  2587,  2591,  2597,  2599,  2601,
    2603,  2604,  2606,  2607,  2609,  2610,  2612,  2614,  2615,  2618,
    2620,  2621,  2623,  2625,  2627,  2628,  2634,  2638,  2639,  2645,
    2649,  2653,  2654,  2658,  2659,  2662,  2664,  2668,  2669,  2671,
    2673,  2674,  2677,  2679,  2683,  2684,  2690,  2691,  2693,  2695,
    2696,  2703,  2704,  2706,  2708,  2711,  2713,  2715,  2717,  2718,
    2724,  2727,  2728,  2734,  2735,  2737,  2739,  2742,  2744,  2746,
    2748,  2750,  2752,  2755,  2756,  2762,  2763,  2765,  2767,  2768,
    2773,  2778,  2782,  2788,  2790,  2794,  2798,  2799,  2806,  2808,
    2810,  2812,  2816,  2819,  2823,  2825,  2827,  2828,  2835,  2837,
    2839,  2841,  2845,  2849,  2854,  2855,  2862,  2863,  2866,  2867,
    2872,  2873,  2876,  2878,  2881,  2886,  2889,  2893,  2896,  2900,
    2901,  2905,  2906,  2907,  2914,  2917,  2919,  2921,  2924,  2927,
    2936,  2941,  2942,  2944,  2947,  2949,  2951,  2953,  2955,  2956,
    2959,  2964,  2968,  2970,  2972,  2976,  2981,  2982,  2983,  2984,
    2987,  2990,  2992,  2994,  2995,  2998,  3002,  3006,  3010,  3013,
    3017,  3022,  3026,  3031,  3035,  3040,  3042,  3046,  3051,  3055,
    3059,  3066,  3068,  3074,  3081,  3087,  3095,  3102,  3111,  3117,
    3124,  3129,  3134,  3140,  3144,  3149,  3151,  3155,  3159,  3163,
    3167,  3171,  3175,  3181,  3187,  3191,  3195,  3199,  3203,  3207,
    3211,  3213,  3215,  3217,  3219,  3221,  3223,  3225,  3227,  3229,
    3231,  3233,  3235,  3237,  3239,  3241,  3243,  3245,  3247,  3249,
    3251,  3253,  3255,  3259,  3261,  3263,  3265,  3267,  3271,  3274,
    3277,  3280,  3283,  3287,  3291,  3297,  3304,  3309,  3314,  3322,
    3325,  3332,  3338,  3345,  3352,  3357,  3362,  3368,  3373,  3380,
    3383,  3388,  3393,  3398,  3409,  3416,  3425,  3432,  3437,  3442,
    3449,  3454,  3459,  3464,  3471,  3476,  3484,  3492,  3500,  3507,
    3514,  3521,  3528,  3532,  3537,  3544,  3553,  3556,  3559,  3564,
    3573,  3582,  3589,  3596,  3599,  3604,  3611,  3618,  3627,  3636,
    3643,  3652,  3659,  3662,  3667,  3676,  3685,  3688,  3691,  3694,
    3699,  3704,  3709,  3714,  3718,  3727,  3732,  3739,  3744,  3749,
    3754,  3761,  3770,  3777,  3782,  3789,  3791,  3798,  3803,  3808,
    3813,  3818,  3823,  3830,  3835,  3836,  3842,  3849,  3852,  3856,
    3857,  3862,  3863,  3867,  3868,  3870,  3872,  3876,  3881,  3886,
    3892,  3897,  3902,  3907,  3913,  3918,  3919,  3920,  3928,  3933,
    3939,  3944,  3950,  3955,  3960,  3965,  3970,  3975,  3981,  3982,
    3991,  3992,  3996,  4000,  4002,  4007,  4008,  4010,  4011,  4014,
    4015,  4017,  4018,  4022,  4025,  4029,  4032,  4034,  4037,  4039,
    4042,  4044,  4046,  4048,  4051,  4052,  4054,  4056,  4060,  4062,
    4066,  4068,  4072,  4073,  4075,  4076,  4079,  4084,  4090,  4092,
    4094,  4096,  4098,  4103,  4105,  4109,  4113,  4117,  4118,  4125,
    4126,  4133,  4134,  4143,  4148,  4149,  4158,  4159,  4170,  4177,
    4178,  4187,  4188,  4199,  4206,  4208,  4211,  4214,  4215,  4220,
    4224,  4230,  4233,  4234,  4235,  4243,  4245,  4246,  4247,  4254,
    4255,  4259,  4260,  4261,  4267,  4268,  4270,  4271,  4273,  4274,
    4277,  4281,  4285,  4287,  4289,  4290,  4298,  4299,  4307,  4309,
    4312,  4313,  4314,  4317,  4318,  4321,  4322,  4324,  4326,  4328,
    4330,  4334,  4336,  4340,  4342,  4344,  4346,  4348,  4350,  4352,
    4354,  4356,  4358,  4360,  4362,  4364,  4366,  4368,  4370,  4372,
    4374,  4376,  4378,  4380,  4382,  4384,  4386,  4388,  4390,  4391,
    4393,  4395,  4396,  4399,  4400,  4402,  4403,  4404,  4408,  4409,
    4410,  4414,  4417,  4418,  4419,  4424,  4429,  4432,  4433,  4435,
    4437,  4441,  4445,  4447,  4450,  4451,  4453,  4454,  4459,  4464,
    4467,  4468,  4470,  4472,  4473,  4475,  4476,  4478,  4481,  4483,
    4487,  4491,  4493,  4495,  4497,  4499,  4501,  4502,  4505,  4507,
    4509,  4511,  4513,  4515,  4517,  4519,  4521,  4523,  4525,  4527,
    4529,  4531,  4533,  4535,  4537,  4539,  4541,  4543,  4545,  4547,
    4549,  4551,  4552,  4553,  4560,  4561,  4563,  4567,  4569,  4573,
    4574,  4577,  4581,  4583,  4586,  4588,  4589,  4593,  4594,  4595,
    4603,  4606,  4608,  4609,  4613,  4614,  4622,  4623,  4630,  4635,
    4642,  4647,  4652,  4657,  4658,  4665,  4670,  4675,  4681,  4688,
    4693,  4695,  4699,  4701,  4703,  4707,  4709,  4710,  4713,  4714,
    4716,  4717,  4718,  4727,  4728,  4729,  4736,  4737,  4739,  4741,
    4743,  4745,  4747,  4750,  4752,  4754,  4756,  4760,  4765,  4766,
    4770,  4774,  4776,  4779,  4782,  4783,  4787,  4788,  4794,  4798,
    4800,  4804,  4806,  4810,  4812,  4814,  4815,  4817,  4818,  4823,
    4824,  4826,  4830,  4832,  4834,  4836,  4837,  4838,  4845,  4846,
    4847,  4859,  4863,  4865,  4869,  4873,  4875,  4879,  4880,  4882,
    4883,  4888,  4889,  4896,  4897,  4903,  4904,  4911,  4913,  4917,
    4920,  4925,  4926,  4929,  4930,  4933,  4935,  4937,  4939,  4940,
    4945,  4946,  4948,  4949,  4951,  4953,  4957,  4959,  4961,  4964,
    4967,  4970,  4972,  4974,  4976,  4978,  4979,  4983,  4984,  4988,
    4991,  4996,  5001,  5005,  5010,  5015,  5017,  5021,  5025,  5032,
    5035,  5038,  5039,  5046,  5047,  5054,  5060,  5063,  5065,  5067,
    5069,  5075,  5081,  5084,  5087,  5089,  5094,  5098,  5101,  5105,
    5108,  5111,  5113,  5117,  5122,  5126,  5130,  5133,  5136,  5140,
    5144,  5148,  5152,  5156,  5160,  5164,  5168,  5170,  5172,  5174,
    5176,  5178,  5179,  5181,  5182,  5185,  5186,  5188,  5190,  5192,
    5193,  5196,  5197,  5200,  5201,  5204,  5207,  5208,  5213,  5214,
    5219,  5221,  5223,  5224,  5226,  5228,  5229,  5231,  5233,  5234,
    5239,  5240,  5241,  5247,  5249,  5250,  5254,  5258,  5260,  5263,
    5266,  5269,  5272,  5275,  5278,  5281,  5283,  5285,  5287,  5289,
    5291,  5293,  5295,  5297,  5298,  5300,  5301,  5305,  5309,  5311,
    5312,  5316,  5318,  5321,  5322,  5324,  5325,  5329,  5333,  5336,
    5339,  5343,  5344,  5346,  5348,  5351,  5352,  5353,  5354,  5355,
    5377,  5379,  5381,  5382,  5384,  5385,  5387,  5389,  5390,  5392,
    5394,  5395,  5398,  5401,  5403,  5407,  5412,  5416,  5420,  5421,
    5424,  5427,  5429,  5433,  5437,  5438,  5443,  5444,  5448,  5450,
    5452,  5453,  5457,  5460,  5464,  5466,  5468,  5471,  5472,  5475,
    5479,  5481,  5487,  5489,  5491,  5494,  5497,  5499,  5501,  5503,
    5505,  5507,  5510,  5513,  5515,  5517,  5519,  5521,  5523,  5525,
    5527,  5530,  5533,  5536,  5539,  5542,  5544,  5546,  5548,  5550,
    5552,  5554,  5556,  5560,  5566,  5568,  5570,  5572,  5574,  5576,
    5580,  5585,  5591,  5593,  5599,  5603,  5606,  5608,  5612,  5615,
    5618,  5623,  5625,  5627,  5629,  5631,  5633,  5635,  5637,  5639,
    5641,  5643,  5645,  5647,  5649,  5651,  5655,  5658,  5660,  5662,
    5664,  5666,  5668,  5670,  5672,  5674,  5676,  5678,  5680,  5682,
    5684,  5686,  5688,  5690,  5692,  5694,  5696,  5698,  5700,  5702,
    5704,  5706,  5708,  5710,  5712,  5714,  5716,  5718,  5720,  5722,
    5724,  5726,  5728,  5730,  5732,  5734,  5736,  5738,  5740,  5742,
    5744,  5746,  5748,  5750,  5752,  5754,  5756,  5758,  5760,  5762,
    5764,  5766,  5768,  5770,  5772,  5774,  5776,  5778,  5780,  5782,
    5784,  5786,  5788,  5790,  5792,  5794,  5796,  5798,  5800,  5802,
    5804,  5806,  5808,  5810,  5812,  5814,  5816,  5818,  5820,  5822,
    5824,  5826,  5828,  5830,  5832,  5834,  5836,  5838,  5840,  5842,
    5844,  5846,  5848,  5850,  5852,  5854,  5856,  5858,  5860,  5862,
    5864,  5866,  5868,  5870,  5872,  5874,  5876,  5878,  5880,  5882,
    5884,  5886,  5888,  5890,  5892,  5894,  5896,  5898,  5900,  5902,
    5904,  5906,  5908,  5910,  5912,  5914,  5916,  5918,  5920,  5922,
    5924,  5926,  5928,  5930,  5932,  5934,  5936,  5938,  5940,  5942,
    5944,  5946,  5948,  5950,  5952,  5954,  5956,  5958,  5960,  5962,
    5964,  5966,  5968,  5970,  5972,  5974,  5976,  5978,  5980,  5982,
    5984,  5986,  5988,  5990,  5992,  5994,  5996,  5998,  6000,  6002,
    6004,  6006,  6008,  6010,  6012,  6014,  6016,  6018,  6020,  6022,
    6024,  6026,  6028,  6030,  6032,  6034,  6036,  6038,  6040,  6042,
    6044,  6046,  6048,  6050,  6052,  6054,  6056,  6058,  6060,  6062,
    6064,  6066,  6068,  6070,  6072,  6074,  6076,  6078,  6080,  6082,
    6084,  6086,  6088,  6090,  6092,  6094,  6096,  6098,  6100,  6102,
    6104,  6106,  6108,  6110,  6112,  6114,  6116,  6118,  6120,  6122,
    6124,  6126,  6128,  6130,  6132,  6134,  6136,  6138,  6140,  6142,
    6144,  6146,  6148,  6150,  6152,  6154,  6156,  6158,  6160,  6162,
    6164,  6166,  6168,  6170,  6172,  6174,  6176,  6178,  6180,  6182,
    6184,  6186,  6188,  6190,  6192,  6194,  6196,  6198,  6200,  6202,
    6204,  6206,  6208,  6210,  6212,  6214,  6216,  6218,  6220,  6222,
    6224,  6226,  6228,  6230,  6232,  6234,  6236,  6238,  6240,  6242,
    6244,  6246,  6248,  6250,  6252,  6254,  6256,  6258,  6260,  6262,
    6264,  6266,  6268,  6270,  6272,  6274,  6276,  6278,  6280,  6282,
    6284,  6286,  6288,  6290,  6292,  6294,  6296,  6298,  6300,  6302,
    6304,  6306,  6308,  6310,  6312,  6314,  6315,  6320,  6321,  6323,
    6325,  6329,  6330,  6333,  6335,  6337,  6339,  6341,  6342,  6344,
    6345,  6347,  6349,  6351,  6352,  6355,  6358,  6361,  6363,  6366,
    6371,  6377,  6382,  6389,  6392,  6396,  6400,  6404,  6410,  6412,
    6416,  6420,  6423,  6426,  6429,  6431,  6433,  6438,  6443,  6445,
    6447,  6449,  6451,  6453,  6454,  6459,  6461,  6463,  6465,  6469,
    6473,  6475,  6477,  6480,  6483,  6484,  6488,  6493,  6497,  6498,
    6506,  6508,  6511,  6513,  6515,  6517,  6519,  6521,  6523,  6524,
    6530,  6532,  6534,  6536,  6538,  6540,  6544,  6551,  6558,  6565,
    6573,  6579,  6583,  6592,  6601,  6610,  6617,  6618,  6620,  6622,
    6625,  6626,  6628,  6630,  6634,  6635,  6639,  6640,  6644,  6645,
    6649,  6650,  6654,  6656,  6658,  6660,  6662,  6664,  6666,  6668,
    6670,  6672,  6674,  6676,  6679,  6682,  6684,  6688,  6691,  6694,
    6697,  6700,  6703,  6706,  6709,  6712,  6714,  6716,  6719,  6720,
    6722,  6726,  6728,  6731,  6734,  6737,  6739,  6743,  6747,  6749,
    6751,  6755,  6757,  6761,  6766,  6772,  6777,  6784,  6786,  6787,
    6791,  6795,  6797,  6799,  6800,  6803,  6806,  6809,  6812,  6813,
    6816,  6817,  6821,  6824,  6826,  6829,  6832,  6835,  6838,  6841,
    6842,  6846,  6847,  6849,  6850,  6854,  6857,  6858,  6860,  6863,
    6864,  6866,  6871,  6876,  6882,  6885,  6889,  6890,  6892,  6893,
    6898,  6899,  6901,  6903,  6904,  6906,  6907,  6910,  6913,  6915,
    6916,  6918,  6920,  6923,  6927,  6930,  6931,  6938,  6942,  6943,
    6944,  6945,  6947,  6950,  6952,  6954,  6956,  6958,  6960,  6962,
    6964,  6966,  6968,  6971,  6974,  6978,  6980,  6982,  6984,  6986,
    6988,  6990,  6992,  6994,  6996,  6998,  7000,  7002,  7004,  7005,
    7009,  7011,  7014,  7016,  7019,  7023,  7027,  7031,  7032,  7036,
    7040,  7041,  7049,  7050,  7054,  7056,  7060,  7061,  7065,  7068,
    7073,  7074,  7078,  7083,  7088,  7089,  7090,  7091,  7108,  7117,
    7125,  7126,  7127,  7128,  7129,  7130,  7146,  7147,  7148,  7149,
    7150,  7163,  7168,  7173,  7177,  7182,  7186,  7189,  7191,  7195,
    7201,  7203,  7205,  7206,  7208,  7210,  7211,  7214,  7215,  7216,
    7220,  7221,  7224,  7230
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     613,     0,    -1,   148,    -1,    -1,   616,   614,   608,   615,
      -1,   616,   148,    -1,    -1,   148,    -1,   617,    -1,  1426,
      -1,   960,    -1,  1017,    -1,  1019,    -1,   666,    -1,   629,
      -1,  1020,    -1,  1009,    -1,  1432,    -1,   636,    -1,   618,
      -1,  1256,    -1,  1288,    -1,  1208,    -1,  1210,    -1,   622,
      -1,  1294,    -1,  1400,    -1,  1391,    -1,   627,    -1,  1220,
      -1,  1496,    -1,  1313,    -1,  1316,    -1,  1383,    -1,  1025,
      -1,  1033,    -1,   809,    -1,  1040,    -1,   620,    -1,  1309,
      -1,  1435,    -1,  1028,    -1,  1012,    -1,  1223,    -1,  1303,
      -1,   701,    -1,  1398,    -1,  1433,    -1,  1434,    -1,  1052,
      -1,  1366,    -1,   694,    -1,  1274,    -1,   998,    -1,  1001,
      -1,  1267,    -1,  1497,    -1,  1389,    -1,  1248,    -1,  1315,
      -1,  1488,    -1,   619,   380,  1360,    -1,   115,    -1,   136,
      -1,   380,  1360,   182,   621,    -1,  1357,    -1,   609,  1362,
      -1,    -1,   161,  1360,   623,   624,    -1,    -1,   561,   625,
      -1,   625,   604,   626,    -1,   626,    -1,   609,  1362,    -1,
      -1,   200,   628,  1362,    -1,    -1,    56,   286,   529,   630,
     631,    -1,   632,    -1,   631,   604,   632,    -1,   273,   152,
    1357,    -1,   287,   152,  1357,    -1,   276,   152,  1357,    -1,
     277,   152,  1188,    -1,   272,   152,  1188,    -1,   284,   152,
    1188,    -1,   280,   152,  1357,    -1,   279,   152,  1357,    -1,
     281,   152,  1357,    -1,   282,   152,  1357,    -1,   283,   152,
    1357,    -1,   285,   152,  1188,    -1,   288,   152,  1345,    -1,
     214,   152,   602,   633,   603,    -1,   635,    -1,    -1,   634,
      -1,   633,   604,   634,    -1,  1188,    -1,   274,   152,  1357,
      -1,   275,   152,  1190,    -1,   410,   152,  1357,    -1,   411,
     152,  1188,    -1,    -1,    94,   861,   512,   864,  1353,   637,
     798,    -1,    -1,    94,   938,   217,  1360,   942,   347,  1353,
     638,   602,   955,   603,   943,    -1,    -1,    94,   939,   217,
    1360,   941,   347,  1353,   639,   602,   955,   603,   944,    -1,
      -1,    94,   940,   217,  1360,   941,   347,  1353,   640,   602,
     955,   603,   945,    -1,    -1,    94,   102,   864,  1360,   641,
     858,    -1,    -1,    94,   642,  1454,    -1,    94,   558,   659,
    1416,    -1,    94,   263,   194,   761,    -1,    94,   510,   758,
      -1,    94,   643,    -1,   453,  1362,   179,   105,   584,  1362,
     352,   602,   644,   603,    -1,   645,    -1,   644,   604,   645,
      -1,   558,  1357,    -1,   203,  1357,    -1,   102,  1357,    -1,
     362,  1357,    -1,   371,  1357,    -1,   469,  1357,    -1,   377,
    1188,    -1,    -1,  1069,   159,   864,   660,   647,   347,   442,
     648,   653,   650,   655,   135,   656,    -1,    -1,   160,  1073,
    1160,   649,   651,   652,    -1,    22,  1073,    -1,    -1,   144,
      -1,   129,   347,   465,    -1,   129,    -1,    -1,   488,  1073,
      -1,    -1,   147,  1073,    -1,    -1,   654,    -1,   347,    77,
     381,    -1,   347,    77,   336,   381,    -1,    -1,    73,  1357,
      -1,    -1,   657,   658,    -1,   707,    -1,   709,    -1,   705,
      -1,   726,    -1,   744,    -1,   746,    -1,   741,    -1,   711,
      -1,   713,    -1,   714,    -1,   715,    -1,   716,    -1,   718,
      -1,    -1,  1360,   610,  1360,    -1,  1360,    -1,    -1,   661,
     663,    -1,    -1,   662,   664,    -1,    73,  1357,    -1,   242,
     484,    -1,   338,   484,    -1,    87,   484,    -1,   396,   484,
     105,    -1,   313,   484,   105,    -1,   665,    -1,   663,    -1,
     127,    -1,  1079,   127,    -1,   484,   446,   120,    -1,   484,
     446,   229,    -1,    -1,    49,   660,   667,   668,    -1,    -1,
     602,   669,   603,    -1,    -1,   670,    -1,   670,   604,  1073,
      -1,  1073,    -1,    -1,   672,    -1,   672,   604,   674,    -1,
     674,    -1,    -1,  1360,   673,   910,    -1,    -1,   676,    -1,
     676,   604,   677,    -1,   677,    -1,   678,   673,  1360,   910,
      -1,    -1,   230,    -1,   361,    -1,   221,    -1,    -1,   679,
     704,   608,    -1,   704,   608,    -1,   680,   704,   608,    -1,
      -1,   681,   682,   608,    -1,    -1,   118,   702,   683,   910,
     703,    -1,   118,  1360,    80,   180,   690,    -1,    -1,   118,
     687,   197,   180,   684,   688,   704,    -1,   118,  1360,    99,
     180,   685,    -1,    -1,   686,  1052,    -1,   163,    -1,    89,
      -1,   689,    -1,   688,   604,   689,    -1,   693,    -1,  1188,
      -1,   691,    -1,   476,   692,  1358,    -1,    -1,   566,    -1,
     690,    -1,  1360,    -1,   477,    -1,  1079,   181,    -1,   475,
      -1,   462,   695,   697,    -1,  1360,    -1,   691,    -1,    -1,
     695,    -1,    -1,   455,   698,    -1,   700,   152,   699,    -1,
     698,   604,   700,   152,   699,    -1,  1344,    -1,  1100,    -1,
    1349,    -1,    63,    -1,   497,    -1,    84,    -1,    86,    -1,
      85,    -1,    54,    -1,   443,    -1,   514,    -1,    72,    -1,
     100,    -1,   304,    -1,   321,    -1,   425,   696,   697,    -1,
    1360,    -1,   702,   604,  1360,    -1,    -1,   119,  1073,    -1,
     707,    -1,   709,    -1,   705,    -1,   726,    -1,   744,    -1,
     746,    -1,   741,    -1,   711,    -1,   713,    -1,   714,    -1,
     715,    -1,   716,    -1,   718,    -1,    -1,   212,   706,   721,
     146,   212,    -1,    -1,   708,   617,    -1,    -1,   431,   710,
    1073,    -1,    -1,   712,   750,    -1,   247,  1361,    -1,   236,
    1361,    -1,   350,  1360,    -1,    -1,   171,   719,  1360,   227,
     717,   720,    -1,    65,  1360,    -1,    -1,   332,   182,    -1,
     182,    -1,  1360,    -1,   720,   604,  1360,    -1,    -1,    -1,
      -1,   722,  1073,   521,   723,   680,   724,   725,    -1,    -1,
     143,   721,    -1,   142,   680,    -1,   727,    -1,   730,    -1,
      -1,    -1,    52,   728,  1073,   729,   732,   740,   146,    52,
      -1,    -1,    52,   731,   733,   740,   146,    52,    -1,   734,
      -1,   732,   734,    -1,   737,    -1,   733,   737,    -1,    -1,
      -1,   577,   735,  1073,   736,   521,   680,    -1,    -1,    -1,
     577,   738,  1073,   739,   521,   680,    -1,    -1,   142,   680,
      -1,    -1,  1361,   611,   742,   750,   743,    -1,    -1,  1361,
      -1,    -1,  1361,   611,   745,   748,   743,    -1,    -1,   747,
     748,    -1,    -1,    30,   749,   681,   679,   146,    -1,   269,
     680,   146,   269,    -1,    -1,    -1,   579,   751,  1073,   135,
     752,   680,   146,   579,    -1,    -1,   420,   680,   554,   753,
    1073,   146,   420,    -1,    29,    -1,     8,    -1,   223,    -1,
     555,    -1,   123,    -1,   783,   785,    -1,   783,    56,   780,
     764,    -1,   783,     6,   780,   759,   768,    -1,    -1,   560,
     263,   194,  1360,    -1,   783,     6,   780,   771,    -1,   783,
     136,   780,   771,    -1,   784,   763,   774,    -1,   784,   763,
     777,    -1,     6,   781,    -1,     6,   782,    -1,    -1,   765,
     766,    -1,   767,    -1,   766,   767,    -1,   766,   604,   767,
      -1,   786,    -1,   787,    -1,   788,    -1,   769,    -1,   770,
      -1,   769,   770,    -1,   769,   604,   770,    -1,   786,    -1,
     787,    -1,   788,    -1,   789,    -1,   792,    -1,   794,    -1,
     796,    -1,   793,    -1,   772,    -1,   773,    -1,   772,   773,
      -1,   772,   604,   773,    -1,   786,    -1,   787,    -1,   788,
      -1,   794,    -1,   796,    -1,   775,    -1,   776,    -1,   775,
     776,    -1,   775,   604,   776,    -1,   786,    -1,   790,    -1,
     791,    -1,   792,    -1,   794,    -1,   796,    -1,   793,    -1,
     778,    -1,   779,    -1,   778,   779,    -1,   778,   604,   779,
      -1,   786,    -1,   794,    -1,   796,    -1,   104,  1357,    -1,
     544,  1357,    -1,   403,  1357,    -1,  1360,    -1,  1360,    -1,
     397,    -1,   399,    -1,   336,     4,    -1,   219,  1240,   797,
      -1,    24,  1240,   797,    -1,   293,  1240,   797,    -1,   166,
    1240,   797,    -1,   545,  1240,   797,    -1,   404,  1240,   797,
      -1,   333,  1240,  1189,    -1,    73,  1240,  1357,    -1,  1281,
     150,  1240,   872,    -1,    -1,   796,    -1,   574,    -1,   339,
      -1,  1189,    -1,   209,    -1,   602,   799,    -1,   865,   804,
     801,    -1,   252,  1353,    -1,   602,   252,  1353,   603,    -1,
     878,   603,   865,   804,   801,    -1,    -1,   804,   854,   603,
     800,  1439,    -1,    -1,    -1,  1324,   857,   854,   802,  1436,
      -1,    -1,  1324,   857,   602,   854,   603,   803,  1439,    -1,
     805,    -1,    -1,   806,    -1,    -1,   370,   808,   807,   811,
      -1,    -1,    -1,   370,   810,   811,    -1,    46,   812,   822,
     823,   830,    -1,   814,   240,   815,   602,   816,   603,    -1,
      -1,   814,   198,   813,   820,    -1,   395,   820,    -1,   395,
     819,    -1,   257,   820,    -1,   257,   819,    -1,    -1,   254,
      -1,    -1,    11,   152,  1189,    -1,    -1,   817,    -1,   818,
      -1,   817,   604,   818,    -1,  1360,    -1,    70,   602,   816,
     603,    -1,   602,  1069,   828,  1070,   603,    -1,   602,  1069,
     828,  1070,   603,    -1,    -1,   369,  1189,    -1,    -1,    -1,
     501,    46,   814,   198,   821,   824,   829,    -1,    -1,   501,
      46,   814,   240,   815,   602,   826,   603,   825,   829,    -1,
     827,    -1,   826,   604,   827,    -1,  1360,    -1,  1076,    -1,
      -1,   500,  1189,    -1,    -1,   602,   831,   603,    -1,   832,
      -1,   831,   604,   832,    -1,    -1,   370,   833,   834,   835,
     851,   846,    -1,  1360,    -1,    -1,    -1,   565,   249,   520,
     836,   838,    -1,    -1,   565,   230,   837,   839,    -1,   297,
      -1,   841,    -1,   841,    -1,   602,   840,   603,    -1,   841,
      -1,   840,   604,   841,    -1,    -1,    -1,   602,   842,   844,
     843,   603,    -1,   845,    -1,   844,   604,   845,    -1,   297,
      -1,  1076,    -1,    -1,   602,   847,   603,    -1,   848,    -1,
     847,   604,   848,    -1,    -1,   501,   849,   850,   851,    -1,
    1362,    -1,    -1,   852,    -1,   852,   853,    -1,   853,    -1,
     510,  1240,  1362,    -1,  1281,   150,  1240,   872,    -1,   333,
    1240,  1189,    -1,   292,  1240,  1191,    -1,   310,  1240,  1191,
      -1,   105,   128,  1240,  1357,    -1,   217,   128,  1240,  1357,
      -1,    73,  1240,  1357,    -1,    -1,    -1,   447,   855,  1063,
    1067,   856,   876,    -1,    -1,    18,    -1,    -1,   859,    -1,
     860,    -1,   859,   860,    -1,   871,    -1,   870,    -1,    -1,
     862,    -1,   863,    -1,   863,   862,    -1,   515,    -1,    -1,
     212,  1079,   162,    -1,    -1,   867,    -1,   868,    -1,   868,
     866,    -1,   868,    -1,   868,   867,    -1,   868,   604,   867,
      -1,   150,  1240,   872,    -1,   292,  1240,  1190,    -1,   310,
    1240,  1190,    -1,    26,  1240,  1188,    -1,   371,  1240,  1357,
      -1,    73,  1240,  1357,    -1,    25,  1240,  1190,    -1,   363,
    1240,  1188,    -1,   363,  1240,   119,    -1,    60,  1240,  1188,
      -1,   513,  1240,  1188,    -1,   122,  1240,  1188,    -1,   438,
    1240,   874,    -1,    -1,   549,  1240,   869,   602,  1302,   603,
      -1,   870,    -1,   871,    -1,   224,  1240,   875,    -1,   105,
     128,  1240,  1357,    -1,   217,   128,  1240,  1357,    -1,   510,
    1360,    -1,   494,   131,    -1,   494,   302,    -1,    81,  1240,
    1357,    -1,   239,  1240,  1188,    -1,   921,   912,  1240,   914,
      -1,   921,    68,  1240,   920,    -1,  1362,    -1,  1362,    -1,
     119,    -1,   174,    -1,   140,    -1,    78,    -1,   405,    -1,
      76,    -1,   338,    -1,   173,    -1,   243,    -1,  1183,    -1,
    1062,  1066,    -1,   496,    -1,   400,    -1,   117,    -1,   228,
      -1,   879,    -1,   880,    -1,   879,   604,   880,    -1,   881,
      -1,   882,    -1,   887,   883,    -1,   887,   927,    -1,   933,
     957,   942,   602,   955,   603,   943,    -1,   939,   936,   957,
     941,   602,   955,   603,   944,    -1,   940,   936,   957,   941,
     602,   955,   603,   945,    -1,   885,   934,   957,   942,   602,
     955,   603,   943,    -1,   885,   179,   240,   957,   602,   955,
     603,   927,    -1,   885,   884,    -1,    -1,   884,    -1,    61,
     602,  1073,   603,    -1,    -1,   886,    -1,    83,   957,    -1,
      -1,  1352,   888,   889,   907,    -1,   897,   905,   901,    -1,
     898,   906,   901,    -1,   176,   899,   901,    -1,    38,    -1,
      38,   904,    -1,    43,    -1,    42,    -1,   893,   904,   924,
      -1,   893,   924,    -1,   894,   904,   925,    -1,   894,   925,
      -1,    33,   904,    -1,    33,    -1,   895,   904,   924,    -1,
     896,   904,   925,    -1,   567,   904,    -1,   591,   905,   901,
      -1,   109,    -1,   525,    -1,   522,    -1,   106,    -1,   526,
      -1,    40,   905,    -1,   892,    -1,   298,    -1,   265,    -1,
     268,   567,    -1,   268,   895,   924,    -1,   528,   924,    -1,
     519,   905,   924,    -1,   300,   924,    -1,   266,   924,    -1,
     117,   899,   901,    -1,   343,   899,   901,    -1,   174,   899,
     901,    -1,    -1,   151,   890,   602,   959,   603,   924,    -1,
      -1,   455,   891,   602,   959,   603,   924,    -1,   268,   924,
      -1,   451,    -1,   189,    -1,   188,    -1,   375,    -1,   318,
      -1,   256,    -1,   317,    -1,   376,    -1,   319,    -1,    59,
      -1,   327,    -1,   324,    59,    -1,   893,   571,    -1,   568,
      -1,   324,   568,    -1,   344,    -1,   327,   568,    -1,   324,
      59,   571,    -1,   327,   571,    -1,   228,    -1,   527,    -1,
     467,    -1,   299,    -1,    32,    -1,   400,    -1,   134,    -1,
     134,   379,    -1,    -1,   904,    -1,   900,    -1,   602,   342,
     604,   342,   603,    -1,    -1,   902,    -1,   902,   903,    -1,
     903,    -1,   463,    -1,   553,    -1,   592,    -1,   602,   267,
     603,    -1,   602,   540,   603,    -1,   602,   116,   603,    -1,
     602,   342,   603,    -1,    -1,   904,    -1,    -1,   900,    -1,
      -1,   908,    -1,   908,   909,    -1,   909,    -1,   341,    -1,
    1079,   341,    -1,   119,   911,    -1,   347,   555,   337,  1072,
      -1,    25,    -1,   451,   119,   566,    -1,   926,   240,    -1,
     550,    -1,   550,   240,    -1,    73,  1357,    -1,    68,   918,
      -1,   889,   919,    -1,   337,  1072,    -1,  1343,    -1,    59,
     455,    -1,    58,    -1,  1362,    -1,    33,    -1,   913,    -1,
     119,    -1,    -1,   912,   914,    -1,  1362,    -1,    33,    -1,
     916,    -1,   119,    -1,  1362,    -1,    -1,    68,   920,    -1,
     918,    -1,   119,    -1,    -1,   119,    -1,    20,    -1,    33,
      20,    -1,    20,    33,    -1,   547,    -1,   547,    33,    -1,
      33,   547,    -1,    -1,   922,    -1,   923,    -1,    47,    -1,
     912,   913,   925,    -1,    33,    -1,    33,   912,   913,    -1,
      -1,    33,    -1,    -1,   383,    -1,   406,  1353,   928,   930,
     931,    -1,    -1,   602,   929,   603,    -1,   929,   604,  1360,
      -1,  1360,    -1,    -1,   289,   183,    -1,   289,   367,    -1,
     289,   464,    -1,    -1,   347,   555,   932,    -1,   347,   123,
     932,    -1,   347,   555,   932,   347,   123,   932,    -1,   347,
     123,   932,   347,   555,   932,    -1,   428,    -1,    50,    -1,
     455,   341,    -1,   338,     5,    -1,   455,   119,    -1,   935,
      -1,   383,   240,    -1,   550,   936,    -1,   240,    -1,   217,
      -1,    -1,   935,    -1,   238,    -1,   217,    -1,   216,    -1,
      -1,   550,    -1,   184,    -1,   473,    -1,    -1,   941,    -1,
     941,   949,    -1,    -1,   946,    -1,    -1,   948,    -1,    -1,
     947,    -1,   951,    -1,   946,   951,    -1,   952,    -1,   947,
     952,    -1,   953,    -1,   948,   953,    -1,   561,   954,    -1,
     538,   954,    -1,   239,  1240,  1188,    -1,    73,  1357,    -1,
     950,    -1,   949,    -1,   950,    -1,   950,    -1,   580,   366,
    1356,    -1,    45,    -1,   440,    -1,   198,    -1,   955,   604,
     956,  1181,    -1,   956,  1181,    -1,  1360,    -1,  1360,   602,
     342,   603,    -1,    -1,  1352,    -1,    -1,   610,  1360,    -1,
    1341,    -1,   959,   604,  1341,    -1,    -1,    13,   994,   512,
    1353,   961,   972,    -1,    -1,    13,   102,   971,   962,   859,
      -1,    13,   102,  1360,   556,   105,   128,   323,    -1,    -1,
      13,   385,   660,   963,   661,    -1,    -1,    13,   185,   660,
     964,   661,    -1,    -1,    13,  1462,  1457,   965,  1464,    -1,
      -1,    13,  1457,   966,  1464,    -1,    -1,    13,  1457,   159,
     660,   967,   968,   969,   650,   655,   970,    -1,    13,   510,
     760,    -1,    13,   263,   194,   762,    -1,    13,   510,   757,
      -1,    13,   510,   756,    -1,    13,   453,  1362,   352,   602,
     644,   603,    -1,    -1,   347,   442,   648,    -1,   654,    -1,
     347,   442,   648,   654,    -1,    -1,   416,   529,   660,    -1,
      -1,   135,   656,    -1,    -1,  1360,    -1,    -1,   130,   510,
      -1,   215,   510,    -1,   987,   805,    -1,   987,   976,    -1,
     976,    -1,   806,    -1,   978,    -1,   136,   370,   985,    -1,
     401,   370,  1027,   977,    -1,    -1,   351,   370,  1027,   977,
     973,  1027,    -1,    14,   370,  1027,   977,    -1,    -1,    61,
     370,   977,   974,  1022,    -1,    -1,   418,   370,  1027,   977,
     975,  1014,    -1,    66,   370,  1027,  1189,    -1,   536,   370,
     977,    -1,   981,    -1,   415,   368,    -1,    12,    -1,   985,
      -1,    -1,     6,   370,  1027,   979,   980,    -1,    -1,   602,
     831,   603,    -1,   369,  1189,    -1,    -1,   417,   370,  1027,
     982,   983,    -1,    -1,    -1,   985,   984,   227,   602,   831,
     603,    -1,   986,    -1,   985,   604,   986,    -1,  1360,    -1,
     989,    -1,   987,   604,   989,    -1,     6,   993,    -1,   988,
     881,   996,    -1,     6,   882,    -1,   988,   602,   878,   603,
      -1,    -1,    56,   993,  1352,   990,   887,   996,    -1,    -1,
      -1,   314,   993,  1352,   991,   889,   907,   992,   996,    -1,
     136,   993,  1352,   995,    -1,   136,   179,   240,   957,    -1,
     136,   383,   240,    -1,   136,   935,  1352,    -1,   129,   238,
      -1,   144,   238,    -1,    13,   993,  1352,   455,   119,  1343,
      -1,    13,   993,  1352,   136,   119,    -1,   416,   997,  1353,
      -1,    91,   529,   912,   914,   919,    -1,   866,    -1,   178,
      -1,  1174,    -1,    -1,    71,    -1,    -1,   213,    -1,    -1,
     428,    -1,    50,    -1,    -1,     8,  1360,    -1,   173,    -1,
      -1,   529,    -1,   152,    -1,    18,    -1,    -1,   489,   465,
    1003,   999,  1007,    -1,   493,   465,  1003,    -1,    -1,   465,
     489,  1003,  1000,  1007,    -1,   465,   493,  1003,    -1,   489,
     531,  1002,    -1,    -1,   580,    82,   468,    -1,    -1,  1004,
    1005,    -1,  1006,    -1,  1005,   604,  1006,    -1,    -1,   485,
      -1,   412,    -1,    -1,   554,  1008,    -1,   635,    -1,  1008,
     604,   635,    -1,    -1,    60,  1385,  1010,  1214,  1011,    -1,
      -1,   394,    -1,   165,    -1,    -1,   418,  1027,  1385,  1013,
    1214,  1014,    -1,    -1,  1015,    -1,  1016,    -1,  1016,  1015,
      -1,   394,    -1,   165,    -1,   559,    -1,    -1,    14,  1027,
    1385,  1018,  1214,    -1,    34,  1357,    -1,    -1,    61,  1385,
    1021,  1214,  1022,    -1,    -1,  1023,    -1,  1024,    -1,  1024,
    1023,    -1,   394,    -1,   169,    -1,   301,    -1,   165,    -1,
      57,    -1,   180,   556,    -1,    -1,   351,  1027,  1385,  1026,
    1214,    -1,    -1,   340,    -1,   259,    -1,    -1,   416,  1385,
    1029,  1031,    -1,   416,   558,   659,  1030,    -1,  1363,   529,
    1363,    -1,  1030,   604,  1363,   529,  1363,    -1,  1032,    -1,
    1031,   604,  1032,    -1,  1353,   529,  1353,    -1,    -1,    48,
     217,  1034,  1035,   230,  1039,    -1,  1036,    -1,  1038,    -1,
    1037,    -1,  1036,   604,  1037,    -1,  1353,  1048,    -1,  1353,
    1046,  1048,    -1,  1360,    -1,   119,    -1,    -1,   258,   217,
     227,    48,  1041,  1042,    -1,  1045,    -1,  1043,    -1,  1044,
      -1,  1043,   604,  1044,    -1,  1353,  1048,  1051,    -1,  1353,
    1046,  1048,  1051,    -1,    -1,   370,   808,  1047,   602,   977,
     603,    -1,    -1,  1049,  1050,    -1,    -1,   935,   602,  1156,
     603,    -1,    -1,   213,   246,    -1,  1053,    -1,   447,  1056,
      -1,   602,  1054,   603,  1439,    -1,   447,  1058,    -1,   602,
    1054,   603,    -1,   447,  1135,    -1,   602,  1055,   603,    -1,
      -1,  1058,  1057,  1436,    -1,    -1,    -1,  1059,  1063,  1067,
    1060,  1061,  1066,    -1,  1177,  1183,    -1,  1203,    -1,  1062,
      -1,  1203,  1062,    -1,  1062,  1203,    -1,   182,  1117,  1166,
    1171,  1168,  1177,  1183,  1194,    -1,   182,   137,  1166,  1183,
      -1,    -1,  1064,    -1,  1064,  1065,    -1,  1065,    -1,  1453,
      -1,   482,    -1,   480,    -1,    -1,   180,   555,    -1,   262,
     230,   457,   312,    -1,  1067,   604,  1068,    -1,  1068,    -1,
     597,    -1,  1069,  1347,  1070,    -1,  1069,  1073,  1070,  1071,
      -1,    -1,    -1,    -1,    18,  1360,    -1,    18,  1357,    -1,
    1360,    -1,  1357,    -1,    -1,   602,   603,    -1,  1073,  1077,
    1073,    -1,  1073,   589,  1073,    -1,  1073,  1078,  1073,    -1,
     336,  1073,    -1,  1074,   233,   535,    -1,  1074,   233,  1079,
     535,    -1,  1074,   233,   168,    -1,  1074,   233,  1079,   168,
      -1,  1074,   233,   551,    -1,  1074,   233,  1079,   551,    -1,
    1074,    -1,  1074,   233,   341,    -1,  1074,   233,  1079,   341,
      -1,  1074,   153,  1075,    -1,  1074,  1081,  1075,    -1,  1074,
    1081,  1082,   602,  1448,   603,    -1,  1075,    -1,  1076,   230,
     602,  1448,   603,    -1,  1076,  1079,   230,   602,  1448,   603,
      -1,  1076,   230,   602,  1073,   603,    -1,  1076,   230,   602,
    1073,   604,  1110,   603,    -1,  1076,  1079,   230,   602,  1073,
     603,    -1,  1076,  1079,   230,   602,  1073,   604,  1110,   603,
      -1,  1076,    31,  1076,    16,  1075,    -1,  1076,  1079,    31,
    1076,    16,  1075,    -1,  1076,   471,   252,  1076,    -1,  1076,
     252,  1083,  1170,    -1,  1076,  1079,   252,  1083,  1170,    -1,
    1076,   407,  1076,    -1,  1076,  1079,   407,  1076,    -1,  1076,
      -1,  1076,   593,  1076,    -1,  1076,   594,  1076,    -1,  1076,
     458,  1076,    -1,  1076,   459,  1076,    -1,  1076,   596,  1076,
      -1,  1076,   595,  1076,    -1,  1076,   596,   226,  1073,  1160,
      -1,  1076,   595,   226,  1073,  1160,    -1,  1076,   597,  1076,
      -1,  1076,   598,  1076,    -1,  1076,   599,  1076,    -1,  1076,
     133,  1076,    -1,  1076,   315,  1076,    -1,  1076,   600,  1076,
      -1,  1083,    -1,   358,    -1,   355,    -1,    16,    -1,    15,
      -1,   336,    -1,   335,    -1,   605,    -1,   335,    -1,   152,
      -1,   186,    -1,   196,    -1,   244,    -1,   271,    -1,   329,
      -1,    12,    -1,    17,    -1,  1349,    -1,  1084,    -1,  1085,
      -1,  1088,    -1,  1086,    -1,  1083,    68,  1362,    -1,  1344,
      -1,  1342,    -1,  1100,    -1,  1096,    -1,  1083,   357,  1083,
      -1,   596,  1083,    -1,   595,  1083,    -1,   601,  1083,    -1,
    1080,  1083,    -1,   602,  1448,   603,    -1,   602,  1073,   603,
      -1,   602,  1073,   604,  1110,   603,    -1,   439,   602,  1073,
     604,  1110,   603,    -1,   162,   602,  1448,   603,    -1,   606,
    1360,  1073,   607,    -1,   289,  1111,     9,   602,  1076,  1090,
     603,    -1,    33,  1083,    -1,    53,   602,  1073,    18,  1108,
     603,    -1,    52,  1113,  1115,  1114,   146,    -1,    91,   602,
    1073,   604,  1108,   603,    -1,    91,   602,  1073,   561,   913,
     603,    -1,   119,   602,  1349,   603,    -1,   565,   602,  1350,
     603,    -1,   226,  1073,  1160,   596,  1073,    -1,    59,   602,
    1110,   603,    -1,    59,   602,  1110,   561,   913,   603,    -1,
      98,  1072,    -1,   109,   602,  1073,   603,    -1,   114,   602,
    1073,   603,    -1,   208,   602,  1073,   603,    -1,   223,   602,
    1073,   604,  1073,   604,  1073,   604,  1073,   603,    -1,   226,
     602,  1073,   604,  1073,   603,    -1,   226,   602,  1073,   604,
    1073,   604,  1110,   603,    -1,   248,   602,  1073,   604,  1073,
     603,    -1,   309,   602,  1073,   603,    -1,   316,   602,  1073,
     603,    -1,   433,   602,  1073,   604,  1073,   603,    -1,   445,
     602,  1073,   603,    -1,   525,   602,  1073,   603,    -1,   522,
     602,  1073,   603,    -1,   522,   602,  1073,   604,  1073,   603,
      -1,   534,   602,  1073,   603,    -1,   534,   602,   245,  1073,
     182,  1073,   603,    -1,   534,   602,   530,  1073,   182,  1073,
     603,    -1,   534,   602,    44,  1073,   182,  1073,   603,    -1,
     534,   602,   245,   182,  1073,   603,    -1,   534,   602,   530,
     182,  1073,   603,    -1,   534,   602,    44,   182,  1073,   603,
      -1,   534,   602,  1073,   182,  1073,   603,    -1,   558,   602,
     603,    -1,   591,   602,  1073,   603,    -1,     7,   602,  1073,
     604,  1073,   603,    -1,     7,   602,  1073,   604,   226,  1073,
    1160,   603,    -1,    97,  1072,    -1,   101,  1072,    -1,   101,
     602,  1073,   603,    -1,   107,   602,  1073,   604,   226,  1073,
    1160,   603,    -1,   108,   602,  1073,   604,   226,  1073,  1160,
     603,    -1,   167,   602,  1160,   182,  1073,   603,    -1,   190,
     602,  1162,   604,  1073,   603,    -1,   337,  1072,    -1,   337,
     602,  1073,   603,    -1,   378,   602,  1076,   230,  1073,   603,
      -1,   498,   602,  1073,   604,  1073,   603,    -1,   498,   602,
    1073,   604,   226,  1073,  1160,   603,    -1,   502,   602,  1073,
     604,  1073,   604,  1073,   603,    -1,   502,   602,  1073,   604,
    1073,   603,    -1,   502,   602,  1073,   182,  1073,   180,  1073,
     603,    -1,   502,   602,  1073,   182,  1073,   603,    -1,   508,
    1072,    -1,   508,   602,  1073,   603,    -1,   523,   602,  1161,
     604,  1073,   604,  1073,   603,    -1,   524,   602,  1161,   604,
    1073,   604,  1073,   603,    -1,   562,  1072,    -1,   564,  1072,
      -1,   563,  1072,    -1,    20,   602,  1073,   603,    -1,    58,
     602,  1073,   603,    -1,    66,   602,  1110,   603,    -1,    69,
     602,  1073,   603,    -1,   102,   602,   603,    -1,   212,   602,
    1073,   604,  1073,   604,  1073,   603,    -1,   305,   602,  1073,
     603,    -1,   315,   602,  1073,   604,  1073,   603,    -1,   346,
     602,  1073,   603,    -1,   371,   602,  1073,   603,    -1,   392,
     602,  1073,   603,    -1,   420,   602,  1073,   604,  1073,   603,
      -1,   421,   602,  1073,   604,  1073,   604,  1073,   603,    -1,
     536,   602,  1073,   604,  1073,   603,    -1,   576,   602,  1073,
     603,    -1,   576,   602,  1073,   604,  1073,   603,    -1,  1087,
      -1,    87,   602,  1073,   604,  1073,   603,    -1,   188,   602,
    1110,   603,    -1,   256,   602,  1110,   603,    -1,   317,   602,
    1110,   603,    -1,   318,   602,  1110,   603,    -1,   319,   602,
    1110,   603,    -1,   375,   602,  1073,   604,  1073,   603,    -1,
     376,   602,  1110,   603,    -1,    -1,  1356,   602,  1089,  1093,
     603,    -1,  1360,   610,  1360,   602,  1109,   603,    -1,  1091,
    1092,    -1,   230,    42,   312,    -1,    -1,   230,   325,   242,
     312,    -1,    -1,   580,   393,   164,    -1,    -1,  1094,    -1,
    1095,    -1,  1094,   604,  1095,    -1,  1069,  1073,  1070,  1071,
      -1,    27,   602,  1106,   603,    -1,    27,   602,   132,  1106,
     603,    -1,    36,   602,  1106,   603,    -1,    37,   602,  1106,
     603,    -1,    39,   602,  1106,   603,    -1,    92,   602,  1165,
     597,   603,    -1,    92,   602,  1106,   603,    -1,    -1,    -1,
      92,   602,   132,  1097,  1110,  1098,   603,    -1,   311,   602,
    1106,   603,    -1,   311,   602,   132,  1106,   603,    -1,   294,
     602,  1106,   603,    -1,   294,   602,   132,  1106,   603,    -1,
     492,   602,  1106,   603,    -1,   570,   602,  1106,   603,    -1,
     491,   602,  1106,   603,    -1,   572,   602,  1106,   603,    -1,
     503,   602,  1106,   603,    -1,   503,   602,   132,  1106,   603,
      -1,    -1,   195,   602,  1103,  1099,  1110,  1105,  1104,   603,
      -1,    -1,   609,  1101,  1102,    -1,  1362,   456,  1073,    -1,
    1362,    -1,   609,  1375,  1362,   958,    -1,    -1,   132,    -1,
      -1,   449,  1341,    -1,    -1,  1178,    -1,    -1,  1165,  1107,
    1073,    -1,    33,   905,    -1,    59,   905,   924,    -1,   327,
     905,    -1,   463,    -1,   463,   228,    -1,   553,    -1,   553,
     228,    -1,   109,    -1,   525,    -1,   106,    -1,   117,   899,
      -1,    -1,  1110,    -1,  1073,    -1,  1110,   604,  1073,    -1,
    1112,    -1,   602,  1112,   603,    -1,  1349,    -1,  1112,   604,
    1349,    -1,    -1,  1073,    -1,    -1,   142,  1073,    -1,   577,
    1073,   521,  1073,    -1,  1115,   577,  1073,   521,  1073,    -1,
    1129,    -1,  1120,    -1,  1119,    -1,  1116,    -1,   606,  1360,
    1116,   607,    -1,  1118,    -1,  1119,   604,  1118,    -1,  1116,
    1128,  1116,    -1,  1116,   495,  1129,    -1,    -1,  1116,  1128,
    1116,   347,  1121,  1073,    -1,    -1,  1116,   495,  1129,   347,
    1122,  1073,    -1,    -1,  1116,  1128,  1116,   561,  1123,   602,
    1159,   603,    -1,  1116,   325,   237,  1129,    -1,    -1,  1116,
     248,  1145,   237,  1116,   347,  1124,  1073,    -1,    -1,  1116,
     248,  1145,   237,  1129,  1125,   561,   602,  1159,   603,    -1,
    1116,   325,   248,  1145,   237,  1129,    -1,    -1,  1116,   433,
    1145,   237,  1116,   347,  1126,  1073,    -1,    -1,  1116,   433,
    1145,   237,  1129,  1127,   561,   602,  1159,   603,    -1,  1116,
     325,   433,  1145,   237,  1129,    -1,   237,    -1,   220,   237,
      -1,    95,   237,    -1,    -1,  1130,  1353,  1164,  1154,    -1,
    1144,  1143,  1140,    -1,   602,  1143,  1131,   603,  1164,    -1,
    1138,  1440,    -1,    -1,    -1,  1131,   549,  1444,  1132,  1445,
    1133,  1440,    -1,  1135,    -1,    -1,    -1,  1136,  1451,  1067,
    1137,   876,  1066,    -1,    -1,  1143,  1139,  1119,    -1,    -1,
      -1,  1141,  1063,  1067,  1142,   876,    -1,    -1,   447,    -1,
      -1,   359,    -1,    -1,   180,   237,    -1,   180,   356,    46,
      -1,   180,   194,    46,    -1,   178,    -1,   213,    -1,    -1,
    1147,   935,  1146,  1149,   602,  1158,   603,    -1,    -1,   560,
     935,  1146,  1150,   602,  1156,   603,    -1,  1148,    -1,  1151,
    1148,    -1,    -1,    -1,  1153,  1151,    -1,    -1,  1155,  1152,
      -1,    -1,  1158,    -1,  1360,    -1,   383,    -1,  1157,    -1,
    1158,   604,  1157,    -1,  1360,    -1,  1159,   604,  1360,    -1,
    1161,    -1,   110,    -1,   111,    -1,   112,    -1,   113,    -1,
     205,    -1,   206,    -1,   207,    -1,   307,    -1,   308,    -1,
     444,    -1,   590,    -1,   114,    -1,   576,    -1,   208,    -1,
     309,    -1,   316,    -1,   392,    -1,   445,    -1,   305,    -1,
     591,    -1,   109,    -1,   525,    -1,   106,    -1,   522,    -1,
      -1,    18,    -1,   152,    -1,    -1,  1163,  1360,    -1,    -1,
      12,    -1,    -1,    -1,   578,  1167,  1073,    -1,    -1,    -1,
     199,  1169,  1073,    -1,   157,  1083,    -1,    -1,    -1,   194,
      46,  1172,  1173,    -1,  1172,   604,  1348,  1181,    -1,  1348,
    1181,    -1,    -1,   581,    -1,   582,    -1,   356,    46,  1175,
      -1,  1175,   604,  1176,    -1,  1176,    -1,  1350,  1181,    -1,
      -1,  1178,    -1,    -1,   356,    46,  1179,  1180,    -1,  1180,
     604,  1348,  1181,    -1,  1348,  1181,    -1,    -1,    19,    -1,
     124,    -1,    -1,  1184,    -1,    -1,  1184,    -1,   253,  1185,
      -1,  1186,    -1,  1186,   604,  1186,    -1,  1186,   345,  1186,
      -1,  1360,    -1,  1342,    -1,   540,    -1,   267,    -1,   342,
      -1,    -1,   253,  1186,    -1,   342,    -1,   201,    -1,   267,
      -1,   540,    -1,   116,    -1,   175,    -1,   342,    -1,   201,
      -1,   267,    -1,   540,    -1,  1192,    -1,   342,    -1,   540,
      -1,   267,    -1,   116,    -1,   175,    -1,   342,    -1,   540,
      -1,   267,    -1,  1192,    -1,  1193,    -1,   116,    -1,   175,
      -1,    -1,    -1,   385,  1360,  1195,   602,  1196,   603,    -1,
      -1,  1197,    -1,  1197,   604,  1198,    -1,  1198,    -1,  1069,
    1073,  1070,    -1,    -1,  1200,  1201,    -1,  1201,   604,  1202,
      -1,  1202,    -1,   609,  1362,    -1,  1362,    -1,    -1,   227,
    1204,  1205,    -1,    -1,    -1,   360,  1359,  1206,   915,  1207,
    1325,  1328,    -1,   138,  1359,    -1,  1199,    -1,    -1,   135,
    1209,  1110,    -1,    -1,   136,  1219,  1385,  1218,  1211,  1214,
     995,    -1,    -1,   136,   217,  1360,   347,  1353,  1212,    -1,
     136,   102,  1218,  1360,    -1,   136,   185,  1218,  1360,   610,
    1360,    -1,   136,   185,  1218,  1360,    -1,   136,   385,  1218,
     660,    -1,   136,   558,   659,  1415,    -1,    -1,   136,   573,
    1218,  1213,  1214,   995,    -1,   136,   159,  1218,   660,    -1,
     136,   533,  1218,   660,    -1,   136,   510,   783,   794,   795,
      -1,   136,   263,   194,   784,   794,   795,    -1,   136,   453,
    1218,  1362,    -1,  1215,    -1,  1214,   604,  1215,    -1,  1353,
      -1,  1217,    -1,  1216,   604,  1217,    -1,  1354,    -1,    -1,
     212,   162,    -1,    -1,   515,    -1,    -1,    -1,   223,  1221,
    1226,   994,  1228,  1222,  1230,  1246,    -1,    -1,    -1,   421,
    1224,  1227,  1228,  1225,  1230,    -1,    -1,   270,    -1,   121,
      -1,   202,    -1,  1255,    -1,   121,    -1,   227,  1229,    -1,
    1229,    -1,  1215,    -1,  1233,    -1,   602,   603,  1233,    -1,
     602,  1232,   603,  1233,    -1,    -1,   455,  1231,  1237,    -1,
    1232,   604,  1346,    -1,  1346,    -1,   565,  1236,    -1,   566,
    1236,    -1,    -1,   854,  1234,  1436,    -1,    -1,   602,   854,
     603,  1235,  1439,    -1,  1236,   604,  1241,    -1,  1241,    -1,
    1237,   604,  1238,    -1,  1238,    -1,  1350,  1239,  1245,    -1,
     152,    -1,   456,    -1,    -1,  1239,    -1,    -1,   602,  1242,
    1243,   603,    -1,    -1,  1244,    -1,  1244,   604,  1245,    -1,
    1245,    -1,  1073,    -1,   119,    -1,    -1,    -1,   347,   139,
    1247,   240,   555,  1253,    -1,    -1,    -1,   555,  1249,  1255,
     994,  1117,   455,  1251,  1250,  1166,  1177,  1187,    -1,  1251,
     604,  1252,    -1,  1252,    -1,  1350,  1239,  1245,    -1,  1253,
     604,  1254,    -1,  1254,    -1,  1350,  1239,  1245,    -1,    -1,
     270,    -1,    -1,   123,  1257,  1265,  1258,    -1,    -1,   182,
    1353,  1259,  1166,  1177,  1187,    -1,    -1,  1262,  1260,   182,
    1117,  1166,    -1,    -1,   182,  1216,  1261,   561,  1117,  1166,
      -1,  1263,    -1,  1262,   604,  1263,    -1,  1360,  1264,    -1,
    1360,   610,  1360,  1264,    -1,    -1,   610,   597,    -1,    -1,
    1266,  1265,    -1,   394,    -1,   270,    -1,   213,    -1,    -1,
     536,  1269,  1268,  1215,    -1,    -1,   512,    -1,    -1,  1271,
      -1,  1272,    -1,  1271,   604,  1272,    -1,    93,    -1,   302,
      -1,    41,   231,    -1,    88,   507,    -1,   364,   170,    -1,
     232,    -1,   506,    -1,   472,    -1,    12,    -1,    -1,   180,
     393,   342,    -1,    -1,   460,  1275,  1276,    -1,   103,  1287,
      -1,  1283,   509,  1282,  1287,    -1,  1283,   532,  1282,  1287,
      -1,   158,  1282,  1287,    -1,   512,   490,  1282,  1287,    -1,
     350,   509,  1282,  1287,    -1,   373,    -1,   150,   873,  1279,
      -1,   150,    12,  1279,    -1,  1283,    70,  1284,  1353,  1282,
    1287,    -1,  1280,   264,    -1,   465,   204,    -1,    -1,    34,
     158,  1285,  1286,  1277,  1182,    -1,    -1,   409,   158,  1285,
    1286,  1278,  1182,    -1,   937,  1284,  1353,  1282,  1166,    -1,
    1281,   149,    -1,    23,    -1,    90,    -1,   384,    -1,    92,
     602,   597,   603,   575,    -1,    92,   602,   597,   603,   155,
      -1,   575,  1182,    -1,   155,  1182,    -1,   389,    -1,   388,
    1270,  1273,  1182,    -1,  1374,   490,  1287,    -1,  1283,   387,
      -1,  1374,   569,  1287,    -1,   912,  1287,    -1,    69,  1287,
      -1,   193,    -1,   193,   180,  1363,    -1,    94,   102,   864,
    1360,    -1,    94,   512,  1353,    -1,    94,   573,  1353,    -1,
     286,   490,    -1,   465,   490,    -1,    94,   385,   660,    -1,
      94,   185,   660,    -1,    94,   533,   660,    -1,   385,   490,
    1287,    -1,   185,   490,  1287,    -1,   385,    67,   660,    -1,
     185,    67,   660,    -1,    94,   159,   660,    -1,   490,    -1,
     320,    -1,   264,    -1,   286,    -1,    33,    -1,    -1,   494,
      -1,    -1,  1284,  1360,    -1,    -1,   183,    -1,   182,    -1,
     230,    -1,    -1,   230,  1357,    -1,    -1,   182,  1190,    -1,
      -1,   252,  1357,    -1,   578,  1073,    -1,    -1,  1291,  1353,
    1289,  1293,    -1,    -1,  1291,  1292,  1290,  1052,    -1,   124,
      -1,   125,    -1,    -1,   165,    -1,   369,    -1,    -1,  1341,
      -1,  1360,    -1,    -1,   177,  1027,  1295,  1296,    -1,    -1,
      -1,  1385,  1297,  1302,  1298,  1299,    -1,  1300,    -1,    -1,
     580,   398,   262,    -1,  1300,   604,  1301,    -1,  1301,    -1,
     154,   264,    -1,   150,   264,    -1,   187,   264,    -1,   466,
     264,    -1,    33,   264,    -1,   408,   264,    -1,   393,    48,
      -1,   204,    -1,   384,    -1,   264,    -1,   490,    -1,   465,
      -1,   286,    -1,   126,    -1,   426,    -1,    -1,  1214,    -1,
      -1,   424,  1304,  1305,    -1,  1305,   604,  1306,    -1,  1306,
      -1,    -1,   465,  1307,  1308,    -1,   286,    -1,   393,    48,
      -1,    -1,    12,    -1,    -1,   391,  1310,  1311,    -1,  1280,
     264,  1312,    -1,   529,  1357,    -1,    29,  1073,    -1,   241,
    1314,  1073,    -1,    -1,    81,    -1,   393,    -1,   560,  1360,
      -1,    -1,    -1,    -1,    -1,   258,  1321,  1317,  1323,  1322,
     218,  1359,  1318,  1324,   227,   512,  1353,  1319,   915,  1320,
    1331,  1325,  1328,  1332,  1334,  1337,    -1,   105,    -1,   588,
      -1,    -1,   259,    -1,    -1,    79,    -1,   270,    -1,    -1,
     421,    -1,   213,    -1,    -1,    70,  1326,    -1,  1326,  1327,
      -1,  1327,    -1,   517,    46,  1341,    -1,   354,   145,    46,
    1341,    -1,   145,    46,  1341,    -1,   156,    46,  1341,    -1,
      -1,   255,  1329,    -1,  1329,  1330,    -1,  1330,    -1,   517,
      46,  1341,    -1,   487,    46,  1341,    -1,    -1,   437,   210,
      46,  1341,    -1,    -1,   213,   342,  1333,    -1,   255,    -1,
     437,    -1,    -1,   602,  1335,   603,    -1,   602,   603,    -1,
    1335,   604,  1336,    -1,  1336,    -1,  1350,    -1,   609,  1362,
      -1,    -1,   455,  1338,    -1,  1338,   604,  1339,    -1,  1339,
      -1,  1350,  1239,  1069,  1245,  1070,    -1,   518,    -1,   326,
      -1,   543,   518,    -1,  1340,  1358,    -1,  1358,    -1,   201,
      -1,    35,    -1,   365,    -1,  1344,    -1,   596,  1345,    -1,
     595,  1345,    -1,  1340,    -1,  1345,    -1,   341,    -1,   168,
      -1,   535,    -1,   201,    -1,    35,    -1,   543,   201,    -1,
     543,    35,    -1,   109,  1340,    -1,   525,  1340,    -1,   522,
    1340,    -1,   342,    -1,   267,    -1,   540,    -1,   116,    -1,
     175,    -1,  1350,    -1,  1347,    -1,  1360,   610,   597,    -1,
    1360,   610,  1360,   610,   597,    -1,  1073,    -1,  1360,    -1,
    1351,    -1,  1360,    -1,  1351,    -1,  1360,   610,  1360,    -1,
     610,  1360,   610,  1360,    -1,  1360,   610,  1360,   610,  1360,
      -1,  1360,    -1,  1360,   610,  1360,   610,  1360,    -1,  1360,
     610,  1360,    -1,   610,  1360,    -1,  1360,    -1,  1360,   610,
    1360,    -1,   610,  1360,    -1,  1360,  1264,    -1,  1360,   610,
    1360,  1264,    -1,  1360,    -1,   209,    -1,   211,    -1,   518,
      -1,   518,    -1,   518,    -1,  1356,    -1,  1364,    -1,  1356,
      -1,  1365,    -1,  1360,    -1,  1357,    -1,   251,    -1,  1362,
      -1,  1362,   609,  1362,    -1,    98,  1072,    -1,  1365,    -1,
      20,    -1,    28,    -1,    30,    -1,    47,    -1,    48,    -1,
      58,    -1,    60,    -1,    65,    -1,    73,    -1,    75,    -1,
      87,    -1,   115,    -1,   135,    -1,   146,    -1,   161,    -1,
     177,    -1,   197,    -1,   200,    -1,   203,    -1,   225,    -1,
     242,    -1,   338,    -1,   350,    -1,   352,    -1,   362,    -1,
     366,    -1,   370,    -1,   377,    -1,   380,    -1,   415,    -1,
     418,    -1,   424,    -1,   427,    -1,   434,    -1,   441,    -1,
     446,    -1,   453,    -1,   463,    -1,   469,    -1,   465,    -1,
     470,    -1,   489,    -1,   493,    -1,   536,    -1,   547,    -1,
     548,    -1,   584,    -1,   587,    -1,   556,    -1,     5,    -1,
       7,    -1,     8,    -1,     9,    -1,    10,    -1,    11,    -1,
      17,    -1,    22,    -1,    23,    -1,    25,    -1,    24,    -1,
      26,    -1,    27,    -1,    34,    -1,    38,    -1,    41,    -1,
      43,    -1,    42,    -1,    45,    -1,    51,    -1,    54,    -1,
      55,    -1,    57,    -1,    62,    -1,    64,    -1,    63,    -1,
      66,    -1,    67,    -1,    69,    -1,    72,    -1,    70,    -1,
      74,    -1,    76,    -1,    77,    -1,    78,    -1,    79,    -1,
      81,    -1,    82,    -1,    84,    -1,    86,    -1,    85,    -1,
      88,    -1,    90,    -1,    93,    -1,    96,    -1,   100,    -1,
     105,    -1,   104,    -1,   106,    -1,   109,    -1,   114,    -1,
     120,    -1,   122,    -1,   126,    -1,   128,    -1,   129,    -1,
     130,    -1,   131,    -1,   138,    -1,   139,    -1,   140,    -1,
     147,    -1,   151,    -1,   150,    -1,   149,    -1,   154,    -1,
     155,    -1,   157,    -1,   159,    -1,   158,    -1,   160,    -1,
     164,    -1,   165,    -1,   166,    -1,   170,    -1,   169,    -1,
     181,    -1,   144,    -1,   183,    -1,   172,    -1,   173,    -1,
     174,    -1,   187,    -1,   189,    -1,   188,    -1,   190,    -1,
     193,    -1,   191,    -1,   198,    -1,   204,    -1,   208,    -1,
     210,    -1,   214,    -1,   229,    -1,   215,    -1,   216,    -1,
     219,    -1,   231,    -1,   232,    -1,   234,    -1,   235,    -1,
     224,    -1,   239,    -1,   243,    -1,   246,    -1,   249,    -1,
     250,    -1,   256,    -1,   257,    -1,   259,    -1,   261,    -1,
     263,    -1,   264,    -1,   292,    -1,   286,    -1,   288,    -1,
     273,    -1,   277,    -1,   274,    -1,   275,    -1,   287,    -1,
     276,    -1,   278,    -1,   272,    -1,   284,    -1,   280,    -1,
     279,    -1,   281,    -1,   282,    -1,   283,    -1,   290,    -1,
     291,    -1,   293,    -1,   295,    -1,   296,    -1,   301,    -1,
     302,    -1,   303,    -1,   304,    -1,   305,    -1,   306,    -1,
     309,    -1,   310,    -1,   314,    -1,   312,    -1,   316,    -1,
     317,    -1,   318,    -1,   319,    -1,   320,    -1,   321,    -1,
     323,    -1,   322,    -1,   324,    -1,   327,    -1,   328,    -1,
     332,    -1,   331,    -1,   339,    -1,   333,    -1,   334,    -1,
     344,    -1,   345,    -1,   346,    -1,   348,    -1,   349,    -1,
     363,    -1,   364,    -1,   367,    -1,   368,    -1,   369,    -1,
     371,    -1,   372,    -1,   374,    -1,   373,    -1,   375,    -1,
     376,    -1,   381,    -1,   382,    -1,   384,    -1,   386,    -1,
     387,    -1,   388,    -1,   389,    -1,   390,    -1,   392,    -1,
     393,    -1,   394,    -1,   397,    -1,   401,    -1,   402,    -1,
     404,    -1,   403,    -1,   405,    -1,   408,    -1,   409,    -1,
     410,    -1,   411,    -1,   412,    -1,   414,    -1,   417,    -1,
     419,    -1,   422,    -1,   426,    -1,   429,    -1,   430,    -1,
     435,    -1,   436,    -1,   437,    -1,   438,    -1,   439,    -1,
     440,    -1,   442,    -1,   443,    -1,   445,    -1,   451,    -1,
     450,    -1,   452,    -1,   464,    -1,   457,    -1,   461,    -1,
     466,    -1,   468,    -1,   471,    -1,   472,    -1,   480,    -1,
     479,    -1,   482,    -1,   485,    -1,   488,    -1,   490,    -1,
     494,    -1,   496,    -1,   497,    -1,   498,    -1,   499,    -1,
     501,    -1,   500,    -1,   504,    -1,   505,    -1,   506,    -1,
     507,    -1,   514,    -1,   509,    -1,   513,    -1,   510,    -1,
     515,    -1,   516,    -1,   519,    -1,   520,    -1,   531,    -1,
     532,    -1,   522,    -1,   523,    -1,   524,    -1,   525,    -1,
     537,    -1,   538,    -1,   539,    -1,   185,    -1,   541,    -1,
     542,    -1,   545,    -1,   544,    -1,   551,    -1,   554,    -1,
     558,    -1,   559,    -1,   569,    -1,   573,    -1,   566,    -1,
     575,    -1,   574,    -1,   576,    -1,   583,    -1,   586,    -1,
     588,    -1,   591,    -1,    -1,   455,  1368,  1367,  1369,    -1,
      -1,   353,    -1,  1370,    -1,  1369,   604,  1370,    -1,    -1,
    1371,  1376,    -1,  1373,    -1,   191,    -1,   259,    -1,   452,
      -1,    -1,   348,    -1,    -1,   191,    -1,   259,    -1,   452,
      -1,    -1,   191,   610,    -1,   259,   610,    -1,   452,   610,
      -1,  1377,    -1,  1373,  1378,    -1,  1372,  1379,  1239,  1382,
      -1,  1372,   531,   234,   250,  1380,    -1,   609,  1362,  1239,
    1073,    -1,   609,   609,  1375,  1379,  1239,  1382,    -1,   912,
     917,    -1,   322,  1239,  1073,    -1,   322,   914,   919,    -1,
     371,  1239,  1381,    -1,   371,   180,  1363,  1239,  1381,    -1,
    1360,    -1,  1360,   610,  1360,    -1,   119,   610,  1360,    -1,
     398,   541,    -1,   398,    74,    -1,   419,   398,    -1,   450,
      -1,   518,    -1,   371,   602,   518,   603,    -1,   346,   602,
     518,   603,    -1,  1073,    -1,   119,    -1,   347,    -1,    12,
      -1,    33,    -1,    -1,   262,  1385,  1384,  1386,    -1,   512,
      -1,   509,    -1,  1387,    -1,  1386,   604,  1387,    -1,  1353,
    1164,  1388,    -1,   398,    -1,   585,    -1,   270,   585,    -1,
     398,   259,    -1,    -1,   552,  1390,  1385,    -1,   197,  1353,
     350,  1164,    -1,   197,  1355,    65,    -1,    -1,   197,  1355,
     398,  1392,  1393,  1166,  1183,    -1,  1394,    -1,  1360,  1395,
      -1,   173,    -1,   332,    -1,   173,    -1,   332,    -1,   382,
      -1,   243,    -1,    -1,  1397,  1396,   602,  1244,   603,    -1,
     152,    -1,   186,    -1,   244,    -1,   196,    -1,   271,    -1,
     432,   659,  1399,    -1,  1403,   347,  1402,  1414,   182,  1416,
      -1,  1403,   347,   185,  1414,   182,  1416,    -1,  1403,   347,
     385,  1414,   182,  1416,    -1,    12,  1404,   604,   192,   353,
     182,  1416,    -1,   390,   347,  1363,   182,  1416,    -1,   192,
     659,  1401,    -1,  1403,   347,  1402,  1414,   529,  1416,  1421,
    1422,    -1,  1403,   347,   185,  1414,   529,  1416,  1421,  1422,
      -1,  1403,   347,   385,  1414,   529,  1416,  1421,  1422,    -1,
     390,   347,  1363,   529,  1416,  1423,    -1,    -1,   512,    -1,
    1405,    -1,    12,  1404,    -1,    -1,   384,    -1,  1406,    -1,
    1405,   604,  1406,    -1,    -1,   447,  1407,  1418,    -1,    -1,
     223,  1408,  1418,    -1,    -1,   555,  1409,  1418,    -1,    -1,
     406,  1410,  1418,    -1,   123,    -1,   557,    -1,   217,    -1,
      13,    -1,    94,    -1,   136,    -1,   161,    -1,   414,    -1,
     461,    -1,   386,    -1,   172,    -1,   192,   353,    -1,   460,
     103,    -1,   504,    -1,    94,   515,   509,    -1,   262,   509,
      -1,   422,   465,    -1,   422,    64,    -1,    94,   573,    -1,
     460,   573,    -1,    94,   436,    -1,    13,   436,    -1,    94,
     558,    -1,   159,    -1,   533,    -1,    94,   510,    -1,    -1,
      16,    -1,  1413,  1411,  1412,    -1,  1413,    -1,   499,   518,
      -1,   235,   518,    -1,    62,   518,    -1,   597,    -1,  1360,
     610,   597,    -1,   597,   610,   597,    -1,  1353,    -1,  1363,
      -1,  1415,   604,  1363,    -1,  1417,    -1,  1416,   604,  1417,
      -1,  1363,   210,    46,   518,    -1,  1363,   210,    46,   371,
     518,    -1,  1363,   210,   580,  1362,    -1,  1363,   210,   580,
    1362,    18,  1357,    -1,  1363,    -1,    -1,   602,  1419,   603,
      -1,  1419,   604,  1420,    -1,  1420,    -1,  1360,    -1,    -1,
     423,  1412,    -1,   423,   486,    -1,   423,   586,    -1,   423,
     334,    -1,    -1,   580,  1424,    -1,    -1,   580,   192,   353,
      -1,  1424,  1425,    -1,  1425,    -1,   192,   353,    -1,   291,
    1188,    -1,   295,  1188,    -1,   290,  1188,    -1,   296,  1188,
      -1,    -1,    30,  1427,  1428,    -1,    -1,   583,    -1,    -1,
      16,   338,    55,    -1,    16,    55,    -1,    -1,   413,    -1,
     338,   413,    -1,    -1,   441,    -1,    75,  1428,  1429,  1430,
      -1,   434,  1428,  1429,  1430,    -1,   434,  1428,   529,  1431,
    1360,    -1,   441,  1360,    -1,   413,   441,  1360,    -1,    -1,
    1437,    -1,    -1,   549,  1444,  1438,  1053,    -1,    -1,  1437,
      -1,  1441,    -1,    -1,  1441,    -1,    -1,  1442,  1443,    -1,
    1178,  1182,    -1,  1184,    -1,    -1,   132,    -1,    12,    -1,
     447,  1134,    -1,   602,  1055,   603,    -1,  1445,  1440,    -1,
      -1,  1446,   549,  1444,  1447,  1445,  1440,    -1,  1449,  1446,
    1450,    -1,    -1,    -1,    -1,  1452,    -1,  1452,  1453,    -1,
    1453,    -1,   495,    -1,   202,    -1,   132,    -1,   483,    -1,
     478,    -1,   479,    -1,   481,    -1,    12,    -1,  1459,  1455,
      -1,  1458,  1456,    -1,  1460,  1457,  1464,    -1,  1464,    -1,
    1472,    -1,  1483,    -1,  1477,    -1,   646,    -1,  1464,    -1,
    1472,    -1,  1483,    -1,  1477,    -1,  1476,    -1,   646,    -1,
    1458,    -1,  1459,    -1,    -1,   120,   152,  1363,    -1,  1461,
      -1,  1461,  1462,    -1,  1462,    -1,   358,   421,    -1,    11,
     152,   542,    -1,    11,   152,   303,    -1,    11,   152,   516,
      -1,    -1,   484,   446,   120,    -1,   484,   446,   229,    -1,
      -1,  1463,   573,  1353,  1465,  1466,    18,  1468,    -1,    -1,
     602,  1467,   603,    -1,  1360,    -1,  1467,   604,  1360,    -1,
      -1,  1469,  1470,  1471,    -1,   447,  1056,    -1,   602,  1054,
     603,  1439,    -1,    -1,   580,    61,   353,    -1,   580,    51,
      61,   353,    -1,   580,   259,    61,   353,    -1,    -1,    -1,
      -1,   533,  1069,   660,   754,   755,   347,  1069,  1473,  1353,
     180,  1069,  1474,   141,   439,  1475,   704,    -1,    10,  1069,
     185,  1360,   430,   877,   470,  1357,    -1,  1069,   185,  1360,
     430,   877,   470,  1357,    -1,    -1,    -1,    -1,    -1,    -1,
    1069,   185,   660,   602,  1478,   671,   603,  1479,   430,  1480,
     910,  1481,   662,  1482,   704,    -1,    -1,    -1,    -1,    -1,
     385,  1069,   660,  1484,   602,  1485,   675,   603,  1486,   662,
    1487,   704,    -1,   587,  1490,  1489,  1491,    -1,   587,   146,
    1489,  1493,    -1,   587,   380,  1489,    -1,   587,    75,  1489,
    1492,    -1,   587,   434,  1489,    -1,   587,   402,    -1,  1341,
      -1,  1341,   604,  1341,    -1,  1341,   604,  1341,   604,  1188,
      -1,    30,    -1,   489,    -1,    -1,   237,    -1,   429,    -1,
      -1,   349,   372,    -1,    -1,    -1,   505,  1494,  1495,    -1,
      -1,   180,   306,    -1,   225,   374,  1360,   470,  1357,    -1,
     548,   374,  1360,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1656,  1656,  1669,  1668,  1693,  1700,  1702,  1706,  1707,
    1712,  1713,  1714,  1715,  1716,  1717,  1718,  1719,  1720,  1721,
    1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,  1730,  1731,
    1732,  1733,  1734,  1735,  1736,  1737,  1738,  1739,  1740,  1741,
    1742,  1743,  1744,  1745,  1746,  1747,  1748,  1749,  1750,  1751,
    1752,  1753,  1754,  1755,  1756,  1757,  1758,  1759,  1760,  1761,
    1762,  1766,  1776,  1777,  1781,  1791,  1798,  1809,  1808,  1819,
    1821,  1825,  1826,  1830,  1843,  1842,  1862,  1861,  1875,  1876,
    1880,  1884,  1888,  1892,  1896,  1900,  1905,  1909,  1913,  1917,
    1921,  1925,  1931,  1962,  1967,  1970,  1972,  1973,  1977,  1991,
    1995,  2011,  2015,  2027,  2026,  2068,  2067,  2079,  2077,  2090,
    2088,  2100,  2099,  2112,  2111,  2119,  2123,  2127,  2131,  2138,
    2151,  2152,  2156,  2160,  2164,  2168,  2172,  2176,  2180,  2188,
    2187,  2219,  2218,  2225,  2232,  2233,  2239,  2245,  2255,  2261,
    2267,  2269,  2276,  2277,  2281,  2287,  2296,  2297,  2305,  2305,
    2363,  2364,  2365,  2366,  2367,  2368,  2369,  2370,  2371,  2372,
    2373,  2374,  2375,  2380,  2394,  2410,  2429,  2430,  2434,  2435,
    2440,  2442,  2444,  2446,  2448,  2450,  2452,  2458,  2459,  2460,
    2464,  2468,  2476,  2475,  2488,  2490,  2493,  2495,  2499,  2503,
    2510,  2512,  2516,  2517,  2522,  2541,  2567,  2569,  2573,  2574,
    2578,  2604,  2605,  2606,  2607,  2611,  2612,  2616,  2617,  2622,
    2625,  2652,  2651,  2716,  2732,  2731,  2785,  2811,  2811,  2834,
    2835,  2840,  2842,  2847,  2870,  2883,  2887,  2904,  2905,  2909,
    2913,  2922,  2929,  2936,  2946,  2961,  2984,  2990,  2991,  2997,
    3000,  3004,  3012,  3032,  3034,  3052,  3058,  3060,  3062,  3064,
    3066,  3068,  3070,  3072,  3074,  3076,  3078,  3080,  3085,  3100,
    3115,  3133,  3134,  3138,  3139,  3140,  3141,  3142,  3143,  3144,
    3145,  3146,  3147,  3148,  3149,  3150,  3155,  3154,  3161,  3161,
    3218,  3217,  3246,  3246,  3260,  3313,  3356,  3377,  3376,  3398,
    3417,  3419,  3420,  3424,  3444,  3467,  3469,  3485,  3467,  3504,
    3506,  3507,  3511,  3512,  3517,  3523,  3516,  3544,  3543,  3559,
    3560,  3564,  3565,  3570,  3574,  3569,  3595,  3599,  3594,  3618,
    3628,  3633,  3632,  3668,  3669,  3674,  3673,  3706,  3706,  3721,
    3720,  3756,  3768,  3770,  3767,  3797,  3796,  3817,  3819,  3824,
    3826,  3828,  3845,  3850,  3856,  3863,  3864,  3872,  3878,  3887,
    3893,  3899,  3900,  3904,  3904,  3909,  3910,  3911,  3915,  3916,
    3917,  3921,  3925,  3926,  3927,  3931,  3932,  3933,  3934,  3935,
    3936,  3937,  3938,  3942,  3946,  3947,  3948,  3952,  3953,  3954,
    3955,  3956,  3960,  3964,  3965,  3966,  3970,  3971,  3972,  3973,
    3974,  3975,  3976,  3980,  3984,  3985,  3986,  3990,  3991,  3992,
    3997,  4005,  4013,  4021,  4033,  4045,  4050,  4055,  4063,  4071,
    4079,  4087,  4095,  4103,  4111,  4124,  4137,  4150,  4152,  4156,
    4161,  4174,  4175,  4226,  4227,  4230,  4245,  4263,  4268,  4266,
    4273,  4275,  4274,  4278,  4277,  4283,  4320,  4321,  4326,  4325,
    4344,  4363,  4362,  4379,  4383,  4391,  4390,  4393,  4395,  4397,
    4399,  4404,  4405,  4411,  4412,  4429,  4430,  4434,  4435,  4439,
    4458,  4468,  4479,  4488,  4489,  4505,  4507,  4506,  4511,  4509,
    4520,  4521,  4525,  4543,  4559,  4560,  4576,  4591,  4613,  4614,
    4619,  4618,  4642,  4652,  4674,  4673,  4691,  4690,  4710,  4732,
    4736,  4765,  4777,  4778,  4783,  4794,  4782,  4819,  4820,  4824,
    4837,  4858,  4871,  4897,  4898,  4903,  4902,  4939,  4944,  4945,
    4949,  4950,  4954,  4956,  4962,  4964,  4966,  4968,  4970,  4972,
    4982,  4997,  4981,  5011,  5012,  5016,  5017,  5021,  5022,  5026,
    5027,  5031,  5032,  5036,  5037,  5041,  5045,  5046,  5049,  5051,
    5055,  5056,  5060,  5061,  5062,  5066,  5071,  5076,  5081,  5086,
    5091,  5096,  5101,  5116,  5122,  5127,  5132,  5137,  5143,  5142,
    5168,  5169,  5170,  5175,  5180,  5185,  5187,  5189,  5191,  5197,
    5205,  5223,  5240,  5263,  5277,  5278,  5279,  5280,  5281,  5282,
    5286,  5287,  5288,  5292,  5293,  5297,  5298,  5299,  5300,  5305,
    5312,  5313,  5317,  5318,  5322,  5323,  5330,  5335,  5341,  5347,
    5353,  5371,  5377,  5379,  5383,  5387,  5388,  5392,  5397,  5396,
    5419,  5420,  5421,  5422,  5427,  5431,  5436,  5441,  5445,  5450,
    5455,  5461,  5466,  5472,  5476,  5481,  5486,  5504,  5506,  5508,
    5521,  5523,  5528,  5533,  5545,  5550,  5555,  5560,  5562,  5564,
    5566,  5568,  5570,  5572,  5574,  5577,  5576,  5581,  5580,  5584,
    5586,  5595,  5596,  5597,  5602,  5603,  5604,  5605,  5606,  5610,
    5614,  5615,  5619,  5620,  5624,  5625,  5626,  5627,  5628,  5632,
    5633,  5634,  5635,  5636,  5640,  5645,  5647,  5653,  5654,  5656,
    5661,  5670,  5671,  5675,  5676,  5680,  5681,  5682,  5686,  5687,
    5688,  5689,  5692,  5693,  5697,  5698,  5702,  5703,  5707,  5708,
    5712,  5713,  5714,  5715,  5722,  5723,  5729,  5735,  5741,  5747,
    5748,  5765,  5786,  5792,  5797,  5798,  5802,  5810,  5814,  5815,
    5819,  5820,  5824,  5833,  5837,  5838,  5842,  5853,  5854,  5858,
    5859,  5863,  5864,  5869,  5870,  5874,  5881,  5890,  5898,  5909,
    5910,  5911,  5912,  5913,  5914,  5919,  5927,  5928,  5932,  5934,
    5938,  5950,  5951,  5955,  5962,  5975,  5976,  5978,  5980,  5986,
    5991,  5997,  6003,  6010,  6020,  6021,  6022,  6023,  6024,  6028,
    6032,  6033,  6037,  6038,  6042,  6043,  6047,  6048,  6049,  6053,
    6054,  6058,  6062,  6075,  6087,  6088,  6092,  6093,  6097,  6098,
    6102,  6103,  6107,  6108,  6112,  6113,  6117,  6118,  6122,  6123,
    6127,  6129,  6133,  6134,  6138,  6142,  6143,  6156,  6157,  6158,
    6162,  6163,  6167,  6173,  6187,  6188,  6192,  6193,  6197,  6198,
    6206,  6205,  6244,  6243,  6257,  6269,  6268,  6287,  6286,  6305,
    6304,  6323,  6317,  6337,  6336,  6369,  6374,  6379,  6384,  6389,
    6399,  6400,  6401,  6402,  6406,  6407,  6419,  6420,  6424,  6425,
    6428,  6430,  6431,  6432,  6434,  6436,  6437,  6446,  6447,  6451,
    6460,  6458,  6472,  6486,  6485,  6499,  6497,  6511,  6518,  6529,
    6533,  6540,  6544,  6549,  6548,  6564,  6566,  6571,  6579,  6578,
    6594,  6598,  6597,  6609,  6610,  6614,  6629,  6630,  6634,  6643,
    6647,  6652,  6657,  6656,  6667,  6676,  6666,  6691,  6700,  6704,
    6713,  6722,  6728,  6734,  6743,  6752,  6771,  6792,  6802,  6806,
    6814,  6815,  6819,  6820,  6824,  6825,  6826,  6830,  6831,  6832,
    6836,  6837,  6838,  6839,  6848,  6847,  6858,  6866,  6865,  6875,
    6884,  6893,  6894,  6901,  6901,  6907,  6908,  6912,  6913,  6914,
    6918,  6919,  6935,  6936,  6941,  6940,  6952,  6953,  6954,  6959,
    6958,  6980,  6981,  6985,  6986,  6990,  6991,  6992,  6997,  6996,
    7018,  7027,  7026,  7053,  7054,  7058,  7059,  7063,  7064,  7065,
    7066,  7067,  7068,  7073,  7072,  7094,  7095,  7096,  7101,  7100,
    7106,  7113,  7118,  7126,  7127,  7131,  7145,  7144,  7157,  7158,
    7162,  7163,  7167,  7177,  7187,  7188,  7193,  7192,  7203,  7204,
    7208,  7209,  7213,  7223,  7234,  7233,  7241,  7241,  7252,  7253,
    7258,  7259,  7268,  7277,  7278,  7282,  7287,  7292,  7297,  7302,
    7301,  7321,  7329,  7321,  7336,  7337,  7338,  7339,  7340,  7344,
    7351,  7358,  7360,  7371,  7372,  7376,  7377,  7405,  7435,  7437,
    7443,  7453,  7454,  7455,  7470,  7477,  7503,  7509,  7515,  7516,
    7517,  7518,  7519,  7523,  7524,  7529,  7580,  7587,  7630,  7636,
    7642,  7648,  7654,  7660,  7666,  7672,  7676,  7682,  7688,  7694,
    7700,  7706,  7710,  7716,  7726,  7732,  7740,  7746,  7756,  7762,
    7771,  7781,  7787,  7797,  7803,  7812,  7816,  7822,  7828,  7834,
    7840,  7846,  7852,  7858,  7864,  7870,  7876,  7882,  7888,  7894,
    7900,  7904,  7905,  7909,  7910,  7914,  7915,  7919,  7920,  7924,
    7925,  7926,  7927,  7928,  7929,  7933,  7934,  7938,  7939,  7940,
    7941,  7942,  7943,  7955,  7956,  7957,  7958,  7959,  7965,  7969,
    7975,  7981,  7987,  7993,  7995,  8002,  8009,  8015,  8017,  8026,
    8033,  8041,  8047,  8054,  8060,  8074,  8081,  8097,  8103,  8109,
    8117,  8123,  8129,  8135,  8141,  8156,  8168,  8174,  8180,  8186,
    8192,  8198,  8204,  8210,  8216,  8222,  8228,  8234,  8240,  8246,
    8252,  8258,  8264,  8272,  8293,  8300,  8306,  8313,  8320,  8327,
    8334,  8341,  8347,  8353,  8360,  8367,  8373,  8380,  8386,  8392,
    8398,  8404,  8410,  8428,  8438,  8444,  8450,  8457,  8464,  8479,
    8485,  8491,  8497,  8503,  8510,  8516,  8522,  8528,  8534,  8546,
    8552,  8558,  8564,  8570,  8582,  8588,  8604,  8610,  8617,  8624,
    8631,  8638,  8645,  8649,  8669,  8668,  8741,  8783,  8785,  8790,
    8791,  8795,  8796,  8800,  8801,  8805,  8812,  8820,  8846,  8852,
    8858,  8864,  8870,  8876,  8885,  8892,  8894,  8891,  8901,  8912,
    8918,  8924,  8930,  8936,  8942,  8948,  8954,  8960,  8967,  8966,
    8985,  8984,  8999,  9009,  9017,  9033,  9034,  9039,  9044,  9049,
    9052,  9065,  9064,  9081,  9083,  9085,  9087,  9089,  9091,  9093,
    9095,  9097,  9099,  9101,  9106,  9107,  9111,  9118,  9126,  9127,
    9131,  9138,  9146,  9147,  9151,  9152,  9156,  9164,  9175,  9176,
    9185,  9196,  9197,  9203,  9204,  9224,  9226,  9230,  9228,  9245,
    9243,  9261,  9259,  9266,  9275,  9273,  9291,  9290,  9300,  9311,
    9309,  9328,  9327,  9338,  9349,  9350,  9351,  9363,  9363,  9377,
    9417,  9468,  9472,  9477,  9469,  9489,  9509,  9517,  9509,  9526,
    9525,  9548,  9565,  9548,  9572,  9576,  9602,  9603,  9608,  9611,
    9612,  9613,  9617,  9618,  9623,  9622,  9628,  9627,  9635,  9636,
    9639,  9641,  9641,  9645,  9645,  9650,  9651,  9655,  9657,  9662,
    9663,  9667,  9678,  9691,  9692,  9693,  9694,  9695,  9696,  9697,
    9698,  9699,  9700,  9701,  9702,  9706,  9707,  9708,  9709,  9710,
    9711,  9712,  9713,  9714,  9718,  9719,  9720,  9721,  9724,  9726,
    9727,  9731,  9732,  9740,  9742,  9746,  9748,  9747,  9761,  9764,
    9763,  9778,  9784,  9799,  9801,  9805,  9807,  9812,  9813,  9833,
    9858,  9862,  9863,  9867,  9880,  9882,  9887,  9886,  9921,  9923,
    9928,  9929,  9930,  9935,  9941,  9945,  9946,  9950,  9957,  9964,
    9971,  9981, 10015, 10019, 10025, 10031, 10041, 10045, 10055, 10056,
   10057, 10058, 10059, 10060, 10064, 10065, 10066, 10067, 10068, 10072,
   10073, 10074, 10075, 10076, 10080, 10081, 10082, 10083, 10087, 10092,
   10093, 10096, 10099, 10098, 10129, 10130, 10134, 10135, 10139, 10151,
   10151, 10161, 10162, 10166, 10185, 10218, 10217, 10230, 10238, 10229,
   10240, 10252, 10264, 10263, 10281, 10280, 10291, 10291, 10307, 10314,
   10337, 10358, 10370, 10375, 10374, 10384, 10390, 10397, 10402, 10407,
   10417, 10418, 10422, 10433, 10434, 10438, 10449, 10450, 10454, 10455,
   10463, 10471, 10462, 10481, 10488, 10480, 10498, 10510, 10511, 10519,
   10523, 10524, 10535, 10536, 10540, 10549, 10550, 10551, 10553, 10552,
   10563, 10564, 10568, 10569, 10571, 10570, 10574, 10573, 10579, 10580,
   10584, 10585, 10589, 10599, 10600, 10604, 10605, 10610, 10609, 10623,
   10624, 10628, 10633, 10641, 10642, 10650, 10652, 10652, 10660, 10668,
   10659, 10690, 10691, 10695, 10703, 10704, 10708, 10718, 10719, 10726,
   10725, 10741, 10740, 10752, 10751, 10763, 10762, 10776, 10777, 10781,
   10794, 10810, 10811, 10815, 10816, 10820, 10821, 10822, 10827, 10826,
   10848, 10850, 10853, 10855, 10858, 10859, 10862, 10866, 10870, 10874,
   10878, 10882, 10886, 10890, 10894, 10902, 10905, 10915, 10914, 10927,
   10934, 10942, 10950, 10958, 10966, 10974, 10981, 10983, 10985, 10994,
   10998, 11003, 11002, 11008, 11007, 11012, 11021, 11028, 11037, 11046,
   11051, 11053, 11055, 11057, 11059, 11061, 11068, 11076, 11078, 11086,
   11093, 11100, 11110, 11117, 11123, 11132, 11140, 11144, 11148, 11155,
   11162, 11168, 11175, 11182, 11187, 11192, 11200, 11202, 11204, 11209,
   11210, 11213, 11215, 11219, 11220, 11224, 11225, 11229, 11230, 11234,
   11235, 11239, 11240, 11243, 11245, 11252, 11263, 11262, 11275, 11274,
   11284, 11285, 11289, 11290, 11291, 11295, 11296, 11297, 11312, 11311,
   11324, 11333, 11323, 11335, 11339, 11340, 11354, 11355, 11360, 11362,
   11364, 11366, 11368, 11370, 11372, 11374, 11376, 11378, 11380, 11382,
   11387, 11389, 11391, 11396, 11397, 11402, 11401, 11411, 11412, 11416,
   11416, 11418, 11419, 11423, 11424, 11429, 11428, 11439, 11443, 11447,
   11459, 11469, 11470, 11471, 11477, 11489, 11501, 11511, 11521, 11488,
   11529, 11530, 11534, 11535, 11539, 11540, 11552, 11556, 11557, 11558,
   11561, 11563, 11567, 11568, 11572, 11577, 11584, 11589, 11596, 11598,
   11602, 11603, 11607, 11612, 11620, 11621, 11624, 11626, 11634, 11636,
   11640, 11641, 11642, 11646, 11648, 11653, 11654, 11663, 11664, 11668,
   11669, 11673, 11686, 11710, 11722, 11733, 11752, 11760, 11772, 11787,
   11808, 11809, 11810, 11818, 11819, 11820, 11827, 11833, 11839, 11845,
   11851, 11880, 11908, 11909, 11910, 11914, 11924, 11934, 11940, 11949,
   11964, 11965, 11969, 11978, 11994, 11998, 12045, 12049, 12067, 12071,
   12150, 12175, 12206, 12207, 12223, 12233, 12237, 12243, 12249, 12259,
   12265, 12274, 12284, 12285, 12315, 12331, 12347, 12364, 12365, 12376,
   12377, 12388, 12389, 12390, 12394, 12411, 12433, 12448, 12449, 12450,
   12451, 12452, 12453, 12454, 12455, 12456, 12457, 12458, 12459, 12460,
   12461, 12462, 12463, 12464, 12465, 12466, 12467, 12468, 12469, 12470,
   12471, 12472, 12473, 12474, 12475, 12476, 12477, 12478, 12479, 12480,
   12481, 12482, 12483, 12484, 12485, 12486, 12487, 12488, 12489, 12490,
   12491, 12492, 12493, 12494, 12495, 12496, 12497, 12507, 12508, 12509,
   12510, 12511, 12512, 12513, 12514, 12515, 12516, 12517, 12518, 12519,
   12520, 12521, 12522, 12523, 12524, 12525, 12526, 12527, 12528, 12529,
   12530, 12531, 12532, 12533, 12534, 12535, 12536, 12537, 12538, 12539,
   12540, 12541, 12542, 12543, 12544, 12545, 12546, 12547, 12548, 12549,
   12550, 12551, 12552, 12553, 12554, 12555, 12556, 12557, 12558, 12559,
   12560, 12561, 12562, 12563, 12564, 12565, 12566, 12567, 12568, 12569,
   12570, 12571, 12572, 12573, 12574, 12575, 12576, 12577, 12578, 12579,
   12580, 12581, 12582, 12583, 12584, 12585, 12586, 12587, 12588, 12589,
   12590, 12591, 12592, 12593, 12594, 12595, 12596, 12597, 12598, 12599,
   12600, 12601, 12602, 12603, 12604, 12605, 12606, 12607, 12608, 12609,
   12610, 12611, 12612, 12613, 12614, 12615, 12616, 12617, 12618, 12619,
   12620, 12621, 12622, 12623, 12624, 12625, 12626, 12627, 12628, 12629,
   12630, 12631, 12632, 12633, 12634, 12635, 12636, 12637, 12638, 12639,
   12640, 12641, 12642, 12643, 12644, 12645, 12646, 12647, 12648, 12649,
   12650, 12651, 12652, 12653, 12654, 12655, 12656, 12657, 12658, 12659,
   12660, 12661, 12662, 12663, 12664, 12665, 12666, 12667, 12668, 12669,
   12670, 12671, 12672, 12673, 12674, 12675, 12676, 12677, 12678, 12679,
   12680, 12681, 12682, 12683, 12684, 12685, 12686, 12687, 12688, 12689,
   12690, 12691, 12692, 12693, 12694, 12695, 12696, 12697, 12698, 12699,
   12700, 12701, 12702, 12703, 12704, 12705, 12706, 12707, 12708, 12709,
   12710, 12711, 12712, 12713, 12714, 12715, 12716, 12717, 12718, 12719,
   12720, 12721, 12722, 12723, 12724, 12725, 12726, 12727, 12728, 12729,
   12730, 12731, 12732, 12733, 12734, 12735, 12736, 12737, 12738, 12739,
   12740, 12741, 12742, 12743, 12744, 12745, 12746, 12747, 12748, 12749,
   12750, 12751, 12752, 12753, 12754, 12755, 12756, 12757, 12758, 12759,
   12760, 12761, 12762, 12763, 12764, 12765, 12766, 12767, 12768, 12769,
   12770, 12771, 12772, 12773, 12774, 12775, 12776, 12777, 12778, 12779,
   12780, 12781, 12782, 12783, 12784, 12791, 12790, 12805, 12806, 12810,
   12811, 12815, 12815, 12897, 12898, 12899, 12900, 12904, 12905, 12909,
   12910, 12911, 12912, 12916, 12917, 12918, 12919, 12923, 12924, 12928,
   12970, 12989, 13000, 13013, 13027, 13042, 13061, 13088, 13101, 13128,
   13171, 13185, 13186, 13187, 13188, 13192, 13193, 13202, 13214, 13215,
   13216, 13222, 13228, 13240, 13239, 13255, 13256, 13260, 13261, 13265,
   13278, 13279, 13280, 13281, 13286, 13285, 13305, 13317, 13330, 13329,
   13362, 13363, 13367, 13368, 13372, 13373, 13374, 13375, 13377, 13376,
   13389, 13390, 13391, 13392, 13393, 13399, 13404, 13410, 13421, 13432,
   13436, 13446, 13451, 13458, 13470, 13482, 13491, 13493, 13497, 13498,
   13505, 13507, 13511, 13512, 13517, 13516, 13520, 13519, 13523, 13522,
   13526, 13525, 13528, 13529, 13530, 13531, 13532, 13533, 13534, 13535,
   13536, 13537, 13538, 13539, 13540, 13541, 13542, 13543, 13544, 13545,
   13546, 13547, 13548, 13549, 13550, 13551, 13552, 13553, 13557, 13558,
   13562, 13563, 13567, 13577, 13587, 13600, 13615, 13628, 13641, 13653,
   13658, 13666, 13671, 13679, 13708, 13715, 13723, 13731, 13737, 13741,
   13745, 13746, 13750, 13777, 13779, 13783, 13787, 13791, 13798, 13799,
   13803, 13804, 13808, 13809, 13813, 13814, 13820, 13826, 13832, 13842,
   13841, 13851, 13852, 13857, 13858, 13859, 13864, 13865, 13866, 13870,
   13871, 13875, 13887, 13896, 13906, 13915, 13929, 13930, 13935, 13934,
   13950, 13951, 13952, 13955, 13957, 13961, 13961, 13985, 13986, 13990,
   13991, 13992, 13996, 14000, 14007, 14010, 14008, 14024, 14031, 14052,
   14069, 14071, 14075, 14076, 14080, 14081, 14089, 14090, 14091, 14092,
   14098, 14104, 14114, 14116, 14118, 14123, 14124, 14125, 14126, 14127,
   14131, 14132, 14133, 14134, 14135, 14136, 14146, 14147, 14152, 14165,
   14178, 14180, 14182, 14187, 14192, 14194, 14196, 14202, 14203, 14205,
   14211, 14210, 14228, 14229, 14233, 14238, 14246, 14246, 14271, 14272,
   14277, 14278, 14280, 14282, 14300, 14306, 14311, 14293, 14373, 14391,
   14416, 14448, 14452, 14460, 14483, 14412, 14548, 14572, 14581, 14589,
   14547, 14610, 14614, 14618, 14622, 14626, 14630, 14637, 14644, 14651,
   14661, 14662, 14666, 14667, 14668, 14672, 14673, 14678, 14680, 14679,
   14685, 14686, 14690, 14700
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM",
  "AUTHORS_SYM", "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CATALOG_NAME_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM",
  "CHECK_SYM", "CIPHER_SYM", "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COLUMN_NAME_SYM", "COMMENT_SYM", "COMMITTED_SYM",
  "COMMIT_SYM", "COMPACT_SYM", "COMPLETION_SYM", "COMPRESSED_SYM",
  "CONCURRENT", "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM",
  "CONSTRAINT", "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM",
  "CONSTRAINT_SCHEMA_SYM", "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM",
  "CONTRIBUTORS_SYM", "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM",
  "CURSOR_NAME_SYM", "CURTIME", "DATABASE", "DATABASES", "DATAFILE_SYM",
  "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL",
  "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM",
  "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM", "DECIMAL_NUM",
  "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT", "DEFINER_SYM", "DELAYED_SYM",
  "DELAY_KEY_WRITE_SYM", "DELETE_SYM", "DESC", "DESCRIBE", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISK_SYM", "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP",
  "DUAL_SYM", "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM",
  "ELSE", "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXECUTE_SYM", "EXISTS", "EXIT_SYM",
  "EXPANSION_SYM", "EXTENDED_SYM", "EXTENT_SIZE_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM", "FROM", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GENERAL", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GROUP_SYM", "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HASH_SYM",
  "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY", "HOST_SYM",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IGNORE_SERVER_IDS_SYM", "IMPORT", "INDEXES",
  "INDEX_SYM", "INFILE", "INITIAL_SIZE_SYM", "INNER_SYM", "INOUT_SYM",
  "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD", "INSTALL_SYM",
  "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM", "IN_SYM", "IO_SYM",
  "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM", "LANGUAGE_SYM",
  "LAST_SYM", "LE", "LEADING", "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM",
  "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT", "LINEAR_SYM", "LINES",
  "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM", "LOCATOR_SYM",
  "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM", "LONGBLOB",
  "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM", "LOW_PRIORITY", "LT",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM",
  "MASTER_USER_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM",
  "OLD_PASSWORD", "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE",
  "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM", "ORDER_SYM",
  "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM", "OWNER_SYM",
  "PACK_KEYS_SYM", "PAGE_SYM", "PARAM_MARKER", "PARSER_SYM", "PARTIAL",
  "PARTITIONING_SYM", "PARTITIONS_SYM", "PARTITION_SYM", "PASSWORD",
  "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM", "POLYGON",
  "PORT_SYM", "POSITION_SYM", "PRECISION", "PREPARE_SYM", "PRESERVE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE_SYM", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PROXY_SYM", "PURGE",
  "QUARTER_SYM", "QUERY_SYM", "QUICK", "RANGE_SYM", "READS_SYM",
  "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM", "REAL", "REBUILD_SYM",
  "RECOVER_SYM", "REDOFILE_SYM", "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM",
  "REFERENCES", "REGEXP", "RELAY", "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD",
  "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM",
  "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM", "RESET_SYM",
  "RESIGNAL_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNAL_SYM", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM",
  "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM",
  "SQLWARNING_SYM", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "STARTS_SYM", "START_SYM",
  "STATUS_SYM", "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM",
  "STRAIGHT_JOIN", "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM",
  "SUBJECT_SYM", "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING",
  "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM",
  "SYSDATE", "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_SYM",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "ULONGLONG_NUM",
  "UNCOMMITTED_SYM", "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDOFILE_SYM",
  "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM", "UNICODE_SYM", "UNINSTALL_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED",
  "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM", "USAGE", "USER", "USE_FRM",
  "USE_SYM", "USING", "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM", "VIEW_SYM", "WAIT_SYM",
  "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE", "WHILE_SYM", "WITH",
  "WITH_CUBE_SYM", "WITH_ROLLUP_SYM", "WORK_SYM", "WRAPPER_SYM",
  "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM", "XOR", "YEAR_MONTH_SYM",
  "YEAR_SYM", "ZEROFILL", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'",
  "'^'", "'~'", "'('", "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'",
  "'.'", "':'", "$accept", "query", "$@1", "opt_end_of_input",
  "verb_clause", "statement", "deallocate", "deallocate_or_drop",
  "prepare", "prepare_src", "execute", "$@2", "execute_using",
  "execute_var_list", "execute_var_ident", "help", "$@3", "change", "$@4",
  "master_defs", "master_def", "ignore_server_id_list", "ignore_server_id",
  "master_file_def", "create", "$@5", "$@6", "$@7", "$@8", "$@9", "$@10",
  "server_def", "server_options_list", "server_option", "event_tail",
  "$@11", "ev_schedule_time", "$@12", "opt_ev_status", "ev_starts",
  "ev_ends", "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@13", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@14", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@15", "$@16", "sp_cursor_stmt", "$@17",
  "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "sqlstate", "opt_value", "sp_hcond", "signal_stmt", "signal_value",
  "opt_signal_value", "opt_set_signal_information",
  "signal_information_item_list", "signal_allowed_expr",
  "signal_condition_information_item_name", "resignal_stmt",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "sp_proc_stmt_if",
  "$@18", "sp_proc_stmt_statement", "$@19", "sp_proc_stmt_return", "$@20",
  "sp_proc_stmt_unlabeled", "$@21", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@22", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@23", "$@24", "$@25", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@26", "$@27", "searched_case_stmt", "$@28",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@29", "$@30", "searched_when_clause", "$@31",
  "$@32", "else_clause_opt", "sp_labeled_control", "$@33", "sp_opt_label",
  "sp_labeled_block", "$@34", "sp_unlabeled_block", "$@35",
  "sp_block_content", "$@36", "sp_unlabeled_control", "$@37", "$@38",
  "$@39", "trg_action_time", "trg_event", "change_tablespace_access",
  "change_tablespace_info", "tablespace_info", "opt_logfile_group_name",
  "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@40", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create2",
  "create2a", "$@41", "create3", "$@42", "$@43", "opt_create_partitioning",
  "opt_partitioning", "partitioning", "$@44", "have_partitioning",
  "partition_entry", "$@45", "partition", "part_type_def", "$@46",
  "opt_linear", "opt_key_algo", "part_field_list", "part_field_item_list",
  "part_field_item", "part_column_list", "part_func", "sub_part_func",
  "opt_num_parts", "opt_sub_part", "$@47", "$@48", "sub_part_field_list",
  "sub_part_field_item", "part_func_expr", "opt_num_subparts", "part_defs",
  "part_def_list", "part_definition", "$@49", "part_name",
  "opt_part_values", "$@50", "$@51", "part_func_max", "part_values_in",
  "part_value_list", "part_value_item", "$@52", "$@53",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@54", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@55", "$@56", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "$@57", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "row_types", "merge_insert_types", "opt_select_from", "udf_type",
  "create_field_list", "field_list", "field_list_item", "column_def",
  "key_def", "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "$@58", "type", "$@59", "$@60",
  "spatial_type", "char", "nchar", "varchar", "nvarchar", "int_type",
  "real_type", "float_options", "precision", "field_options",
  "field_opt_list", "field_option", "field_length", "opt_field_length",
  "opt_precision", "opt_attribute", "opt_attribute_list", "attribute",
  "type_with_opt_collate", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident", "opt_component",
  "string_list", "alter", "$@61", "$@62", "$@63", "$@64", "$@65", "$@66",
  "$@67", "ev_alter_on_schedule_completion", "opt_ev_rename_to",
  "opt_ev_sql_stmt", "ident_or_empty", "alter_commands", "$@68", "$@69",
  "$@70", "remove_partitioning", "all_or_alt_part_name_list",
  "add_partition_rule", "$@71", "add_part_extra", "reorg_partition_rule",
  "$@72", "reorg_parts_rule", "$@73", "alt_part_name_list",
  "alt_part_name_item", "alter_list", "add_column", "alter_list_item",
  "$@74", "$@75", "$@76", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "$@77", "$@78", "start",
  "start_transaction_opts", "slave_thread_opts", "$@79",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@80", "opt_checksum_type", "repair",
  "$@81", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@82", "binlog_base64_event", "check", "$@83",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "$@84", "opt_no_write_to_binlog", "rename", "$@85", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@86",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@87",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@88", "cache_keys_spec", "$@89",
  "cache_key_list_or_empty", "opt_ignore_leaves", "select", "select_init",
  "select_paren", "select_paren_derived", "select_init2", "$@90",
  "select_part2", "$@91", "$@92", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "optional_braces", "expr", "bool_pri",
  "predicate", "bit_expr", "or", "and", "not", "not2", "comp_op",
  "all_or_any", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@93", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@94", "$@95", "$@96",
  "variable", "$@97", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "$@98",
  "cast_type", "opt_expr_list", "expr_list", "ident_list_arg",
  "ident_list", "opt_expr", "opt_else", "when_list", "table_ref",
  "join_table_list", "esc_table_ref", "derived_table_list", "join_table",
  "$@99", "$@100", "$@101", "$@102", "$@103", "$@104", "$@105",
  "normal_join", "table_factor", "$@106", "select_derived_union", "$@107",
  "$@108", "select_init2_derived", "select_part2_derived", "$@109",
  "$@110", "select_derived", "$@111", "select_derived2", "$@112", "$@113",
  "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@114",
  "$@115", "index_hints_list", "opt_index_hints_list", "$@116",
  "opt_key_definition", "$@117", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@118", "having_clause", "$@119", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@120", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "real_ulong_num", "ulonglong_num", "real_ulonglong_num", "dec_num_error",
  "dec_num", "procedure_clause", "$@121", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@122",
  "select_var_list", "select_var_ident", "into", "$@123",
  "into_destination", "$@124", "$@125", "do", "$@126", "drop", "$@127",
  "$@128", "$@129", "table_list", "table_name", "table_alias_ref_list",
  "table_alias_ref", "if_exists", "opt_temporary", "insert", "$@130",
  "$@131", "replace", "$@132", "$@133", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@134", "fields", "insert_values", "$@135", "$@136", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@137", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@138", "update", "$@139", "$@140", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@141", "single_multi", "$@142", "$@143", "$@144", "table_wild_list",
  "table_wild_one", "opt_wild", "opt_delete_options", "opt_delete_option",
  "truncate", "$@145", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@146", "show_param",
  "$@147", "$@148", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@149", "$@150", "describe_command",
  "opt_extended_describe", "opt_describe_column", "flush", "$@151",
  "flush_options", "$@152", "$@153", "opt_with_read_lock",
  "flush_options_list", "flush_option", "opt_table_list", "reset", "$@154",
  "reset_options", "reset_option", "$@155", "slave_reset_options", "purge",
  "$@156", "purge_options", "purge_option", "kill", "kill_option", "use",
  "load", "$@157", "$@158", "$@159", "$@160", "data_or_xml", "opt_local",
  "load_data_lock", "opt_duplicate", "opt_field_term", "field_term_list",
  "field_term", "opt_line_term", "line_term_list", "line_term",
  "opt_xml_rows_identified_by", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "load_data_set_list", "load_data_set_elem",
  "text_literal", "text_string", "param_marker", "signed_literal",
  "literal", "NUM_literal", "insert_ident", "table_wild", "order_ident",
  "simple_ident", "simple_ident_nospvar", "simple_ident_q", "field_ident",
  "table_ident", "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "$@161", "opt_option", "option_value_list", "option_type_value",
  "$@162", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@163",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@164", "handler", "$@165", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@166",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "$@167", "$@168", "$@169",
  "$@170", "opt_and", "require_list", "require_list_element",
  "grant_ident", "user_list", "grant_list", "grant_user",
  "opt_column_list", "column_list", "column_list_id", "require_clause",
  "grant_options", "opt_grant_option", "grant_option_list", "grant_option",
  "begin", "$@171", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "$@172", "union_opt",
  "opt_union_order_or_limit", "union_order_or_limit", "$@173",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@174", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "$@175",
  "view_list_opt", "view_list", "view_select", "$@176", "view_select_aux",
  "view_check_option", "trigger_tail", "$@177", "$@178", "$@179",
  "udf_tail", "sf_tail", "$@180", "$@181", "$@182", "$@183", "$@184",
  "sp_tail", "$@185", "$@186", "$@187", "$@188", "xa", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@189", "opt_migrate", "install", "uninstall", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   124,    38,    45,    43,    42,    47,    37,
      94,   126,    40,    41,    44,    33,   123,   125,    59,    64,
      46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   612,   613,   614,   613,   613,   615,   615,   616,   616,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   618,   619,   619,   620,   621,   621,   623,   622,   624,
     624,   625,   625,   626,   628,   627,   630,   629,   631,   631,
     632,   632,   632,   632,   632,   632,   632,   632,   632,   632,
     632,   632,   632,   632,   632,   633,   633,   633,   634,   635,
     635,   635,   635,   637,   636,   638,   636,   639,   636,   640,
     636,   641,   636,   642,   636,   636,   636,   636,   636,   643,
     644,   644,   645,   645,   645,   645,   645,   645,   645,   647,
     646,   649,   648,   648,   650,   650,   650,   650,   651,   651,
     652,   652,   653,   653,   654,   654,   655,   655,   657,   656,
     658,   658,   658,   658,   658,   658,   658,   658,   658,   658,
     658,   658,   658,   659,   660,   660,   661,   661,   662,   662,
     663,   663,   663,   663,   663,   663,   663,   664,   664,   664,
     665,   665,   667,   666,   668,   668,   669,   669,   670,   670,
     671,   671,   672,   672,   673,   674,   675,   675,   676,   676,
     677,   678,   678,   678,   678,   679,   679,   680,   680,   681,
     681,   683,   682,   682,   684,   682,   682,   686,   685,   687,
     687,   688,   688,   689,   690,   690,   691,   692,   692,   693,
     693,   693,   693,   693,   694,   695,   695,   696,   696,   697,
     697,   698,   698,   699,   699,   699,   700,   700,   700,   700,
     700,   700,   700,   700,   700,   700,   700,   700,   701,   702,
     702,   703,   703,   704,   704,   704,   704,   704,   704,   704,
     704,   704,   704,   704,   704,   704,   706,   705,   708,   707,
     710,   709,   712,   711,   713,   714,   715,   717,   716,   718,
     719,   719,   719,   720,   720,   722,   723,   724,   721,   725,
     725,   725,   726,   726,   728,   729,   727,   731,   730,   732,
     732,   733,   733,   735,   736,   734,   738,   739,   737,   740,
     740,   742,   741,   743,   743,   745,   744,   747,   746,   749,
     748,   750,   751,   752,   750,   753,   750,   754,   754,   755,
     755,   755,   756,   757,   758,   759,   759,   760,   760,   761,
     762,   763,   763,   765,   764,   766,   766,   766,   767,   767,
     767,   768,   769,   769,   769,   770,   770,   770,   770,   770,
     770,   770,   770,   771,   772,   772,   772,   773,   773,   773,
     773,   773,   774,   775,   775,   775,   776,   776,   776,   776,
     776,   776,   776,   777,   778,   778,   778,   779,   779,   779,
     780,   781,   782,   783,   784,   785,   785,   785,   786,   787,
     788,   789,   790,   791,   792,   793,   794,   795,   795,   796,
     796,   797,   797,   798,   798,   798,   798,   799,   800,   799,
     801,   802,   801,   803,   801,   804,   805,   805,   807,   806,
     808,   810,   809,   811,   812,   813,   812,   812,   812,   812,
     812,   814,   814,   815,   815,   816,   816,   817,   817,   818,
     819,   820,   821,   822,   822,   823,   824,   823,   825,   823,
     826,   826,   827,   828,   829,   829,   830,   830,   831,   831,
     833,   832,   834,   835,   836,   835,   837,   835,   838,   838,
     839,   839,   840,   840,   842,   843,   841,   844,   844,   845,
     845,   846,   846,   847,   847,   849,   848,   850,   851,   851,
     852,   852,   853,   853,   853,   853,   853,   853,   853,   853,
     855,   856,   854,   857,   857,   858,   858,   859,   859,   860,
     860,   861,   861,   862,   862,   863,   864,   864,   865,   865,
     866,   866,   867,   867,   867,   868,   868,   868,   868,   868,
     868,   868,   868,   868,   868,   868,   868,   868,   869,   868,
     868,   868,   868,   868,   868,   868,   868,   868,   868,   868,
     870,   871,   872,   873,   874,   874,   874,   874,   874,   874,
     875,   875,   875,   876,   876,   877,   877,   877,   877,   878,
     879,   879,   880,   880,   881,   881,   882,   882,   882,   882,
     882,   882,   883,   883,   884,   885,   885,   886,   888,   887,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   890,   889,   891,   889,   889,
     889,   892,   892,   892,   892,   892,   892,   892,   892,   893,
     894,   894,   895,   895,   896,   896,   896,   896,   896,   897,
     897,   897,   897,   897,   898,   898,   898,   899,   899,   899,
     900,   901,   901,   902,   902,   903,   903,   903,   904,   904,
     904,   904,   905,   905,   906,   906,   907,   907,   908,   908,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   910,   911,   911,   912,   912,   913,   913,   914,   914,
     915,   915,   916,   916,   917,   917,   918,   919,   919,   920,
     920,   921,   921,   922,   922,   922,   923,   923,   923,   924,
     924,   924,   924,   924,   924,   924,   925,   925,   926,   926,
     927,   928,   928,   929,   929,   930,   930,   930,   930,   931,
     931,   931,   931,   931,   932,   932,   932,   932,   932,   933,
     934,   934,   935,   935,   936,   936,   937,   937,   937,   938,
     938,   939,   940,   941,   942,   942,   943,   943,   944,   944,
     945,   945,   946,   946,   947,   947,   948,   948,   949,   949,
     950,   950,   951,   951,   952,   953,   953,   954,   954,   954,
     955,   955,   956,   956,   957,   957,   958,   958,   959,   959,
     961,   960,   962,   960,   960,   963,   960,   964,   960,   965,
     960,   966,   960,   967,   960,   960,   960,   960,   960,   960,
     968,   968,   968,   968,   969,   969,   970,   970,   971,   971,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     973,   972,   972,   974,   972,   975,   972,   972,   972,   972,
     976,   977,   977,   979,   978,   980,   980,   980,   982,   981,
     983,   984,   983,   985,   985,   986,   987,   987,   988,   989,
     989,   989,   990,   989,   991,   992,   989,   989,   989,   989,
     989,   989,   989,   989,   989,   989,   989,   989,   989,   989,
     993,   993,   994,   994,   995,   995,   995,   996,   996,   996,
     997,   997,   997,   997,   999,   998,   998,  1000,   998,   998,
    1001,  1002,  1002,  1004,  1003,  1005,  1005,  1006,  1006,  1006,
    1007,  1007,  1008,  1008,  1010,  1009,  1011,  1011,  1011,  1013,
    1012,  1014,  1014,  1015,  1015,  1016,  1016,  1016,  1018,  1017,
    1019,  1021,  1020,  1022,  1022,  1023,  1023,  1024,  1024,  1024,
    1024,  1024,  1024,  1026,  1025,  1027,  1027,  1027,  1029,  1028,
    1028,  1030,  1030,  1031,  1031,  1032,  1034,  1033,  1035,  1035,
    1036,  1036,  1037,  1038,  1039,  1039,  1041,  1040,  1042,  1042,
    1043,  1043,  1044,  1045,  1047,  1046,  1049,  1048,  1050,  1050,
    1051,  1051,  1052,  1053,  1053,  1054,  1054,  1055,  1055,  1057,
    1056,  1059,  1060,  1058,  1061,  1061,  1061,  1061,  1061,  1062,
    1062,  1063,  1063,  1064,  1064,  1065,  1065,  1065,  1066,  1066,
    1066,  1067,  1067,  1067,  1068,  1068,  1069,  1070,  1071,  1071,
    1071,  1071,  1071,  1072,  1072,  1073,  1073,  1073,  1073,  1073,
    1073,  1073,  1073,  1073,  1073,  1073,  1074,  1074,  1074,  1074,
    1074,  1074,  1075,  1075,  1075,  1075,  1075,  1075,  1075,  1075,
    1075,  1075,  1075,  1075,  1075,  1075,  1076,  1076,  1076,  1076,
    1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,
    1076,  1077,  1077,  1078,  1078,  1079,  1079,  1080,  1080,  1081,
    1081,  1081,  1081,  1081,  1081,  1082,  1082,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1086,
    1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,
    1086,  1086,  1086,  1086,  1086,  1086,  1087,  1087,  1087,  1087,
    1087,  1087,  1087,  1087,  1089,  1088,  1088,  1090,  1090,  1091,
    1091,  1092,  1092,  1093,  1093,  1094,  1094,  1095,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1097,  1098,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1099,  1096,
    1101,  1100,  1102,  1102,  1102,  1103,  1103,  1104,  1104,  1105,
    1105,  1107,  1106,  1108,  1108,  1108,  1108,  1108,  1108,  1108,
    1108,  1108,  1108,  1108,  1109,  1109,  1110,  1110,  1111,  1111,
    1112,  1112,  1113,  1113,  1114,  1114,  1115,  1115,  1116,  1116,
    1117,  1118,  1118,  1119,  1119,  1120,  1120,  1121,  1120,  1122,
    1120,  1123,  1120,  1120,  1124,  1120,  1125,  1120,  1120,  1126,
    1120,  1127,  1120,  1120,  1128,  1128,  1128,  1130,  1129,  1129,
    1129,  1131,  1132,  1133,  1131,  1134,  1136,  1137,  1135,  1139,
    1138,  1141,  1142,  1140,  1143,  1144,  1145,  1145,  1146,  1146,
    1146,  1146,  1147,  1147,  1149,  1148,  1150,  1148,  1151,  1151,
    1152,  1153,  1152,  1155,  1154,  1156,  1156,  1157,  1157,  1158,
    1158,  1159,  1159,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1161,  1161,  1161,  1161,  1161,
    1161,  1161,  1161,  1161,  1162,  1162,  1162,  1162,  1163,  1163,
    1163,  1164,  1164,  1165,  1165,  1166,  1167,  1166,  1168,  1169,
    1168,  1170,  1170,  1171,  1171,  1172,  1172,  1173,  1173,  1173,
    1174,  1175,  1175,  1176,  1177,  1177,  1179,  1178,  1180,  1180,
    1181,  1181,  1181,  1182,  1182,  1183,  1183,  1184,  1185,  1185,
    1185,  1186,  1186,  1186,  1186,  1186,  1187,  1187,  1188,  1188,
    1188,  1188,  1188,  1188,  1189,  1189,  1189,  1189,  1189,  1190,
    1190,  1190,  1190,  1190,  1191,  1191,  1191,  1191,  1192,  1193,
    1193,  1194,  1195,  1194,  1196,  1196,  1197,  1197,  1198,  1200,
    1199,  1201,  1201,  1202,  1202,  1204,  1203,  1206,  1207,  1205,
    1205,  1205,  1209,  1208,  1211,  1210,  1212,  1210,  1210,  1210,
    1210,  1210,  1210,  1213,  1210,  1210,  1210,  1210,  1210,  1210,
    1214,  1214,  1215,  1216,  1216,  1217,  1218,  1218,  1219,  1219,
    1221,  1222,  1220,  1224,  1225,  1223,  1226,  1226,  1226,  1226,
    1227,  1227,  1228,  1228,  1229,  1230,  1230,  1230,  1231,  1230,
    1232,  1232,  1233,  1233,  1234,  1233,  1235,  1233,  1236,  1236,
    1237,  1237,  1238,  1239,  1239,  1240,  1240,  1242,  1241,  1243,
    1243,  1244,  1244,  1245,  1245,  1246,  1247,  1246,  1249,  1250,
    1248,  1251,  1251,  1252,  1253,  1253,  1254,  1255,  1255,  1257,
    1256,  1259,  1258,  1260,  1258,  1261,  1258,  1262,  1262,  1263,
    1263,  1264,  1264,  1265,  1265,  1266,  1266,  1266,  1268,  1267,
    1269,  1269,  1270,  1270,  1271,  1271,  1272,  1272,  1272,  1272,
    1272,  1272,  1272,  1272,  1272,  1273,  1273,  1275,  1274,  1276,
    1276,  1276,  1276,  1276,  1276,  1276,  1276,  1276,  1276,  1276,
    1276,  1277,  1276,  1278,  1276,  1276,  1276,  1276,  1276,  1276,
    1276,  1276,  1276,  1276,  1276,  1276,  1276,  1276,  1276,  1276,
    1276,  1276,  1276,  1276,  1276,  1276,  1276,  1276,  1276,  1276,
    1276,  1276,  1276,  1276,  1276,  1276,  1279,  1279,  1279,  1280,
    1280,  1281,  1281,  1282,  1282,  1283,  1283,  1284,  1284,  1285,
    1285,  1286,  1286,  1287,  1287,  1287,  1289,  1288,  1290,  1288,
    1291,  1291,  1292,  1292,  1292,  1293,  1293,  1293,  1295,  1294,
    1297,  1298,  1296,  1296,  1299,  1299,  1300,  1300,  1301,  1301,
    1301,  1301,  1301,  1301,  1301,  1301,  1301,  1301,  1301,  1301,
    1301,  1301,  1301,  1302,  1302,  1304,  1303,  1305,  1305,  1307,
    1306,  1306,  1306,  1308,  1308,  1310,  1309,  1311,  1312,  1312,
    1313,  1314,  1314,  1314,  1315,  1317,  1318,  1319,  1320,  1316,
    1321,  1321,  1322,  1322,  1323,  1323,  1323,  1324,  1324,  1324,
    1325,  1325,  1326,  1326,  1327,  1327,  1327,  1327,  1328,  1328,
    1329,  1329,  1330,  1330,  1331,  1331,  1332,  1332,  1333,  1333,
    1334,  1334,  1334,  1335,  1335,  1336,  1336,  1337,  1337,  1338,
    1338,  1339,  1340,  1340,  1340,  1340,  1341,  1341,  1341,  1342,
    1343,  1343,  1343,  1344,  1344,  1344,  1344,  1344,  1344,  1344,
    1344,  1344,  1344,  1344,  1344,  1345,  1345,  1345,  1345,  1345,
    1346,  1346,  1347,  1347,  1348,  1349,  1349,  1350,  1350,  1351,
    1351,  1351,  1352,  1352,  1352,  1352,  1353,  1353,  1353,  1354,
    1354,  1355,  1356,  1356,  1357,  1358,  1359,  1360,  1360,  1361,
    1361,  1362,  1362,  1362,  1363,  1363,  1363,  1364,  1364,  1364,
    1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,
    1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,
    1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,
    1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,  1364,
    1364,  1364,  1364,  1364,  1364,  1364,  1364,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,  1365,
    1365,  1365,  1365,  1365,  1365,  1367,  1366,  1368,  1368,  1369,
    1369,  1371,  1370,  1372,  1372,  1372,  1372,  1373,  1373,  1374,
    1374,  1374,  1374,  1375,  1375,  1375,  1375,  1376,  1376,  1377,
    1377,  1378,  1378,  1378,  1378,  1378,  1378,  1378,  1379,  1379,
    1379,  1380,  1380,  1380,  1380,  1381,  1381,  1381,  1382,  1382,
    1382,  1382,  1382,  1384,  1383,  1385,  1385,  1386,  1386,  1387,
    1388,  1388,  1388,  1388,  1390,  1389,  1391,  1391,  1392,  1391,
    1393,  1393,  1394,  1394,  1395,  1395,  1395,  1395,  1396,  1395,
    1397,  1397,  1397,  1397,  1397,  1398,  1399,  1399,  1399,  1399,
    1399,  1400,  1401,  1401,  1401,  1401,  1402,  1402,  1403,  1403,
    1404,  1404,  1405,  1405,  1407,  1406,  1408,  1406,  1409,  1406,
    1410,  1406,  1406,  1406,  1406,  1406,  1406,  1406,  1406,  1406,
    1406,  1406,  1406,  1406,  1406,  1406,  1406,  1406,  1406,  1406,
    1406,  1406,  1406,  1406,  1406,  1406,  1406,  1406,  1411,  1411,
    1412,  1412,  1413,  1413,  1413,  1414,  1414,  1414,  1414,  1415,
    1415,  1416,  1416,  1417,  1417,  1417,  1417,  1417,  1418,  1418,
    1419,  1419,  1420,  1421,  1421,  1421,  1421,  1421,  1422,  1422,
    1423,  1423,  1424,  1424,  1425,  1425,  1425,  1425,  1425,  1427,
    1426,  1428,  1428,  1429,  1429,  1429,  1430,  1430,  1430,  1431,
    1431,  1432,  1433,  1433,  1434,  1435,  1436,  1436,  1438,  1437,
    1439,  1439,  1439,  1440,  1440,  1442,  1441,  1443,  1443,  1444,
    1444,  1444,  1445,  1445,  1446,  1447,  1446,  1448,  1449,  1450,
    1451,  1451,  1452,  1452,  1453,  1453,  1453,  1453,  1453,  1453,
    1453,  1453,  1454,  1454,  1454,  1455,  1455,  1455,  1455,  1455,
    1456,  1456,  1456,  1456,  1456,  1456,  1457,  1457,  1458,  1459,
    1460,  1460,  1460,  1461,  1462,  1462,  1462,  1463,  1463,  1463,
    1465,  1464,  1466,  1466,  1467,  1467,  1469,  1468,  1470,  1470,
    1471,  1471,  1471,  1471,  1473,  1474,  1475,  1472,  1476,  1476,
    1478,  1479,  1480,  1481,  1482,  1477,  1484,  1485,  1486,  1487,
    1483,  1488,  1488,  1488,  1488,  1488,  1488,  1489,  1489,  1489,
    1490,  1490,  1491,  1491,  1491,  1492,  1492,  1493,  1494,  1493,
    1495,  1495,  1496,  1497
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     4,     1,     2,     0,     4,     0,
       2,     3,     1,     2,     0,     3,     0,     5,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     5,     1,     0,     1,     3,     1,     3,
       3,     3,     3,     0,     7,     0,    12,     0,    12,     0,
      12,     0,     6,     0,     3,     4,     4,     3,     2,    10,
       1,     3,     2,     2,     2,     2,     2,     2,     2,     0,
      13,     0,     6,     2,     0,     1,     3,     1,     0,     2,
       0,     2,     0,     1,     3,     4,     0,     2,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     3,     1,     0,     2,     0,     2,
       2,     2,     2,     2,     3,     3,     1,     1,     1,     2,
       3,     3,     0,     4,     0,     3,     0,     1,     3,     1,
       0,     1,     3,     1,     0,     3,     0,     1,     3,     1,
       4,     0,     1,     1,     1,     0,     3,     2,     3,     0,
       3,     0,     5,     5,     0,     7,     5,     0,     2,     1,
       1,     1,     3,     1,     1,     1,     3,     0,     1,     1,
       1,     1,     2,     1,     3,     1,     1,     0,     1,     0,
       2,     3,     5,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       3,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     5,     0,     2,
       0,     3,     0,     2,     2,     2,     2,     0,     6,     2,
       0,     2,     1,     1,     3,     0,     0,     0,     7,     0,
       2,     2,     1,     1,     0,     0,     8,     0,     6,     1,
       2,     1,     2,     0,     0,     6,     0,     0,     6,     0,
       2,     0,     5,     0,     1,     0,     5,     0,     2,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     4,     5,     0,     4,     4,     4,     3,
       3,     2,     2,     0,     2,     1,     2,     3,     1,     1,
       1,     1,     1,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       2,     2,     2,     1,     1,     1,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     0,     1,     1,
       1,     1,     1,     2,     3,     2,     4,     5,     0,     5,
       0,     0,     5,     0,     7,     1,     0,     1,     0,     4,
       0,     0,     3,     5,     6,     0,     4,     2,     2,     2,
       2,     0,     1,     0,     3,     0,     1,     1,     3,     1,
       4,     5,     5,     0,     2,     0,     0,     7,     0,    10,
       1,     3,     1,     1,     0,     2,     0,     3,     1,     3,
       0,     6,     1,     0,     0,     5,     0,     4,     1,     1,
       1,     3,     1,     3,     0,     0,     5,     1,     3,     1,
       1,     0,     3,     1,     3,     0,     4,     1,     0,     1,
       2,     1,     3,     4,     3,     3,     3,     4,     4,     3,
       0,     0,     6,     0,     1,     0,     1,     1,     2,     1,
       1,     0,     1,     1,     2,     1,     0,     3,     0,     1,
       1,     2,     1,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     0,     6,
       1,     1,     3,     4,     4,     2,     2,     2,     3,     3,
       4,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     2,     2,     7,     8,     8,     8,
       8,     2,     0,     1,     4,     0,     1,     2,     0,     4,
       3,     3,     3,     1,     2,     1,     1,     3,     2,     3,
       2,     2,     1,     3,     3,     2,     3,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     2,     3,     2,     3,
       2,     2,     3,     3,     3,     0,     6,     0,     6,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     2,     1,     2,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     2,     0,     1,     1,
       5,     0,     1,     2,     1,     1,     1,     1,     3,     3,
       3,     3,     0,     1,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     2,     2,     1,     2,     1,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     0,     2,     1,
       1,     0,     1,     1,     2,     2,     1,     2,     2,     0,
       1,     1,     1,     3,     1,     3,     0,     1,     0,     1,
       5,     0,     3,     3,     1,     0,     2,     2,     2,     0,
       3,     3,     6,     6,     1,     1,     2,     2,     2,     1,
       2,     2,     1,     1,     0,     1,     1,     1,     1,     0,
       1,     1,     1,     0,     1,     2,     0,     1,     0,     1,
       0,     1,     1,     2,     1,     2,     1,     2,     2,     2,
       3,     2,     1,     1,     1,     1,     3,     1,     1,     1,
       4,     2,     1,     4,     0,     1,     0,     2,     1,     3,
       0,     6,     0,     5,     7,     0,     5,     0,     5,     0,
       5,     0,     4,     0,    10,     3,     4,     3,     3,     7,
       0,     3,     1,     4,     0,     3,     0,     2,     0,     1,
       0,     2,     2,     2,     2,     1,     1,     1,     3,     4,
       0,     6,     4,     0,     5,     0,     6,     4,     3,     1,
       2,     1,     1,     0,     5,     0,     3,     2,     0,     5,
       0,     0,     6,     1,     3,     1,     1,     3,     2,     3,
       2,     4,     0,     6,     0,     0,     8,     4,     4,     3,
       3,     2,     2,     6,     5,     3,     5,     1,     1,     1,
       0,     1,     0,     1,     0,     1,     1,     0,     2,     1,
       0,     1,     1,     1,     0,     5,     3,     0,     5,     3,
       3,     0,     3,     0,     2,     1,     3,     0,     1,     1,
       0,     2,     1,     3,     0,     5,     0,     1,     1,     0,
       6,     0,     1,     1,     2,     1,     1,     1,     0,     5,
       2,     0,     5,     0,     1,     1,     2,     1,     1,     1,
       1,     1,     2,     0,     5,     0,     1,     1,     0,     4,
       4,     3,     5,     1,     3,     3,     0,     6,     1,     1,
       1,     3,     2,     3,     1,     1,     0,     6,     1,     1,
       1,     3,     3,     4,     0,     6,     0,     2,     0,     4,
       0,     2,     1,     2,     4,     2,     3,     2,     3,     0,
       3,     0,     0,     6,     2,     1,     1,     2,     2,     8,
       4,     0,     1,     2,     1,     1,     1,     1,     0,     2,
       4,     3,     1,     1,     3,     4,     0,     0,     0,     2,
       2,     1,     1,     0,     2,     3,     3,     3,     2,     3,
       4,     3,     4,     3,     4,     1,     3,     4,     3,     3,
       6,     1,     5,     6,     5,     7,     6,     8,     5,     6,
       4,     4,     5,     3,     4,     1,     3,     3,     3,     3,
       3,     3,     5,     5,     3,     3,     3,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     3,     2,     2,
       2,     2,     3,     3,     5,     6,     4,     4,     7,     2,
       6,     5,     6,     6,     4,     4,     5,     4,     6,     2,
       4,     4,     4,    10,     6,     8,     6,     4,     4,     6,
       4,     4,     4,     6,     4,     7,     7,     7,     6,     6,
       6,     6,     3,     4,     6,     8,     2,     2,     4,     8,
       8,     6,     6,     2,     4,     6,     6,     8,     8,     6,
       8,     6,     2,     4,     8,     8,     2,     2,     2,     4,
       4,     4,     4,     3,     8,     4,     6,     4,     4,     4,
       6,     8,     6,     4,     6,     1,     6,     4,     4,     4,
       4,     4,     6,     4,     0,     5,     6,     2,     3,     0,
       4,     0,     3,     0,     1,     1,     3,     4,     4,     5,
       4,     4,     4,     5,     4,     0,     0,     7,     4,     5,
       4,     5,     4,     4,     4,     4,     4,     5,     0,     8,
       0,     3,     3,     1,     4,     0,     1,     0,     2,     0,
       1,     0,     3,     2,     3,     2,     1,     2,     1,     2,
       1,     1,     1,     2,     0,     1,     1,     3,     1,     3,
       1,     3,     0,     1,     0,     2,     4,     5,     1,     1,
       1,     1,     4,     1,     3,     3,     3,     0,     6,     0,
       6,     0,     8,     4,     0,     8,     0,    10,     6,     0,
       8,     0,    10,     6,     1,     2,     2,     0,     4,     3,
       5,     2,     0,     0,     7,     1,     0,     0,     6,     0,
       3,     0,     0,     5,     0,     1,     0,     1,     0,     2,
       3,     3,     1,     1,     0,     7,     0,     7,     1,     2,
       0,     0,     2,     0,     2,     0,     1,     1,     1,     1,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       1,     0,     2,     0,     1,     0,     0,     3,     0,     0,
       3,     2,     0,     0,     4,     4,     2,     0,     1,     1,
       3,     3,     1,     2,     0,     1,     0,     4,     4,     2,
       0,     1,     1,     0,     1,     0,     1,     2,     1,     3,
       3,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     0,     6,     0,     1,     3,     1,     3,     0,
       2,     3,     1,     2,     1,     0,     3,     0,     0,     7,
       2,     1,     0,     3,     0,     7,     0,     6,     4,     6,
       4,     4,     4,     0,     6,     4,     4,     5,     6,     4,
       1,     3,     1,     1,     3,     1,     0,     2,     0,     1,
       0,     0,     8,     0,     0,     6,     0,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     3,     4,     0,     3,
       3,     1,     2,     2,     0,     3,     0,     5,     3,     1,
       3,     1,     3,     1,     1,     0,     1,     0,     4,     0,
       1,     3,     1,     1,     1,     0,     0,     6,     0,     0,
      11,     3,     1,     3,     3,     1,     3,     0,     1,     0,
       4,     0,     6,     0,     5,     0,     6,     1,     3,     2,
       4,     0,     2,     0,     2,     1,     1,     1,     0,     4,
       0,     1,     0,     1,     1,     3,     1,     1,     2,     2,
       2,     1,     1,     1,     1,     0,     3,     0,     3,     2,
       4,     4,     3,     4,     4,     1,     3,     3,     6,     2,
       2,     0,     6,     0,     6,     5,     2,     1,     1,     1,
       5,     5,     2,     2,     1,     4,     3,     2,     3,     2,
       2,     1,     3,     4,     3,     3,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     1,     1,     1,     1,
       1,     0,     1,     0,     2,     0,     1,     1,     1,     0,
       2,     0,     2,     0,     2,     2,     0,     4,     0,     4,
       1,     1,     0,     1,     1,     0,     1,     1,     0,     4,
       0,     0,     5,     1,     0,     3,     3,     1,     2,     2,
       2,     2,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     0,     3,     3,     1,     0,
       3,     1,     2,     0,     1,     0,     3,     3,     2,     2,
       3,     0,     1,     1,     2,     0,     0,     0,     0,    21,
       1,     1,     0,     1,     0,     1,     1,     0,     1,     1,
       0,     2,     2,     1,     3,     4,     3,     3,     0,     2,
       2,     1,     3,     3,     0,     4,     0,     3,     1,     1,
       0,     3,     2,     3,     1,     1,     2,     0,     2,     3,
       1,     5,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     3,     5,     1,     1,     1,     1,     1,     3,
       4,     5,     1,     5,     3,     2,     1,     3,     2,     2,
       4,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     4,     0,     1,     1,
       3,     0,     2,     1,     1,     1,     1,     0,     1,     0,
       1,     1,     1,     0,     2,     2,     2,     1,     2,     4,
       5,     4,     6,     2,     3,     3,     3,     5,     1,     3,
       3,     2,     2,     2,     1,     1,     4,     4,     1,     1,
       1,     1,     1,     0,     4,     1,     1,     1,     3,     3,
       1,     1,     2,     2,     0,     3,     4,     3,     0,     7,
       1,     2,     1,     1,     1,     1,     1,     1,     0,     5,
       1,     1,     1,     1,     1,     3,     6,     6,     6,     7,
       5,     3,     8,     8,     8,     6,     0,     1,     1,     2,
       0,     1,     1,     3,     0,     3,     0,     3,     0,     3,
       0,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     3,     2,     2,     2,
       2,     2,     2,     2,     2,     1,     1,     2,     0,     1,
       3,     1,     2,     2,     2,     1,     3,     3,     1,     1,
       3,     1,     3,     4,     5,     4,     6,     1,     0,     3,
       3,     1,     1,     0,     2,     2,     2,     2,     0,     2,
       0,     3,     2,     1,     2,     2,     2,     2,     2,     0,
       3,     0,     1,     0,     3,     2,     0,     1,     2,     0,
       1,     4,     4,     5,     2,     3,     0,     1,     0,     4,
       0,     1,     1,     0,     1,     0,     2,     2,     1,     0,
       1,     1,     2,     3,     2,     0,     6,     3,     0,     0,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     3,
       1,     2,     1,     2,     3,     3,     3,     0,     3,     3,
       0,     7,     0,     3,     1,     3,     0,     3,     2,     4,
       0,     3,     4,     4,     0,     0,     0,    16,     8,     7,
       0,     0,     0,     0,     0,    15,     0,     0,     0,     0,
      12,     4,     4,     3,     4,     3,     2,     1,     3,     5,
       1,     1,     0,     1,     1,     0,     2,     0,     0,     3,
       0,     2,     5,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,  2428,   975,  2359,     0,     0,     0,     0,     0,     0,
    2361,   113,    62,  1579,  1690,  1691,  1492,  1518,     2,     0,
     975,   163,     0,    74,  1520,     0,  1741,     0,     0,   975,
     441,     0,  1735,     0,     0,   975,  1523,  1725,   237,   163,
    2361,     0,  1021,  2187,  1617,     0,     0,     0,     0,  1600,
       0,  2244,  1568,     0,     0,     0,     0,     3,     8,    19,
       0,    38,    24,    28,    14,    18,    13,    51,    45,    36,
      10,    53,    54,    16,    42,    11,    12,    15,    34,    41,
      35,    37,    49,  1012,    22,    23,    29,    43,    58,    20,
      55,    52,    21,  1692,    25,    44,    39,    31,    59,    32,
      50,    33,    57,    27,    46,    26,     9,    17,    47,    48,
      40,    60,    30,    56,     0,   848,     0,     0,   913,     0,
       0,     0,     0,     0,   831,  2426,  2427,  2428,   977,   976,
       0,  2361,  1844,   960,   986,  1907,  1908,  1909,  1910,  1911,
    1912,  1913,  1858,  1914,  1915,  1917,  1916,  1918,  1919,  1859,
    1860,  1920,  1921,  1922,  1924,  1923,  1925,  1861,  1862,  1926,
    1927,  1928,  1929,  1863,  1864,  1930,  1932,  1931,  1865,  1933,
    1934,  1935,  1937,  1936,  1866,  1938,  1867,  1939,  1940,  1941,
    1942,  1943,  1944,  1945,  1947,  1946,  1868,  1948,  1949,  1950,
    1951,  1952,  1954,  1953,  1955,  1956,  1957,  1869,  1958,  1959,
    1960,  1961,  1962,  1963,  1964,  1870,  1965,  1966,  1967,  1984,
    1871,  1968,  1971,  1970,  1969,  1972,  1973,  1974,  1976,  1975,
    1977,  1872,  1978,  1979,  1980,  1982,  1981,  1986,  1987,  1988,
    1873,  1983,  1985,  2166,  1989,  1991,  1990,  1992,  1994,  1993,
    1874,  1995,  1875,  1876,  1996,  1997,  1842,  1998,  1843,  1999,
    2001,  2002,  2003,  2008,  1877,  2000,  2004,  2005,  2006,  2007,
    2009,  1878,  2010,  2011,  2012,  2013,  2014,  2015,  2016,  2017,
    2018,  2019,  2030,  2023,  2025,  2026,  2028,  2024,  2029,  2033,
    2032,  2034,  2035,  2036,  2031,  2021,  2027,  2022,  2037,  2038,
    2020,  2039,  2040,  2041,  2042,  2043,  2044,  2045,  2046,  2047,
    2048,  2049,  2051,  2050,  2052,  2053,  2054,  2055,  2056,  2057,
    2059,  2058,  2060,  2061,  2062,  2064,  2063,  2066,  2067,  1879,
    2065,  2068,  2069,  2070,  2071,  2072,  1880,  1881,  1882,  2073,
    2074,  1883,  2075,  2076,  2077,  1884,  2078,  2079,  2081,  2080,
    2082,  2083,  1885,  1886,  2084,  2085,  2086,  2087,  2088,  2089,
    2090,  2091,  2092,  2093,  2094,  2095,  2096,  2097,  2099,  2098,
    2100,  2101,  2102,  2103,  2104,  2105,  2106,  1887,  2107,  1888,
    2108,  2109,  1889,  2110,  1890,  2111,  2112,  1891,  2113,  2114,
    2115,  2116,  2117,  2118,  1892,  2119,  2120,  2121,  1893,  2123,
    2122,  2124,  1894,  2126,  2127,  1895,  2125,  1897,  2128,  2129,
    1896,  1898,  2130,  2131,  2133,  2132,  2134,  2135,  2136,  1899,
    2137,  1900,  2138,  2139,  2140,  2141,  2142,  2144,  2143,  2145,
    2146,  2147,  2148,  2150,  2152,  2151,  2149,  2153,  2154,  2155,
    2156,  2159,  2160,  2161,  2162,  2157,  2158,  1901,  2163,  2164,
    2165,  2167,  2168,  2170,  2169,  1902,  1903,  2171,  2172,  1906,
    2173,  2174,  2177,  2175,  2176,  2179,  2178,  2180,  2181,  1904,
    2182,  1905,  2183,  2184,   182,  1847,   165,  1848,  1857,     0,
    2236,  2235,   944,   961,  2362,  2363,   536,   781,     0,     0,
     782,     0,   535,   780,   163,  2428,   118,     0,   532,   533,
       0,     0,     0,  1593,     0,  1516,  1516,  1516,     0,     0,
    1516,  1516,     0,  1519,  1516,   163,  1516,     0,    67,  1698,
       0,     0,     0,     0,  1841,     0,  1526,     0,  1742,  1743,
       0,  1750,     0,  1751,  1745,  2233,     0,     0,     0,     0,
       0,   163,   978,     0,  1577,     0,   227,   236,   238,   239,
     235,     0,  2363,  2374,  1013,  1019,  1031,  2188,  2185,  1675,
     239,   933,   933,   933,   931,   933,  1601,  1598,     0,     0,
    1577,  1744,  2480,     0,     0,     0,  2476,     0,  2481,     0,
    1021,     0,     0,     1,     5,     0,     0,  1979,  2077,  1688,
    1686,  1836,     0,   822,   849,     0,   827,     0,   825,  1853,
    1852,  1851,     0,   838,   837,   835,     0,   403,     0,     0,
    2437,   829,   958,  2360,     0,   184,     0,    76,     0,     0,
       0,  2366,     0,     0,     0,     0,   117,     0,     0,     0,
     114,  1046,  1046,  2428,  2430,  2432,   536,   534,     0,     0,
       0,  1597,  1596,  1595,     0,  1593,  1908,  1858,  1919,     0,
    1809,     0,     0,     0,  1292,     0,  1863,     0,  1933,  1935,
    1868,     0,     0,  1053,  1053,  1053,     0,     0,     0,  1956,
    1957,  1818,     0,     0,     0,  1806,  1819,  1991,  1992,     0,
    1808,  1997,     0,     0,     0,     0,  2014,  1816,     0,     0,
    2046,  2048,     0,     0,  2052,  2053,  2054,  2055,  1793,  1108,
       0,  1053,  1805,  1815,  2070,  1799,  2078,  2082,  2083,     0,
    2092,     0,     0,     0,  2117,  2121,     0,     0,  2141,     0,
       0,  1053,  1792,  2159,  2160,  2161,  2162,     0,  1807,  1901,
    1817,     0,  2173,  1053,  1053,  1053,     0,     0,     0,  2180,
    2184,     0,     0,     0,  2398,  1107,     0,  1260,     0,  1286,
    1065,  1071,  1085,     0,  1100,  1118,  1119,  1121,  1215,  1120,
    1126,  1125,  1493,  1803,  1124,  1123,  1804,  1117,  1826,  1847,
    1825,     0,     0,     0,     0,     0,     0,     0,     0,  1671,
       0,     0,  1503,  1516,    69,     0,  2280,  2295,  2296,  2292,
    2297,  2315,  2298,  2302,     0,  2294,  2286,     0,  2301,     0,
    2290,  2299,     0,  2284,     0,  2300,  2305,  2316,  2288,  2293,
    2271,     0,  2278,  2282,  1838,  1398,  2247,  2248,     0,    75,
    1528,  1529,  1527,   912,     0,  1740,     0,  1754,     0,   973,
     451,   442,     0,  1670,  1669,     0,  1736,  2375,     0,     0,
     949,  1531,  1578,     0,  1530,  1731,     0,  1729,  1726,  1728,
     228,     0,     0,   258,  2280,     0,  2265,     0,  2369,  2366,
    2376,  2411,  2406,  2405,  2408,  2409,  1037,  2410,  1036,  2407,
    2404,  1046,  1032,  1034,  1035,  2191,  1637,     0,   715,     0,
    1683,  1638,     0,     0,  1683,     0,  1433,  1673,  1676,     0,
    2200,  1651,   778,   777,   776,  2201,  1669,     0,  1625,  1639,
       0,  1602,  1644,     0,  2202,     0,  1672,     0,  1433,  1683,
       0,  1618,     0,     0,     0,     0,   234,   927,   937,   929,
     924,     0,   930,   926,     0,  2493,  2245,   912,  1798,  1797,
    1845,  2477,  1796,  2485,  2487,  2473,  2475,  2482,  1015,     0,
    2380,     6,    61,     0,  1695,  2435,  2436,  2434,   731,     0,
    1053,  1854,  2429,   166,   836,     0,   404,   166,     0,     0,
       0,     0,     0,   405,   406,   342,   820,   833,     0,     0,
     832,  2437,     0,     0,   988,   990,   989,  1006,   186,   183,
     164,     0,   946,  1510,  1512,   963,  2365,     0,     0,  2367,
    2371,  1106,  1105,     0,   111,   116,     0,     0,     0,  2337,
     115,  2331,  2433,  1046,  1046,  1046,  2425,     0,  2413,  2420,
    2421,  2424,  2423,  2422,  2419,     0,  2412,  2415,  2416,  2418,
    2417,  2437,  2431,     0,   783,   783,   783,     0,  1580,  1583,
    1587,  1591,  1594,     0,     0,  1403,  1139,  1403,  1403,  1403,
    1293,     0,     0,     0,     0,     0,     0,     0,     0,  1403,
       0,  1176,  1149,     0,  1177,     0,     0,     0,     0,     0,
    1812,     0,     0,  2398,     0,     0,     0,  1265,     0,     0,
       0,  2398,     0,     0,     0,     0,     0,  1288,  1290,  1825,
    1403,     0,     0,  1403,     0,     0,     0,     0,     0,  1058,
       0,  1183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1403,  1403,     0,     0,  1403,     0,  1192,
       0,  1814,     0,     0,     0,  1813,     0,     0,  1811,  1810,
    1794,     0,  1196,  1198,  1197,     0,  1403,  1403,     0,     0,
    1129,  1128,  1130,     0,     0,     0,     0,     0,     0,  1104,
    1103,  1102,  1101,     0,     0,     0,  1109,     0,  1110,  1111,
       0,  1112,  1113,  1114,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1131,     0,     0,     0,  1795,  1224,     0,
    1517,  1498,  1505,  1500,     0,  1671,  1501,  1509,   417,     0,
    1506,  2329,  1502,     0,  1494,     0,    68,     0,  1721,     0,
       0,     0,  1715,  1717,  1720,  1716,     0,     0,  1722,  1719,
       0,  1718,  1699,  1703,  1707,  1700,  2281,  2279,  2313,  2312,
    2317,     0,  2314,  2310,  2303,  2338,  2307,     0,  2338,  2309,
    2308,  2338,  2304,  2311,  2338,  2276,     0,  1399,  1400,     0,
    2246,     0,  1837,     0,     0,   996,  1755,  1756,  1752,  1398,
    2234,  2237,     0,   452,     0,     0,   463,     0,     0,    64,
      65,     0,   980,     0,   979,   983,     0,     0,     0,  1534,
    1524,  1533,  1732,  1733,     0,   226,   251,   246,   254,   248,
     250,   249,   255,   256,   257,   252,   247,   253,   240,     0,
    2279,     0,  2276,  2370,     0,  2372,  2389,  1020,  2377,  1043,
    1022,  1042,     0,  1033,  2186,  2189,  2197,  1679,   714,     0,
       0,  1650,     0,   536,     0,     0,     0,     0,     0,     0,
    1619,     0,     0,   573,     0,  1643,  1434,  1677,  1678,  1683,
       0,     0,  1683,     0,  1656,  1673,     0,  1683,  1614,     0,
       0,  1606,  1611,  1607,     0,  1613,  1612,  1615,  1603,  1604,
    1679,  1630,  1657,  1673,  1642,  1649,     0,  1629,  1636,     0,
    1647,  1673,  1673,  1683,  1683,   940,   939,   938,   934,   935,
     940,     0,  1599,  1327,     0,     0,  2474,  2488,  2472,  2483,
    2484,  2471,  1016,  2381,  1014,  2382,     0,     7,     4,  1689,
    1687,  1696,  1697,   732,   731,   527,   530,   529,     0,     0,
    1856,     0,   828,     0,  1671,   826,     0,     0,  1671,   353,
    1671,   407,   731,   840,     0,     0,   830,   959,     0,     0,
     440,  1006,   992,  1008,     0,   187,   189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    77,    78,    94,   948,   947,
       0,   945,   971,   970,   968,     0,   969,   967,   962,   964,
     965,  2364,  2368,   537,   731,  1671,     0,   345,     0,     0,
       0,     0,     0,   536,     0,     0,  2414,   103,   784,     0,
       0,     0,  1585,  1513,  1581,  1515,  1836,     0,     0,     0,
    1589,     0,     0,  1404,  1403,     0,  1271,     0,     0,     0,
       0,  1294,     0,     0,     0,     0,     0,     0,     0,  1245,
       0,  1271,  1054,     0,  1203,     0,     0,     0,     0,     0,
       0,  1374,  1375,  1376,  1377,  1385,  1378,  1379,  1380,  1387,
    1392,  1381,  1382,  1388,  1389,  1390,  1383,  1391,  1386,  1384,
    1393,     0,  1373,     0,  1396,  1394,  1397,  1395,     0,  1266,
    1258,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1403,     0,     0,     0,  1403,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1403,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1172,     0,  1828,  1827,     0,     0,     0,     0,  1133,
       0,  1132,  1336,     0,  2383,  2399,     0,  2203,  1261,  1263,
       0,  1056,  1055,  1057,  1068,  1061,  1066,  1059,  1063,     0,
    1115,  1913,  1069,     0,     0,  1097,  2398,  1412,  1098,  1083,
    1088,  1089,     0,  1086,  1087,     0,  1091,     0,  1090,  1094,
    1095,  1096,  1099,     0,     0,     0,     0,  1122,  1127,  1287,
    1046,  1829,     0,  1496,   417,   420,   419,  1507,   418,  1555,
       0,   914,     0,     0,    70,    72,  1712,  1709,  1708,  1710,
    1714,  1713,  1711,     0,  1723,  2306,     0,  2287,     0,  2291,
    2285,  2289,     0,     0,  2277,     0,  2283,  1402,  1987,  2063,
       0,  1405,  2250,  1521,  2492,     0,  1753,     0,     0,     0,
     974,     0,  1046,   450,   449,   448,   447,     0,   465,   445,
     453,    66,     0,     0,  1737,     0,     0,     0,     0,   951,
    1532,     0,  1734,  1730,  1727,     0,     0,     0,     0,     0,
       0,     0,  2373,  2391,  2390,  2378,  1046,  1424,  1047,  1047,
    1825,  2191,  2194,  2195,  2198,  2196,     0,  2193,  2192,  2207,
       0,  1681,  1684,  1685,     0,     0,  1665,  1659,  1658,  1654,
    1660,  1655,  1668,  1667,  1666,  1627,  1626,  1444,  1445,  1443,
    1437,  1438,  1442,  1441,  1622,  1674,  1664,  1662,  1652,  1683,
    1663,  1661,  1608,  1609,  1610,     0,  1433,     0,  1681,  1683,
    1673,     0,  1683,  1683,  1646,  1648,     0,   928,   937,   925,
     932,  1345,  1344,     0,  1301,     0,  1303,  1300,  1299,  1298,
       0,  1344,  2478,  2486,  2490,     0,  1433,  2388,  2386,   528,
    1555,  1555,     0,  1855,     0,     0,     0,     0,     0,     0,
       0,   167,   176,     0,     0,   351,   352,  1555,   350,   393,
     394,   397,   398,   399,     0,     0,     0,     0,     0,     0,
       0,     0,   120,   400,  1555,  1555,   347,   373,   374,   377,
     378,   379,   380,   381,   343,     0,   348,   910,   910,     0,
    1555,  1555,   910,  1555,     0,     0,  1555,  1555,     0,     0,
    1555,     0,     0,   910,     0,  1555,   908,     0,     0,  1555,
    1555,  1555,  1555,   910,     0,     0,  1555,   440,  1555,     0,
       0,   920,     0,     0,  1555,     0,     0,  1555,     0,  1555,
     856,   907,   540,   560,   561,   821,   855,   857,   869,   436,
       0,   886,   909,     0,   842,   844,  2438,  2439,  2440,   995,
     987,   994,   991,  1006,  1004,   993,   773,   772,     0,  1007,
     185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1511,   972,   966,   112,   731,  1555,  1555,  1555,  1555,
     349,   382,   383,   386,   387,   388,   389,   392,   390,   391,
       0,     0,  1671,     0,     0,  2332,     0,  2466,     0,     0,
       0,   165,   538,     0,     0,   785,     0,     0,     0,     0,
       0,  1405,     0,  1839,  1588,  1327,  1592,  1591,     0,  1199,
       0,  1238,     0,  1240,  1241,  1242,     0,     0,     0,     0,
       0,  1200,     0,  1147,  1201,  1202,     0,     0,     0,     0,
    1244,     0,  1178,     0,     0,  1150,  1151,  1144,  1136,     0,
    1217,     0,     0,  1152,     0,     0,     0,     0,     0,  1218,
    1289,     0,  1291,  1829,     0,  1250,  1205,  1157,     0,  1248,
       0,  1158,  1219,  1220,  1221,  1184,  1207,  1208,     0,  1223,
       0,  1209,     0,     0,     0,     0,  1160,  1254,  1252,     0,
       0,     0,     0,  1256,  1193,  1162,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,  1164,     0,  1145,
    1253,  1255,  1213,     0,  1173,     0,  2392,  1335,  2400,  1336,
       0,     0,  2394,  2384,  2389,  2397,  1137,     0,     0,     0,
       0,     0,  1830,  1062,  1067,  1060,  1064,  2398,     0,     0,
       0,     0,  1081,  1080,     0,     0,     0,  2398,  1412,  1084,
       0,     0,  1234,  1235,  1284,     0,  1499,  1497,  1508,  1553,
    1554,  1556,     0,  2330,   916,   915,  1504,   914,    73,     0,
    1706,  1724,  1701,  2342,     0,  2341,     0,  2325,  2328,  1836,
       0,     0,     0,  2260,  2254,  2261,  2263,  2257,  2262,  2264,
    2255,  2256,  2251,  2258,  1406,  1435,     0,   997,   999,  1000,
     998,  1006,     0,     0,  2240,  2241,  2239,  2238,   455,     0,
    1469,  1470,  1455,  1456,  1454,  1457,   464,  1458,  1468,     0,
     476,     0,     0,     0,  1739,  1738,     0,   981,   984,   985,
     956,   955,   957,   950,   952,   953,   520,  1538,     0,     0,
       0,  1544,  1525,  1535,     0,  1956,  2159,  2162,   241,   244,
     243,   245,     0,     0,     0,     0,     0,     0,  1041,  1327,
    1485,  1038,  1026,  1435,  1425,  1025,  1048,  1044,     0,  2190,
       0,  2157,  2218,     0,     0,     0,     0,     0,  2208,  1680,
       0,  1631,     0,  1653,     0,     0,  1624,     0,  1645,  1605,
    1633,  1623,  1405,  1673,  1620,  1621,   942,   941,   936,  1344,
    1327,     0,     0,  1324,  1346,     0,  1346,  1327,  1327,     0,
    1327,  1398,  1341,     0,     0,  2489,  1426,  2387,     0,     0,
     824,   170,   173,   171,     0,   172,     0,     0,   402,   401,
       0,  1671,   395,   124,   123,   125,   126,  1452,  1453,  1449,
    1450,  1448,  1451,   128,   127,   122,   839,     0,     0,     0,
    1671,   375,   354,   355,   358,   359,   360,   911,   814,   975,
     890,     0,   606,   814,   769,   774,   774,   888,     0,   975,
       0,     0,     0,     0,     0,   975,     0,     0,     0,  1555,
       0,   901,   851,     0,     0,     0,     0,     0,   902,     0,
     852,  1555,     0,     0,     0,     0,     0,   975,     0,     0,
     438,     0,   975,   870,   923,   922,   921,     0,   975,   975,
       0,   566,   567,   565,     0,     0,   558,   541,   731,   853,
     437,   854,   605,     0,   917,   602,   608,  1832,     0,     0,
       0,   134,  2442,     0,  1365,   188,    95,    84,    80,    99,
    1462,  1463,  1461,  1459,  1460,   100,    82,    83,    87,    86,
      88,    89,    90,    85,    91,    81,    92,   101,   102,    79,
       0,     0,     0,     0,  1671,   384,     0,     0,  1555,   344,
     361,   362,   365,   366,   367,   368,   369,   372,   370,   371,
       0,  2333,  2335,     0,     0,   338,   337,     0,   129,  2460,
       0,     0,   605,   104,   436,   539,   542,   807,   809,   808,
     799,   798,   105,   107,   109,  1514,  1591,  1327,  1424,  1837,
    1405,     0,  1590,     0,     0,  1239,  1272,     0,  1295,     0,
    1141,   692,   692,  1282,  1280,   677,   692,  1276,  1281,  1278,
       0,   717,     0,   716,     0,     0,     0,  1246,  1243,     0,
       0,     0,     0,  1269,     0,     0,     0,  1146,     0,  1229,
    1251,  1249,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1257,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1134,  1046,  2401,  2403,
    1017,     0,  2393,  2395,  2204,  2205,  2206,   816,  1262,     0,
    1078,  1074,     0,  1072,  1411,  1093,  1092,     0,     0,     0,
    1082,  1047,  1225,  1046,     0,  1285,  1831,   416,   572,  1495,
      71,  1704,  2339,     0,  2350,     0,     0,     0,     0,     0,
       0,     0,  2249,  1436,  1565,     0,  1006,  1010,  1846,  1746,
    2242,  2243,     0,   456,   457,   459,  1047,   473,   451,     0,
     443,   446,     0,   455,     0,   954,  1031,     0,  1557,  1542,
    1549,  1543,     0,     0,     0,  1541,  1821,  1820,  1827,  2376,
       0,     0,  2270,     0,     0,     0,  2379,  1405,  1405,  1479,
       0,     0,  1023,  1028,  1024,  1027,     0,  1045,  1052,  1051,
    1822,  1829,     0,     0,     0,     0,   719,   718,   727,     0,
       0,     0,  2203,     0,   723,   725,   724,  2213,   722,  1682,
    1433,  1641,  1640,  1440,  1439,  1616,  1433,  1635,  1683,     0,
       0,  2383,  1339,     0,  1326,  1325,  1347,     0,  1327,  1346,
    1346,     0,  1306,  1305,  1569,  1572,     0,  1304,  1363,  1329,
    1031,  2479,  2491,     0,   730,   729,   571,   726,   570,   175,
     174,   180,   181,   422,   408,   421,   396,   121,   409,   410,
     376,     0,   356,   607,   815,   873,     0,     0,     0,   774,
     601,   814,   783,   775,   814,   814,     0,     0,   551,   548,
     892,   554,   871,   863,   872,   883,   885,     0,   550,   568,
       0,     0,   556,   814,   858,   899,   900,   914,   545,     0,
     581,   582,   580,   562,   569,   546,   547,   894,     0,  1420,
    1422,  1430,   553,   552,     0,   549,     0,   905,   878,     0,
     579,   577,   574,   576,   575,   578,   557,   555,   868,     0,
     910,   910,   887,     0,   589,   590,   592,   593,  1835,     0,
     919,   889,     0,   594,   603,   595,     0,     0,     0,   144,
       0,     0,   841,     0,   137,   135,   146,     0,     0,     0,
    1368,     0,  1369,  1366,  1367,     0,    96,    98,   415,   414,
     413,   412,   385,     0,     0,     0,  1671,   363,  2334,     0,
       0,  2467,   341,   339,   340,     0,     0,   190,   587,   588,
     586,   585,     0,   425,     0,  1884,   423,     0,   435,     0,
    1757,   731,   543,     0,     0,     0,     0,  1405,  1446,  1840,
    1584,     0,  1174,  1296,     0,     0,   693,  1273,   739,     0,
    1283,   679,   678,  1275,  1277,  1279,  1140,  1148,  1216,  1143,
    1142,     0,     0,     0,  1181,  1182,  1267,  1270,     0,     0,
    1154,     0,  1156,     0,     0,  1231,  1206,  1222,  1185,  1210,
       0,  1159,  1135,     0,  1186,     0,  1191,  1189,     0,  1163,
       0,     0,  1170,     0,  1168,     0,  1169,     0,  1171,  1212,
    1214,  1337,  2402,  1018,     0,     0,  1264,  1070,     0,  1079,
    1076,     0,  1073,  1048,  1236,  1226,     0,  1702,  2340,     0,
    2275,  2327,  2326,  2343,  2343,  2343,     0,  1407,     0,  1522,
    1001,  1006,  1010,     0,  1002,  1757,   460,     0,     0,     0,
     480,     0,   478,   454,     0,   982,  1046,  1539,  1551,     0,
    1559,     0,     0,  1536,  1546,     0,     0,     0,  1545,   242,
       0,  2267,  2268,  2266,  1435,  1413,     0,     0,  1491,     0,
    1486,  1039,     0,  1050,  1049,     0,  2220,     0,  2219,  2231,
    2232,  2229,  2230,  2228,  2209,     0,  2215,  2214,     0,     0,
       0,  2225,  2216,     0,     0,  1632,  1634,  1628,   943,  2389,
    1398,  1331,  1327,  1302,  1327,  1313,     0,     0,  1327,  1309,
    1307,  1311,     0,  1405,     0,  1328,  1360,  1046,  1824,  1427,
    1430,   357,   875,     0,   814,   770,   771,   783,     0,   783,
     783,     0,     0,   862,     0,   963,     0,   867,   727,   563,
     898,   897,   564,     0,   860,     0,  1431,  1432,  1423,   439,
     859,   880,   865,  1723,   891,   605,   918,   751,   673,   622,
     613,   692,   616,   615,   659,   630,   627,   677,   675,   645,
     677,   677,   652,   651,   669,   655,   635,   739,   739,   634,
     672,   739,   656,   654,   658,     0,   660,   677,   665,   653,
     657,   674,   650,   647,   671,   692,   629,   628,   631,   670,
     739,     0,   663,   692,   696,   633,   739,   746,     0,     0,
     692,   694,  1834,   145,   133,     0,     0,   843,   845,     0,
       0,   846,  2444,     0,  2446,     0,  1009,     0,    93,     0,
       0,   346,   411,   364,  2336,     0,   201,  1046,     0,     0,
     191,   193,   194,     0,     0,     0,   538,  1759,  1758,   424,
     523,   544,     0,     0,     0,  1591,  1586,     0,  1582,     0,
    1297,     0,     0,     0,     0,   733,   744,   742,   736,     0,
     740,   741,  1274,     0,  1247,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1138,     0,  1227,     0,     0,     0,
       0,     0,     0,  1167,  1165,  1166,  1435,  2383,   817,  1075,
       0,  1237,     0,     0,     0,  2348,  2348,  2348,  1564,  1563,
       0,  1562,  1566,  1003,  1011,     0,   458,   461,     0,   453,
       0,   477,     0,   444,   521,     0,     0,     0,  1560,  1548,
    2380,  1537,  1540,  1829,  2269,  1030,     0,  1408,  1490,  1487,
       0,  1480,  1482,  1484,     0,  1823,     0,     0,  2224,  2210,
     728,     0,     0,     0,     0,  2211,  1332,  1330,  1340,     0,
    1298,  1327,  1327,     0,  1298,     0,     0,     0,  1571,  1424,
    1573,  1364,     0,  1342,     0,  1429,     0,     0,   874,     0,
       0,     0,     0,     0,     0,   904,     0,   917,   864,   884,
     906,   696,   975,  1421,   879,   881,   951,     0,   591,     0,
     755,   621,   614,   632,   681,   676,     0,   681,   681,   641,
     659,   636,     0,   739,   649,   640,   661,   664,   666,   668,
     681,     0,   739,   638,   625,   681,   704,     0,     0,     0,
     700,     0,   749,     0,   707,   609,   697,   699,     0,     0,
     662,   739,   618,   747,   746,   620,   739,   746,   681,     0,
     695,   681,     0,   131,   136,   147,   148,   834,  2443,     0,
    2441,     0,  1005,  1370,    97,     0,     0,   204,   202,   203,
       0,   197,   199,   194,  2454,     0,  2461,     0,     0,  2459,
     426,   428,   436,   524,     0,     0,  1430,   812,     0,     0,
    1447,  1175,   690,   688,   691,   689,   735,   734,   738,     0,
     737,   746,     0,  1179,  1180,  1268,  1259,  1204,     0,  1155,
    1228,     0,     0,  1211,  1187,  1190,  1188,  1194,  1195,  1038,
    1038,   583,  2396,  1077,  1705,  2351,     0,     0,  2347,  2345,
       0,  2346,  2344,  2318,     0,  2273,  2274,  2272,  2259,     0,
       0,     0,  1046,   466,     0,   483,   482,   479,  1435,  1550,
    1552,  1558,  1547,     0,  1409,  1424,   720,  1483,     0,  1040,
    2222,  2221,  2223,  2217,     0,     0,     0,     0,  1314,     0,
    1318,  1323,  1319,     0,  1310,  1308,     0,  1446,  1352,  1353,
       0,     0,  1358,  1362,  1435,  1430,   877,     0,   604,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   903,
    1800,   893,   895,   861,     0,   866,   559,     0,   754,     0,
     759,   685,   686,   687,   642,   682,   684,     0,   644,   612,
     637,   667,   643,     0,   639,   626,   710,   709,  1053,   702,
     713,     0,     0,   708,   698,   706,   701,   617,   619,   623,
     624,   610,     0,   611,  1833,   138,   847,   278,  2445,  1021,
       0,  2450,   119,  2458,  2468,   201,     0,     0,   142,     0,
     192,   727,   195,  2380,  1757,     0,   431,   786,     0,   811,
       0,   788,   790,   745,   743,     0,     0,  1230,  1232,  1338,
     584,  2324,  2323,  2322,  2319,     0,     0,     0,     0,     0,
       0,  2349,  2353,  1561,     0,     0,     0,   474,     0,     0,
     508,   522,  1417,  1430,     0,  1435,     0,  1488,  1481,  2227,
    2226,  2212,  1333,     0,     0,     0,     0,     0,  1371,  1570,
    1348,  1348,  1359,  1343,  1428,   876,     0,     0,   786,     0,
       0,  1802,  1801,   917,     0,   752,     0,   756,   757,   758,
       0,   750,   683,     0,   818,     0,   712,  1053,   705,     0,
     140,   304,     0,   290,   276,     0,     0,     0,   280,   149,
     152,   150,     0,   151,   157,     0,   158,   159,   160,   161,
     162,   153,   302,   303,   156,   154,   155,     0,  1849,     0,
    1850,  2448,     0,     0,  2447,   168,   198,     0,     0,   134,
     143,  2462,   711,   429,   427,     0,  2376,     0,  1555,   106,
     787,   803,   802,   792,  1430,     0,     0,   108,   789,   805,
     796,   110,   791,   804,   794,   680,  1153,  2320,  2354,  2357,
    2355,  2356,  2358,  2352,     0,  1747,  1047,     0,   467,     0,
     470,   472,   486,     0,  1555,     0,     0,  1555,  1555,  1555,
    1555,   501,   509,   511,     0,  1418,  1419,     0,  1414,  1416,
    1410,  1471,   721,  1760,  2383,  1315,     0,  1320,     0,  1312,
       0,     0,  1356,  1354,     0,   786,   596,   788,   790,   896,
       0,   753,     0,     0,   739,     0,   739,   703,   139,     0,
     132,     0,     0,   289,   292,     0,     0,   295,   285,   284,
     286,     0,   279,   278,   278,   332,   283,   329,   328,   321,
    2380,     0,     0,     0,  2469,   200,  1046,   146,     0,   433,
     432,   801,     0,   793,   810,   813,     0,   797,   795,  1567,
    1575,     0,   720,     0,   475,   468,     0,     0,   484,     0,
    1555,  1555,     0,     0,     0,     0,     0,   481,   510,  1555,
    1430,     0,  1029,     0,  1768,  1334,     0,     0,  1372,     0,
    1349,     0,     0,     0,   600,   599,   597,   598,     0,   765,
       0,   764,     0,   761,   760,   646,   819,   648,   141,   305,
     316,   319,   311,   291,     0,     0,     0,   281,   278,     0,
     265,   263,   264,   270,   271,   272,   273,   274,   275,   266,
     269,   267,   268,   278,     0,   209,     0,     0,  2449,     0,
    2451,     0,   178,   177,   169,     0,   278,  2455,     0,  2463,
    2380,   800,   806,     0,     0,  1748,   462,   474,   471,   494,
     487,   490,     0,   519,     0,     0,  1466,  1464,  1465,   515,
    1467,   516,   514,   512,   505,     0,   503,     0,  1415,  1472,
       0,     0,     0,     0,  1761,  1763,     0,  1489,  1317,  1322,
    1351,  1350,  1365,     0,   882,   767,   768,   766,     0,     0,
       0,     0,   278,   312,     0,   287,     0,     0,     0,     0,
     207,   335,     0,   205,   323,   323,  2452,  2453,   179,  2470,
       0,   148,   168,   434,  1574,  1576,  1774,   469,   494,     0,
     492,     0,   488,   485,   489,   517,   518,     0,   502,     0,
     513,     0,     0,     0,     0,     0,  1762,     0,     0,  1769,
    1771,     0,     0,     0,     0,   313,   319,   309,   317,   278,
       0,     0,   277,   296,   331,   208,     0,   333,     0,   278,
       0,   322,   324,   326,     0,   130,  2464,     0,  1760,   491,
       0,   499,   495,   497,   500,   508,   507,   504,  1046,  1766,
    1767,     0,  1764,     0,     0,  1770,  1357,  1355,   763,   762,
       0,   310,     0,     0,   308,   288,   293,   278,     0,   278,
     220,   219,     0,   211,   259,   330,     0,   210,  2456,   278,
       0,  1768,   493,     0,     0,   506,     0,     0,  1475,  1477,
    1765,  1773,  1772,   314,     0,   278,     0,   278,     0,   278,
       0,     0,     0,     0,     0,   206,   278,  2465,     0,  1776,
     498,   496,  1047,  1473,  1046,     0,   306,   278,   294,   299,
     336,     0,   214,   260,   261,     0,   217,  2457,  1775,     0,
    1780,  1478,  1476,   278,   278,   295,   298,   334,     0,     0,
     212,   213,   225,   224,   216,     0,     0,     0,  1787,   278,
     278,   300,   233,   231,   278,   221,   229,   223,     0,   230,
     262,   218,  1778,  1779,  1777,  1782,     0,     0,  1784,  1785,
       0,  1749,     0,   215,   232,  1786,  1781,     0,  1788,  1790,
       0,   222,  1783,     0,  1046,  1789,     0,  1047,  1791
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    56,   575,  1378,    57,    58,    59,    60,    61,  1249,
      62,   774,  1186,  1664,  1665,    63,   515,    64,   971,  1435,
    1436,  2845,  2846,  1437,    65,  1992,  2883,  2884,  2885,  1454,
     485,   486,  1851,  1852,   996,  2866,  2832,  3595,  2836,  3700,
    3830,  3739,  1924,  3171,  3596,  3597,  3709,   510,  1990,  1392,
    3854,  1831,  3954,  1832,    66,   605,   969,  1414,  1415,  3189,
    3190,  3428,  3191,  3420,  3421,  3422,  3423,  4079,  3928,  4023,
    4080,  4152,  4188,  4194,  4195,  4122,  4204,  4205,  4206,  4192,
     841,  4207,    67,   538,   539,   843,  1278,  2238,  1279,    68,
    4123,  4190,  3929,  3930,  3837,  3931,  3712,  3932,  3841,  3933,
    3715,  3934,  3935,  3936,  3937,  4071,  3938,  3836,  4115,  3925,
    3926,  4117,  4169,  4186,  3939,  3722,  3831,  4010,  3723,  3832,
    4066,  3921,  4067,  4110,  4165,  3922,  4011,  4113,  4014,  3940,
    3946,  4081,  3941,  3947,  3942,  3727,  3848,  3945,  3846,  3944,
    4119,  4076,  2477,  2865,   593,   594,   616,  1982,   595,   985,
     944,  1394,  1864,  1865,  2342,  2343,  2459,  2460,  2461,  1856,
    1857,  1858,  1970,  1971,  1972,  1838,  1839,  1840,  1398,  1835,
    1836,   596,   945,   955,  1859,  1860,  1861,  2465,  1974,  1975,
    1976,  1977,  1862,  1657,  1863,  2734,  2483,  2876,  3613,  3199,
    3746,  3960,  2877,  2878,  2410,  2794,  2390,    69,   527,   821,
    1246,  2211,  1247,  2213,  2622,  2623,  2624,  1703,  1704,  3493,
    1708,  2210,  3647,  3967,  3779,  3780,  2626,  3778,  2630,  2991,
    2992,  3270,  3495,  3650,  3972,  3877,  4043,  3970,  4039,  3971,
    4041,  4134,  4092,  4093,  3887,  3985,  3986,  4047,  4095,  3791,
    3792,  3793,  2231,  2636,  3498,  3434,  1964,  1384,  1385,   487,
     488,   489,   613,  2484,  1911,  2485,  2486,  2809,  1913,  1914,
    2597,  1312,  2806,  2783,  3469,  2872,  2813,  2814,  2815,  2816,
    2817,  2823,  2750,  2351,  2352,  2415,  2826,  3611,  3356,  3371,
    3155,  3156,  3157,  3158,  3159,  3160,  3161,  2900,  2901,  3564,
    3565,  3566,  2896,  2897,  3401,  3385,  3386,  3387,  3612,  3579,
    3219,  2677,  2678,  3657,  2686,  2687,  2725,  3036,  2726,  1388,
    3220,  3221,  3222,  3395,  3388,  2825,  3350,  3557,  3560,  3691,
    3913,  2353,  2751,  2354,  2754,   900,   490,  2355,  2356,  1468,
    1469,  3749,  3757,  3761,  3750,  3762,  3758,  3751,  3752,  3753,
    3764,  3760,  2490,  3435,  3436,  2743,  2956,  3693,    70,  1402,
     938,   947,   943,   961,   600,  1403,  1925,  2421,  3407,   583,
    1915,  3342,  3085,  3346,  1916,  2763,  1917,  3072,  3328,  1918,
    3101,  3344,  3554,  2764,  2765,  1919,  1920,  1921,  3084,  3093,
    3683,  2357,   123,  2156,  2821,  2397,    71,  1360,  1355,    72,
     912,   907,   908,  1358,  1359,  1797,  2287,    73,   608,  1441,
      74,  1257,  2223,  2224,  2225,    75,   962,    76,    77,   609,
    1448,  1449,  1450,    78,  1242,   130,    79,   829,  1252,  1254,
    1255,    80,   604,   963,   964,   965,   966,  1930,    81,  1695,
    2187,  2188,  2189,  2190,  1411,  2423,  1412,  1413,  1939,  2984,
      82,    83,   572,  2111,   544,   850,   545,   546,  1737,  2251,
    3470,   861,   862,   863,  2662,  1290,  1291,  1292,  2256,  2667,
    1041,   739,   740,   741,   742,  1134,  1135,  3389,   743,  1144,
    1623,   744,   745,   746,   747,   748,   749,  1650,  2924,  2925,
    3236,  2141,  2142,  2143,   750,  2029,  2911,  2042,   751,  1127,
    1608,  1540,  3228,  2916,  1485,  2012,  2520,  2594,  2105,  1066,
    1067,  1031,  2019,  1491,  1804,  1805,  1806,  1807,  1808,  3316,
    3315,  3317,  3663,  3519,  3665,  3523,  2298,  1809,  1810,  2700,
    3517,  3804,  2106,  2107,  2108,  3246,  2701,  3052,  2719,  2720,
    3534,  2289,  1811,  2707,  3812,  3531,  3532,  3903,  3902,  3533,
    3321,  3322,  3065,  3066,  2841,  2842,  2843,  3667,  1531,  1532,
    1538,  1229,  1230,  1486,  2185,  2611,  3505,  3654,  2132,  3287,
    3652,  3798,  1922,  2789,  2790,  2253,  2254,  2723,  3069,  3098,
    1315,  3471,  2613,  1770,  1771,  3208,  4193,  2735,  2435,  3979,
    2207,  2208,  3892,  4051,  4137,  4138,  4139,  3018,  3019,  3291,
    3292,  2255,  2659,  3020,  3506,  3803,    84,   494,    85,  1662,
    2147,  1183,  2161,   973,  1472,  1473,   762,   507,    86,   516,
    2186,    87,   534,  1721,   813,   833,  1260,  1261,  2232,  2637,
    2644,  2233,  2649,  3280,  2639,  2997,  2998,  2151,  2152,  2640,
    3000,  3277,  3260,  3261,  2979,  3490,    88,   560,  3063,  2714,
    2715,  3869,  3870,   834,    89,   493,  1018,  2001,  1478,  2000,
    1019,  1020,  2003,   634,   635,    90,   914,   557,  1337,  1338,
    1339,  1786,    91,   549,   901,  2690,  2696,  1765,   825,  1179,
    1319,   904,  1320,  1751,  2271,  1301,    92,   934,   933,    93,
     579,  1380,    94,   775,  1202,  1674,  2601,  2967,  1203,  1204,
    2162,    95,   535,   838,   839,  1263,  1723,    96,   529,   826,
    1714,    97,   520,    98,    99,   817,  2985,  3872,  4036,   524,
    1697,  1238,  3200,  3894,  3994,  3995,  3997,  4059,  4060,  4088,
    4180,  4214,  4198,  4217,  4218,  4221,  4228,  4229,   753,   921,
     754,  3549,   755,   756,  2645,  2646,  3070,   757,  2647,   758,
    2744,   974,  1475,   513,   465,   590,   922,  2619,   760,  3729,
     941,   989,   467,   468,   100,   865,   548,  1294,  1295,  1296,
    1746,  1747,   905,  2120,  1748,  1749,  2268,  2263,  3299,  3042,
    3034,   101,   818,   472,  1240,  1241,  2196,   102,   559,   103,
    1231,  1691,  1692,  2182,  2610,  2183,   104,   846,   105,   800,
    1685,   801,  1207,   802,   803,  1221,  1215,  1224,  1218,  3635,
    3482,  3483,  2170,  1182,   990,   991,  1677,  2164,  2165,  3255,
    3485,  2970,  3641,  3642,   106,   131,   475,   611,   980,  1284,
     107,   108,   109,   110,  1287,  1373,  2247,  1374,  2112,  1375,
    1376,  1818,  1735,  1604,  1605,  2954,  1124,  1125,  2115,  2567,
    2568,   864,   620,  1006,   998,   124,   125,   126,   623,   624,
     127,   959,   960,  2422,  2838,  3173,  3410,  3411,  3601,  3734,
    1000,  3607,  4030,  4156,  1001,  1002,  2867,  3609,  3858,  4032,
    4129,  1003,  2474,  3186,  3735,  3956,   111,   923,   569,  1371,
    1366,  1368,  1814,  2305,   112,   113
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3619
static const int yypact[] =
{
    5573,  2402,  1114, -3619,  -126,   200, 42458,   734,  -105,  -105,
     446,   952, -3619, -3619, -3619, -3619, -3619,  3313, -3619, 42458,
    1114, -3619, 23128, -3619, -3619,   756,   167,    68,  -105,  1114,
   -3619, 42458, -3619,   712,  1207,  1114, -3619, -3619, 37778, -3619,
     446, 42458, -3619,   837, -3619, 37778,   737,   897,   749,   972,
    1199, -3619, -3619, 42458,  1072,  -117,  1578,  1452, -3619, -3619,
    1231, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, 23717, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619,  1491, 42458,  1498, 42458, -3619,  1469,
   42458, 36023, 42458,  1157,  1523, -3619, -3619,  1574, -3619, -3619,
    -105,   446, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619,  1094, -3619, -3619,  1205,
   -3619, -3619, -3619, -3619, -3619,  1723,  1534, -3619,  1558, 36023,
   -3619, 42458, -3619, -3619, -3619,   855, -3619,  1245, -3619,  1246,
    1553,  1556,  1576,  1168, 11170,  1563,  1563,  1563, 42458,  1601,
    1563,  1563, 42458, -3619,  1563, -3619,  1563,  -105, -3619, -3619,
    3555, 42458,  1482,   803,   599, 36023,   174, 42458, -3619, -3619,
   11170, -3619,  1572, -3619, -3619, -3619,  -105,  1768,  1666,   226,
   42458, -3619, -3619,  -105,   198,    26,  1284, -3619, -3619,  1410,
   -3619,  3772,   142, -3619, -3619, -3619,  2441, -3619, -3619,  5697,
    1410, -3619, -3619, -3619,  1298, -3619, -3619, -3619, 42458,  -105,
    1602, -3619, -3619,   166,   166,   166, -3619,   166, -3619,   166,
   -3619,  -117,  1289, -3619, -3619,  1280, 42458,   661,   703, -3619,
   -3619,  1296,   -27, -3619,  1346, 33098, -3619, 42458, -3619, -3619,
   -3619, -3619,  1597, -3619, -3619, -3619,  1958, -3619, 23128, 42458,
    1424, -3619, -3619, -3619, 23128,  1308, 42458, -3619, 23128, 23128,
     246,    10,  1035, 42458, 42458,  1736, -3619,  1969, 33098,  1561,
   -3619,   425,   -69,  1574,  1966, -3619,  1534, -3619, 42458, 42458,
   42458, -3619, -3619, -3619, 38363,  1168,  1377,  1384,  1396, 15412,
   -3619,  1398,  1443,  1445, 11170,  1457,  1465,  1481,  1495,  1497,
    1502,  1510,  1514,  1516,  1516,  1518,  1529,  1538,  1564,  1090,
    1566, -3619,  1582,  1589,  1600, -3619, -3619,  1607,  1618,  1626,
   -3619,  1636,  1638,  1649, 11776,  1661,  1672, -3619, 20179,  1679,
    1685,  1696,  1699,  1703,  1705,  1707,  1710,  1716, -3619, -3619,
   11170,  1724, -3619, -3619,  1734, -3619,  1747,  1758,  1763,  1767,
    1770,  1772,  1784,  1790,  1792,  1795,  1799,  1815,  1819,  1823,
    1827,  1830, -3619,  1880,  1834,  1841,  1938,  1843, -3619,  1847,
   -3619,   225,  1850,  1516,  1516,  1516,  1876,  1878,  1882,  1885,
    1890, 15412, 15412, 15412, 11170, -3619, 42458, -3619, 42458,  1955,
    3294, -3619,  2244, 15412,   157, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619,  1477,  1488, -3619, -3619, -3619, -3619, -3619,  1893,
    1418,  1868, 42458, 42458, 42458,  1726, 42458, 42458, 36023,  1631,
   42458, 33098, -3619,  1563,  1575,  2532,  1761,  1725,  1925, -3619,
   -3619, -3619, -3619, -3619,  1803, -3619, -3619,  1695, -3619,  1831,
   -3619, -3619,   173, -3619,   101, -3619, -3619, -3619, -3619, -3619,
   -3619,  1993,  1584, -3619, -3619,   130, -3619, -3619, 42458, -3619,
   -3619, -3619, -3619,  2259,  2020,  1955,  2449,   210, 23128, -3619,
     877, -3619,  -193, -3619, -3619,  2238, -3619, -3619, 33098, 23128,
   -3619, -3619, -3619, 20768, -3619, -3619,  2458, -3619,  1908, -3619,
   -3619,  1488,  3421, -3619,  1761,  2161, -3619,  2177,  2092,    10,
    1990, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619,  1946,  2441, -3619, -3619, -3619, -3619,  2399, -3619,  2090,
     -22, -3619,  1947,  1982,   -22, 33683,  2300,   213, -3619,   346,
   -3619,  2380, -3619, -3619, -3619, -3619,  2076,  2059, -3619, -3619,
     374,  2354, -3619,  2417, -3619,    52, -3619,  2091,  2300,   -22,
     213, -3619,  2314,  2434,   471,  -180, -3619, -3619,   594, -3619,
   -3619,  2503, -3619, -3619, 23128, -3619, -3619,  2259, -3619, -3619,
   -3619,  1987, -3619,  2245,  2099, -3619, -3619,    66, -3619,  2008,
     755,  2519, -3619,   717, 34268, -3619, -3619, -3619,  2552,  2578,
    1516,  2085, -3619, -3619, -3619,  2692, -3619, -3619,  2104,  2597,
    2597,  2597,  2710, -3619, -3619, -3619, -3619, -3619,  2270,  2147,
   -3619,  1424, 23128,  2498,  2128, -3619, -3619,  2365, 11170, -3619,
   -3619,  4402,    71, -3619, -3619,   178, -3619,  2686,  2334, -3619,
   -3619, -3619, -3619,  2588, -3619, -3619,  2692,  2660,  2597,  2561,
    2175, -3619, -3619, -3619, -3619, -3619, -3619,  1340, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619,  1404, -3619, -3619, -3619, -3619,
   -3619,  1424, -3619, 23128, -3619, -3619, -3619, 23128, -3619,  2176,
   -3619,  2171, -3619, 11170, 11170,  1301,  2716,  2773,  2773,  2773,
    1955,  2212, 11170, 11170, 11170, 11170, 11170, 11170, 11170,  1319,
    2192, -3619, -3619,  8746, -3619,  2194, 11170, 11170,  2280, 11170,
    1488, 11170, 24306, -3619,  3097, 11170,   526,  2672, 11170, 11170,
   11170, 11170,  3547, 11170, 11170, 24306,  2796,  2204, -3619,  2199,
    1399, 11170, 11170,  1464, 11170, 11170, 11170, 11170, 11170, -3619,
    8746, -3619, 11170, 11170, 11170, 11170, 15412, 11170, 11170, 11170,
   11170, 11170, 11170,  2773,  2773, 11170, 11170,  1480,  8746, -3619,
   11170,  1488,  2391,  2391, 11170,  1488,  7534, 11170, -3619, -3619,
   -3619,  2207, -3619, -3619, -3619, 24306,  2773,  2773, 11170, 11170,
    2716,  2716,  2716,   239,  2208,   770, 11170, 25484,  2202, -3619,
   -3619, -3619, -3619, 11170, 11170, 11170, -3619, 15412, -3619, -3619,
    1895, -3619, -3619, -3619, 12382, 15412, 15412,  2213, 15412, 15412,
   15412, 15412, 15412,  2562, 15412, 15412, 16018, 16624, 15412, 15412,
   15412, 15412,  1125,  2716, 36023, 15412, 11170, -3619, -3619, 42458,
   -3619, -3619, -3619,  2210, 23128,  1631, -3619, -3619,   -76,  2673,
   -3619, -3619,  2218, 23128, -3619,  2215, -3619,  2564, -3619,  2565,
    2566,  2568, -3619, -3619, -3619, -3619,  2786,  2571, -3619, -3619,
    2581, -3619, -3619,  2242, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619,  2338, -3619, -3619, -3619,  2247, -3619, 33098,  2247, -3619,
   -3619,  2247, -3619, -3619,  2247,    47,  4576, -3619, -3619, 42458,
   -3619, 43043, -3619, 20768,  -126, -3619, -3619, -3619,  2595,   201,
    2252, -3619, 23128, -3619,    87,    87,  2488,   159, 36023, -3619,
   -3619,   187,  2254,  2335,  2261, -3619,  2340, 23128, 23128, -3619,
   -3619, -3619, -3619,  2851,    26, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,  2271,  2722,
    2275, 33098,   748, -3619, 42458, -3619,  1492, -3619, -3619, -3619,
    2277, -3619, 11170, -3619,  2279, -3619,   898,  2648, -3619,  -126,
   11170, -3619,  2287,  1534, 42458, 42458, 42458, 23128, 42458, 23128,
   -3619,   852,   852, -3619, 31343, -3619, -3619, -3619, -3619,   -22,
   42458, 42458,   -22, 33098, -3619,   213, 42458,   -22, -3619,  2654,
    2381, -3619, -3619, -3619,  2717, -3619, -3619,  2709,  2291, -3619,
    2648, -3619, -3619,   213, -3619, -3619, 23128, -3619, -3619,   213,
   -3619,   213,   213,   -22,   -22,  2342, -3619, -3619,  2294, -3619,
    2342,  2435, -3619,   586,   166,  2533, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619,   126, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619,   183, -3619, -3619, -3619,  1559,  2779,
   -3619, 36023,  1123,   -95,   843,  1123,  2248,  -126,   699, -3619,
     699, -3619,  4519,  2570,   209, 23128, -3619,  2304, 38948, 23128,
   -3619, -3619, -3619,   181,  2306,  2307,  1955,  2763,  2776,  2777,
    2780,  2781,  2789,  2790,  2792,  2794,  2799,  2802,  2807,  2808,
    2819,  2820,  2822,  2823,  2824,  2327, -3619, -3619, -3619, -3619,
   23128, -3619, -3619, -3619, -3619,  2421, -3619, -3619, -3619, -3619,
    2220, -3619, -3619, -3619,   217,  1362,  2394,  2420,   161, 33098,
    2809, 42458, 42458,  1534, 42458, 42458, -3619, -3619,   542,  2636,
    2637,  2649,  2398, -3619, -3619, -3619,   787, 42458,  2813, 27833,
   -3619,   307,   539, -3619,  2773,  2396, -3619,  2406,  2407,  2408,
   11170,    78,   164,  1082,  1038,  1070,  1102,   340,   231, -3619,
    2409,  2418, -3619,  1133, -3619,   356,   362,  1159,  1169,  2411,
    2422, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619,  2838, -3619,  1240, -3619, -3619, -3619, -3619,  2419, -3619,
   -3619,  1171,   366,   396,   271,  2425,   430,  1326,  1355,  2426,
   24306, 42458,  2773,  2427,  1191,  1213,  2773,  2428,   461,  1217,
    1423,  1449,  1451,  1222,  1232,  1239,   681,  1467,  2393,  1273,
     687,   764,   815,   825,  1277,  2429,  2430,   886,   276,  2773,
    2431,  1294,   278,  2436,  2439,  1320,  9352,  9958, 10564,  1037,
     904, -3619,  2447, -3619,  2199,  2450,  2452,   282,  1328, -3619,
   11170, -3619, -3619,   792,  1145,  2489,   206,  1086, -3619,  2583,
   42458,  2064,   150, -3619, -3619, -3619, -3619, -3619, -3619,   745,
   -3619,  2455, -3619,  2456,  1554,  2459, 11170,   859,  2459,  2628,
     850,   850, 15412,  2093,  2655, 11776,   324, 11776,   324,  2459,
    2459,  2459, -3619, 15412,  2460, 15412, 15412, -3619,  2716,  1955,
    2457,  1190, 42458, -3619,   -76, -3619, -3619, -3619, -3619,    93,
   33098,   100, 23128, 36023,  2448, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619,  3558, 23128, -3619, 42458, -3619,  2534, -3619,
   -3619, -3619, 21357, 21357, -3619, 21357, -3619, -3619,   360,   782,
    2783,  2483, -3619, -3619, -3619, 23128, -3619,  2847,   727, 23128,
    2304,  2464, -3619, -3619, -3619, -3619, -3619,  1835,  2569, -3619,
    3056, -3619, 11170,  -126, -3619, 33098, 33098, 23128, 23128,    46,
   -3619,  1253, -3619, -3619, -3619,  3421, 17230,  2877,  2890, 21357,
   21357, 21357, -3619, -3619, -3619, -3619, -3619,  1295,  1955, -3619,
    2463, -3619, -3619, -3619, -3619, -3619, 39533,   117, -3619, -3619,
    -126,  2892, -3619,  1955,  2473, 42458, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619,   679, -3619, -3619, -3619, -3619, -3619, -3619, -3619,   -22,
   -3619, -3619, -3619, -3619, -3619,  2689,  2300,  2354,  2892,   -22,
     213, 23128,   -22,   -22, -3619, -3619,  1922, -3619,   594, -3619,
   -3619, -3619, -3619, 42458,  1416,  2629, -3619,  2475, -3619, -3619,
   23128, -3619,  2479, -3619,  2905,  3042,  2300, -3619, -3619, -3619,
      93,    93,  2767, -3619,  -126,  2609,  2610,  2616,  2618,  2619,
    2658, -3619, -3619,  -126,  -126, -3619, -3619,    93, -3619,  1140,
   -3619, -3619, -3619, -3619,  -126,  -126,  -126,  -126,  2524,  -126,
    -126,  1504, -3619, -3619,    93,    93, -3619,   275, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619,   947, -3619,  1619,  3035,  2737,
      93,    93,  3035,    93,  2739,  2741,    93,    93,  2592,  2984,
      93,  2884,  2621,  3084,  2891,    93, -3619,  2623,  3000,    93,
      93,    93,    93,  3035,  2766,  3091,    93, -3619,    93,  2770,
    2784,   144,  2774,  2778,    93,   184, 42458,    93,  2787,    93,
   -3619, -3619,  4842, -3619, -3619, -3619, -3619, -3619, -3619,   730,
   21948, -3619, -3619,   462, -3619,  2735, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,  2551, -3619,
   -3619, 11170,  2558,  2524,  -126,  -126,  1521,  -126,  2524,  -126,
    -126,  -126,  -126,  -126,  2524,  2524,  -126,  1775,  -126,  2524,
    4402, -3619, -3619, -3619, -3619,   243,    93,    93,    93,    93,
   -3619,  1915, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   36023,  2899,   234,   -67, 36023, -3619, 42458, -3619,  1173, 42458,
    2567,   522,  3427,   827,   827, -3619, 23128, 23128, 23128, 42458,
    2593,  2483, 27833, -3619, -3619,   586, -3619,  2560, 12988, -3619,
    2574, -3619, 11170, -3619, -3619, -3619,  1108, 11170, 11170,  3022,
    1670, -3619, 34853, -3619, -3619, -3619, 11170, 34853,  1670, 11170,
   -3619,  2575, -3619,  2946,  2948, -3619, -3619, -3619, -3619, 11170,
   -3619, 11170, 11170, -3619, 11170, 11170, 11170, 11170, 11170, -3619,
   -3619, 15412, -3619,  2580,  2576, -3619, -3619, -3619,  2577, -3619,
   11170, -3619, -3619, -3619, -3619, -3619, -3619, -3619, 11170, -3619,
   11170, -3619, 11170, 11170, 11170, 11170, -3619, -3619, -3619, 13594,
   11170, 11170,  2590, -3619, -3619, -3619, 11170, 11170, 11170, -3619,
   11170,  1711, 11170,  1852, 11170,  2004, 11170, -3619, 11170, -3619,
   -3619, -3619, -3619, 11170, -3619,  1507, -3619, -3619,  2151, -3619,
     792,  2591, -3619, -3619,  1492, -3619, -3619,  2582,  2585,  2594,
   36023, 11170, -3619, -3619, -3619, -3619, -3619, -3619, 15412,   302,
    2600, 15412, -3619,  2628,  3547,  3547,  1870, 11170,   859,  2628,
   11170,  2602,  2587, -3619, 11170, 42458, -3619, -3619, -3619, -3619,
   -3619, -3619, 36023, -3619, -3619, -3619, -3619,   100, -3619,  2215,
   -3619,  2304, -3619, -3619,  1539, -3619, 33098,  2596, -3619,  2604,
    2683,  2687,  2688, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619,  2300,  1253, -3619,  2611, -3619,
   -3619,  2365,  2700,  2644,  2973, -3619, -3619, -3619, 42458, 15412,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,  3187,
    2632,  2633,  3085,  2638,  1955, -3619,  2712, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619,   109, -3619, -3619,  2641,  2641,
   18999, -3619, -3619, -3619,  3086,   608,   608,   608, -3619, -3619,
   -3619, -3619,  2886, 33098,  3062,  3064,  3066,   717, -3619,   659,
   -3619,   205,  3029,  2300, -3619,  3067, 36608, -3619, 28418, -3619,
    2650,  3027,  2652,    93, 30758,   794, 26072, 31928, -3619, -3619,
    1521, -3619,    76, -3619, 31343, 31343, -3619,  2923, -3619, -3619,
   -3619, -3619,  2483,   213, -3619, -3619, -3619,  2662, -3619, -3619,
     798,  3030,  3034, -3619,  2913,  1110,  2913,   798,   798, 24306,
     586,  2077, -3619,  2524,  2967, -3619, -3619, -3619, 35438, 32513,
   -3619, -3619, -3619, -3619,  3171, -3619,  3172,   884, -3619, -3619,
    2387,   843, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619,  2248,  2387,  2387,
     699, -3619,   127, -3619, -3619, -3619, -3619, -3619, 24895,  1114,
   -3619,   135, -3619, 24895, -3619,   181,   181, -3619, 24895,  1114,
    1521,  2524, 24895,  2524, 40118,  1114,  -126,  -126,  2155,    93,
    2524, -3619, -3619,  3038, 42458,  3039, 24895, 24895, -3619, 36023,
   -3619,    93,   140,  2524,  1521,  1521, 24895,  1114, 24306,  1211,
   -3619,  -126,  1114, -3619, -3619, -3619, -3619, 23128,  1114,  1114,
    2395, -3619, -3619, -3619,  2524, 40118, -3619, -3619,  6151, -3619,
   -3619, -3619, 18410, 42458,   939,   482, -3619,  2670,    50,  1045,
    2753,  1194,  2681,  2684, 40703,  1955,  2524, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
    -126,  1835,  2387,  2387,  1362, -3619,  2938,  3100,    93, -3619,
     822, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
    2782, -3619,  3267,  2865,  2694, -3619, -3619,   229, -3619, -3619,
     993, 23128, 17821, -3619,  2929, -3619,  2653, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619,  2703,   586,  2958,  1285,
    2483,  2718, -3619, 11776,  1363, -3619,  1955, 11170,  1955,  1543,
   -3619,  2714,  2714, -3619, -3619,  2720,  2714,  3090, -3619,  3099,
    2727, -3619,  2733, -3619,  1373,  2736,  2738,  1477, -3619, 11170,
   11170,  1392,  1426,   -94,   916,   926,   311, -3619,  1428,  2589,
   -3619, -3619,  1471,  1479,  1524,  1526,   963,  1532,  1630, 11776,
    1541,  1069,   378, -3619,  1570,   994,   999,  1586, 11170,  1590,
   11170,  1598, 11170,  1605,  1629,  1646, -3619,  1946,  2151, -3619,
   -3619,  2744, -3619, -3619, -3619, -3619, -3619,  2732,  1955,  2750,
   -3619, -3619, 11170, -3619,   157, -3619, -3619, 15412,   387,  2752,
   -3619,  1955, -3619, -3619,  2764,  1477, -3619, -3619, -3619, -3619,
   -3619,  2788, -3619, 42458,   489,  2747, 29003, 33098, 33098, 33098,
    2771, 11170, -3619, -3619,  2972, 23128, -3619,  3162, -3619, -3619,
   -3619, -3619,  2785,  2772, -3619, -3619, -3619,  2628,  3123,  3009,
   -3619, -3619,  1835, 42458, 33098, -3619,  2441, 24306, -3619,  2791,
   -3619,  2791,  1676,  2795,  1641, -3619, -3619, -3619,  2775,  1990,
   17230,  3200,  2175, 33098, 33098, 33098, -3619,  2483,  2483,   137,
    2828,  3154, -3619, -3619, -3619, -3619, 41288, -3619, -3619, -3619,
   -3619,  1229, 42458,  3136, 42458,  8140, -3619, -3619,  3319, 11170,
   33098,   833,  1086,    93, -3619, -3619, -3619, -3619, -3619, -3619,
    2300, -3619, -3619, -3619, -3619, -3619,  2300, -3619,   -22,  1922,
    -161,  1145, -3619,  2200, -3619, -3619, -3619,  3152,   798,  2913,
    2913,  3153,  3044,   736,  2793, -3619,    93, -3619, -3619, -3619,
    2441, -3619, -3619, 11170, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619,   947, -3619, -3619, -3619, -3619,  2810,  3170,  3174,   181,
   -3619, 24895, -3619, -3619, 24895, 24895,   125, 40118, -3619, -3619,
   -3619, -3619, -3619, -3619,  2812, -3619, -3619,  1835, -3619, -3619,
   32513,  -126, -3619, 24895,  2812, -3619, -3619,   199, -3619,  -126,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, 40118,  2832,
   -3619,  1047, -3619, -3619,  1768, -3619, 40118, -3619, -3619, 40118,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,  2815,
    2344,  2048, -3619,  2834,  2837, -3619, -3619, -3619, -3619, 42458,
   -3619, -3619, 23128, -3619, -3619, -3619,  4522, 42458,  3013, -3619,
   11170, 11170,  3080, 42458,  3095, -3619,  3365, 42458,  3426, 40118,
   -3619,  2842, -3619,  2844, -3619,  1663, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619,  2848, 42458,  2387,   234, -3619, -3619,  -126,
     993, -3619, -3619, -3619, -3619,  3102,  3109, 42458, -3619, -3619,
   -3619, -3619,  2987, -3619, 23128,  3413, -3619,  3014, -3619,  2857,
     221,  4158, -3619,  2860,  2861,  2863, 27833,  2483,  3216, -3619,
   -3619,  3547, -3619,  1955, 11170,   834, -3619, -3619,   193,   870,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619,  2867,  3547,  3547, -3619, -3619,  3025, -3619, 11170, 11170,
   -3619, 11170, -3619,   883,  2868,  2901, -3619, -3619, -3619, -3619,
   11170, -3619, -3619,  3547, -3619, 11170, -3619, -3619, 11170, -3619,
   11170, 11170, -3619,  1650, -3619,  1717, -3619,  1738, -3619, -3619,
   -3619,  2277, -3619, -3619,   770, 42458, -3619, -3619,  1669, -3619,
   -3619, 11170, -3619, 36608, -3619, -3619,  3093, -3619, -3619,  3290,
   -3619, -3619, -3619,  -123,  -123,  -123, 14200,  1955,  3344, -3619,
   -3619, -3619,  3162,  3242, -3619,   132, -3619, 42458,  2893,   182,
   -3619,  1681, -3619, -3619,  2894, -3619,  1946,  2895, -3619,    93,
   14200,  2641,  3014, -3619, -3619,  1676, 24306, 28418, -3619, -3619,
   33098,  2175,  2175,  2175,  2300,  3300,  2700,  2700, -3619, 26660,
   -3619, -3619,  3046, -3619, -3619, 29588, -3619,   -32, -3619, -3619,
   15412,  1582, -3619,  1955, -3619, 35438, -3619,  1955,    93,  2907,
    2908, -3619, -3619, 41873, 11170, -3619, -3619, -3619, -3619,  1492,
    3495, -3619,   586, -3619,   798, -3619,  3264,  3274,   798, -3619,
   -3619, -3619, 24306,  2483, 14200, -3619,    51,  1946,  1955,  2910,
    1047, -3619,   -86, 11170, 24895, -3619, -3619, -3619,  2914, -3619,
   -3619,  3393,  3396, -3619, 24895,  2220, 42458, -3619,  3319, -3619,
   -3619, -3619, -3619,  4522, -3619, 24306, -3619, -3619, -3619, -3619,
   -3619, 42458, -3619, 23128, -3619, 18410, -3619,  2915, -3619,  2714,
    2714,  2714, -3619, -3619, -3619, -3619, -3619,  2720,  3139, -3619,
    2720,  2720, -3619, -3619, -3619, -3619, -3619,   193,  1749, -3619,
   -3619,   193, -3619, -3619, -3619,   147,   945,  2720, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619,  2714, -3619, -3619, -3619, -3619,
     193,  2714, -3619,  2714,  2103, -3619,   291,   111,  2714,  2714,
    2714,  2917,  2912, -3619,  1955,  3547,  3446, -3619, -3619,  3059,
    -126,  3390, -3619,  1688, -3619,  2928, -3619, 40703, -3619,  2524,
    2248, -3619, -3619, -3619, -3619,  3065,   828, -3619,  3098,  2936,
    2941, -3619, -3619,  -126,  2945,  2949,  4842, -3619, -3619, -3619,
    3533, -3619, 42458, 42458, 42458,  2560, -3619, 31343, -3619,  1027,
    1955,  2950,  2952,  2953,  2954,  3525,   165, -3619,  3526, 34853,
   -3619, -3619, -3619,  1718, -3619,  2957,  2961,   166,  2966,  1748,
    1006,  1720,  3249,  3328, -3619,  3178, -3619,  1807,  1103,  1825,
    1888,  1904,  1924, -3619, -3619, -3619,  1219,  1145, -3619, -3619,
    1731, -3619,  3310,  3220,   195,  2995,  2995,  2995,  1582,  1955,
    1742, -3619, -3619, -3619, -3619,  3351, -3619, -3619,  2978,  3056,
   42458, -3619,  3009, -3619,  2277, 24306, 14200,  2979,  2977, -3619,
     755, -3619, -3619,  2974,  2175, -3619,  3537,  3386, -3619, -3619,
   36023,  2982, -3619, -3619,  3275, -3619,   263,  3190, -3619, -3619,
   -3619,   833,  3071,  3074,    93,  1955, -3619, -3619,  2475,  2798,
    3032,   798,   798,  3306,  3033, 11170, 11170,  2993, -3619,  2958,
   -3619, -3619,   352,  2277, 11170, -3619,  1835,  3009, -3619,  1931,
    2994,  2996, 42458,  2997,  3001, -3619,  2933,   939, -3619, -3619,
   -3619,  2103,  1114, -3619, -3619,  2812,   109,  2999, -3619, 42458,
    3308, -3619, -3619, -3619,  1218, -3619,  3002,  1218,  1218, -3619,
    2090, -3619,  3036,   193, -3619, -3619,  3037, -3619, -3619, -3619,
    1218,  3004,   193, -3619, -3619,  1218, -3619, 36023,  -126,  2624,
   -3619,  3054, -3619,  3491,  3371, -3619,  2103, -3619,  3376,  3276,
   -3619,   193, -3619, -3619,  3585, -3619,   193,  3585,  1218,  3277,
   -3619,  1218, 42458, -3619, -3619, -3619, -3619, -3619, -3619, 42458,
   -3619,   819, -3619, -3619, -3619,  1760,  -126, -3619, -3619, -3619,
    3017,  3018, -3619, -3619, -3619,  1045, -3619, 42458,  4522, -3619,
   -3619, -3619,  2929, -3619,   919,  1800,  1047,  3019,  1808,  1855,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, 34853,
   -3619,  3585,  3282, -3619, -3619, -3619, -3619, -3619, 11170, -3619,
   -3619,  3314,  3461, -3619, -3619, -3619, -3619, -3619, -3619,   205,
     205, -3619, -3619, -3619, -3619, -3619,  3110,  3111, -3619, -3619,
    3112, -3619, -3619,   129,  2088, -3619, -3619, -3619, -3619, 14200,
    3387,  3120, -3619, -3619,  3031,  3069, -3619, -3619,  1219, -3619,
   -3619, -3619, -3619, 11170, -3619,  2958,  2155, -3619, 26660, -3619,
   -3619, -3619, -3619, -3619,  3043,  3045,  8140,   770, -3619,  3075,
   -3619, -3619, -3619,  3076,  1955,  1955, 42458,  3216, -3619, -3619,
     181,   181, -3619,   352,  1219,  1047, -3619,  1896, -3619, 42458,
   42458,  1913, 42458, 42458,   608,   608,   608,  1775,  1775, -3619,
   -3619, -3619, -3619, -3619,  3408, -3619, -3619,  1927, -3619,    70,
    3291, -3619, -3619, -3619, -3619,  1218, -3619,   166, -3619, -3619,
   -3619, -3619, -3619,   166, -3619, -3619, -3619, -3619,  1516, -3619,
   -3619,  3303,  3079, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619,  3048, -3619, -3619,  3166, -3619, 48308, -3619, -3619,
    -117,  3061, -3619, -3619, -3619,  1395, 42458, 23128,  3080,  3225,
   -3619,  3319, -3619,   755,   221,  3014, -3619,   145, 42458, -3619,
    3320,   169,   211, -3619, -3619,  3053,  1953, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619,   385,  3311,  2524,  2524,  2524,
    2524,  2088, -3619, -3619,  3108, 23128, 15412,  3168, 42458,  1335,
    2445, -3619,  1361,  1047, 11170,  2300, 32513, -3619, -3619, -3619,
   -3619, -3619, -3619, 11170,  3068, 11170,  3070,  1933, -3619, -3619,
    3489,  3489, -3619, -3619, -3619, -3619,  1960,  1967,   145,  2014,
    2038, -3619, -3619,   939,  3072, -3619, 42458, -3619, -3619, -3619,
     245, -3619, -3619,  2060, -3619,  2066, -3619,  1516, -3619, 11170,
    3524,  3104, 42458,   814, -3619, 49478, 49478, 42458, -3619, -3619,
   -3619, -3619,  5102, -3619, -3619,    36, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619,  3646, -3619,  3088,
   -3619, -3619,  3083,   938, -3619, -3619, -3619,  4522,  3497,  1194,
   -3619, -3619, -3619, -3619, -3619,  3087,  1990,  -126,    93, -3619,
     145, -3619, -3619, -3619,  1047,  3092,  3316, -3619,   169, -3619,
   -3619, -3619,   211, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, 24306, -3619, -3619,  1835, -3619,  2073,
   -3619, -3619, -3619,  3177,    93,  3572,  3574,    93,    93,    93,
      93,  3105,  2445, -3619,  3554, -3619, -3619, 11170, -3619, -3619,
    1955,  3321, -3619,  3639,  1145,  1955, 42458,  1955, 42458, -3619,
   42458,  1382, -3619, -3619,  3304,   145, -3619,   169,   211, -3619,
    3009, -3619,   840,   840,   193,   166,   193, -3619,  1955, 11170,
   -3619, 11170,  3134, -3619, -3619,  3531, 42458, -3619, -3619, -3619,
   -3619, 11170, -3619, 48308, 48308, -3619, -3619, -3619, -3619,  3687,
     755,  3657,  3367,  3660,  2803, -3619, -3619,  3365,  4522, -3619,
   -3619, -3619,  2524, -3619, -3619, -3619,  1204, -3619, -3619,  3119,
   -3619,    93,  2155,  3121, -3619, -3619, 42458,  3124, -3619,  -126,
      93,    93,  1989,  1989,  1835, 36023,  3227, -3619, -3619,    93,
    1047, 42458, -3619,   915,  3474, -3619,  2101,  2106, -3619,  3684,
   -3619,  3685,  3131,  3132, -3619, -3619, -3619, -3619,  2120, -3619,
    3733, -3619,   858,  3394,  3397, -3619, -3619, -3619,  1955,  1955,
   -3619,   222, -3619, -3619,  3519,  3603, 11170,  1955, 45383,  3142,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, 48893, 11170, -3619,    36,  3646, -3619,  3398,
   -3619,  3403, -3619, -3619, -3619,  3631, 48308, -3619,  3624, -3619,
     755, -3619, -3619, 24306, 14200, -3619, -3619,  3168, -3619,  3158,
   -3619, -3619,   -54, -3619,  -126,  -126, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619,  2127, -3619, 36023, -3619, -3619,
    3715,  3717,  3620,  3721,   915, -3619,  1092, -3619, -3619, -3619,
   -3619, -3619, 40703, 40703, -3619, -3619, -3619, -3619,  3214,  3647,
    3194, 11170, 48308, -3619,  3627, -3619,  3562,  2061,  3506,  3169,
   -3619,  3175,  2035,  3661, 49478, 49478, -3619, -3619, -3619, -3619,
    3640, -3619, -3619, -3619, -3619, -3619,  3343, -3619, -3619,  2135,
   -3619, 14806, -3619, -3619, -3619, -3619, -3619, 36023, -3619,  3227,
   -3619,  3180,   166,   166,  3737,   166, -3619,  3741,  3742,  1092,
   -3619,  3186,  2140,   840,   840, -3619,   268, -3619,  1955, 45968,
    3739, 42458, -3619, -3619, -3619, -3619, 11170, -3619, 37193, 46553,
    3184, -3619, -3619, -3619,  3354, -3619,  2803,  3584,  3639, -3619,
    3158, -3619,  3191, -3619,  2628,  2445, -3619, -3619,  3193, -3619,
   -3619,   166, -3619,   166,   166, -3619, -3619, -3619, -3619, -3619,
   11170, -3619,  3651,  3278, -3619,  3199, -3619, 48308,   439, 48308,
   -3619, -3619,  3608,  3202,   310, -3619,  3201, -3619, -3619, 48308,
    3761,  3474, -3619, 14806,  3205, -3619, 11170,  3207,  3208, -3619,
   -3619, -3619, -3619,  1955,  3759, 48308, 42458, 43628,  3395, 47138,
    3633, 42458,  4522,  3634,  3636, -3619, 48308, -3619,   166,  3605,
   -3619, -3619,  1955, -3619, -3619,  3298, -3619, 44213, -3619,  2465,
   -3619,  3245, -3619, -3619,  3702,  2310, -3619, -3619, -3619,  3483,
    3224, -3619, -3619, 48308, 48308, -3619, -3619, -3619, 30173, 11170,
   -3619, -3619, -3619, -3619, -3619,   717,    33, 19588,  3372, 44798,
   47723, -3619, -3619, -3619, 27248, -3619, -3619, -3619,  3648, -3619,
    1955, -3619, -3619, -3619, -3619, -3619, 36023,  2149, -3619, -3619,
   24306, -3619, 30173, -3619, -3619, -3619, -3619, 22537,  3228, -3619,
      93, -3619, -3619, 24306, -3619, -3619, 14200, -3619, -3619
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3619, -3619, -3619, -3619, -3619,   119, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619,  1674, -3619, -3619, -3619, -3619, -3619,
    1874, -3619,   657, -1686, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619,   658,  1500,  3217, -3619,   415, -3619,   102, -3619,
   -3619, -3619, -2735,   -14,  -186, -3619, -3619,   293,    20,  2900,
    -184, -3548, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619,   426,   423, -3619, -3619,   248, -3619, -3619, -1246, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619,  -365,  -317,  1692,
   -3619, -3619, -3619,  3814, -3619,  3317, -3619,  1223,  2143, -3619,
   -3619, -3619,  -464,   272, -3619,   280, -3619,   284, -3619,   285,
   -3619,   286,   287,   290,   292, -3619,   294, -3619, -3619,  -313,
   -3619, -3619, -3619, -3619,   296, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619,  -191, -3619, -3619,   -45, -3619, -3619,  -178,   297,
   -3619,  -135,   299, -3619,   300, -3619,   -55, -3619,   -48, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619,  2918, -3619, -3619, -3619, -1894, -3619, -3619, -2226,  2499,
   -3619, -1687, -3619, -3619, -1776, -3619, -3619, -1518,   817, -3619,
   -3619,  1186,  -305, -3619, -1319, -1784, -1780, -3619, -3619, -3619,
   -1869, -1839,  -747,  2249, -1121, -2111, -3619, -3619, -3619,   298,
   -3619, -3619, -2401,  1988,  2508, -3619,  2491, -3619, -3619,  1119,
   -3619, -3619,  1286,   646,  1283, -3619,   935,  2678, -1168, -3619,
   -3619, -3619, -3619, -3619, -3619,    48,   281,   -42, -3619, -3110,
     654, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3618,
   -3619, -3619, -3619,  -204, -3619, -3619,  -119, -3619, -3619,  -163,
   -3619,   151, -2176, -3619, -3619, -3619, -3619,  2480, -1238, -3619,
    3457, -3619,  -498,   751,  2036, -2272, -1334, -3619,  -871,  -858,
   -2328, -3619, -3619, -3619, -3101,  1089,  1470, -3619,   848,  2034,
   -1783, -3619,  1540, -3619, -3619,   872, -3619, -2561, -3619, -3619,
   -3619,   830, -3619,   831, -3619, -3619, -3619, -1260,   799,  -240,
   -3619,   397, -2303, -2382, -3619,   622, -3619,   579, -3498, -3619,
    -544, -1966, -2247,    96, -3619, -3619,   593, -2934,   936, -3619,
   -3619, -3619, -2967, -1885, -3619,   158, -3619, -3619, -3619, -3619,
   -3557, -3619, -3619, -1393, -1897, -3619, -3619,  3962,  3963,  -979,
   -2511, -2677,   162,   170, -3619, -3619, -3619,  2507, -1016,   228,
     218,   224,  1991,  -251,   365, -2204, -3619,   414, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619,  2074,  -872, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -2262,   908, -3619, -3619,  1591, -3619, -3619,
   -3619, -1741,   274, -2025, -2800, -3619, -3619, -3619, -3619, -3619,
   -3619,  1402, -3619, -3619,  2203,  2640, -3619, -3619, -3619, -3619,
   -3619, -3619,   652,  1778, -3619, -3619, -3619, -3619, -3619, -3619,
     920,  2554, -3619, -3619, -3619,   -11, -3619, -3619, -3619, -3619,
    2289, -3619, -3619, -3619, -3619,  2598, -3619, -3619, -3619, -3619,
   -3619, -3619,  1393, -3619,  1818, -3619, -1359, -3619, -3619,  1028,
    -925,  1764,  -564,  1902,   418, -3619,  3443, -3619, -3619, -3619,
   -1550, -1568, -3619,  3156,  -713, -2317,  2278,  -620, -1728,  1056,
    -605,  3416, -3619, -1084, -1056, -3619, -3619,  -609, -3619, -3619,
   -3619,  -608, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619,  1427, -3619, -3619, -3619, -3619, -1638, -3619,
   -3619, -3619, -3619, -3619,  1519, -3619,  1994, -3619,  -460, -3619,
    2956, -3619, -3619, -3619, -2151, -1724,  1727,   973, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -2221, -3619, -3619,
   -3619, -3619, -3619,  1917, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -1602, -3619, -1833,   357, -3619,   497, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619,    29,   856,    32, -2091, -1039,  1657,
   -3619, -3619, -1196,  2998, -1923, -3619, -3619, -3619,  1894, -3619,
   -3619, -3619, -3619, -3619,   941, -2427, -1313, -3619, -3619, -2953,
    -843, -2127,  -832, -3619, -2167,   511, -1615, -1679,  -298,   156,
   -1120, -3619, -3619, -3619, -3619, -3619,  -124, -3619, -3619, -3619,
     534,  1791, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619,  -535,  -670, -3619,  2046,  1715, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619,  2814,  2797,  1860, -3619,
   -3619, -2404, -3619, -3619,  1820, -3619,   775, -2223, -1699,  1050,
   -3619, -3619,  1052, -3005, -3619, -3619, -3619, -3619, -3619, -3619,
     991, -3619,    91,  3498, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619,  2584, -1002,  3422, -3619, -3619, -3619, -3619, -3619, -3619,
    2281, -3619, -3619, -3619, -3619, -3619, -3619,  2754,  3515,  -545,
   -1184, -3619,  -700,  2729,  2282,  -853, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,  2401,
     964, -3619, -3619, -3619,  2816, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
   -3619, -3619,  1091,   -17, -3619,    83,   -53, -3619,    22, -3619,
   -3619, -3619, -3619, -3619,  -148, -3619, -3619,  -151,  -644,  -928,
   -1281,   704, -1681, -1909,  1078,  2800, -3004,  -651, -1077, -1101,
   -1841,    60, -3619, -3619,  2274,    88,   279,  -247,    -6, -2642,
    -109,  -556, -3619, -2649, -3619, -3619, -3619, -3619,  2345, -3619,
   -3619, -3619, -3619,  1403, -3619, -3619, -3619,  1044, -3619,   788,
     575, -3619, -3619,   160, -3619,  2397, -3619, -3619, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
    2811,  3553,  3251, -3619,  2871, -3619, -3619, -3619, -3619, -3619,
     465, -3619,   891, -3619, -1963,  2642,   609, -3619,  1501,  -201,
    -480, -3619, -3619,   464, -3619, -3619,  1292,  3566,  3260, -3619,
   -3619, -3619, -3619, -3619, -2584,  -840, -3619, -3151, -2637, -1587,
   -3619, -3619, -2023, -2770, -3619, -3619,  -983, -3619, -3619, -3619,
   -3619, -1747, -3619, -3619, -3619,   152,  3626,  3628, -3619, -3619,
    -122, -3619,   295, -3619, -3619, -3619, -3619, -3619, -3619, -3619,
    3492, -3619, -3619, -3619, -3619,  3493, -3619, -3619, -3619, -3619,
   -3619,  3494, -3619, -3619, -3619, -3619, -3619,  1248, -3619, -3619,
   -3619, -3619, -3619, -3619, -3619, -3619
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2438
static const yytype_int16 yytable[] =
{
     466,   997,  1005,   983,   903,   899,  1381,   929,  1379,   509,
    1288,  2257,   592,   508,  1593,  1050,   514,  2113,   526,  1480,
    1938,  1310,  1178,  1545,   533,   528,   464,  1068,  2206,   942,
    1568,  1026,   540,  1772,   752,   543,  1470,  1471,  1592,   540,
    2675,  2679,  2681,  1698,  1316,  2240,  1345,   561,  2446,  1042,
    1044,  2778,  1935,  1614,  2643,  1344,  2522,  1658,  2612,  3320,
    1622,  2525,  2728,  1816,  3051,  3008,  1316,  1386,  1912,  1101,
    1510,  2888,  1105,   972,   975,  1841,  2712,  1706,  2498,  2416,
    1387,  2345,   512,  2880,  2350,  2346,  1081,   581,  2239,  1624,
    1625,  2573,   133,  1628,  1629,  1630,  1631,  3167,  1633,  1634,
    1636,  1638,  1639,  1640,  1641,  1642,  1099,  2693,  2694,   584,
    2286,   466,  2774,  2466,   466,   591,   597,  3325,  1112,  1113,
    1114,  2308,  2309,  1120,  1121,  1122,  2664,  2358,  1013,  3502,
    2898,  2362,  2599,  1162,  2903,  1163,  1973,   586,  2320,  2703,
     588,  1779,  2377,  2467,  3393,  3634,  1819,  2713,  1227,  2752,
    2154,  1854,  2386,   580,  3340,  2338,  2339,  1701,   610,  1789,
    3359,  3364,  2394,  1259,  3365,  1129,  1130,  1792,  1793,   473,
    2341,  2360,  2361,   521,  2363,   868,   869,  2366,  2367,  1129,
    1130,  2370,  2020,  3373,  3247,  3447,  2379,  2252,   525,  3392,
    2382,  2383,  2384,  2385,   532,  2455,  2746,  2389,  2463,  2391,
    1346,   918,  2464,  2604,  1222,  2400,  3366,  1983,  2404,  2302,
    2406,  2220,  2902,  3215,  2882,  1181,  1712,  3537,  3747,  1227,
    2017,  1129,  1130,   868,   869,  1164,  3216,  2738,  2739, -1361,
    1299,  2691,  1682,  2333,  2857,  1442,  1438,  1219,  3003,  3855,
    3217,  3078,  3747,  4042,  1362,  2149,  1129,  1130,   518,  2154,
    2951,   868,   869,  3687,  1129,  1130,  1341,  3476,  1854,   823,
    1108,  3081,  1815,  1655, -1361,  3154,  3914,  2450,  2451,  2452,
    2453,  3500,  1253,  1843,  2220,  3016,   935, -2321, -1401,   601,
    2652,  2500,  1228,  3326,  3747,   522,  1129,  1130,  4212,  1236,
     602,  1129,  1130,  1129,  1130,   810,  2395,  1129,  1130,  1854,
    3254,   976,  1383,  1369,  2470,  3843,  3953,  1966,  1833,   986,
    1353,  3215,   835,  2780,  2747,  2401,   994,  1129,  1130,   831,
    3535,  2322,  1129,  1130,  3216,   132,  1129,  1130,  2427,  1926,
     570,  -823,   541,  2437,  1979,  1390,  1383,  3510,  3217,  2443,
    2444,  2850,  2851,  1443,  2448,  3197,  1837,  1444,   978,   868,
     869,  4040,  2862,  1228,  4044,  1129,  1130,  1709,  1445,  2697,
    3959,  2569,  1383,   625,  4012,  -525,  3296,   919,  3822,  -430,
     615,  1129,  1130,  1460,  1461,  1462,   811,  1129,  1130,  1314,
    3268,  1129,  1130,  2781,  3748,  2660,  2828,  3297,  3049,  1354,
    4153,  -526,   132,  1129,  1130,  1317,  3570,  3651,  1936,  1710,
    2458,  1509,  1129,  1130,   470,  3574,   809,   471,  3748,  4154,
    4012,  1129,  1130,  1321,  1068,   958,  1248,   134,  3298,   836,
    1855,  1937,  3269,   979,  3587, -1671,  1109,  1407,  1654,  3589,
    3477,  2829,  1683,  3673,  3197,   993,  1812,  3688,  1927,  2264,
    2221,  1326,  3050,  1318,   812,  1129,  1130,  3476,  2742,  1834,
    3748,  2471,  2863,  1837,  1129,  1130,  3844,  1146,  2080,  2755,
    3044,  1175,  3743,  2711,   995,  1439,  1774,  2661,   832,  1777,
    4213, -1401,  4132,   591,  1781,   597,  1129,  1130,  2782,  1446,
    1237,  1459,  1815,  3619,  3643,   571,  2402,  3055,  2265,   936,
    2376,   837,   765,  3064,  1837,  1370,   597,  3017,  1656,  3653,
    1794,  1795,  1012,  2221, -2437,   804,  4108,  4109, -2252,   591,
    1166,   814,   824,  1386,  1165,   937,  3327,  2756,  2748,  1131,
    1841,  2760,  1132,  3088,   827,  2658,  1387,  1855,  2155,  3478,
    3528,  1619,  3341,  1658,  3689,  2776,  2777,  3551,  3953,  2418,
    1627,  1349,  1342,  2746,  1817,  2787,  2344,  3077,  4038,  2150,
    3079,  3080,   915,  3198,  1129,  1130,  1300,  1648,  2345,  1684,
     519,  1131,  2346,  1259,  1132,  3529,  3331,  1967,  1855,  3090,
     932,  2416,  1447,  1655,  1494,  1495,  2133,  2890,  1912,   591,
    3082,   946,  3674,  1386,   977,  4148,  1131,  2136,  1259,  1132,
    2139,  2466,   581,   466,  1131,  1533,  1387,  1132,   581, -1401,
     970,  3281,   581,   581,  1547,  2222,  2282,   984,   946,  3201,
    3472, -1361,   591, -2252,  1655,  3845,  1560,  1561,  1562,   957,
    3477,  2467,  1014,  1015,  1016,  1567,  1131,  2155,  1021,  1132,
    3183,  1131,  1534,  1131,  1132,  1535,  1132,  1131,  1220,  1149,
    1132,  2416,  3198,  2130,  2973,  2974,  2975,  1842,  1661,  1791,
    1440,  2692,  1973,  2740,  4174,  2018,   523,  1131,   956,  1177,
    1132,  1678,  1131,  2462,   967,  1132,  1131,   773,  2222,  1132,
    2771,   848,  1069,  2396,  1223,  1440,  2463,  3742,  2852,  3274,
    2464,  3479,  2779,  1993,   920,  2749,   819,  2702,  2721,  1702,
    3011,  3012,  3013,   830,  3480,  1131,  1129,  1130,  1132,  3948,
    3799,  3195,  1129,  1130,  1440,  2665,  1994,  1700,  1978, -2321,
    3908,  1131,  3448,  2895,  1132,  3367,  1713,  1131,  1843,   916,
    1132,  1131,  1719,  1854,  1132,  1728,  2266,  1819,   896,  3353,
    1126,  2741,  1128,  1131,  3014,  3015,  1132, -2321, -1401,  1133,
    3218,  1984,  1131,  1110,  3182,  1132,  2759,  3662,  2761,  3756,
    3323,  1131,  3091,  1133,  1132,  2772,  1171,   466,  1173,  2855,
     946,   466,   591,  3372,   466,   591,  1313,  1778,  2784,   896,
    1961,  3375,  2849,  2887,  2793,  1011,  3276,   618,  3398,  1129,
    1130,  3481,  1440,  1172,  2864,  1131, -1401,  1176,  1132,  2807,
    1180,  -823,  2027,  3890,  1131,  1133,  2657,  1132,   771,  3920,
    3823,  3864,  1232,  2736,  3511,  1755,  3351,  3352,  1656,  4033,
     994,  2847,   581,  2116,  2902,  3301,  1131,  2902,  2902,  1132,
    1133,  2952,   591,   581,   828,  -525,  2643,   581,  1133,  -430,
    1129,  1130,  2617,  3310,  2902,  2028,  1322,  3314,  3218,  3345,
    1129,  1130,  1599,  1600,  1821,  4065,  1854,  3071,  3374,  1656,
    1979,  -526,  3076,  3391,  3394,  3396,  3397,  3915,  1350,  3917,
    1133,  2469,  3390,  2963,  1327,  1133,   114,  1133,   806,   591,
    3330,  1133,  2487,  3740,  1599,  2046,  3056,  3057,  1239,  2340,
    2081,  2085,  2086,  3819,  3480,  2102,  2103,  3285,  2822,  1256,
    3909,  1133,  3527,  2895,  1131,  1966,  1133,  1132,  2988,  2052,
    1133,  1129,  1130,  3309,  2419,  2581,  2582,  3313,   581,   958,
    1250,  2008,  3530,  2123,  2920,  2921,   999,  1007,  1837,  1129,
    1130,  1158,  1159,  1160,  1161,  3232,  2276,  1164,  1382,  1133,
   -2253,  1129,  1130,  1729,   688,  1205,  2281,  3988, -2252,  2284,
    2285,  1129,  1130,  2278,  2026,  1133,  2149,  2819,  3730, -1836,
    3211,  1133,  2480,  2993,  1316,  1133,   581,  2345,   995,  4035,
    2033,  2346,  2753,  2753,  3206,  1989,  2034,  1133, -2252,  2240,
    2044,  1854, -1671,  2307,  2680,   116,  1133,  4006,  1129,  1130,
    1351,  2937,  2938,  1146,  1316,  1133,  3211,  2466,  2458,  3851,
    2960,  2961,  1855,  1772,  1772,  2539,  3834,  2193, -2437,  3852,
    2045,  3816,  1841,  1352,  2731,  2502,  1356,   581, -2385,  1129,
    1130,  1476,  2239,  3048,  1129,  1130,  2131,  2467,  1609,  1133,
     469,  1129,  1130,  2344,  2274,  2488,  3306,  2350,  1133,   474,
    2140,  3614,  1167,  1801,  2048, -2253,  1131,  2138,  1655,  1132,
    3440,  1837,  1131,  2631,  2580,  1132,  1069,  3284,  1536,  3417,
    1133,  1537,  1129,  1130,   476,  1647,  3730,  3730,  3418,  1069,
    3990,  2295,  1837,  3838,  3839,  2060,  3096,  2830,  2996,  2969,
    2377,  3991,  2463,  1467,  1912,  2241,  2464,  1474,  3655,  1357,
    1993,  3516,  2199,  3060,  1129,  1130,  2124,  1233,  3087,  1742,
    3520,  3521,  1842,  1459,  1386,  2585,  2586,  1129,  1130,  2698,
    1897,  3212,   562,  1994,  2153,  2718,  1801,  1387, -1693,  1594,
    2868, -2385,  2820,  2732,  2113,  1855,  1762,  1129,  1130,  1131,
    1265,   591,  1132,  1129,  1130,  2194,   712,  2157,  1133,  1593,
     517,  1243,   606,  1730,  1244,  1973,   477,  3212,  3905,  1711,
    3319,  2462,  2009,  2627,  2579,  1900,  3835,   563,  1129,  1130,
   -1694,  1048,  3067,   530,  2589,  1967,  1643,  1743,   591,  2216,
    2217,  1655,  3860,  1651,    42,  1149,  1837,  3895,   581,  -779,
    1131,  3097,  1763,  1132,  1129,  1130,  3213,   581,  3910,  3039,
    1131,  2475,  1655,  1132,  1129,  1130,  1129,  1130,  1802,  3419,
     547,  1363,  1803,   896,  3730,  3730,  1824,  3853,  1593,  4007,
    1843,   807,  2476,  2267,  3040,  2831,  1129,  1130,  3233,   808,
    1825,   591,  3223,   619,   555,   478,  1165,  1602,   564,  2096,
    2917,  2869,  2716,  1687,  1978,  1690,   551,   581,  1129,  1130,
     552,  4237,  1129,  1130,  1653,  2468,   581,  1129,  1130,  2109,
    1855,  1131,   591,  2416,  1132,  1801,  1744,  1129,  1130,  2935,
    2150,   581,   581,  3451,  1129,  1130,  1406,  2982,  3616,  1131,
    1684,  1802,  1132, -1693,  2416,  1803,  3599,  2489,  3911,  3992,
    1133,  1131,  1245,  1656,  1132,   591,  1133,  2117,  1732,  3730,
    2125,  1131,  1823,  2275,  1132,  2068,  1740,  1593,  1129,  1130,
   -1671,  2072,  1129,  1130,  3730,  3912,  2126,  3061,   466,   466,
     466,   581,   466,   581,  1286, -1694,  1466,  3730,  1773,  1129,
    1130,  2791,  2195,  1483,  1775,   466,   896,   591,  1131,    55,
     466,  1132,  1694,  2834,  1756,  1757,  1758,  2327,  1760,  1167,
    2792,  1483,   542,  1979,  2408,  1129,  1130,   896,  2835,  2469,
     581,  1776,  1764,  1129,  1130,  2118,  1780,  2708, -1591,  1131,
    1745,  3041,  1132,  1133,  1131,  1644,  2753,  1132,  2709,  1837,
   -2253,  1131,   553,  3730,  1132,  1826,  2226,  1759,  2073,  1761,
     981,   982,  1603,   128,  3214,  3730,  3730,  1645,  1129,  1130,
    1167,   631,  4082,  4082,  1167,   591,  2328,  1752,  1129,  1130,
   -2253, -1591,  1131,  2870,  2110,  1132,  1656,  2002, -2385,   581,
    1802,  2249,  1931,   581,  1133,   479,  1790,  1129,  1130,  3802,
    3214,  1483,  2329,   246,  1133,   248,   688,  1656,  2376,  2074,
    3730,  3600,  2344,   603,  1131,   480,  2856,  1132,   554,  2075,
    3730,  -196,  3993,  1484,   581,  1966,  1827,  1131,   632,  3745,
    1132,  1129,  1130,  1129,  1130,  1156,  1157,  1158,  1159,  1160,
    1161,  1499,   565,   591,   129,   466,   466,  1131,  1991,   466,
    1132,  1828,   481,  1131,  -531,  1928,  1132,   482,  3730,  1933,
    3730,  1021,  1314,  2007,   566,  1133,  1483,  2249,  2330,  1655,
    3730,  1987,  1988,  3623,   556,  1853,  1129,  1130,  1131,  2871,
    2079,  1132,  1483,  1133,  1129,  1130,  3730,  2889,  3730,  1463,
    3730, -2385,   483,  2959,  1733,  1133,   567,  3730,  2098,  3588,
     484,  2291,  3590,  3368,  1131,  1133,  3369,  1132,  3730,  1829,
    2918,  3615,  2250,  2584,  1131,  1464,  1131,  1132,  3801,  1132,
    2919,  1552,  1646,  2808,  3730,  3730,  1593,  2462,  2119,  1129,
    1130,  1129,  1130,  2710,  1069,  2053,  1131,  1129,  1130,  1132,
    3730,  3730,  1133,  2331,  2158,  3730,  1129,  1130,  1129,  1130,
    2999,   568,   633,  1463,  2847,  3782,  3624,  2930,  1131,  2527,
    2128,  1132,  1131,   558,  1842,  1132,  3899,  1131,   573,  4057,
    1132,  1837,  2533,  1133,  3783,  1129,  1130,  1131,  1133,  1465,
    1132,  1050,  1101,  1105,  1131,  1133,  1556,  1132,  2940,  2022,
     574,  1129,  1130,  2941,  2122,  1129,  1130,  1830,   712,  4058,
    3458,   576,  1579,  1129,  1130,  2548,  3417,   868,   869,  3900,
    1129,  1130,  2617,  2047,  1734,  3418,  1133,  1820,  1131,  2507,
    3441,  1132,  1131,  1048,   896,  1132,  2292,  2430,  3681,  3682,
    2097,  2023,  1166,   582,  1129,  1130,  2146,  3536,  3964,  1131,
     585,  1815,  1132,  2293,   591,  3550,   581,   591,  1133,  4050,
    2113,  1129,  1130,   587,  2294,  1129,  1130,   617,   581,   598,
    2163,  1133,  2936,  2024,  1166,  1131,  2169,  2169,  1132,  2169,
    -605,  3561,   599,  1131,  2595,  2021,  1132,  1146,   769,   581,
    2347,  1133,  1049,   581,   116,  1967,  2431,  1133,  3550,  2047,
    2226,  1655,  2348,  2511,   606,  2025,  3464,  1978,  2227,   591,
     591,   581,   581,  2468,  1656,  3896,   470,  3897,  1131,   471,
    1069,  1132,  1133,  2169,  2169,  2169,  1129,  1130,  1131,  2512,
     537,  1132,  1129,  1130,   607,  2469,  2032,   537,  3901,   610,
    2262,  2295,  2168,  2168,  2321,  2168,   612,  1131,  1133,  2273,
    1132,  2332,   614,  1129,  1130,  2191,  3419,   626,  1133,  1239,
    1133,   482,  2035,  1129,  1130,   531,  1968,  1399,  1400,  3215,
     628,  3562,  2036,   629,  2043,   761,  2513,  1256,  2219,  2514,
    1133,  1131,  3216,  1131,  1132,   581,  1132,  2515,  2432,  2168,
    2168,  2168,  2144,   630,  2056,   766,  3217,  2290,  -605,   816,
    2145,  2215,  1133,   477,   581,  1457,  1133,   868,  3360,  1288,
    3563,  1133,   924,   925,   820,   926,  2057,   927,  2228,  2229,
    2061,  1133,  1129,  1130,  2770,  2065,  1131,  1679,  1133,  1132,
    1680,  2144,   805,  1681,  1131,  2066,  1936,  1132,  2269,  3025,
    1129,  1130,  2067,  2040,  1166,  3047, -1591,  3045,   822,  2296,
     840,  2283,  3209,  3046,  3307,  2230,   896,  3354,  1316,  1937,
    3357,  3358,  1133,  2433,  1316,   842,  1133,  1129,  1130,  1149,
    2301,  2456,   832,  3225,  3226,  2472,  2071,  3370,   911,  1131,
    2076,  1131,  1132,  1133,  1132,  3083,  2587,  1131,   931, -1591,
    1132,   661,   930,  2558,  3238,  2501,  1131,  2084,  1131,  1132,
    2403,  1132,   939,  1129,  1130,  1593,   808,  1969,   958,  1133,
     968,  2297,  2311,  2523,  2417,   987,  3094,  1133,  2523,  1129,
    1130,  2318,  2319,  2089,  3100,  1131,  1772,  3102,  1132,  2049,
    1166,  2104,  2323,  2324,  2325,  2326,  1656,  2334,  2335,  1129,
    1130,  1131,  3795,  3796,  1132,  1131,  1129,  1130,  1132,   948,
     666,  2200,  1133,  1131,   909,   910,  1132,   913,  2050,  1550,
    1131,  1593,  1133,  1132,   949,  3797,  2892,  3175,  1129,  1130,
    1129,  1130,  2689,  2140,   591,   988,  2908,   114,   591,  1023,
    2473,  1133,   992,   466,  1131,  2716,  1024,  1132,  1966,  2349,
     581,   581,   581,  2496,  1593,  2914,  2499,  2516,  1025,  2241,
    1027,  1131,  -605,  1146,  1132,  1131,   920,  4234,  1132,  2478,
    2201,  2577,  1151,  1152,   950,  1133,   591,  1133,  2791,  1129,
    1130,   591,  3769,  3770,  3771,  3772,  2062,  1166,  1169,  2915,
    1170,  2922,  2428,  2429,  2560,  2436,  2202,  2438,  2439,  2440,
    2441,  2442,   677,  2598,  2445,  1028,  2447,  1029,  3873,  3862,
    1129,  1130,  2063,  1166,  2064,  1166,  2492,  2493,  2494,  1032,
    1133,  2434,  2758,  1615,  2894, -1671,  1131,  1033,  1133,  1132,
    2069,  1166,  1131,  1174,  2926,  1132,  1129,  1130,  2995,  1129,
    1130,  1166,  2927,  1034,  1303,  3879,  2785,  2786,  3882,  3883,
    3884,  3885,   480,  1131,   951,  1227,  1132,  1035,  3874,  1036,
    3333,  3334,  2203,  1131,  1037,  2200,  1132,  2336,  2337,  2468,
    2566,  1166,  1038,  1133,   591,  1133,  1039,   693,  1040,  2347,
    1043,  1133,  2958,  2226,  3038,   896,  3403,  2928,  3376,  2929,
    1133,  1045,  1133,  2517,  1837,  2931,  1185,  3670,  3671,  2596,
    1046,  1304,  2602,  2603,  2934,  1206,   591,  1154,  1155,  1156,
    1157,  1158,  1159,  1160,  1161,  2523,  1214,  2683,  2688,  1133,
     591,  1208,  1131,   851,  2201,  1132,  1047,  1305,  1051,  -605,
    4077,  3377, -1401,  2939,  1593,  1133,  3378,  2204,  1217,  1133,
    1131,  3974,  3975,  1132,  1052,  1149,  2562,  1133,  1226,  2942,
    3987,  1053,  2625,  2944,  1133,  2518,  1420,  1421,  2999,  2727,
    2523,  2946,  1054,  2889,  1216,  3982,   688,  1131,  2948,  1055,
    1132,   763,   764,   868,   869,   767,   768,  2113,  1133,   770,
    1056,   772,  3379,  2519,  2648, -1401,  1146,  2373,  1057,  1228,
     981,   982,  2949,  2932,  1166,  1133,  1616,   591,  1058,  1133,
    1059,  2228,  2229,  1131,  3005,  3006,  1132,  3961,  1967,  2950,
    2669,  1060,  2671,  3243,  1655, -1401,  3976, -1401,   591,  1131,
     591,   591,  1132,  1063,   688,  1936,  3178,  3179,  1773,  1773,
    2598, -1401,  3249,  1166,  1064,  1145, -1401,  1442,  3002,  1131,
    3636,  1070,  1132,   852,  3271,  3272,  1131,  1071,  1937,  1132,
   -1401,  3408,  3409,  1594,   952,  2291,  3218, -1401,  1072,  3455,
    1133,  1073,   591,   591, -1401,  1074,  1133,  1075,  1131,  1076,
    1131,  1132,  1077,  1132, -1401,   720,  3361,  3152,  1078,  1968,
    3244,  3444,  3452,  3459,  1166, -1401,  1080,  1133,  1151,  1152,
   -1401,  3977,  1433,  1434,  3473,  1166,  1082,  1133,  2745, -1401,
    1225,  3245,  2417,  -748,  2668,  3488,  3489,  2417,  2757,  1083,
    1844,  3457,  2417,   853,  2767,   953,  2417,   954,  2766,  1131,
    1084,  1209,  1132,  3602,  2337,  1085,  1328,  1306,  2766,  1086,
    2417,  2417,  1087,   591,  1088,  2205,  2788,  1146,  3637,  3638,
    2417,  2796,  1594,  3639,  3640,  1443,  1089,  2798,  2799,  1444,
    1131,   581,  1090,  1132,  1091,  1329,  1133,  1092,   712,  2766,
    1445,  1093, -1401,  3617,  3618,  -605,  2417,  2818,  1149,   896,
    3463,  3621,  3618,   114,  1133,  2347,  1131,  1094,  2844,  1132,
    2292,  1095,  1026,  1048, -1401,  1096,  2327,  2348,  3465,  1097,
    1617,  2375,  1098, -1401,  4181,  1210,  1102,  2293,   981,   982,
    1211,  1133,  1330,  1103,  3380,  1106,  1618,  1331,  2294,  1107,
    3381,  1845,  1111,   851,  2768,  2769,   712,  2797,  3622,  3618,
    1969,  3231, -1401,  1154,  1155,  1156,  1157,  1158,  1159,  1160,
    1161,  2800,   118,  2801,  1147,   581,  2417,  1133,  1115,  2795,
    1116,  1048,  1100,  1212,  1117,  2328,  3382,  1118,  1184,  1656,
    1234,  3466,  1119,  1133,  1307,  1168,  1148,  1235,  1213,  3675,
    3272,  3250,  1251,  2200,   115,  1515,  1262,  3467,  1281,  4238,
   -1401,  2329,  1264,  1133,  2802,  1308,  3678,  3618,  3784,  2454,
    1133,  1446,   116,  -605,  1282,  2295,  1146,  3468,   477,  3978,
    3685,  3686, -1401,  1283,  3538,  2803,  3809,  3810,  2848,  1286,
    1104,  2873,  1133,  1289,  1133,  1298,  1487,  1488,  1489,  1302,
    3785,  1151,  1152,  1314,  3383,  1309,  3766,  1297,  1500,  1149,
    1323,  1936,  2201,  3814,  3618,  1187,  1324,  3424,  1325,  2804,
    3815,  3618, -1401,   852,  2171,  1340,  2172,  2330,  1347,   981,
     982,  1343,  4073,  1348,  1937,  1361,  1332,   117,  2202,  1553,
    2627,  1364,  1557,  1133,  1365, -1671,  2733,  2163,  3943,  1519,
    1232,   591,   591,   591,  1367,  3759,  3763,  4184,  4185,   581,
    1846,  1372,  1575,  1576,  1447,   118,  1580,  3817,  3618,  1847,
    2244,  2245,  2246,  2070,  1133,  1848, -1401,  2625,   591,   854,
     855,  1594,   857,  2296,   859,  1595,  1596, -1401, -1401,  3694,
    2327,  3818,  3618,   853,  1069,  3694,   860,   591,   591,   591,
    1133,  1150,  2331,  3384,  2203, -1401,  1333, -1401,  1188,   640,
    3024,  2523,  3786,  3824,  3825,   119,  3026,  1377,  3028,  3826,
    3825,  1383,  3449,  1593,   591,  2981,  3875,  3876,  1870,  1871,
   -1401, -1401,  1189,  1389, -1401, -1401,  1190,  1155,  1156,  1157,
    1158,  1159,  1160,  1161,  1391,  2297,  1520,  3871,  1393,  2328,
    1523,  1397,  1151,  1152,  3998,  3810,  1396,  1524,  1149,  3999,
    3810,  -731,  -731,  1873,  1401,  1153,  1404,  1849,  1334,  1191,
    1405,  -731,  1146,  4004,  3272,  2329,  1876,  -605,  1408,  2204,
    4048,  4049,  1409,  3544,  1877,  1410,  1192,  3787,  4089,  4090,
     661,  1451,  3759,  4107,  3177,  2417,  3763,  1452,  2417,  2417,
    1453,  2766,  4226,  4227,  3023,  3788,  3629,  3630,  1879,  1583,
    1584,  1146,  3980,  3980,   591,  1456,  4069,  2417,   759,  3288,
    3289,  1458,  1383,  3256,  3257,  1880,  3486,  3487,  3789,  1459,
    1477,  1479,  2766,  1525,  1164,  1483,   536,   120,  1146,  1490,
    2766,  2330,   665,  2766,   759,  1502,  1193,  1504,  1110,   666,
    2805,  3759,  3763,  1885,  1539,  1549,  1850,  3053,  1550,  1551,
    1591,  1601,  1610,  3106,  1632,  1626,   581,   480,  1194,  2923,
    1652,  3162,  1660,  1659,  1663,   670,  1335,   466,  1666,  1667,
    1668,  3172,  1669,  2766,  1670,  1671,  1527,  1154,  1155,  1156,
    1157,  1158,  1159,  1160,  1161,  1672,  1673,  1675,  3181,  1676,
    2332,  1151,  1152,  3168,  1696,   121,  1699,  1707,  1715,  3089,
    1336,  3192,  1593,  1722,  1716,  1717,  2331,  3092,   581,  1718,
    1888,  4147,  3646,  4149,  1726,  1725,  1824,  1889,  1750,  1727,
    3205,  1736,  3107,  1741,  1754,  1782,  3871,  1784,  1783,  1785,
    1825,   677,  1890,  2291,  -605,  1787,  1796,  3916,  1798,  4167,
    1050,  1101,  1105,  1800,  1149,  1813,  1288,  1822,  1440,  1940,
    3293,  1941,   122,   759,  -912,  1942,  1195,  1923,   759,   854,
     855,   856,   857,   858,   859,  1196,  2727,  2205,  1943,  1944,
    3952,  1960,  1945,  1946,  3194,  2173,   860,  4199,  4200,   896,
    1197,  1947,  1948,  1149,  1949,  1891,  1950,  3184,   759,  3248,
     688,  1951,  3438,  3439,  1952,  3790,  2174,  2669,  1198,  1953,
    1954,  3578,  3656,  1892,   759,   692,   693,  1528,   640,  2175,
    1149,  1955,  1956,  3696,  1957,  1958,  1959,  1962,  1980,  2176,
    1981,  2625,  1530,  1996,  1997,  4094,  1154,  1155,  1156,  1157,
    1158,  1159,  1160,  1161,  1986,  2005,  1998,  1199,  1200,  2011,
    2648,  3283,  1999,  2010,   591,   759,   759,   759,   759,  2013,
    2014,  2015,  2030,   591,  2037,  2031,  1896,   759,  2292,  2596,
    2039,  2047,  1201,  2041,  1898,  2038,  2177,  2178,  2051,   591,
    2055,  2059,  2077,  2078,  2083,  2293,  3732,  2262,  2114,  2121,
    2087,   470,  3544,  2088,   471,  1826,  2294,  1151,  1152,   661,
    2099,  2668,  2159,  2100,  2179,  2101,  1594, -1116,  2127,  1161,
   -1233,  2184,  2137,  2166,  2332,  2192,  2198,  2212,  2417,  2242,
    2209,  2054,  2243,  2258,  2270,  2058,  2272,  4094,  2417,  2300,
    2766,  3541,  2277,  2303,  2299,  2304,  1151,  1152,  2306,  1594,
    2310,  1904,  3827,  2312,  2313,  2766,  1593,   581,  2082,  2417,
    2314,   665,  2315,  2316,  2317,  3794,  2347,  2359,   666,  2364,
    2523,  2365,  2369,  1151,  1152,  2180,  1827,  3568,  3569,  1593,
    4219,  2368,  2371,  2295,  4099,  4100,  1593,  4102,  2381,  2378,
    3572,  2372,  1593,  2380,   670,  3575,  2387,  2388,   981,   982,
    2392,  1828,   712,  4230,  2398,  3518,  3545,  1905,  2399,  3546,
    4219,  2420,  2393,  2424,  2497,  2347,  4230,  2405,  3591,   718,
    2426,  3593,  2457,  1906,   720,  2181,  1907,   721,  2510,  2479,
    2501,  2844,  2529,  4140,  2530,  4141,  4142,  2505,  2528,  2540,
    2541,  3507,  1154,  1155,  1156,  1157,  1158,  1159,  1160,  1161,
    2145,  2593,  2574,  2553,  2572,  2575,  3437,  3437,  3437,  1829,
     677,  1773,  1909,  2583,  2576,  2592,  2605,  1511,  1512,  1513,
    1514,  1515,  2607,   591,  2606,  2615,  2608,  2609,  2618,  3547,
    3548,  1154,  1155,  1156,  1157,  1158,  1159,  1160,  1161,  2620,
    4178,  2296,  2621,  2628,  2629,  1702,  3957,  2632,  2650,  2651,
    2633,  2634,   759,  2638,  2653,  3955,  2654,  3794,  2655,  2249,
    1156,  1157,  1158,  1159,  1160,  1161,  2250,  2881,  3405,   688,
    2672,  2673,  2674,  2373,  3496,  2695,  2699,  2704,  2727,  1594,
    4211,  2705,  2706,  2722,   692,   693,  2729,  2730,  2773,  2775,
    2827,  3429,  2833,  2837,   591,  2859,  2839,  1830,  3676,  3677,
    2853,  3679,  3680,  2297,  2854,  2860,  2861,   759,   759,  1897,
    2858,  1936,  1516,  1517,  1518,  1519,   759,   759,   759,   759,
     759,   759,   759,  2886,  1815,  2006,  2895,   759,  2904,  2978,
     759,   759,  2899,   759,  1937,   759,  3437,  2905,  3656,   759,
    2906,  3553,   759,   759,   759,   759,  2907,   759,   759,  2909,
    2523,  2910,  2955,  3558,  2971,   759,   759,  2953,   759,   759,
     759,   759,   759,  2957,   759,  2962,   759,   759,   759,   759,
     759,   759,   759,   759,   759,   759,   759,  2965,  2966,   759,
     759,   591,   759,  2976,   759,  2983,  2987,  1243,   759,  2990,
     759,   759,  3010,  3021,  3022,  3007,  3027,  3035,  2986,  3054,
    3058,  3059,   759,   759,  3163,  3001,  3594,  3062,  3004,  3293,
     759,  2291,  1520,  3598,  1521,  1522,  1523,   759,   759,   759,
    3074,   759,  3073,  1524,  3075,   495,  3086,  3103,   759,   759,
     759,  3192,   759,   759,   759,   759,   759,  3166,   759,   759,
     759,   759,   759,   759,   759,   759,  3095,  3104,  3170,   759,
     759,  3105,  3169,   591,  3174,  3176,  1136,  1137,  3177,  3187,
    3180,   712,  1870,  1871,  2374,  3545,  3188,  3193,  3546,  -440,
    3196,  2226,  3202,  3203,  4019,  3204,  3577,  2375,   718,  3207,
    3224,  3234,   496,   720,  3227,  1266,   721,  3955,  4136,  4019,
    1138,  3235,  3253,  3262,  1267,  -731,  -731,  1873,  3264,  1525,
    1139,  3252,  4029,  1268,  3286,  -731,  3267,  3273,   497,  3275,
    1876,  3311,   591,  3294,  3603,  1269,  1270,  1271,  1877,  3302,
    3303,  3312,  3335,  1227,  3324,  3336,  3332,  3349,  3355,  3399,
    3668,  1272,  3402,  2418,  3404,  3406,  2292,  1140,  3547,  3548,
     498,  3412,  1879,  3437,  3437,  3416,  3437,  3437,  1141,  3426,
    3425,  1526,  1527,  2293,  4136,  3427,  1383,  2523,  3430,  1880,
    3794,  3433,  3431,  3442,  2294,  3443,  3444,  3445,  3446,  3450,
    3453,  3460,  1129,  1130,  3454,  1142,   759,   776,   777,  3456,
    3461,  3462,  3474,  3475,   759,  3484,   499,  1885,  3491,  4208,
    3492,  3489,  3501,  3503,  3025,  3504,  3508,  3509,  3512,  3514,
   -1401,  1187,  3515, -1316, -1321,  3526,  3539,  3559,  3540,  3542,
    3737,   581,  3556,  3543,  3567,  4019,  3573,  3390,  3571,  3581,
    3582,  3583,  3437,  4208,  4236,  4126,  3585,  3586,  3393,  3592,
    3604,  3620,  3605,  1143,  3625,  3628,  3627,  3644,  3631,  3632,
    3633,  2295,  3645,  3648,  3649,  3684,  3664,  3666,  3690,   581,
    3697,  3733,  3781, -1401,  1888,  3698,  3659,  1228,  3660,   778,
     591,  1889,  3452,  3522,  3699,  3741,  3765,  1511,  1512,  1513,
    1514,  1515,  3755,  3774,  3768,  4157,  1890,  3738,  3777,  3811,
    3806,  3829,  3808,  1528,  3820, -1401,  3847,  3856,   779,  2481,
    3821,  -307,  3866,  4019,  1188,  4019,  3850,  1529,  1530, -1401,
    3859,   780,  4177,   -63, -1401,  3865,  3833,  3878,   500,  3849,
    3880,  3840,  3881,  4019,  3889,  3775,  3891,  3886,  1189,  3893,
    2822,  3920,  1190,  3923,   781, -1401,   782,  -325,  3949,  1891,
    3950,  3951, -1401,  3963,  3966,  1273,  3969,   783,  3984,  3996,
    4000,  4001, -1401,  4002,  4003,  4019,  4019,  1892,  4005,  2296,
    4223,  4008,  1274, -1401,  4009,  1191,  4015,   784, -1401,  4016,
    4020,  4026,  1516,  1517,  1518,  1519,  4027, -1401,  4028,  4031,
    4038,  4052,  1192,  4053,   759,  4054,   501,  4055,  1594,  4063,
    4064,  4065,   785,  4070,  4072,  4074,  3983,  4075,   786,  4078,
    4087,  4084,  4098,  4101,   844,   777, -2172,  4103,  4104,  4106,
    1896,  4114,  4127,  4128,  4130,  4133, -1474,  4144,  1898,  4145,
    3668,  2297,  3668,  4146,  3898,  4150,  4151,  4158,  4161,  4155,
    4163,  4166,  4164,  4172,  4175,  4170,  4176,   787,  4179,  4183,
   -1401,  4189,  1193,   502,  4187,  4196,  4197,  4220,   503,  4224,
    3924,  3842,  4233,  2600,  2449,  3861,  3414,  2737,  3415,  1004,
    3608,  3857, -1401,  3958,  1194,  4085,   504,  1395,  4086,  3606,
    3610, -1401,  1520,  3736,  1521,  1522,  1523,  4231,  4191,   550,
     759,   759,   759,  1524,  1275,  1904,   778,   906,  2234,  3710,
    3781,   505,  4201,  3009,   759,  4111,  4013,  3711,  2598,   591,
   -1401,  3713,  3714,  3716,  3717,  3989,   506,  3718,  4112,  3719,
    4083,  3720,  4025,  3721,  3724,   779,  3725,  3726,  4024,  1866,
     759,  1934,  1131,  2148,  1455,  1132,   759,  2409,   780,   759,
    1910,   759,  3744,  3099,  2989,  3494,  2994,   759,  1276,   759,
     759,  1905,  3266,  1705,  3968,  4037,  3497,  3776, -1401,  4160,
    4097,   781,  4135,   782,  1965,  1277,   815,  1906,  4096,  1525,
    1907,   788,  1195,  3888,   783,   789,   627,  3432,  2407,  3185,
   -1401,  1196,  2879,  3348,  2414,  2824,  3337,  1594,  3362,  3363,
    3400,   790,  3692,  3552,   784,  3584,  1197,  3973,  3965,   791,
    3576,  3300,  3904,   491,   492,  1995,  1909,   792,  3863,  3906,
    3868,   591,  3867,  3754,  1198,  2491,   759,  3695,  3907,   785,
   -1401,  1526,  1527,  2411,  3339,   786,  2844,  2844,  3555,  2812,
    1799,  2288,   793,  2635,  1963,  3338,  2218,  1932,  2980,  2616,
    3263,  2656,  2571,   928,  2248,   794,   795,  3731,  1293,  3251,
    2964,  1548,  2526,  1199,  1200,  3308,  2570,  2717,  3813,  2482,
    3672,  4061,  2590,  3413,   787,  4062,  3343,  1501,  3669,  3981,
    4182,   591,  3658,  2663, -1401,  2495,  2614,  1693,  1201,  2641,
    3499,  3279,  3278,  3318,  4034,  1720, -1401,  1022,   917,   796,
    1030,  2004,  4045,  4046,   902,  4116,  1766,  3347,  2279,  1788,
    2280,  4131,  4124, -1401,  2160, -1401,  3265,  4056,  4159,  4232,
    1724,  4105,  4235,  3580,  3282,  3043,  2259,  3304,   797,  3513,
    1062,  3661,  1739,  1731,   847,  1280,  2197,  1686, -1401, -1401,
    3767,  1985, -1401, -1401,  2968,  3773,  1079,  4225,   849,  1285,
     798,   621,   799,   622,  1008,  1009,  1010,     0,     0,     0,
       0,     0,     0,  1528,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1133,  1529,  1530,     0,
    4168,     0,     0,     0,     0,  4173,     0,     0,     0,     0,
    1123,     0,     0,     0,     0,     0,     0,     0,   788,     0,
       0,     0,   845,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   790,     0,
       0,     0,  4209,  1870,  1871,     0,   791,     0,     0,     0,
       0,  1594,     0,     0,   792,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     591,     0,     0,     0,  1594,   759,  4209,     0,  1873,   793,
       0,  1594,     0,     0,     0,     0,     0,  1594,     0,     0,
       0,  1876,   794,   795,     0,     0,     0,     0,     0,  1877,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1879,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   796,  1383,     0,     0,
    1880,     0,   759,     0,     0,     0,   759,     0,     0,     0,
       0,   759,   759,     0,     0,     0,     0,     0,     0,     0,
     759,     0,     0,   759,     0,   797,     0,     0,  1885,     0,
       0,     0,     0,   759,     0,   759,   759,     0,   759,   759,
     759,   759,   759,     0,     0,   759,     0,   798,     0,   799,
       0,     0,     0,     0,   759,     0,     0,     0,     0,     0,
       0,     0,   759,     0,   759,     0,   759,   759,   759,   759,
       0,     0,     0,   759,   759,   759,     0,     0,     0,     0,
     759,   759,   759,     0,   759,     0,   759,     0,   759,     0,
     759,     0,   759,     0,     0,  1888,     0,   759,     0,     0,
       0,     0,  1889,     0,  1416,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   759,     0,  1890,     0,     0,
       0,     0,   759,     0,     0,   759,     0,     0,     0,     0,
       0,   759,     0,     0,   759,     0,     0,     0,   759,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1481,
    1482,     0,     0,     0,     0,     0,     0,     0,  1492,  1493,
    1891,     0,  1496,  1497,  1498,     0,     0,     0,     0,  1503,
       0,     0,  1505,  1506,     0,  1507,     0,  1508,  1892,     0,
       0,     0,     0,   759,  1541,  1542,  1543,  1544,     0,  1546,
       0,     0,     0,     0,     0,     0,     0,  1554,  1555,     0,
    1558,  1559,     0,     0,     0,     0,  1563,     0,  1564,  1565,
    1566,     0,     0,  1569,  1570,  1571,  1572,  1573,  1574,     0,
       0,  1577,  1578,     0,  1581,     0,  1582,     0,     0,     0,
    1585,  1896,  1589,  1590,     0,  1867,     0,     0,     0,  1898,
       0,     0,  1868,  1869,  1597,  1598,     0,     0,     0,     0,
       0,     0,  1606,     0,  1870,  1871,     0,     0,     0,  1611,
    1612,  1613,     0,     0,  3108,  3109,     0,     0,     0,     0,
    3110,     0,  3111,     0,  3112,  3113,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1872,     0,     0,     0,  1873,
    1874,  3114,  1649,     0,     0,  1875,     0,     0,     0,   777,
       0,     0,  1876,     0,     0,     0,  1904,     0,     0,     0,
    1877,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1878,     0,     0,     0,     0,     0,  1417,     0,     0,     0,
       0,     0,     0,     0,  1879,     0,     0,     0,  3115,     0,
       0,  3116,     0,     0,     0,     0,     0,     0,  1383,  3117,
       0,  1880,     0,     0,     0,     0,     0,     0,  1881,  1882,
       0,     0,  1905,     0,     0,  1883,  3118,     0,     0,     0,
       0,     0,     0,  1884,     0,     0,     0,  -850,  1906,  1885,
     778,  1907,     0,  3119,  1418,  1419,  1420,  1421,  1422,  1423,
       0,  1424,  1425,  1426,  1427,  1428,  1429,  1430,     0,  1431,
    1432,     0,     0,     0,     0,     0,  3120,  1886,  3121,   779,
       0,     0,     0,     0,     0,     0,     0,  1909,  1738,     0,
    3122,  3123,   780,     0,     0,     0,  1753,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1887,   781,  1888,   782,     0,     0,
       0,     0,     0,  1889,     0,     0,     0,     0,   783,     0,
    3124,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   784,     0,
       0,     0,     0,     0,     0,     0,     0,   759,  3125,     0,
       0,   759,     0,     0,     0,     0,     0,  3126,  3127,     0,
    3128,     0,     0,   785,     0,     0,     0,     0,     0,   786,
       0,     0,     0,   759,   759,     0,     0,     0,     0,     0,
       0,  1891,  1433,  1434,     0,     0,     0,     0,     0,     0,
    3129,  3130,  3131,   759,     0,     0,     0,     0,     0,  1892,
       0,     0,   759,  1893,   759,     0,   759,     0,   787,  3132,
    3133,  3134,     0,     0,     0,     0,  3135,     0,     0,  3136,
       0,     0,     0,     0,     0,     0,   759,     0,     0,     0,
       0,   759,     0,     0,     0,  3137,  3138,  1870,  1871,     0,
    1894,     0,     0,     0,     0,  1895,     0,     0,     0,     0,
       0,     0,  1896,     0,     0,   759,     0,     0,     0,  1897,
    1898,     0,     0,     0,     0,     0,     0,  3139,  3140,     0,
    -731,  -731,  1873,     0,     0,     0,  2016,     0,     0,     0,
    -731,     0,     0,     0,     0,  1876,     0,     0,     0,     0,
    1899,     0,  3141,  1877,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1900,  1901,  1902,  1903,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1879,     0,   759,
       0,     0,     0,   759,     0,     0,     0,  1904,     0,     0,
       0,  1383,   788,     0,  1880,     0,     0,     0,     0,     0,
       0,     0,     0,  3142,     0,     0,     0,  3143,     0,     0,
       0,     0,   790,     0,     0,     0,     0,     0,     0,  3144,
     791,     0,  1885,     0,     0,     0,     0,   759,   792,     0,
       0,     0,  2091,  2093,  2095,     0,     0,     0,     0,     0,
       0,     0,     0,  1905,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   793,     0,     0,     0,     0,     0,  1906,
       0,     0,  1907,     0,     0,     0,   794,   795,     0,     0,
       0,  3145,  2129,     0,  3146,     0,     0,  3147,  3148,  3149,
    3150,  2134,     0,  2135,     0,  1908,     0,     0,     0,  1888,
       0,     0,     0,     0,     0,     0,  1889,     0,  1909,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     796,  1890,     0,     0,     0,     0,     0,     0,     0,  3151,
    3152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   759,   759,     0,     0,     0,   797,
       0,     0,     0,  3153,     0,     1,     2,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -850,  2214,     0,
       0,   798,     0,   799,  1891,     0,     4,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     6,  1892,     0,     0,     0,     0,     0,     7,     0,
       0,     0,     8,     9,     0,     0,     0,     0,   759,     0,
       0,     0,     0,     0,     0,     0,     0,    10,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   759,   759,     0,   759,    11,     0,     0,     0,
       0,     0,     0,     0,   759,  1896,     0,     0,     0,   759,
       0,     0,   759,  1898,   759,   759,     0,    12,     0,     0,
       0,     0,     0,     0,     0,    13,    14,    15,     0,     0,
       0,     0,     0,     0,     0,   759,     0,    16,    17,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     759,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    19,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   759,     0,     0,     0,     0,    20,
    1904,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    21,     0,     0,     0,     0,    22,
       0,     0,    23,     0,   759,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   759,     0,
       0,     0,     0,     0,     0,    24,     0,    25,     0,     0,
       0,     0,     0,     0,     0,     0,  1905,     0,   759,     0,
       0,     0,     0,    26,     0,     0,     0,   759,     0,     0,
       0,     0,  1906,     0,     0,  1907,     0,  2425,     0,     0,
      27,     0,     0,     0,    28,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1909,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2504,     0,     0,     0,  2506,     0,
       0,     0,     0,  2508,  2509,     0,     0,     0,     0,     0,
       0,     0,  2524,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    29,     0,  2531,     0,  2532,     0,     0,
    2534,  2535,  2536,  2537,  2538,     0,     0,     0,     0,     0,
       0,     0,    30,     0,     0,     0,  2542,     0,     0,     0,
       0,     0,    31,     0,  2543,     0,  2544,     0,  2545,  2546,
    2547,     0,     0,    32,     0,  2550,  2551,  2552,     0,     0,
       0,     0,  2554,  2555,  2556,     0,  2557,     0,  2559,     0,
    2561,     0,  2563,     0,  2564,    33,     0,     0,    34,  2565,
      35,     0,     0,    36,     0,     0,    37,    38,     0,     0,
       0,     0,     0,     0,    39,     0,    40,  2578,     0,     0,
       0,     0,     0,    41,     0,     0,     0,     0,     0,    42,
     759,     0,     0,  2588,     0,     0,  2591,    43,     0,     0,
       0,     0,    44,     0,    45,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     1,     2,     0,   759,
     759,    47,     0,     0,     0,    48,     0,     0,   759,     0,
       0,     0,     0,     3,     0,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     6,     0,     0,     0,     0,     0,     0,     7,
       0,     0,     0,     8,     9,     0,     0,     0,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    10,     0,
      50,     0,     0,     0,    51,     0,     0,    52,     0,     0,
       0,     0,    53,     0,     0,     0,     0,    11,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    12,    54,
       0,     0,     0,     0,     0,     0,    13,    14,    15,     0,
       0,     0,     0,     0,    55,     0,     0,     0,    16,    17,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     866,    18,     0,     0,     0,     0,     0,     0,     0,     0,
     823,   867,   759,     0,    19,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      20,     0,     0,     0,     0,   868,   869,     0,     0,     0,
       0,     0,     0,   759,     0,    21,   870,     0,     0,     0,
      22,     0,     0,    23,     0,     0,     0,   759,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   871,     0,   872,
     759,   873,     0,     0,     0,     0,    24,     0,    25,     0,
     874,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    26,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    27,     0,     0,     0,    28,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1671,   875,     0,     0,
       0,     0,   876,     0,     0,   877,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3728,     0,     0,     0,     0,     0,     0,     0,     0,
     878,     0,   879,     0,     0,     0,     0,     0,   880,     0,
     881,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   882,   883,     0,     0,     0,     0,  2891,
     759,     0,     0,  2893,    29,     0,     0,     0,   759,     0,
       0,     0,     0,     0,     0,   884,     0,   759,     0,   759,
       0,     0,     0,    30,     0,  2912,  2913,     0,     0,     0,
       0,     0,     0,    31,     0,     0,   885,     0,     0,     0,
       0,     0,     0,     0,    32,  2933,     0,     0,     0,     0,
       0,     0,     0,   759,  2943,     0,  2945,     0,  2947,  3728,
    3728,     0,     0,   886,     0,     0,    33,     0,     0,    34,
       0,    35,     0,     0,    36,     0,     0,    37,    38,     0,
       0,     0,     0,     0,     0,    39,     0,    40,     0,     0,
       0,     0,     0,     0,    41,     0,     0,     0,     0,     0,
      42,     0,     0,     0,     0,     0,     0,  2977,    43,     0,
       0,     0,     0,    44,     0,    45,     0,     0,    46,     0,
       0,     0,     0,     0,     0,     0,     0,   887,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,     0,     0,     0,
     888,   759,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   889,   890,     0,     0,   891,   892,     0,     0,     0,
       0,  3033,     0,     0,     0,  3037,     0,     0,     0,     0,
       0,     0,     0,   759,     0,   759,   893,     0,     0,    49,
       0,     0,     0,     0,     0,   759,     0,  3728,  3728,     0,
       0,    50,     0,     0,     0,    51,     0,     0,    52,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,  3068,
    3962,     0,     0,     0,     0,     0,     0,     0,     0,   894,
       0,     0,     0,     0,     0,     0,     0,  2810,     0,     0,
      54,     0,   895,     0,  1868,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,  1870,  1871,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2199,     0,     0,
       0,   896,     0,     0,     0,     0,     0,     0,     0,     0,
     759,     0,  3728,     0,     0,     0,     0,  1872,     0,   897,
       0,  1873,     0,     0,     0,     0,     0,  3728,   759,     0,
       0,     0,     0,     0,  1876,     0,     0,     0,     0,     0,
    3728,     0,  1877,     0,     0,     0,     0,     0,   759,     0,
       0,     0,  1878,     0,     0,     0,  3164,  3165,     0,     0,
       0,     0,     0,     0,     0,     0,  1879,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2199,     0,     0,     0,
    1383,     0,   898,  1880,     0,     0,     0,     0,     0,     0,
    1881,     0,     0,     0,     0,   759,  3728,  2811,     0,     0,
       0,     0,     0,     0,     0,  1884,     0,     0,  3728,  3728,
       0,  1885,     0,     0,     0,     0,     0,     0,     0,     0,
    3210,     0,     0,     0,     0,   759,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1886,
       0,     0,     0,     0,  3229,  3230,     0,     0,     0,     0,
       0,     0,     0,  3728,     0,     0,  3237,     0,     0,     0,
     759,  3239,     0,  3728,  3240,     0,  3241,  3242,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1888,     0,
       0,     0,     0,     0,     0,  1889,     0,     0,     0,     0,
       0,     0,     0,     0,   759,     0,     0,     0,     0,     0,
    1890,  3728,  3259,  3728,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3728,     0,     0,     0,   759,     0,     0,
     759,     0,     0,     0,     0,     0,  3259,     0,     0,  3728,
       0,  3728,     0,  3728,     0,     0,     0,     0,     0,     0,
    3728,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3728,     0,  1891,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3728,  3728,     0,
    3305,  1892,     0,   759,     0,  1893,     0,     0,     0,     0,
       0,     0,     0,  3728,  3728,     0,     0,     0,  3728,     0,
    3259,     0,     0,     0,     0,     0,     0,     0,     0,  3329,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1895,     0,     0,
     759,     0,     0,     0,  1896,     0,     0,     0,     0,     0,
       0,     0,  1898,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1901,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1904,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1905,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1906,     0,     0,  1907,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3259,     0,     0,     0,     0,     0,     0,     0,
    1909,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3524,  3525,     0,     0,     0,     0,     0,     0,     0,
    3068,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3626,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3259,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3068,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3033,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3800,     0,     0,     0,     0,     0,     0,     0,     0,  3805,
       0,  3807,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3828,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3068,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3918,     0,  3919,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3927,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4017,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4022,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3259,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4068,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4118,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4143,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,   636,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,  4162,     0,   637,     0,   143,   144,   145,   146,
     147,   638,   149,     0,   150,     0,     0,   639,   151,   640,
     641,   642,   152,   643,     0,   153,   154,   155,  1586,   156,
       0,   157,   158,     0,     0,   159,   644,   645,   160,   161,
       0,   162,   646,   647,   164,     0,   165,   166,   167,   168,
     648,   170,     0,   649,   172,  4210,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   650,   187,     0,   188,   651,   652,   189,     0,     0,
     190,   653,   654,     0,   191,   655,   656,     0,   192,   193,
     194,   657,   658,   659,     0,     0,     0,     0,   660,   197,
     661,     0,  3259,   662,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,   663,     0,   222,   223,
     224,   664,   665,   225,   226,     0,   227,   228,   229,   666,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   667,   236,   668,   238,     0,   239,     0,   669,
       0,   240,   241,     0,   242,   670,     0,   243,   244,     0,
       0,     0,   671,   246,   247,   248,   672,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,   673,   253,   254,
     674,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,  1587,
     263,     0,   675,   264,   265,     0,     0,     0,     0,     0,
     676,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,   677,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,   678,   288,   289,   290,   291,   679,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   680,
     299,     0,     0,   681,   301,   682,   302,     0,   303,   683,
     684,   685,   686,   687,   308,   309,   310,   311,   312,     0,
     688,   313,   314,     0,     0,   315,   316,   317,   318,   689,
     690,   691,   319,   320,     0,   692,   693,     0,   321,   322,
     694,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,   695,
     331,   332,   333,   334,   335,   696,   337,   338,   339,   697,
     698,   342,   699,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   700,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,   701,   702,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,   703,   377,   378,
     379,   380,   381,   704,   383,   384,   385,   386,     0,   705,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,   706,   707,   411,   412,     0,
     413,   414,   708,   416,   417,   418,   709,   710,   419,   420,
     421,   422,   711,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   712,   429,   430,     0,   713,   714,   715,   716,
       0,     0,     0,     0,  1588,   435,   436,     0,   717,   718,
     719,   438,   439,   440,   720,   441,   442,   721,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   722,   451,     0,     0,   723,   724,   725,   726,
     452,     0,     0,   453,   727,     0,   728,   454,   455,   456,
     729,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   730,     0,     0,     0,   731,
     732,     0,     0,     0,     0,   733,   734,     0,     0,   735,
     736,     0,     0,   737,   738,   135,     0,   636,   137,   138,
     139,   140,  3029,     0,     0,     0,     0,   141,     0,     0,
     637,     0,   143,   144,   145,   146,   147,   638,   149,     0,
     150,     0,     0,  3030,   151,   640,   641,   642,   152,   643,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   644,   645,   160,   161,     0,   162,   646,   647,
     164,     0,   165,   166,   167,   168,   648,   170,     0,   649,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   650,   187,     0,
     188,   651,   652,   189,     0,     0,   190,   653,   654,     0,
     191,   655,   656,     0,   192,   193,   194,   657,   658,   659,
       0,     0,     0,     0,   660,   197,   661,     0,     0,  3031,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,   663,     0,   222,   223,   224,   664,   665,   225,
     226,     0,   227,   228,   229,   666,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   667,   236,
     668,   238,     0,   239,     0,   669,     0,   240,   241,     0,
     242,   670,     0,   243,   244,     0,     0,     0,   671,   246,
     247,   248,   672,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,   673,   253,   254,   674,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,   675,   264,
     265,     0,     0,     0,     0,     0,   676,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,   677,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,   678,
     288,   289,   290,   291,   679,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   680,   299,     0,     0,   681,
     301,   682,   302,     0,   303,   683,   684,   685,   686,   687,
     308,   309,   310,   311,   312,     0,   688,   313,   314,     0,
       0,   315,   316,   317,   318,   689,   690,   691,   319,   320,
       0,   692,   693,     0,   321,   322,   694,  3032,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,   695,   331,   332,   333,   334,
     335,   696,   337,   338,   339,   697,   698,   342,   699,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   700,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
     701,   702,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,   703,   377,   378,   379,   380,   381,   704,
     383,   384,   385,   386,     0,   705,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,   706,   707,   411,   412,     0,   413,   414,   708,   416,
     417,   418,   709,   710,   419,   420,   421,   422,   711,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   712,   429,
     430,     0,   713,   714,   715,   716,     0,     0,     0,     0,
       0,   435,   436,     0,   717,   718,   719,   438,   439,   440,
     720,   441,   442,   721,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   722,   451,
       0,     0,   723,   724,   725,   726,   452,     0,     0,   453,
     727,     0,   728,   454,   455,   456,   729,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   730,     0,     0,     0,   731,   732,     0,     0,     0,
       0,   733,   734,     0,     0,   735,   736,     0,     0,   737,
     738,   135,     0,   636,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   637,     0,   143,   144,
     145,   146,   147,   638,   149,     0,   150,     0,     0,   639,
     151,   640,   641,   642,   152,   643,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   644,   645,
     160,   161,     0,   162,   646,   647,   164,     0,   165,   166,
     167,   168,   648,   170,     0,   649,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   650,   187,     0,   188,   651,   652,   189,
       0,     0,   190,   653,   654,     0,   191,   655,   656,     0,
     192,   193,   194,   657,   658,   659,     0,     0,     0,     0,
     660,   197,   661,     0,     0,   662,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,   663,     0,
     222,   223,   224,   664,   665,   225,   226,     0,   227,   228,
     229,   666,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   667,   236,   668,   238,     0,   239,
       0,   669,     0,   240,   241,     0,   242,   670,     0,   243,
     244,     0,     0,     0,   671,   246,   247,   248,   672,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,   673,
     253,   254,   674,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,   675,   264,   265,     0,     0,     0,
       0,     0,   676,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,   677,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,   678,   288,   289,   290,   291,
     679,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   680,   299,     0,     0,   681,   301,   682,   302,     0,
     303,   683,   684,   685,   686,   687,   308,   309,   310,   311,
     312,     0,   688,   313,   314,     0,     0,   315,   316,   317,
     318,   689,   690,   691,   319,   320,     0,   692,   693,     0,
     321,   322,   694,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,   695,   331,   332,   333,   334,   335,   696,   337,   338,
     339,   697,   698,   342,   699,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   700,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,   701,   702,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,   703,
     377,   378,   379,   380,   381,   704,   383,   384,   385,   386,
       0,   705,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,   706,   707,   411,
     412,     0,   413,   414,   708,   416,   417,   418,   709,   710,
     419,   420,   421,   422,   711,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   712,   429,   430,     0,   713,   714,
     715,   716,     0,     0,     0,     0,     0,   435,   436,     0,
     717,   718,   719,   438,   439,   440,   720,   441,   442,   721,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   722,   451,     0,     0,   723,   724,
     725,   726,   452,     0,     0,   453,   727,     0,   728,   454,
     455,   456,   729,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   730,     0,     0,
       0,   731,   732,     0,     0,     0,     0,   733,   734,  1502,
       0,   735,   736,     0,     0,   737,   738,   135,     0,   636,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
       0,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,  2090,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,   674,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,   690,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,     0,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   636,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   637,     0,
     143,   144,   145,   146,   147,   638,   149,     0,   150,     0,
       0,   639,   151,   640,   641,   642,   152,   643,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     644,   645,   160,   161,     0,   162,   646,   647,   164,     0,
     165,   166,   167,   168,   648,   170,     0,   649,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   650,   187,     0,   188,   651,
     652,   189,     0,     0,   190,   653,   654,     0,   191,   655,
     656,     0,   192,   193,   194,   657,   658,   659,     0,     0,
       0,     0,   660,   197,   661,     0,     0,   662,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
     663,     0,   222,   223,   224,   664,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
    2092,   232,     0,   233,     0,   234,   667,   236,   668,   238,
       0,   239,     0,   669,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   671,   246,   247,   248,
     672,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,   673,   253,   254,   674,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,   675,   264,   265,     0,
       0,     0,     0,     0,   676,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,   678,   288,   289,
     290,   291,   679,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   680,   299,     0,     0,   681,   301,   682,
     302,     0,   303,   683,   684,   685,   686,   687,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,   689,   690,   691,   319,   320,     0,   692,
     693,     0,   321,   322,   694,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,   695,   331,   332,   333,   334,   335,   696,
     337,   338,   339,   697,   698,   342,   699,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     700,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,   701,   702,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,   703,   377,   378,   379,   380,   381,   704,   383,   384,
     385,   386,     0,   705,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,   706,
     707,   411,   412,     0,   413,   414,   708,   416,   417,   418,
     709,   710,   419,   420,   421,   422,   711,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
     713,   714,   715,   716,     0,     0,     0,     0,     0,   435,
     436,     0,   717,   718,   719,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   722,   451,     0,     0,
     723,   724,   725,   726,   452,     0,     0,   453,   727,     0,
     728,   454,   455,   456,   729,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   730,
       0,     0,     0,   731,   732,     0,     0,     0,     0,   733,
     734,     0,     0,   735,   736,     0,     0,   737,   738,   135,
       0,   636,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   637,     0,   143,   144,   145,   146,
     147,   638,   149,     0,   150,     0,     0,   639,   151,   640,
     641,   642,   152,   643,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   644,   645,   160,   161,
       0,   162,   646,   647,   164,     0,   165,   166,   167,   168,
     648,   170,     0,   649,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   650,   187,     0,   188,   651,   652,   189,     0,     0,
     190,   653,   654,     0,   191,   655,   656,     0,   192,   193,
     194,   657,   658,   659,     0,     0,     0,     0,   660,   197,
     661,     0,     0,   662,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,   663,     0,   222,   223,
     224,   664,   665,   225,   226,     0,   227,   228,   229,   666,
       0,   230,     0,     0,     0,   231,  2094,   232,     0,   233,
       0,   234,   667,   236,   668,   238,     0,   239,     0,   669,
       0,   240,   241,     0,   242,   670,     0,   243,   244,     0,
       0,     0,   671,   246,   247,   248,   672,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,   673,   253,   254,
     674,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,   675,   264,   265,     0,     0,     0,     0,     0,
     676,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,   677,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,   678,   288,   289,   290,   291,   679,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   680,
     299,     0,     0,   681,   301,   682,   302,     0,   303,   683,
     684,   685,   686,   687,   308,   309,   310,   311,   312,     0,
     688,   313,   314,     0,     0,   315,   316,   317,   318,   689,
     690,   691,   319,   320,     0,   692,   693,     0,   321,   322,
     694,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,   695,
     331,   332,   333,   334,   335,   696,   337,   338,   339,   697,
     698,   342,   699,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   700,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,   701,   702,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,   703,   377,   378,
     379,   380,   381,   704,   383,   384,   385,   386,     0,   705,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,   706,   707,   411,   412,     0,
     413,   414,   708,   416,   417,   418,   709,   710,   419,   420,
     421,   422,   711,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   712,   429,   430,     0,   713,   714,   715,   716,
       0,     0,     0,     0,     0,   435,   436,     0,   717,   718,
     719,   438,   439,   440,   720,   441,   442,   721,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   722,   451,     0,     0,   723,   724,   725,   726,
     452,     0,     0,   453,   727,     0,   728,   454,   455,   456,
     729,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   730,     0,     0,     0,   731,
     732,     0,     0,     0,     0,   733,   734,     0,     0,   735,
     736,     0,     0,   737,   738,   135,     0,   636,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     637,     0,   143,   144,   145,   146,   147,   638,   149,     0,
     150,     0,     0,   639,   151,   640,   641,   642,   152,   643,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   644,   645,   160,   161,     0,   162,   646,   647,
     164,     0,   165,   166,   167,   168,   648,   170,     0,   649,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   650,   187,     0,
     188,   651,   652,   189,     0,     0,   190,   653,   654,     0,
     191,   655,   656,     0,   192,   193,   194,   657,   658,   659,
       0,     0,     0,     0,   660,   197,   661,     0,     0,   662,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,   663,     0,   222,   223,   224,   664,   665,   225,
     226,     0,   227,   228,   229,   666,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   667,   236,
     668,   238,     0,   239,     0,   669,     0,   240,   241,     0,
     242,   670,     0,   243,   244,     0,     0,     0,   671,   246,
     247,   248,   672,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,   673,   253,   254,   674,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,   675,   264,
     265,     0,     0,     0,     0,     0,   676,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,   677,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,   678,
     288,   289,   290,   291,   679,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   680,   299,     0,     0,   681,
     301,   682,   302,     0,   303,   683,   684,   685,   686,   687,
     308,   309,   310,   311,   312,     0,   688,   313,   314,     0,
       0,   315,   316,   317,   318,   689,   690,   691,   319,   320,
       0,   692,   693,     0,   321,   322,   694,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,   695,   331,   332,   333,   334,
     335,   696,   337,   338,   339,   697,   698,   342,   699,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   700,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
     701,   702,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,   703,   377,   378,   379,   380,   381,   704,
     383,   384,   385,   386,     0,   705,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,   706,   707,   411,   412,     0,   413,   414,   708,   416,
     417,   418,   709,   710,   419,   420,   421,   422,   711,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   712,   429,
     430,     0,   713,   714,   715,   716,     0,     0,     0,     0,
       0,   435,   436,     0,   717,   718,   719,   438,   439,   440,
     720,   441,   442,   721,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   722,   451,
       0,     0,   723,   724,   725,   726,   452,     0,     0,   453,
     727,     0,   728,   454,   455,   456,   729,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   730,     0,     0,     0,   731,   732,     0,     0,     0,
       0,   733,   734,     0,     0,   735,   736,     0,     0,   737,
     738,   135,     0,   636,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   637,     0,   143,   144,
     145,   146,   147,   638,   149,     0,   150,     0,     0,   639,
     151,   640,   641,   642,   152,   643,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   644,   645,
     160,   161,     0,   162,   646,   647,   164,     0,   165,   166,
     167,   168,   648,   170,     0,   649,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   650,   187,     0,   188,   651,   652,   189,
       0,     0,   190,   653,   654,     0,   191,   655,   656,     0,
     192,   193,   194,   657,   658,   659,     0,     0,     0,     0,
     660,   197,   661,     0,     0,   662,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,   663,     0,
     222,   223,   224,   664,   665,   225,   226,     0,   227,   228,
     229,   666,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   667,   236,   668,   238,     0,   239,
       0,   669,     0,   240,   241,     0,   242,   670,     0,   243,
     244,     0,     0,     0,   671,   246,   247,   248,   672,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,   673,
     253,   254,   674,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,   675,   264,   265,     0,     0,     0,
       0,     0,   676,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,   677,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,   678,   288,   289,   290,   291,
     679,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   680,   299,     0,     0,   681,   301,   682,   302,     0,
     303,   683,   684,   685,   686,   687,   308,   309,   310,   311,
     312,     0,   688,   313,   314,     0,     0,   315,   316,   317,
     318,   689,   690,   691,   319,   320,     0,   692,   693,     0,
     321,   322,   694,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,   695,   331,   332,   333,   334,   335,   696,   337,   338,
     339,   697,   698,   342,   699,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   700,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,   701,   702,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,   703,
     377,   378,   379,   380,   381,   704,   383,   384,   385,   386,
       0,   705,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,   706,   707,   411,
     412,     0,   413,   414,   708,   416,   417,   418,   709,   710,
     419,   420,   421,   422,   711,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   712,   429,   430,     0,   713,   714,
     715,   716,     0,     0,     0,     0,     0,   435,   436,     0,
     717,   718,   719,   438,   439,   440,   720,   441,   442,   721,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   722,   451,     0,     0,   723,   724,
     725,   726,   452,     0,     0,   453,   727,     0,   728,   454,
     455,   456,   729,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   730,     0,     0,
       0,   731,   732,     0,     0,     0,     0,   733,  1061,     0,
       0,   735,   736,     0,     0,   737,   738,   135,     0,   636,
     137,   138,   139,   140,  1620,     0,     0,     0,     0,  1621,
       0,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
       0,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,   674,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,     0,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,     0,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   636,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   637,     0,
     143,   144,   145,   146,   147,   638,   149,     0,   150,     0,
       0,   639,   151,   640,   641,   642,   152,   643,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     644,   645,   160,   161,     0,   162,   646,   647,   164,     0,
     165,   166,   167,   168,   648,   170,     0,   649,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   650,   187,     0,   188,   651,
     652,   189,     0,     0,   190,   653,   654,     0,   191,   655,
     656,     0,   192,   193,   194,   657,   658,   659,     0,     0,
       0,     0,   660,   197,   661,     0,     0,   662,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
     663,     0,   222,   223,   224,   664,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   667,   236,   668,   238,
       0,   239,     0,   669,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   671,   246,   247,   248,
     672,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,   673,   253,   254,  2503,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,   675,   264,   265,     0,
       0,     0,     0,     0,   676,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,   678,   288,   289,
     290,   291,   679,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   680,   299,     0,     0,   681,   301,   682,
     302,     0,   303,   683,   684,   685,   686,   687,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,   689,   690,   691,   319,   320,     0,   692,
     693,     0,   321,   322,   694,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,   695,   331,   332,   333,   334,   335,   696,
     337,   338,   339,   697,   698,   342,   699,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     700,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,   701,   702,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,   703,   377,   378,   379,   380,   381,   704,   383,   384,
     385,   386,     0,   705,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,   706,
     707,   411,   412,     0,   413,   414,   708,   416,   417,   418,
     709,   710,   419,   420,   421,   422,   711,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
     713,   714,   715,   716,     0,     0,     0,     0,     0,   435,
     436,     0,   717,   718,   719,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   722,   451,     0,     0,
     723,   724,   725,   726,   452,     0,     0,   453,   727,     0,
     728,   454,   455,   456,   729,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   730,
       0,     0,     0,   731,   732,     0,     0,     0,     0,   733,
     734,     0,     0,   735,   736,     0,     0,   737,   738,   135,
       0,   636,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   637,     0,   143,   144,   145,   146,
     147,   638,   149,     0,   150,     0,     0,   639,   151,   640,
     641,   642,   152,   643,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   644,   645,   160,   161,
       0,   162,   646,   647,   164,     0,   165,   166,   167,   168,
     648,   170,     0,   649,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   650,   187,     0,   188,   651,   652,   189,     0,     0,
     190,   653,   654,     0,   191,   655,   656,     0,   192,   193,
     194,   657,   658,   659,     0,     0,     0,     0,   660,   197,
     661,     0,     0,   662,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,   663,     0,   222,   223,
     224,   664,   665,   225,   226,     0,   227,   228,   229,   666,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   667,   236,   668,   238,     0,   239,     0,   669,
       0,   240,   241,     0,   242,   670,     0,   243,   244,     0,
       0,     0,   671,   246,   247,   248,   672,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,   673,   253,   254,
    2549,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,   675,   264,   265,     0,     0,     0,     0,     0,
     676,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,   677,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,   678,   288,   289,   290,   291,   679,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   680,
     299,     0,     0,   681,   301,   682,   302,     0,   303,   683,
     684,   685,   686,   687,   308,   309,   310,   311,   312,     0,
     688,   313,   314,     0,     0,   315,   316,   317,   318,   689,
     690,   691,   319,   320,     0,   692,   693,     0,   321,   322,
     694,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,   695,
     331,   332,   333,   334,   335,   696,   337,   338,   339,   697,
     698,   342,   699,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   700,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,   701,   702,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,   703,   377,   378,
     379,   380,   381,   704,   383,   384,   385,   386,     0,   705,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,   706,   707,   411,   412,     0,
     413,   414,   708,   416,   417,   418,   709,   710,   419,   420,
     421,   422,   711,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   712,   429,   430,     0,   713,   714,   715,   716,
       0,     0,     0,     0,     0,   435,   436,     0,   717,   718,
     719,   438,   439,   440,   720,   441,   442,   721,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   722,   451,     0,     0,   723,   724,   725,   726,
     452,     0,     0,   453,   727,     0,   728,   454,   455,   456,
     729,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   730,     0,     0,     0,   731,
     732,     0,     0,     0,     0,   733,   734,     0,     0,   735,
     736,     0,     0,   737,   738,   135,     0,   636,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     637,     0,   143,   144,   145,   146,   147,   638,   149,     0,
     150,     0,     0,   639,   151,   640,   641,   642,   152,   643,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   644,   645,   160,   161,     0,   162,   646,   647,
     164,     0,   165,   166,   167,   168,   648,   170,     0,   649,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   650,   187,     0,
     188,   651,   652,   189,     0,     0,   190,   653,   654,     0,
     191,   655,   656,     0,   192,   193,   194,   657,   658,   659,
       0,     0,     0,     0,   660,   197,   661,     0,     0,  3258,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,   663,     0,   222,   223,   224,   664,   665,   225,
     226,     0,   227,   228,   229,   666,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   667,   236,
     668,   238,     0,   239,     0,   669,     0,   240,   241,     0,
     242,   670,     0,   243,   244,     0,     0,     0,   671,   246,
     247,   248,   672,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,   673,   253,   254,   674,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,   675,   264,
     265,     0,     0,     0,     0,     0,   676,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,   677,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,   678,
     288,   289,   290,   291,   679,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   680,   299,     0,     0,   681,
     301,   682,   302,     0,   303,   683,   684,   685,   686,   687,
     308,   309,   310,   311,   312,     0,   688,   313,   314,     0,
       0,   315,   316,   317,   318,   689,   690,   691,   319,   320,
       0,   692,   693,     0,   321,   322,   694,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,   695,   331,   332,   333,   334,
     335,   696,   337,   338,   339,   697,   698,   342,   699,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   700,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
     701,   702,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,   703,   377,   378,   379,   380,   381,   704,
     383,   384,   385,   386,     0,   705,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,   706,   707,   411,   412,     0,   413,   414,   708,   416,
     417,   418,   709,   710,   419,   420,   421,   422,   711,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   712,   429,
     430,     0,   713,   714,   715,   716,     0,     0,     0,     0,
       0,   435,   436,     0,   717,   718,   719,   438,   439,   440,
     720,   441,   442,   721,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   722,   451,
       0,     0,   723,   724,   725,   726,   452,     0,     0,   453,
     727,     0,   728,   454,   455,   456,   729,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   730,     0,     0,     0,   731,   732,     0,     0,     0,
       0,   733,   734,     0,     0,   735,   736,     0,     0,   737,
     738,   135,     0,   636,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   637,     0,   143,   144,
     145,   146,   147,   638,   149,     0,   150,     0,     0,   639,
     151,   640,   641,   642,   152,   643,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   644,   645,
     160,   161,     0,   162,   646,   647,   164,     0,   165,   166,
     167,   168,   648,   170,     0,   649,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   650,   187,     0,   188,   651,   652,   189,
       0,     0,   190,   653,   654,     0,   191,   655,   656,     0,
     192,   193,   194,   657,   658,   659,     0,     0,     0,     0,
     660,   197,   661,     0,     0,   662,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,   663,     0,
     222,   223,   224,   664,   665,   225,   226,     0,   227,   228,
     229,   666,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   667,   236,   668,   238,     0,   239,
       0,   669,     0,   240,   241,     0,   242,   670,     0,   243,
     244,     0,     0,     0,   671,   246,   247,   248,   672,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,   673,
     253,   254,   674,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,   675,   264,   265,     0,     0,     0,
       0,     0,   676,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,   677,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,   678,   288,   289,   290,   291,
     679,   292,   293,  4091,     0,     0,     0,   294,   295,   296,
     297,   680,   299,     0,     0,   681,   301,   682,   302,     0,
     303,   683,   684,   685,   686,   687,   308,   309,   310,   311,
     312,     0,   688,   313,   314,     0,     0,   315,   316,   317,
     318,   689,     0,   691,   319,   320,     0,   692,   693,     0,
     321,   322,   694,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,   695,   331,   332,   333,   334,   335,   696,   337,   338,
     339,   697,   698,   342,   699,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   700,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,   701,   702,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,   703,
     377,   378,   379,   380,   381,   704,   383,   384,   385,   386,
       0,   705,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,   706,   707,   411,
     412,     0,   413,   414,   708,   416,   417,   418,   709,   710,
     419,   420,   421,   422,   711,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   712,   429,   430,     0,   713,   714,
     715,   716,     0,     0,     0,     0,     0,   435,   436,     0,
     717,   718,   719,   438,   439,   440,   720,   441,   442,   721,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   722,   451,     0,     0,   723,   724,
     725,   726,   452,     0,     0,   453,   727,     0,   728,   454,
     455,   456,   729,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   730,     0,     0,
       0,   731,   732,     0,     0,     0,     0,   733,   734,     0,
       0,   735,   736,     0,     0,   737,   738,   135,     0,   636,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
       0,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,   674,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,     0,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,     0,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   636,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   637,     0,
     143,   144,   145,   146,   147,   638,   149,     0,   150,     0,
       0,   639,   151,   640,   641,   642,   152,   643,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     644,   645,   160,   161,     0,   162,   646,   647,   164,     0,
     165,   166,   167,   168,   648,   170,     0,   649,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   650,   187,     0,   188,   651,
     652,   189,     0,     0,   190,   653,   654,     0,   191,   655,
     656,     0,   192,   193,   194,   657,   658,   659,     0,     0,
       0,     0,   660,   197,   661,     0,     0,   662,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
     663,     0,   222,   223,   224,   664,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   667,   236,   668,   238,
       0,   239,     0,   669,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   671,   246,   247,   248,
     672,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,   673,   253,   254,  1635,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,   675,   264,   265,     0,
       0,     0,     0,     0,   676,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,   678,   288,   289,
     290,   291,   679,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   680,   299,     0,     0,   681,   301,   682,
     302,     0,   303,   683,   684,   685,   686,   687,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,   689,     0,   691,   319,   320,     0,   692,
     693,     0,   321,   322,   694,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,   695,   331,   332,   333,   334,   335,   696,
     337,   338,   339,   697,   698,   342,   699,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     700,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,   701,   702,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,   703,   377,   378,   379,   380,   381,   704,   383,   384,
     385,   386,     0,   705,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,   706,
     707,   411,   412,     0,   413,   414,   708,   416,   417,   418,
     709,   710,   419,   420,   421,   422,   711,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
     713,   714,   715,   716,     0,     0,     0,     0,     0,   435,
     436,     0,   717,   718,   719,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   722,   451,     0,     0,
     723,   724,   725,   726,   452,     0,     0,   453,   727,     0,
     728,   454,   455,   456,   729,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   730,
       0,     0,     0,   731,   732,     0,     0,     0,     0,   733,
     734,     0,     0,   735,   736,     0,     0,   737,   738,   135,
       0,   636,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   637,     0,   143,   144,   145,   146,
     147,   638,   149,     0,   150,     0,     0,   639,   151,   640,
     641,   642,   152,   643,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   644,   645,   160,   161,
       0,   162,   646,   647,   164,     0,   165,   166,   167,   168,
     648,   170,     0,   649,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   650,   187,     0,   188,   651,   652,   189,     0,     0,
     190,   653,   654,     0,   191,   655,   656,     0,   192,   193,
     194,   657,   658,   659,     0,     0,     0,     0,   660,   197,
     661,     0,     0,   662,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,   663,     0,   222,   223,
     224,   664,   665,   225,   226,     0,   227,   228,   229,   666,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   667,   236,   668,   238,     0,   239,     0,   669,
       0,   240,   241,     0,   242,   670,     0,   243,   244,     0,
       0,     0,   671,   246,   247,   248,   672,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,   673,   253,   254,
    1637,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,   675,   264,   265,     0,     0,     0,     0,     0,
     676,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,   677,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,   678,   288,   289,   290,   291,   679,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   680,
     299,     0,     0,   681,   301,   682,   302,     0,   303,   683,
     684,   685,   686,   687,   308,   309,   310,   311,   312,     0,
     688,   313,   314,     0,     0,   315,   316,   317,   318,   689,
       0,   691,   319,   320,     0,   692,   693,     0,   321,   322,
     694,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,   695,
     331,   332,   333,   334,   335,   696,   337,   338,   339,   697,
     698,   342,   699,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   700,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,   701,   702,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,   703,   377,   378,
     379,   380,   381,   704,   383,   384,   385,   386,     0,   705,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,   706,   707,   411,   412,     0,
     413,   414,   708,   416,   417,   418,   709,   710,   419,   420,
     421,   422,   711,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   712,   429,   430,     0,   713,   714,   715,   716,
       0,     0,     0,     0,     0,   435,   436,     0,   717,   718,
     719,   438,   439,   440,   720,   441,   442,   721,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   722,   451,     0,     0,   723,   724,   725,   726,
     452,     0,     0,   453,   727,     0,   728,   454,   455,   456,
     729,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   730,     0,     0,     0,   731,
     732,     0,     0,     0,     0,   733,   734,     0,     0,   735,
     736,     0,     0,   737,   738,   135,     0,   136,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     142,     0,   143,   144,   145,   146,   147,   148,   149,     0,
     150,     0,     0,     0,   151,   640,     0,     0,   152,     0,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,     0,     0,   160,   161,     0,   162,   163,     0,
     164,     0,   165,   166,   167,   168,   169,   170,     0,   171,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   186,   187,     0,
     188,     0,     0,   189,     0,     0,   190,     0,     0,     0,
     191,     0,     0,     0,   192,   193,   194,     0,     0,  2235,
       0,     0,     0,     0,   196,   197,   661,     0,     0,     0,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,     0,     0,   222,   223,   224,     0,   665,   225,
     226,     0,   227,   228,   229,   666,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   235,   236,
     237,   238,     0,   239,     0,     0,     0,   240,   241,     0,
     242,   670,     0,   243,   244,     0,     0,     0,   245,   246,
     247,   248,     0,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,     0,   253,   254,     0,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,     0,   264,
     265,     0,     0,     0,     0,     0,   266,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,   677,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,     0,
     288,   289,   290,   291,     0,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   298,   299,     0,     0,   300,
     301,     0,   302,     0,   303,     0,   304,   305,   306,   307,
     308,   309,   310,   311,   312,     0,   688,   313,   314,     0,
       0,   315,   316,   317,   318,     0,     0,     0,   319,   320,
       0,   692,   693,     0,   321,   322,   323,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,     0,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,     0,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   352,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
       0,     0,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,     0,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,     0,     0,   411,   412,     0,   413,   414,   415,   416,
     417,   418,     0,     0,   419,   420,   421,   422,     0,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   712,   429,
     430,     0,  2236,   432,   433,  2237,     0,     0,     0,     0,
       0,   435,   436,     0,     0,   718,   437,   438,   439,   440,
     720,   441,   442,   721,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   450,   451,
       0,     0,     0,     0,     0,     0,   452,     0,     0,   453,
       0,     0,     0,   454,   455,   456,   457,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,     0,     0,     0,   135,     0,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,   737,
     738,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,  2348,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,   477,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,  1936,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,  1937,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,  2874,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,  2875,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,  -436,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,   480,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,     0,   463,     0,     0,   135,     0,   136,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     142,  2413,   143,   144,   145,   146,   147,   148,   149,     0,
     150,     0,     0,     0,   151,     0,     0,     0,   152,     0,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,     0,     0,   160,   161,     0,   162,   163,     0,
     164,     0,   165,   166,   167,   168,   169,   170,     0,   171,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,  2348,   183,   184,   185,   186,   187,     0,
     188,     0,     0,   189,     0,     0,   190,     0,     0,     0,
     191,     0,     0,     0,   192,   193,   194,     0,     0,   195,
       0,     0,     0,     0,   196,   197,     0,     0,     0,     0,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,     0,     0,   222,   223,   224,     0,     0,   225,
     226,     0,   227,   228,   229,     0,     0,   230,     0,     0,
       0,   231,     0,   232,   477,   233,     0,   234,   235,   236,
     237,   238,     0,   239,     0,     0,     0,   240,   241,     0,
     242,     0,     0,   243,   244,     0,     0,     0,   245,   246,
     247,   248,     0,     0,   249,   250,   251,  1936,     0,   252,
       0,     0,     0,     0,   253,   254,     0,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
    1937,     0,   261,   262,     0,     0,   263,     0,     0,   264,
     265,     0,     0,     0,     0,     0,   266,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,     0,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,     0,
     288,   289,   290,   291,     0,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   298,   299,     0,     0,   300,
     301,     0,   302,     0,   303,     0,   304,   305,   306,   307,
     308,   309,   310,   311,   312,     0,     0,   313,   314,     0,
       0,   315,   316,   317,   318,     0,     0,     0,   319,   320,
       0,     0,     0,     0,   321,   322,   323,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,     0,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,     0,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   352,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
       0,     0,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,     0,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,   480,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,     0,     0,   411,   412,     0,   413,   414,   415,   416,
     417,   418,     0,     0,   419,   420,   421,   422,     0,   423,
     424,     0,     0,   425,   426,   427,   428,     0,     0,   429,
     430,     0,   431,   432,   433,   434,     0,     0,     0,     0,
       0,   435,   436,     0,     0,     0,   437,   438,   439,   440,
       0,   441,   442,     0,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   450,   451,
       0,     0,     0,     0,     0,     0,   452,     0,     0,   453,
       0,     0,     0,   454,   455,   456,   457,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,     0,   135,     0,   136,   137,   138,   139,
     140,     0,     0,     0,     0,     0,   141,     0,     0,   142,
    2413,   143,   144,   145,   146,   147,   148,   149,     0,   150,
       0,     0,     0,   151,     0,     0,     0,   152,     0,     0,
     153,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,   161,     0,   162,   163,     0,   164,
       0,   165,   166,   167,   168,   169,   170,     0,   171,   172,
       0,   173,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   183,   184,   185,   186,   187,     0,   188,
       0,     0,   189,     0,     0,   190,     0,     0,     0,   191,
       0,     0,     0,   192,   193,   194,     0,     0,   195,     0,
       0,     0,     0,   196,   197,     0,     0,     0,     0,   198,
       0,   199,     0,     0,     0,   200,     0,   201,   202,   203,
     204,     0,     0,     0,   205,     0,     0,   206,   207,   208,
       0,     0,     0,   209,     0,   210,   211,     0,   212,   213,
     214,     0,     0,   215,   216,     0,   217,   218,   219,   220,
     221,     0,     0,   222,   223,   224,     0,     0,   225,   226,
       0,   227,   228,   229,     0,     0,   230,     0,     0,     0,
     231,     0,   232,     0,   233,     0,   234,   235,   236,   237,
     238,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,     0,   243,   244,     0,     0,     0,   245,   246,   247,
     248,     0,     0,   249,   250,   251,     0,     0,   252,     0,
       0,     0,     0,   253,   254,     0,     0,     0,   255,     0,
     256,   257,     0,   258,   259,     0,     0,     0,   260,     0,
       0,   261,   262,     0,     0,   263,     0,     0,   264,   265,
       0,     0,     0,     0,     0,   266,   267,     0,   268,     0,
     269,     0,   270,   271,     0,     0,     0,     0,     0,     0,
       0,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,     0,   285,   286,   287,     0,   288,
     289,   290,   291,     0,   292,   293,     0,     0,     0,     0,
     294,   295,   296,   297,   298,   299,     0,     0,   300,   301,
       0,   302,     0,   303,     0,   304,   305,   306,   307,   308,
     309,   310,   311,   312,     0,     0,   313,   314,     0,     0,
     315,   316,   317,   318,     0,     0,     0,   319,   320,     0,
       0,     0,     0,   321,   322,   323,     0,   324,   325,   326,
       0,   327,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,   329,   330,     0,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,     0,     0,   343,
     344,   345,     0,   346,     0,   347,   348,   349,   350,   351,
       0,   352,   353,   354,     0,     0,   355,     0,     0,     0,
     356,   357,   358,   359,   360,     0,     0,   361,   362,   363,
     364,   365,     0,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,   372,     0,   373,   374,     0,   375,   376,
       0,     0,     0,   377,   378,   379,   380,   381,   382,   383,
     384,   385,   386,     0,   387,   388,  2226,     0,     0,   389,
     390,   391,   392,     0,     0,     0,   393,     0,     0,     0,
     394,     0,   395,   396,   397,   398,     0,   399,   400,   401,
     402,   403,     0,     0,     0,     0,     0,     0,   404,   405,
       0,   406,     0,     0,   407,     0,     0,   408,   409,   410,
       0,     0,   411,   412,     0,   413,   414,   415,   416,   417,
     418,     0,     0,   419,   420,   421,   422,     0,   423,   424,
       0,     0,   425,   426,   427,   428,     0,     0,   429,   430,
       0,   431,   432,   433,   434,     0,     0,     0,     0,     0,
     435,   436,     0,     0,     0,   437,   438,   439,   440,     0,
     441,   442,     0,   443,   444,     0,   445,   446,     0,     0,
     447,     0,     0,   448,     0,   449,     0,   450,   451,     0,
       0,     0,     0,     0,     0,   452,     0,     0,   453,     0,
       0,     0,   454,   455,   456,   457,     0,     0,     0,     0,
       0,     0,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,     0,   135,     0,   136,   137,   138,   139,   140,
       0,     0,  2642,     0,     0,   141,     0,     0,   142,   738,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,     0,     0,     0,   135,     0,   136,   137,   138,   139,
     140,  4215,     0,     0,     0,     0,   141,  4216,   738,   142,
       0,   143,   144,   145,   146,   147,   148,   149,     0,   150,
       0,     0,     0,   151,     0,     0,     0,   152,     0,     0,
     153,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,   161,     0,   162,   163,     0,   164,
       0,   165,   166,   167,   168,   169,   170,     0,   171,   172,
       0,   173,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,     0,   183,   184,   185,   186,   187,     0,   188,
       0,     0,   189,     0,     0,   190,     0,     0,     0,   191,
       0,     0,     0,   192,   193,   194,     0,     0,   195,     0,
       0,     0,     0,   196,   197,     0,     0,     0,     0,   198,
       0,   199,     0,     0,     0,   200,     0,   201,   202,   203,
     204,     0,     0,     0,   205,     0,     0,   206,   207,   208,
       0,     0,     0,   209,     0,   210,   211,     0,   212,   213,
     214,     0,     0,   215,   216,     0,   217,   218,   219,   220,
     221,     0,     0,   222,   223,   224,     0,     0,   225,   226,
       0,   227,   228,   229,     0,     0,   230,     0,     0,     0,
     231,     0,   232,     0,   233,     0,   234,   235,   236,   237,
     238,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,     0,   243,   244,     0,     0,     0,   245,   246,   247,
     248,     0,     0,   249,   250,   251,     0,     0,   252,     0,
       0,     0,     0,   253,   254,     0,     0,     0,   255,     0,
     256,   257,     0,   258,   259,     0,     0,     0,   260,     0,
       0,   261,   262,     0,     0,   263,     0,     0,   264,   265,
       0,     0,     0,     0,     0,   266,   267,     0,   268,     0,
     269,     0,   270,   271,     0,     0,     0,     0,     0,     0,
       0,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,     0,   285,   286,   287,     0,   288,
     289,   290,   291,     0,   292,   293,     0,     0,     0,     0,
     294,   295,   296,   297,   298,   299,     0,     0,   300,   301,
       0,   302,     0,   303,     0,   304,   305,   306,   307,   308,
     309,   310,   311,   312,     0,     0,   313,   314,     0,     0,
     315,   316,   317,   318,     0,     0,     0,   319,   320,     0,
       0,     0,     0,   321,   322,   323,     0,   324,   325,   326,
       0,   327,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,   329,   330,     0,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,     0,     0,   343,
     344,   345,     0,   346,     0,   347,   348,   349,   350,   351,
       0,   352,   353,   354,     0,     0,   355,     0,     0,     0,
     356,   357,   358,   359,   360,     0,     0,   361,   362,   363,
     364,   365,     0,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,   372,     0,   373,   374,     0,   375,   376,
       0,     0,     0,   377,   378,   379,   380,   381,   382,   383,
     384,   385,   386,     0,   387,   388,     0,     0,     0,   389,
     390,   391,   392,     0,     0,     0,   393,     0,     0,     0,
     394,     0,   395,   396,   397,   398,     0,   399,   400,   401,
     402,   403,     0,     0,     0,     0,     0,     0,   404,   405,
       0,   406,     0,     0,   407,     0,     0,   408,   409,   410,
       0,     0,   411,   412,     0,   413,   414,   415,   416,   417,
     418,     0,     0,   419,   420,   421,   422,     0,   423,   424,
       0,     0,   425,   426,   427,   428,     0,     0,   429,   430,
       0,   431,   432,   433,   434,     0,     0,     0,     0,     0,
     435,   436,     0,     0,     0,   437,   438,   439,   440,     0,
     441,   442,     0,   443,   444,     0,   445,   446,     0,     0,
     447,     0,     0,   448,     0,   449,     0,   450,   451,     0,
       0,     0,     0,     0,     0,   452,     0,     0,   453,     0,
       0,     0,   454,   455,   456,   457,     0,     0,     0,     0,
       0,     0,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,     0,   135,     0,   136,   137,   138,   139,   140,
       0,  1065,     0,     0,     0,   141,     0,     0,   142,   738,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,  1258,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,     0,   135,     0,   136,   137,   138,   139,   140,     0,
       0,     0,     0,     0,   141,     0,     0,   142,   511,   143,
     144,   145,   146,   147,   148,   149,     0,   150,     0,     0,
       0,   151,     0,     0,     0,   152,     0,     0,   153,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,   161,     0,   162,   163,     0,   164,     0,   165,
     166,   167,   168,   169,   170,     0,   171,   172,     0,   173,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,   185,   186,   187,     0,   188,     0,     0,
     189,     0,     0,   190,     0,     0,     0,   191,     0,     0,
       0,   192,   193,   194,     0,     0,   195,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,   198,     0,   199,
       0,     0,     0,   200,     0,   201,   202,   203,   204,     0,
       0,     0,   205,     0,     0,   206,   207,   208,     0,     0,
       0,   209,     0,   210,   211,     0,   212,   213,   214,     0,
       0,   215,   216,     0,   217,   218,   219,   220,   221,     0,
       0,   222,   223,   224,     0,     0,   225,   226,     0,   227,
     228,   229,     0,     0,   230,     0,     0,     0,   231,     0,
     232,     0,   233,     0,   234,   235,   236,   237,   238,     0,
     239,     0,     0,     0,   240,   241,     0,   242,     0,     0,
     243,   244,     0,     0,     0,   245,   246,   247,   248,     0,
       0,   249,   250,   251,     0,     0,   252,     0,     0,     0,
       0,   253,   254,     0,     0,     0,   255,     0,   256,   257,
       0,   258,   259,     0,     0,     0,   260,     0,     0,   261,
     262,     0,     0,   263,     0,     0,   264,   265,     0,     0,
       0,     0,     0,   266,   267,     0,   268,     0,   269,     0,
     270,   271,     0,     0,     0,     0,     0,     0,     0,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,     0,   285,   286,   287,     0,   288,   289,   290,
     291,     0,   292,   293,     0,     0,     0,     0,   294,   295,
     296,   297,   298,   299,     0,     0,   300,   301,     0,   302,
       0,   303,     0,   304,   305,   306,   307,   308,   309,   310,
     311,   312,     0,     0,   313,   314,     0,     0,   315,   316,
     317,   318,     0,     0,     0,   319,   320,     0,     0,     0,
       0,   321,   322,   323,     0,   324,   325,   326,     0,   327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,   343,   344,   345,
       0,   346,     0,   347,   348,   349,   350,   351,     0,   352,
     353,   354,     0,     0,   355,     0,     0,     0,   356,   357,
     358,   359,   360,     0,     0,   361,   362,   363,   364,   365,
       0,   366,   367,     0,   368,   369,   370,     0,     0,   371,
       0,   372,     0,   373,   374,     0,   375,   376,     0,     0,
       0,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,   389,   390,   391,
     392,     0,     0,     0,   393,     0,     0,     0,   394,     0,
     395,   396,   397,   398,     0,   399,   400,   401,   402,   403,
       0,     0,     0,     0,     0,     0,   404,   405,     0,   406,
       0,     0,   407,     0,     0,   408,   409,   410,     0,     0,
     411,   412,     0,   413,   414,   415,   416,   417,   418,     0,
       0,   419,   420,   421,   422,     0,   423,   424,     0,     0,
     425,   426,   427,   428,     0,     0,   429,   430,     0,   431,
     432,   433,   434,     0,     0,     0,     0,     0,   435,   436,
       0,     0,     0,   437,   438,   439,   440,     0,   441,   442,
       0,   443,   444,     0,   445,   446,     0,     0,   447,     0,
       0,   448,     0,   449,     0,   450,   451,     0,     0,     0,
       0,     0,     0,   452,     0,     0,   453,     0,     0,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,     0,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
       0,     0,     0,   135,  2167,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,   511,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,     0,   135,     0,   136,   137,   138,   139,   140,     0,
    2412,     0,     0,     0,   141,     0,     0,   142,  2413,   143,
     144,   145,   146,   147,   148,   149,     0,   150,     0,     0,
       0,   151,     0,     0,     0,   152,     0,     0,   153,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,   161,     0,   162,   163,     0,   164,     0,   165,
     166,   167,   168,   169,   170,     0,   171,   172,     0,   173,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,   185,   186,   187,     0,   188,     0,     0,
     189,     0,     0,   190,     0,     0,     0,   191,     0,     0,
       0,   192,   193,   194,     0,     0,   195,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,   198,     0,   199,
       0,     0,     0,   200,     0,   201,   202,   203,   204,     0,
       0,     0,   205,     0,     0,   206,   207,   208,     0,     0,
       0,   209,     0,   210,   211,     0,   212,   213,   214,     0,
       0,   215,   216,     0,   217,   218,   219,   220,   221,     0,
       0,   222,   223,   224,     0,     0,   225,   226,     0,   227,
     228,   229,     0,     0,   230,     0,     0,     0,   231,     0,
     232,     0,   233,     0,   234,   235,   236,   237,   238,     0,
     239,     0,     0,     0,   240,   241,     0,   242,     0,     0,
     243,   244,     0,     0,     0,   245,   246,   247,   248,     0,
       0,   249,   250,   251,     0,     0,   252,     0,     0,     0,
       0,   253,   254,     0,     0,     0,   255,     0,   256,   257,
       0,   258,   259,     0,     0,     0,   260,     0,     0,   261,
     262,     0,     0,   263,     0,     0,   264,   265,     0,     0,
       0,     0,     0,   266,   267,     0,   268,     0,   269,     0,
     270,   271,     0,     0,     0,     0,     0,     0,     0,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,     0,   285,   286,   287,     0,   288,   289,   290,
     291,     0,   292,   293,     0,     0,     0,     0,   294,   295,
     296,   297,   298,   299,     0,     0,   300,   301,     0,   302,
       0,   303,     0,   304,   305,   306,   307,   308,   309,   310,
     311,   312,     0,     0,   313,   314,     0,     0,   315,   316,
     317,   318,     0,     0,     0,   319,   320,     0,     0,     0,
       0,   321,   322,   323,     0,   324,   325,   326,     0,   327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,   343,   344,   345,
       0,   346,     0,   347,   348,   349,   350,   351,     0,   352,
     353,   354,     0,     0,   355,     0,     0,     0,   356,   357,
     358,   359,   360,     0,     0,   361,   362,   363,   364,   365,
       0,   366,   367,     0,   368,   369,   370,     0,     0,   371,
       0,   372,     0,   373,   374,     0,   375,   376,     0,     0,
       0,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,   389,   390,   391,
     392,     0,     0,     0,   393,     0,     0,     0,   394,     0,
     395,   396,   397,   398,     0,   399,   400,   401,   402,   403,
       0,     0,     0,     0,     0,     0,   404,   405,     0,   406,
       0,     0,   407,     0,     0,   408,   409,   410,     0,     0,
     411,   412,     0,   413,   414,   415,   416,   417,   418,     0,
       0,   419,   420,   421,   422,     0,   423,   424,     0,     0,
     425,   426,   427,   428,     0,     0,   429,   430,     0,   431,
     432,   433,   434,     0,     0,     0,     0,     0,   435,   436,
       0,     0,     0,   437,   438,   439,   440,     0,   441,   442,
       0,   443,   444,     0,   445,   446,     0,     0,   447,     0,
       0,   448,     0,   449,     0,   450,   451,     0,     0,     0,
       0,     0,     0,   452,     0,     0,   453,     0,     0,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,     0,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
       0,     0,     0,   135,     0,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,  4216,   738,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,     0,   135,     0,   136,   137,   138,   139,   140,     0,
       0,     0,     0,     0,   141,     0,     0,   142,   511,   143,
     144,   145,   146,   147,   148,   149,     0,   150,     0,     0,
       0,   151,     0,     0,     0,   152,     0,     0,   153,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,   161,     0,   162,   163,     0,   164,     0,   165,
     166,   167,   168,   169,   170,     0,   171,   172,     0,   173,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,   185,   186,   187,     0,   188,     0,     0,
     189,     0,     0,   190,     0,     0,     0,   191,     0,     0,
       0,   192,   193,   194,     0,     0,   195,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,   198,     0,   199,
       0,     0,     0,   200,     0,   201,   202,   203,   204,     0,
       0,     0,   205,     0,     0,   206,   207,   208,     0,     0,
       0,   209,     0,   210,   211,     0,   212,   213,   214,     0,
       0,   215,   216,     0,   217,   218,   219,   220,   221,     0,
       0,   222,   577,   224,     0,     0,   225,   226,     0,   227,
     228,   229,     0,     0,   230,     0,     0,     0,   231,     0,
     232,     0,   233,     0,   234,   235,   236,   237,   238,     0,
     239,     0,     0,     0,   240,   241,     0,   242,     0,     0,
     243,   244,     0,     0,     0,   245,   246,   247,   248,     0,
       0,   249,   250,   251,     0,     0,   252,     0,     0,     0,
       0,   253,   254,     0,     0,     0,   255,     0,   256,   257,
       0,   258,   259,     0,     0,     0,   260,     0,     0,   261,
     262,     0,     0,   263,     0,     0,   264,   265,     0,     0,
       0,     0,     0,   266,   267,     0,   268,     0,   269,     0,
     270,   271,     0,     0,     0,     0,     0,     0,     0,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,     0,   285,   286,   287,     0,   288,   289,   290,
     291,     0,   292,   293,     0,     0,     0,     0,   294,   295,
     296,   297,   298,   299,     0,     0,   300,   301,     0,   302,
       0,   303,     0,   304,   305,   306,   307,   308,   309,   310,
     311,   312,     0,     0,   313,   314,     0,     0,   315,   316,
     317,   318,     0,     0,     0,   319,   320,     0,     0,     0,
       0,   321,   322,   323,     0,   324,   325,   326,     0,   327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   578,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,   343,   344,   345,
       0,   346,     0,   347,   348,   349,   350,   351,     0,   352,
     353,   354,     0,     0,   355,     0,     0,     0,   356,   357,
     358,   359,   360,     0,     0,   361,   362,   363,   364,   365,
       0,   366,   367,     0,   368,   369,   370,     0,     0,   371,
       0,   372,     0,   373,   374,     0,   375,   376,     0,     0,
       0,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,   389,   390,   391,
     392,     0,     0,     0,   393,     0,     0,     0,   394,     0,
     395,   396,   397,   398,     0,   399,   400,   401,   402,   403,
       0,     0,     0,     0,     0,     0,   404,   405,     0,   406,
       0,     0,   407,     0,     0,   408,   409,   410,     0,     0,
     411,   412,     0,   413,   414,   415,   416,   417,   418,     0,
       0,   419,   420,   421,   422,     0,   423,   424,     0,     0,
     425,   426,   427,   428,     0,     0,   429,   430,     0,   431,
     432,   433,   434,     0,     0,     0,     0,     0,   435,   436,
       0,     0,     0,   437,   438,   439,   440,     0,   441,   442,
       0,   443,   444,     0,   445,   446,     0,     0,   447,     0,
       0,   448,     0,   449,     0,   450,   451,     0,     0,     0,
       0,     0,     0,   452,     0,     0,   453,     0,     0,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,     0,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
       0,   135,     0,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,   511,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,     0,
     135,     0,   136,   137,   138,   139,   140,     0,     0,     0,
       0,     0,   141,     0,     0,   142,   738,   143,   144,   145,
     146,   147,   148,   149,     0,   150,     0,     0,     0,   151,
       0,     0,     0,   152,     0,     0,   153,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
     161,     0,   162,   163,     0,   164,     0,   165,   166,   167,
     168,   169,   170,     0,   171,   172,     0,   173,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,   185,   186,   187,     0,   188,     0,     0,   189,     0,
       0,   190,     0,     0,     0,   191,     0,     0,     0,   192,
     193,   194,     0,     0,   195,     0,     0,     0,     0,   196,
     197,     0,     0,     0,     0,   198,     0,   199,     0,     0,
       0,   200,     0,   201,   202,   203,   204,     0,     0,     0,
     205,     0,     0,   206,   207,   208,     0,     0,     0,   209,
       0,   210,   211,     0,   212,   213,   214,     0,     0,   215,
     216,     0,   217,   218,   219,   220,   221,     0,     0,   222,
     223,   224,     0,     0,   225,   226,     0,   227,   228,   229,
       0,     0,   230,     0,     0,     0,   231,     0,   232,     0,
     233,     0,   234,   235,   236,   237,   238,     0,   239,     0,
       0,     0,   240,   241,     0,   242,     0,     0,   243,   244,
       0,     0,     0,   245,   246,   247,   248,     0,     0,   249,
     250,   251,     0,     0,   252,     0,     0,     0,     0,   253,
     254,     0,     0,     0,   255,     0,   256,   257,     0,   258,
     259,     0,     0,     0,   260,     0,     0,   261,   262,     0,
       0,   263,     0,     0,   264,   265,     0,     0,     0,     0,
       0,   266,   267,     0,   268,     0,   269,     0,   270,   271,
       0,     0,     0,     0,     0,     0,     0,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
       0,   285,   286,   287,     0,   288,   289,   290,   291,     0,
     292,   293,     0,     0,     0,     0,   294,   295,   296,   297,
     298,   299,     0,     0,   300,   301,     0,   302,     0,   303,
       0,   304,   305,   306,   307,   308,   309,   310,   311,   312,
       0,     0,   313,   314,     0,     0,   315,   316,   317,   318,
       0,     0,     0,   319,   320,     0,     0,     0,     0,   321,
     322,   323,     0,   324,   325,   326,     0,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,   329,   330,
       0,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,   343,   344,   345,     0,   346,
       0,   347,   348,   349,   350,   351,     0,   352,   353,   354,
       0,     0,   355,     0,     0,     0,   356,   357,   358,   359,
     360,     0,     0,   361,   362,   363,   364,   365,     0,   366,
     367,     0,   368,   369,   370,     0,     0,   371,     0,   372,
       0,   373,   374,     0,   375,   376,     0,     0,     0,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,   389,   390,   391,   392,     0,
       0,     0,   393,     0,     0,     0,   394,     0,   395,   396,
     397,   398,     0,   399,   400,   401,   402,   403,     0,     0,
       0,     0,     0,     0,   404,   405,     0,   406,     0,     0,
     407,     0,     0,   408,   409,   410,     0,     0,   411,   412,
       0,   413,   414,   415,   416,   417,   418,     0,     0,   419,
     420,   421,   422,     0,   423,   424,     0,     0,   425,   426,
     427,   428,     0,     0,   429,   430,     0,   431,   432,   433,
     434,     0,     0,     0,     0,     0,   435,   436,     0,     0,
       0,   437,   438,   439,   440,     0,   441,   442,     0,   443,
     444,     0,   445,   446,     0,     0,   447,     0,     0,   448,
       0,   449,     0,   450,   451,     0,     0,     0,     0,     0,
       0,   452,     0,     0,   453,     0,     0,     0,   454,   455,
     456,   457,     0,     0,     0,     0,     0,     0,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,     0,   135,
       0,   136,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   142,  2413,   143,   144,   145,   146,
     147,   148,   149,     0,   150,     0,     0,     0,   151,     0,
       0,     0,   152,     0,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,     0,     0,   160,   161,
       0,   162,   163,     0,   164,     0,   165,   166,   167,   168,
     169,   170,     0,   171,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   186,   187,     0,   188,     0,     0,   189,     0,     0,
     190,     0,     0,     0,   191,     0,     0,     0,   192,   193,
     194,     0,     0,   195,     0,     0,     0,     0,   196,   197,
       0,     0,     0,     0,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,     0,     0,   222,   223,
     224,     0,     0,   225,   226,     0,   227,   228,   229,     0,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   235,   236,   237,   238,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,     0,   243,   244,     0,
       0,     0,   245,   246,   247,   248,     0,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,     0,   253,   254,
       0,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,     0,   264,   265,   589,     0,     0,     0,     0,
     266,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,     0,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,     0,   288,   289,   290,   291,     0,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   298,
     299,     0,     0,   300,   301,     0,   302,     0,   303,     0,
     304,   305,   306,   307,   308,   309,   310,   311,   312,     0,
       0,   313,   314,     0,     0,   315,   316,   317,   318,     0,
       0,     0,   319,   320,     0,     0,     0,     0,   321,   322,
     323,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,     0,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,     0,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   352,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,     0,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,     0,   387,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,     0,     0,   411,   412,     0,
     413,   414,   415,   416,   417,   418,     0,     0,   419,   420,
     421,   422,     0,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   132,   429,   430,     0,   431,   432,   433,   434,
       0,     0,     0,     0,     0,   435,   436,     0,     0,     0,
     437,   438,   439,   440,     0,   441,   442,     0,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   450,   451,     0,     0,     0,     0,     0,     0,
     452,     0,     0,   453,     0,     0,     0,   454,   455,   456,
     457,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,   135,     0,   136,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   142,  1607,   143,   144,   145,   146,   147,   148,
     149,     0,   150,     0,     0,     0,   151,     0,     0,     0,
     152,     0,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,     0,     0,   160,   161,     0,   162,
     163,     0,   164,     0,   165,   166,   167,   168,   169,   170,
       0,   171,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   186,
     187,     0,   188,     0,     0,   189,     0,     0,   190,     0,
       0,     0,   191,     0,     0,     0,   192,   193,   194,     0,
       0,   195,     0,     0,     0,     0,   196,   197,     0,     0,
       0,     0,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,     0,     0,   222,   223,   224,     0,
       0,   225,   226,     0,   227,   228,   229,     0,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     235,   236,   237,   238,     0,   239,     0,     0,     0,   240,
     241,     0,   242,     0,     0,   243,   244,     0,     0,     0,
     245,   246,   247,   248,     0,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,     0,   253,   254,     0,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
       0,   264,   265,   589,     0,     0,     0,     0,   266,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,     0,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,     0,   288,   289,   290,   291,     0,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   298,   299,     0,
       0,   300,   301,     0,   302,     0,   303,     0,   304,   305,
     306,   307,   308,   309,   310,   311,   312,     0,     0,   313,
     314,     0,     0,   315,   316,   317,   318,     0,     0,     0,
     319,   320,     0,     0,     0,     0,   321,   322,   323,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,     0,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
       0,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   352,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,     0,     0,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,     0,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,     0,     0,   411,   412,     0,   413,   414,
     415,   416,   417,   418,     0,     0,   419,   420,   421,   422,
       0,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     132,   429,   430,     0,   431,   432,   433,   434,     0,     0,
       0,     0,     0,   435,   436,     0,     0,     0,   437,   438,
     439,   440,     0,   441,   442,     0,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     450,   451,     0,     0,     0,     0,     0,     0,   452,     0,
       0,   453,     0,     0,     0,   454,   455,   456,   457,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   135,     0,   136,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     142,  2682,   143,   144,   145,   146,   147,   148,   149,     0,
     150,     0,     0,     0,   151,     0,     0,     0,   152,     0,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,     0,     0,   160,   161,     0,   162,   163,     0,
     164,     0,   165,   166,   167,   168,   169,   170,     0,   171,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   186,   187,     0,
     188,     0,     0,   189,     0,     0,   190,     0,     0,     0,
     191,     0,     0,     0,   192,   193,   194,     0,     0,   195,
       0,     0,     0,     0,   196,   197,     0,     0,     0,     0,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,     0,     0,   222,   223,   224,     0,     0,   225,
     226,     0,   227,   228,   229,     0,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   235,   236,
     237,   238,     0,   239,     0,     0,     0,   240,   241,     0,
     242,     0,     0,   243,   244,     0,     0,     0,   245,   246,
     247,   248,     0,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,     0,   253,   254,     0,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,     0,   264,
     265,   589,     0,     0,     0,     0,   266,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,     0,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,     0,
     288,   289,   290,   291,     0,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   298,   299,     0,     0,   300,
     301,     0,   302,     0,   303,     0,   304,   305,   306,   307,
     308,   309,   310,   311,   312,     0,     0,   313,   314,     0,
       0,   315,   316,   317,   318,     0,     0,     0,   319,   320,
       0,     0,     0,     0,   321,   322,   323,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,     0,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,     0,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   352,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
       0,     0,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,     0,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,     0,     0,   411,   412,     0,   413,   414,   415,   416,
     417,   418,     0,     0,   419,   420,   421,   422,     0,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   132,   429,
     430,     0,   431,   432,   433,   434,     0,     0,     0,     0,
       0,   435,   436,     0,     0,     0,   437,   438,   439,   440,
       0,   441,   442,     0,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   450,   451,
       0,     0,     0,     0,     0,     0,   452,     0,     0,   453,
       0,     0,     0,   454,   455,   456,   457,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   135,     0,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,     0,  3290,
     143,   144,   145,   146,   147,   148,     0,     0,  -327,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,     0,     0,     0,     0,   159,
    3701,     0,   160,   161,     0,   162,     0,     0,     0,     0,
     165,   166,   167,  3702,   169,   170,     0,   171,   172,     0,
     173,     0,   175,     0,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,     0,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,     0,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,     0,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,     0,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,     0,
       0,     0,   222,   223,   224,     0,     0,   225,   226,  3703,
     227,   228,   229,     0,     0,     0,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,     0,   241,     0,     0,     0,
       0,     0,   244,     0,     0,     0,   245,   246,   247,   248,
    3704,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,     0,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,  3705,     0,     0,   260,     0,     0,
       0,   262,     0,     0,   263,  3706,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,  -282,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,     0,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,  3707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   329,   330,     0,     0,   332,   333,   334,     0,   336,
     337,   338,   339,   340,   341,     0,     0,     0,     0,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,     0,     0,   368,     0,   370,  -282,     0,
     371,     0,     0,     0,   373,     0,     0,   375,   376,  3708,
       0,     0,     0,   378,   379,   380,   381,   382,   383,     0,
     385,   386,     0,   387,     0,     0,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   393,     0,     0,     0,   394,
       0,     0,   396,     0,   398,     0,   399,     0,     0,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,     0,   410,     0,
       0,     0,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,     0,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,     0,     0,     0,     0,   447,
       0,     0,   448,     0,     0,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,  -282,     0,     0,
       0,   458,     0,     0,   460,     0,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,  4222,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
    2006,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,  2670,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
    2972,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,  3295,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,  2327,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,  2328,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,  2329,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
    2330,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,   981,   982,
       0,   319,   320,     0,     0,  2331,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,  4202,   536,
    4203,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,  2332,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,  2521,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,  2676,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
    2149,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,   589,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,  2150,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   132,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
    1767,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,  1768,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,   695,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,  1769,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,  2684,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,  2685,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,   589,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   132,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,  2521,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,  2676,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,   589,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,   132,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,   940,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,   589,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   132,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,  1311,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,   589,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,   132,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,   918,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,   919,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   920,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,  2521,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,   589,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,   132,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,  2724,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,   589,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   132,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,   589,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,   132,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,  2666,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   132,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,  4120,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,  4121,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,   536,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,  1017,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,  1929,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,  2260,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,  2261,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
    2762,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,  2840,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   132,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,  2260,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,     0,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,  1688,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,  1689,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,     0,     0,
     143,   144,   145,   146,   147,   148,     0,     0,  -327,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,     0,     0,     0,     0,   159,
    3701,     0,   160,   161,     0,   162,     0,     0,     0,     0,
     165,   166,   167,  3702,   169,   170,     0,   171,   172,     0,
     173,     0,   175,     0,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,     0,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,     0,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,     0,     0,     0,   206,   207,   208,     0,
    -297,  -297,   209,     0,  -297,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,     0,
       0,     0,   222,   223,   224,     0,     0,   225,   226,  3703,
     227,   228,   229,     0,     0,     0,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,     0,   241,     0,     0,     0,
       0,     0,   244,     0,     0,     0,   245,   246,   247,   248,
    3704,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,     0,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,  3705,     0,     0,   260,     0,     0,
       0,   262,     0,     0,   263,  3706,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,  -282,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,     0,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,  3707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   329,   330,     0,     0,   332,   333,   334,     0,   336,
     337,   338,   339,   340,   341,     0,     0,     0,     0,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,     0,     0,   368,     0,   370,  -282,     0,
     371,     0,     0,     0,   373,     0,     0,   375,   376,  3708,
       0,     0,     0,   378,   379,   380,   381,   382,   383,     0,
     385,   386,     0,   387,     0,     0,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   393,     0,     0,     0,   394,
       0,     0,   396,     0,   398,     0,   399,     0,     0,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,     0,   410,     0,
       0,     0,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,     0,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,     0,     0,     0,     0,   447,
       0,     0,   448,     0,     0,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,  -282,     0,     0,
       0,   458,     0,     0,   460,     0,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,     0,     0,   143,   144,   145,   146,   147,
     148,     0,     0,  -327,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
       0,     0,     0,     0,   159,  3701,     0,   160,   161,     0,
     162,     0,     0,     0,     0,   165,   166,   167,  3702,   169,
     170,     0,   171,   172,     0,   173,     0,   175,     0,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
       0,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,     0,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,     0,     0,
       0,   206,   207,   208,     0,  -318,     0,   209,     0,  -318,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,     0,     0,     0,   222,   223,   224,
       0,     0,   225,   226,  3703,   227,   228,   229,     0,     0,
       0,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
       0,   241,     0,     0,     0,     0,     0,   244,     0,     0,
       0,   245,   246,   247,   248,  3704,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,     0,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,  3705,
       0,     0,   260,     0,     0,     0,   262,     0,     0,   263,
    3706,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,  -282,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,     0,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,  3707,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,   330,     0,     0,
     332,   333,   334,     0,   336,   337,   338,   339,   340,   341,
       0,     0,     0,     0,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,     0,     0,
     368,     0,   370,  -282,     0,   371,     0,     0,     0,   373,
       0,     0,   375,   376,  3708,     0,     0,     0,   378,   379,
     380,   381,   382,   383,     0,   385,   386,     0,   387,     0,
       0,     0,     0,   389,   390,   391,     0,     0,     0,     0,
     393,     0,     0,     0,   394,     0,     0,   396,     0,   398,
       0,   399,     0,     0,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,     0,   410,     0,     0,     0,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,     0,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
       0,     0,     0,     0,   447,     0,     0,   448,     0,     0,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
    -318,     0,  -282,     0,     0,     0,   458,     0,     0,   460,
       0,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,     0,     0,
     143,   144,   145,   146,   147,   148,     0,     0,  -327,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,     0,     0,     0,     0,   159,
    3701,     0,   160,   161,     0,   162,     0,     0,     0,     0,
     165,   166,   167,  3702,   169,   170,     0,   171,   172,     0,
     173,     0,   175,     0,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,     0,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,     0,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,     0,     0,     0,   206,   207,   208,     0,
    -315,     0,   209,     0,  -315,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,     0,
       0,     0,   222,   223,   224,     0,     0,   225,   226,  3703,
     227,   228,   229,     0,     0,     0,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,     0,   241,     0,     0,     0,
       0,     0,   244,     0,     0,     0,   245,   246,   247,   248,
    3704,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,     0,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,  3705,     0,     0,   260,     0,     0,
       0,   262,     0,     0,   263,  3706,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,  -282,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,     0,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,  3707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   329,   330,     0,     0,   332,   333,   334,     0,   336,
     337,   338,   339,   340,   341,     0,     0,     0,     0,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,     0,     0,   368,     0,   370,  -282,     0,
     371,     0,     0,     0,   373,     0,     0,   375,   376,  3708,
       0,     0,     0,   378,   379,   380,   381,   382,   383,     0,
     385,   386,     0,   387,     0,     0,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   393,     0,     0,     0,   394,
       0,     0,   396,     0,   398,     0,   399,     0,     0,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,     0,   410,     0,
       0,     0,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,     0,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,     0,     0,     0,     0,   447,
       0,     0,   448,     0,     0,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,  -315,     0,  -282,     0,     0,
       0,   458,     0,     0,   460,     0,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,     0,     0,   143,   144,   145,   146,   147,
     148,     0,     0,  -327,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
       0,     0,     0,     0,   159,  3701,     0,   160,   161,     0,
     162,     0,     0,     0,     0,   165,   166,   167,  3702,   169,
     170,     0,   171,   172,     0,   173,     0,   175,     0,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
       0,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,     0,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,     0,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,  4018,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,     0,     0,     0,   222,   223,   224,
       0,     0,   225,   226,  3703,   227,   228,   229,     0,     0,
       0,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
       0,   241,     0,     0,     0,     0,     0,   244,     0,     0,
       0,   245,   246,   247,   248,  3704,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,     0,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,  3705,
       0,     0,   260,     0,     0,     0,   262,     0,     0,   263,
    3706,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,  -282,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,     0,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,  3707,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,   330,     0,     0,
     332,   333,   334,     0,   336,   337,   338,   339,   340,   341,
       0,     0,     0,     0,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,     0,     0,
     368,     0,   370,  -282,     0,   371,     0,     0,     0,   373,
       0,     0,   375,   376,  3708,     0,     0,     0,   378,   379,
     380,   381,   382,   383,     0,   385,   386,     0,   387,     0,
       0,     0,     0,   389,   390,   391,     0,     0,     0,     0,
     393,     0,     0,     0,   394,     0,     0,   396,     0,   398,
       0,   399,     0,     0,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,     0,   410,     0,     0,     0,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,     0,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
       0,     0,     0,     0,   447,     0,     0,   448,     0,     0,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,  -282,     0,     0,     0,   458,     0,     0,   460,
       0,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,     0,     0,
     143,   144,   145,   146,   147,   148,     0,     0,  -327,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,     0,     0,     0,     0,   159,
    3701,     0,   160,   161,     0,   162,     0,     0,     0,     0,
     165,   166,   167,  3702,   169,   170,     0,   171,   172,     0,
     173,     0,   175,     0,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,     0,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,     0,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,     0,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,  -320,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,     0,
       0,     0,   222,   223,   224,     0,     0,   225,   226,  3703,
     227,   228,   229,     0,     0,     0,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,     0,   241,     0,     0,     0,
       0,     0,   244,     0,     0,     0,   245,   246,   247,   248,
    3704,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,     0,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,  3705,     0,     0,   260,     0,     0,
       0,   262,     0,     0,   263,  3706,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,  -282,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,     0,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,  3707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   329,   330,     0,     0,   332,   333,   334,     0,   336,
     337,   338,   339,   340,   341,     0,     0,     0,     0,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,     0,     0,   368,     0,   370,  -282,     0,
     371,     0,     0,     0,   373,     0,     0,   375,   376,  3708,
       0,     0,     0,   378,   379,   380,   381,   382,   383,     0,
     385,   386,     0,   387,     0,     0,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   393,     0,     0,     0,   394,
       0,     0,   396,     0,   398,     0,   399,     0,     0,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,     0,   410,     0,
       0,     0,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,     0,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,     0,     0,     0,     0,   447,
       0,     0,   448,     0,     0,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,  -282,     0,     0,
       0,   458,     0,     0,   460,     0,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,     0,     0,   143,   144,   145,   146,   147,
     148,     0,     0,  -327,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
       0,     0,     0,     0,   159,  3701,     0,   160,   161,     0,
     162,     0,     0,     0,     0,   165,   166,   167,  3702,   169,
     170,     0,   171,   172,     0,   173,     0,   175,     0,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
       0,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,     0,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,     0,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,  4125,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,     0,     0,     0,   222,   223,   224,
       0,     0,   225,   226,  3703,   227,   228,   229,     0,     0,
       0,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
       0,   241,     0,     0,     0,     0,     0,   244,     0,     0,
       0,   245,   246,   247,   248,  3704,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,     0,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,  3705,
       0,     0,   260,     0,     0,     0,   262,     0,     0,   263,
    3706,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,  -282,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,     0,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,  3707,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,   330,     0,     0,
     332,   333,   334,     0,   336,   337,   338,   339,   340,   341,
       0,     0,     0,     0,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,     0,     0,
     368,     0,   370,  -282,     0,   371,     0,     0,     0,   373,
       0,     0,   375,   376,  3708,     0,     0,     0,   378,   379,
     380,   381,   382,   383,     0,   385,   386,     0,   387,     0,
       0,     0,     0,   389,   390,   391,     0,     0,     0,     0,
     393,     0,     0,     0,   394,     0,     0,   396,     0,   398,
       0,   399,     0,     0,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,     0,   410,     0,     0,     0,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,     0,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
       0,     0,     0,     0,   447,     0,     0,   448,     0,     0,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,  -282,     0,     0,     0,   458,     0,     0,   460,
       0,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,     0,     0,
     143,   144,   145,   146,   147,   148,     0,     0,  -327,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,     0,     0,     0,     0,   159,
    3701,     0,   160,   161,     0,   162,     0,     0,     0,     0,
     165,   166,   167,  3702,   169,   170,     0,   171,   172,     0,
     173,     0,   175,     0,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,     0,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,     0,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,     0,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,  4171,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,     0,
       0,     0,   222,   223,   224,     0,     0,   225,   226,  3703,
     227,   228,   229,     0,     0,     0,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,     0,   241,     0,     0,     0,
       0,     0,   244,     0,     0,     0,   245,   246,   247,   248,
    3704,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,     0,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,  3705,     0,     0,   260,     0,     0,
       0,   262,     0,     0,   263,  3706,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,  -282,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,     0,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,  3707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   329,   330,     0,     0,   332,   333,   334,     0,   336,
     337,   338,   339,   340,   341,     0,     0,     0,     0,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,     0,     0,   368,     0,   370,  -282,     0,
     371,     0,     0,     0,   373,     0,     0,   375,   376,  3708,
       0,     0,     0,   378,   379,   380,   381,   382,   383,     0,
     385,   386,     0,   387,     0,     0,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   393,     0,     0,     0,   394,
       0,     0,   396,     0,   398,     0,   399,     0,     0,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,     0,   410,     0,
       0,     0,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,     0,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,     0,     0,     0,     0,   447,
       0,     0,   448,     0,     0,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,  -282,     0,     0,
       0,   458,     0,     0,   460,     0,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,     0,     0,   143,   144,   145,   146,   147,
     148,     0,     0,  -327,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
       0,     0,     0,     0,   159,  3701,     0,   160,   161,     0,
     162,     0,     0,     0,     0,   165,   166,   167,  3702,   169,
     170,     0,   171,   172,     0,   173,     0,   175,     0,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
       0,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,     0,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,     0,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,  -301,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,     0,     0,     0,   222,   223,   224,
       0,     0,   225,   226,  3703,   227,   228,   229,     0,     0,
       0,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
       0,   241,     0,     0,     0,     0,     0,   244,     0,     0,
       0,   245,   246,   247,   248,  3704,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,     0,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,  3705,
       0,     0,   260,     0,     0,     0,   262,     0,     0,   263,
    3706,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,  -282,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,     0,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,  3707,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,   330,     0,     0,
     332,   333,   334,     0,   336,   337,   338,   339,   340,   341,
       0,     0,     0,     0,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,     0,     0,
     368,     0,   370,  -282,     0,   371,     0,     0,     0,   373,
       0,     0,   375,   376,  3708,     0,     0,     0,   378,   379,
     380,   381,   382,   383,     0,   385,   386,     0,   387,     0,
       0,     0,     0,   389,   390,   391,     0,     0,     0,     0,
     393,     0,     0,     0,   394,     0,     0,   396,     0,   398,
       0,   399,     0,     0,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,     0,   410,     0,     0,     0,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,     0,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
       0,     0,     0,     0,   447,     0,     0,   448,     0,     0,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,  -282,     0,     0,     0,   458,     0,     0,   460,
       0,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,     0,     0,
     143,   144,   145,   146,   147,   148,     0,     0,  -327,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,     0,     0,     0,     0,   159,
    3701,     0,   160,   161,     0,   162,     0,     0,     0,     0,
     165,   166,   167,  3702,   169,   170,     0,   171,   172,     0,
     173,     0,   175,     0,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,     0,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,     0,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,     0,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,     0,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,     0,
       0,     0,   222,   223,   224,     0,     0,   225,   226,  3703,
     227,   228,   229,     0,     0,     0,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,     0,   241,     0,     0,     0,
       0,     0,   244,     0,     0,     0,   245,   246,   247,   248,
    3704,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,     0,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,  3705,     0,     0,   260,     0,     0,
       0,   262,     0,     0,   263,  3706,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,  -282,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,     0,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,  3707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   329,   330,     0,     0,   332,   333,   334,     0,   336,
     337,   338,   339,   340,   341,     0,     0,     0,     0,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,     0,     0,   368,     0,   370,  -282,     0,
     371,     0,     0,     0,   373,     0,     0,   375,   376,  3708,
       0,     0,     0,   378,   379,   380,   381,   382,   383,     0,
     385,   386,     0,   387,     0,     0,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   393,     0,     0,     0,   394,
       0,     0,   396,     0,   398,     0,   399,     0,     0,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,     0,   410,     0,
       0,     0,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,     0,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,     0,     0,     0,     0,   447,
       0,     0,   448,     0,     0,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,  -282,     0,     0,
       0,   458,     0,     0,   460,     0,   462,     0,   135,   463,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,     0,     0,   143,   144,   145,   146,   147,
     148,     0,     0,  -327,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
       0,     0,     0,     0,   159,  3701,     0,   160,   161,     0,
     162,     0,     0,     0,     0,   165,   166,   167,  3702,   169,
     170,     0,   171,   172,     0,   173,     0,   175,     0,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
       0,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,     0,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,     0,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,     0,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,     0,     0,     0,   222,   223,   224,
       0,     0,   225,   226,  3703,   227,   228,   229,     0,     0,
       0,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
       0,   241,     0,     0,     0,     0,     0,   244,     0,     0,
       0,   245,   246,   247,   248,  3704,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,     0,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,  3705,
       0,     0,   260,     0,     0,     0,   262,     0,     0,   263,
    3706,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,  -282,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,     0,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,  3707,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   329,   330,     0,     0,
     332,   333,   334,     0,   336,   337,   338,   339,   340,   341,
       0,     0,     0,     0,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,     0,     0,
     368,     0,   370,  -282,     0,   371,     0,     0,     0,   373,
       0,     0,   375,   376,  3708,     0,     0,     0,   378,   379,
     380,   381,   382,   383,     0,   385,   386,     0,   387,     0,
       0,     0,     0,   389,   390,   391,     0,     0,     0,     0,
     393,     0,     0,     0,   394,     0,     0,   396,     0,   398,
       0,   399,     0,     0,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,     0,   410,     0,     0,     0,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,     0,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
       0,     0,     0,     0,   447,     0,     0,  4021,     0,     0,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,  -282,     0,     0,     0,   458,     0,     0,   460,
       0,   462,     0,   135,   463,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,     0,     0,
     143,   144,   145,   146,   147,   148,     0,     0,     0,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,     0,     0,     0,     0,   159,
       0,     0,   160,   161,     0,   162,     0,     0,     0,     0,
     165,   166,   167,     0,   169,   170,     0,   171,   172,     0,
     173,     0,   175,     0,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,     0,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,     0,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,     0,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,     0,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,     0,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,     0,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,     0,   241,     0,     0,     0,
       0,     0,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,     0,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
       0,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,     0,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   329,   330,     0,     0,   332,   333,   334,     0,   336,
     337,   338,   339,   340,   341,     0,     0,     0,     0,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,     0,     0,   368,     0,   370,     0,     0,
     371,     0,     0,     0,   373,     0,     0,   375,   376,     0,
       0,     0,     0,   378,   379,   380,   381,   382,   383,     0,
     385,   386,     0,   387,     0,     0,     0,     0,   389,   390,
     391,     0,     0,     0,     0,   393,     0,     0,     0,   394,
       0,     0,   396,     0,   398,     0,   399,     0,     0,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,     0,   410,     0,
       0,     0,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,     0,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,     0,     0,     0,     0,   447,
       0,     0,   448,     0,     0,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,     0,     0,   460,     0,   462,     0,     0,   463
};

static const yytype_int16 yycheck[] =
{
       6,   621,   622,   612,   549,   549,   934,   571,   933,    20,
     850,  1739,   121,    19,  1115,   659,    22,  1604,    29,  1021,
    1413,   874,   769,  1062,    35,    31,     6,   678,  1707,   585,
    1086,   639,    38,  1314,   494,    41,  1015,  1016,  1115,    45,
    2263,  2264,  2265,  1239,   876,  1726,   899,    53,  1957,   654,
     655,  2379,  1411,  1137,  2230,   898,  2022,  1178,  2185,  3064,
    1144,  2027,  2309,  1376,  2701,  2649,   898,   938,  1402,   713,
    1053,  2498,   716,   608,   609,  1394,  2297,  1245,  2001,  1920,
     938,  1865,    22,  2484,  1867,  1865,   691,    93,  1726,  1145,
    1146,  2114,     4,  1149,  1150,  1151,  1152,  2832,  1154,  1155,
    1156,  1157,  1158,  1159,  1160,  1161,   711,  2274,  2275,   115,
    1796,   117,  2374,  1982,   120,   121,   122,  3070,   723,   724,
     725,  1820,  1821,   731,   732,   733,  2253,  1868,   626,  3280,
    2512,  1872,  2157,   742,  2516,   743,  1455,   117,  1837,  2290,
     120,  1325,  1883,  1982,    33,    16,  1384,  2298,    18,  2353,
      50,    24,  1893,    93,  3088,  1854,  1855,    70,    16,  1343,
    3127,  3128,    18,   833,  3131,    15,    16,  1351,  1352,     9,
    1857,  1870,  1871,   105,  1873,    58,    59,  1876,  1877,    15,
      16,  1880,    18,  3150,  2954,    20,  1885,  1737,    28,  3156,
    1889,  1890,  1891,  1892,    34,  1971,    61,  1896,  1982,  1898,
     900,    35,  1982,  2166,   103,  1904,    59,    46,  1907,  1811,
    1909,   165,  2515,    20,  2486,   771,    29,  3327,    73,    18,
     142,    15,    16,    58,    59,    68,    33,  2338,  2339,   178,
     252,   155,   185,  1848,  2460,    57,   165,    64,  2642,  3737,
      47,  2752,    73,   297,   914,   152,    15,    16,    81,    50,
    2567,    58,    59,   183,    15,    16,   204,    62,    24,    33,
      35,   136,   356,   339,   213,  2826,  3823,  1966,  1967,  1968,
    1969,  3276,   828,  1394,   165,   138,   303,   148,   148,   127,
    2243,  2005,   152,   369,    73,   217,    15,    16,   255,    79,
     130,    15,    16,    15,    16,   121,   152,    15,    16,    24,
     423,    55,   119,   237,   371,   269,  3854,    73,   403,   614,
     490,    20,   286,   173,   179,   131,   385,    15,    16,   121,
    3324,  1839,    15,    16,    33,   518,    15,    16,  1943,   120,
     447,   148,    39,  1948,  1455,   940,   119,    74,    47,  1954,
    1955,  2452,  2453,   165,  1959,   213,   219,   169,   338,    58,
      59,  3969,   123,   152,  3972,    15,    16,   198,   180,  2282,
    3858,  2108,   119,   485,   142,   148,   398,   201,   123,   148,
     479,    15,    16,   993,   994,   995,   202,    15,    16,   253,
     198,    15,    16,   243,   239,   180,   336,   419,   549,   569,
      80,   148,   518,    15,    16,   182,  3363,  3498,   217,   240,
     166,  1052,    15,    16,   509,  3372,   515,   512,   239,    99,
     142,    15,    16,    67,  1065,   484,   609,   217,   450,   393,
     293,   240,   240,   413,  3391,   150,   201,   962,  1175,  3396,
     235,   381,   385,  3534,   213,    10,  1364,   367,   229,   322,
     394,    67,   603,   230,   270,    15,    16,    62,  2342,   544,
     239,   518,   223,   219,    15,    16,   420,   133,   182,  2356,
    2683,   766,  3613,  2296,   533,   394,  1319,   262,   270,  1322,
     437,   270,  4090,   479,  1327,   481,    15,    16,   338,   301,
     270,   604,   356,  3436,  3489,   602,   302,  2708,   371,   516,
    1883,   465,   498,  2716,   219,   429,   502,   360,   574,  3503,
    1353,  1354,   624,   394,   573,   511,  4063,  4064,   148,   515,
     604,   517,   286,  1384,   357,   542,   602,  2358,   383,   355,
    1839,  2362,   358,  2770,   530,  2249,  1384,   293,   428,   334,
     178,  1140,  3093,  1654,   464,  2376,  2377,  3337,  4086,    77,
    1148,    70,   490,    61,  1376,  2386,  1865,  2751,   602,   456,
    2754,  2755,   558,   421,    15,    16,   578,  1165,  2342,   512,
     393,   355,  2342,  1233,   358,   213,  3077,   333,   293,  2773,
     576,  2412,   394,   339,  1034,  1035,  1632,  2500,  1912,   585,
     455,   587,  3535,  1454,   338,   146,   355,  1643,  1258,   358,
    1646,  2460,   598,   599,   355,  1055,  1454,   358,   604,   398,
     606,  3005,   608,   609,  1064,   559,  1790,   613,   614,  2881,
    3247,   560,   618,   253,   339,   579,  1076,  1077,  1078,   599,
     235,  2460,   628,   629,   630,  1085,   355,   428,   634,   358,
    2856,   355,   106,   355,   358,   109,   358,   355,   465,   315,
     358,  2482,   421,  1626,  2607,  2608,  2609,  1394,  1183,  1349,
     604,   575,  1971,  2340,  4152,   577,   588,   355,   598,   768,
     358,  1217,   355,  1982,   604,   358,   355,   507,   559,   358,
    2369,   529,   678,   529,   573,   604,  2460,  3611,  2454,  2996,
    2460,   486,  2381,   538,   518,   550,   526,  2289,  2303,   602,
    2653,  2654,  2655,   533,   499,   355,    15,    16,   358,  3850,
    3653,  2877,    15,    16,   604,  2255,   561,  1242,  1455,   580,
    3820,   355,   547,   602,   358,   568,   529,   355,  1839,   559,
     358,   355,  1257,    24,   358,  1281,   609,  1965,   494,  3111,
     736,   604,   738,   355,  2657,  2658,   358,   608,   608,   589,
     547,   580,   355,   518,  2855,   358,  2361,  3517,  2363,   580,
    3067,   355,  2777,   589,   358,  2370,   762,   763,   764,  2458,
     766,   767,   768,  3145,   770,   771,   875,  1323,  2383,   494,
    1440,  3153,  2451,  2497,  2389,   623,  2999,   484,  3160,    15,
      16,   586,   604,   763,   555,   355,   585,   767,   358,  2404,
     770,   608,   561,  3797,   355,   589,   137,   358,   505,   577,
     555,  3754,   808,  2321,   541,  1303,  3109,  3110,   574,  3960,
     385,  2426,   818,   607,  3117,  3038,   355,  3120,  3121,   358,
     589,  2568,   828,   829,   531,   608,  3002,   833,   589,   608,
      15,    16,  2191,  3054,  3137,   604,   490,  3058,   547,  3101,
      15,    16,   603,   604,  1388,   577,    24,  2741,  3151,   574,
    1971,   608,  2749,  3156,  3157,  3158,  3159,  3824,   387,  3826,
     589,  1982,   571,  2591,   490,   589,    11,   589,    65,   875,
    3074,   589,    45,  3608,   603,   604,  2709,  2710,   818,   604,
     604,   603,   604,  3683,   499,   603,   604,  3014,   406,   829,
      50,   589,  3319,   602,   355,    73,   589,   358,  2626,  1550,
     589,    15,    16,  3054,   442,   603,   604,  3058,   914,   484,
     822,   604,   560,   168,   603,   604,   621,   622,   219,    15,
      16,   597,   598,   599,   600,    42,  1779,    68,   934,   589,
     148,    15,    16,   185,   326,   775,  1789,  3890,   578,  1792,
    1793,    15,    16,  1786,   604,   589,   152,     8,  3597,   350,
     116,   589,   430,  2632,  1786,   589,   962,  2741,   533,  3964,
     604,  2741,  2355,  2356,  2887,  1463,   604,   589,   608,  2650,
     604,    24,   150,  1816,   180,   120,   589,   119,    15,    16,
     509,   603,   604,   133,  1816,   589,   116,  2856,   166,    51,
     603,   604,   293,  2274,  2275,  2051,   182,   270,   573,    61,
     604,  3678,  2321,   532,   120,  2007,   412,  1013,   253,    15,
      16,  1017,  2650,  2699,    15,    16,   157,  2856,  1127,   589,
     286,    15,    16,  2342,   345,   198,  3049,  2810,   589,   583,
    1650,  3432,   753,   447,   604,   253,   355,  1645,   339,   358,
    3207,   219,   355,  2211,  2128,   358,  1052,  3010,   522,   221,
     589,   525,    15,    16,   102,  1164,  3705,  3706,   230,  1065,
     145,   325,   219,  3705,  3706,   604,    19,    22,  2636,   580,
    2811,   156,  2856,  1013,  2408,  1726,  2856,  1017,  3505,   485,
     538,  3304,  1702,   347,    15,    16,   341,   813,  2767,   191,
    3311,  3312,  1839,   604,  1965,  2134,  2135,    15,    16,  2283,
     370,   267,    30,   561,  1660,  2301,   447,  1965,   447,  1115,
     117,   356,   173,   229,  2701,   293,   264,    15,    16,   355,
     841,  1127,   358,    15,    16,   398,   518,  1662,   589,  2230,
     374,   254,   610,   385,   257,  2454,   184,   267,  3815,  1248,
    3063,  2460,   603,  2199,  2127,   415,   332,    75,    15,    16,
     447,   543,  2720,   441,  2137,   333,    31,   259,  1164,  1715,
    1716,   339,  3746,  1169,   447,   315,   219,  3804,  1174,   217,
     355,   124,   320,   358,    15,    16,   342,  1183,   338,   346,
     355,     8,   339,   358,    15,    16,    15,    16,   602,   361,
     353,   917,   606,   494,  3843,  3844,    73,   259,  2299,   341,
    2321,   398,    29,  1747,   371,   160,    15,    16,   325,   610,
      87,  1217,   342,   358,   465,   263,   357,   447,   146,   182,
    2533,   228,  2299,  1229,  1971,  1231,   489,  1233,    15,    16,
     493,  4236,    15,    16,  1174,  1982,  1242,    15,    16,   447,
     293,   355,  1248,  3084,   358,   447,   348,    15,    16,   180,
     456,  1257,  1258,  3219,    15,    16,   961,  2616,  3434,   355,
     512,   602,   358,   602,  3105,   606,   447,   440,   428,   354,
     589,   355,   395,   574,   358,  1281,   589,   191,  1284,  3928,
     535,   355,  1391,   604,   358,   604,  1292,  2388,    15,    16,
     150,   604,    15,    16,  3943,   455,   551,   561,  1304,  1305,
    1306,  1307,  1308,  1309,   549,   602,  1011,  3956,  1314,    15,
      16,  2388,   585,    12,  1320,  1321,   494,  1323,   355,   602,
    1326,   358,  1234,   129,  1304,  1305,  1306,   116,  1308,  1050,
     119,    12,    40,  2454,   604,    15,    16,   494,   144,  2460,
    1346,  1321,   490,    15,    16,   259,  1326,   237,   561,   355,
     452,   518,   358,   589,   355,   230,  2749,   358,   248,   219,
     578,   355,   465,  4012,   358,   242,   447,  1307,   604,  1309,
     335,   336,   602,   259,   540,  4024,  4025,   252,    15,    16,
    1101,   213,  4024,  4025,  1105,  1391,   175,  1299,    15,    16,
     608,   604,   355,   400,   602,   358,   574,   610,   253,  1405,
     602,   182,  1408,  1409,   589,   453,  1346,    15,    16,  3656,
     540,    12,   201,   209,   589,   211,   326,   574,  2811,   604,
    4069,   602,  2741,   131,   355,   473,   604,   358,   531,   604,
    4079,   603,   517,   132,  1440,    73,   313,   355,   270,  3615,
     358,    15,    16,    15,    16,   595,   596,   597,   598,   599,
     600,   132,   380,  1459,   340,  1461,  1462,   355,  1464,  1465,
     358,   338,   510,   355,   512,  1405,   358,   515,  4117,  1409,
    4119,  1477,   253,  1479,   402,   589,    12,   182,   267,   339,
    4129,  1461,  1462,  3449,   512,  1397,    15,    16,   355,   496,
     604,   358,    12,   589,    15,    16,  4145,  2499,  4147,   159,
    4149,   356,   550,  2587,    12,   589,   434,  4156,   604,  3394,
     558,    95,  3397,   568,   355,   589,   571,   358,  4167,   396,
     604,   602,   227,  2131,   355,   185,   355,   358,  3655,   358,
     604,   132,   407,  2405,  4183,  4184,  2637,  2856,   452,    15,
      16,    15,    16,   433,  1550,  1551,   355,    15,    16,   358,
    4199,  4200,   589,   342,  1663,  4204,    15,    16,    15,    16,
    2637,   489,   394,   159,  3179,   230,  3451,   604,   355,  2029,
      16,   358,   355,   374,  2321,   358,   194,   355,     0,   487,
     358,   219,  2042,   589,   249,    15,    16,   355,   589,   185,
     358,  2235,  2236,  2237,   355,   589,   132,   358,   604,   561,
     148,    15,    16,   604,  1610,    15,    16,   484,   518,   517,
     604,   380,   132,    15,    16,  2075,   221,    58,    59,   237,
      15,    16,  2981,   596,   132,   230,   589,    68,   355,   521,
     603,   358,   355,   543,   494,   358,   220,   116,  3547,  3548,
     603,   603,   604,   152,    15,    16,  1652,  3326,  3871,   355,
     152,   356,   358,   237,  1660,  3336,  1662,  1663,   589,  3987,
    3247,    15,    16,   194,   248,    15,    16,   481,  1674,   512,
    1676,   589,   603,   603,   604,   355,  1682,  1683,   358,  1685,
      61,   463,   159,   355,  2144,   603,   358,   133,   502,  1695,
      71,   589,   602,  1699,   120,   333,   175,   589,  3379,   596,
     447,   339,    83,    33,   610,   603,   603,  2454,   455,  1715,
    1716,  1717,  1718,  2460,   574,  3806,   509,  3808,   355,   512,
    1726,   358,   589,  1729,  1730,  1731,    15,    16,   355,    59,
      38,   358,    15,    16,   529,  2856,   603,    45,   356,    16,
    1746,   325,  1682,  1683,   604,  1685,   212,   355,   589,  1755,
     358,   540,   194,    15,    16,  1695,   361,   512,   589,  1699,
     589,   515,   603,    15,    16,   558,   404,   950,   951,    20,
     217,   553,   603,   217,   603,   212,   106,  1717,  1718,   109,
     589,   355,    33,   355,   358,  1791,   358,   117,   267,  1729,
    1730,  1731,   602,   217,   603,   194,    47,  1803,   179,   227,
     610,  1713,   589,   184,  1810,   988,   589,    58,    59,  2649,
     592,   589,   564,   565,    46,   567,   603,   569,   565,   566,
     603,   589,    15,    16,  2368,   603,   355,  1218,   589,   358,
    1221,   602,   350,  1224,   355,   603,   217,   358,  1750,   610,
      15,    16,   603,   603,   604,  2698,   561,  2690,   182,   433,
     566,  1791,  2891,  2696,  3050,   602,   494,  3117,  2690,   240,
    3120,  3121,   589,   342,  2696,   455,   589,    15,    16,   315,
    1810,  1980,   270,  2912,  2913,  1984,   603,  3137,   580,   355,
     603,   355,   358,   589,   358,  2757,    16,   355,   608,   604,
     358,   116,   603,   182,  2933,   610,   355,   603,   355,   358,
    1906,   358,   556,    15,    16,  3006,   610,   545,   484,   589,
     602,   495,  1824,  2022,  1920,   179,  2788,   589,  2027,    15,
      16,  1833,  1834,   603,  2796,   355,  3207,  2799,   358,   603,
     604,   603,  1844,  1845,  1846,  1847,   574,  1849,  1850,    15,
      16,   355,   581,   582,   358,   355,    15,    16,   358,   352,
     175,   116,   589,   355,   552,   553,   358,   555,   603,   604,
     355,  3062,   589,   358,     6,   604,   603,  2839,    15,    16,
      15,    16,  2270,  2593,  1980,     6,   603,    11,  1984,   602,
    1986,   589,   421,  1989,   355,  3062,   602,   358,    73,   370,
    1996,  1997,  1998,  1999,  3095,   603,  2002,   327,   602,  2650,
     602,   355,   383,   133,   358,   355,   518,  4230,   358,  1989,
     175,  2120,   458,   459,    56,   589,  2022,   589,  3095,    15,
      16,  2027,  3637,  3638,  3639,  3640,   603,   604,   610,   603,
     162,   603,  1944,  1945,   182,  1947,   201,  1949,  1950,  1951,
    1952,  1953,   267,  2152,  1956,   602,  1958,   602,  3776,  3748,
      15,    16,   603,   604,   603,   604,  1996,  1997,  1998,   602,
     589,   540,  2360,   168,   521,   150,   355,   602,   589,   358,
     603,   604,   355,   347,   603,   358,    15,    16,  2634,    15,
      16,   604,   603,   602,   102,  3784,  2384,  2385,  3787,  3788,
    3789,  3790,   473,   355,   136,    18,   358,   602,  3777,   602,
    3079,  3080,   267,   355,   602,   116,   358,   603,   604,  2856,
     603,   604,   602,   589,  2120,   589,   602,   342,   602,    71,
     602,   589,  2582,   447,  2680,   494,  3165,   603,    25,   603,
     589,   602,   589,   463,   219,   603,   561,  3530,  3531,  2145,
     602,   159,   603,   604,   603,   384,  2152,   593,   594,   595,
     596,   597,   598,   599,   600,  2264,   353,  2266,  2267,   589,
    2166,   436,   355,    12,   175,   358,   602,   185,   602,   550,
     135,    68,    95,   603,  3275,   589,    73,   342,   347,   589,
     355,  3880,  3881,   358,   602,   315,   182,   589,   604,   603,
    3889,   602,  2198,   603,   589,   525,   274,   275,  3275,  2308,
    2309,   603,   602,  3205,   509,  3884,   326,   355,   603,   602,
     358,   496,   497,    58,    59,   500,   501,  3804,   589,   504,
     602,   506,   119,   553,  2230,   148,   133,   179,   602,   152,
     335,   336,   603,   603,   604,   589,   341,  2243,   602,   589,
     602,   565,   566,   355,   603,   604,   358,  3862,   333,   603,
    2256,   602,  2258,   603,   339,   178,   267,   180,  2264,   355,
    2266,  2267,   358,   602,   326,   217,   603,   604,  2274,  2275,
    2379,   194,   603,   604,   602,    31,   199,    57,   602,   355,
     192,   602,   358,   132,   603,   604,   355,   602,   240,   358,
     213,   603,   604,  2299,   336,    95,   547,   220,   602,  3227,
     589,   602,  2308,  2309,   227,   602,   589,   602,   355,   602,
     355,   358,   602,   358,   237,   540,   567,   568,   602,   404,
     603,   603,   604,   603,   604,   248,   602,   589,   458,   459,
     253,   342,   410,   411,   603,   604,   602,   589,  2349,   262,
     347,   603,  2348,   240,  2256,   603,   604,  2353,  2359,   602,
     102,   603,  2358,   202,  2365,   397,  2362,   399,  2364,   355,
     602,   436,   358,   603,   604,   602,    12,   385,  2374,   602,
    2376,  2377,   602,  2379,   602,   540,  2387,   133,   290,   291,
    2386,  2392,  2388,   295,   296,   165,   602,  2398,  2399,   169,
     355,  2397,   602,   358,   602,    41,   589,   602,   518,  2405,
     180,   602,   325,   603,   604,    61,  2412,  2413,   315,   494,
     603,   603,   604,    11,   589,    71,   355,   602,  2424,   358,
     220,   602,  3030,   543,   347,   602,   116,    83,   603,   602,
     535,   383,   602,   356,  4162,   510,   602,   237,   335,   336,
     515,   589,    88,   602,   341,   602,   551,    93,   248,   602,
     347,   203,   602,    12,  2366,  2367,   518,  2397,   603,   604,
     545,  2921,   385,   593,   594,   595,   596,   597,   598,   599,
     600,    76,   213,    78,   230,  2481,  2482,   589,   602,  2391,
     602,   543,   602,   558,   602,   175,   383,   602,   773,   574,
     470,   603,   602,   589,   512,   602,   252,    48,   573,   603,
     604,  2961,   264,   116,   102,   114,    48,   603,   347,  4237,
     433,   201,   604,   589,   119,   533,   603,   604,    73,   604,
     589,   301,   120,   179,   347,   325,   133,   603,   184,   540,
     603,   604,   455,   441,   603,   140,   603,   604,  2450,   549,
     602,  2481,   589,   597,   589,   455,  1027,  1028,  1029,   602,
     105,   458,   459,   253,   451,   573,   603,   158,  1039,   315,
     180,   217,   175,   603,   604,    33,   490,  3187,   509,   174,
     603,   604,   495,   132,  1683,   158,  1685,   267,   264,   335,
     336,   490,   521,   149,   240,    82,   232,   185,   201,  1070,
    3646,   604,  1073,   589,   349,   150,   209,  2603,  3844,   208,
    2606,  2607,  2608,  2609,   505,  3621,  3622,   142,   143,  2615,
     362,   603,  1093,  1094,   394,   213,  1097,   603,   604,   371,
    1729,  1730,  1731,   230,   589,   377,   549,  2633,  2634,   478,
     479,  2637,   481,   433,   483,  1116,  1117,   560,   561,  3567,
     116,   603,   604,   202,  2650,  3573,   495,  2653,  2654,  2655,
     589,   407,   342,   550,   267,   578,   302,   580,   126,    35,
    2666,  2770,   217,   603,   604,   263,  2672,   148,  2674,   603,
     604,   119,  3216,  3774,  2680,  2615,   603,   604,    25,    26,
     603,   604,   150,   105,   607,   608,   154,   594,   595,   596,
     597,   598,   599,   600,   609,   495,   305,  3774,     6,   175,
     309,   104,   458,   459,   603,   604,   602,   316,   315,   603,
     604,    58,    59,    60,     4,   471,   446,   469,   364,   187,
     573,    68,   133,   603,   604,   201,    73,   383,   230,   342,
     603,   604,   604,   109,    81,   370,   204,   292,   603,   604,
     116,    55,  3758,   603,   604,  2751,  3762,   413,  2754,  2755,
     162,  2757,   603,   604,  2666,   310,  3469,  3470,   105,  1102,
    1103,   133,  3882,  3883,  2770,   105,  4012,  2773,   494,  3016,
    3017,   210,   119,  2974,  2975,   122,  3256,  3257,   333,   604,
     604,   610,  2788,   392,    68,    12,   476,   385,   133,   577,
    2796,   267,   168,  2799,   520,   603,   264,   603,   518,   175,
     405,  3817,  3818,   150,   132,     9,   558,   607,   604,   610,
     603,   603,   610,  2819,   252,   602,  2822,   473,   286,   230,
     610,  2827,   604,   150,   609,   201,   472,  2833,   264,   264,
     264,  2837,   264,  2839,    48,   264,   445,   593,   594,   595,
     596,   597,   598,   599,   600,   264,   604,   509,  2854,   602,
     540,   458,   459,  2833,   259,   453,   604,   369,   604,  2771,
     506,  2867,  3963,    12,   529,   604,   342,  2779,  2874,   529,
     217,  4117,  3492,  4119,   152,   604,    73,   224,   230,   604,
    2886,   604,  2822,   604,   597,   231,  3963,   170,   507,   180,
      87,   267,   239,    95,   550,   604,   554,  3825,   604,  4145,
    3544,  3545,  3546,   468,   315,   372,  3746,   128,   604,   603,
    3019,   604,   510,   639,   512,   152,   384,   347,   644,   478,
     479,   480,   481,   482,   483,   393,  3035,   540,   152,   152,
     127,   604,   152,   152,  2874,   152,   495,  4183,  4184,   494,
     408,   152,   152,   315,   152,   292,   152,  2859,   674,  2955,
     326,   152,  3203,  3204,   152,   510,   173,  2963,   426,   152,
     152,   337,  3506,   310,   690,   341,   342,   576,    35,   186,
     315,   152,   152,  3578,   152,   152,   152,   556,   584,   196,
     560,  2987,   591,   347,   347,  4041,   593,   594,   595,   596,
     597,   598,   599,   600,   185,   182,   347,   465,   466,   603,
    3006,  3007,   604,  1484,  3010,   731,   732,   733,   734,   603,
     603,   603,   603,  3019,   603,   597,   363,   743,   220,  3025,
     182,   596,   490,   604,   371,   603,   243,   244,   602,  3035,
     603,   603,   603,   603,   603,   237,  3600,  3043,   549,   456,
     604,   509,   109,   604,   512,   242,   248,   458,   459,   116,
     603,  2963,   604,   603,   271,   603,  3062,   602,   602,   600,
     603,   578,   602,   529,   540,   218,   602,    11,  3074,   192,
     501,  1552,   182,   610,   182,  1556,   603,  4133,  3084,   604,
    3086,  3332,   393,   604,   455,   180,   458,   459,    46,  3095,
     323,   438,  3697,   484,   484,  3101,  4197,  3103,  1579,  3105,
     484,   168,   484,   484,   446,  3650,    71,   370,   175,   370,
    3219,   370,   128,   458,   459,   332,   313,  3357,  3358,  4220,
    4197,   529,   238,   325,  4052,  4053,  4227,  4055,   128,   238,
    3370,   510,  4233,   510,   201,  3375,   370,    46,   335,   336,
     370,   338,   518,  4220,   370,   347,   522,   494,   370,   525,
    4227,   416,   368,   602,   561,    71,  4233,   370,  3398,   535,
     602,  3401,   263,   510,   540,   382,   513,   543,   146,   602,
     610,  3177,   226,  4101,   226,  4103,  4104,   603,   603,   603,
     603,  3290,   593,   594,   595,   596,   597,   598,   599,   600,
     610,   604,   610,   603,   603,   610,  3202,  3203,  3204,   396,
     267,  3207,   549,   603,   610,   603,   610,   110,   111,   112,
     113,   114,   529,  3219,   610,   604,   529,   529,   518,   595,
     596,   593,   594,   595,   596,   597,   598,   599,   600,   585,
    4158,   433,   259,    46,   602,   602,  3856,   152,   152,   353,
     602,   529,   968,   602,   182,  3854,   182,  3792,   182,   182,
     595,   596,   597,   598,   599,   600,   227,   604,  3170,   326,
     610,   234,   610,   179,  3270,   342,   604,   237,  3377,  3275,
    4195,   237,   359,   306,   341,   342,   105,   105,   240,   240,
     610,  3193,   529,   602,  3290,    18,   602,   484,  3539,  3540,
     352,  3542,  3543,   495,   194,   430,   602,  1023,  1024,   370,
     518,   217,   205,   206,   207,   208,  1032,  1033,  1034,  1035,
    1036,  1037,  1038,   610,   356,   597,   602,  1043,   228,   347,
    1046,  1047,   602,  1049,   240,  1051,  3332,   228,  3872,  1055,
     603,  3342,  1058,  1059,  1060,  1061,   603,  1063,  1064,   603,
    3449,   603,   610,  3349,   597,  1071,  1072,   603,  1074,  1075,
    1076,  1077,  1078,   603,  1080,   603,  1082,  1083,  1084,  1085,
    1086,  1087,  1088,  1089,  1090,  1091,  1092,   603,   580,  1095,
    1096,  3377,  1098,   602,  1100,   213,   604,   254,  1104,   370,
    1106,  1107,   182,   555,   230,   610,   250,    68,   603,   237,
     237,   347,  1118,  1119,   381,   604,  3402,   604,   603,  3508,
    1126,    95,   305,  3409,   307,   308,   309,  1133,  1134,  1135,
     240,  1137,   602,   316,   240,   102,   604,   602,  1144,  1145,
    1146,  3427,  1148,  1149,  1150,  1151,  1152,   347,  1154,  1155,
    1156,  1157,  1158,  1159,  1160,  1161,   604,   603,    73,  1165,
    1166,   604,   347,  3449,    18,   603,   152,   153,   604,   347,
     602,   518,    25,    26,   370,   522,   347,   470,   525,    46,
     603,   447,   602,   602,  3928,   602,  3378,   383,   535,   253,
     603,   603,   159,   540,   449,    54,   543,  4086,  4098,  3943,
     186,   580,   192,   139,    63,    58,    59,    60,   246,   392,
     196,   398,  3956,    72,   194,    68,   603,   603,   185,   604,
      73,   237,  3508,   457,  3416,    84,    85,    86,    81,   602,
     602,   237,   119,    18,   604,   119,   602,   602,   379,   602,
    3526,   100,   610,    77,   465,   135,   220,   233,   595,   596,
     217,   603,   105,  3539,  3540,   470,  3542,  3543,   244,   603,
     442,   444,   445,   237,  4164,   604,   119,  3656,   603,   122,
    4095,    18,   603,   603,   248,   603,   603,   603,    33,    33,
     603,   312,    15,    16,   603,   271,  1292,    12,    13,   603,
     242,   393,   262,   353,  1300,   580,   263,   150,   227,  4188,
     602,   604,   603,    46,   610,   199,   604,   312,   398,   518,
      95,    33,   518,   561,   561,   602,   602,   289,   602,   602,
    3606,  3607,   603,   602,   602,  4069,   602,   571,   571,   555,
     119,   240,  3618,  4222,  4234,  4079,   240,   341,    33,   342,
     603,   602,   604,   329,   342,   164,   312,   240,   518,   518,
     518,   325,   512,   602,   565,   227,   561,   561,   347,  3645,
     337,   580,  3648,   148,   217,   566,   603,   152,   603,    94,
    3656,   224,   604,   347,   488,   430,   603,   110,   111,   112,
     113,   114,   342,   555,   353,  4129,   239,  3607,   500,   180,
     602,   147,   602,   576,   602,   180,    30,   180,   123,   252,
    3686,   577,   366,  4147,   126,  4149,   603,   590,   591,   194,
     603,   136,  4156,   380,   199,   603,  3702,   520,   385,   611,
     128,  3707,   128,  4167,   150,  3645,   385,   602,   150,    70,
     406,   577,   154,   182,   159,   220,   161,    30,    61,   292,
     353,    61,   227,   604,   603,   304,   602,   172,   501,   255,
      46,    46,   237,   602,   602,  4199,  4200,   310,     5,   433,
    4204,   347,   321,   248,   347,   187,   227,   192,   253,   146,
     608,   353,   205,   206,   207,   208,   353,   262,   127,   135,
     602,    46,   204,    46,  1490,   145,   453,    46,  3774,   555,
     123,   577,   217,   146,   212,   269,  3885,   608,   223,   118,
     437,   141,   602,    46,    12,    13,   611,    46,    46,   603,
     363,    52,   608,   439,   210,   604,   603,   146,   371,   521,
    3806,   495,  3808,   604,  3810,   197,   604,    46,   603,   608,
     603,    52,   604,   180,   180,   420,   180,   262,   213,   521,
     325,   119,   264,   510,   579,   342,   602,   455,   515,   181,
    3836,  3712,   604,  2159,  1960,  3747,  3179,  2337,  3180,   622,
    3425,  3739,   347,  3857,   286,  4031,   533,   947,  4032,  3423,
    3427,   356,   305,  3605,   307,   308,   309,  4222,  4175,    45,
    1586,  1587,  1588,   316,   443,   438,    94,   550,  1725,  3597,
    3876,   558,  4185,  2650,  1600,  4066,  3921,  3597,  3987,  3885,
     385,  3597,  3597,  3597,  3597,  3891,   573,  3597,  4066,  3597,
    4025,  3597,  3947,  3597,  3597,   123,  3597,  3597,  3946,  1400,
    1626,  1410,   355,  1654,   986,   358,  1632,  1919,   136,  1635,
    1402,  1637,  3614,  2794,  2628,  3269,  2633,  1643,   497,  1645,
    1646,   494,  2987,  1245,  3876,  3967,  3272,  3646,   433,  4133,
    4049,   159,  4095,   161,  1454,   514,   520,   510,  4047,   392,
     513,   386,   384,  3792,   172,   390,   489,  3196,  1912,  2860,
     455,   393,  2482,  3105,  1920,  2415,  3084,  3963,  3128,  3128,
    3161,   406,  3565,  3341,   192,  3386,   408,  3879,  3872,   414,
    3377,  3035,  3814,    11,    11,  1468,   549,   422,  3750,  3817,
    3762,  3987,  3758,  3618,   426,  1994,  1712,  3573,  3818,   217,
     495,   444,   445,  1919,  3086,   223,  4002,  4003,  3346,  2408,
    1360,  1798,   447,  2225,  1450,  3085,  1717,  1409,  2615,  2191,
    2982,  2247,  2110,   570,  1736,   460,   461,  3599,   862,  2963,
    2593,  1065,  2028,   465,   466,  3052,  2109,  2300,  3671,   602,
    3533,  4002,  2138,  3177,   262,  4003,  3095,  1039,  3527,  3883,
    4164,  4047,  3508,  2252,   549,  1999,  2186,  1233,   490,  2229,
    3275,  3001,  3000,  3062,  3963,  1258,   561,   635,   560,   504,
     644,  1477,  3974,  3975,   549,  4071,  1312,  3103,  1787,  1340,
    1788,  4088,  4078,   578,  1673,   580,  2985,  3994,  4131,  4227,
    1264,  4059,  4233,  3379,  3006,  2682,  1741,  3043,   533,  3301,
     674,  3516,  1292,  1282,   541,   844,  1699,  1226,   603,   604,
    3635,  1459,   607,   608,  2603,  3641,   690,  4216,   542,   849,
     555,   485,   557,   485,   622,   622,   622,    -1,    -1,    -1,
      -1,    -1,    -1,   576,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   589,   590,   591,    -1,
    4146,    -1,    -1,    -1,    -1,  4151,    -1,    -1,    -1,    -1,
     734,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   386,    -1,
      -1,    -1,   390,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   406,    -1,
      -1,    -1,  4188,    25,    26,    -1,   414,    -1,    -1,    -1,
      -1,  4197,    -1,    -1,   422,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4216,    -1,    -1,    -1,  4220,  1941,  4222,    -1,    60,   447,
      -1,  4227,    -1,    -1,    -1,    -1,    -1,  4233,    -1,    -1,
      -1,    73,   460,   461,    -1,    -1,    -1,    -1,    -1,    81,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   504,   119,    -1,    -1,
     122,    -1,  2008,    -1,    -1,    -1,  2012,    -1,    -1,    -1,
      -1,  2017,  2018,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2026,    -1,    -1,  2029,    -1,   533,    -1,    -1,   150,    -1,
      -1,    -1,    -1,  2039,    -1,  2041,  2042,    -1,  2044,  2045,
    2046,  2047,  2048,    -1,    -1,  2051,    -1,   555,    -1,   557,
      -1,    -1,    -1,    -1,  2060,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2068,    -1,  2070,    -1,  2072,  2073,  2074,  2075,
      -1,    -1,    -1,  2079,  2080,  2081,    -1,    -1,    -1,    -1,
    2086,  2087,  2088,    -1,  2090,    -1,  2092,    -1,  2094,    -1,
    2096,    -1,  2098,    -1,    -1,   217,    -1,  2103,    -1,    -1,
      -1,    -1,   224,    -1,   968,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2121,    -1,   239,    -1,    -1,
      -1,    -1,  2128,    -1,    -1,  2131,    -1,    -1,    -1,    -1,
      -1,  2137,    -1,    -1,  2140,    -1,    -1,    -1,  2144,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1023,
    1024,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1032,  1033,
     292,    -1,  1036,  1037,  1038,    -1,    -1,    -1,    -1,  1043,
      -1,    -1,  1046,  1047,    -1,  1049,    -1,  1051,   310,    -1,
      -1,    -1,    -1,  2199,  1058,  1059,  1060,  1061,    -1,  1063,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1071,  1072,    -1,
    1074,  1075,    -1,    -1,    -1,    -1,  1080,    -1,  1082,  1083,
    1084,    -1,    -1,  1087,  1088,  1089,  1090,  1091,  1092,    -1,
      -1,  1095,  1096,    -1,  1098,    -1,  1100,    -1,    -1,    -1,
    1104,   363,  1106,  1107,    -1,     6,    -1,    -1,    -1,   371,
      -1,    -1,    13,    14,  1118,  1119,    -1,    -1,    -1,    -1,
      -1,    -1,  1126,    -1,    25,    26,    -1,    -1,    -1,  1133,
    1134,  1135,    -1,    -1,    32,    33,    -1,    -1,    -1,    -1,
      38,    -1,    40,    -1,    42,    43,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    56,    -1,    -1,    -1,    60,
      61,    59,  1166,    -1,    -1,    66,    -1,    -1,    -1,    13,
      -1,    -1,    73,    -1,    -1,    -1,   438,    -1,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    -1,    -1,    -1,    -1,    -1,   214,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,   106,    -1,
      -1,   109,    -1,    -1,    -1,    -1,    -1,    -1,   119,   117,
      -1,   122,    -1,    -1,    -1,    -1,    -1,    -1,   129,   130,
      -1,    -1,   494,    -1,    -1,   136,   134,    -1,    -1,    -1,
      -1,    -1,    -1,   144,    -1,    -1,    -1,   148,   510,   150,
      94,   513,    -1,   151,   272,   273,   274,   275,   276,   277,
      -1,   279,   280,   281,   282,   283,   284,   285,    -1,   287,
     288,    -1,    -1,    -1,    -1,    -1,   174,   178,   176,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   549,  1292,    -1,
     188,   189,   136,    -1,    -1,    -1,  1300,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   215,   159,   217,   161,    -1,    -1,
      -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,   172,    -1,
     228,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   239,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   192,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2503,   256,    -1,
      -1,  2507,    -1,    -1,    -1,    -1,    -1,   265,   266,    -1,
     268,    -1,    -1,   217,    -1,    -1,    -1,    -1,    -1,   223,
      -1,    -1,    -1,  2529,  2530,    -1,    -1,    -1,    -1,    -1,
      -1,   292,   410,   411,    -1,    -1,    -1,    -1,    -1,    -1,
     298,   299,   300,  2549,    -1,    -1,    -1,    -1,    -1,   310,
      -1,    -1,  2558,   314,  2560,    -1,  2562,    -1,   262,   317,
     318,   319,    -1,    -1,    -1,    -1,   324,    -1,    -1,   327,
      -1,    -1,    -1,    -1,    -1,    -1,  2582,    -1,    -1,    -1,
      -1,  2587,    -1,    -1,    -1,   343,   344,    25,    26,    -1,
     351,    -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,
      -1,    -1,   363,    -1,    -1,  2611,    -1,    -1,    -1,   370,
     371,    -1,    -1,    -1,    -1,    -1,    -1,   375,   376,    -1,
      58,    59,    60,    -1,    -1,    -1,  1490,    -1,    -1,    -1,
      68,    -1,    -1,    -1,    -1,    73,    -1,    -1,    -1,    -1,
     401,    -1,   400,    81,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   415,   416,   417,   418,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   105,    -1,  2675,
      -1,    -1,    -1,  2679,    -1,    -1,    -1,   438,    -1,    -1,
      -1,   119,   386,    -1,   122,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,
      -1,    -1,   406,    -1,    -1,    -1,    -1,    -1,    -1,   467,
     414,    -1,   150,    -1,    -1,    -1,    -1,  2723,   422,    -1,
      -1,    -1,  1586,  1587,  1588,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   447,    -1,    -1,    -1,    -1,    -1,   510,
      -1,    -1,   513,    -1,    -1,    -1,   460,   461,    -1,    -1,
      -1,   519,  1626,    -1,   522,    -1,    -1,   525,   526,   527,
     528,  1635,    -1,  1637,    -1,   536,    -1,    -1,    -1,   217,
      -1,    -1,    -1,    -1,    -1,    -1,   224,    -1,   549,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     504,   239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   567,
     568,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2830,  2831,    -1,    -1,    -1,   533,
      -1,    -1,    -1,   591,    -1,    13,    14,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   608,  1712,    -1,
      -1,   555,    -1,   557,   292,    -1,    34,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    49,   310,    -1,    -1,    -1,    -1,    -1,    56,    -1,
      -1,    -1,    60,    61,    -1,    -1,    -1,    -1,  2894,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2918,  2919,    -1,  2921,    94,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2930,   363,    -1,    -1,    -1,  2935,
      -1,    -1,  2938,   371,  2940,  2941,    -1,   115,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   123,   124,   125,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2961,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2976,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   161,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3000,    -1,    -1,    -1,    -1,   177,
     438,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   192,    -1,    -1,    -1,    -1,   197,
      -1,    -1,   200,    -1,  3030,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3044,    -1,
      -1,    -1,    -1,    -1,    -1,   223,    -1,   225,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   494,    -1,  3064,    -1,
      -1,    -1,    -1,   241,    -1,    -1,    -1,  3073,    -1,    -1,
      -1,    -1,   510,    -1,    -1,   513,    -1,  1941,    -1,    -1,
     258,    -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   549,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2008,    -1,    -1,    -1,  2012,    -1,
      -1,    -1,    -1,  2017,  2018,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2026,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,    -1,  2039,    -1,  2041,    -1,    -1,
    2044,  2045,  2046,  2047,  2048,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   370,    -1,    -1,    -1,  2060,    -1,    -1,    -1,
      -1,    -1,   380,    -1,  2068,    -1,  2070,    -1,  2072,  2073,
    2074,    -1,    -1,   391,    -1,  2079,  2080,  2081,    -1,    -1,
      -1,    -1,  2086,  2087,  2088,    -1,  2090,    -1,  2092,    -1,
    2094,    -1,  2096,    -1,  2098,   413,    -1,    -1,   416,  2103,
     418,    -1,    -1,   421,    -1,    -1,   424,   425,    -1,    -1,
      -1,    -1,    -1,    -1,   432,    -1,   434,  2121,    -1,    -1,
      -1,    -1,    -1,   441,    -1,    -1,    -1,    -1,    -1,   447,
    3276,    -1,    -1,  2137,    -1,    -1,  2140,   455,    -1,    -1,
      -1,    -1,   460,    -1,   462,    -1,    -1,   465,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    13,    14,    -1,  3315,
    3316,   489,    -1,    -1,    -1,   493,    -1,    -1,  3324,    -1,
      -1,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    56,
      -1,    -1,    -1,    60,    61,    -1,    -1,    -1,   536,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    -1,
     548,    -1,    -1,    -1,   552,    -1,    -1,   555,    -1,    -1,
      -1,    -1,   560,    -1,    -1,    -1,    -1,    94,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,   587,
      -1,    -1,    -1,    -1,    -1,    -1,   123,   124,   125,    -1,
      -1,    -1,    -1,    -1,   602,    -1,    -1,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      23,   148,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      33,    34,  3458,    -1,   161,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     177,    -1,    -1,    -1,    -1,    58,    59,    -1,    -1,    -1,
      -1,    -1,    -1,  3489,    -1,   192,    69,    -1,    -1,    -1,
     197,    -1,    -1,   200,    -1,    -1,    -1,  3503,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    92,
    3516,    94,    -1,    -1,    -1,    -1,   223,    -1,   225,    -1,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   241,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   258,    -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   149,   150,    -1,    -1,
      -1,    -1,   155,    -1,    -1,   158,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     183,    -1,   185,    -1,    -1,    -1,    -1,    -1,   191,    -1,
     193,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   216,   217,    -1,    -1,    -1,    -1,  2503,
    3646,    -1,    -1,  2507,   351,    -1,    -1,    -1,  3654,    -1,
      -1,    -1,    -1,    -1,    -1,   238,    -1,  3663,    -1,  3665,
      -1,    -1,    -1,   370,    -1,  2529,  2530,    -1,    -1,    -1,
      -1,    -1,    -1,   380,    -1,    -1,   259,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   391,  2549,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3699,  2558,    -1,  2560,    -1,  2562,  3705,
    3706,    -1,    -1,   286,    -1,    -1,   413,    -1,    -1,   416,
      -1,   418,    -1,    -1,   421,    -1,    -1,   424,   425,    -1,
      -1,    -1,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,
      -1,    -1,    -1,    -1,   441,    -1,    -1,    -1,    -1,    -1,
     447,    -1,    -1,    -1,    -1,    -1,    -1,  2611,   455,    -1,
      -1,    -1,    -1,   460,    -1,   462,    -1,    -1,   465,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   350,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   489,    -1,    -1,    -1,   493,    -1,    -1,    -1,
     373,  3797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   384,   385,    -1,    -1,   388,   389,    -1,    -1,    -1,
      -1,  2675,    -1,    -1,    -1,  2679,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3829,    -1,  3831,   409,    -1,    -1,   536,
      -1,    -1,    -1,    -1,    -1,  3841,    -1,  3843,  3844,    -1,
      -1,   548,    -1,    -1,    -1,   552,    -1,    -1,   555,    -1,
      -1,    -1,    -1,   560,    -1,    -1,    -1,    -1,    -1,  2723,
    3866,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   452,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,    -1,    -1,
     587,    -1,   465,    -1,    13,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   602,    25,    26,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   490,    -1,    -1,
      -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3926,    -1,  3928,    -1,    -1,    -1,    -1,    56,    -1,   512,
      -1,    60,    -1,    -1,    -1,    -1,    -1,  3943,  3944,    -1,
      -1,    -1,    -1,    -1,    73,    -1,    -1,    -1,    -1,    -1,
    3956,    -1,    81,    -1,    -1,    -1,    -1,    -1,  3964,    -1,
      -1,    -1,    91,    -1,    -1,    -1,  2830,  2831,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   569,    -1,    -1,    -1,
     119,    -1,   575,   122,    -1,    -1,    -1,    -1,    -1,    -1,
     129,    -1,    -1,    -1,    -1,  4011,  4012,   136,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   144,    -1,    -1,  4024,  4025,
      -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2894,    -1,    -1,    -1,    -1,  4041,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   178,
      -1,    -1,    -1,    -1,  2918,  2919,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4069,    -1,    -1,  2930,    -1,    -1,    -1,
    4076,  2935,    -1,  4079,  2938,    -1,  2940,  2941,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,    -1,
      -1,    -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4110,    -1,    -1,    -1,    -1,    -1,
     239,  4117,  2976,  4119,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4129,    -1,    -1,    -1,  4133,    -1,    -1,
    4136,    -1,    -1,    -1,    -1,    -1,  3000,    -1,    -1,  4145,
      -1,  4147,    -1,  4149,    -1,    -1,    -1,    -1,    -1,    -1,
    4156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4167,    -1,   292,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4183,  4184,    -1,
    3044,   310,    -1,  4189,    -1,   314,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4199,  4200,    -1,    -1,    -1,  4204,    -1,
    3064,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3073,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   356,    -1,    -1,
    4236,    -1,    -1,    -1,   363,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   416,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   438,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   510,    -1,    -1,   513,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3276,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     549,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3315,  3316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3458,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3489,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3503,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3516,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3654,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3663,
      -1,  3665,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3699,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3797,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3829,    -1,  3831,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3841,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3926,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3944,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3964,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4011,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4076,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,  4136,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    44,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,  4189,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    93,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,  4236,   119,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,   168,   169,   170,    -1,   172,   173,   174,   175,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,   195,
      -1,   197,   198,    -1,   200,   201,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,   212,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,   223,   224,   225,
     226,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,   245,
     246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,   341,   342,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,   530,   531,   532,    -1,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,   562,   563,   564,   565,
     566,    -1,    -1,   569,   570,    -1,   572,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,   595,
     596,    -1,    -1,    -1,    -1,   601,   602,    -1,    -1,   605,
     606,    -1,    -1,   609,   610,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,   119,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,   168,   169,
     170,    -1,   172,   173,   174,   175,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,   195,    -1,   197,   198,    -1,
     200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,   223,   224,   225,   226,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,   341,   342,    -1,   344,   345,   346,   347,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,   502,   503,   504,   505,   506,   507,   508,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,   562,   563,   564,   565,   566,    -1,    -1,   569,
     570,    -1,   572,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,    -1,   595,   596,    -1,    -1,    -1,
      -1,   601,   602,    -1,    -1,   605,   606,    -1,    -1,   609,
     610,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    93,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
     114,   115,   116,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,   169,   170,    -1,   172,   173,
     174,   175,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,   195,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,
     224,   225,   226,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,   326,   327,   328,    -1,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,   341,   342,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,   491,   492,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,   502,   503,
     504,   505,   506,   507,   508,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,   562,   563,
     564,   565,   566,    -1,    -1,   569,   570,    -1,   572,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,   595,   596,    -1,    -1,    -1,    -1,   601,   602,   603,
      -1,   605,   606,    -1,    -1,   609,   610,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
      -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,   182,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
     182,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,   195,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,   223,   224,   225,   226,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
     502,   503,   504,   505,   506,   507,   508,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
     562,   563,   564,   565,   566,    -1,    -1,   569,   570,    -1,
     572,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,   595,   596,    -1,    -1,    -1,    -1,   601,
     602,    -1,    -1,   605,   606,    -1,    -1,   609,   610,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    93,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,   168,   169,   170,    -1,   172,   173,   174,   175,
      -1,   177,    -1,    -1,    -1,   181,   182,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,   195,
      -1,   197,   198,    -1,   200,   201,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,   212,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,   223,   224,   225,
     226,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,   341,   342,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,   562,   563,   564,   565,
     566,    -1,    -1,   569,   570,    -1,   572,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,   595,
     596,    -1,    -1,    -1,    -1,   601,   602,    -1,    -1,   605,
     606,    -1,    -1,   609,   610,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,   119,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,   168,   169,
     170,    -1,   172,   173,   174,   175,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,   195,    -1,   197,   198,    -1,
     200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,   223,   224,   225,   226,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,   341,   342,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,   502,   503,   504,   505,   506,   507,   508,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,   562,   563,   564,   565,   566,    -1,    -1,   569,
     570,    -1,   572,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,    -1,   595,   596,    -1,    -1,    -1,
      -1,   601,   602,    -1,    -1,   605,   606,    -1,    -1,   609,
     610,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    93,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
     114,   115,   116,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,   169,   170,    -1,   172,   173,
     174,   175,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,   195,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,
     224,   225,   226,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,   326,   327,   328,    -1,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,   341,   342,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,   491,   492,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,   502,   503,
     504,   505,   506,   507,   508,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,   562,   563,
     564,   565,   566,    -1,    -1,   569,   570,    -1,   572,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,   595,   596,    -1,    -1,    -1,    -1,   601,   602,    -1,
      -1,   605,   606,    -1,    -1,   609,   610,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
      -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,   195,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,   223,   224,   225,   226,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
     502,   503,   504,   505,   506,   507,   508,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
     562,   563,   564,   565,   566,    -1,    -1,   569,   570,    -1,
     572,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,   595,   596,    -1,    -1,    -1,    -1,   601,
     602,    -1,    -1,   605,   606,    -1,    -1,   609,   610,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    93,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,   168,   169,   170,    -1,   172,   173,   174,   175,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,   195,
      -1,   197,   198,    -1,   200,   201,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,   212,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,   223,   224,   225,
     226,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,   341,   342,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,   562,   563,   564,   565,
     566,    -1,    -1,   569,   570,    -1,   572,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,   595,
     596,    -1,    -1,    -1,    -1,   601,   602,    -1,    -1,   605,
     606,    -1,    -1,   609,   610,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,   119,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,   168,   169,
     170,    -1,   172,   173,   174,   175,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,   195,    -1,   197,   198,    -1,
     200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,   223,   224,   225,   226,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,   341,   342,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,   502,   503,   504,   505,   506,   507,   508,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,   562,   563,   564,   565,   566,    -1,    -1,   569,
     570,    -1,   572,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,    -1,   595,   596,    -1,    -1,    -1,
      -1,   601,   602,    -1,    -1,   605,   606,    -1,    -1,   609,
     610,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    93,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
     114,   115,   116,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,   169,   170,    -1,   172,   173,
     174,   175,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,   195,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,
     224,   225,   226,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,   326,   327,   328,    -1,    -1,   331,   332,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,   342,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,   491,   492,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,   502,   503,
     504,   505,   506,   507,   508,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,   562,   563,
     564,   565,   566,    -1,    -1,   569,   570,    -1,   572,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,   595,   596,    -1,    -1,    -1,    -1,   601,   602,    -1,
      -1,   605,   606,    -1,    -1,   609,   610,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
      -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,   195,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,   223,   224,   225,   226,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,   335,    -1,   337,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
     502,   503,   504,   505,   506,   507,   508,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
     562,   563,   564,   565,   566,    -1,    -1,   569,   570,    -1,
     572,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,   595,   596,    -1,    -1,    -1,    -1,   601,
     602,    -1,    -1,   605,   606,    -1,    -1,   609,   610,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    93,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,   168,   169,   170,    -1,   172,   173,   174,   175,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,   195,
      -1,   197,   198,    -1,   200,   201,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,   212,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,   223,   224,   225,
     226,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,    -1,   331,   332,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,   342,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,   562,   563,   564,   565,
     566,    -1,    -1,   569,   570,    -1,   572,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,   595,
     596,    -1,    -1,    -1,    -1,   601,   602,    -1,    -1,   605,
     606,    -1,    -1,   609,   610,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    35,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,    -1,
     100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,    -1,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,    -1,    -1,   164,   165,   166,    -1,   168,   169,
     170,    -1,   172,   173,   174,   175,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,    -1,
     200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
     290,   291,   292,   293,    -1,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,   312,    -1,   314,    -1,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
      -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,   339,
      -1,   341,   342,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,    -1,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
      -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,    -1,    -1,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,    -1,    -1,   504,   505,   506,   507,    -1,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,    -1,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,
      -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,   609,
     610,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,   184,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,   217,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,   240,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,   252,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,   447,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,   473,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,    -1,   591,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   610,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,    -1,
     100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,
      -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,   169,
     170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,   184,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,    -1,
     200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,    -1,    -1,   214,   215,   216,   217,    -1,   219,
      -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
     240,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
     290,   291,   292,   293,    -1,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,   312,    -1,   314,    -1,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,    -1,   327,   328,    -1,
      -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,   339,
      -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,    -1,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
      -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,   473,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,    -1,    -1,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,    -1,    -1,   504,   505,   506,   507,    -1,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,   539,
      -1,   541,   542,    -1,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,
      -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
     610,    22,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    -1,    84,    85,    86,    87,    88,    -1,    90,
      -1,    -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,
      -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,
      -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,
      -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,
     131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,
     151,    -1,    -1,   154,   155,    -1,   157,   158,   159,   160,
     161,    -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,
      -1,   172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,
     181,    -1,   183,    -1,   185,    -1,   187,   188,   189,   190,
     191,    -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,
      -1,    -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,
     211,    -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,
      -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,
     231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,
      -1,   242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,
      -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,   286,   287,   288,    -1,   290,
     291,   292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,
     301,   302,   303,   304,   305,   306,    -1,    -1,   309,   310,
      -1,   312,    -1,   314,    -1,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,
     331,   332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,
      -1,    -1,    -1,   344,   345,   346,    -1,   348,   349,   350,
      -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   362,   363,   364,    -1,   366,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,   380,
     381,   382,    -1,   384,    -1,   386,   387,   388,   389,   390,
      -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,
     401,   402,   403,   404,   405,    -1,    -1,   408,   409,   410,
     411,   412,    -1,   414,   415,    -1,   417,   418,   419,    -1,
      -1,   422,    -1,   424,    -1,   426,   427,    -1,   429,   430,
      -1,    -1,    -1,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,    -1,   445,   446,   447,    -1,    -1,   450,
     451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,
     461,    -1,   463,   464,   465,   466,    -1,   468,   469,   470,
     471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,
      -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,
      -1,    -1,   493,   494,    -1,   496,   497,   498,   499,   500,
     501,    -1,    -1,   504,   505,   506,   507,    -1,   509,   510,
      -1,    -1,   513,   514,   515,   516,    -1,    -1,   519,   520,
      -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,
     531,   532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,
     541,   542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,
     551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,
      -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,
      -1,    -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,
      -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,
     591,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,   603,    -1,    -1,    17,    -1,    -1,    20,   610,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,   603,    -1,    -1,    -1,    -1,    17,   609,   610,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    -1,    84,    85,    86,    87,    88,    -1,    90,
      -1,    -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,
      -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,
      -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,
      -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,
     131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,
     151,    -1,    -1,   154,   155,    -1,   157,   158,   159,   160,
     161,    -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,
      -1,   172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,
     181,    -1,   183,    -1,   185,    -1,   187,   188,   189,   190,
     191,    -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,
      -1,    -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,
     211,    -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,
      -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,
     231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,
      -1,   242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,
      -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,   286,   287,   288,    -1,   290,
     291,   292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,
     301,   302,   303,   304,   305,   306,    -1,    -1,   309,   310,
      -1,   312,    -1,   314,    -1,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,
     331,   332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,
      -1,    -1,    -1,   344,   345,   346,    -1,   348,   349,   350,
      -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   362,   363,   364,    -1,   366,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,   380,
     381,   382,    -1,   384,    -1,   386,   387,   388,   389,   390,
      -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,
     401,   402,   403,   404,   405,    -1,    -1,   408,   409,   410,
     411,   412,    -1,   414,   415,    -1,   417,   418,   419,    -1,
      -1,   422,    -1,   424,    -1,   426,   427,    -1,   429,   430,
      -1,    -1,    -1,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,
     451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,
     461,    -1,   463,   464,   465,   466,    -1,   468,   469,   470,
     471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,
      -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,
      -1,    -1,   493,   494,    -1,   496,   497,   498,   499,   500,
     501,    -1,    -1,   504,   505,   506,   507,    -1,   509,   510,
      -1,    -1,   513,   514,   515,   516,    -1,    -1,   519,   520,
      -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,
     531,   532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,
     541,   542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,
     551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,
      -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,
      -1,    -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,
      -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,
     591,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,   602,    -1,    -1,    -1,    17,    -1,    -1,    20,   610,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,   227,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   610,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      -1,    84,    85,    86,    87,    88,    -1,    90,    -1,    -1,
      93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,
      -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,
      -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,
      -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,   146,   147,    -1,   149,   150,   151,    -1,
      -1,   154,   155,    -1,   157,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,   172,
     173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,
     183,    -1,   185,    -1,   187,   188,   189,   190,   191,    -1,
     193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,
     203,   204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,
      -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,
      -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,
      -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,
     243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,
      -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,    -1,   290,   291,   292,
     293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,
     303,   304,   305,   306,    -1,    -1,   309,   310,    -1,   312,
      -1,   314,    -1,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,
     333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,
      -1,   344,   345,   346,    -1,   348,   349,   350,    -1,   352,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,
     363,   364,    -1,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,   380,   381,   382,
      -1,   384,    -1,   386,   387,   388,   389,   390,    -1,   392,
     393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,
     403,   404,   405,    -1,    -1,   408,   409,   410,   411,   412,
      -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,   422,
      -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,
     453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,
     463,   464,   465,   466,    -1,   468,   469,   470,   471,   472,
      -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,
      -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,
     493,   494,    -1,   496,   497,   498,   499,   500,   501,    -1,
      -1,   504,   505,   506,   507,    -1,   509,   510,    -1,    -1,
     513,   514,   515,   516,    -1,    -1,   519,   520,    -1,   522,
     523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,
      -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,   542,
      -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,
      -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,
      -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,
     573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,
     583,   584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,
      -1,    -1,    -1,     5,   597,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,   610,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
     602,    -1,    -1,    -1,    17,    -1,    -1,    20,   610,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      -1,    84,    85,    86,    87,    88,    -1,    90,    -1,    -1,
      93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,
      -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,
      -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,
      -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,   146,   147,    -1,   149,   150,   151,    -1,
      -1,   154,   155,    -1,   157,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,   172,
     173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,
     183,    -1,   185,    -1,   187,   188,   189,   190,   191,    -1,
     193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,
     203,   204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,
      -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,
      -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,
      -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,
     243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,
      -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,    -1,   290,   291,   292,
     293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,
     303,   304,   305,   306,    -1,    -1,   309,   310,    -1,   312,
      -1,   314,    -1,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,
     333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,
      -1,   344,   345,   346,    -1,   348,   349,   350,    -1,   352,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,
     363,   364,    -1,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,   380,   381,   382,
      -1,   384,    -1,   386,   387,   388,   389,   390,    -1,   392,
     393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,
     403,   404,   405,    -1,    -1,   408,   409,   410,   411,   412,
      -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,   422,
      -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,
     453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,
     463,   464,   465,   466,    -1,   468,   469,   470,   471,   472,
      -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,
      -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,
     493,   494,    -1,   496,   497,   498,   499,   500,   501,    -1,
      -1,   504,   505,   506,   507,    -1,   509,   510,    -1,    -1,
     513,   514,   515,   516,    -1,    -1,   519,   520,    -1,   522,
     523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,
      -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,   542,
      -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,
      -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,
      -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,
     573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,
     583,   584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,   609,   610,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   610,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      -1,    84,    85,    86,    87,    88,    -1,    90,    -1,    -1,
      93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,
      -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,
      -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,
      -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,   146,   147,    -1,   149,   150,   151,    -1,
      -1,   154,   155,    -1,   157,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,   172,
     173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,
     183,    -1,   185,    -1,   187,   188,   189,   190,   191,    -1,
     193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,
     203,   204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,
      -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,
      -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,
      -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,
     243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,
      -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,    -1,   290,   291,   292,
     293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,
     303,   304,   305,   306,    -1,    -1,   309,   310,    -1,   312,
      -1,   314,    -1,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,
     333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,
      -1,   344,   345,   346,    -1,   348,   349,   350,    -1,   352,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,
     363,   364,    -1,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,   380,   381,   382,
      -1,   384,    -1,   386,   387,   388,   389,   390,    -1,   392,
     393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,
     403,   404,   405,    -1,    -1,   408,   409,   410,   411,   412,
      -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,   422,
      -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,
     453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,
     463,   464,   465,   466,    -1,   468,   469,   470,   471,   472,
      -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,
      -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,
     493,   494,    -1,   496,   497,   498,   499,   500,   501,    -1,
      -1,   504,   505,   506,   507,    -1,   509,   510,    -1,    -1,
     513,   514,   515,   516,    -1,    -1,   519,   520,    -1,   522,
     523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,
      -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,   542,
      -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,
      -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,
      -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,
     573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,
     583,   584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    -1,    84,
      85,    86,    87,    88,    -1,    90,    -1,    -1,    93,    -1,
      -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,   104,
     105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,   114,
     115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,    -1,
      -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,   154,
     155,    -1,   157,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,    -1,    -1,   169,   170,    -1,   172,   173,   174,
      -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,
     185,    -1,   187,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,   204,
      -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,   214,
     215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,   234,
     235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,
      -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,   286,   287,   288,    -1,   290,   291,   292,   293,    -1,
     295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,
     305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,   314,
      -1,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,   334,
      -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,   344,
     345,   346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,
      -1,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,   380,   381,   382,    -1,   384,
      -1,   386,   387,   388,   389,   390,    -1,   392,   393,   394,
      -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,
     405,    -1,    -1,   408,   409,   410,   411,   412,    -1,   414,
     415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,   424,
      -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,    -1,
     445,   446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,
      -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,
     465,   466,    -1,   468,   469,   470,   471,   472,    -1,    -1,
      -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,
     485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,   494,
      -1,   496,   497,   498,   499,   500,   501,    -1,    -1,   504,
     505,   506,   507,    -1,   509,   510,    -1,    -1,   513,   514,
     515,   516,    -1,    -1,   519,   520,    -1,   522,   523,   524,
     525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,    -1,
      -1,   536,   537,   538,   539,    -1,   541,   542,    -1,   544,
     545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,
      -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,    -1,
      -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,   574,
     575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,
      -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,   610,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,
      96,    -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,
     106,    -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,
      -1,    -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,    -1,    -1,   164,   165,
     166,    -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,    -1,
      -1,   197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,    -1,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,    -1,   249,   250,   251,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,   290,   291,   292,   293,    -1,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
      -1,   327,   328,    -1,    -1,   331,   332,   333,   334,    -1,
      -1,    -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,    -1,    -1,   504,   505,
     506,   507,    -1,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,
     536,   537,   538,   539,    -1,   541,   542,    -1,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,
     566,    -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,   609,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,
      -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,
      -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,
      -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,    -1,    -1,   164,   165,   166,    -1,
      -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,
     198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,    -1,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
      -1,   249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,   290,   291,   292,   293,    -1,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,    -1,   327,
     328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,
     338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,    -1,    -1,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,    -1,    -1,   504,   505,   506,   507,
      -1,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,
     538,   539,    -1,   541,   542,    -1,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,
      -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   609,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,    -1,
     100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,
      -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,   169,
     170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,    -1,
     200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,   249,
     250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
     290,   291,   292,   293,    -1,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,   312,    -1,   314,    -1,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,    -1,   327,   328,    -1,
      -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,   339,
      -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,    -1,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
      -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,    -1,    -1,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,    -1,    -1,   504,   505,   506,   507,    -1,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,   539,
      -1,   541,   542,    -1,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,
      -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,   609,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    55,    -1,    57,    -1,    -1,    -1,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    -1,    74,    -1,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    -1,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,    -1,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,    -1,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,   171,
     172,   173,   174,    -1,    -1,    -1,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
      -1,    -1,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,    -1,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,   236,    -1,    -1,   239,    -1,    -1,
      -1,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,   269,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,    -1,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   363,   364,    -1,    -1,   367,   368,   369,    -1,   371,
     372,   373,   374,   375,   376,    -1,    -1,    -1,    -1,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,    -1,    -1,   417,    -1,   419,   420,    -1,
     422,    -1,    -1,    -1,   426,    -1,    -1,   429,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,   439,   440,    -1,
     442,   443,    -1,   445,    -1,    -1,    -1,    -1,   450,   451,
     452,    -1,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,    -1,   464,    -1,   466,    -1,   468,    -1,    -1,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,    -1,   490,    -1,
      -1,    -1,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,    -1,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,    -1,    -1,    -1,    -1,   551,
      -1,    -1,   554,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,   579,    -1,    -1,
      -1,   583,    -1,    -1,   586,    -1,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,   604,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
     597,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,   597,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
     597,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,   597,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,   116,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,   175,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,    -1,    -1,   342,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,   475,   476,
     477,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,   540,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
     152,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,   251,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,   456,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
     267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,   342,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,   540,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,   251,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,   251,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,   518,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,   251,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,   251,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,   518,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    35,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,   251,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,   518,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,   251,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,   251,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,   518,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    89,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,   163,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,   476,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,   182,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,   383,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    55,    -1,    57,    -1,    -1,    -1,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    -1,    74,    -1,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    -1,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,    -1,
     142,   143,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,    -1,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,   171,
     172,   173,   174,    -1,    -1,    -1,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
      -1,    -1,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,    -1,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,   236,    -1,    -1,   239,    -1,    -1,
      -1,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,   269,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,    -1,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   363,   364,    -1,    -1,   367,   368,   369,    -1,   371,
     372,   373,   374,   375,   376,    -1,    -1,    -1,    -1,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,    -1,    -1,   417,    -1,   419,   420,    -1,
     422,    -1,    -1,    -1,   426,    -1,    -1,   429,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,   439,   440,    -1,
     442,   443,    -1,   445,    -1,    -1,    -1,    -1,   450,   451,
     452,    -1,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,    -1,   464,    -1,   466,    -1,   468,    -1,    -1,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,    -1,   490,    -1,
      -1,    -1,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,    -1,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,    -1,    -1,    -1,    -1,   551,
      -1,    -1,   554,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,   579,    -1,    -1,
      -1,   583,    -1,    -1,   586,    -1,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    54,    55,    -1,
      57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    -1,    74,    -1,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      -1,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,    -1,    -1,
      -1,   138,   139,   140,    -1,   142,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,    -1,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,   171,   172,   173,   174,    -1,    -1,
      -1,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,    -1,    -1,   204,    -1,    -1,
      -1,   208,   209,   210,   211,   212,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,   236,
      -1,    -1,   239,    -1,    -1,    -1,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,   269,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,    -1,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   363,   364,    -1,    -1,
     367,   368,   369,    -1,   371,   372,   373,   374,   375,   376,
      -1,    -1,    -1,    -1,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,    -1,    -1,
     417,    -1,   419,   420,    -1,   422,    -1,    -1,    -1,   426,
      -1,    -1,   429,   430,   431,    -1,    -1,    -1,   435,   436,
     437,   438,   439,   440,    -1,   442,   443,    -1,   445,    -1,
      -1,    -1,    -1,   450,   451,   452,    -1,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,    -1,   464,    -1,   466,
      -1,   468,    -1,    -1,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,    -1,   490,    -1,    -1,    -1,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,    -1,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
      -1,    -1,    -1,    -1,   551,    -1,    -1,   554,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
     577,    -1,   579,    -1,    -1,    -1,   583,    -1,    -1,   586,
      -1,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    55,    -1,    57,    -1,    -1,    -1,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    -1,    74,    -1,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    -1,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,    -1,
     142,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,    -1,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,   171,
     172,   173,   174,    -1,    -1,    -1,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
      -1,    -1,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,    -1,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,   236,    -1,    -1,   239,    -1,    -1,
      -1,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,   269,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,    -1,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   363,   364,    -1,    -1,   367,   368,   369,    -1,   371,
     372,   373,   374,   375,   376,    -1,    -1,    -1,    -1,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,    -1,    -1,   417,    -1,   419,   420,    -1,
     422,    -1,    -1,    -1,   426,    -1,    -1,   429,   430,   431,
      -1,    -1,    -1,   435,   436,   437,   438,   439,   440,    -1,
     442,   443,    -1,   445,    -1,    -1,    -1,    -1,   450,   451,
     452,    -1,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,    -1,   464,    -1,   466,    -1,   468,    -1,    -1,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,    -1,   490,    -1,
      -1,    -1,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,    -1,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,    -1,    -1,    -1,    -1,   551,
      -1,    -1,   554,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,   577,    -1,   579,    -1,    -1,
      -1,   583,    -1,    -1,   586,    -1,   588,    -1,     5,   591,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    22,    23,    24,    25,    26,
      27,    -1,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    51,    52,    -1,    54,    55,    -1,
      57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    -1,    74,    -1,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      -1,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,    -1,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,    -1,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,    -1,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,   171,   172,   173,   174,    -1,    -1,
      -1,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,    -1,    -1,   204,    -1,    -1,
      -1,   208,   209,   210,   211,   212,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,    -1,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,   236,
      -1,    -1,   239,    -1,    -1,    -1,   243,    -1,    -1,   246,
     247,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,   269,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,    -1,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   363,   364,    -1,    -1,
     367,   368,   369,    -1,   371,   372,   373,   374,   375,   376,
      -1,    -1,    -1,    -1,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,    -1,    -1,
     417,    -1,   419,   420,    -1,   422,    -1,    -1,    -1,   426,
      -1,    -1,   429,   430,   431,    -1,    -1,    -1,   435,   436,
     437,   438,   439,   440,    -1,   442,   443,    -1,   445,    -1,
      -1,    -1,    -1,   450,   451,   452,    -1,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,    -1,   464,    -1,   466,
      -1,   468,    -1,    -1,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,    -1,   490,    -1,    -1,    -1,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,    -1,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
      -1,    -1,    -1,    -1,   551,    -1,    -1,   554,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,   579,    -1,    -1,    -1,   583,    -1,    -1,   586,
      -1,   588,    -1,     5,   591,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      22,    23,    24,    25,    26,    27,    -1,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
      52,    -1,    54,    55,    -1,    57,    -1,    -1,    -1,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    -1,    74,    -1,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    -1,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,    -1,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,    -1,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,    -1,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,   171,
     172,   173,   174,    -1,    -1,    -1,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
      -1,    -1,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,    -1,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,   236,    -1,    -1,   239,    -1,    -1,
      -1,   243,    -1,    -1,   246,   247,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,   269,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,    -1,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   363,   364,    -1,    -1,   367,   368,   369,    -1,   371,
     372,   373,   374,   375,   376,    -1,    -1,    -1,    -1,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1