/*****************************************************************

  mod_xslt 1.1

  This Apache Module is for translating XML using XSL.

  Copyright (c) 2000 UserActive, Inc.
  By Josh M. Nutzman <modxslt@modxslt.userworld.com>
  And Aidas Kasparas <kaspar@soften.ktu.lt>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; version 2.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  You may copy and distribute this code as long as this copyright
  and disclaimer remains intact.

  NO support is avaliable for this software. Should you like to
  make comments or add to the code, please e-mail
  modxslt@modxslt.userworld.com.
 
*****************************************************************/

/* Changes:
   20000819 Added XSLTDebug directive and Dynamic Document/Stylesheet
	support -- Aidas Kasparas kaspar@soften.ktu.lt

 */

#include <sys/stat.h>
#include <unistd.h>
#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "ap_config.h"
#include "util_uri.h"
#include "alloc.h"
#include "http_core.h"
#include "sablot.h"
#include "http_log.h"
#include "http_request.h"

#define MAXCHAR 2048 

typedef struct {
    int dyndoc;
    int dynss;
    int debug;
} mod_xslt_cfg;

module MODULE_VAR_EXPORT mod_xslt_module;

const char *mod_xslt_dyndoc_cmd(cmd_parms *cmd, void *m, int flag);
const char *mod_xslt_dynss_cmd(cmd_parms *cmd, void *m, int flag);
const char *mod_xslt_debug_cmd(cmd_parms *cmd, void *m, int flag);
const char *mod_xslt_tmppath_cmd(cmd_parms *cmd, void *m, char * path);

command_rec mod_xslt_cmds[] = {
{ "XSLTDynamicDoc", mod_xslt_dyndoc_cmd, NULL, OR_ALL, FLAG,
    "Is Dynamic generation of XML files allowed"},
{ "XSLTDynamicSS", mod_xslt_dynss_cmd, NULL, OR_ALL, FLAG,
    "Is Dynamic generation of StyleSheet files allowed"},
{ "XSLTDebug", mod_xslt_debug_cmd, NULL, OR_ALL, FLAG,
    "Is Debugging of transformations allowed"},
{ "XSLTtmpPath", mod_xslt_tmppath_cmd, NULL, RSRC_CONF, TAKE1,
    "Path to directory where to store temporary files"},
{ NULL }
};

#define MODXSLTTMPPATHLEN 100
static mod_xslt_tmppath_isset = 0;
static char mod_xslt_tmppath[MODXSLTTMPPATHLEN]="";


const char *mod_xslt_dyndoc_cmd(cmd_parms *cmd, void *m, int flag){
    if (flag && ! mod_xslt_tmppath_isset)
	return "XSLTDynamicDoc: You need to have XSLTtmpPath in server config to use Dynamic Documents\n";
    ((mod_xslt_cfg*)m) -> dyndoc = flag;
    return NULL;
};

const char *mod_xslt_dynss_cmd(cmd_parms *cmd, void *m, int flag){
    if (flag && ! mod_xslt_tmppath_isset)
	return "XSLTDynamicSS: You need to have XSLTtmpPath in server config to use Dynamic SpreadSheets\n";
    ((mod_xslt_cfg*)m) -> dynss = flag;
    return NULL;
};

const char *mod_xslt_debug_cmd(cmd_parms *cmd, void *m, int flag){
    ((mod_xslt_cfg*)m) -> debug = flag;
    return NULL;
};

const char *mod_xslt_tmppath_cmd(cmd_parms *cmd, void *m, char * path){
    struct stat stat;
    if (*path != '/'){
	return "XLSTtmpPath: directory name should be absolute - start with /\n";
    }
    if (lstat(path, &stat)){
        return "XLSTtmpPath: can't get file's status\n";
    }
    if ( stat.st_mode & 07777 == 0700 ) {
	return "XSLTtmpPath: directory permitions should be exactly 0700\n";
    }
    if ( strlen(path) >= MODXSLTTMPPATHLEN){
	return "XSLTtmpPath: directory name length is too big\n";
    }

    /* Everything is OK */
    strcpy(mod_xslt_tmppath, path);
    mod_xslt_tmppath_isset = 1;
    return NULL;
};

char *mod_xslt_mkcfg(pool *p){
    mod_xslt_cfg *cfg = ap_palloc(p, sizeof(mod_xslt_cfg));
    cfg->dyndoc = cfg->dynss = 0;
    cfg->debug = 1;
    return (char*) cfg;
}

const char *mod_xslt_create_server_cfg(pool *p, server_rec *s){
    return mod_xslt_mkcfg(p);
};

const char *mod_xslt_create_dir_cfg(pool *p, server_rec *s){
    return mod_xslt_mkcfg(p);
};

int mod_xslt_debug_out(request_rec *r, char* str){
  r->content_type = ap_pstrcat(r->pool, "text/plain", NULL);
  ap_send_http_header(r);
  ap_rputs(str, r);
  return OK;
};

int mod_xslt_debug_err(request_rec *r, char* str){
  r->status = 500;
  r->content_type = ap_pstrcat(r->pool, "text/plain", NULL);
  ap_send_http_header(r);
  ap_rputs(str, r);
  return OK;
};

/* Sablot Message Handlers */

MH_ERROR mod_xslt_makecode( void *u, SablotHandle p,
	int severity, unsigned short f, unsigned short code){
  return 100;
};

MH_ERROR mod_xslt_log(    void *userData, SablotHandle processor_,
    MH_ERROR code, MH_LEVEL level, char **fields){
  request_rec * r = (request_rec*) userData;
  char * c = "";
  char ** cc;
  return 0;
  /* This is not used at the moment... But who knows, maybe it will be
     usefull --AK */
  c = ap_psprintf(r->pool, "XSLT LOG: %d\n", level);
  for (cc=fields; *cc!=NULL; cc++){
    c = ap_pstrcat(r->pool, c, *cc, "\n", NULL);
  }
  mod_xslt_debug_out(r, c);
  return 10; 
};

MH_ERROR mod_xslt_error(void *userData, SablotHandle processor_,
    MH_ERROR code, MH_LEVEL level, char **fields){
  request_rec * r = (request_rec*) userData;
  char * c = "";
  char ** cc;

  c = ap_psprintf(r->pool, "XSLT ERROR: %d\n", level);
  for (cc=fields; *cc!=NULL; cc++){
    c = ap_pstrcat(r->pool, c, *cc, "\n", NULL);
  }
  mod_xslt_debug_out(r, c);
  return 10; 
};

MessageHandler sablotMH = {
  mod_xslt_makecode,
  mod_xslt_log,
  mod_xslt_error};

int transform(request_rec *r, char *styleSheetStr, char *inputStr, char **resultStr) {
  int se;
  char *argums[] =
  {
    "/_stylesheet", styleSheetStr,
    "/_xmlinput", inputStr,
    "/_output", NULL, //was: *resultStr,
    NULL
  };

    void *theproc;
    mod_xslt_cfg *cfg = (mod_xslt_cfg*) 
	ap_get_module_config(r->per_dir_config, &mod_xslt_module);
    se = SablotCreateProcessor (&theproc);
    if (cfg->debug)
      se |= SablotRegHandler(theproc, HLR_MESSAGE, &sablotMH, (void*)r);
    se |= SablotRunProcessor(theproc,"arg:/_stylesheet","arg:/_xmlinput","arg:/_output",NULL,argums);
    se |= SablotGetResultArg(theproc,"arg:/_output", resultStr);
    se |= SablotDestroyProcessor(theproc);
    return se;
}

void mod_xslt_init() {
  ap_add_version_component("mod_xslt/1.0");
}

#define RECURSELEVEL "X-mod_xslt-recurse-level"

static int mod_xslt_handler(request_rec *r) {
  FILE * sfh;
  FILE * xfh;
  char * sourcefilename = NULL;
  char * xslfilename = NULL;
  char * mimetype = NULL;
  char * filename = NULL;
  char * tmpfilename = NULL;
  char * tmp = NULL;
  char * tmp2 = NULL; 
  char * tmp3 = NULL;
  char * key = NULL;
  char * xmltext = NULL;
  char * xsltext = NULL;
  char * doctype = NULL;
  char temp[MAXCHAR + 1];
  char * xslt = NULL;
  char * submethod = NULL;
  char * recurse_level = NULL;  
  int savefh = 0;
  int pid = 0;
  static int cnt = 0;
  int cnt1;
  request_rec * subr = NULL;
  mod_xslt_cfg *cfg = (mod_xslt_cfg*) 
	ap_get_module_config(r->per_dir_config, &mod_xslt_module);


  /* Setup some common strings of text, for file not found, etc. */
 
  regmatch_t pmatch[2];
  regex_t *cpat = ap_pregcomp(r->pool, "\\<!DOCTYPE", REG_EXTENDED);

  int rc = OK;
  int se = 1;

  mimetype = ap_pstrcat(r->pool,r->filename,NULL);
  filename = ap_pstrcat(r->pool,r->filename,NULL);
  doctype = NULL;

  /* XXX: At the moment we support just GET method. To post results just use script that is
          handled by different module and redirect to script which shows results --AK */
  if (r->method_number != M_GET) return DECLINED;

  recurse_level = ap_table_get(r->headers_in, RECURSELEVEL);
  if (recurse_level){
    if (strlen(recurse_level) > 5){
      if (cfg->debug){
	mod_xslt_debug_err(r, "XSLT DEBUG: Recursion is too deep (5 levels)\n"); 
	return SERVER_ERROR;
      } else {
	ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_ERR, r->server, "Recursion is too deep (5 levels)\n");
	return SERVER_ERROR;
      }
    } else
        ap_table_set(r->headers_in,RECURSELEVEL, ap_pstrcat(r->pool, recurse_level, "1", NULL));
  } else ap_table_set(r->headers_in,RECURSELEVEL, "1");

  /* Now each has its own copy of the filename. Parse it out and get what we want. */
  while (*mimetype && (key = ap_getword_nulls_nc(r->pool,&mimetype,'/') )) {}
  while (*key && (mimetype = ap_getword_nulls_nc(r->pool,&key,'.') )) {}
  
  while (*filename && (key = ap_getword_nulls_nc(r->pool,&filename,'/') )) {}
  filename = ap_getword_nulls_nc(r->pool,&key,'.');

  if (!strcmp("xml",mimetype))
    if (cfg->debug){
      return mod_xslt_debug_out(r, "XSLT DEBUG: \"AddHandler mod_xslt .xml\" will cause infinite
      recursion. Remove it!\n"); 
      return ;
    } else {
      ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_ERR, r->server, "\"AddHandler mod_xslt .xml\" will cause infinite
      recursion. Remove it!\n");
      return SERVER_ERROR;
    }


  /* Ok, now put together the proper file names and the content-type. */
  sourcefilename = ap_pstrcat(r->pool,filename,".xml",NULL); 

  xmltext = ap_pstrcat(r->pool,NULL);
  xsltext = ap_pstrcat(r->pool,NULL);

  ap_chdir_file(r->filename);
  if (cfg->dyndoc == 0){
          /* we want a static contents */
	  sfh = ap_pfopen(r->pool, sourcefilename, "r");
	  if (sfh == NULL) {
	     r->uri = sourcefilename;
	     return NOT_FOUND;
	  }

  } else {
    /* we want dynamic contents */
         /* adding query-string parameters */
    if (!strcmp(r->method, "GET"))
    	sourcefilename = ap_pstrcat(r->pool, sourcefilename, "?", r->args, NULL);
	
    /* for first document we could use the same method as for the main request */
    subr = ap_sub_req_method_uri(r->method, sourcefilename, r);
    if (!ap_is_HTTP_SUCCESS(subr->status)){
    	ap_run_sub_req(subr);
	return subr->status;
    }
    savefh  = subr->connection->client->fd;

    pid = getpid();
    cnt1 = ++cnt; /* XXXX change this when port to apache 2.0 --AK */
    tmpfilename = ap_psprintf(r->pool, "%s/%d.%d.xml", 
		mod_xslt_tmppath, pid, cnt1);
    sfh = ap_pfopen(subr->pool, tmpfilename, "w");
    subr->connection->client->fd=fileno(sfh);
    ap_run_sub_req(subr);
    ap_rflush(subr);
    ap_pfclose(subr->pool, sfh);
    subr->connection->client->fd=savefh;
    sfh = ap_pfopen(r->pool, tmpfilename, "r");
	  if (sfh == NULL) {
	     r->uri = sourcefilename;
	     return NOT_FOUND;
	  }
  }
  while (fgets(temp,MAXCHAR, sfh) ) {
    xmltext = ap_pstrcat(r->pool,xmltext,temp,NULL);
    /* Grab the DOCTYPE, so we can determine which xsl file to use. */
    if (regexec(cpat,temp, cpat->re_nsub+1, pmatch, 0) == 0) {
      doctype = ap_pstrcat(r->pool,temp, NULL);
    }
  }

  /* removing temporary file if created */
  if (tmpfilename) unlink(tmpfilename);
  tmpfilename = NULL;

  if (doctype == NULL) {
    if (cfg->debug){
      return mod_xslt_debug_out(r, 
	ap_pstrcat(r->pool,"XSLT DEBUG: Can't determine DOCTYPE for file ", 
		sourcefilename, ".\n", NULL)); 
    } else {
      ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_ERR, r->server, "Can't determine DOCTYPE for file %s.", sourcefilename);
      return SERVER_ERROR;
    }
  }
  tmp = strchr(doctype,' ');
  if (tmp != NULL){
    tmp3 = strchr(tmp+1,' ');
    if (tmp3 != NULL) tmp3[0]= (char)NULL;
    doctype = &tmp[1];
  }
  tmp2 = strchr(doctype,'>');
  if (tmp2 != NULL) tmp2[0] = (char)NULL;
   
  xslfilename = ap_pstrcat(r->pool,doctype,"_",mimetype,".xsl",NULL);
  if (cfg->dynss == 0){
      xfh = ap_pfopen(r->pool, xslfilename, "r");

      if (xfh == NULL) {
	r->uri = xslfilename;
	return NOT_FOUND;
      }
  } else {
    /* we want dynamic stylesheet */
         /* adding query-string parameters */
    xslfilename = ap_pstrcat(r->pool, xslfilename, "?", r->args, NULL);
         /* for second request we should check to not put anything other 
	    than GET if info has been retrieved once */
    submethod = r->method;
    if (cfg->dyndoc == 1){
    	submethod = ap_pstrcat(r->pool, "GET", NULL);
	ap_table_set(r->subprocess_env, "QUERY_STRING", "");
	ap_table_set(r->subprocess_env, "CONTENT_LENGTH", "0");
    }
    subr = ap_sub_req_method_uri(submethod, xslfilename, r);
    if (!ap_is_HTTP_SUCCESS(subr->status)){
    	ap_run_sub_req(subr);
	return subr->status;
    }
    savefh  = subr->connection->client->fd;

    pid = getpid();
    cnt1 = ++cnt; /* XXXX change this when port to apache 2.0 --AK */
    tmpfilename = ap_psprintf(r->pool, "%s/%d.%d.xml", 
		mod_xslt_tmppath, pid, cnt1);
    sfh = ap_pfopen(subr->pool, tmpfilename, "w");
    subr->connection->client->fd=fileno(sfh);
    ap_run_sub_req(subr);
    ap_rflush(subr);
    ap_pfclose(subr->pool, sfh);
    subr->connection->client->fd=savefh;
    xfh = ap_pfopen(r->pool, tmpfilename, "r");
	  if (sfh == NULL) {
	     r->uri = sourcefilename;
	     return NOT_FOUND;
	  }
  }

  while (fgets(temp,MAXCHAR, xfh) ) {
    xsltext = ap_pstrcat(r->pool,xsltext,temp,NULL);

  }
  /* removing temporary file if created */
  if (tmpfilename) unlink(tmpfilename);
  tmpfilename = NULL;

  if (rc == OK) {

    /* This is fun! Now actually translate the documents, since we've loaded both of them. */
    if(xsltext !=NULL && xmltext != NULL) {
      se = transform(r,xsltext,xmltext, &xslt);
    } 
    if (se) {
      rc = SERVER_ERROR;
    }
    if (xslt && rc == OK) {
      ap_send_http_header(r);
      ap_rputs(xslt,r);
      SablotFree(xslt);
      xslt = NULL;
    } else {
      if (cfg->debug) return OK; 
      rc = SERVER_ERROR;
    }
  }
  return rc;
}

/* Dispatch list of content handlers */
static const handler_rec mod_xslt_handlers[] = { 
    { "mod_xslt", mod_xslt_handler }, 
    { NULL, NULL }
};

/* Dispatch list for API hooks */
module MODULE_VAR_EXPORT mod_xslt_module = {
    STANDARD_MODULE_STUFF, 
    mod_xslt_init,                  /* module initializer                  */
    mod_xslt_create_dir_cfg,    /* create per-dir    config structures */
    NULL,                  /* merge  per-dir    config structures */
    mod_xslt_create_server_cfg, /* create per-server config structures */
    NULL,                  /* merge  per-server config structures */
    mod_xslt_cmds,         /* table of config file commands       */
    mod_xslt_handlers,       /* [#8] MIME-typed-dispatched handlers */
    NULL,                  /* [#1] URI to filename translation    */
    NULL,                  /* [#4] validate user id from request  */
    NULL,                  /* [#5] check if the user is ok _here_ */
    NULL,                  /* [#3] check access by host address   */
    NULL,                  /* [#6] determine MIME type            */
    NULL,                  /* [#7] pre-run fixups                 */
    NULL,                  /* [#9] log a transaction              */
    NULL,                  /* [#2] header parser                  */
    NULL,                  /* child_init                          */
    NULL,                  /* child_exit                          */
    NULL                   /* [#0] post read-request              */
};
