/*
  $Id:$
 */

#include <stdlib.h>
#include <stdio.h>
#ifdef M_HAVE_READLINE
#include <readline/readline.h>
#include <readline/history.h>
#endif
#include <setjmp.h>
#include "minami.h"
#include "scene.h"

static jmp_buf env;

#ifndef M_HAVE_READLINE
char *
readline(char *prompt)
{
    int len;
    char *ret;
    char *p;
    char buf[BUFSIZ];

    fmtmsg("%s", prompt);
    p = fgets(buf, BUFSIZ-1, stdin);
    if(p == NULL){
	freopen("/dev/tty", "r", stdin);
	return NULL;
    }
    len = strlen(buf);
    ret = malloc(len + 1);
    if(ret == NULL)
	return NULL;
    
    strcpy(ret, buf);
    if(len > 0 && ret[len-1] == '\n')
	ret[len-1] = '\0'; 

    return ret;
}
#endif

/* ä򤷤Ƥ뤫ɤ */
int
Q_Talk(int scene)
{
    int w = you.wear;
    int p = you.puton;

    if(w == ITEM_DAEMON_ROBE ||
       (!you.f_female && w == ITEM_EVENING_DRESS) ||
       (!you.f_female && w == ITEM_ONE_PIECE_DRESS) ||
       (!you.f_female && w == ITEM_COSTUME) ||
       p == ITEM_WIG ||
       (!you.f_female && p == ITEM_LINGERIE)){
	return MIN_FALSE;
    }
    return MIN_TRUE;
}

/*  ͤܤ˸Ȥˤ뤫ʤ */
int
Q_Town(int scene)
{
    if(scene >= DUMMY)
	return MIN_FALSE;

    return MIN_TRUE;
}

int
SelectItem(const char *prompt)
{
    int i = 0;
    int n;
    char *b;

    def_action_i(0, NULL, NULL);
    fmtmsg("\n");
    while(1){
	b = readline((char *)prompt);
	if(!b)
	    return 0;

	if(EQ(b, "0")){
	    n = 0;
	    goto LoopOut;
	}
	if(atoi(b) != 0){
	    n = 0;
	    for(i=0 ; i<NUM_ITEMS ; ++i){
		if(I_Have(i)){
		    ++n;
		    if(n == atoi(b))
			goto LoopOut;
		}
	    }
	}
    }
 LoopOut:    
    return i;
}

int
Answer(const char *prompt, const char *ans)
{
    char *b;

    b = readline((char *)prompt);

    if(EQ(b, ans)){
	free(b);
	return MIN_OK;
    }
    free(b);
    return MIN_NG;
}

int 
Yn(const char *prompt)
{
    int c;

    while(1){
	fmtmsg("\n\n%s", prompt);
	c = Getc();
	if((c != 'y' && c != 'n') && (c != 'Y' && c != 'N')){
	    fmtmsg("\nynƤ\n");
	    continue;
	}
	break;
    }
    fmtmsg("\n");
    return c;
}

int
Select(const char *prompt, int n)
{
    int c;

    while(1){
	fmtmsg("%s\n", prompt);
	c = Getc();
	if(c < '1' || c > '0' + n){
	    fmtmsg("\n1%dϰϤϤƤ\n", n);
	    continue;
	}
	break;
    }

    return c - '0';
}

int
Prompt(char *verb, char *obj)
{
    int i, n, n0;
    char *buf;
    char *arg[16];
    char *p;

    if(setjmp(env) == 0)
	;

    fmtmsg("\n\n");

    buf = readline("Ƥɤ롩> ");

    /* skip space */
    p = buf;
    if(!p)
	return -1;
#ifdef M_HAVE_READLINE
    add_history(buf);
#endif

    while(*p && (*p == ' ' || *p == '\t'))
	++p;

    if(!*p){
	free(buf);
	*verb = 0;
	*obj = 0;
	return 0;
    }

    i = 0;
    for(i=0 ; *p && i<16 ; ){
	arg[i] = p;
	++i;
	while(*p && *p != ' ' && *p != '\t')
	    ++p;
	if(!*p)
	    break;
	*p = '\0';
	++p;
	
	while(*p && (*p == ' ' || *p == '\t'))
	    ++p;
    }

    n = i;
    n0 = 1;

    *verb = '\0';
    *obj = '\0';
/*
  Ūưϰlook atפΤ褦ˤ褯Ȥ
  ñˤƤϣ
 */
    if(n >= 2){
	if(EQ(arg[0], "look") && EQ(arg[1], "at")){
	    ++n0;
	    strcpy(verb, "look_at");
	}
	else if(EQ(arg[0], "put") && EQ(arg[1], "on")){
	    ++n0;
	    strcpy(verb, "put_on");
	}
	else if(EQ(arg[0], "take") && EQ(arg[1], "off")){
	    ++n0;
	    strcpy(verb, "take_off");
	}
	else if(EQ(arg[0], "pick") && EQ(arg[1], "up")){
	    ++n0;
	    strcpy(verb, "pick_up");
	}
    }
    if(!*verb)
	strcat(verb, arg[0]);
/*
  褯Ȥά
*/
    if(EQ(verb, "continue") || EQ(verb, "north") ||
       EQ(verb, "south") || EQ(verb, "east") ||
       EQ(verb, "west") || EQ(verb, "inventory") ||
       EQ(verb, "down") || EQ(verb, "up") ||
       EQ(verb, "map"))
	verb[1] = '\0';
/*
  alaisư
 */
    else if(EQ(verb, "?"))
	strcpy(verb, "help");
    else if(EQ(verb, "check") || EQ(verb, "inspect") || EQ(verb, "look_at"))
	strcpy(verb, "look");
    else if(EQ(verb, "apply"))
	strcpy(verb, "use");
    else if(EQ(verb, "pick_up") || EQ(verb, "pickup"))
	strcpy(verb, "get");
    else if(EQ(verb, "put_on"))
	strcpy(verb, "wear");

    for(i=n0 ; i<n ; ++i){
	if(i != n0)
	    strcat(obj, " ");
	strcat(obj, arg[i]);
    }
/*
  aliasŪ
*/
    if(EQ(obj, "BSD magazine"))
	strcpy(obj, "book");
    else if(EQ(obj, "men") || EQ(obj, "boy"))
	strcpy(obj, "man");
    else if(EQ(obj, "women") || EQ(obj, "girl"))
	strcpy(obj, "woman");
    else if(EQ(obj, "men in black"))
	strcpy(obj, "man in black");
    else if(EQ(obj, "daemon-kun"))
	strcpy(obj, "daemon");

    free(buf);
    fmtmsg("\n");

    return 0;
}

int
UseMap(int n, int typ)
{
    if(typ == 0){
	switch(n){
	case 1:
	    fmtmsg("
        -----   -----
        |   |   |   |
        |   |   | > |
        |   |   |   |
        --+--   -----
          #
-----   --+--   -----
|   |   |   |   |   |
|   +###+   +###+   |
|   |   |   |   |   |
--+--   -----   --+--
  #               #
--+--   -----   --+--
|   |   |   |   |   |
|<  |   |<  |   |  >|
|   |   |   |   |   |
-----   --#--   -----
          #
###########
");
	    break;
	case 2:
	    fmtmsg("
-----   -----   -----
|   |   |   |   |   |
|   +###+   |   | < |
|   |   |   |   |   |
--+--   --+--   --+--
  #       #       #
--+--   --+--   --+--
|   |   |   |   |   |
|   |   |   +###+   |
|   |   |   |   |   |
--+--   -----   --+--
  #               #
--+--   -----   --+--
|   |   |   |   |   |
| > |   |< >|   | < |
|   |   |   |   |   |
-----   -----   -----
");
	    break;
	case 3:
	    fmtmsg("
        -----   -----
        |   |   |   |
        | { +###+   |
        |   |   |   |
        --+--   -----
          #
-----   --+--   -----
|   |   |   |   |   |
|   +###+   +###+   |
|   |   |   |   |   |
--+--   -----   --+--
  #               #
--+--   -----   --+--
|   |   |   |   |   |
|<  |   |< >|   |  >|
|   |   |   |   |   |
-----   -----   -----
");
	    break;
	case 4:
	    fmtmsg("
-----   -----   -----
|   |   |   |   |   |
|   +###+   +###+  >|
|   |   |   |   |   |
--+--   --+--   --+--
  #       #       #
--+--   --+--   --+--
|   |   |   |   |   |
|   |   | @ |   |   |
|   |   |   |   |   |
--+--   -----   -----
  #             
--+--   -----   -----  
|   |   |   |   |   |
|   +###+<  +###+<  |
|   |   |   |   |   |
-----   -----   -----
");
	    break;
	case 5:
	    fmtmsg("
        -----   -----
        |   |   |   |
        |   +###+<  |
        |   |   |   |
        -----   --+--
                  #
        -----   --+--
        |   |   |   |
        |   +###+   |
        |   |   |   |
        -----   --+--
                  #             
                --+--
                |   |   
                | _ |   
                |   |   
                -----
");
	    break;
	}
	return 1;
    }
    else if(typ == 1){
	fmtmsg("
+###+###+###+   +
#   #       #   #
#   #       #   #
+   +###+   +###+
#       #       #
#       #       #
+###+###+###+   +
    #           #
    #           #
+   +###+###+   <
#           #
#           #
+###+###+###+###<
");
	return 1;
    }
    else if(typ == 2){
	switch(n){
	case 51:
	    fmtmsg("
+-+-+-+
|     |
+     +
|     |
+     +
|     |
+-+-< >
");
	    break;
	case 52:
	    fmtmsg("
+-+-+-+
|     |
+     +
|     |
+     +
|     |
+-< >-+
");
	    break;
	case 53:
	    fmtmsg("
+-+-+-+
|     |
+     +
|     |
+     +
|     |
< >-+-+
");
	    break;
	case 55:
	    fmtmsg("
<------
      |
----- |
|   | |
| >-- |
|     |
-------
");
	    break;
	case 56:
	    fmtmsg("
>------
      |
----- |
|   | |
| <-- |
|     |
-------
");
	    break;
	case 57:
	    fmtmsg("
-------
|     |
----- |
    | |
< >-- |
|     |
-------
");
	    break;
	case 58:
	    fmtmsg("
  + +-+
  |   |
>-+ +-< 
  |   |
  + +-+
");
	    break;
	}
    }
    return 0;
}

int
LookCandelabrum()
{
    Inventory  *i = &(you.items[ITEM_CANDELABRUM]);

    if(i->quan == 0)
	fmtmsg("ϼĤƤʤ", i->quan);
    else if(i->quan == 7)
	fmtmsg("%dƤΤĤƤ롣", i->quan);
    else
	fmtmsg("%dܤΤĤƤ롣", i->quan);

    return MIN_OK;
}
