#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/types.h>
#include <ctype.h>
#include <fcntl.h>
/*
#include <readline/readline.h>
#include <readline/history.h>
*/
#include "minami.h"
#include "scene.h"

#define MON_WEAK		1
#define MON_STRONG		(1<<1)
#define MON_WEAPON		(1<<2)

#define BATTLE_PROTECT		1

#define RESULT_WIN		1
#define RESULT_LOOSE		0

Monst montab[] =
{
    {"", 25, 0, MON_WEAK},
    {"ܥ", 25, 0, MON_WEAK},
    {"ּҰ", 60, 0, MON_WEAK},
    {"", 60, 0, MON_STRONG | MON_WEAPON},
    {"Ź", 25, 0, MON_WEAPON},
    {"ɥޥ", 60, 0, MON_STRONG | MON_WEAPON},
};

static char *
bar(int c, int n)
{
    char *ret, *p;

    if(n > 79)
	n = 79;
    p = ret = malloc(n+1);
    while(n > 0){
	*(p++) = '*';
	--n;
    }
    *p = '\0';

    return ret;
}

static void
hpbar(int n, Monst *mons)
{
    char *_bar;

    fmtmsg("\n\n");

    while(n > 0){
	_bar = bar('*', mons->hp);
	fmtmsg("%8s HP(%2d):%s\n", mons->name, mons->hp, _bar);
	free(_bar);
	++mons;
	--n;
    }

    fmtmsg("\n");

    _bar = bar('*', you.hp);
    fmtmsg("%8s HP(%2d):%s\n", you.name, you.hp, _bar);
    free(_bar);
}

static int
your_phase(int n, Monst *mons, int *flag)
{
    int c;
    int c2;
    int dmg = 0;
    Monst *m;
    int good_weapon = 0;

    if(you.wield == ITEM_EXCALIBUR)
	good_weapon = 1;

    *flag = 0;
/*    hpbar(n, mons);*/

    fmtmsg("\n[ʤι]
1.      2.ޤۤ
3. ƥ     4.ޤ
5. ˤ
");
    c = Select("", 5);
    c2 = 0;
    m = &mons[0];

    if(n > 1){
	fmtmsg("\n[ɤ򹶷⤹롩]\n");
	fmtmsg("%d) %s ", 1, mons[0].name);
	fmtmsg("%d) %s", 2, mons[1].name);
	c2 = Select("", 2);
	m = &mons[c2 - 1];
    }
	

    switch(c){
    case 1:
	if(you.wield){
	    fmtmsg("ʤ%s򹶷⤷\n", m->name);
	    dmg = 10 + good_weapon * 10;
	}
	else{
	    fmtmsg("ʤ%sǼؤ꤫ä\n", m->name);
	    dmg = 7;
	}
	More();
	if(m->prop & MON_WEAK || good_weapon){
	    fmtmsg("%s%dΥ᡼\n", m->name, dmg);
	    m->hp -= dmg;
	}
	else if(m->prop & MON_STRONG)
	    fmtmsg("%sϥҥȿȤ򤫤路\n", m->name, dmg);
	
	if(m->hp <= 0){
	    fmtmsg("ʤ%sݤ\n", m->name);
	    if(c2 == 0)
		mons[0] = mons[1];
	    --n;
	}
	break;
    case 2:
	fmtmsg("ʤˡΤʤ\n");
	break;
    case 3:
    {
	int i;
	ItemTab *itab;
	
	i = SelectItem("ɤΥƥȤޤ");
	itab = ItemByNum(i);
	fmtmsg("ʤ%sȤäⵯʤä\n", 
	       ItemName(i));
    }
    break;
    case 4:
	fmtmsg("ʤϿȤä\n");
	*flag |= BATTLE_PROTECT;
	break;
    case 5:
	fmtmsg("ƨʤ\n");
	break;
    default:
	break;
    }
    More();
    
    return n;
}

int
mon_phase(int n, Monst *m, int *flag)
{
    int dmg;
    int protect = 1;

    if(*flag & BATTLE_PROTECT)
	protect = 2;

    if(m->prop & MON_WEAPON){
	fmtmsg("%sϤʤڤĤ\n", m->name);
	dmg = 7/protect;
    }
    else{
	fmtmsg("%sϤʤ˳ߤĤƤ\n", m->name);
	dmg = 7/protect;
    }
    More();
    if(m->prop & MON_WEAK){
	fmtmsg("ʤ%dΥ᡼\n", dmg/2);
	you.hp -= dmg / 2;
    }
    else{
	fmtmsg("ʤ%dΥ᡼\n", dmg);
	you.hp -= dmg;
    }
    More();

    return n;
}

static int
battle(int n, Monst *mons)
{
    int rnd;
    int flag;

    while(n > 0){
	flag = 0;
	hpbar(n, mons);
	n = your_phase(n, mons, &flag);
	hpbar(n, mons);
	if(n == 0)
	    break;
	else if(n == 1)
	    mon_phase(n, &mons[0], &flag);
	else{
	    rnd = random()%2;
	    mon_phase(n, &mons[rnd], &flag);
	    mon_phase(n, &mons[(rnd+1)%2], &flag);
	}
	if(you.hp <= 0){
	    fmtmsg("ʤϻˤޤġġġ\n");
	    return RESULT_LOOSE;
	}
    }	
    fmtmsg("ʤƮ˾\n");
    return RESULT_WIN;
}

int
Battle(int scene, int typ, int win, int loose)
{
    int ret;
    Monst mons[1];

    mons[0] = montab[typ];

    More();
    ret = battle(1, mons);
    if(ret == RESULT_LOOSE)
	return loose;

    return win;
}

int
Battle2(int scene, int typ, int typ2, int win, int loose)
{
    int ret;
    Monst mons[2];

    mons[0] = montab[typ];
    mons[1] = montab[typ2];

    More();
    ret = battle(2, mons);
    if(ret == RESULT_LOOSE)
	return loose;

    return win;
}
