/* discard.c - discard output on a file pointer */
#ifndef	lint
static char ident[] = "@(#)$Id: discard.c,v 1.7 1993/02/26 21:56:04 jromine Exp $";
#endif	/* lint */

#include "../h/mh.h"
#include <stdio.h>
#ifdef POSIX
#include <termios.h>
#else
#ifndef	SYS5
#include <sgtty.h>
#else	/* SYS5 */
#include <sys/types.h>
#include <termio.h>
#ifndef	NOIOCTLH
#include <sys/ioctl.h>
#endif	/* NOIOCTLH */
#endif	/* SYS5 */
#endif	/* POSIX */

#ifdef __CYGWIN32__
#include <errno.h>
#define	HASUB(fp) ((fp)->_ub._base != NULL)
#define	FREEUB(fp) { \
	if ((fp)->_ub._base != (fp)->_ubuf) \
		free((char *)(fp)->_ub._base); \
	(fp)->_ub._base = NULL; \
}
#endif	/* __CYGWIN32__ */

#ifdef FILE__PTR
#define _ptr  __ptr
#define _cnt  __cnt
#define _base __base
#endif

void	discard (io)
FILE   *io;
{
#ifndef POSIX
#ifndef	SYS5
    struct sgttyb   sg;
#else	/* SYS5 */
    struct termio   sg;
#endif	/* SYS5 */
#endif	/* POSIX */

    if (io == NULL)
	return;

#ifdef POSIX
    tcflush (fileno (io), TCOFLUSH);
#else
#ifndef	SYS5
    if (ioctl (fileno (io), TIOCGETP, (char *) &sg) != NOTOK)
	(void) ioctl (fileno (io), TIOCSETP, (char *) &sg);
#else	/* SYS5 */
    if (ioctl (fileno (io), TCGETA, &sg) != NOTOK)
	(void) ioctl (fileno (io), TCSETA, &sg);
#endif	/* SYS5 */
#endif	/* POSIX */

#ifdef _FSTDIO
    fpurge (io);
#else
#ifdef _STDIO_USES_IOSTREAM
    io -> _IO_write_ptr = io -> _IO_write_base;
#else
    if (io -> _ptr = io -> _base)
	io -> _cnt = 0;
#endif /* _STDIO_USES_IOSTREAM */
#endif
}

#ifdef __CYGWIN32__
int	fpurge (FILE *io)
{
	if (!io->_flags) {
		errno = EBADF;
		return(EOF);
	}

	if (HASUB(io))
		FREEUB(io);
	io->_p = io->_bf._base;
	io->_r = 0;
	io->_w = io->_flags & (__SLBF|__SNBF) ? 0 : io->_bf._size;
	return (0);
}
#endif
