//===-- Analysis.cpp ------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

#include "llvm-c/Analysis.h"
#include "llvm/InitializePasses.h"
#include "llvm/Analysis/Verifier.h"
#include <cstring>

using namespace llvm;

/// initializeAnalysis - Initialize all passes linked into the Analysis library.
void llvm::initializeAnalysis(PassRegistry &Registry) {
  initializeAliasAnalysisAnalysisGroup(Registry);
  initializeAliasAnalysisCounterPass(Registry);
  initializeAAEvalPass(Registry);
  initializeAliasDebuggerPass(Registry);
  initializeAliasSetPrinterPass(Registry);
  initializeNoAAPass(Registry);
  initializeBasicAliasAnalysisPass(Registry);
  initializeCFGViewerPass(Registry);
  initializeCFGPrinterPass(Registry);
  initializeCFGOnlyViewerPass(Registry);
  initializeCFGOnlyPrinterPass(Registry);
  initializePrintDbgInfoPass(Registry);
  initializeDominanceFrontierPass(Registry);
  initializeDomViewerPass(Registry);
  initializeDomPrinterPass(Registry);
  initializeDomOnlyViewerPass(Registry);
  initializePostDomViewerPass(Registry);
  initializeDomOnlyPrinterPass(Registry);
  initializePostDomPrinterPass(Registry);
  initializePostDomOnlyViewerPass(Registry);
  initializePostDomOnlyPrinterPass(Registry);
  initializeIVUsersPass(Registry);
  initializeInstCountPass(Registry);
  initializeIntervalPartitionPass(Registry);
  initializeLazyValueInfoPass(Registry);
  initializeLibCallAliasAnalysisPass(Registry);
  initializeLintPass(Registry);
  initializeLiveValuesPass(Registry);
  initializeLoopDependenceAnalysisPass(Registry);
  initializeLoopInfoPass(Registry);
  initializeMemDepPrinterPass(Registry);
  initializeMemoryDependenceAnalysisPass(Registry);
  initializeModuleDebugInfoPrinterPass(Registry);
  initializePostDominatorTreePass(Registry);
  initializePostDominanceFrontierPass(Registry);
  initializeProfileEstimatorPassPass(Registry);
  initializeNoProfileInfoPass(Registry);
  initializeNoPathProfileInfoPass(Registry);
  initializeProfileInfoAnalysisGroup(Registry);
  initializePathProfileInfoAnalysisGroup(Registry);
  initializeLoaderPassPass(Registry);
  initializePathProfileLoaderPassPass(Registry);
  initializeProfileVerifierPassPass(Registry);
  initializePathProfileVerifierPass(Registry);
  initializeRegionInfoPass(Registry);
  initializeRegionViewerPass(Registry);
  initializeRegionPrinterPass(Registry);
  initializeRegionOnlyViewerPass(Registry);
  initializeRegionOnlyPrinterPass(Registry);
  initializeScalarEvolutionPass(Registry);
  initializeScalarEvolutionAliasAnalysisPass(Registry);
  initializeTypeBasedAliasAnalysisPass(Registry);
}

void LLVMInitializeAnalysis(LLVMPassRegistryRef R) {
  initializeAnalysis(*unwrap(R));
}

LLVMBool LLVMVerifyModule(LLVMModuleRef M, LLVMVerifierFailureAction Action,
                          char **OutMessages) {
  std::string Messages;

  LLVMBool Result = verifyModule(*unwrap(M),
                            static_cast<VerifierFailureAction>(Action),
                            OutMessages? &Messages : 0);

  if (OutMessages)
    *OutMessages = strdup(Messages.c_str());

  return Result;
}

LLVMBool LLVMVerifyFunction(LLVMValueRef Fn, LLVMVerifierFailureAction Action) {
  return verifyFunction(*unwrap<Function>(Fn),
                        static_cast<VerifierFailureAction>(Action));
}

void LLVMViewFunctionCFG(LLVMValueRef Fn) {
  Function *F = unwrap<Function>(Fn);
  F->viewCFG();
}

void LLVMViewFunctionCFGOnly(LLVMValueRef Fn) {
  Function *F = unwrap<Function>(Fn);
  F->viewCFGOnly();
}
