.\" zip_set_file_compression.mdoc \-- set compression method and its flags
.\" Copyright (C) 2012 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_SET_FILE_COMPRESSION 3 "May 1, 2012" NiH
.SH "NAME"
zip_set_file_compression \- set compression method for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
int
zip_set_file_compression(struct zip *archive, zip_uint64_t index); \
"zip_int32_t comp" "zip_uint32_t comp_flags"
.SH "DESCRIPTION"
The
zip_set_file_compression
function sets the compression method for the file at position
\fBindex\fR
in the zip archive to
\fBcomp\fR
with the compression method specific
\fBcomp_flags.\fR
The
\fBcomp\fR
is the same as returned by
zip_stat(3).
For the
\fBcomp\fR
argument, currently only the following values are supported:
.RS
.TP 19
\fBZIP_CM_DEFAULT\fR
default compression; currently the same as
\fBZIP_CM_DEFLATE.\fR
.TP 19
\fBZIP_CM_STORE\fR
Store the file uncompressed.
.TP 19
\fBZIP_CM_DEFLATE\fR
Deflate the file with the
zlib(3)
algorithm and default options
.RE
.PP
The
\fBcomp_flags\fR
argument is currently ignored.
.\" For the comp_flags argument, the lower 4 bits define the compression
.\" level.
.\" 0 is fastest compression, 15 is highest compression
.\" \fBZIP_COMP_FL_DEFAULT\fR
.\" can be used to specify that the default shall be used.
.\" Further compression method specific flags will be added over time.
.PP
The current compression method for a file in a zip archive can be
determined using
zip_stat(3).
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_set_file_compression
fails if:
.RS
.TP 4
[ZIP_ER_INVAL]
\fBindex\fR
is not a valid file index in
\fBarchive,\fR
or the argument combination is invalid.
.TP 4
[ZIP_ER_COMPNOTSUPP]
Unsupported compression method requested.
.TP 4
[ZIP_ER_RDONLY]
Read-only zip file, no changes allowed.
.RE
.SH "SEE ALSO"
libzip(3),
zip_stat(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
