/*
 * Copyright (c) 2006-2010 Citrix Systems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <string.h>

#include "xen_internal.h"
#include <xen/api/xen_storage_operations.h>
#include "xen_storage_operations_internal.h"


/*
 * Maintain this in the same order as the enum declaration!
 */
static const char *lookup_table[] =
{
    "scan",
    "destroy",
    "forget",
    "plug",
    "unplug",
    "update",
    "vdi_create",
    "vdi_introduce",
    "vdi_destroy",
    "vdi_resize",
    "vdi_clone",
    "vdi_snapshot",
    "undefined"
};


extern xen_storage_operations_set *
xen_storage_operations_set_alloc(size_t size)
{
    return calloc(1, sizeof(xen_storage_operations_set) +
                  size * sizeof(enum xen_storage_operations));
}


extern void
xen_storage_operations_set_free(xen_storage_operations_set *set)
{
    free(set);
}


const char *
xen_storage_operations_to_string(enum xen_storage_operations val)
{
    return lookup_table[val];
}


extern enum xen_storage_operations
xen_storage_operations_from_string(xen_session *session, const char *str)
{
    (void)session;
    return ENUM_LOOKUP(str, lookup_table);
}


const abstract_type xen_storage_operations_abstract_type_ =
    {
        .typename = ENUM,
        .enum_marshaller =
             (const char *(*)(int))&xen_storage_operations_to_string,
        .enum_demarshaller =
             (int (*)(xen_session *, const char *))&xen_storage_operations_from_string
    };


const abstract_type xen_storage_operations_set_abstract_type_ =
    {
        .typename = SET,
        .child = &xen_storage_operations_abstract_type_
    };


