/*
 * Copyright (c) 2006-2010 Citrix Systems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include "xen_internal.h"
#include <xen/api/xen_api_failure.h>


/*
 * Maintain this in the same order as the enum declaration!
 */
static const char *lookup_table[] =
{
    "ACTIVATION_WHILE_NOT_FREE",
    "AUTH_ALREADY_ENABLED",
    "AUTH_DISABLE_FAILED",
    "AUTH_DISABLE_FAILED_PERMISSION_DENIED",
    "AUTH_DISABLE_FAILED_WRONG_CREDENTIALS",
    "AUTH_ENABLE_FAILED",
    "AUTH_ENABLE_FAILED_DOMAIN_LOOKUP_FAILED",
    "AUTH_ENABLE_FAILED_PERMISSION_DENIED",
    "AUTH_ENABLE_FAILED_UNAVAILABLE",
    "AUTH_ENABLE_FAILED_WRONG_CREDENTIALS",
    "AUTH_IS_DISABLED",
    "AUTH_SERVICE_ERROR",
    "AUTH_UNKNOWN_TYPE",
    "BACKUP_SCRIPT_FAILED",
    "BOOTLOADER_FAILED",
    "CANNOT_CONTACT_HOST",
    "CANNOT_CREATE_STATE_FILE",
    "CANNOT_ENABLE_REDO_LOG",
    "CANNOT_EVACUATE_HOST",
    "CANNOT_FETCH_PATCH",
    "CANNOT_FIND_OEM_BACKUP_PARTITION",
    "CANNOT_FIND_PATCH",
    "CANNOT_FIND_STATE_PARTITION",
    "CANNOT_PLUG_VIF",
    "CANNOT_RESET_CONTROL_DOMAIN",
    "CERTIFICATE_ALREADY_EXISTS",
    "CERTIFICATE_CORRUPT",
    "CERTIFICATE_DOES_NOT_EXIST",
    "CERTIFICATE_LIBRARY_CORRUPT",
    "CERTIFICATE_NAME_INVALID",
    "CHANGE_PASSWORD_REJECTED",
    "CPU_FEATURE_MASKING_NOT_SUPPORTED",
    "CRL_ALREADY_EXISTS",
    "CRL_CORRUPT",
    "CRL_DOES_NOT_EXIST",
    "CRL_NAME_INVALID",
    "DB_UNIQUENESS_CONSTRAINT_VIOLATION",
    "DEFAULT_SR_NOT_FOUND",
    "DEVICE_ALREADY_ATTACHED",
    "DEVICE_ALREADY_DETACHED",
    "DEVICE_ALREADY_EXISTS",
    "DEVICE_ATTACH_TIMEOUT",
    "DEVICE_DETACH_REJECTED",
    "DEVICE_DETACH_TIMEOUT",
    "DEVICE_NOT_ATTACHED",
    "DOMAIN_BUILDER_ERROR",
    "DOMAIN_EXISTS",
    "DUPLICATE_PIF_DEVICE_NAME",
    "DUPLICATE_VM",
    "EVENTS_LOST",
    "FEATURE_RESTRICTED",
    "FIELD_TYPE_ERROR",
    "HANDLE_INVALID",
    "HA_ABORT_NEW_MASTER",
    "HA_CONSTRAINT_VIOLATION_NETWORK_NOT_SHARED",
    "HA_CONSTRAINT_VIOLATION_SR_NOT_SHARED",
    "HA_FAILED_TO_FORM_LIVESET",
    "HA_HEARTBEAT_DAEMON_STARTUP_FAILED",
    "HA_HOST_CANNOT_ACCESS_STATEFILE",
    "HA_HOST_CANNOT_SEE_PEERS",
    "HA_HOST_IS_ARMED",
    "HA_IS_ENABLED",
    "HA_LOST_STATEFILE",
    "HA_NOT_ENABLED",
    "HA_NOT_INSTALLED",
    "HA_NO_PLAN",
    "HA_OPERATION_WOULD_BREAK_FAILOVER_PLAN",
    "HA_POOL_IS_ENABLED_BUT_HOST_IS_DISABLED",
    "HA_SHOULD_BE_FENCED",
    "HA_TOO_FEW_HOSTS",
    "HOSTS_NOT_HOMOGENEOUS",
    "HOST_BROKEN",
    "HOST_CANNOT_ATTACH_NETWORK",
    "HOST_CANNOT_DESTROY_SELF",
    "HOST_CANNOT_READ_METRICS",
    "HOST_CD_DRIVE_EMPTY",
    "HOST_DISABLED",
    "HOST_DISABLED_UNTIL_REBOOT",
    "HOST_HAS_NO_MANAGEMENT_IP",
    "HOST_HAS_RESIDENT_VMS",
    "HOST_IN_EMERGENCY_MODE",
    "HOST_IN_USE",
    "HOST_IS_LIVE",
    "HOST_IS_SLAVE",
    "HOST_ITS_OWN_SLAVE",
    "HOST_MASTER_CANNOT_TALK_BACK",
    "HOST_NAME_INVALID",
    "HOST_NOT_DISABLED",
    "HOST_NOT_ENOUGH_FREE_MEMORY",
    "HOST_NOT_LIVE",
    "HOST_OFFLINE",
    "HOST_POWER_ON_MODE_DISABLED",
    "HOST_STILL_BOOTING",
    "HOST_UNKNOWN_TO_MASTER",
    "IMPORT_ERROR",
    "IMPORT_ERROR_ATTACHED_DISKS_NOT_FOUND",
    "IMPORT_ERROR_CANNOT_HANDLE_CHUNKED",
    "IMPORT_ERROR_FAILED_TO_FIND_OBJECT",
    "IMPORT_ERROR_PREMATURE_EOF",
    "IMPORT_ERROR_SOME_CHECKSUMS_FAILED",
    "IMPORT_ERROR_UNEXPECTED_FILE",
    "IMPORT_INCOMPATIBLE_VERSION",
    "INTERFACE_HAS_NO_IP",
    "INTERNAL_ERROR",
    "INVALID_DEVICE",
    "INVALID_EDITION",
    "INVALID_FEATURE_STRING",
    "INVALID_IP_ADDRESS_SPECIFIED",
    "INVALID_PATCH",
    "INVALID_PATCH_WITH_LOG",
    "INVALID_VALUE",
    "IS_TUNNEL_ACCESS_PIF",
    "JOINING_HOST_CANNOT_BE_MASTER_OF_OTHER_HOSTS",
    "JOINING_HOST_CANNOT_CONTAIN_SHARED_SRS",
    "JOINING_HOST_CANNOT_HAVE_RUNNING_OR_SUSPENDED_VMS",
    "JOINING_HOST_CANNOT_HAVE_RUNNING_VMS",
    "JOINING_HOST_CANNOT_HAVE_VMS_WITH_CURRENT_OPERATIONS",
    "JOINING_HOST_CONNECTION_FAILED",
    "JOINING_HOST_SERVICE_FAILED",
    "LICENCE_RESTRICTION",
    "LICENSE_CANNOT_DOWNGRADE_WHILE_IN_POOL",
    "LICENSE_CHECKOUT_ERROR",
    "LICENSE_DOES_NOT_SUPPORT_POOLING",
    "LICENSE_DOES_NOT_SUPPORT_XHA",
    "LICENSE_EXPIRED",
    "LICENSE_FILE_DEPRECATED",
    "LICENSE_PROCESSING_ERROR",
    "LOCATION_NOT_UNIQUE",
    "MAC_DOES_NOT_EXIST",
    "MAC_INVALID",
    "MAC_STILL_EXISTS",
    "MAP_DUPLICATE_KEY",
    "MESSAGE_DEPRECATED",
    "MESSAGE_METHOD_UNKNOWN",
    "MESSAGE_PARAMETER_COUNT_MISMATCH",
    "MISSING_CONNECTION_DETAILS",
    "NETWORK_ALREADY_CONNECTED",
    "NETWORK_CONTAINS_PIF",
    "NETWORK_CONTAINS_VIF",
    "NOT_ALLOWED_ON_OEM_EDITION",
    "NOT_IMPLEMENTED",
    "NOT_IN_EMERGENCY_MODE",
    "NOT_SUPPORTED_DURING_UPGRADE",
    "NO_HOSTS_AVAILABLE",
    "OBJECT_NOLONGER_EXISTS",
    "ONLY_ALLOWED_ON_OEM_EDITION",
    "OPENVSWITCH_NOT_ACTIVE",
    "OPERATION_BLOCKED",
    "OPERATION_NOT_ALLOWED",
    "OTHER_OPERATION_IN_PROGRESS",
    "OUT_OF_SPACE",
    "PATCH_ALREADY_APPLIED",
    "PATCH_ALREADY_EXISTS",
    "PATCH_APPLY_FAILED",
    "PATCH_IS_APPLIED",
    "PATCH_PRECHECK_FAILED_PREREQUISITE_MISSING",
    "PATCH_PRECHECK_FAILED_UNKNOWN_ERROR",
    "PATCH_PRECHECK_FAILED_VM_RUNNING",
    "PATCH_PRECHECK_FAILED_WRONG_SERVER_VERSION",
    "PBD_EXISTS",
    "PERMISSION_DENIED",
    "PIF_ALREADY_BONDED",
    "PIF_BOND_NEEDS_MORE_MEMBERS",
    "PIF_CANNOT_BOND_CROSS_HOST",
    "PIF_CONFIGURATION_ERROR",
    "PIF_DEVICE_NOT_FOUND",
    "PIF_DOES_NOT_ALLOW_UNPLUG",
    "PIF_HAS_NO_NETWORK_CONFIGURATION",
    "PIF_IS_MANAGEMENT_INTERFACE",
    "PIF_IS_PHYSICAL",
    "PIF_IS_VLAN",
    "PIF_TUNNEL_STILL_EXISTS",
    "PIF_VLAN_EXISTS",
    "PIF_VLAN_STILL_EXISTS",
    "POOL_AUTH_ALREADY_ENABLED",
    "POOL_AUTH_DISABLE_FAILED",
    "POOL_AUTH_DISABLE_FAILED_PERMISSION_DENIED",
    "POOL_AUTH_DISABLE_FAILED_WRONG_CREDENTIALS",
    "POOL_AUTH_ENABLE_FAILED",
    "POOL_AUTH_ENABLE_FAILED_DOMAIN_LOOKUP_FAILED",
    "POOL_AUTH_ENABLE_FAILED_DUPLICATE_HOSTNAME",
    "POOL_AUTH_ENABLE_FAILED_INVALID_OU",
    "POOL_AUTH_ENABLE_FAILED_PERMISSION_DENIED",
    "POOL_AUTH_ENABLE_FAILED_WRONG_CREDENTIALS",
    "POOL_JOINING_EXTERNAL_AUTH_MISMATCH",
    "POOL_JOINING_HOST_MUST_HAVE_PHYSICAL_MANAGEMENT_NIC",
    "POOL_JOINING_HOST_MUST_HAVE_SAME_PRODUCT_VERSION",
    "PROVISION_FAILED_OUT_OF_SPACE",
    "PROVISION_ONLY_ALLOWED_ON_TEMPLATE",
    "RBAC_PERMISSION_DENIED",
    "REDO_LOG_IS_ENABLED",
    "RESTORE_INCOMPATIBLE_VERSION",
    "RESTORE_SCRIPT_FAILED",
    "RESTORE_TARGET_MGMT_IF_NOT_IN_BACKUP",
    "RESTORE_TARGET_MISSING_DEVICE",
    "ROLE_ALREADY_EXISTS",
    "ROLE_NOT_FOUND",
    "SESSION_AUTHENTICATION_FAILED",
    "SESSION_INVALID",
    "SESSION_NOT_REGISTERED",
    "SLAVE_REQUIRES_MANAGEMENT_INTERFACE",
    "SR_ATTACH_FAILED",
    "SR_BACKEND_FAILURE",
    "SR_DEVICE_IN_USE",
    "SR_FULL",
    "SR_HAS_MULTIPLE_PBDS",
    "SR_HAS_NO_PBDS",
    "SR_HAS_PBD",
    "SR_INDESTRUCTIBLE",
    "SR_NOT_EMPTY",
    "SR_NOT_SHARABLE",
    "SR_OPERATION_NOT_SUPPORTED",
    "SR_REQUIRES_UPGRADE",
    "SR_UNKNOWN_DRIVER",
    "SR_UUID_EXISTS",
    "SR_VDI_LOCKING_FAILED",
    "SSL_VERIFY_ERROR",
    "SUBJECT_ALREADY_EXISTS",
    "SUBJECT_CANNOT_BE_RESOLVED",
    "SYSTEM_STATUS_MUST_USE_TAR_ON_OEM",
    "SYSTEM_STATUS_RETRIEVAL_FAILED",
    "TASK_CANCELLED",
    "TOO_BUSY",
    "TOO_MANY_PENDING_TASKS",
    "TRANSPORT_PIF_NOT_CONFIGURED",
    "UNKNOWN_BOOTLOADER",
    "USER_IS_NOT_LOCAL_SUPERUSER",
    "UUID_INVALID",
    "VALUE_NOT_SUPPORTED",
    "VBD_CDS_MUST_BE_READONLY",
    "VBD_IS_EMPTY",
    "VBD_NOT_EMPTY",
    "VBD_NOT_REMOVABLE_MEDIA",
    "VBD_NOT_UNPLUGGABLE",
    "VBD_TRAY_LOCKED",
    "VDI_INCOMPATIBLE_TYPE",
    "VDI_IN_USE",
    "VDI_IS_A_PHYSICAL_DEVICE",
    "VDI_IS_NOT_ISO",
    "VDI_LOCATION_MISSING",
    "VDI_MISSING",
    "VDI_NOT_AVAILABLE",
    "VDI_NOT_MANAGED",
    "VDI_READONLY",
    "VIF_IN_USE",
    "VLAN_TAG_INVALID",
    "VMPP_ARCHIVE_MORE_FREQUENT_THAN_BACKUP",
    "VMPP_HAS_VM",
    "VMS_FAILED_TO_COOPERATE",
    "VM_BAD_POWER_STATE",
    "VM_BIOS_STRINGS_ALREADY_SET",
    "VM_CANNOT_DELETE_DEFAULT_TEMPLATE",
    "VM_CHECKPOINT_RESUME_FAILED",
    "VM_CHECKPOINT_SUSPEND_FAILED",
    "VM_CRASHED",
    "VM_DUPLICATE_VBD_DEVICE",
    "VM_FAILED_SHUTDOWN_ACKNOWLEDGMENT",
    "VM_HALTED",
    "VM_HVM_REQUIRED",
    "VM_IS_PROTECTED",
    "VM_IS_TEMPLATE",
    "VM_MEMORY_SIZE_TOO_LOW",
    "VM_MIGRATE_FAILED",
    "VM_MISSING_PV_DRIVERS",
    "VM_NOT_RESIDENT_HERE",
    "VM_NO_CRASHDUMP_SR",
    "VM_NO_SUSPEND_SR",
    "VM_NO_VCPUS",
    "VM_OLD_PV_DRIVERS",
    "VM_REBOOTED",
    "VM_REQUIRES_NETWORK",
    "VM_REQUIRES_SR",
    "VM_REQUIRES_VDI",
    "VM_REVERT_FAILED",
    "VM_SHUTDOWN_TIMEOUT",
    "VM_SNAPSHOT_WITH_QUIESCE_FAILED",
    "VM_SNAPSHOT_WITH_QUIESCE_NOT_SUPPORTED",
    "VM_SNAPSHOT_WITH_QUIESCE_PLUGIN_DEOS_NOT_RESPOND",
    "VM_SNAPSHOT_WITH_QUIESCE_TIMEOUT",
    "VM_TOO_MANY_VCPUS",
    "VM_UNSAFE_BOOT",
    "WLB_AUTHENTICATION_FAILED",
    "WLB_CONNECTION_REFUSED",
    "WLB_CONNECTION_RESET",
    "WLB_DISABLED",
    "WLB_INTERNAL_ERROR",
    "WLB_MALFORMED_REQUEST",
    "WLB_MALFORMED_RESPONSE",
    "WLB_NOT_INITIALIZED",
    "WLB_TIMEOUT",
    "WLB_UNKNOWN_HOST",
    "WLB_URL_INVALID",
    "WLB_XENSERVER_AUTHENTICATION_FAILED",
    "WLB_XENSERVER_CONNECTION_REFUSED",
    "WLB_XENSERVER_MALFORMED_RESPONSE",
    "WLB_XENSERVER_TIMEOUT",
    "WLB_XENSERVER_UNKNOWN_HOST",
    "XAPI_HOOK_FAILED",
    "XENAPI_MISSING_PLUGIN",
    "XENAPI_PLUGIN_FAILURE",
    "XEN_VSS_REQ_ERROR_ADDING_VOLUME_TO_SNAPSET_FAILED",
    "XEN_VSS_REQ_ERROR_CREATING_SNAPSHOT",
    "XEN_VSS_REQ_ERROR_CREATING_SNAPSHOT_XML_STRING",
    "XEN_VSS_REQ_ERROR_INIT_FAILED",
    "XEN_VSS_REQ_ERROR_NO_VOLUMES_SUPPORTED",
    "XEN_VSS_REQ_ERROR_PREPARING_WRITERS",
    "XEN_VSS_REQ_ERROR_PROV_NOT_LOADED",
    "XEN_VSS_REQ_ERROR_START_SNAPSHOT_SET_FAILED",
    "XMLRPC_UNMARSHAL_FAILURE"
};


const char *
xen_api_failure_to_string(enum xen_api_failure val)
{
    return lookup_table[val];
}


extern enum xen_api_failure
xen_api_failure_from_string(const char *str)
{
    return ENUM_LOOKUP(str, lookup_table);
}


