/*
 * Copyright (c) 2006-2010 Citrix Systems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef XEN_TASK_STATUS_TYPE_H
#define XEN_TASK_STATUS_TYPE_H


#include <xen/api/xen_common.h>


enum xen_task_status_type
{
    /**
     * task is in progress
     */
    XEN_TASK_STATUS_TYPE_PENDING,

    /**
     * task was completed successfully
     */
    XEN_TASK_STATUS_TYPE_SUCCESS,

    /**
     * task has failed
     */
    XEN_TASK_STATUS_TYPE_FAILURE,

    /**
     * task is being cancelled
     */
    XEN_TASK_STATUS_TYPE_CANCELLING,

    /**
     * task has been cancelled
     */
    XEN_TASK_STATUS_TYPE_CANCELLED,

    /**
     * Unknown to this version of the bindings.
     */
    XEN_TASK_STATUS_TYPE_UNDEFINED
};


typedef struct xen_task_status_type_set
{
    size_t size;
    enum xen_task_status_type contents[];
} xen_task_status_type_set;

/**
 * Allocate a xen_task_status_type_set of the given size.
 */
extern xen_task_status_type_set *
xen_task_status_type_set_alloc(size_t size);

/**
 * Free the given xen_task_status_type_set.  The given set must have
 * been allocated by this library.
 */
extern void
xen_task_status_type_set_free(xen_task_status_type_set *set);


/**
 * Return the name corresponding to the given code.  This string must
 * not be modified or freed.
 */
extern const char *
xen_task_status_type_to_string(enum xen_task_status_type val);


/**
 * Return the correct code for the given string, or set the session
 * object to failure and return an undefined value if the given string does
 * not match a known code.
 */
extern enum xen_task_status_type
xen_task_status_type_from_string(xen_session *session, const char *str);


#endif
