/*
 * Copyright (c) 2006-2010 Citrix Systems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef XEN_MESSAGE_H
#define XEN_MESSAGE_H

#include <xen/api/xen_cls.h>
#include <xen/api/xen_common.h>
#include <xen/api/xen_message_decl.h>


/*
 * The message class.
 * 
 * An message for the attention of the administrator.
 */


/**
 * Free the given xen_message.  The given handle must have been
 * allocated by this library.
 */
extern void
xen_message_free(xen_message message);


typedef struct xen_message_set
{
    size_t size;
    xen_message *contents[];
} xen_message_set;

/**
 * Allocate a xen_message_set of the given size.
 */
extern xen_message_set *
xen_message_set_alloc(size_t size);

/**
 * Free the given xen_message_set.  The given set must have been
 * allocated by this library.
 */
extern void
xen_message_set_free(xen_message_set *set);


typedef struct xen_message_record
{
    xen_message handle;
    char *uuid;
    char *name;
    int64_t priority;
    enum xen_cls cls;
    char *obj_uuid;
    time_t timestamp;
    char *body;
} xen_message_record;

/**
 * Allocate a xen_message_record.
 */
extern xen_message_record *
xen_message_record_alloc(void);

/**
 * Free the given xen_message_record, and all referenced values.  The
 * given record must have been allocated by this library.
 */
extern void
xen_message_record_free(xen_message_record *record);


typedef struct xen_message_record_opt
{
    bool is_record;
    union
    {
        xen_message handle;
        xen_message_record *record;
    } u;
} xen_message_record_opt;

/**
 * Allocate a xen_message_record_opt.
 */
extern xen_message_record_opt *
xen_message_record_opt_alloc(void);

/**
 * Free the given xen_message_record_opt, and all referenced values. 
 * The given record_opt must have been allocated by this library.
 */
extern void
xen_message_record_opt_free(xen_message_record_opt *record_opt);


typedef struct xen_message_record_set
{
    size_t size;
    xen_message_record *contents[];
} xen_message_record_set;

/**
 * Allocate a xen_message_record_set of the given size.
 */
extern xen_message_record_set *
xen_message_record_set_alloc(size_t size);

/**
 * Free the given xen_message_record_set, and all referenced values. 
 * The given set must have been allocated by this library.
 */
extern void
xen_message_record_set_free(xen_message_record_set *set);



typedef struct xen_message_record_opt_set
{
    size_t size;
    xen_message_record_opt *contents[];
} xen_message_record_opt_set;

/**
 * Allocate a xen_message_record_opt_set of the given size.
 */
extern xen_message_record_opt_set *
xen_message_record_opt_set_alloc(size_t size);

/**
 * Free the given xen_message_record_opt_set, and all referenced
 * values.  The given set must have been allocated by this library.
 */
extern void
xen_message_record_opt_set_free(xen_message_record_opt_set *set);


/**
 * .
 */
extern bool
xen_message_create(xen_session *session, xen_message *result, char *name, int64_t priority, enum xen_cls cls, char *obj_uuid, char *body);


/**
 * .
 */
extern bool
xen_message_destroy(xen_session *session, xen_message self);


/**
 * .
 */
extern bool
xen_message_get_all(xen_session *session, struct xen_message_set **result);


/**
 * .
 */
extern bool
xen_message_get_record(xen_session *session, xen_message_record **result, xen_message self);


/**
 * .
 */
extern bool
xen_message_get_by_uuid(xen_session *session, xen_message *result, char *uuid);


#endif
