/*
 * Copyright (c) 2006-2010 Citrix Systems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef XEN_AFTER_APPLY_GUIDANCE_H
#define XEN_AFTER_APPLY_GUIDANCE_H


#include <xen/api/xen_common.h>


enum xen_after_apply_guidance
{
    /**
     * This patch requires HVM guests to be restarted once applied.
     */
    XEN_AFTER_APPLY_GUIDANCE_RESTARTHVM,

    /**
     * This patch requires PV guests to be restarted once applied.
     */
    XEN_AFTER_APPLY_GUIDANCE_RESTARTPV,

    /**
     * This patch requires the host to be restarted once applied.
     */
    XEN_AFTER_APPLY_GUIDANCE_RESTARTHOST,

    /**
     * This patch requires XAPI to be restarted once applied.
     */
    XEN_AFTER_APPLY_GUIDANCE_RESTARTXAPI,

    /**
     * Unknown to this version of the bindings.
     */
    XEN_AFTER_APPLY_GUIDANCE_UNDEFINED
};


typedef struct xen_after_apply_guidance_set
{
    size_t size;
    enum xen_after_apply_guidance contents[];
} xen_after_apply_guidance_set;

/**
 * Allocate a xen_after_apply_guidance_set of the given size.
 */
extern xen_after_apply_guidance_set *
xen_after_apply_guidance_set_alloc(size_t size);

/**
 * Free the given xen_after_apply_guidance_set.  The given set must
 * have been allocated by this library.
 */
extern void
xen_after_apply_guidance_set_free(xen_after_apply_guidance_set *set);


/**
 * Return the name corresponding to the given code.  This string must
 * not be modified or freed.
 */
extern const char *
xen_after_apply_guidance_to_string(enum xen_after_apply_guidance val);


/**
 * Return the correct code for the given string, or set the session
 * object to failure and return an undefined value if the given string does
 * not match a known code.
 */
extern enum xen_after_apply_guidance
xen_after_apply_guidance_from_string(xen_session *session, const char *str);


#endif
