/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * sem test.
 *
 ****************************************************************************/

#include <libstash/libstash_r.h>

#include <sys/time.h>

#define _LIBSTASH_TEST_NUM_THREADS 10

void *
thread_entry_func(void * a_arg)
{
  cw_sem_t * sem = (cw_sem_t *) a_arg;

  sem_wait(sem);
  out_put(cw_g_out, "Got semaphore.\n");
  
  return NULL;
}

int
main()
{
  cw_sem_t sem_a, * sem_b;
  cw_thd_t threads[_LIBSTASH_TEST_NUM_THREADS];
  cw_uint32_t i;
  struct timeval now;
  struct timespec timeout;
  struct timezone tz;
  
  libstash_init();
  out_put(cw_g_out, "Test begin\n");

  sem_b = sem_new(NULL, 0);
  _cw_check_ptr(sem_b);
  _cw_assert(0 == sem_getvalue(sem_b));
  sem_post(sem_b);
  _cw_assert(1 == sem_getvalue(sem_b));
  sem_adjust(sem_b, -2);
  _cw_assert(-1 == sem_getvalue(sem_b));
  sem_post(sem_b);
  _cw_assert(TRUE == sem_trywait(sem_b));
  sem_post(sem_b);
  _cw_assert(FALSE == sem_trywait(sem_b));
  sem_post(sem_b);
  sem_wait(sem_b);
  sem_post(sem_b);

  /* Set timeout for 2 seconds. */
  bzero(&tz, sizeof(struct timezone));
  gettimeofday(&now, &tz);
  timeout.tv_sec = now.tv_sec + 2;
  timeout.tv_nsec = now.tv_usec * 1000;
  
  _cw_assert(FALSE == sem_timedwait(sem_b, &timeout));
  _cw_assert(TRUE == sem_timedwait(sem_b, &timeout));
  sem_delete(sem_b);
  
  _cw_assert(&sem_a == sem_new(&sem_a, 0));

  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    thd_new(&threads[i], thread_entry_func, (void *) &sem_a);
  }

  sem_adjust(&sem_a, _LIBSTASH_TEST_NUM_THREADS);
  
  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    thd_join(&threads[i]);
  }
  
  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    thd_new(&threads[i], thread_entry_func, (void *) &sem_a);
  }

  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    sem_post(&sem_a);
  }
  
  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    thd_join(&threads[i]);
  }
  
  sem_delete(&sem_a);

  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  return 0;
}
