/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Test the pezz class.
 *
 ****************************************************************************/

#define _LIBSTASH_USE_PEZZ
#include <libstash/libstash_r.h>

int
main()
{
  libstash_init();
  out_put(cw_g_out, "Test begin\n");

  dbg_register(cw_g_dbg, "pezz_error");
/*    dbg_register(cw_g_dbg, "pezz_verbose"); */

  /* pezz_new(), pezz_delete(), pezz_get_buffer_size(). */
  {
    cw_pezz_t pezz, * pezz_p;

    _cw_assert(&pezz == pezz_new(&pezz, 123, 7));
    _cw_assert(123 == pezz_get_buffer_size(&pezz));
    pezz_delete(&pezz);

    pezz_p = pezz_new(NULL, 234, 11);
    _cw_check_ptr(pezz_p);
    _cw_assert(234 == pezz_get_buffer_size(pezz_p));
    pezz_delete(pezz_p);
  }

  /* pezz_get(), pezz_put(). */
  {
    cw_pezz_t pezz;
    void * pointers[100];
    cw_uint32_t i;

    pezz_new(&pezz, 4096, 10);
    _cw_assert(4096 == pezz_get_buffer_size(&pezz));
    for (i = 0; i < 100; i++)
    {
      pointers[i] = _cw_pezz_get(&pezz);
      _cw_check_ptr(pointers[i]);
    }
    for (i = 0; i < 100; i++)
    {
      _cw_pezz_put(&pezz, pointers[i]);
      pointers[i] = NULL;
    }
    
    for (i = 0; i < 5; i++)
    {
      pointers[i] = _cw_pezz_get(&pezz);
      _cw_check_ptr(pointers[i]);
    }
    for (i = 0; i < 5; i++)
    {
      _cw_pezz_put(&pezz, pointers[i]);
      pointers[i] = NULL;
    }
    
    for (i = 0; i < 6; i++)
    {
      pointers[i] = _cw_pezz_get(&pezz);
      _cw_check_ptr(pointers[i]);
    }
    for (i = 0; i < 6; i++)
    {
      _cw_pezz_put(&pezz, pointers[i]);
      pointers[i] = NULL;
    }
    
    for (i = 0; i < 1; i++)
    {
      pointers[i] = _cw_pezz_get(&pezz);
      _cw_check_ptr(pointers[i]);
    }
    for (i = 0; i < 1; i++)
    {
      _cw_pezz_put(&pezz, pointers[i]);
      pointers[i] = NULL;
    }
    
    for (i = 0; i < 11; i++)
    {
      pointers[i] = _cw_pezz_get(&pezz);
      _cw_check_ptr(pointers[i]);
    }
    for (i = 0; i < 11; i++)
    {
      _cw_pezz_put(&pezz, pointers[i]);
      pointers[i] = NULL;
    }

    pezz_delete(&pezz);
  }
  
  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  return 0;
}
