/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Test for 64 bit value printing in the log class.
 *
 ****************************************************************************/

#include <libstash/libstash_r.h>

int
main()
{
  cw_uint64_t i, j, k, l;
  char a[65], b[65];
    
  libstash_init();
  log_printf(cw_g_log, "Test begin\n");

  /* The following grossness shuts the compiler up.  IMO the compiler is
   * out of line in generating warnings on these. */
/*   i = 0xffff0000ffffabcd; */
  i = ((cw_uint64_t) 0xffff0000 << 32) + 0xffffabcd;
  
/*   j = 0x0123456789abcdef; */
  j = ((cw_uint64_t) 0x01234567 << 32) + 0x89abcdef;

/*   k = 123456789012345; */
  k = ((cw_uint64_t) 12345678 * 10000000) + 9012345;
  l = 42;
  
  log_printf(cw_g_log, "0xffff0000ffffabcd --> 0x%s (16), %s (2)\n",
	     log_print_uint64(i, 16, a), log_print_uint64(i, 2, b));
  log_printf(cw_g_log, "0x0123456789abcdef --> 0x%s (16), %s (2)\n",
	     log_print_uint64(j, 16, a), log_print_uint64(j, 2, b));
  log_printf(cw_g_log, "123456789012345 --> %s (10)\n",
	     log_print_uint64(k, 10, a));
  log_printf(cw_g_log, "42 --> %s (10)\n",
	     log_print_uint64(l, 10, a));

  log_printf(cw_g_log, "Test end\n");
  libstash_shutdown();

  return 0;
}
