/*  Programmable IRC function library 
    Copyright (C) 1999-2000 Jorgen Sigvardsson <jorgen@cs.kau.se>
    $Id: tcp.c,v 1.2 2000/01/08 15:37:55 jorgen Exp $
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include "tcp.h"

int
tcp_connect(gcstring server, gushort port)
{  
    struct hostent* hp;
    struct sockaddr_in sin;
    int s;

    if(!(hp = gethostbyname(server))) {
	return -1;
    }
    
    if((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	return -1;
    }
    
    bzero(&sin, sizeof(sin));
    bcopy(hp->h_addr, (char*)&sin.sin_addr, hp->h_length);
    sin.sin_port = htons(port);
    sin.sin_family = AF_INET;
    
    if(connect(s, (struct sockaddr*)&sin, sizeof(sin)) < 0) {
	return -1;
    }
    
    return s;
}

int
tcp_server(gcstring addr, gushort port)
{
/* XXX: Implement me! */
    return -1;
}
