#include "gen_ppc32_regalloc_if.h"

static int cmp_attr_ppc32_fConst(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return attr_a->data.constant_tarval != attr_b->data.constant_tarval;

}

static int cmp_attr_ppc32_Addis_zero(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Cmpli(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Lfd(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Addi(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_cUnknown(ir_node *a, ir_node *b) {
	(void) a;
	(void) b;
	
	return 1;

}

static int cmp_attr_ppc32_Stb(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Switch(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Branch(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Lfs(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Sth(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Srawi(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Cmpi(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Lhz(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Stw(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Lwz(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Stfs(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Andi_dot(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Lha(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Const(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return attr_a->data.constant_tarval != attr_b->data.constant_tarval;

}

static int cmp_attr_ppc32_Lbz(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Rlwinm(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Lwzu(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Addi_zero(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_Unknown(ir_node *a, ir_node *b) {
	(void) a;
	(void) b;
	
	return 1;

}

static int cmp_attr_ppc32_Ori(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_fUnknown(ir_node *a, ir_node *b) {
	(void) a;
	(void) b;
	
	return 1;

}

static int cmp_attr_ppc32_Stfd(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return (attr_a->data.constant_tarval != attr_b->data.constant_tarval);

}

static int cmp_attr_ppc32_SymConst(ir_node *a, ir_node *b) {
	ppc32_attr_t *attr_a = get_irn_generic_attr(a);
	ppc32_attr_t *attr_b = get_irn_generic_attr(b);
	
	return attr_a->data.constant_tarval != attr_b->data.constant_tarval;

}


ir_op *op_ppc32_fConst = NULL;
ir_op *op_ppc32_fMul = NULL;
ir_op *op_ppc32_fDivs = NULL;
ir_op *op_ppc32_fSubs = NULL;
ir_op *op_ppc32_Addis_zero = NULL;
ir_op *op_ppc32_Cmpli = NULL;
ir_op *op_ppc32_Cmp = NULL;
ir_op *op_ppc32_Sraw = NULL;
ir_op *op_ppc32_Slw = NULL;
ir_op *op_ppc32_Lfd = NULL;
ir_op *op_ppc32_Addi = NULL;
ir_op *op_ppc32_cUnknown = NULL;
ir_op *op_ppc32_Stb = NULL;
ir_op *op_ppc32_Switch = NULL;
ir_op *op_ppc32_Branch = NULL;
ir_op *op_ppc32_Mullw = NULL;
ir_op *op_ppc32_Lfs = NULL;
ir_op *op_ppc32_Sth = NULL;
ir_op *op_ppc32_fDiv = NULL;
ir_op *op_ppc32_Divw = NULL;
ir_op *op_ppc32_Rlwnm = NULL;
ir_op *op_ppc32_Sub = NULL;
ir_op *op_ppc32_fCmpu = NULL;
ir_op *op_ppc32_Srawi = NULL;
ir_op *op_ppc32_Cmpi = NULL;
ir_op *op_ppc32_Lhz = NULL;
ir_op *op_ppc32_Stw = NULL;
ir_op *op_ppc32_Cmpl = NULL;
ir_op *op_ppc32_fMinus = NULL;
ir_op *op_ppc32_fMax = NULL;
ir_op *op_ppc32_Lwz = NULL;
ir_op *op_ppc32_Stfs = NULL;
ir_op *op_ppc32_Andi_dot = NULL;
ir_op *op_ppc32_fSub = NULL;
ir_op *op_ppc32_Lha = NULL;
ir_op *op_ppc32_fAdds = NULL;
ir_op *op_ppc32_Const = NULL;
ir_op *op_ppc32_Lbz = NULL;
ir_op *op_ppc32_Xor = NULL;
ir_op *op_ppc32_Or = NULL;
ir_op *op_ppc32_Rlwinm = NULL;
ir_op *op_ppc32_fAdd = NULL;
ir_op *op_ppc32_Lwzu = NULL;
ir_op *op_ppc32_Add = NULL;
ir_op *op_ppc32_Mulhwu = NULL;
ir_op *op_ppc32_LoopCopy = NULL;
ir_op *op_ppc32_Addi_zero = NULL;
ir_op *op_ppc32_fMin = NULL;
ir_op *op_ppc32_Unknown = NULL;
ir_op *op_ppc32_Ori = NULL;
ir_op *op_ppc32_fMuls = NULL;
ir_op *op_ppc32_fAbs = NULL;
ir_op *op_ppc32_Extsh = NULL;
ir_op *op_ppc32_Extsb = NULL;
ir_op *op_ppc32_fRsp = NULL;
ir_op *op_ppc32_Srw = NULL;
ir_op *op_ppc32_Neg = NULL;
ir_op *op_ppc32_fCtiw = NULL;
ir_op *op_ppc32_Divwu = NULL;
ir_op *op_ppc32_fNeg = NULL;
ir_op *op_ppc32_Not = NULL;
ir_op *op_ppc32_Mtctr = NULL;
ir_op *op_ppc32_fUnknown = NULL;
ir_op *op_ppc32_And = NULL;
ir_op *op_ppc32_Mulhw = NULL;
ir_op *op_ppc32_Stfd = NULL;
ir_op *op_ppc32_SymConst = NULL;

ir_op *get_op_ppc32_fConst(void)         { return op_ppc32_fConst; }
int    is_ppc32_fConst(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fConst; }

ir_op *get_op_ppc32_fMul(void)         { return op_ppc32_fMul; }
int    is_ppc32_fMul(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fMul; }

ir_op *get_op_ppc32_fDivs(void)         { return op_ppc32_fDivs; }
int    is_ppc32_fDivs(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fDivs; }

ir_op *get_op_ppc32_fSubs(void)         { return op_ppc32_fSubs; }
int    is_ppc32_fSubs(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fSubs; }

ir_op *get_op_ppc32_Addis_zero(void)         { return op_ppc32_Addis_zero; }
int    is_ppc32_Addis_zero(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Addis_zero; }

ir_op *get_op_ppc32_Cmpli(void)         { return op_ppc32_Cmpli; }
int    is_ppc32_Cmpli(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Cmpli; }

ir_op *get_op_ppc32_Cmp(void)         { return op_ppc32_Cmp; }
int    is_ppc32_Cmp(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Cmp; }

ir_op *get_op_ppc32_Sraw(void)         { return op_ppc32_Sraw; }
int    is_ppc32_Sraw(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Sraw; }

ir_op *get_op_ppc32_Slw(void)         { return op_ppc32_Slw; }
int    is_ppc32_Slw(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Slw; }

ir_op *get_op_ppc32_Lfd(void)         { return op_ppc32_Lfd; }
int    is_ppc32_Lfd(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Lfd; }

ir_op *get_op_ppc32_Addi(void)         { return op_ppc32_Addi; }
int    is_ppc32_Addi(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Addi; }

ir_op *get_op_ppc32_cUnknown(void)         { return op_ppc32_cUnknown; }
int    is_ppc32_cUnknown(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_cUnknown; }

ir_op *get_op_ppc32_Stb(void)         { return op_ppc32_Stb; }
int    is_ppc32_Stb(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Stb; }

ir_op *get_op_ppc32_Switch(void)         { return op_ppc32_Switch; }
int    is_ppc32_Switch(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Switch; }

ir_op *get_op_ppc32_Branch(void)         { return op_ppc32_Branch; }
int    is_ppc32_Branch(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Branch; }

ir_op *get_op_ppc32_Mullw(void)         { return op_ppc32_Mullw; }
int    is_ppc32_Mullw(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Mullw; }

ir_op *get_op_ppc32_Lfs(void)         { return op_ppc32_Lfs; }
int    is_ppc32_Lfs(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Lfs; }

ir_op *get_op_ppc32_Sth(void)         { return op_ppc32_Sth; }
int    is_ppc32_Sth(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Sth; }

ir_op *get_op_ppc32_fDiv(void)         { return op_ppc32_fDiv; }
int    is_ppc32_fDiv(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fDiv; }

ir_op *get_op_ppc32_Divw(void)         { return op_ppc32_Divw; }
int    is_ppc32_Divw(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Divw; }

ir_op *get_op_ppc32_Rlwnm(void)         { return op_ppc32_Rlwnm; }
int    is_ppc32_Rlwnm(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Rlwnm; }

ir_op *get_op_ppc32_Sub(void)         { return op_ppc32_Sub; }
int    is_ppc32_Sub(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Sub; }

ir_op *get_op_ppc32_fCmpu(void)         { return op_ppc32_fCmpu; }
int    is_ppc32_fCmpu(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fCmpu; }

ir_op *get_op_ppc32_Srawi(void)         { return op_ppc32_Srawi; }
int    is_ppc32_Srawi(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Srawi; }

ir_op *get_op_ppc32_Cmpi(void)         { return op_ppc32_Cmpi; }
int    is_ppc32_Cmpi(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Cmpi; }

ir_op *get_op_ppc32_Lhz(void)         { return op_ppc32_Lhz; }
int    is_ppc32_Lhz(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Lhz; }

ir_op *get_op_ppc32_Stw(void)         { return op_ppc32_Stw; }
int    is_ppc32_Stw(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Stw; }

ir_op *get_op_ppc32_Cmpl(void)         { return op_ppc32_Cmpl; }
int    is_ppc32_Cmpl(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Cmpl; }

ir_op *get_op_ppc32_fMinus(void)         { return op_ppc32_fMinus; }
int    is_ppc32_fMinus(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fMinus; }

ir_op *get_op_ppc32_fMax(void)         { return op_ppc32_fMax; }
int    is_ppc32_fMax(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fMax; }

ir_op *get_op_ppc32_Lwz(void)         { return op_ppc32_Lwz; }
int    is_ppc32_Lwz(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Lwz; }

ir_op *get_op_ppc32_Stfs(void)         { return op_ppc32_Stfs; }
int    is_ppc32_Stfs(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Stfs; }

ir_op *get_op_ppc32_Andi_dot(void)         { return op_ppc32_Andi_dot; }
int    is_ppc32_Andi_dot(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Andi_dot; }

ir_op *get_op_ppc32_fSub(void)         { return op_ppc32_fSub; }
int    is_ppc32_fSub(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fSub; }

ir_op *get_op_ppc32_Lha(void)         { return op_ppc32_Lha; }
int    is_ppc32_Lha(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Lha; }

ir_op *get_op_ppc32_fAdds(void)         { return op_ppc32_fAdds; }
int    is_ppc32_fAdds(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fAdds; }

ir_op *get_op_ppc32_Const(void)         { return op_ppc32_Const; }
int    is_ppc32_Const(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Const; }

ir_op *get_op_ppc32_Lbz(void)         { return op_ppc32_Lbz; }
int    is_ppc32_Lbz(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Lbz; }

ir_op *get_op_ppc32_Xor(void)         { return op_ppc32_Xor; }
int    is_ppc32_Xor(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Xor; }

ir_op *get_op_ppc32_Or(void)         { return op_ppc32_Or; }
int    is_ppc32_Or(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Or; }

ir_op *get_op_ppc32_Rlwinm(void)         { return op_ppc32_Rlwinm; }
int    is_ppc32_Rlwinm(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Rlwinm; }

ir_op *get_op_ppc32_fAdd(void)         { return op_ppc32_fAdd; }
int    is_ppc32_fAdd(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fAdd; }

ir_op *get_op_ppc32_Lwzu(void)         { return op_ppc32_Lwzu; }
int    is_ppc32_Lwzu(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Lwzu; }

ir_op *get_op_ppc32_Add(void)         { return op_ppc32_Add; }
int    is_ppc32_Add(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Add; }

ir_op *get_op_ppc32_Mulhwu(void)         { return op_ppc32_Mulhwu; }
int    is_ppc32_Mulhwu(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Mulhwu; }

ir_op *get_op_ppc32_LoopCopy(void)         { return op_ppc32_LoopCopy; }
int    is_ppc32_LoopCopy(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_LoopCopy; }

ir_op *get_op_ppc32_Addi_zero(void)         { return op_ppc32_Addi_zero; }
int    is_ppc32_Addi_zero(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Addi_zero; }

ir_op *get_op_ppc32_fMin(void)         { return op_ppc32_fMin; }
int    is_ppc32_fMin(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fMin; }

ir_op *get_op_ppc32_Unknown(void)         { return op_ppc32_Unknown; }
int    is_ppc32_Unknown(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Unknown; }

ir_op *get_op_ppc32_Ori(void)         { return op_ppc32_Ori; }
int    is_ppc32_Ori(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Ori; }

ir_op *get_op_ppc32_fMuls(void)         { return op_ppc32_fMuls; }
int    is_ppc32_fMuls(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fMuls; }

ir_op *get_op_ppc32_fAbs(void)         { return op_ppc32_fAbs; }
int    is_ppc32_fAbs(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fAbs; }

ir_op *get_op_ppc32_Extsh(void)         { return op_ppc32_Extsh; }
int    is_ppc32_Extsh(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Extsh; }

ir_op *get_op_ppc32_Extsb(void)         { return op_ppc32_Extsb; }
int    is_ppc32_Extsb(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Extsb; }

ir_op *get_op_ppc32_fRsp(void)         { return op_ppc32_fRsp; }
int    is_ppc32_fRsp(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fRsp; }

ir_op *get_op_ppc32_Srw(void)         { return op_ppc32_Srw; }
int    is_ppc32_Srw(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Srw; }

ir_op *get_op_ppc32_Neg(void)         { return op_ppc32_Neg; }
int    is_ppc32_Neg(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Neg; }

ir_op *get_op_ppc32_fCtiw(void)         { return op_ppc32_fCtiw; }
int    is_ppc32_fCtiw(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fCtiw; }

ir_op *get_op_ppc32_Divwu(void)         { return op_ppc32_Divwu; }
int    is_ppc32_Divwu(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Divwu; }

ir_op *get_op_ppc32_fNeg(void)         { return op_ppc32_fNeg; }
int    is_ppc32_fNeg(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fNeg; }

ir_op *get_op_ppc32_Not(void)         { return op_ppc32_Not; }
int    is_ppc32_Not(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Not; }

ir_op *get_op_ppc32_Mtctr(void)         { return op_ppc32_Mtctr; }
int    is_ppc32_Mtctr(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Mtctr; }

ir_op *get_op_ppc32_fUnknown(void)         { return op_ppc32_fUnknown; }
int    is_ppc32_fUnknown(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_fUnknown; }

ir_op *get_op_ppc32_And(void)         { return op_ppc32_And; }
int    is_ppc32_And(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_And; }

ir_op *get_op_ppc32_Mulhw(void)         { return op_ppc32_Mulhw; }
int    is_ppc32_Mulhw(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Mulhw; }

ir_op *get_op_ppc32_Stfd(void)         { return op_ppc32_Stfd; }
int    is_ppc32_Stfd(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_Stfd; }

ir_op *get_op_ppc32_SymConst(void)         { return op_ppc32_SymConst; }
int    is_ppc32_SymConst(const ir_node *n) { return get_ppc32_irn_opcode(n) == iro_ppc32_SymConst; }



static int ppc32_opcode_start = -1;
static int ppc32_opcode_end   = -1;


/** A tag for the ppc32 opcodes. Note that the address is used as a tag value, NOT the FOURCC code. */
#define ppc32_op_tag FOURCC('P', 'P', 'C', '3')

/** Return the opcode number of the first ppc32 opcode. */
int get_ppc32_opcode_first(void) {
	return ppc32_opcode_start;
}

/** Return the opcode number of the last ppc32 opcode + 1. */
int get_ppc32_opcode_last(void) {
	return ppc32_opcode_end;
}

/** Return 1 if the given opcode is a ppc32 machine op, 0 otherwise */
int is_ppc32_op(const ir_op *op) {
	return get_op_tag(op) == ppc32_op_tag;
}

/** Return 1 if the given node is a ppc32 machine node, 0 otherwise */
int is_ppc32_irn(const ir_node *node) {
	return is_ppc32_op(get_irn_op(node));
}

int get_ppc32_irn_opcode(const ir_node *node) {
	if (is_ppc32_irn(node))
		return get_irn_opcode(node) - ppc32_opcode_start;
	return -1;
}

#ifdef BIT
#undef BIT
#endif
#define BIT(x)  (1 << (x % 32))

static const unsigned ppc32_limit_gp_r0_r1[] = { 0xFFFFFFFF & ~BIT(REG_R0) & ~BIT(REG_R1), 0xFFFFFFFF };
static const unsigned ppc32_limit_condition_cr0[] = { BIT(REG_CR0), 0 };

static const arch_register_req_t ppc32_requirements_fp_fp = {
	arch_register_req_type_normal,
	& ppc32_reg_classes[CLASS_ppc32_fp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0            /* different pos */
};


static const arch_register_req_t ppc32_requirements_gp_gp = {
	arch_register_req_type_normal,
	& ppc32_reg_classes[CLASS_ppc32_gp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0            /* different pos */
};


static const arch_register_req_t ppc32_requirements_condition_condition = {
	arch_register_req_type_normal,
	& ppc32_reg_classes[CLASS_ppc32_condition],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0            /* different pos */
};


static const arch_register_req_t ppc32_requirements_gp_not_r0 = {
	arch_register_req_type_limited,
	& ppc32_reg_classes[CLASS_ppc32_gp],
	ppc32_limit_gp_r0_r1,
	0,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t ppc32_requirements__none = {
	arch_register_req_type_none,
	NULL,                         /* regclass */
	NULL,                         /* limit bitset */
	0,                            /* same pos */
	0                             /* different pos */
};


static const arch_register_req_t ppc32_requirements_condition_cr0 = {
	arch_register_req_type_limited,
	& ppc32_reg_classes[CLASS_ppc32_condition],
	ppc32_limit_condition_cr0,
	0,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t ppc32_requirements_gp_in_r1 = {
	arch_register_req_type_should_be_same,
	& ppc32_reg_classes[CLASS_ppc32_gp],
	NULL,
	1,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t ppc32_requirements_count_count = {
	arch_register_req_type_normal,
	& ppc32_reg_classes[CLASS_ppc32_count],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0            /* different pos */
};


static const arch_register_req_t ppc32_requirements_gp_in_r2 = {
	arch_register_req_type_should_be_same,
	& ppc32_reg_classes[CLASS_ppc32_gp],
	NULL,
	2,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t ppc32_requirements_count_in_r3 = {
	arch_register_req_type_should_be_same,
	& ppc32_reg_classes[CLASS_ppc32_count],
	NULL,
	4,        /* same pos */
	0        /* different pos */
};



/**
 * float Const (high-level node)
 */
ir_node *new_bd_ppc32_fConst(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fConst;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_ppc32_fMul(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fMul;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Div (single): Div(a, b) = a / b
 */
ir_node *new_bd_ppc32_fDivs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fDivs;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Sub (single): Sub(a, b) = a - b
 */
ir_node *new_bd_ppc32_fSubs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fSubs;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * load the constant to higher 16 bit of register
 */
ir_node *new_bd_ppc32_Addis_zero(dbg_info *db, ir_node *block, ir_mode *mode, ppc32_attr_offset_mode om, tarval *tv, ident *id)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Addis_zero;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	ppc32_attr_t *attr;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	
	attr->offset_mode = om;
	if (tv) {
		attr->content_type = ppc32_ac_Const;
		attr->data.constant_tarval = tv;
	}
	else if (id) {
		attr->content_type = ppc32_ac_SymConst;
		attr->data.symconst_ident = id;
	}

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Cmp logical immediate: Cmpli(a, const) = Flags in crX
 */
ir_node *new_bd_ppc32_Cmpli(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Cmpli;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_condition_condition,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Cmp: Cmp(a, b) = Flags in crX
 */
ir_node *new_bd_ppc32_Cmp(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Cmp;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_condition_condition,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shrs: Sraw(a, b): c = a >> b
 */
ir_node *new_bd_ppc32_Sraw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Sraw;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shl: Shl(a, b) = a << b
 */
ir_node *new_bd_ppc32_Slw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Slw;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Load (double): Load(ptr, mem) = LD ptr
 */
ir_node *new_bd_ppc32_Lfd(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Lfd;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Add: Addi(a, const) = Addi(const, a) = a + const
 */
ir_node *new_bd_ppc32_Addi(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Addi;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct unknown condition register
 */
ir_node *new_bd_ppc32_cUnknown(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_cUnknown;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_condition_condition,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store: Store (byte) (ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_ppc32_Stb(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Stb;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements_gp_gp,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Switch(selector): Jump to whatever
 */
ir_node *new_bd_ppc32_Switch(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Switch;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_condition_condition,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * branch somewhere
 */
ir_node *new_bd_ppc32_Branch(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Branch;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 2;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_condition_condition,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements__none,
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Mul: Mullw(a, b) = Mullw(b, a) = lo32(a * b)
 */
ir_node *new_bd_ppc32_Mullw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Mullw;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Load (single): Load(ptr, mem) = LD ptr
 */
ir_node *new_bd_ppc32_Lfs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Lfs;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store: Store (halfword) (ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_ppc32_Sth(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Sth;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements_gp_gp,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Div: Div(a, b) = a / b
 */
ir_node *new_bd_ppc32_fDiv(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fDiv;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Div (signed): Div(a, b) = a div b
 */
ir_node *new_bd_ppc32_Divw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Divw;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct ???: Rlwnm(a, b): c = a ROTL b
 */
ir_node *new_bd_ppc32_Rlwnm(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Rlwnm;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_ppc32_Sub(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Sub;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Cmp unordered: fCmpu(a, b) = a ? b
 */
ir_node *new_bd_ppc32_fCmpu(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fCmpu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_condition_condition,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shrs: Srawi(a, const): c = a >> const
 */
ir_node *new_bd_ppc32_Srawi(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Srawi;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Cmp immediate: Cmpi(a, const) = Flags in crX
 */
ir_node *new_bd_ppc32_Cmpi(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Cmpi;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_condition_condition,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load (halfword unsigned): Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_ppc32_Lhz(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Lhz;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store: Store (word) (ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_ppc32_Stw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Stw;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements_gp_gp,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Cmp logical: Cmpl(a, b) = Flags in crX
 */
ir_node *new_bd_ppc32_Cmpl(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Cmpl;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_condition_condition,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Minus: fMinus(a) = -a
 */
ir_node *new_bd_ppc32_fMinus(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fMinus;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Max: Max(a, b) = Max(b, a) = a > b ? a : b
 */
ir_node *new_bd_ppc32_fMax(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fMax;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load (word): Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_ppc32_Lwz(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Lwz;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store (single): Store(ptr, val, mem)  = ST ptr,val
 */
ir_node *new_bd_ppc32_Stfs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Stfs;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements_fp_fp,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * ands constant with register with cr0 update
 */
ir_node *new_bd_ppc32_Andi_dot(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Andi_dot;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 2;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_condition_cr0,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_ppc32_fSub(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fSub;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load (halfword signed): Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_ppc32_Lha(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Lha;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Add (single): Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_ppc32_fAdds(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fAdds;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * Const (high-level node)
 */
ir_node *new_bd_ppc32_Const(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Const;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load (byte unsigned): Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_ppc32_Lbz(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Lbz;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Xor: Xor(a, b) = Xor(b, a) = a XOR b
 */
ir_node *new_bd_ppc32_Xor(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Xor;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Or: Or(a, b) = Or(b, a) = a OR b
 */
ir_node *new_bd_ppc32_Or(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Or;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct ???: Rlwinm(a, b_const, c_const, d_const): (m = MASK(c, d)) e = (a ROTL b) & m
 */
ir_node *new_bd_ppc32_Rlwinm(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Rlwinm;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_ppc32_fAdd(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fAdd;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load with update (word): Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_ppc32_Lwzu(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Lwzu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 3;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_in_r1,
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_ppc32_Add(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Add;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Mul: Mulhwu(a, b) = Mulhwu(b, a) = hi32(a * b)
 */
ir_node *new_bd_ppc32_Mulhwu(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Mulhwu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct LoopCopy(src, dest, count, mem): Copy count words from src to dest
 */
ir_node *new_bd_ppc32_LoopCopy(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_node *op3, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_LoopCopy;
	int       flags   = 0;
	int       arity   = 4;
	ir_node  *in[4];
	int       n_res   = 5;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_count_count,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements__none,
		& ppc32_requirements_gp_in_r1,
		& ppc32_requirements_gp_in_r2,
		& ppc32_requirements_count_in_r3,
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;
	in[3] = op3;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * load constant (16bit with sign extension)
 */
ir_node *new_bd_ppc32_Addi_zero(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Addi_zero;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Min: Min(a, b) = Min(b, a) = a < b ? a : b
 */
ir_node *new_bd_ppc32_fMin(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fMin;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct unknown register
 */
ir_node *new_bd_ppc32_Unknown(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Unknown;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * ors constant with register
 */
ir_node *new_bd_ppc32_Ori(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Ori;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Mul (single): Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_ppc32_fMuls(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fMuls;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Abs: fAbs(a) = |a|
 */
ir_node *new_bd_ppc32_fAbs(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fAbs;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Sign extension of halfword: Extsh(char a) = (short) a
 */
ir_node *new_bd_ppc32_Extsh(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Extsh;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Sign extension of byte: Extsb(char a) = (int) a
 */
ir_node *new_bd_ppc32_Extsb(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Extsb;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Round to single: fRsp(a) = (float) a
 */
ir_node *new_bd_ppc32_fRsp(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fRsp;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shr: Srw(a, b): c = a >> b
 */
ir_node *new_bd_ppc32_Srw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Srw;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Minus: Neg(a) = -a
 */
ir_node *new_bd_ppc32_Neg(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Neg;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Convert to integer word: fCtiw(a) = (int) a
 */
ir_node *new_bd_ppc32_fCtiw(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fCtiw;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Div (unsigned): Div(a, b) = a div b
 */
ir_node *new_bd_ppc32_Divwu(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Divwu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Negation: fNeg(a) = -a
 */
ir_node *new_bd_ppc32_fNeg(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fNeg;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Not: Not(a) = !a
 */
ir_node *new_bd_ppc32_Not(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Not;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Mtctr: Ctr = a
 */
ir_node *new_bd_ppc32_Mtctr(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Mtctr;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_count_count,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct unknown floating point register
 */
ir_node *new_bd_ppc32_fUnknown(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_fUnknown;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_fp_fp,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct And: And(a, b) = And(b, a) = a AND b
 */
ir_node *new_bd_ppc32_And(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_And;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Mul: Mulhw(a, b) = Mulhw(b, a) = hi32(a * b)
 */
ir_node *new_bd_ppc32_Mulhw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Mulhw;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_gp,
		& ppc32_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store (double): Store(ptr, val, mem)  = ST ptr,val
 */
ir_node *new_bd_ppc32_Stfd(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_Stfd;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& ppc32_requirements_gp_not_r0,
		& ppc32_requirements_fp_fp,
		& ppc32_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * SymConst (high-level node)
 */
ir_node *new_bd_ppc32_SymConst(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_ppc32_SymConst;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& ppc32_requirements_gp_gp,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_ppc32_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * Creates the ppc32 specific Firm machine operations
 * needed for the assembler irgs.
 */
void ppc32_create_opcodes(const arch_irn_ops_t *be_ops) {
#define N   irop_flag_none
#define L   irop_flag_labeled
#define C   irop_flag_commutative
#define X   irop_flag_cfopcode
#define I   irop_flag_ip_cfopcode
#define F   irop_flag_fragile
#define Y   irop_flag_forking
#define H   irop_flag_highlevel
#define c   irop_flag_constlike
#define K   irop_flag_keep
#define M   irop_flag_machine
#define O   irop_flag_machine_op
#define NB  irop_flag_dump_noblock
#define NI  irop_flag_dump_noinput
#define R   (irop_flag_user << 0)

	ir_op_ops  ops;
	int        cur_opcode;
	static int run_once = 0;
	int        i;

	if (run_once)
		return;
	run_once = 1;
	
	/* we handle all middleend nodes as well that have no other handler */
	for (i = 0; i <= iro_Last; ++i) {
		ir_op *op      = get_irp_opcode(i);
		if (op->ops.be_ops == NULL)
			op->ops.be_ops = be_ops;
	}

	cur_opcode = get_next_ir_opcodes(iro_ppc32_last);
  
	ppc32_opcode_start = cur_opcode;

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_fConst;
	op_ppc32_fConst = new_ir_op(cur_opcode + iro_ppc32_fConst, "ppc32_fConst", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fConst, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fMul = new_ir_op(cur_opcode + iro_ppc32_fMul, "ppc32_fMul", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fMul, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fDivs = new_ir_op(cur_opcode + iro_ppc32_fDivs, "ppc32_fDivs", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fDivs, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fSubs = new_ir_op(cur_opcode + iro_ppc32_fSubs, "ppc32_fSubs", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fSubs, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Addis_zero;
	op_ppc32_Addis_zero = new_ir_op(cur_opcode + iro_ppc32_Addis_zero, "ppc32_Addis_zero", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Addis_zero, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Cmpli;
	op_ppc32_Cmpli = new_ir_op(cur_opcode + iro_ppc32_Cmpli, "ppc32_Cmpli", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Cmpli, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Cmp = new_ir_op(cur_opcode + iro_ppc32_Cmp, "ppc32_Cmp", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Cmp, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Sraw = new_ir_op(cur_opcode + iro_ppc32_Sraw, "ppc32_Sraw", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Sraw, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Slw = new_ir_op(cur_opcode + iro_ppc32_Slw, "ppc32_Slw", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Slw, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Lfd;
	op_ppc32_Lfd = new_ir_op(cur_opcode + iro_ppc32_Lfd, "ppc32_Lfd", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Lfd, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Addi;
	op_ppc32_Addi = new_ir_op(cur_opcode + iro_ppc32_Addi, "ppc32_Addi", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Addi, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_cUnknown;
	op_ppc32_cUnknown = new_ir_op(cur_opcode + iro_ppc32_cUnknown, "ppc32_cUnknown", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_cUnknown, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Stb;
	op_ppc32_Stb = new_ir_op(cur_opcode + iro_ppc32_Stb, "ppc32_Stb", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Stb, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Switch;
	op_ppc32_Switch = new_ir_op(cur_opcode + iro_ppc32_Switch, "ppc32_Switch", op_pin_state_floats, L|X|Y|M, oparity_trinary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Switch, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Branch;
	op_ppc32_Branch = new_ir_op(cur_opcode + iro_ppc32_Branch, "ppc32_Branch", op_pin_state_floats, L|X|Y|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Branch, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Mullw = new_ir_op(cur_opcode + iro_ppc32_Mullw, "ppc32_Mullw", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Mullw, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Lfs;
	op_ppc32_Lfs = new_ir_op(cur_opcode + iro_ppc32_Lfs, "ppc32_Lfs", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Lfs, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Sth;
	op_ppc32_Sth = new_ir_op(cur_opcode + iro_ppc32_Sth, "ppc32_Sth", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Sth, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fDiv = new_ir_op(cur_opcode + iro_ppc32_fDiv, "ppc32_fDiv", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fDiv, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Divw = new_ir_op(cur_opcode + iro_ppc32_Divw, "ppc32_Divw", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Divw, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Rlwnm = new_ir_op(cur_opcode + iro_ppc32_Rlwnm, "ppc32_Rlwnm", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Rlwnm, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Sub = new_ir_op(cur_opcode + iro_ppc32_Sub, "ppc32_Sub", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Sub, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fCmpu = new_ir_op(cur_opcode + iro_ppc32_fCmpu, "ppc32_fCmpu", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fCmpu, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Srawi;
	op_ppc32_Srawi = new_ir_op(cur_opcode + iro_ppc32_Srawi, "ppc32_Srawi", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Srawi, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Cmpi;
	op_ppc32_Cmpi = new_ir_op(cur_opcode + iro_ppc32_Cmpi, "ppc32_Cmpi", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Cmpi, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Lhz;
	op_ppc32_Lhz = new_ir_op(cur_opcode + iro_ppc32_Lhz, "ppc32_Lhz", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Lhz, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Stw;
	op_ppc32_Stw = new_ir_op(cur_opcode + iro_ppc32_Stw, "ppc32_Stw", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Stw, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Cmpl = new_ir_op(cur_opcode + iro_ppc32_Cmpl, "ppc32_Cmpl", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Cmpl, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fMinus = new_ir_op(cur_opcode + iro_ppc32_fMinus, "ppc32_fMinus", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fMinus, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fMax = new_ir_op(cur_opcode + iro_ppc32_fMax, "ppc32_fMax", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fMax, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Lwz;
	op_ppc32_Lwz = new_ir_op(cur_opcode + iro_ppc32_Lwz, "ppc32_Lwz", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Lwz, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Stfs;
	op_ppc32_Stfs = new_ir_op(cur_opcode + iro_ppc32_Stfs, "ppc32_Stfs", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Stfs, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Andi_dot;
	op_ppc32_Andi_dot = new_ir_op(cur_opcode + iro_ppc32_Andi_dot, "ppc32_Andi_dot", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Andi_dot, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fSub = new_ir_op(cur_opcode + iro_ppc32_fSub, "ppc32_fSub", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fSub, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Lha;
	op_ppc32_Lha = new_ir_op(cur_opcode + iro_ppc32_Lha, "ppc32_Lha", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Lha, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fAdds = new_ir_op(cur_opcode + iro_ppc32_fAdds, "ppc32_fAdds", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fAdds, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Const;
	op_ppc32_Const = new_ir_op(cur_opcode + iro_ppc32_Const, "ppc32_Const", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Const, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Lbz;
	op_ppc32_Lbz = new_ir_op(cur_opcode + iro_ppc32_Lbz, "ppc32_Lbz", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Lbz, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Xor = new_ir_op(cur_opcode + iro_ppc32_Xor, "ppc32_Xor", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Xor, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Or = new_ir_op(cur_opcode + iro_ppc32_Or, "ppc32_Or", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Or, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Rlwinm;
	op_ppc32_Rlwinm = new_ir_op(cur_opcode + iro_ppc32_Rlwinm, "ppc32_Rlwinm", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Rlwinm, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fAdd = new_ir_op(cur_opcode + iro_ppc32_fAdd, "ppc32_fAdd", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fAdd, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Lwzu;
	op_ppc32_Lwzu = new_ir_op(cur_opcode + iro_ppc32_Lwzu, "ppc32_Lwzu", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Lwzu, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Add = new_ir_op(cur_opcode + iro_ppc32_Add, "ppc32_Add", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Add, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Mulhwu = new_ir_op(cur_opcode + iro_ppc32_Mulhwu, "ppc32_Mulhwu", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Mulhwu, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_LoopCopy = new_ir_op(cur_opcode + iro_ppc32_LoopCopy, "ppc32_LoopCopy", op_pin_state_floats, N|M, oparity_any, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_LoopCopy, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Addi_zero;
	op_ppc32_Addi_zero = new_ir_op(cur_opcode + iro_ppc32_Addi_zero, "ppc32_Addi_zero", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Addi_zero, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fMin = new_ir_op(cur_opcode + iro_ppc32_fMin, "ppc32_fMin", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fMin, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Unknown;
	op_ppc32_Unknown = new_ir_op(cur_opcode + iro_ppc32_Unknown, "ppc32_Unknown", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Unknown, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Ori;
	op_ppc32_Ori = new_ir_op(cur_opcode + iro_ppc32_Ori, "ppc32_Ori", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Ori, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fMuls = new_ir_op(cur_opcode + iro_ppc32_fMuls, "ppc32_fMuls", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fMuls, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fAbs = new_ir_op(cur_opcode + iro_ppc32_fAbs, "ppc32_fAbs", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fAbs, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Extsh = new_ir_op(cur_opcode + iro_ppc32_Extsh, "ppc32_Extsh", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Extsh, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Extsb = new_ir_op(cur_opcode + iro_ppc32_Extsb, "ppc32_Extsb", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Extsb, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fRsp = new_ir_op(cur_opcode + iro_ppc32_fRsp, "ppc32_fRsp", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fRsp, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Srw = new_ir_op(cur_opcode + iro_ppc32_Srw, "ppc32_Srw", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Srw, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Neg = new_ir_op(cur_opcode + iro_ppc32_Neg, "ppc32_Neg", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Neg, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fCtiw = new_ir_op(cur_opcode + iro_ppc32_fCtiw, "ppc32_fCtiw", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fCtiw, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Divwu = new_ir_op(cur_opcode + iro_ppc32_Divwu, "ppc32_Divwu", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Divwu, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_fNeg = new_ir_op(cur_opcode + iro_ppc32_fNeg, "ppc32_fNeg", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fNeg, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Not = new_ir_op(cur_opcode + iro_ppc32_Not, "ppc32_Not", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Not, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Mtctr = new_ir_op(cur_opcode + iro_ppc32_Mtctr, "ppc32_Mtctr", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Mtctr, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_fUnknown;
	op_ppc32_fUnknown = new_ir_op(cur_opcode + iro_ppc32_fUnknown, "ppc32_fUnknown", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_fUnknown, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_And = new_ir_op(cur_opcode + iro_ppc32_And, "ppc32_And", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_And, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = NULL;
	op_ppc32_Mulhw = new_ir_op(cur_opcode + iro_ppc32_Mulhw, "ppc32_Mulhw", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Mulhw, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_Stfd;
	op_ppc32_Stfd = new_ir_op(cur_opcode + iro_ppc32_Stfd, "ppc32_Stfd", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_Stfd, ppc32_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = ppc32_dump_node;
	ops.node_cmp_attr = cmp_attr_ppc32_SymConst;
	op_ppc32_SymConst = new_ir_op(cur_opcode + iro_ppc32_SymConst, "ppc32_SymConst", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(ppc32_attr_t), &ops);
	set_op_tag(op_ppc32_SymConst, ppc32_op_tag);

	ppc32_opcode_end = cur_opcode + iro_ppc32_last;
}
