/**
 * @file
 * @brief  The generated interface for the register allocator.
 *          Contains register classes and types and register constraints
 *          for all nodes where constraints were given in spec.
 * @note    DO NOT EDIT THIS FILE, your changes will be lost.
 *          Edit libfirm/ir/be/ia32/ia32_spec.pl instead.
 *          created by: libfirm/ir/be/scripts/generate_regalloc_if.pl libfirm/ir/be/ia32/ia32_spec.pl libfirm/ir/be/ia32
 * $date    Mon Mar  2 12:22:14 2009
 */
#include "config.h"

#include "gen_ia32_regalloc_if.h"
#include "gen_ia32_machine.h"
#include "bearch_ia32_t.h"
#include "ia32_map_regs.h"
#include "irmode.h"

arch_register_class_t ia32_reg_classes[] = {
	{ 0, "ia32_xmm", N_ia32_xmm_REGS, NULL, ia32_xmm_regs, 0 },
	{ 1, "ia32_flags", N_ia32_flags_REGS, NULL, ia32_flags_regs, arch_register_class_flag_manual_ra },
	{ 2, "ia32_gp", N_ia32_gp_REGS, NULL, ia32_gp_regs, 0 },
	{ 3, "ia32_st", N_ia32_st_REGS, NULL, ia32_st_regs, arch_register_class_flag_manual_ra },
	{ 4, "ia32_mmx", N_ia32_mmx_REGS, NULL, ia32_mmx_regs, arch_register_class_flag_manual_ra },
	{ 5, "ia32_fp_cw", N_ia32_fp_cw_REGS, NULL, ia32_fp_cw_regs, arch_register_class_flag_manual_ra|arch_register_class_flag_state },
	{ 6, "ia32_vfp", N_ia32_vfp_REGS, NULL, ia32_vfp_regs, 0 }
};

const arch_register_t ia32_xmm_regs[N_ia32_xmm_REGS] = {
	{
		"xmm0",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM0,
		arch_register_type_caller_save
	},
	{
		"xmm1",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM1,
		arch_register_type_caller_save
	},
	{
		"xmm2",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM2,
		arch_register_type_caller_save
	},
	{
		"xmm3",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM3,
		arch_register_type_caller_save
	},
	{
		"xmm4",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM4,
		arch_register_type_caller_save
	},
	{
		"xmm5",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM5,
		arch_register_type_caller_save
	},
	{
		"xmm6",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM6,
		arch_register_type_caller_save
	},
	{
		"xmm7",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM7,
		arch_register_type_caller_save
	},
	{
		"xmm_NOREG",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_NOREG,
		arch_register_type_ignore | arch_register_type_virtual
	},
	{
		"xmm_UKNWN",
		&ia32_reg_classes[CLASS_ia32_xmm],
		REG_XMM_UKNWN,
		arch_register_type_ignore | arch_register_type_joker | arch_register_type_virtual
	},
};
const arch_register_t ia32_flags_regs[N_ia32_flags_REGS] = {
	{
		"eflags",
		&ia32_reg_classes[CLASS_ia32_flags],
		REG_EFLAGS,
		arch_register_type_none
	},
};
const arch_register_t ia32_gp_regs[N_ia32_gp_REGS] = {
	{
		"edx",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_EDX,
		arch_register_type_caller_save
	},
	{
		"ecx",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_ECX,
		arch_register_type_caller_save
	},
	{
		"eax",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_EAX,
		arch_register_type_caller_save
	},
	{
		"ebx",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_EBX,
		arch_register_type_callee_save
	},
	{
		"esi",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_ESI,
		arch_register_type_callee_save
	},
	{
		"edi",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_EDI,
		arch_register_type_callee_save
	},
	{
		"ebp",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_EBP,
		arch_register_type_callee_save
	},
	{
		"esp",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_ESP,
		arch_register_type_ignore
	},
	{
		"gp_NOREG",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_NOREG,
		arch_register_type_ignore | arch_register_type_joker | arch_register_type_virtual
	},
	{
		"gp_UKNWN",
		&ia32_reg_classes[CLASS_ia32_gp],
		REG_GP_UKNWN,
		arch_register_type_ignore | arch_register_type_joker | arch_register_type_virtual
	},
};
const arch_register_t ia32_st_regs[N_ia32_st_REGS] = {
	{
		"st",
		&ia32_reg_classes[CLASS_ia32_st],
		REG_ST0,
		arch_register_type_ignore
	},
	{
		"st(1)",
		&ia32_reg_classes[CLASS_ia32_st],
		REG_ST1,
		arch_register_type_ignore
	},
	{
		"st(2)",
		&ia32_reg_classes[CLASS_ia32_st],
		REG_ST2,
		arch_register_type_ignore
	},
	{
		"st(3)",
		&ia32_reg_classes[CLASS_ia32_st],
		REG_ST3,
		arch_register_type_ignore
	},
	{
		"st(4)",
		&ia32_reg_classes[CLASS_ia32_st],
		REG_ST4,
		arch_register_type_ignore
	},
	{
		"st(5)",
		&ia32_reg_classes[CLASS_ia32_st],
		REG_ST5,
		arch_register_type_ignore
	},
	{
		"st(6)",
		&ia32_reg_classes[CLASS_ia32_st],
		REG_ST6,
		arch_register_type_ignore
	},
	{
		"st(7)",
		&ia32_reg_classes[CLASS_ia32_st],
		REG_ST7,
		arch_register_type_ignore
	},
};
const arch_register_t ia32_mmx_regs[N_ia32_mmx_REGS] = {
	{
		"mm0",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MM0,
		arch_register_type_ignore
	},
	{
		"mm1",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MM1,
		arch_register_type_ignore
	},
	{
		"mm2",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MM2,
		arch_register_type_ignore
	},
	{
		"mm3",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MM3,
		arch_register_type_ignore
	},
	{
		"mm4",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MM4,
		arch_register_type_ignore
	},
	{
		"mm5",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MM5,
		arch_register_type_ignore
	},
	{
		"mm6",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MM6,
		arch_register_type_ignore
	},
	{
		"mm7",
		&ia32_reg_classes[CLASS_ia32_mmx],
		REG_MM7,
		arch_register_type_ignore
	},
};
const arch_register_t ia32_fp_cw_regs[N_ia32_fp_cw_REGS] = {
	{
		"fpcw",
		&ia32_reg_classes[CLASS_ia32_fp_cw],
		REG_FPCW,
		arch_register_type_ignore | arch_register_type_state
	},
};
const arch_register_t ia32_vfp_regs[N_ia32_vfp_REGS] = {
	{
		"vf0",
		&ia32_reg_classes[CLASS_ia32_vfp],
		REG_VF0,
		arch_register_type_caller_save
	},
	{
		"vf1",
		&ia32_reg_classes[CLASS_ia32_vfp],
		REG_VF1,
		arch_register_type_caller_save
	},
	{
		"vf2",
		&ia32_reg_classes[CLASS_ia32_vfp],
		REG_VF2,
		arch_register_type_caller_save
	},
	{
		"vf3",
		&ia32_reg_classes[CLASS_ia32_vfp],
		REG_VF3,
		arch_register_type_caller_save
	},
	{
		"vf4",
		&ia32_reg_classes[CLASS_ia32_vfp],
		REG_VF4,
		arch_register_type_caller_save
	},
	{
		"vf5",
		&ia32_reg_classes[CLASS_ia32_vfp],
		REG_VF5,
		arch_register_type_caller_save
	},
	{
		"vf6",
		&ia32_reg_classes[CLASS_ia32_vfp],
		REG_VF6,
		arch_register_type_caller_save
	},
	{
		"vf7",
		&ia32_reg_classes[CLASS_ia32_vfp],
		REG_VF7,
		arch_register_type_caller_save
	},
	{
		"vfp_NOREG",
		&ia32_reg_classes[CLASS_ia32_vfp],
		REG_VFP_NOREG,
		arch_register_type_ignore | arch_register_type_joker | arch_register_type_virtual
	},
	{
		"vfp_UKNWN",
		&ia32_reg_classes[CLASS_ia32_vfp],
		REG_VFP_UKNWN,
		arch_register_type_ignore | arch_register_type_joker | arch_register_type_virtual
	},
};

void ia32_register_init(void) {
	/* set largest possible mode for 'ia32_xmm' */
	ia32_reg_classes[CLASS_ia32_xmm].mode = mode_E;

	/* set largest possible mode for 'ia32_flags' */
	ia32_reg_classes[CLASS_ia32_flags].mode = mode_Iu;

	/* set largest possible mode for 'ia32_gp' */
	ia32_reg_classes[CLASS_ia32_gp].mode = mode_Iu;

	/* set largest possible mode for 'ia32_st' */
	ia32_reg_classes[CLASS_ia32_st].mode = mode_E;

	/* set largest possible mode for 'ia32_mmx' */
	ia32_reg_classes[CLASS_ia32_mmx].mode = mode_E;

	/* set largest possible mode for 'ia32_fp_cw' */
	ia32_reg_classes[CLASS_ia32_fp_cw].mode = mode_fpcw;

	/* set largest possible mode for 'ia32_vfp' */
	ia32_reg_classes[CLASS_ia32_vfp].mode = mode_E;

}

