/**
 * @file
 * @brief     Generated functions to emit code for assembler ir nodes.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit libfirm/ir/be/ia32/ia32_spec.pl instead.
 *            created by: libfirm/ir/be/scripts/generate_emitter.pl libfirm/ir/be/ia32/ia32_spec.pl libfirm/ir/be/ia32
 * @date      Mon Mar  2 12:22:14 2009
 */
#include "config.h"

#include <stdio.h>

#include "irnode.h"
#include "irop_t.h"
#include "irprog_t.h"

#include "gen_ia32_emitter.h"
#include "ia32_new_nodes.h"
#include "ia32_emitter.h"

static void emit_ia32_xZero(const ir_node *node) {
	be_emit_cstring("\txorp");
	ia32_emit_xmm_mode_suffix_s(node);
	be_emit_char(' ');
	ia32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_FldCW(const ir_node *node) {
	be_emit_cstring("\tfldcw ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fadd(const ir_node *node) {
	be_emit_cstring("\tfadd");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_ShrMem(const ir_node *node) {
	be_emit_cstring("\tshr");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_CvtSI2SS(const ir_node *node) {
	be_emit_cstring("\tcvtsi2ss ");
	ia32_emit_unop(node, n_ia32_unary_op);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Bsf(const ir_node *node) {
	be_emit_cstring("\tbsf");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_unop(node, n_ia32_unary_op);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_ShlD(const ir_node *node) {
	be_emit_cstring("\tshld");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 2);
	be_emit_cstring(", ");
	ia32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_PopEbp(const ir_node *node) {
	be_emit_cstring("\tpop");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Inc(const ir_node *node) {
	be_emit_cstring("\tinc");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xStore(const ir_node *node) {
	be_emit_cstring("\tmov");
	ia32_emit_xmm_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xxLoad(const ir_node *node) {
	be_emit_cstring("\tmovdqu ");
	ia32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xAnd(const ir_node *node) {
	be_emit_cstring("\tandp");
	ia32_emit_xmm_mode_suffix_s(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xAdd(const ir_node *node) {
	be_emit_cstring("\tadd");
	ia32_emit_xmm_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xPsllq(const ir_node *node) {
	be_emit_cstring("\tpsllq ");
	ia32_emit_source_register_or_immediate(node, 1);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xxStore(const ir_node *node) {
	be_emit_cstring("\tmovdqu ");
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_FnstCWNOP(const ir_node *node) {
	(void) node;
}

static void emit_ia32_XorMem8Bit(const ir_node *node) {
	be_emit_cstring("\txor");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fldl2t(const ir_node *node) {
	be_emit_cstring("\tfldll2t");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fisttp(const ir_node *node) {
	be_emit_cstring("\tfisttp");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_DecMem(const ir_node *node) {
	be_emit_cstring("\tdec");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_emms(const ir_node *node) {
	be_emit_cstring("\temms");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fdivr(const ir_node *node) {
	be_emit_cstring("\tfdivr");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Unknown_VFP(const ir_node *node) {
	(void) node;
}

static void emit_ia32_xLoad(const ir_node *node) {
	be_emit_cstring("\tmov");
	ia32_emit_xmm_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_CvtSI2SD(const ir_node *node) {
	be_emit_cstring("\tcvtsi2sd ");
	ia32_emit_unop(node, n_ia32_unary_op);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_XorMem(const ir_node *node) {
	be_emit_cstring("\txor");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Xor0(const ir_node *node) {
	be_emit_cstring("\txor");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Sar(const ir_node *node) {
	be_emit_cstring("\tsar");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 1);
	be_emit_cstring(", ");
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Div(const ir_node *node) {
	be_emit_cstring("\tdiv");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_unop(node, n_ia32_unary_op);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fpushCopy(const ir_node *node) {
	be_emit_cstring("\tfld ");
	ia32_emit_x87_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Stc(const ir_node *node) {
	be_emit_cstring("\tstc");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Fucomi(const ir_node *node) {
	be_emit_cstring("\tfucomi ");
	ia32_emit_x87_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fldl2e(const ir_node *node) {
	be_emit_cstring("\tfldl2e");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Enter(const ir_node *node) {
	be_emit_cstring("\tenter");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fmul(const ir_node *node) {
	be_emit_cstring("\tfmul");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_NoReg_XMM(const ir_node *node) {
	(void) node;
}

static void emit_ia32_xMax(const ir_node *node) {
	be_emit_cstring("\tmax");
	ia32_emit_xmm_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fdivrp(const ir_node *node) {
	be_emit_cstring("\tfdivp");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_OrMem8Bit(const ir_node *node) {
	be_emit_cstring("\tor");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Prefetch1(const ir_node *node) {
	be_emit_cstring("\tprefetcht1 ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fsub(const ir_node *node) {
	be_emit_cstring("\tfsub");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Lea(const ir_node *node) {
	be_emit_cstring("\tleal ");
	ia32_emit_am(node);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_FtstFnstsw(const ir_node *node) {
	be_emit_cstring("\tftst");
	be_emit_finish_line_gas(node);
	be_emit_cstring("\tfnstsw %ax");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_NotMem(const ir_node *node) {
	be_emit_cstring("\tnot");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Sbb0(const ir_node *node) {
	be_emit_cstring("\tsbb");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Bt(const ir_node *node) {
	be_emit_cstring("\tbt");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Or(const ir_node *node) {
	be_emit_cstring("\tor");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Xor(const ir_node *node) {
	be_emit_cstring("\txor");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_IncMem(const ir_node *node) {
	be_emit_cstring("\tinc");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xAllOnes(const ir_node *node) {
	be_emit_cstring("\tpcmpeqb ");
	ia32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Breakpoint(const ir_node *node) {
	be_emit_cstring("\tint3");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_ffreep(const ir_node *node) {
	be_emit_cstring("\tffreep ");
	ia32_emit_x87_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_SubMem(const ir_node *node) {
	be_emit_cstring("\tsub");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_AddMem(const ir_node *node) {
	be_emit_cstring("\tadd");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_ShlMem(const ir_node *node) {
	be_emit_cstring("\tshl");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Fucompi(const ir_node *node) {
	be_emit_cstring("\tfucompi ");
	ia32_emit_x87_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fdiv(const ir_node *node) {
	be_emit_cstring("\tfdiv");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Outport(const ir_node *node) {
	be_emit_cstring("\tout");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_16bit_source_register_or_immediate(node, 0);
	be_emit_cstring(", ");
	ia32_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xMin(const ir_node *node) {
	be_emit_cstring("\tmin");
	ia32_emit_xmm_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fist(const ir_node *node) {
	be_emit_cstring("\tfist");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xXor(const ir_node *node) {
	be_emit_cstring("\txorp");
	ia32_emit_xmm_mode_suffix_s(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_IJmp(const ir_node *node) {
	be_emit_cstring("\tjmp *");
	ia32_emit_unop(node, n_ia32_unary_op);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_NegMem(const ir_node *node) {
	be_emit_cstring("\tneg");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Mul(const ir_node *node) {
	be_emit_cstring("\tmul");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_unop(node, n_ia32_binary_right);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Sahf(const ir_node *node) {
	be_emit_cstring("\tsahf");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_SubMem8Bit(const ir_node *node) {
	be_emit_cstring("\tsub");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_AddMem8Bit(const ir_node *node) {
	be_emit_cstring("\tadd");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fst(const ir_node *node) {
	be_emit_cstring("\tfst");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_FucomppFnstsw(const ir_node *node) {
	be_emit_cstring("\tfucompp");
	be_emit_finish_line_gas(node);
	be_emit_cstring("\tfnstsw %ax");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_RorMem(const ir_node *node) {
	be_emit_cstring("\tror");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fpush(const ir_node *node) {
	be_emit_cstring("\tfld ");
	ia32_emit_x87_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fild(const ir_node *node) {
	be_emit_cstring("\tfild");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xOr(const ir_node *node) {
	be_emit_cstring("\torp");
	ia32_emit_xmm_mode_suffix_s(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Store(const ir_node *node) {
	be_emit_cstring("\tmov");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fldln2(const ir_node *node) {
	be_emit_cstring("\tfldln2");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Ucomi(const ir_node *node) {
	 be_emit_cstring("\tucomi");
	 ia32_emit_xmm_mode_suffix(node);
	 be_emit_char(' ');
	 ia32_emit_binop(node);
	 be_emit_finish_line_gas(node);
}

static void emit_ia32_fldz(const ir_node *node) {
	be_emit_cstring("\tfldz");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Unknown_GP(const ir_node *node) {
	(void) node;
}

static void emit_ia32_Store8Bit(const ir_node *node) {
	be_emit_cstring("\tmov");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fpop(const ir_node *node) {
	be_emit_cstring("\tfstp ");
	ia32_emit_x87_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Sbb(const ir_node *node) {
	be_emit_cstring("\tsbb");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_FucomFnstsw(const ir_node *node) {
	be_emit_cstring("\tfucom ");
	ia32_emit_x87_register(node, 1);
	be_emit_finish_line_gas(node);
	be_emit_cstring("\tfnstsw %ax");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Set(const ir_node *node) {
	be_emit_cstring("\tset");
	ia32_emit_cmp_suffix_node(node, 0);
	be_emit_char(' ');
	ia32_emit_8bit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fdivp(const ir_node *node) {
	be_emit_cstring("\tfdivrp");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fmulp(const ir_node *node) {
	be_emit_cstring("\tfmulp");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xMul(const ir_node *node) {
	be_emit_cstring("\tmul");
	ia32_emit_xmm_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Push(const ir_node *node) {
	be_emit_cstring("\tpush");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_unop(node, n_ia32_unary_op);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fsubrp(const ir_node *node) {
	be_emit_cstring("\tfsubp");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xPslld(const ir_node *node) {
	be_emit_cstring("\tpslld ");
	ia32_emit_source_register_or_immediate(node, 1);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Cmp(const ir_node *node) {
	be_emit_cstring("\tcmp");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_FucompFnstsw(const ir_node *node) {
	be_emit_cstring("\tfucomp ");
	ia32_emit_x87_register(node, 1);
	be_emit_finish_line_gas(node);
	be_emit_cstring("\tfnstsw %ax");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_mov_gp_variant0(const ir_node *node) {
	be_emit_cstring("\tshl ");
	ia32_emit_source_register(node, 2);
	be_emit_cstring(", 15; .movd ");
	ia32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ia32_emit_source_register(node, 2);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xSub(const ir_node *node) {
	be_emit_cstring("\tsub");
	ia32_emit_xmm_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xMovd(const ir_node *node) {
	be_emit_cstring("\tmovd ");
	ia32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Cltd(const ir_node *node) {
	be_emit_cstring("\tcltd");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xPsrld(const ir_node *node) {
	be_emit_cstring("\tpsrld ");
	ia32_emit_source_register_or_immediate(node, 1);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xPzero(const ir_node *node) {
	be_emit_cstring("\tpxor ");
	ia32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Rol(const ir_node *node) {
	be_emit_cstring("\trol");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 1);
	be_emit_cstring(", ");
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Cmc(const ir_node *node) {
	be_emit_cstring("\tcmc");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Cmp8Bit(const ir_node *node) {
	be_emit_cstring("\tcmpb ");
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xDiv(const ir_node *node) {
	be_emit_cstring("\tdiv");
	ia32_emit_xmm_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Test8Bit(const ir_node *node) {
	be_emit_cstring("\ttestb ");
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Sub(const ir_node *node) {
	be_emit_cstring("\tsub");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_PrefetchNTA(const ir_node *node) {
	be_emit_cstring("\tprefetchnta ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Shr(const ir_node *node) {
	be_emit_cstring("\tshr");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 1);
	be_emit_cstring(", ");
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fprem(const ir_node *node) {
	be_emit_cstring("\tfprem1");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_IDiv(const ir_node *node) {
	be_emit_cstring("\tidiv");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_unop(node, n_ia32_unary_op);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_ProduceVal(const ir_node *node) {
	(void) node;
}

static void emit_ia32_Bswap(const ir_node *node) {
	be_emit_cstring("\tbswap");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Test(const ir_node *node) {
	be_emit_cstring("\ttest");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_AddSP(const ir_node *node) {
	be_emit_cstring("\taddl ");
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fsubr(const ir_node *node) {
	be_emit_cstring("\tfsubr");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_RolMem(const ir_node *node) {
	be_emit_cstring("\trol");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Prefetch2(const ir_node *node) {
	be_emit_cstring("\tprefetcht2 ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_NoReg_GP(const ir_node *node) {
	(void) node;
}

static void emit_ia32_FnstCW(const ir_node *node) {
	be_emit_cstring("\tfnstcw ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Prefetch0(const ir_node *node) {
	be_emit_cstring("\tprefetcht0 ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_OrMem(const ir_node *node) {
	be_emit_cstring("\tor");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fsubp(const ir_node *node) {
	be_emit_cstring("\tfsubrp");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fldlg2(const ir_node *node) {
	be_emit_cstring("\tfldlg2");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fld1(const ir_node *node) {
	be_emit_cstring("\tfld1");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Popcnt(const ir_node *node) {
	be_emit_cstring("\tpopcnt");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_unop(node, n_ia32_unary_op);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Ror(const ir_node *node) {
	be_emit_cstring("\tror");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 1);
	be_emit_cstring(", ");
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fpremp(const ir_node *node) {
	be_emit_cstring("\tfprem1\n. fstp ");
	ia32_emit_x87_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Shl(const ir_node *node) {
	be_emit_cstring("\tshl");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 1);
	be_emit_cstring(", ");
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_AndMem8Bit(const ir_node *node) {
	be_emit_cstring("\tand");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fistp(const ir_node *node) {
	be_emit_cstring("\tfistp");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Add(const ir_node *node) {
	be_emit_cstring("\tadd");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_SubSP(const ir_node *node) {
	be_emit_cstring("\tsubl ");
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
	be_emit_cstring("\tmovl %esp, ");
	ia32_emit_dest_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_PrefetchW(const ir_node *node) {
	be_emit_cstring("\tprefetchw ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fxch(const ir_node *node) {
	be_emit_cstring("\tfxch ");
	ia32_emit_x87_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fchs(const ir_node *node) {
	be_emit_cstring("\tfchs");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_ShrD(const ir_node *node) {
	be_emit_cstring("\tshrd");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 2);
	be_emit_cstring(", ");
	ia32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fstp(const ir_node *node) {
	be_emit_cstring("\tfstp");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_UD2(const ir_node *node) {
	be_emit_cstring("\t.value  0x0b0f");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Cwtl(const ir_node *node) {
	be_emit_cstring("\tcwtl");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fabs(const ir_node *node) {
	be_emit_cstring("\tfabs");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Unknown_XMM(const ir_node *node) {
	(void) node;
}

static void emit_ia32_fldpi(const ir_node *node) {
	be_emit_cstring("\tfldpi");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Leave(const ir_node *node) {
	be_emit_cstring("\tleave");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_NoReg_VFP(const ir_node *node) {
	(void) node;
}

static void emit_ia32_Neg(const ir_node *node) {
	be_emit_cstring("\tneg");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_IMul1OP(const ir_node *node) {
	be_emit_cstring("\timul");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_unop(node, n_ia32_binary_right);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_PopMem(const ir_node *node) {
	be_emit_cstring("\tpop");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_fld(const ir_node *node) {
	be_emit_cstring("\tfld");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Dec(const ir_node *node) {
	be_emit_cstring("\tdec");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Pop(const ir_node *node) {
	be_emit_cstring("\tpop");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_faddp(const ir_node *node) {
	be_emit_cstring("\tfaddp");
	ia32_emit_x87_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_x87_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Not(const ir_node *node) {
	be_emit_cstring("\tnot");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_AndMem(const ir_node *node) {
	be_emit_cstring("\tand");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_femms(const ir_node *node) {
	be_emit_cstring("\tfemms");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xStoreSimple(const ir_node *node) {
	be_emit_cstring("\tmov");
	ia32_emit_xmm_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_source_register(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_And(const ir_node *node) {
	be_emit_cstring("\tand");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_SetMem(const ir_node *node) {
	be_emit_cstring("\tset");
	ia32_emit_cmp_suffix_node(node, 3);
	be_emit_char(' ');
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Bsr(const ir_node *node) {
	be_emit_cstring("\tbsr");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_unop(node, n_ia32_unary_op);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Bswap16(const ir_node *node) {
	be_emit_cstring("\txchg ");
	ia32_emit_8bit_source_register_or_immediate(node, 0);
	be_emit_cstring(", ");
	ia32_emit_8bit_high_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Inport(const ir_node *node) {
	be_emit_cstring("\tin");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_dest_register_size(node, 0);
	be_emit_cstring(", ");
	ia32_emit_16bit_source_register_or_immediate(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_SarMem(const ir_node *node) {
	be_emit_cstring("\tsar");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_8bit_source_register_or_immediate(node, 3);
	be_emit_cstring(", ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_RepPrefix(const ir_node *node) {
	be_emit_cstring("\trep");
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Adc(const ir_node *node) {
	be_emit_cstring("\tadc");
	ia32_emit_mode_suffix(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_xAndNot(const ir_node *node) {
	be_emit_cstring("\tandnp");
	ia32_emit_xmm_mode_suffix_s(node);
	be_emit_char(' ');
	ia32_emit_binop(node);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Load(const ir_node *node) {
	be_emit_cstring("\tmov");
	ia32_emit_extend_suffix(node);
	be_emit_cstring("l ");
	ia32_emit_am(node);
	be_emit_cstring(", ");
	ia32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ia32_Prefetch(const ir_node *node) {
	be_emit_cstring("\tprefetch ");
	ia32_emit_am(node);
	be_emit_finish_line_gas(node);
}

/**
 * Enters the emitter functions for handled nodes into the generic
 * pointer of an opcode.
 */
void ia32_register_spec_emitters(void) {

#define BE_EMIT(a) op_ia32_##a->ops.generic = (op_func)emit_ia32_##a

  /* generated emitter functions */
  BE_EMIT(xZero);
  BE_EMIT(FldCW);
  BE_EMIT(fadd);
  BE_EMIT(ShrMem);
  BE_EMIT(CvtSI2SS);
  BE_EMIT(Bsf);
  BE_EMIT(ShlD);
  BE_EMIT(PopEbp);
  BE_EMIT(Inc);
  BE_EMIT(xStore);
  BE_EMIT(xxLoad);
  BE_EMIT(xAnd);
  BE_EMIT(xAdd);
  BE_EMIT(xPsllq);
  BE_EMIT(xxStore);
  BE_EMIT(FnstCWNOP);
  BE_EMIT(XorMem8Bit);
  BE_EMIT(fldl2t);
  BE_EMIT(fisttp);
  BE_EMIT(DecMem);
  BE_EMIT(emms);
  BE_EMIT(fdivr);
  BE_EMIT(Unknown_VFP);
  BE_EMIT(xLoad);
  BE_EMIT(CvtSI2SD);
  BE_EMIT(XorMem);
  BE_EMIT(Xor0);
  BE_EMIT(Sar);
  BE_EMIT(Div);
  BE_EMIT(fpushCopy);
  BE_EMIT(Stc);
  BE_EMIT(Fucomi);
  BE_EMIT(fldl2e);
  BE_EMIT(Enter);
  BE_EMIT(fmul);
  BE_EMIT(NoReg_XMM);
  BE_EMIT(xMax);
  BE_EMIT(fdivrp);
  BE_EMIT(OrMem8Bit);
  BE_EMIT(Prefetch1);
  BE_EMIT(fsub);
  BE_EMIT(Lea);
  BE_EMIT(FtstFnstsw);
  BE_EMIT(NotMem);
  BE_EMIT(Sbb0);
  BE_EMIT(Bt);
  BE_EMIT(Or);
  BE_EMIT(Xor);
  BE_EMIT(IncMem);
  BE_EMIT(xAllOnes);
  BE_EMIT(Breakpoint);
  BE_EMIT(ffreep);
  BE_EMIT(SubMem);
  BE_EMIT(AddMem);
  BE_EMIT(ShlMem);
  BE_EMIT(Fucompi);
  BE_EMIT(fdiv);
  BE_EMIT(Outport);
  BE_EMIT(xMin);
  BE_EMIT(fist);
  BE_EMIT(xXor);
  BE_EMIT(IJmp);
  BE_EMIT(NegMem);
  BE_EMIT(Mul);
  BE_EMIT(Sahf);
  BE_EMIT(SubMem8Bit);
  BE_EMIT(AddMem8Bit);
  BE_EMIT(fst);
  BE_EMIT(FucomppFnstsw);
  BE_EMIT(RorMem);
  BE_EMIT(fpush);
  BE_EMIT(fild);
  BE_EMIT(xOr);
  BE_EMIT(Store);
  BE_EMIT(fldln2);
  BE_EMIT(Ucomi);
  BE_EMIT(fldz);
  BE_EMIT(Unknown_GP);
  BE_EMIT(Store8Bit);
  BE_EMIT(fpop);
  BE_EMIT(Sbb);
  BE_EMIT(FucomFnstsw);
  BE_EMIT(Set);
  BE_EMIT(fdivp);
  BE_EMIT(fmulp);
  BE_EMIT(xMul);
  BE_EMIT(Push);
  BE_EMIT(fsubrp);
  BE_EMIT(xPslld);
  BE_EMIT(Cmp);
  BE_EMIT(FucompFnstsw);
  BE_EMIT(mov_gp_variant0);
  BE_EMIT(xSub);
  BE_EMIT(xMovd);
  BE_EMIT(Cltd);
  BE_EMIT(xPsrld);
  BE_EMIT(xPzero);
  BE_EMIT(Rol);
  BE_EMIT(Cmc);
  BE_EMIT(Cmp8Bit);
  BE_EMIT(xDiv);
  BE_EMIT(Test8Bit);
  BE_EMIT(Sub);
  BE_EMIT(PrefetchNTA);
  BE_EMIT(Shr);
  BE_EMIT(fprem);
  BE_EMIT(IDiv);
  BE_EMIT(ProduceVal);
  BE_EMIT(Bswap);
  BE_EMIT(Test);
  BE_EMIT(AddSP);
  BE_EMIT(fsubr);
  BE_EMIT(RolMem);
  BE_EMIT(Prefetch2);
  BE_EMIT(NoReg_GP);
  BE_EMIT(FnstCW);
  BE_EMIT(Prefetch0);
  BE_EMIT(OrMem);
  BE_EMIT(fsubp);
  BE_EMIT(fldlg2);
  BE_EMIT(fld1);
  BE_EMIT(Popcnt);
  BE_EMIT(Ror);
  BE_EMIT(fpremp);
  BE_EMIT(Shl);
  BE_EMIT(AndMem8Bit);
  BE_EMIT(fistp);
  BE_EMIT(Add);
  BE_EMIT(SubSP);
  BE_EMIT(PrefetchW);
  BE_EMIT(fxch);
  BE_EMIT(fchs);
  BE_EMIT(ShrD);
  BE_EMIT(fstp);
  BE_EMIT(UD2);
  BE_EMIT(Cwtl);
  BE_EMIT(fabs);
  BE_EMIT(Unknown_XMM);
  BE_EMIT(fldpi);
  BE_EMIT(Leave);
  BE_EMIT(NoReg_VFP);
  BE_EMIT(Neg);
  BE_EMIT(IMul1OP);
  BE_EMIT(PopMem);
  BE_EMIT(fld);
  BE_EMIT(Dec);
  BE_EMIT(Pop);
  BE_EMIT(faddp);
  BE_EMIT(Not);
  BE_EMIT(AndMem);
  BE_EMIT(femms);
  BE_EMIT(xStoreSimple);
  BE_EMIT(And);
  BE_EMIT(SetMem);
  BE_EMIT(Bsr);
  BE_EMIT(Bswap16);
  BE_EMIT(Inport);
  BE_EMIT(SarMem);
  BE_EMIT(RepPrefix);
  BE_EMIT(Adc);
  BE_EMIT(xAndNot);
  BE_EMIT(Load);
  BE_EMIT(Prefetch);

#undef BE_EMIT
}

