/**
 * @file
 * @brief Function prototypes for the new opcode functions.
 * @note  DO NOT EDIT THIS FILE, your changes will be lost.
 *        Edit libfirm/ir/be/arm/arm_spec.pl instead.
 *        created by: libfirm/ir/be/scripts/generate_new_opcodes.pl libfirm/ir/be/arm/arm_spec.pl libfirm/ir/be/arm
 * @date  Tue Jan 20 10:57:58 2009
 */
#ifndef FIRM_BE_ARM_GEN_ARM_NEW_NODES_H
#define FIRM_BE_ARM_GEN_ARM_NEW_NODES_H

typedef enum _arm_opcodes {
	iro_arm_Unknown_GP,
	iro_arm_Mla,
	iro_arm_fpaMin,
	iro_arm_fpaFrd,
	iro_arm_Mov,
	iro_arm_LdTls,
	iro_arm_SubSPandCopy,
	iro_arm_EmptyReg,
	iro_arm_And_i,
	iro_arm_fpaRdf,
	iro_arm_Add_i,
	iro_arm_fpaFix,
	iro_arm_fpaMvf,
	iro_arm_fpaCnfeBra,
	iro_arm_Abs,
	iro_arm_Mvn,
	iro_arm_fpaFdv_i,
	iro_arm_Unknown_FPA,
	iro_arm_fpaFrd_i,
	iro_arm_Or_i,
	iro_arm_Umull,
	iro_arm_Sub,
	iro_arm_Sub_i,
	iro_arm_Storeh,
	iro_arm_Shr,
	iro_arm_Loadbs,
	iro_arm_Shrs,
	iro_arm_fpaRdf_i,
	iro_arm_fpaSuf,
	iro_arm_fpaFml,
	iro_arm_fpaDbl2GP,
	iro_arm_Eor_i,
	iro_arm_CopyB,
	iro_arm_AddSP,
	iro_arm_fpaAdf,
	iro_arm_Copy,
	iro_arm_fpaDvf,
	iro_arm_fpaDvf_i,
	iro_arm_TstBra,
	iro_arm_Mvn_i,
	iro_arm_StoreStackM4Inc,
	iro_arm_fpaMuf,
	iro_arm_Mov_i,
	iro_arm_Eor,
	iro_arm_fpaCmfeBra,
	iro_arm_fpaCnfBra,
	iro_arm_Loadb,
	iro_arm_Rsb,
	iro_arm_Loadh,
	iro_arm_fpaLdf,
	iro_arm_fpaAbs,
	iro_arm_fpaConst,
	iro_arm_fpaMuf_i,
	iro_arm_fpaFdv,
	iro_arm_Or,
	iro_arm_fpaMnf_i,
	iro_arm_fpaMax,
	iro_arm_Ror,
	iro_arm_Smull,
	iro_arm_Shl,
	iro_arm_Add,
	iro_arm_fpaSuf_i,
	iro_arm_LoadStackM3Epilogue,
	iro_arm_Storeb,
	iro_arm_Bic,
	iro_arm_Mul,
	iro_arm_fpaRsf_i,
	iro_arm_CmpBra,
	iro_arm_fpaRsf,
	iro_arm_fpaMnf,
	iro_arm_Bic_i,
	iro_arm_Rsb_i,
	iro_arm_fpaCmfBra,
	iro_arm_fpaMvf_i,
	iro_arm_fpaStf,
	iro_arm_Store,
	iro_arm_And,
	iro_arm_Loadhs,
	iro_arm_fpaFlt,
	iro_arm_SwitchJmp,
	iro_arm_SymConst,
	iro_arm_Load,
	iro_arm_fpaAdf_i,
	iro_arm_last_generated,
	iro_arm_last = iro_arm_last_generated
} arm_opcodes;

int is_arm_irn(const ir_node *node);

int get_arm_opcode_first(void);
int get_arm_opcode_last(void);
int get_arm_irn_opcode(const ir_node *node);
void arm_create_opcodes(const arch_irn_ops_t *be_ops);
extern ir_op *op_arm_Unknown_GP;
ir_op *get_op_arm_Unknown_GP(void);
int is_arm_Unknown_GP(const ir_node *n);
/**
 * construct Unknown_GP node
 */
ir_node *new_bd_arm_Unknown_GP(dbg_info *db, ir_node *block);

extern ir_op *op_arm_Mla;
ir_op *get_op_arm_Mla(void);
int is_arm_Mla(const ir_node *n);
/**
 * construct Mla: Mla(a, b, c) = a * b + c
 */
ir_node *new_bd_arm_Mla(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *mode);

extern ir_op *op_arm_fpaMin;
ir_op *get_op_arm_fpaMin(void);
int is_arm_fpaMin(const ir_node *n);
/**
 * construct FPA Min: Min(a, b) = Min(b, a) = a < b ? a : b
 */
ir_node *new_bd_arm_fpaMin(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_fpaFrd;
ir_op *get_op_arm_fpaFrd(void);
int is_arm_fpaFrd(const ir_node *n);
/**
 * construct FPA Fast reverse Div: Div(a, b) = b / a
 */
ir_node *new_bd_arm_fpaFrd(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode);

extern ir_op *op_arm_Mov;
ir_op *get_op_arm_Mov(void);
int is_arm_Mov(const ir_node *n);
/**
 * construct Mov: a = b
 */
ir_node *new_bd_arm_Mov(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, arm_shift_modifier mod, long shf);

extern ir_op *op_arm_LdTls;
ir_op *get_op_arm_LdTls(void);
int is_arm_LdTls(const ir_node *n);
/**
 * load the TLS address
 */
ir_node *new_bd_arm_LdTls(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_arm_SubSPandCopy;
ir_op *get_op_arm_SubSPandCopy(void);
int is_arm_SubSPandCopy(const ir_node *n);
/**
 * construct Sub from stack pointer and copy to Register
 */
ir_node *new_bd_arm_SubSPandCopy(dbg_info *db, ir_node *block, ir_node *stack, ir_node *size, ir_node *mem);

extern ir_op *op_arm_EmptyReg;
ir_op *get_op_arm_EmptyReg(void);
int is_arm_EmptyReg(const ir_node *n);
/**
 * allocate an empty register for calculations
 */
ir_node *new_bd_arm_EmptyReg(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_arm_And_i;
ir_op *get_op_arm_And_i(void);
int is_arm_And_i(const ir_node *n);
/**
 * construct And: And(a, const) = And(const, a) = a AND const
 */
ir_node *new_bd_arm_And_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);

extern ir_op *op_arm_fpaRdf;
ir_op *get_op_arm_fpaRdf(void);
int is_arm_fpaRdf(const ir_node *n);
/**
 * construct FPA reverse Div: Div(a, b) = b / a
 */
ir_node *new_bd_arm_fpaRdf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode);

extern ir_op *op_arm_Add_i;
ir_op *get_op_arm_Add_i(void);
int is_arm_Add_i(const ir_node *n);
/**
 * construct Add: Add(a, const) = Add(const, a) = a + const
 */
ir_node *new_bd_arm_Add_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);

extern ir_op *op_arm_fpaFix;
ir_op *get_op_arm_fpaFix(void);
int is_arm_fpaFix(const ir_node *n);
/**
 * construct a FPA float->integer conversion
 */
ir_node *new_bd_arm_fpaFix(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_arm_fpaMvf;
ir_op *get_op_arm_fpaMvf(void);
int is_arm_fpaMvf(const ir_node *n);
/**
 * construct FPA Move: b = a
 */
ir_node *new_bd_arm_fpaMvf(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_arm_fpaCnfeBra;
ir_op *get_op_arm_fpaCnfeBra(void);
int is_arm_fpaCnfeBra(const ir_node *n);
/**
 * construct floating point Compare and Branch: CMF A, -B && JMPxx LABEL
 */
ir_node *new_bd_arm_fpaCnfeBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num);

extern ir_op *op_arm_Abs;
ir_op *get_op_arm_Abs(void);
int is_arm_Abs(const ir_node *n);
/**
 * construct Abs: Abs(a) = |a|
 */
ir_node *new_bd_arm_Abs(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_arm_Mvn;
ir_op *get_op_arm_Mvn(void);
int is_arm_Mvn(const ir_node *n);
/**
 * construct Not: Not(a) = !a
 */
ir_node *new_bd_arm_Mvn(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, arm_shift_modifier mod, long shf);

extern ir_op *op_arm_fpaFdv_i;
ir_op *get_op_arm_fpaFdv_i(void);
int is_arm_fpaFdv_i(const ir_node *n);
/**
 * construct FPA Fast Div: Div(a, b) = a / b
 */
ir_node *new_bd_arm_fpaFdv_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *op_mode, long imm);

extern ir_op *op_arm_Unknown_FPA;
ir_op *get_op_arm_Unknown_FPA(void);
int is_arm_Unknown_FPA(const ir_node *n);
/**
 * construct Unknown_FPA node
 */
ir_node *new_bd_arm_Unknown_FPA(dbg_info *db, ir_node *block);

extern ir_op *op_arm_fpaFrd_i;
ir_op *get_op_arm_fpaFrd_i(void);
int is_arm_fpaFrd_i(const ir_node *n);
/**
 * construct FPA Fast reverse Div: Div(a, b) = b / a
 */
ir_node *new_bd_arm_fpaFrd_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *op_mode, long imm);

extern ir_op *op_arm_Or_i;
ir_op *get_op_arm_Or_i(void);
int is_arm_Or_i(const ir_node *n);
/**
 * construct Or: Or(a, const) = Or(const, a) = a OR const
 */
ir_node *new_bd_arm_Or_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);

extern ir_op *op_arm_Umull;
ir_op *get_op_arm_Umull(void);
int is_arm_Umull(const ir_node *n);
/**
 * construct unsigned 64bit Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_Umull(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_Sub;
ir_op *get_op_arm_Sub(void);
int is_arm_Sub(const ir_node *n);
/**
 * construct Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_arm_Sub(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf);

extern ir_op *op_arm_Sub_i;
ir_op *get_op_arm_Sub_i(void);
int is_arm_Sub_i(const ir_node *n);
/**
 * construct Sub: Sub(a, const) = a - const
 */
ir_node *new_bd_arm_Sub_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);

extern ir_op *op_arm_Storeh;
ir_op *get_op_arm_Storeh(void);
int is_arm_Storeh(const ir_node *n);
/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_arm_Storeh(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2);

extern ir_op *op_arm_Shr;
ir_op *get_op_arm_Shr(void);
int is_arm_Shr(const ir_node *n);
/**
 * construct Shr: Shr(a, b) = a >>u b
 */
ir_node *new_bd_arm_Shr(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_Loadbs;
ir_op *get_op_arm_Loadbs(void);
int is_arm_Loadbs(const ir_node *n);
/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_Loadbs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_Shrs;
ir_op *get_op_arm_Shrs(void);
int is_arm_Shrs(const ir_node *n);
/**
 * construct Shrs: Shrs(a, b) = a >>s b
 */
ir_node *new_bd_arm_Shrs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_fpaRdf_i;
ir_op *get_op_arm_fpaRdf_i(void);
int is_arm_fpaRdf_i(const ir_node *n);
/**
 * construct FPA reverse Div: Div(a, b) = b / a
 */
ir_node *new_bd_arm_fpaRdf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *op_mode, long imm);

extern ir_op *op_arm_fpaSuf;
ir_op *get_op_arm_fpaSuf(void);
int is_arm_fpaSuf(const ir_node *n);
/**
 * construct FPA Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_arm_fpaSuf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_fpaFml;
ir_op *get_op_arm_fpaFml(void);
int is_arm_fpaFml(const ir_node *n);
/**
 * construct FPA Fast Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_fpaFml(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_fpaDbl2GP;
ir_op *get_op_arm_fpaDbl2GP(void);
int is_arm_fpaDbl2GP(const ir_node *n);
/**
 * construct fp double to 2 gp register transfer
 */
ir_node *new_bd_arm_fpaDbl2GP(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_Eor_i;
ir_op *get_op_arm_Eor_i(void);
int is_arm_Eor_i(const ir_node *n);
/**
 * construct Eor: Eor(a, const) = Eor(const, a) = a EOR const
 */
ir_node *new_bd_arm_Eor_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);

extern ir_op *op_arm_CopyB;
ir_op *get_op_arm_CopyB(void);
int is_arm_CopyB(const ir_node *n);
/**
 * implements a memcopy: CopyB(dst, src, size, mem) == memcpy(dst, src, size)
 */
ir_node *new_bd_arm_CopyB(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_node *op3, ir_node *op4, ir_node *op5, long imm);

extern ir_op *op_arm_AddSP;
ir_op *get_op_arm_AddSP(void);
int is_arm_AddSP(const ir_node *n);
/**
 * construct Add to stack pointer
 */
ir_node *new_bd_arm_AddSP(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2);

extern ir_op *op_arm_fpaAdf;
ir_op *get_op_arm_fpaAdf(void);
int is_arm_fpaAdf(const ir_node *n);
/**
 * construct FPA Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_arm_fpaAdf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_Copy;
ir_op *get_op_arm_Copy(void);
int is_arm_Copy(const ir_node *n);
/**
 * implements a register copy
 */
ir_node *new_bd_arm_Copy(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_arm_fpaDvf;
ir_op *get_op_arm_fpaDvf(void);
int is_arm_fpaDvf(const ir_node *n);
/**
 * construct FPA Div: Div(a, b) = a / b
 */
ir_node *new_bd_arm_fpaDvf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode);

extern ir_op *op_arm_fpaDvf_i;
ir_op *get_op_arm_fpaDvf_i(void);
int is_arm_fpaDvf_i(const ir_node *n);
/**
 * construct FPA Div: Div(a, b) = a / b
 */
ir_node *new_bd_arm_fpaDvf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *op_mode, long imm);

extern ir_op *op_arm_TstBra;
ir_op *get_op_arm_TstBra(void);
int is_arm_TstBra(const ir_node *n);
/**
 * construct conditional branch: TST A, B && JMPxx LABEL
 */
ir_node *new_bd_arm_TstBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num);

extern ir_op *op_arm_Mvn_i;
ir_op *get_op_arm_Mvn_i(void);
int is_arm_Mvn_i(const ir_node *n);
/**
 * represents a negated integer constant
 */
ir_node *new_bd_arm_Mvn_i(dbg_info *db, ir_node *block, ir_mode *mode, long imm);

extern ir_op *op_arm_StoreStackM4Inc;
ir_op *get_op_arm_StoreStackM4Inc(void);
int is_arm_StoreStackM4Inc(const ir_node *n);
/**
 * construct Store: Push 4 Registers = ST ptr,val
 */
ir_node *new_bd_arm_StoreStackM4Inc(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_node *op3, ir_node *op4, ir_node *op5);

extern ir_op *op_arm_fpaMuf;
ir_op *get_op_arm_fpaMuf(void);
int is_arm_fpaMuf(const ir_node *n);
/**
 * construct FPA Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_fpaMuf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_Mov_i;
ir_op *get_op_arm_Mov_i(void);
int is_arm_Mov_i(const ir_node *n);
/**
 * represents an integer constant
 */
ir_node *new_bd_arm_Mov_i(dbg_info *db, ir_node *block, ir_mode *mode, long imm);

extern ir_op *op_arm_Eor;
ir_op *get_op_arm_Eor(void);
int is_arm_Eor(const ir_node *n);
/**
 * construct Eor: Eor(a, b) = Eor(b, a) = a EOR b
 */
ir_node *new_bd_arm_Eor(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf);

extern ir_op *op_arm_fpaCmfeBra;
ir_op *get_op_arm_fpaCmfeBra(void);
int is_arm_fpaCmfeBra(const ir_node *n);
/**
 * construct floating point Compare and Branch: CMF A, -B && JMPxx LABEL
 */
ir_node *new_bd_arm_fpaCmfeBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num);

extern ir_op *op_arm_fpaCnfBra;
ir_op *get_op_arm_fpaCnfBra(void);
int is_arm_fpaCnfBra(const ir_node *n);
/**
 * construct floating point Compare negative and Branch: CMF A, -B && JMPxx LABEL
 */
ir_node *new_bd_arm_fpaCnfBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num);

extern ir_op *op_arm_Loadb;
ir_op *get_op_arm_Loadb(void);
int is_arm_Loadb(const ir_node *n);
/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_Loadb(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_Rsb;
ir_op *get_op_arm_Rsb(void);
int is_arm_Rsb(const ir_node *n);
/**
 * construct Rsb: Rsb(a, b) = b - a
 */
ir_node *new_bd_arm_Rsb(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf);

extern ir_op *op_arm_Loadh;
ir_op *get_op_arm_Loadh(void);
int is_arm_Loadh(const ir_node *n);
/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_Loadh(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_fpaLdf;
ir_op *get_op_arm_fpaLdf(void);
int is_arm_fpaLdf(const ir_node *n);
/**
 * construct FPA Load: Load(ptr, mem) = LD ptr
 */
ir_node *new_bd_arm_fpaLdf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode);

extern ir_op *op_arm_fpaAbs;
ir_op *get_op_arm_fpaAbs(void);
int is_arm_fpaAbs(const ir_node *n);
/**
 * construct FPA Absolute value: fAbsd(a) = |a|
 */
ir_node *new_bd_arm_fpaAbs(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_arm_fpaConst;
ir_op *get_op_arm_fpaConst(void);
int is_arm_fpaConst(const ir_node *n);
/**
 * construct a floating point constant
 */
ir_node *new_bd_arm_fpaConst(dbg_info *db, ir_node *block, tarval *tv);

extern ir_op *op_arm_fpaMuf_i;
ir_op *get_op_arm_fpaMuf_i(void);
int is_arm_fpaMuf_i(const ir_node *n);
/**
 * construct FPA Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_fpaMuf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);

extern ir_op *op_arm_fpaFdv;
ir_op *get_op_arm_fpaFdv(void);
int is_arm_fpaFdv(const ir_node *n);
/**
 * construct FPA Fast Div: Div(a, b) = a / b
 */
ir_node *new_bd_arm_fpaFdv(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode);

extern ir_op *op_arm_Or;
ir_op *get_op_arm_Or(void);
int is_arm_Or(const ir_node *n);
/**
 * construct Or: Or(a, b) = Or(b, a) = a OR b
 */
ir_node *new_bd_arm_Or(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf);

extern ir_op *op_arm_fpaMnf_i;
ir_op *get_op_arm_fpaMnf_i(void);
int is_arm_fpaMnf_i(const ir_node *n);
/**
 * represents a float constant
 */
ir_node *new_bd_arm_fpaMnf_i(dbg_info *db, ir_node *block, ir_mode *mode, long imm);

extern ir_op *op_arm_fpaMax;
ir_op *get_op_arm_fpaMax(void);
int is_arm_fpaMax(const ir_node *n);
/**
 * construct FPA Max: Max(a, b) = Max(b, a) = a > b ? a : b
 */
ir_node *new_bd_arm_fpaMax(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_Ror;
ir_op *get_op_arm_Ror(void);
int is_arm_Ror(const ir_node *n);
/**
 * construct Ror: Ror(a, b) = a <<r>> b
 */
ir_node *new_bd_arm_Ror(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_Smull;
ir_op *get_op_arm_Smull(void);
int is_arm_Smull(const ir_node *n);
/**
 * construct signed 64bit Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_Smull(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_Shl;
ir_op *get_op_arm_Shl(void);
int is_arm_Shl(const ir_node *n);
/**
 * construct Shl: Shl(a, b) = a << b
 */
ir_node *new_bd_arm_Shl(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_Add;
ir_op *get_op_arm_Add(void);
int is_arm_Add(const ir_node *n);
/**
 * construct Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_arm_Add(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf);

extern ir_op *op_arm_fpaSuf_i;
ir_op *get_op_arm_fpaSuf_i(void);
int is_arm_fpaSuf_i(const ir_node *n);
/**
 * construct FPA Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_arm_fpaSuf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);

extern ir_op *op_arm_LoadStackM3Epilogue;
ir_op *get_op_arm_LoadStackM3Epilogue(void);
int is_arm_LoadStackM3Epilogue(const ir_node *n);
/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_LoadStackM3Epilogue(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_Storeb;
ir_op *get_op_arm_Storeb(void);
int is_arm_Storeb(const ir_node *n);
/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_arm_Storeb(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2);

extern ir_op *op_arm_Bic;
ir_op *get_op_arm_Bic(void);
int is_arm_Bic(const ir_node *n);
/**
 * construct Bic: Bic(a, b) = a AND ~b
 */
ir_node *new_bd_arm_Bic(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf);

extern ir_op *op_arm_Mul;
ir_op *get_op_arm_Mul(void);
int is_arm_Mul(const ir_node *n);
/**
 * construct Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_Mul(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_fpaRsf_i;
ir_op *get_op_arm_fpaRsf_i(void);
int is_arm_fpaRsf_i(const ir_node *n);
/**
 * construct FPA reverse Sub: Sub(a, b) = b - a
 */
ir_node *new_bd_arm_fpaRsf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);

extern ir_op *op_arm_CmpBra;
ir_op *get_op_arm_CmpBra(void);
int is_arm_CmpBra(const ir_node *n);
/**
 * construct conditional branch: CMP A, B && JMPxx LABEL
 */
ir_node *new_bd_arm_CmpBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num);

extern ir_op *op_arm_fpaRsf;
ir_op *get_op_arm_fpaRsf(void);
int is_arm_fpaRsf(const ir_node *n);
/**
 * construct FPA reverse Sub: Sub(a, b) = b - a
 */
ir_node *new_bd_arm_fpaRsf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_arm_fpaMnf;
ir_op *get_op_arm_fpaMnf(void);
int is_arm_fpaMnf(const ir_node *n);
/**
 * construct FPA Move Negated: b = -a
 */
ir_node *new_bd_arm_fpaMnf(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_arm_Bic_i;
ir_op *get_op_arm_Bic_i(void);
int is_arm_Bic_i(const ir_node *n);
/**
 * construct Bic: Bic(a, const) = a AND ~const
 */
ir_node *new_bd_arm_Bic_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);

extern ir_op *op_arm_Rsb_i;
ir_op *get_op_arm_Rsb_i(void);
int is_arm_Rsb_i(const ir_node *n);
/**
 * construct Rsb: Rsb(a, const) = const - a
 */
ir_node *new_bd_arm_Rsb_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);

extern ir_op *op_arm_fpaCmfBra;
ir_op *get_op_arm_fpaCmfBra(void);
int is_arm_fpaCmfBra(const ir_node *n);
/**
 * construct floating point Compare and Branch: CMF A, B && JMPxx LABEL
 */
ir_node *new_bd_arm_fpaCmfBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num);

extern ir_op *op_arm_fpaMvf_i;
ir_op *get_op_arm_fpaMvf_i(void);
int is_arm_fpaMvf_i(const ir_node *n);
/**
 * represents a float constant
 */
ir_node *new_bd_arm_fpaMvf_i(dbg_info *db, ir_node *block, ir_mode *mode, long imm);

extern ir_op *op_arm_fpaStf;
ir_op *get_op_arm_fpaStf(void);
int is_arm_fpaStf(const ir_node *n);
/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_arm_fpaStf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *op_mode);

extern ir_op *op_arm_Store;
ir_op *get_op_arm_Store(void);
int is_arm_Store(const ir_node *n);
/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_arm_Store(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2);

extern ir_op *op_arm_And;
ir_op *get_op_arm_And(void);
int is_arm_And(const ir_node *n);
/**
 * construct And: And(a, b) = And(b, a) = a AND b
 */
ir_node *new_bd_arm_And(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf);

extern ir_op *op_arm_Loadhs;
ir_op *get_op_arm_Loadhs(void);
int is_arm_Loadhs(const ir_node *n);
/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_Loadhs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_fpaFlt;
ir_op *get_op_arm_fpaFlt(void);
int is_arm_fpaFlt(const ir_node *n);
/**
 * construct a FPA integer->float conversion
 */
ir_node *new_bd_arm_fpaFlt(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_arm_SwitchJmp;
ir_op *get_op_arm_SwitchJmp(void);
int is_arm_SwitchJmp(const ir_node *n);
/**
 * construct switch
 */
ir_node *new_bd_arm_SwitchJmp(dbg_info *db, ir_node *block, ir_node *op0, int n_projs, long def_proj_num);

extern ir_op *op_arm_SymConst;
ir_op *get_op_arm_SymConst(void);
int is_arm_SymConst(const ir_node *n);
/**
 * represents a symbolic constant
 */
ir_node *new_bd_arm_SymConst(dbg_info *db, ir_node *block, ir_mode *mode, ident *id);

extern ir_op *op_arm_Load;
ir_op *get_op_arm_Load(void);
int is_arm_Load(const ir_node *n);
/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_Load(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_arm_fpaAdf_i;
ir_op *get_op_arm_fpaAdf_i(void);
int is_arm_fpaAdf_i(const ir_node *n);
/**
 * construct FPA Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_arm_fpaAdf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm);


enum pn_arm_fpaFrd {
	pn_arm_fpaFrd_res = 0,
	pn_arm_fpaFrd_M = 1,
};

enum pn_arm_SubSPandCopy {
	pn_arm_SubSPandCopy_stack = 0,
	pn_arm_SubSPandCopy_addr = 1,
	pn_arm_SubSPandCopy_M = 2,
};

enum n_arm_SubSPandCopy {
	n_arm_SubSPandCopy_stack = 0,
	n_arm_SubSPandCopy_size = 1,
	n_arm_SubSPandCopy_mem = 2,
};

enum pn_arm_fpaRdf {
	pn_arm_fpaRdf_res = 0,
	pn_arm_fpaRdf_M = 1,
};

enum pn_arm_fpaFdv_i {
	pn_arm_fpaFdv_i_res = 0,
	pn_arm_fpaFdv_i_M = 1,
};

enum pn_arm_fpaFrd_i {
	pn_arm_fpaFrd_i_res = 0,
	pn_arm_fpaFrd_i_M = 1,
};

enum pn_arm_Umull {
	pn_arm_Umull_low = 0,
	pn_arm_Umull_high = 1,
};

enum pn_arm_Loadbs {
	pn_arm_Loadbs_res = 0,
	pn_arm_Loadbs_M = 1,
};

enum pn_arm_fpaRdf_i {
	pn_arm_fpaRdf_i_res = 0,
	pn_arm_fpaRdf_i_M = 1,
};

enum pn_arm_fpaDbl2GP {
	pn_arm_fpaDbl2GP_low = 0,
	pn_arm_fpaDbl2GP_high = 1,
	pn_arm_fpaDbl2GP_M = 2,
};

enum pn_arm_CopyB {
	pn_arm_CopyB_M = 0,
};

enum pn_arm_AddSP {
	pn_arm_AddSP_stack = 0,
	pn_arm_AddSP_M = 1,
};

enum pn_arm_fpaDvf {
	pn_arm_fpaDvf_res = 0,
	pn_arm_fpaDvf_M = 1,
};

enum pn_arm_fpaDvf_i {
	pn_arm_fpaDvf_i_res = 0,
	pn_arm_fpaDvf_i_M = 1,
};

enum pn_arm_StoreStackM4Inc {
	pn_arm_StoreStackM4Inc_ptr = 0,
	pn_arm_StoreStackM4Inc_M = 1,
};

enum pn_arm_Loadb {
	pn_arm_Loadb_res = 0,
	pn_arm_Loadb_M = 1,
};

enum pn_arm_Loadh {
	pn_arm_Loadh_res = 0,
	pn_arm_Loadh_M = 1,
};

enum pn_arm_fpaLdf {
	pn_arm_fpaLdf_res = 0,
	pn_arm_fpaLdf_M = 1,
};

enum pn_arm_fpaFdv {
	pn_arm_fpaFdv_res = 0,
	pn_arm_fpaFdv_M = 1,
};

enum pn_arm_Smull {
	pn_arm_Smull_low = 0,
	pn_arm_Smull_high = 1,
};

enum pn_arm_LoadStackM3Epilogue {
	pn_arm_LoadStackM3Epilogue_res0 = 0,
	pn_arm_LoadStackM3Epilogue_res1 = 1,
	pn_arm_LoadStackM3Epilogue_res2 = 2,
	pn_arm_LoadStackM3Epilogue_M = 3,
};

enum pn_arm_Loadhs {
	pn_arm_Loadhs_res = 0,
	pn_arm_Loadhs_M = 1,
};

enum pn_arm_Load {
	pn_arm_Load_res = 0,
	pn_arm_Load_M = 1,
};
#endif
