#include "gen_arm_regalloc_if.h"

static int cmp_attr_arm_Mov(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);
}

static int cmp_attr_arm_EmptyReg(ir_node *a, ir_node *b) {
	(void) a;
	(void) b;
	return 1;
}

static int cmp_attr_arm_And_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Add_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Mvn(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);
}

static int cmp_attr_arm_fpaFdv_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_fpaFrd_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Or_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Sub(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);
}

static int cmp_attr_arm_Sub_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_fpaRdf_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Eor_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_CopyB(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_fpaDvf_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Mvn_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Mov_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Eor(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);
}

static int cmp_attr_arm_Rsb(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);
}

static int cmp_attr_arm_fpaMuf_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Or(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);
}

static int cmp_attr_arm_fpaMnf_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Add(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);
}

static int cmp_attr_arm_fpaSuf_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Bic(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);
}

static int cmp_attr_arm_fpaRsf_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Bic_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_Rsb_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_fpaMvf_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}

static int cmp_attr_arm_And(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);
}

static int cmp_attr_arm_fpaAdf_i(ir_node *a, ir_node *b) {
	arm_attr_t *attr_a = get_irn_generic_attr(a);
	arm_attr_t *attr_b = get_irn_generic_attr(b);
	return attr_a->imm_value != attr_b->imm_value;
}


ir_op *op_arm_Unknown_GP = NULL;
ir_op *op_arm_Mla = NULL;
ir_op *op_arm_fpaMin = NULL;
ir_op *op_arm_fpaFrd = NULL;
ir_op *op_arm_Mov = NULL;
ir_op *op_arm_LdTls = NULL;
ir_op *op_arm_SubSPandCopy = NULL;
ir_op *op_arm_EmptyReg = NULL;
ir_op *op_arm_And_i = NULL;
ir_op *op_arm_fpaRdf = NULL;
ir_op *op_arm_Add_i = NULL;
ir_op *op_arm_fpaFix = NULL;
ir_op *op_arm_fpaMvf = NULL;
ir_op *op_arm_fpaCnfeBra = NULL;
ir_op *op_arm_Abs = NULL;
ir_op *op_arm_Mvn = NULL;
ir_op *op_arm_fpaFdv_i = NULL;
ir_op *op_arm_Unknown_FPA = NULL;
ir_op *op_arm_fpaFrd_i = NULL;
ir_op *op_arm_Or_i = NULL;
ir_op *op_arm_Umull = NULL;
ir_op *op_arm_Sub = NULL;
ir_op *op_arm_Sub_i = NULL;
ir_op *op_arm_Storeh = NULL;
ir_op *op_arm_Shr = NULL;
ir_op *op_arm_Loadbs = NULL;
ir_op *op_arm_Shrs = NULL;
ir_op *op_arm_fpaRdf_i = NULL;
ir_op *op_arm_fpaSuf = NULL;
ir_op *op_arm_fpaFml = NULL;
ir_op *op_arm_fpaDbl2GP = NULL;
ir_op *op_arm_Eor_i = NULL;
ir_op *op_arm_CopyB = NULL;
ir_op *op_arm_AddSP = NULL;
ir_op *op_arm_fpaAdf = NULL;
ir_op *op_arm_Copy = NULL;
ir_op *op_arm_fpaDvf = NULL;
ir_op *op_arm_fpaDvf_i = NULL;
ir_op *op_arm_TstBra = NULL;
ir_op *op_arm_Mvn_i = NULL;
ir_op *op_arm_StoreStackM4Inc = NULL;
ir_op *op_arm_fpaMuf = NULL;
ir_op *op_arm_Mov_i = NULL;
ir_op *op_arm_Eor = NULL;
ir_op *op_arm_fpaCmfeBra = NULL;
ir_op *op_arm_fpaCnfBra = NULL;
ir_op *op_arm_Loadb = NULL;
ir_op *op_arm_Rsb = NULL;
ir_op *op_arm_Loadh = NULL;
ir_op *op_arm_fpaLdf = NULL;
ir_op *op_arm_fpaAbs = NULL;
ir_op *op_arm_fpaConst = NULL;
ir_op *op_arm_fpaMuf_i = NULL;
ir_op *op_arm_fpaFdv = NULL;
ir_op *op_arm_Or = NULL;
ir_op *op_arm_fpaMnf_i = NULL;
ir_op *op_arm_fpaMax = NULL;
ir_op *op_arm_Ror = NULL;
ir_op *op_arm_Smull = NULL;
ir_op *op_arm_Shl = NULL;
ir_op *op_arm_Add = NULL;
ir_op *op_arm_fpaSuf_i = NULL;
ir_op *op_arm_LoadStackM3Epilogue = NULL;
ir_op *op_arm_Storeb = NULL;
ir_op *op_arm_Bic = NULL;
ir_op *op_arm_Mul = NULL;
ir_op *op_arm_fpaRsf_i = NULL;
ir_op *op_arm_CmpBra = NULL;
ir_op *op_arm_fpaRsf = NULL;
ir_op *op_arm_fpaMnf = NULL;
ir_op *op_arm_Bic_i = NULL;
ir_op *op_arm_Rsb_i = NULL;
ir_op *op_arm_fpaCmfBra = NULL;
ir_op *op_arm_fpaMvf_i = NULL;
ir_op *op_arm_fpaStf = NULL;
ir_op *op_arm_Store = NULL;
ir_op *op_arm_And = NULL;
ir_op *op_arm_Loadhs = NULL;
ir_op *op_arm_fpaFlt = NULL;
ir_op *op_arm_SwitchJmp = NULL;
ir_op *op_arm_SymConst = NULL;
ir_op *op_arm_Load = NULL;
ir_op *op_arm_fpaAdf_i = NULL;

ir_op *get_op_arm_Unknown_GP(void)         { return op_arm_Unknown_GP; }
int    is_arm_Unknown_GP(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Unknown_GP; }

ir_op *get_op_arm_Mla(void)         { return op_arm_Mla; }
int    is_arm_Mla(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mla; }

ir_op *get_op_arm_fpaMin(void)         { return op_arm_fpaMin; }
int    is_arm_fpaMin(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaMin; }

ir_op *get_op_arm_fpaFrd(void)         { return op_arm_fpaFrd; }
int    is_arm_fpaFrd(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaFrd; }

ir_op *get_op_arm_Mov(void)         { return op_arm_Mov; }
int    is_arm_Mov(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mov; }

ir_op *get_op_arm_LdTls(void)         { return op_arm_LdTls; }
int    is_arm_LdTls(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_LdTls; }

ir_op *get_op_arm_SubSPandCopy(void)         { return op_arm_SubSPandCopy; }
int    is_arm_SubSPandCopy(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_SubSPandCopy; }

ir_op *get_op_arm_EmptyReg(void)         { return op_arm_EmptyReg; }
int    is_arm_EmptyReg(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_EmptyReg; }

ir_op *get_op_arm_And_i(void)         { return op_arm_And_i; }
int    is_arm_And_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_And_i; }

ir_op *get_op_arm_fpaRdf(void)         { return op_arm_fpaRdf; }
int    is_arm_fpaRdf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaRdf; }

ir_op *get_op_arm_Add_i(void)         { return op_arm_Add_i; }
int    is_arm_Add_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Add_i; }

ir_op *get_op_arm_fpaFix(void)         { return op_arm_fpaFix; }
int    is_arm_fpaFix(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaFix; }

ir_op *get_op_arm_fpaMvf(void)         { return op_arm_fpaMvf; }
int    is_arm_fpaMvf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaMvf; }

ir_op *get_op_arm_fpaCnfeBra(void)         { return op_arm_fpaCnfeBra; }
int    is_arm_fpaCnfeBra(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaCnfeBra; }

ir_op *get_op_arm_Abs(void)         { return op_arm_Abs; }
int    is_arm_Abs(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Abs; }

ir_op *get_op_arm_Mvn(void)         { return op_arm_Mvn; }
int    is_arm_Mvn(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mvn; }

ir_op *get_op_arm_fpaFdv_i(void)         { return op_arm_fpaFdv_i; }
int    is_arm_fpaFdv_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaFdv_i; }

ir_op *get_op_arm_Unknown_FPA(void)         { return op_arm_Unknown_FPA; }
int    is_arm_Unknown_FPA(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Unknown_FPA; }

ir_op *get_op_arm_fpaFrd_i(void)         { return op_arm_fpaFrd_i; }
int    is_arm_fpaFrd_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaFrd_i; }

ir_op *get_op_arm_Or_i(void)         { return op_arm_Or_i; }
int    is_arm_Or_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Or_i; }

ir_op *get_op_arm_Umull(void)         { return op_arm_Umull; }
int    is_arm_Umull(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Umull; }

ir_op *get_op_arm_Sub(void)         { return op_arm_Sub; }
int    is_arm_Sub(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Sub; }

ir_op *get_op_arm_Sub_i(void)         { return op_arm_Sub_i; }
int    is_arm_Sub_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Sub_i; }

ir_op *get_op_arm_Storeh(void)         { return op_arm_Storeh; }
int    is_arm_Storeh(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Storeh; }

ir_op *get_op_arm_Shr(void)         { return op_arm_Shr; }
int    is_arm_Shr(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Shr; }

ir_op *get_op_arm_Loadbs(void)         { return op_arm_Loadbs; }
int    is_arm_Loadbs(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Loadbs; }

ir_op *get_op_arm_Shrs(void)         { return op_arm_Shrs; }
int    is_arm_Shrs(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Shrs; }

ir_op *get_op_arm_fpaRdf_i(void)         { return op_arm_fpaRdf_i; }
int    is_arm_fpaRdf_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaRdf_i; }

ir_op *get_op_arm_fpaSuf(void)         { return op_arm_fpaSuf; }
int    is_arm_fpaSuf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaSuf; }

ir_op *get_op_arm_fpaFml(void)         { return op_arm_fpaFml; }
int    is_arm_fpaFml(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaFml; }

ir_op *get_op_arm_fpaDbl2GP(void)         { return op_arm_fpaDbl2GP; }
int    is_arm_fpaDbl2GP(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaDbl2GP; }

ir_op *get_op_arm_Eor_i(void)         { return op_arm_Eor_i; }
int    is_arm_Eor_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Eor_i; }

ir_op *get_op_arm_CopyB(void)         { return op_arm_CopyB; }
int    is_arm_CopyB(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_CopyB; }

ir_op *get_op_arm_AddSP(void)         { return op_arm_AddSP; }
int    is_arm_AddSP(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_AddSP; }

ir_op *get_op_arm_fpaAdf(void)         { return op_arm_fpaAdf; }
int    is_arm_fpaAdf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaAdf; }

ir_op *get_op_arm_Copy(void)         { return op_arm_Copy; }
int    is_arm_Copy(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Copy; }

ir_op *get_op_arm_fpaDvf(void)         { return op_arm_fpaDvf; }
int    is_arm_fpaDvf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaDvf; }

ir_op *get_op_arm_fpaDvf_i(void)         { return op_arm_fpaDvf_i; }
int    is_arm_fpaDvf_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaDvf_i; }

ir_op *get_op_arm_TstBra(void)         { return op_arm_TstBra; }
int    is_arm_TstBra(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_TstBra; }

ir_op *get_op_arm_Mvn_i(void)         { return op_arm_Mvn_i; }
int    is_arm_Mvn_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mvn_i; }

ir_op *get_op_arm_StoreStackM4Inc(void)         { return op_arm_StoreStackM4Inc; }
int    is_arm_StoreStackM4Inc(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_StoreStackM4Inc; }

ir_op *get_op_arm_fpaMuf(void)         { return op_arm_fpaMuf; }
int    is_arm_fpaMuf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaMuf; }

ir_op *get_op_arm_Mov_i(void)         { return op_arm_Mov_i; }
int    is_arm_Mov_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mov_i; }

ir_op *get_op_arm_Eor(void)         { return op_arm_Eor; }
int    is_arm_Eor(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Eor; }

ir_op *get_op_arm_fpaCmfeBra(void)         { return op_arm_fpaCmfeBra; }
int    is_arm_fpaCmfeBra(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaCmfeBra; }

ir_op *get_op_arm_fpaCnfBra(void)         { return op_arm_fpaCnfBra; }
int    is_arm_fpaCnfBra(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaCnfBra; }

ir_op *get_op_arm_Loadb(void)         { return op_arm_Loadb; }
int    is_arm_Loadb(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Loadb; }

ir_op *get_op_arm_Rsb(void)         { return op_arm_Rsb; }
int    is_arm_Rsb(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Rsb; }

ir_op *get_op_arm_Loadh(void)         { return op_arm_Loadh; }
int    is_arm_Loadh(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Loadh; }

ir_op *get_op_arm_fpaLdf(void)         { return op_arm_fpaLdf; }
int    is_arm_fpaLdf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaLdf; }

ir_op *get_op_arm_fpaAbs(void)         { return op_arm_fpaAbs; }
int    is_arm_fpaAbs(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaAbs; }

ir_op *get_op_arm_fpaConst(void)         { return op_arm_fpaConst; }
int    is_arm_fpaConst(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaConst; }

ir_op *get_op_arm_fpaMuf_i(void)         { return op_arm_fpaMuf_i; }
int    is_arm_fpaMuf_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaMuf_i; }

ir_op *get_op_arm_fpaFdv(void)         { return op_arm_fpaFdv; }
int    is_arm_fpaFdv(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaFdv; }

ir_op *get_op_arm_Or(void)         { return op_arm_Or; }
int    is_arm_Or(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Or; }

ir_op *get_op_arm_fpaMnf_i(void)         { return op_arm_fpaMnf_i; }
int    is_arm_fpaMnf_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaMnf_i; }

ir_op *get_op_arm_fpaMax(void)         { return op_arm_fpaMax; }
int    is_arm_fpaMax(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaMax; }

ir_op *get_op_arm_Ror(void)         { return op_arm_Ror; }
int    is_arm_Ror(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Ror; }

ir_op *get_op_arm_Smull(void)         { return op_arm_Smull; }
int    is_arm_Smull(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Smull; }

ir_op *get_op_arm_Shl(void)         { return op_arm_Shl; }
int    is_arm_Shl(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Shl; }

ir_op *get_op_arm_Add(void)         { return op_arm_Add; }
int    is_arm_Add(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Add; }

ir_op *get_op_arm_fpaSuf_i(void)         { return op_arm_fpaSuf_i; }
int    is_arm_fpaSuf_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaSuf_i; }

ir_op *get_op_arm_LoadStackM3Epilogue(void)         { return op_arm_LoadStackM3Epilogue; }
int    is_arm_LoadStackM3Epilogue(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_LoadStackM3Epilogue; }

ir_op *get_op_arm_Storeb(void)         { return op_arm_Storeb; }
int    is_arm_Storeb(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Storeb; }

ir_op *get_op_arm_Bic(void)         { return op_arm_Bic; }
int    is_arm_Bic(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Bic; }

ir_op *get_op_arm_Mul(void)         { return op_arm_Mul; }
int    is_arm_Mul(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Mul; }

ir_op *get_op_arm_fpaRsf_i(void)         { return op_arm_fpaRsf_i; }
int    is_arm_fpaRsf_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaRsf_i; }

ir_op *get_op_arm_CmpBra(void)         { return op_arm_CmpBra; }
int    is_arm_CmpBra(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_CmpBra; }

ir_op *get_op_arm_fpaRsf(void)         { return op_arm_fpaRsf; }
int    is_arm_fpaRsf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaRsf; }

ir_op *get_op_arm_fpaMnf(void)         { return op_arm_fpaMnf; }
int    is_arm_fpaMnf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaMnf; }

ir_op *get_op_arm_Bic_i(void)         { return op_arm_Bic_i; }
int    is_arm_Bic_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Bic_i; }

ir_op *get_op_arm_Rsb_i(void)         { return op_arm_Rsb_i; }
int    is_arm_Rsb_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Rsb_i; }

ir_op *get_op_arm_fpaCmfBra(void)         { return op_arm_fpaCmfBra; }
int    is_arm_fpaCmfBra(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaCmfBra; }

ir_op *get_op_arm_fpaMvf_i(void)         { return op_arm_fpaMvf_i; }
int    is_arm_fpaMvf_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaMvf_i; }

ir_op *get_op_arm_fpaStf(void)         { return op_arm_fpaStf; }
int    is_arm_fpaStf(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaStf; }

ir_op *get_op_arm_Store(void)         { return op_arm_Store; }
int    is_arm_Store(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Store; }

ir_op *get_op_arm_And(void)         { return op_arm_And; }
int    is_arm_And(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_And; }

ir_op *get_op_arm_Loadhs(void)         { return op_arm_Loadhs; }
int    is_arm_Loadhs(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Loadhs; }

ir_op *get_op_arm_fpaFlt(void)         { return op_arm_fpaFlt; }
int    is_arm_fpaFlt(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaFlt; }

ir_op *get_op_arm_SwitchJmp(void)         { return op_arm_SwitchJmp; }
int    is_arm_SwitchJmp(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_SwitchJmp; }

ir_op *get_op_arm_SymConst(void)         { return op_arm_SymConst; }
int    is_arm_SymConst(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_SymConst; }

ir_op *get_op_arm_Load(void)         { return op_arm_Load; }
int    is_arm_Load(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_Load; }

ir_op *get_op_arm_fpaAdf_i(void)         { return op_arm_fpaAdf_i; }
int    is_arm_fpaAdf_i(const ir_node *n) { return get_arm_irn_opcode(n) == iro_arm_fpaAdf_i; }



static int arm_opcode_start = -1;
static int arm_opcode_end   = -1;


/** A tag for the arm opcodes. Note that the address is used as a tag value, NOT the FOURCC code. */
#define arm_op_tag FOURCC('A', 'R', 'M', '\0')

/** Return the opcode number of the first arm opcode. */
int get_arm_opcode_first(void) {
	return arm_opcode_start;
}

/** Return the opcode number of the last arm opcode + 1. */
int get_arm_opcode_last(void) {
	return arm_opcode_end;
}

/** Return 1 if the given opcode is a arm machine op, 0 otherwise */
int is_arm_op(const ir_op *op) {
	return get_op_tag(op) == arm_op_tag;
}

/** Return 1 if the given node is a arm machine node, 0 otherwise */
int is_arm_irn(const ir_node *node) {
	return is_arm_op(get_irn_op(node));
}

int get_arm_irn_opcode(const ir_node *node) {
	if (is_arm_irn(node))
		return get_irn_opcode(node) - arm_opcode_start;
	return -1;
}

#ifdef BIT
#undef BIT
#endif
#define BIT(x)  (1 << (x % 32))

static const unsigned arm_limit_gp_gp_UKNWN[] = { BIT(REG_GP_UKNWN), 0 };
static const unsigned arm_limit_gp_sp[] = { BIT(REG_SP), 0 };
static const unsigned arm_limit_fpa_fpa_UKNWN[] = { BIT(REG_FPA_UKNWN), 0 };
static const unsigned arm_limit_gp_gp_UKNWN_pc_r12_sp_sp[] = { 0xFFFFFFFF & ~BIT(REG_SP) & ~BIT(REG_R12) & ~BIT(REG_SP) & ~BIT(REG_PC) & ~BIT(REG_GP_UKNWN), 0xFFFFFFFF };
static const unsigned arm_limit_gp_r11[] = { BIT(REG_R11), 0 };
static const unsigned arm_limit_gp_pc[] = { BIT(REG_PC), 0 };

static const arch_register_req_t arm_requirements_gp_gp_UKNWN_I = {
	arch_register_req_type_ignore | arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_gp_UKNWN,
	0,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t arm_requirements_gp_gp = {
	arch_register_req_type_normal,
	& arm_reg_classes[CLASS_arm_gp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0            /* different pos */
};


static const arch_register_req_t arm_requirements_gp_not_in_r1 = {
	arch_register_req_type_must_be_different,
	& arm_reg_classes[CLASS_arm_gp],
	NULL,
	0,        /* same pos */
	1        /* different pos */
};


static const arch_register_req_t arm_requirements_fpa_fpa = {
	arch_register_req_type_normal,
	& arm_reg_classes[CLASS_arm_fpa],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0            /* different pos */
};


static const arch_register_req_t arm_requirements__none = {
	arch_register_req_type_none,
	NULL,                         /* regclass */
	NULL,                         /* limit bitset */
	0,                            /* same pos */
	0                             /* different pos */
};


static const arch_register_req_t arm_requirements_gp_sp = {
	arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_sp,
	0,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t arm_requirements_gp_sp_I_S = {
	arch_register_req_type_ignore | arch_register_req_type_produces_sp | arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_sp,
	0,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t arm_requirements_fpa_fpa_UKNWN_I = {
	arch_register_req_type_ignore | arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_fpa],
	arm_limit_fpa_fpa_UKNWN,
	0,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t arm_requirements_gp_not_sp = {
	arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_gp_UKNWN_pc_r12_sp_sp,
	0,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t arm_requirements_gp_r11_I = {
	arch_register_req_type_ignore | arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_r11,
	0,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t arm_requirements_gp_pc_I = {
	arch_register_req_type_ignore | arch_register_req_type_limited,
	& arm_reg_classes[CLASS_arm_gp],
	arm_limit_gp_pc,
	0,        /* same pos */
	0        /* different pos */
};



/**
 * construct Unknown_GP node
 */
ir_node *new_bd_arm_Unknown_GP(dbg_info *db, ir_node *block)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Unknown_GP;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp_UKNWN_I,
	};

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Mla: Mla(a, b, c) = a * b + c
 */
ir_node *new_bd_arm_Mla(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Mla;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_not_in_r1,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Min: Min(a, b) = Min(b, a) = a < b ? a : b
 */
ir_node *new_bd_arm_fpaMin(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaMin;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Fast reverse Div: Div(a, b) = b / a
 */
ir_node *new_bd_arm_fpaFrd(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaFrd;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->op_mode = op_mode;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Mov: a = b
 */
ir_node *new_bd_arm_Mov(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, arm_shift_modifier mod, long shf)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Mov;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * load the TLS address
 */
ir_node *new_bd_arm_LdTls(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_LdTls;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Sub from stack pointer and copy to Register
 */
ir_node *new_bd_arm_SubSPandCopy(dbg_info *db, ir_node *block, ir_node *stack, ir_node *size, ir_node *mem)
{
	ir_node  *res;
	ir_op    *op      = op_arm_SubSPandCopy;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 3;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_sp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_sp_I_S,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = stack;
	in[1] = size;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * allocate an empty register for calculations
 */
ir_node *new_bd_arm_EmptyReg(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_EmptyReg;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct And: And(a, const) = And(const, a) = a AND const
 */
ir_node *new_bd_arm_And_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_And_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA reverse Div: Div(a, b) = b / a
 */
ir_node *new_bd_arm_fpaRdf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaRdf;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->op_mode = op_mode;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Add: Add(a, const) = Add(const, a) = a + const
 */
ir_node *new_bd_arm_Add_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Add_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct a FPA float->integer conversion
 */
ir_node *new_bd_arm_fpaFix(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaFix;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Move: b = a
 */
ir_node *new_bd_arm_fpaMvf(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaMvf;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct floating point Compare and Branch: CMF A, -B && JMPxx LABEL
 */
ir_node *new_bd_arm_fpaCnfeBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaCnfeBra;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
		& arm_requirements__none,
	};
	arm_CondJmp_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
		set_arm_CondJmp_proj_num(res, proj_num);
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Abs: Abs(a) = |a|
 */
ir_node *new_bd_arm_Abs(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Abs;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Not: Not(a) = !a
 */
ir_node *new_bd_arm_Mvn(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, arm_shift_modifier mod, long shf)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Mvn;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Fast Div: Div(a, b) = a / b
 */
ir_node *new_bd_arm_fpaFdv_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *op_mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaFdv_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->op_mode = op_mode; ARM_SET_FPA_IMM(attr); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Unknown_FPA node
 */
ir_node *new_bd_arm_Unknown_FPA(dbg_info *db, ir_node *block)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Unknown_FPA;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	ir_mode  *mode    = mode_E;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa_UKNWN_I,
	};

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Fast reverse Div: Div(a, b) = b / a
 */
ir_node *new_bd_arm_fpaFrd_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *op_mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaFrd_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->op_mode = op_mode; ARM_SET_FPA_IMM(attr); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Or: Or(a, const) = Or(const, a) = a OR const
 */
ir_node *new_bd_arm_Or_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Or_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct unsigned 64bit Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_Umull(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Umull;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_arm_Sub(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Sub;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Sub: Sub(a, const) = a - const
 */
ir_node *new_bd_arm_Sub_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Sub_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_arm_Storeh(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Storeh;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shr: Shr(a, b) = a >>u b
 */
ir_node *new_bd_arm_Shr(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Shr;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_Loadbs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Loadbs;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shrs: Shrs(a, b) = a >>s b
 */
ir_node *new_bd_arm_Shrs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Shrs;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA reverse Div: Div(a, b) = b / a
 */
ir_node *new_bd_arm_fpaRdf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *op_mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaRdf_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->op_mode = op_mode; ARM_SET_FPA_IMM(attr); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_arm_fpaSuf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaSuf;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Fast Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_fpaFml(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaFml;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct fp double to 2 gp register transfer
 */
ir_node *new_bd_arm_fpaDbl2GP(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaDbl2GP;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 3;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Eor: Eor(a, const) = Eor(const, a) = a EOR const
 */
ir_node *new_bd_arm_Eor_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Eor_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * implements a memcopy: CopyB(dst, src, size, mem) == memcpy(dst, src, size)
 */
ir_node *new_bd_arm_CopyB(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_node *op3, ir_node *op4, ir_node *op5, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_CopyB;
	int       flags   = 0;
	int       arity   = 6;
	ir_node  *in[6];
	int       n_res   = 1;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_not_sp,
		& arm_requirements_gp_not_sp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;
	in[3] = op3;
	in[4] = op4;
	in[5] = op5;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Add to stack pointer
 */
ir_node *new_bd_arm_AddSP(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2)
{
	ir_node  *res;
	ir_op    *op      = op_arm_AddSP;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_sp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_sp_I_S,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_arm_fpaAdf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaAdf;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * implements a register copy
 */
ir_node *new_bd_arm_Copy(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Copy;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Div: Div(a, b) = a / b
 */
ir_node *new_bd_arm_fpaDvf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaDvf;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->op_mode = op_mode;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Div: Div(a, b) = a / b
 */
ir_node *new_bd_arm_fpaDvf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *op_mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaDvf_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->op_mode = op_mode; ARM_SET_FPA_IMM(attr); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct conditional branch: TST A, B && JMPxx LABEL
 */
ir_node *new_bd_arm_TstBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num)
{
	ir_node  *res;
	ir_op    *op      = op_arm_TstBra;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
		& arm_requirements__none,
	};
	arm_CondJmp_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
		set_arm_CondJmp_proj_num(res, proj_num);
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * represents a negated integer constant
 */
ir_node *new_bd_arm_Mvn_i(dbg_info *db, ir_node *block, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Mvn_i;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store: Push 4 Registers = ST ptr,val
 */
ir_node *new_bd_arm_StoreStackM4Inc(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_node *op3, ir_node *op4, ir_node *op5)
{
	ir_node  *res;
	ir_op    *op      = op_arm_StoreStackM4Inc;
	int       flags   = 0;
	int       arity   = 6;
	ir_node  *in[6];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_sp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_sp_I_S,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;
	in[3] = op3;
	in[4] = op4;
	in[5] = op5;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_fpaMuf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaMuf;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * represents an integer constant
 */
ir_node *new_bd_arm_Mov_i(dbg_info *db, ir_node *block, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Mov_i;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Eor: Eor(a, b) = Eor(b, a) = a EOR b
 */
ir_node *new_bd_arm_Eor(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Eor;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct floating point Compare and Branch: CMF A, -B && JMPxx LABEL
 */
ir_node *new_bd_arm_fpaCmfeBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaCmfeBra;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
		& arm_requirements__none,
	};
	arm_CondJmp_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
		set_arm_CondJmp_proj_num(res, proj_num);
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct floating point Compare negative and Branch: CMF A, -B && JMPxx LABEL
 */
ir_node *new_bd_arm_fpaCnfBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaCnfBra;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
		& arm_requirements__none,
	};
	arm_CondJmp_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
		set_arm_CondJmp_proj_num(res, proj_num);
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_Loadb(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Loadb;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Rsb: Rsb(a, b) = b - a
 */
ir_node *new_bd_arm_Rsb(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Rsb;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_Loadh(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Loadh;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Load: Load(ptr, mem) = LD ptr
 */
ir_node *new_bd_arm_fpaLdf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaLdf;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->op_mode = op_mode;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Absolute value: fAbsd(a) = |a|
 */
ir_node *new_bd_arm_fpaAbs(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaAbs;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct a floating point constant
 */
ir_node *new_bd_arm_fpaConst(dbg_info *db, ir_node *block, tarval *tv)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaConst;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	ir_mode  *mode    = get_tarval_mode(tv);
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	arm_fpaConst_attr_t *attr;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->tv = tv;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_fpaMuf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaMuf_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_FPA_IMM(attr); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Fast Div: Div(a, b) = a / b
 */
ir_node *new_bd_arm_fpaFdv(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *op_mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaFdv;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->op_mode = op_mode;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Or: Or(a, b) = Or(b, a) = a OR b
 */
ir_node *new_bd_arm_Or(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Or;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * represents a float constant
 */
ir_node *new_bd_arm_fpaMnf_i(dbg_info *db, ir_node *block, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaMnf_i;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	arm_attr_t *attr;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_FPA_IMM(attr); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Max: Max(a, b) = Max(b, a) = a > b ? a : b
 */
ir_node *new_bd_arm_fpaMax(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaMax;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Ror: Ror(a, b) = a <<r>> b
 */
ir_node *new_bd_arm_Ror(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Ror;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct signed 64bit Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_Smull(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Smull;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shl: Shl(a, b) = a << b
 */
ir_node *new_bd_arm_Shl(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Shl;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_arm_Add(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Add;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_arm_fpaSuf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaSuf_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_FPA_IMM(attr); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_LoadStackM3Epilogue(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_arm_LoadStackM3Epilogue;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 4;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_sp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_r11_I,
		& arm_requirements_gp_sp_I_S,
		& arm_requirements_gp_pc_I,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_arm_Storeb(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Storeb;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Bic: Bic(a, b) = a AND ~b
 */
ir_node *new_bd_arm_Bic(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Bic;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_arm_Mul(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Mul;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_not_in_r1,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA reverse Sub: Sub(a, b) = b - a
 */
ir_node *new_bd_arm_fpaRsf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaRsf_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_FPA_IMM(attr); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct conditional branch: CMP A, B && JMPxx LABEL
 */
ir_node *new_bd_arm_CmpBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num)
{
	ir_node  *res;
	ir_op    *op      = op_arm_CmpBra;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
		& arm_requirements__none,
	};
	arm_CondJmp_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
		set_arm_CondJmp_proj_num(res, proj_num);
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA reverse Sub: Sub(a, b) = b - a
 */
ir_node *new_bd_arm_fpaRsf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaRsf;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Move Negated: b = -a
 */
ir_node *new_bd_arm_fpaMnf(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaMnf;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Bic: Bic(a, const) = a AND ~const
 */
ir_node *new_bd_arm_Bic_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Bic_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Rsb: Rsb(a, const) = const - a
 */
ir_node *new_bd_arm_Rsb_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Rsb_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct floating point Compare and Branch: CMF A, B && JMPxx LABEL
 */
ir_node *new_bd_arm_fpaCmfBra(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, int proj_num)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaCmfBra;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
		& arm_requirements__none,
	};
	arm_CondJmp_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
		set_arm_CondJmp_proj_num(res, proj_num);
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * represents a float constant
 */
ir_node *new_bd_arm_fpaMvf_i(dbg_info *db, ir_node *block, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaMvf_i;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	arm_attr_t *attr;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_FPA_IMM(attr); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_arm_fpaStf(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *op_mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaStf;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_fpa_fpa,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	attr->op_mode = op_mode;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_arm_Store(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Store;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct And: And(a, b) = And(b, a) = a AND b
 */
ir_node *new_bd_arm_And(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode, arm_shift_modifier mod, long shf)
{
	ir_node  *res;
	ir_op    *op      = op_arm_And;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_Loadhs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Loadhs;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct a FPA integer->float conversion
 */
ir_node *new_bd_arm_fpaFlt(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaFlt;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct switch
 */
ir_node *new_bd_arm_SwitchJmp(dbg_info *db, ir_node *block, ir_node *op0, int n_projs, long def_proj_num)
{
	ir_node  *res;
	ir_op    *op      = op_arm_SwitchJmp;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements__none,
	};
	arm_SwitchJmp_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
		set_arm_SwitchJmp_n_projs(res, n_projs);
	set_arm_SwitchJmp_default_proj_num(res, def_proj_num);
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * represents a symbolic constant
 */
ir_node *new_bd_arm_SymConst(dbg_info *db, ir_node *block, ir_mode *mode, ident *id)
{
	ir_node  *res;
	ir_op    *op      = op_arm_SymConst;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
	};
	arm_SymConst_attr_t *attr;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
		set_arm_symconst_id(res, id);
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_arm_Load(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_arm_Load;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_gp_gp,
		& arm_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FPA Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_arm_fpaAdf_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode, long imm)
{
	ir_node  *res;
	ir_op    *op      = op_arm_fpaAdf_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& arm_requirements_fpa_fpa,
	};
	arm_attr_t *attr;

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	attr = get_irn_generic_attr(res);
	ARM_SET_FPA_IMM(attr); attr->imm_value = imm;
	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * Creates the arm specific Firm machine operations
 * needed for the assembler irgs.
 */
void arm_create_opcodes(const arch_irn_ops_t *be_ops) {
#define N   irop_flag_none
#define L   irop_flag_labeled
#define C   irop_flag_commutative
#define X   irop_flag_cfopcode
#define I   irop_flag_ip_cfopcode
#define F   irop_flag_fragile
#define Y   irop_flag_forking
#define H   irop_flag_highlevel
#define c   irop_flag_constlike
#define K   irop_flag_keep
#define M   irop_flag_machine
#define O   irop_flag_machine_op
#define NB  irop_flag_dump_noblock
#define NI  irop_flag_dump_noinput
#define R   (irop_flag_user << 0)

	ir_op_ops  ops;
	int        cur_opcode;
	static int run_once = 0;
	int        i;

	if (run_once)
		return;
	run_once = 1;
	
	/* we handle all middleend nodes as well that have no other handler */
	for (i = 0; i <= iro_Last; ++i) {
		ir_op *op      = get_irp_opcode(i);
		if (op->ops.be_ops == NULL)
			op->ops.be_ops = be_ops;
	}

	cur_opcode = get_next_ir_opcodes(iro_arm_last);
  
	arm_opcode_start = cur_opcode;

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Unknown_GP = new_ir_op(cur_opcode + iro_arm_Unknown_GP, "arm_Unknown_GP", op_pin_state_pinned, c|M, oparity_zero, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Unknown_GP, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Mla = new_ir_op(cur_opcode + iro_arm_Mla, "arm_Mla", op_pin_state_floats, N|M, oparity_trinary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Mla, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaMin = new_ir_op(cur_opcode + iro_arm_fpaMin, "arm_fpaMin", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaMin, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaFrd = new_ir_op(cur_opcode + iro_arm_fpaFrd, "arm_fpaFrd", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaFrd, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Mov;
	ops.copy_attr = arm_copy_attr;
	op_arm_Mov = new_ir_op(cur_opcode + iro_arm_Mov, "arm_Mov", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Mov, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_LdTls = new_ir_op(cur_opcode + iro_arm_LdTls, "arm_LdTls", op_pin_state_floats, N|M, oparity_zero, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_LdTls, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_SubSPandCopy = new_ir_op(cur_opcode + iro_arm_SubSPandCopy, "arm_SubSPandCopy", op_pin_state_floats, N|M, oparity_trinary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_SubSPandCopy, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_EmptyReg;
	ops.copy_attr = arm_copy_attr;
	op_arm_EmptyReg = new_ir_op(cur_opcode + iro_arm_EmptyReg, "arm_EmptyReg", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_EmptyReg, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_And_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_And_i = new_ir_op(cur_opcode + iro_arm_And_i, "arm_And_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_And_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaRdf = new_ir_op(cur_opcode + iro_arm_fpaRdf, "arm_fpaRdf", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaRdf, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Add_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_Add_i = new_ir_op(cur_opcode + iro_arm_Add_i, "arm_Add_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Add_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaFix = new_ir_op(cur_opcode + iro_arm_fpaFix, "arm_fpaFix", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaFix, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaMvf = new_ir_op(cur_opcode + iro_arm_fpaMvf, "arm_fpaMvf", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaMvf, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_CondJmp;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaCnfeBra = new_ir_op(cur_opcode + iro_arm_fpaCnfeBra, "arm_fpaCnfeBra", op_pin_state_pinned, L|X|Y|M, oparity_binary, 0, sizeof(arm_CondJmp_attr_t), &ops);
	set_op_tag(op_arm_fpaCnfeBra, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Abs = new_ir_op(cur_opcode + iro_arm_Abs, "arm_Abs", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Abs, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Mvn;
	ops.copy_attr = arm_copy_attr;
	op_arm_Mvn = new_ir_op(cur_opcode + iro_arm_Mvn, "arm_Mvn", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Mvn, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaFdv_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaFdv_i = new_ir_op(cur_opcode + iro_arm_fpaFdv_i, "arm_fpaFdv_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaFdv_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Unknown_FPA = new_ir_op(cur_opcode + iro_arm_Unknown_FPA, "arm_Unknown_FPA", op_pin_state_pinned, c|M, oparity_zero, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Unknown_FPA, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaFrd_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaFrd_i = new_ir_op(cur_opcode + iro_arm_fpaFrd_i, "arm_fpaFrd_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaFrd_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Or_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_Or_i = new_ir_op(cur_opcode + iro_arm_Or_i, "arm_Or_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Or_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Umull = new_ir_op(cur_opcode + iro_arm_Umull, "arm_Umull", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Umull, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Sub;
	ops.copy_attr = arm_copy_attr;
	op_arm_Sub = new_ir_op(cur_opcode + iro_arm_Sub, "arm_Sub", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Sub, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Sub_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_Sub_i = new_ir_op(cur_opcode + iro_arm_Sub_i, "arm_Sub_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Sub_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Storeh = new_ir_op(cur_opcode + iro_arm_Storeh, "arm_Storeh", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Storeh, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Shr = new_ir_op(cur_opcode + iro_arm_Shr, "arm_Shr", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Shr, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Loadbs = new_ir_op(cur_opcode + iro_arm_Loadbs, "arm_Loadbs", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Loadbs, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Shrs = new_ir_op(cur_opcode + iro_arm_Shrs, "arm_Shrs", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Shrs, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaRdf_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaRdf_i = new_ir_op(cur_opcode + iro_arm_fpaRdf_i, "arm_fpaRdf_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaRdf_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaSuf = new_ir_op(cur_opcode + iro_arm_fpaSuf, "arm_fpaSuf", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaSuf, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaFml = new_ir_op(cur_opcode + iro_arm_fpaFml, "arm_fpaFml", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaFml, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaDbl2GP = new_ir_op(cur_opcode + iro_arm_fpaDbl2GP, "arm_fpaDbl2GP", op_pin_state_floats, L|F|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaDbl2GP, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Eor_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_Eor_i = new_ir_op(cur_opcode + iro_arm_Eor_i, "arm_Eor_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Eor_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_CopyB;
	ops.copy_attr = arm_copy_attr;
	op_arm_CopyB = new_ir_op(cur_opcode + iro_arm_CopyB, "arm_CopyB", op_pin_state_pinned, F|H|M, oparity_any, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_CopyB, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_AddSP = new_ir_op(cur_opcode + iro_arm_AddSP, "arm_AddSP", op_pin_state_floats, N|M, oparity_trinary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_AddSP, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaAdf = new_ir_op(cur_opcode + iro_arm_fpaAdf, "arm_fpaAdf", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaAdf, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Copy = new_ir_op(cur_opcode + iro_arm_Copy, "arm_Copy", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Copy, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaDvf = new_ir_op(cur_opcode + iro_arm_fpaDvf, "arm_fpaDvf", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaDvf, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaDvf_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaDvf_i = new_ir_op(cur_opcode + iro_arm_fpaDvf_i, "arm_fpaDvf_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaDvf_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_CondJmp;
	ops.copy_attr = arm_copy_attr;
	op_arm_TstBra = new_ir_op(cur_opcode + iro_arm_TstBra, "arm_TstBra", op_pin_state_pinned, L|X|Y|M, oparity_binary, 0, sizeof(arm_CondJmp_attr_t), &ops);
	set_op_tag(op_arm_TstBra, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Mvn_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_Mvn_i = new_ir_op(cur_opcode + iro_arm_Mvn_i, "arm_Mvn_i", op_pin_state_floats, N|M, oparity_zero, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Mvn_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_StoreStackM4Inc = new_ir_op(cur_opcode + iro_arm_StoreStackM4Inc, "arm_StoreStackM4Inc", op_pin_state_exc_pinned, L|F|M, oparity_any, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_StoreStackM4Inc, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaMuf = new_ir_op(cur_opcode + iro_arm_fpaMuf, "arm_fpaMuf", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaMuf, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Mov_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_Mov_i = new_ir_op(cur_opcode + iro_arm_Mov_i, "arm_Mov_i", op_pin_state_floats, N|M, oparity_zero, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Mov_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Eor;
	ops.copy_attr = arm_copy_attr;
	op_arm_Eor = new_ir_op(cur_opcode + iro_arm_Eor, "arm_Eor", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Eor, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_CondJmp;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaCmfeBra = new_ir_op(cur_opcode + iro_arm_fpaCmfeBra, "arm_fpaCmfeBra", op_pin_state_pinned, L|X|Y|M, oparity_binary, 0, sizeof(arm_CondJmp_attr_t), &ops);
	set_op_tag(op_arm_fpaCmfeBra, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_CondJmp;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaCnfBra = new_ir_op(cur_opcode + iro_arm_fpaCnfBra, "arm_fpaCnfBra", op_pin_state_pinned, L|X|Y|M, oparity_binary, 0, sizeof(arm_CondJmp_attr_t), &ops);
	set_op_tag(op_arm_fpaCnfBra, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Loadb = new_ir_op(cur_opcode + iro_arm_Loadb, "arm_Loadb", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Loadb, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Rsb;
	ops.copy_attr = arm_copy_attr;
	op_arm_Rsb = new_ir_op(cur_opcode + iro_arm_Rsb, "arm_Rsb", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Rsb, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Loadh = new_ir_op(cur_opcode + iro_arm_Loadh, "arm_Loadh", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Loadh, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaLdf = new_ir_op(cur_opcode + iro_arm_fpaLdf, "arm_fpaLdf", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaLdf, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaAbs = new_ir_op(cur_opcode + iro_arm_fpaAbs, "arm_fpaAbs", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaAbs, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaConst;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaConst = new_ir_op(cur_opcode + iro_arm_fpaConst, "arm_fpaConst", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(arm_fpaConst_attr_t), &ops);
	set_op_tag(op_arm_fpaConst, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaMuf_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaMuf_i = new_ir_op(cur_opcode + iro_arm_fpaMuf_i, "arm_fpaMuf_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaMuf_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaFdv = new_ir_op(cur_opcode + iro_arm_fpaFdv, "arm_fpaFdv", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaFdv, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Or;
	ops.copy_attr = arm_copy_attr;
	op_arm_Or = new_ir_op(cur_opcode + iro_arm_Or, "arm_Or", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Or, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaMnf_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaMnf_i = new_ir_op(cur_opcode + iro_arm_fpaMnf_i, "arm_fpaMnf_i", op_pin_state_floats, N|M, oparity_zero, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaMnf_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaMax = new_ir_op(cur_opcode + iro_arm_fpaMax, "arm_fpaMax", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaMax, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Ror = new_ir_op(cur_opcode + iro_arm_Ror, "arm_Ror", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Ror, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Smull = new_ir_op(cur_opcode + iro_arm_Smull, "arm_Smull", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Smull, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Shl = new_ir_op(cur_opcode + iro_arm_Shl, "arm_Shl", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Shl, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Add;
	ops.copy_attr = arm_copy_attr;
	op_arm_Add = new_ir_op(cur_opcode + iro_arm_Add, "arm_Add", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Add, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaSuf_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaSuf_i = new_ir_op(cur_opcode + iro_arm_fpaSuf_i, "arm_fpaSuf_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaSuf_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_LoadStackM3Epilogue = new_ir_op(cur_opcode + iro_arm_LoadStackM3Epilogue, "arm_LoadStackM3Epilogue", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_LoadStackM3Epilogue, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Storeb = new_ir_op(cur_opcode + iro_arm_Storeb, "arm_Storeb", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Storeb, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Bic;
	ops.copy_attr = arm_copy_attr;
	op_arm_Bic = new_ir_op(cur_opcode + iro_arm_Bic, "arm_Bic", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Bic, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Mul = new_ir_op(cur_opcode + iro_arm_Mul, "arm_Mul", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Mul, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaRsf_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaRsf_i = new_ir_op(cur_opcode + iro_arm_fpaRsf_i, "arm_fpaRsf_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaRsf_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_CondJmp;
	ops.copy_attr = arm_copy_attr;
	op_arm_CmpBra = new_ir_op(cur_opcode + iro_arm_CmpBra, "arm_CmpBra", op_pin_state_pinned, L|X|Y|M, oparity_binary, 0, sizeof(arm_CondJmp_attr_t), &ops);
	set_op_tag(op_arm_CmpBra, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaRsf = new_ir_op(cur_opcode + iro_arm_fpaRsf, "arm_fpaRsf", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaRsf, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaMnf = new_ir_op(cur_opcode + iro_arm_fpaMnf, "arm_fpaMnf", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaMnf, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Bic_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_Bic_i = new_ir_op(cur_opcode + iro_arm_Bic_i, "arm_Bic_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Bic_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_Rsb_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_Rsb_i = new_ir_op(cur_opcode + iro_arm_Rsb_i, "arm_Rsb_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Rsb_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_CondJmp;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaCmfBra = new_ir_op(cur_opcode + iro_arm_fpaCmfBra, "arm_fpaCmfBra", op_pin_state_pinned, L|X|Y|M, oparity_binary, 0, sizeof(arm_CondJmp_attr_t), &ops);
	set_op_tag(op_arm_fpaCmfBra, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaMvf_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaMvf_i = new_ir_op(cur_opcode + iro_arm_fpaMvf_i, "arm_fpaMvf_i", op_pin_state_floats, N|M, oparity_zero, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaMvf_i, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaStf = new_ir_op(cur_opcode + iro_arm_fpaStf, "arm_fpaStf", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaStf, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Store = new_ir_op(cur_opcode + iro_arm_Store, "arm_Store", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Store, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_And;
	ops.copy_attr = arm_copy_attr;
	op_arm_And = new_ir_op(cur_opcode + iro_arm_And, "arm_And", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_And, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Loadhs = new_ir_op(cur_opcode + iro_arm_Loadhs, "arm_Loadhs", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Loadhs, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaFlt = new_ir_op(cur_opcode + iro_arm_fpaFlt, "arm_fpaFlt", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaFlt, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_SwitchJmp;
	ops.copy_attr = arm_copy_attr;
	op_arm_SwitchJmp = new_ir_op(cur_opcode + iro_arm_SwitchJmp, "arm_SwitchJmp", op_pin_state_pinned, L|X|Y|M, oparity_unary, 0, sizeof(arm_SwitchJmp_attr_t), &ops);
	set_op_tag(op_arm_SwitchJmp, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_SymConst;
	ops.copy_attr = arm_copy_attr;
	op_arm_SymConst = new_ir_op(cur_opcode + iro_arm_SymConst, "arm_SymConst", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(arm_SymConst_attr_t), &ops);
	set_op_tag(op_arm_SymConst, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm;
	ops.copy_attr = arm_copy_attr;
	op_arm_Load = new_ir_op(cur_opcode + iro_arm_Load, "arm_Load", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_Load, arm_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = arm_dump_node;
	ops.node_cmp_attr = cmp_attr_arm_fpaAdf_i;
	ops.copy_attr = arm_copy_attr;
	op_arm_fpaAdf_i = new_ir_op(cur_opcode + iro_arm_fpaAdf_i, "arm_fpaAdf_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(arm_attr_t), &ops);
	set_op_tag(op_arm_fpaAdf_i, arm_op_tag);

	arm_opcode_end = cur_opcode + iro_arm_last;
}
