/**
 * @file
 * @brief Function prototypes for the new opcode functions.
 * @note  DO NOT EDIT THIS FILE, your changes will be lost.
 *        Edit libfirm/ir/be/TEMPLATE/TEMPLATE_spec.pl instead.
 *        created by: libfirm/ir/be/scripts/generate_new_opcodes.pl libfirm/ir/be/TEMPLATE/TEMPLATE_spec.pl libfirm/ir/be/TEMPLATE
 * @date  Tue Jan 20 10:58:00 2009
 */
#ifndef FIRM_BE_TEMPLATE_GEN_TEMPLATE_NEW_NODES_H
#define FIRM_BE_TEMPLATE_GEN_TEMPLATE_NEW_NODES_H

typedef enum _TEMPLATE_opcodes {
	iro_TEMPLATE_fConst,
	iro_TEMPLATE_fMul,
	iro_TEMPLATE_Or,
	iro_TEMPLATE_Inc,
	iro_TEMPLATE_And_i,
	iro_TEMPLATE_fAdd,
	iro_TEMPLATE_Shl,
	iro_TEMPLATE_Add_i,
	iro_TEMPLATE_Add,
	iro_TEMPLATE_RotL,
	iro_TEMPLATE_fLoad,
	iro_TEMPLATE_fMin,
	iro_TEMPLATE_Or_i,
	iro_TEMPLATE_fDiv,
	iro_TEMPLATE_Sub,
	iro_TEMPLATE_Mul,
	iro_TEMPLATE_Sub_i,
	iro_TEMPLATE_Shr,
	iro_TEMPLATE_RotR,
	iro_TEMPLATE_RotL_i,
	iro_TEMPLATE_Mul_i,
	iro_TEMPLATE_Eor_i,
	iro_TEMPLATE_Dec,
	iro_TEMPLATE_Shl_i,
	iro_TEMPLATE_Not,
	iro_TEMPLATE_fMinus,
	iro_TEMPLATE_fMax,
	iro_TEMPLATE_Store,
	iro_TEMPLATE_And,
	iro_TEMPLATE_fStore,
	iro_TEMPLATE_fSub,
	iro_TEMPLATE_Minus,
	iro_TEMPLATE_Eor,
	iro_TEMPLATE_Const,
	iro_TEMPLATE_Load,
	iro_TEMPLATE_Shr_i,
	iro_TEMPLATE_last_generated,
	iro_TEMPLATE_last = iro_TEMPLATE_last_generated
} TEMPLATE_opcodes;

int is_TEMPLATE_irn(const ir_node *node);

int get_TEMPLATE_opcode_first(void);
int get_TEMPLATE_opcode_last(void);
int get_TEMPLATE_irn_opcode(const ir_node *node);
void TEMPLATE_create_opcodes(const arch_irn_ops_t *be_ops);
extern ir_op *op_TEMPLATE_fConst;
ir_op *get_op_TEMPLATE_fConst(void);
int is_TEMPLATE_fConst(const ir_node *n);
/**
 * represents a FP constant
 */
ir_node *new_bd_TEMPLATE_fConst(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_TEMPLATE_fMul;
ir_op *get_op_TEMPLATE_fMul(void);
int is_TEMPLATE_fMul(const ir_node *n);
/**
 * construct FP Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_TEMPLATE_fMul(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Or;
ir_op *get_op_TEMPLATE_Or(void);
int is_TEMPLATE_Or(const ir_node *n);
/**
 * construct Or: Or(a, b) = Or(b, a) = a OR b
 */
ir_node *new_bd_TEMPLATE_Or(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Inc;
ir_op *get_op_TEMPLATE_Inc(void);
int is_TEMPLATE_Inc(const ir_node *n);
/**
 * construct Increment: Inc(a) = a++
 */
ir_node *new_bd_TEMPLATE_Inc(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_And_i;
ir_op *get_op_TEMPLATE_And_i(void);
int is_TEMPLATE_And_i(const ir_node *n);
/**
 * construct And: And(a, const) = And(const, a) = a AND const
 */
ir_node *new_bd_TEMPLATE_And_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_fAdd;
ir_op *get_op_TEMPLATE_fAdd(void);
int is_TEMPLATE_fAdd(const ir_node *n);
/**
 * construct FP Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_TEMPLATE_fAdd(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Shl;
ir_op *get_op_TEMPLATE_Shl(void);
int is_TEMPLATE_Shl(const ir_node *n);
/**
 * construct Shl: Shl(a, b) = a << b
 */
ir_node *new_bd_TEMPLATE_Shl(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Add_i;
ir_op *get_op_TEMPLATE_Add_i(void);
int is_TEMPLATE_Add_i(const ir_node *n);
/**
 * construct Add: Add(a, const) = Add(const, a) = a + const
 */
ir_node *new_bd_TEMPLATE_Add_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_Add;
ir_op *get_op_TEMPLATE_Add(void);
int is_TEMPLATE_Add(const ir_node *n);
/**
 * construct Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_TEMPLATE_Add(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_RotL;
ir_op *get_op_TEMPLATE_RotL(void);
int is_TEMPLATE_RotL(const ir_node *n);
/**
 * construct RotL: RotL(a, b) = a ROTL b
 */
ir_node *new_bd_TEMPLATE_RotL(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_fLoad;
ir_op *get_op_TEMPLATE_fLoad(void);
int is_TEMPLATE_fLoad(const ir_node *n);
/**
 * construct FP Load: Load(ptr, mem) = LD ptr
 */
ir_node *new_bd_TEMPLATE_fLoad(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_fMin;
ir_op *get_op_TEMPLATE_fMin(void);
int is_TEMPLATE_fMin(const ir_node *n);
/**
 * construct FP Min: Min(a, b) = Min(b, a) = a < b ? a : b
 */
ir_node *new_bd_TEMPLATE_fMin(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Or_i;
ir_op *get_op_TEMPLATE_Or_i(void);
int is_TEMPLATE_Or_i(const ir_node *n);
/**
 * construct Or: Or(a, const) = Or(const, a) = a OR const
 */
ir_node *new_bd_TEMPLATE_Or_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_fDiv;
ir_op *get_op_TEMPLATE_fDiv(void);
int is_TEMPLATE_fDiv(const ir_node *n);
/**
 * construct FP Div: Div(a, b) = a / b
 */
ir_node *new_bd_TEMPLATE_fDiv(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Sub;
ir_op *get_op_TEMPLATE_Sub(void);
int is_TEMPLATE_Sub(const ir_node *n);
/**
 * construct Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_TEMPLATE_Sub(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Mul;
ir_op *get_op_TEMPLATE_Mul(void);
int is_TEMPLATE_Mul(const ir_node *n);
/**
 * construct Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_TEMPLATE_Mul(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Sub_i;
ir_op *get_op_TEMPLATE_Sub_i(void);
int is_TEMPLATE_Sub_i(const ir_node *n);
/**
 * construct Sub: Sub(a, const) = a - const
 */
ir_node *new_bd_TEMPLATE_Sub_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_Shr;
ir_op *get_op_TEMPLATE_Shr(void);
int is_TEMPLATE_Shr(const ir_node *n);
/**
 * construct Shr: Shr(a, b) = a >> b
 */
ir_node *new_bd_TEMPLATE_Shr(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_RotR;
ir_op *get_op_TEMPLATE_RotR(void);
int is_TEMPLATE_RotR(const ir_node *n);
/**
 * construct RotR: RotR(a, b) = a ROTR b
 */
ir_node *new_bd_TEMPLATE_RotR(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_RotL_i;
ir_op *get_op_TEMPLATE_RotL_i(void);
int is_TEMPLATE_RotL_i(const ir_node *n);
/**
 * construct RotL: RotL(a, const) = a ROTL const
 */
ir_node *new_bd_TEMPLATE_RotL_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_Mul_i;
ir_op *get_op_TEMPLATE_Mul_i(void);
int is_TEMPLATE_Mul_i(const ir_node *n);
/**
 * construct Mul: Mul(a, const) = Mul(const, a) = a * const
 */
ir_node *new_bd_TEMPLATE_Mul_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_Eor_i;
ir_op *get_op_TEMPLATE_Eor_i(void);
int is_TEMPLATE_Eor_i(const ir_node *n);
/**
 * construct Eor: Eor(a, const) = Eor(const, a) = a EOR const
 */
ir_node *new_bd_TEMPLATE_Eor_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_Dec;
ir_op *get_op_TEMPLATE_Dec(void);
int is_TEMPLATE_Dec(const ir_node *n);
/**
 * construct Decrement: Dec(a) = a--
 */
ir_node *new_bd_TEMPLATE_Dec(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_Shl_i;
ir_op *get_op_TEMPLATE_Shl_i(void);
int is_TEMPLATE_Shl_i(const ir_node *n);
/**
 * construct Shl: Shl(a, const) = a << const
 */
ir_node *new_bd_TEMPLATE_Shl_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_Not;
ir_op *get_op_TEMPLATE_Not(void);
int is_TEMPLATE_Not(const ir_node *n);
/**
 * construct Not: Not(a) = !a
 */
ir_node *new_bd_TEMPLATE_Not(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_fMinus;
ir_op *get_op_TEMPLATE_fMinus(void);
int is_TEMPLATE_fMinus(const ir_node *n);
/**
 * construct FP Minus: Minus(a) = -a
 */
ir_node *new_bd_TEMPLATE_fMinus(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_fMax;
ir_op *get_op_TEMPLATE_fMax(void);
int is_TEMPLATE_fMax(const ir_node *n);
/**
 * construct FP Max: Max(a, b) = Max(b, a) = a > b ? a : b
 */
ir_node *new_bd_TEMPLATE_fMax(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Store;
ir_op *get_op_TEMPLATE_Store(void);
int is_TEMPLATE_Store(const ir_node *n);
/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_TEMPLATE_Store(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *mode);

extern ir_op *op_TEMPLATE_And;
ir_op *get_op_TEMPLATE_And(void);
int is_TEMPLATE_And(const ir_node *n);
/**
 * construct And: And(a, b) = And(b, a) = a AND b
 */
ir_node *new_bd_TEMPLATE_And(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_fStore;
ir_op *get_op_TEMPLATE_fStore(void);
int is_TEMPLATE_fStore(const ir_node *n);
/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_TEMPLATE_fStore(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *mode);

extern ir_op *op_TEMPLATE_fSub;
ir_op *get_op_TEMPLATE_fSub(void);
int is_TEMPLATE_fSub(const ir_node *n);
/**
 * construct FP Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_TEMPLATE_fSub(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Minus;
ir_op *get_op_TEMPLATE_Minus(void);
int is_TEMPLATE_Minus(const ir_node *n);
/**
 * construct Minus: Minus(a) = -a
 */
ir_node *new_bd_TEMPLATE_Minus(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_TEMPLATE_Eor;
ir_op *get_op_TEMPLATE_Eor(void);
int is_TEMPLATE_Eor(const ir_node *n);
/**
 * construct Eor: Eor(a, b) = Eor(b, a) = a EOR b
 */
ir_node *new_bd_TEMPLATE_Eor(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Const;
ir_op *get_op_TEMPLATE_Const(void);
int is_TEMPLATE_Const(const ir_node *n);
/**
 * represents an integer constant
 */
ir_node *new_bd_TEMPLATE_Const(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_TEMPLATE_Load;
ir_op *get_op_TEMPLATE_Load(void);
int is_TEMPLATE_Load(const ir_node *n);
/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_TEMPLATE_Load(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_TEMPLATE_Shr_i;
ir_op *get_op_TEMPLATE_Shr_i(void);
int is_TEMPLATE_Shr_i(const ir_node *n);
/**
 * construct Shr: Shr(a, const) = a >> const
 */
ir_node *new_bd_TEMPLATE_Shr_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

#endif
